/*
 * Copyright © 2007 Red Hat, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Authors:
 *     Dave Airlie <airlied@redhat.com>
 *
 */
#ifndef DUMB_BO_H
#define DUMB_BO_H

#include <stdint.h>

struct dumb_bo {
    uint32_t handle;
    uint32_t size;
    void *ptr;
    uint32_t pitch;
};

struct dumb_bo *dumb_bo_create(int fd, const unsigned width,
                               const unsigned height, const unsigned bpp);
int dumb_bo_map(int fd, struct dumb_bo *bo);
int dumb_bo_get_fd(int fd, struct dumb_bo *bo, uint32_t flags);
int dumb_bo_get_name(int fd, struct dumb_bo *bo);
int dumb_bo_destroy(int fd, struct dumb_bo *bo);
struct dumb_bo *dumb_get_bo_from_fd(int fd, int handle, int pitch, int size);

#endif
