/*
 * Driver for OV5642 CMOS Image Sensor from OmniVision
 *
 * Copyright (C) 2008, Guennadi Liakhovetski <kernel@pengutronix.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#include "ov5642.h"

#define VCM_DRIVER_A3907   0
#define VCM_DRIVER_AD5820  1
#define VCM_DRIVER_DW9710  2
#define VCM_DRIVER         VCM_DRIVER_A3907

#if (VCM_DRIVER == VCM_DRIVER_A3907)
static struct reginfo sensor_af_firmware[] =
{
	{0x3000,0x20},
	{0x8000,0x02},
	{0x8001,0x00},
	{0x8002,0x06},
	{0x8003,0x02},
	{0x8004,0x0d},
	{0x8005,0xd1},
	{0x8006,0x78},
	{0x8007,0x7f},
	{0x8008,0xe4},
	{0x8009,0xf6},
	{0x800a,0xd8},
	{0x800b,0xfd},
	{0x800c,0x75},
	{0x800d,0x81},
	{0x800e,0x7e},
	{0x800f,0x02},
	{0x8010,0x15},
	{0x8011,0x5f},
	{0x8012,0x00},
	{0x8013,0x02},
	{0x8014,0x15},
	{0x8015,0xab},
	{0x8016,0xe0},
	{0x8017,0xf5},
	{0x8018,0x72},
	{0x8019,0xa3},
	{0x801a,0xe0},
	{0x801b,0xf5},
	{0x801c,0x73},
	{0x801d,0xae},
	{0x801e,0x6a},
	{0x801f,0xe4},
	{0x8020,0x85},
	{0x8021,0x6b},
	{0x8022,0x55},
	{0x8023,0x8e},
	{0x8024,0x54},
	{0x8025,0xf5},
	{0x8026,0x53},
	{0x8027,0xf5},
	{0x8028,0x52},
	{0x8029,0xab},
	{0x802a,0x55},
	{0x802b,0xaa},
	{0x802c,0x54},
	{0x802d,0xa9},
	{0x802e,0x53},
	{0x802f,0xa8},
	{0x8030,0x52},
	{0x8031,0xaf},
	{0x8032,0x2c},
	{0x8033,0xfc},
	{0x8034,0xfd},
	{0x8035,0xfe},
	{0x8036,0x12},
	{0x8037,0x08},
	{0x8038,0x9b},
	{0x8039,0x8f},
	{0x803a,0x55},
	{0x803b,0x8e},
	{0x803c,0x54},
	{0x803d,0x8d},
	{0x803e,0x53},
	{0x803f,0x8c},
	{0x8040,0x52},
	{0x8041,0xaf},
	{0x8042,0x55},
	{0x8043,0xae},
	{0x8044,0x54},
	{0x8045,0xad},
	{0x8046,0x53},
	{0x8047,0xac},
	{0x8048,0x52},
	{0x8049,0x8f},
	{0x804a,0x2b},
	{0x804b,0x8e},
	{0x804c,0x2a},
	{0x804d,0x8d},
	{0x804e,0x29},
	{0x804f,0x8c},
	{0x8050,0x28},
	{0x8051,0xae},
	{0x8052,0x6c},
	{0x8053,0xe4},
	{0x8054,0x85},
	{0x8055,0x6d},
	{0x8056,0x55},
	{0x8057,0x8e},
	{0x8058,0x54},
	{0x8059,0xf5},
	{0x805a,0x53},
	{0x805b,0xf5},
	{0x805c,0x52},
	{0x805d,0xab},
	{0x805e,0x55},
	{0x805f,0xaa},
	{0x8060,0x54},
	{0x8061,0xa9},
	{0x8062,0x53},
	{0x8063,0xa8},
	{0x8064,0x52},
	{0x8065,0xaf},
	{0x8066,0x2d},
	{0x8067,0xfc},
	{0x8068,0xfd},
	{0x8069,0xfe},
	{0x806a,0x12},
	{0x806b,0x08},
	{0x806c,0x9b},
	{0x806d,0x8f},
	{0x806e,0x55},
	{0x806f,0x8e},
	{0x8070,0x54},
	{0x8071,0x8d},
	{0x8072,0x53},
	{0x8073,0x8c},
	{0x8074,0x52},
	{0x8075,0xe5},
	{0x8076,0x2b},
	{0x8077,0x25},
	{0x8078,0x55},
	{0x8079,0xf5},
	{0x807a,0x2b},
	{0x807b,0xe5},
	{0x807c,0x2a},
	{0x807d,0x35},
	{0x807e,0x54},
	{0x807f,0xf5},
	{0x8080,0x2a},
	{0x8081,0xe5},
	{0x8082,0x29},
	{0x8083,0x35},
	{0x8084,0x53},
	{0x8085,0xf5},
	{0x8086,0x29},
	{0x8087,0xe5},
	{0x8088,0x28},
	{0x8089,0x35},
	{0x808a,0x52},
	{0x808b,0xf5},
	{0x808c,0x28},
	{0x808d,0xae},
	{0x808e,0x6e},
	{0x808f,0xe4},
	{0x8090,0x85},
	{0x8091,0x6f},
	{0x8092,0x55},
	{0x8093,0x8e},
	{0x8094,0x54},
	{0x8095,0xf5},
	{0x8096,0x53},
	{0x8097,0xf5},
	{0x8098,0x52},
	{0x8099,0xab},
	{0x809a,0x55},
	{0x809b,0xaa},
	{0x809c,0x54},
	{0x809d,0xa9},
	{0x809e,0x53},
	{0x809f,0xa8},
	{0x80a0,0x52},
	{0x80a1,0xaf},
	{0x80a2,0x2e},
	{0x80a3,0xfc},
	{0x80a4,0xfd},
	{0x80a5,0xfe},
	{0x80a6,0x12},
	{0x80a7,0x08},
	{0x80a8,0x9b},
	{0x80a9,0x8f},
	{0x80aa,0x55},
	{0x80ab,0x8e},
	{0x80ac,0x54},
	{0x80ad,0x8d},
	{0x80ae,0x53},
	{0x80af,0x8c},
	{0x80b0,0x52},
	{0x80b1,0xe5},
	{0x80b2,0x2b},
	{0x80b3,0x25},
	{0x80b4,0x55},
	{0x80b5,0xf5},
	{0x80b6,0x2b},
	{0x80b7,0xe5},
	{0x80b8,0x2a},
	{0x80b9,0x35},
	{0x80ba,0x54},
	{0x80bb,0xf5},
	{0x80bc,0x2a},
	{0x80bd,0xe5},
	{0x80be,0x29},
	{0x80bf,0x35},
	{0x80c0,0x53},
	{0x80c1,0xf5},
	{0x80c2,0x29},
	{0x80c3,0xe5},
	{0x80c4,0x28},
	{0x80c5,0x35},
	{0x80c6,0x52},
	{0x80c7,0xf5},
	{0x80c8,0x28},
	{0x80c9,0xae},
	{0x80ca,0x70},
	{0x80cb,0xe4},
	{0x80cc,0x85},
	{0x80cd,0x71},
	{0x80ce,0x55},
	{0x80cf,0x8e},
	{0x80d0,0x54},
	{0x80d1,0xf5},
	{0x80d2,0x53},
	{0x80d3,0xf5},
	{0x80d4,0x52},
	{0x80d5,0xab},
	{0x80d6,0x55},
	{0x80d7,0xaa},
	{0x80d8,0x54},
	{0x80d9,0xa9},
	{0x80da,0x53},
	{0x80db,0xa8},
	{0x80dc,0x52},
	{0x80dd,0xaf},
	{0x80de,0x2f},
	{0x80df,0xfc},
	{0x80e0,0xfd},
	{0x80e1,0xfe},
	{0x80e2,0x12},
	{0x80e3,0x08},
	{0x80e4,0x9b},
	{0x80e5,0x8f},
	{0x80e6,0x55},
	{0x80e7,0x8e},
	{0x80e8,0x54},
	{0x80e9,0x8d},
	{0x80ea,0x53},
	{0x80eb,0x8c},
	{0x80ec,0x52},
	{0x80ed,0xe5},
	{0x80ee,0x2b},
	{0x80ef,0x25},
	{0x80f0,0x55},
	{0x80f1,0xf5},
	{0x80f2,0x2b},
	{0x80f3,0xe5},
	{0x80f4,0x2a},
	{0x80f5,0x35},
	{0x80f6,0x54},
	{0x80f7,0xf5},
	{0x80f8,0x2a},
	{0x80f9,0xe5},
	{0x80fa,0x29},
	{0x80fb,0x35},
	{0x80fc,0x53},
	{0x80fd,0xf5},
	{0x80fe,0x29},
	{0x80ff,0xe5},
	{0x8100,0x28},
	{0x8101,0x35},
	{0x8102,0x52},
	{0x8103,0xf5},
	{0x8104,0x28},
	{0x8105,0xae},
	{0x8106,0x72},
	{0x8107,0xe4},
	{0x8108,0x85},
	{0x8109,0x73},
	{0x810a,0x55},
	{0x810b,0x8e},
	{0x810c,0x54},
	{0x810d,0xf5},
	{0x810e,0x53},
	{0x810f,0xf5},
	{0x8110,0x52},
	{0x8111,0xab},
	{0x8112,0x55},
	{0x8113,0xaa},
	{0x8114,0x54},
	{0x8115,0xa9},
	{0x8116,0x53},
	{0x8117,0xa8},
	{0x8118,0x52},
	{0x8119,0xaf},
	{0x811a,0x30},
	{0x811b,0xfc},
	{0x811c,0xfd},
	{0x811d,0xfe},
	{0x811e,0x12},
	{0x811f,0x08},
	{0x8120,0x9b},
	{0x8121,0x8f},
	{0x8122,0x55},
	{0x8123,0x8e},
	{0x8124,0x54},
	{0x8125,0x8d},
	{0x8126,0x53},
	{0x8127,0x8c},
	{0x8128,0x52},
	{0x8129,0xe5},
	{0x812a,0x2b},
	{0x812b,0x25},
	{0x812c,0x55},
	{0x812d,0xf5},
	{0x812e,0x2b},
	{0x812f,0xe5},
	{0x8130,0x2a},
	{0x8131,0x35},
	{0x8132,0x54},
	{0x8133,0xf5},
	{0x8134,0x2a},
	{0x8135,0xe5},
	{0x8136,0x29},
	{0x8137,0x35},
	{0x8138,0x53},
	{0x8139,0xf5},
	{0x813a,0x29},
	{0x813b,0xe5},
	{0x813c,0x28},
	{0x813d,0x35},
	{0x813e,0x52},
	{0x813f,0xf5},
	{0x8140,0x28},
	{0x8141,0x22},
	{0x8142,0xab},
	{0x8143,0x0d},
	{0x8144,0xaa},
	{0x8145,0x0c},
	{0x8146,0xa9},
	{0x8147,0x0b},
	{0x8148,0xa8},
	{0x8149,0x0a},
	{0x814a,0xfc},
	{0x814b,0xfd},
	{0x814c,0xfe},
	{0x814d,0x12},
	{0x814e,0x08},
	{0x814f,0x9b},
	{0x8150,0x8f},
	{0x8151,0x0d},
	{0x8152,0x8e},
	{0x8153,0x0c},
	{0x8154,0x8d},
	{0x8155,0x0b},
	{0x8156,0x8c},
	{0x8157,0x0a},
	{0x8158,0x7b},
	{0x8159,0x40},
	{0x815a,0xe4},
	{0x815b,0xfa},
	{0x815c,0xf9},
	{0x815d,0xf8},
	{0x815e,0x12},
	{0x815f,0x09},
	{0x8160,0x26},
	{0x8161,0x8f},
	{0x8162,0x0d},
	{0x8163,0x8e},
	{0x8164,0x0c},
	{0x8165,0x8d},
	{0x8166,0x0b},
	{0x8167,0x8c},
	{0x8168,0x0a},
	{0x8169,0x22},
	{0x816a,0xd2},
	{0x816b,0x29},
	{0x816c,0x90},
	{0x816d,0x30},
	{0x816e,0x1b},
	{0x816f,0xe5},
	{0x8170,0x25},
	{0x8171,0xf0},
	{0x8172,0x22},
	{0x8173,0x85},
	{0x8174,0x49},
	{0x8175,0x82},
	{0x8176,0x85},
	{0x8177,0x48},
	{0x8178,0x83},
	{0x8179,0xe5},
	{0x817a,0x7c},
	{0x817b,0x75},
	{0x817c,0xf0},
	{0x817d,0x02},
	{0x817e,0x12},
	{0x817f,0x09},
	{0x8180,0xee},
	{0x8181,0xe4},
	{0x8182,0x93},
	{0x8183,0xfe},
	{0x8184,0x74},
	{0x8185,0x01},
	{0x8186,0x93},
	{0x8187,0xff},
	{0x8188,0x85},
	{0x8189,0x49},
	{0x818a,0x82},
	{0x818b,0x85},
	{0x818c,0x48},
	{0x818d,0x83},
	{0x818e,0x22},
	{0x818f,0xfe},
	{0x8190,0xe4},
	{0x8191,0xfc},
	{0x8192,0xfd},
	{0x8193,0xe5},
	{0x8194,0x3f},
	{0x8195,0x2f},
	{0x8196,0xf5},
	{0x8197,0x3f},
	{0x8198,0xe5},
	{0x8199,0x3e},
	{0x819a,0x3e},
	{0x819b,0xf5},
	{0x819c,0x3e},
	{0x819d,0xed},
	{0x819e,0x35},
	{0x819f,0x3d},
	{0x81a0,0xf5},
	{0x81a1,0x3d},
	{0x81a2,0xec},
	{0x81a3,0x35},
	{0x81a4,0x3c},
	{0x81a5,0xf5},
	{0x81a6,0x3c},
	{0x81a7,0xaf},
	{0x81a8,0x3f},
	{0x81a9,0xae},
	{0x81aa,0x3e},
	{0x81ab,0xfc},
	{0x81ac,0xad},
	{0x81ad,0x3d},
	{0x81ae,0x78},
	{0x81af,0x08},
	{0x81b0,0x12},
	{0x81b1,0x09},
	{0x81b2,0xcb},
	{0x81b3,0x8f},
	{0x81b4,0x3f},
	{0x81b5,0x8e},
	{0x81b6,0x3e},
	{0x81b7,0x8d},
	{0x81b8,0x3d},
	{0x81b9,0x8c},
	{0x81ba,0x3c},
	{0x81bb,0x22},
	{0x81bc,0xaf},
	{0x81bd,0x2b},
	{0x81be,0xae},
	{0x81bf,0x2a},
	{0x81c0,0xad},
	{0x81c1,0x29},
	{0x81c2,0xac},
	{0x81c3,0x28},
	{0x81c4,0x78},
	{0x81c5,0x06},
	{0x81c6,0x12},
	{0x81c7,0x09},
	{0x81c8,0xb8},
	{0x81c9,0x8f},
	{0x81ca,0x2b},
	{0x81cb,0x8e},
	{0x81cc,0x2a},
	{0x81cd,0x8d},
	{0x81ce,0x29},
	{0x81cf,0x8c},
	{0x81d0,0x28},
	{0x81d1,0xd3},
	{0x81d2,0xe5},
	{0x81d3,0x29},
	{0x81d4,0x94},
	{0x81d5,0x00},
	{0x81d6,0xe5},
	{0x81d7,0x28},
	{0x81d8,0x94},
	{0x81d9,0x00},
	{0x81da,0x22},
	{0x81db,0xe5},
	{0x81dc,0x0b},
	{0x81dd,0x24},
	{0x81de,0x01},
	{0x81df,0xff},
	{0x81e0,0xe4},
	{0x81e1,0x33},
	{0x81e2,0xfe},
	{0x81e3,0x22},
	{0x81e4,0x85},
	{0x81e5,0x0d},
	{0x81e6,0x64},
	{0x81e7,0x85},
	{0x81e8,0x0e},
	{0x81e9,0x65},
	{0x81ea,0xe5},
	{0x81eb,0x0e},
	{0x81ec,0xc4},
	{0x81ed,0xf8},
	{0x81ee,0x54},
	{0x81ef,0x0f},
	{0x81f0,0xc8},
	{0x81f1,0x68},
	{0x81f2,0xf5},
	{0x81f3,0x0e},
	{0x81f4,0xe5},
	{0x81f5,0x0d},
	{0x81f6,0xc4},
	{0x81f7,0x54},
	{0x81f8,0xf0},
	{0x81f9,0x48},
	{0x81fa,0xf5},
	{0x81fb,0x0d},
	{0x81fc,0x22},
	{0x81fd,0x12},
	{0x81fe,0x08},
	{0x81ff,0x9b},
	{0x8200,0x8f},
	{0x8201,0x69},
	{0x8202,0x8e},
	{0x8203,0x68},
	{0x8204,0x8d},
	{0x8205,0x67},
	{0x8206,0x8c},
	{0x8207,0x66},
	{0x8208,0xaf},
	{0x8209,0x69},
	{0x820a,0xae},
	{0x820b,0x68},
	{0x820c,0xad},
	{0x820d,0x67},
	{0x820e,0xac},
	{0x820f,0x66},
	{0x8210,0x22},
	{0x8211,0xe4},
	{0x8212,0x93},
	{0x8213,0xfc},
	{0x8214,0x74},
	{0x8215,0x01},
	{0x8216,0x93},
	{0x8217,0xfd},
	{0x8218,0xc3},
	{0x8219,0xef},
	{0x821a,0x9d},
	{0x821b,0xff},
	{0x821c,0xee},
	{0x821d,0x9c},
	{0x821e,0x22},
	{0x821f,0xe0},
	{0x8220,0x44},
	{0x8221,0x01},
	{0x8222,0xf0},
	{0x8223,0xe0},
	{0x8224,0x44},
	{0x8225,0x02},
	{0x8226,0xf0},
	{0x8227,0xe0},
	{0x8228,0x44},
	{0x8229,0x04},
	{0x822a,0xf0},
	{0x822b,0x22},
	{0x822c,0xd2},
	{0x822d,0x09},
	{0x822e,0x90},
	{0x822f,0x30},
	{0x8230,0x18},
	{0x8231,0xe5},
	{0x8232,0x21},
	{0x8233,0xf0},
	{0x8234,0x22},
	{0x8235,0xe4},
	{0x8236,0x85},
	{0x8237,0x11},
	{0x8238,0x0d},
	{0x8239,0x85},
	{0x823a,0x10},
	{0x823b,0x0c},
	{0x823c,0xf5},
	{0x823d,0x0b},
	{0x823e,0xf5},
	{0x823f,0x0a},
	{0x8240,0xab},
	{0x8241,0x0d},
	{0x8242,0xaa},
	{0x8243,0x0c},
	{0x8244,0xa9},
	{0x8245,0x0b},
	{0x8246,0xa8},
	{0x8247,0x0a},
	{0x8248,0x22},
	{0x8249,0x90},
	{0x824a,0x30},
	{0x824b,0x42},
	{0x824c,0xe0},
	{0x824d,0xf5},
	{0x824e,0x22},
	{0x824f,0x75},
	{0x8250,0x51},
	{0x8251,0x0a},
	{0x8252,0x22},
	{0x8253,0xf5},
	{0x8254,0x82},
	{0x8255,0xe4},
	{0x8256,0x3a},
	{0x8257,0xf5},
	{0x8258,0x83},
	{0x8259,0x02},
	{0x825a,0x09},
	{0x825b,0xde},
	{0x825c,0x8f},
	{0x825d,0x0a},
	{0x825e,0x74},
	{0x825f,0x4a},
	{0x8260,0x2f},
	{0x8261,0xf8},
	{0x8262,0xe6},
	{0x8263,0x22},
	{0x8264,0xc2},
	{0x8265,0x07},
	{0x8266,0xc2},
	{0x8267,0x06},
	{0x8268,0xc2},
	{0x8269,0x02},
	{0x826a,0xc2},
	{0x826b,0x01},
	{0x826c,0xc2},
	{0x826d,0x00},
	{0x826e,0xc2},
	{0x826f,0x03},
	{0x8270,0xd2},
	{0x8271,0x04},
	{0x8272,0x22},
	{0x8273,0xe5},
	{0x8274,0x16},
	{0x8275,0x25},
	{0x8276,0xe0},
	{0x8277,0x25},
	{0x8278,0xe0},
	{0x8279,0x22},
	{0x827a,0x12},
	{0x827b,0x09},
	{0x827c,0x26},
	{0x827d,0x8f},
	{0x827e,0x69},
	{0x827f,0x8e},
	{0x8280,0x68},
	{0x8281,0x8d},
	{0x8282,0x67},
	{0x8283,0x8c},
	{0x8284,0x66},
	{0x8285,0x22},
	{0x8286,0xe4},
	{0x8287,0x85},
	{0x8288,0x0f},
	{0x8289,0x0d},
	{0x828a,0x85},
	{0x828b,0x0e},
	{0x828c,0x0c},
	{0x828d,0xf5},
	{0x828e,0x0b},
	{0x828f,0xf5},
	{0x8290,0x0a},
	{0x8291,0x22},
	{0x8292,0x90},
	{0x8293,0x12},
	{0x8294,0x67},
	{0x8295,0xe4},
	{0x8296,0x93},
	{0x8297,0xff},
	{0x8298,0x90},
	{0x8299,0x30},
	{0x829a,0x0a},
	{0x829b,0xe0},
	{0x829c,0x22},
	{0x829d,0xc2},
	{0x829e,0x02},
	{0x829f,0xc2},
	{0x82a0,0x01},
	{0x82a1,0xd2},
	{0x82a2,0x00},
	{0x82a3,0xc2},
	{0x82a4,0x03},
	{0x82a5,0xc2},
	{0x82a6,0x04},
	{0x82a7,0x22},
	{0x82a8,0xd2},
	{0x82a9,0x02},
	{0x82aa,0xd2},
	{0x82ab,0x01},
	{0x82ac,0xc2},
	{0x82ad,0x00},
	{0x82ae,0x22},
	{0x82af,0x74},
	{0x82b0,0x4a},
	{0x82b1,0x25},
	{0x82b2,0x0a},
	{0x82b3,0xf8},
	{0x82b4,0xe6},
	{0x82b5,0x22},
	{0x82b6,0xd3},
	{0x82b7,0xe5},
	{0x82b8,0x0b},
	{0x82b9,0x94},
	{0x82ba,0xff},
	{0x82bb,0xe5},
	{0x82bc,0x0a},
	{0x82bd,0x94},
	{0x82be,0x00},
	{0x82bf,0x22},
	{0x82c0,0x30},
	{0x82c1,0x18},
	{0x82c2,0x4d},
	{0x82c3,0x20},
	{0x82c4,0x19},
	{0x82c5,0x4a},
	{0x82c6,0x75},
	{0x82c7,0x0a},
	{0x82c8,0x02},
	{0x82c9,0x12},
	{0x82ca,0x02},
	{0x82cb,0xaf},
	{0x82cc,0xff},
	{0x82cd,0xe5},
	{0x82ce,0x4a},
	{0x82cf,0xd3},
	{0x82d0,0x9f},
	{0x82d1,0x40},
	{0x82d2,0x04},
	{0x82d3,0x7f},
	{0x82d4,0x00},
	{0x82d5,0x80},
	{0x82d6,0x02},
	{0x82d7,0xaf},
	{0x82d8,0x0a},
	{0x82d9,0x12},
	{0x82da,0x02},
	{0x82db,0x5c},
	{0x82dc,0xff},
	{0x82dd,0xe5},
	{0x82de,0x4b},
	{0x82df,0xd3},
	{0x82e0,0x9f},
	{0x82e1,0x40},
	{0x82e2,0x04},
	{0x82e3,0x7f},
	{0x82e4,0x01},
	{0x82e5,0x80},
	{0x82e6,0x02},
	{0x82e7,0xaf},
	{0x82e8,0x0a},
	{0x82e9,0x12},
	{0x82ea,0x02},
	{0x82eb,0x5c},
	{0x82ec,0xff},
	{0x82ed,0xe5},
	{0x82ee,0x4d},
	{0x82ef,0xd3},
	{0x82f0,0x9f},
	{0x82f1,0x40},
	{0x82f2,0x04},
	{0x82f3,0x7f},
	{0x82f4,0x03},
	{0x82f5,0x80},
	{0x82f6,0x02},
	{0x82f7,0xaf},
	{0x82f8,0x0a},
	{0x82f9,0x12},
	{0x82fa,0x02},
	{0x82fb,0x5c},
	{0x82fc,0xff},
	{0x82fd,0xe5},
	{0x82fe,0x4e},
	{0x82ff,0xd3},
	{0x8300,0x9f},
	{0x8301,0x40},
	{0x8302,0x04},
	{0x8303,0x7f},
	{0x8304,0x04},
	{0x8305,0x80},
	{0x8306,0x02},
	{0x8307,0xaf},
	{0x8308,0x0a},
	{0x8309,0x12},
	{0x830a,0x02},
	{0x830b,0x5c},
	{0x830c,0xf5},
	{0x830d,0x0b},
	{0x830e,0x80},
	{0x830f,0x06},
	{0x8310,0x85},
	{0x8311,0x79},
	{0x8312,0x0a},
	{0x8313,0x85},
	{0x8314,0x4f},
	{0x8315,0x0b},
	{0x8316,0x7f},
	{0x8317,0x01},
	{0x8318,0xe4},
	{0x8319,0xfe},
	{0x831a,0x12},
	{0x831b,0x02},
	{0x831c,0xaf},
	{0x831d,0xfd},
	{0x831e,0xe5},
	{0x831f,0x0b},
	{0x8320,0xc3},
	{0x8321,0x9d},
	{0x8322,0x50},
	{0x8323,0x04},
	{0x8324,0x7d},
	{0x8325,0x01},
	{0x8326,0x80},
	{0x8327,0x02},
	{0x8328,0x7d},
	{0x8329,0xff},
	{0x832a,0xac},
	{0x832b,0x0b},
	{0x832c,0xe5},
	{0x832d,0x4e},
	{0x832e,0xb5},
	{0x832f,0x0b},
	{0x8330,0x03},
	{0x8331,0xd3},
	{0x8332,0x80},
	{0x8333,0x01},
	{0x8334,0xc3},
	{0x8335,0x92},
	{0x8336,0x1f},
	{0x8337,0xe5},
	{0x8338,0x4d},
	{0x8339,0xb5},
	{0x833a,0x0b},
	{0x833b,0x03},
	{0x833c,0xd3},
	{0x833d,0x80},
	{0x833e,0x01},
	{0x833f,0xc3},
	{0x8340,0x92},
	{0x8341,0x1e},
	{0x8342,0xe5},
	{0x8343,0x4c},
	{0x8344,0xb5},
	{0x8345,0x0b},
	{0x8346,0x03},
	{0x8347,0xd3},
	{0x8348,0x80},
	{0x8349,0x01},
	{0x834a,0xc3},
	{0x834b,0x92},
	{0x834c,0x1d},
	{0x834d,0xe5},
	{0x834e,0x4b},
	{0x834f,0xb5},
	{0x8350,0x0b},
	{0x8351,0x03},
	{0x8352,0xd3},
	{0x8353,0x80},
	{0x8354,0x01},
	{0x8355,0xc3},
	{0x8356,0x92},
	{0x8357,0x1c},
	{0x8358,0xe5},
	{0x8359,0x4a},
	{0x835a,0xb5},
	{0x835b,0x0b},
	{0x835c,0x03},
	{0x835d,0xd3},
	{0x835e,0x80},
	{0x835f,0x01},
	{0x8360,0xc3},
	{0x8361,0x92},
	{0x8362,0x1b},
	{0x8363,0xe5},
	{0x8364,0x30},
	{0x8365,0xd3},
	{0x8366,0x94},
	{0x8367,0x00},
	{0x8368,0x40},
	{0x8369,0x04},
	{0x836a,0xa2},
	{0x836b,0x1f},
	{0x836c,0x80},
	{0x836d,0x01},
	{0x836e,0xc3},
	{0x836f,0x92},
	{0x8370,0x1f},
	{0x8371,0xe5},
	{0x8372,0x2f},
	{0x8373,0xd3},
	{0x8374,0x94},
	{0x8375,0x00},
	{0x8376,0x40},
	{0x8377,0x04},
	{0x8378,0xa2},
	{0x8379,0x1e},
	{0x837a,0x80},
	{0x837b,0x01},
	{0x837c,0xc3},
	{0x837d,0x92},
	{0x837e,0x1e},
	{0x837f,0xe5},
	{0x8380,0x2e},
	{0x8381,0xd3},
	{0x8382,0x94},
	{0x8383,0x00},
	{0x8384,0x40},
	{0x8385,0x04},
	{0x8386,0xa2},
	{0x8387,0x1d},
	{0x8388,0x80},
	{0x8389,0x01},
	{0x838a,0xc3},
	{0x838b,0x92},
	{0x838c,0x1d},
	{0x838d,0xe5},
	{0x838e,0x2d},
	{0x838f,0xd3},
	{0x8390,0x94},
	{0x8391,0x00},
	{0x8392,0x40},
	{0x8393,0x04},
	{0x8394,0xa2},
	{0x8395,0x1c},
	{0x8396,0x80},
	{0x8397,0x01},
	{0x8398,0xc3},
	{0x8399,0x92},
	{0x839a,0x1c},
	{0x839b,0xe5},
	{0x839c,0x2c},
	{0x839d,0xd3},
	{0x839e,0x94},
	{0x839f,0x00},
	{0x83a0,0x40},
	{0x83a1,0x04},
	{0x83a2,0xa2},
	{0x83a3,0x1b},
	{0x83a4,0x80},
	{0x83a5,0x01},
	{0x83a6,0xc3},
	{0x83a7,0x92},
	{0x83a8,0x1b},
	{0x83a9,0xe5},
	{0x83aa,0x23},
	{0x83ab,0x54},
	{0x83ac,0xf8},
	{0x83ad,0x70},
	{0x83ae,0x5b},
	{0x83af,0xbf},
	{0x83b0,0x01},
	{0x83b1,0x08},
	{0x83b2,0xed},
	{0x83b3,0xf4},
	{0x83b4,0x04},
	{0x83b5,0xfd},
	{0x83b6,0x7f},
	{0x83b7,0x02},
	{0x83b8,0x80},
	{0x83b9,0x06},
	{0x83ba,0xbf},
	{0x83bb,0x02},
	{0x83bc,0x02},
	{0x83bd,0x7f},
	{0x83be,0x01},
	{0x83bf,0x0e},
	{0x83c0,0xd3},
	{0x83c1,0xed},
	{0x83c2,0x64},
	{0x83c3,0x80},
	{0x83c4,0x94},
	{0x83c5,0x80},
	{0x83c6,0x40},
	{0x83c7,0x18},
	{0x83c8,0xec},
	{0x83c9,0x2e},
	{0x83ca,0xf5},
	{0x83cb,0x0b},
	{0x83cc,0xd3},
	{0x83cd,0x95},
	{0x83ce,0x7c},
	{0x83cf,0x40},
	{0x83d0,0x2c},
	{0x83d1,0x7d},
	{0x83d2,0xff},
	{0x83d3,0xef},
	{0x83d4,0x60},
	{0x83d5,0x04},
	{0x83d6,0x7b},
	{0x83d7,0x00},
	{0x83d8,0x80},
	{0x83d9,0x02},
	{0x83da,0x7b},
	{0x83db,0x03},
	{0x83dc,0xaf},
	{0x83dd,0x03},
	{0x83de,0x80},
	{0x83df,0x18},
	{0x83e0,0xec},
	{0x83e1,0xc3},
	{0x83e2,0x9e},
	{0x83e3,0x50},
	{0x83e4,0x13},
	{0x83e5,0x7d},
	{0x83e6,0x01},
	{0x83e7,0xef},
	{0x83e8,0x60},
	{0x83e9,0x04},
	{0x83ea,0x7b},
	{0x83eb,0x00},
	{0x83ec,0x80},
	{0x83ed,0x02},
	{0x83ee,0x7b},
	{0x83ef,0x03},
	{0x83f0,0xaf},
	{0x83f1,0x03},
	{0x83f2,0xec},
	{0x83f3,0x2e},
	{0x83f4,0xf5},
	{0x83f5,0x0b},
	{0x83f6,0x80},
	{0x83f7,0x05},
	{0x83f8,0xc3},
	{0x83f9,0xec},
	{0x83fa,0x9e},
	{0x83fb,0xf5},
	{0x83fc,0x0b},
	{0x83fd,0xef},
	{0x83fe,0x64},
	{0x83ff,0x03},
	{0x8400,0x60},
	{0x8401,0x03},
	{0x8402,0x02},
	{0x8403,0x03},
	{0x8404,0x2c},
	{0x8405,0x12},
	{0x8406,0x02},
	{0x8407,0xaf},
	{0x8408,0xf5},
	{0x8409,0x0b},
	{0x840a,0x12},
	{0x840b,0x01},
	{0x840c,0xdb},
	{0x840d,0xe5},
	{0x840e,0x4e},
	{0x840f,0xb5},
	{0x8410,0x07},
	{0x8411,0x07},
	{0x8412,0xe4},
	{0x8413,0xb5},
	{0x8414,0x06},
	{0x8415,0x03},
	{0x8416,0xd3},
	{0x8417,0x80},
	{0x8418,0x02},
	{0x8419,0xa2},
	{0x841a,0x1f},
	{0x841b,0x92},
	{0x841c,0x1f},
	{0x841d,0xe5},
	{0x841e,0x4d},
	{0x841f,0xb5},
	{0x8420,0x07},
	{0x8421,0x07},
	{0x8422,0xe4},
	{0x8423,0xb5},
	{0x8424,0x06},
	{0x8425,0x03},
	{0x8426,0xd3},
	{0x8427,0x80},
	{0x8428,0x02},
	{0x8429,0xa2},
	{0x842a,0x1e},
	{0x842b,0x92},
	{0x842c,0x1e},
	{0x842d,0x12},
	{0x842e,0x01},
	{0x842f,0xdb},
	{0x8430,0xe5},
	{0x8431,0x4c},
	{0x8432,0xb5},
	{0x8433,0x07},
	{0x8434,0x07},
	{0x8435,0xe4},
	{0x8436,0xb5},
	{0x8437,0x06},
	{0x8438,0x03},
	{0x8439,0xd3},
	{0x843a,0x80},
	{0x843b,0x02},
	{0x843c,0xa2},
	{0x843d,0x1d},
	{0x843e,0x92},
	{0x843f,0x1d},
	{0x8440,0xe5},
	{0x8441,0x4b},
	{0x8442,0xb5},
	{0x8443,0x07},
	{0x8444,0x07},
	{0x8445,0xe4},
	{0x8446,0xb5},
	{0x8447,0x06},
	{0x8448,0x03},
	{0x8449,0xd3},
	{0x844a,0x80},
	{0x844b,0x02},
	{0x844c,0xa2},
	{0x844d,0x1c},
	{0x844e,0x92},
	{0x844f,0x1c},
	{0x8450,0x12},
	{0x8451,0x01},
	{0x8452,0xdb},
	{0x8453,0xe5},
	{0x8454,0x4a},
	{0x8455,0xb5},
	{0x8456,0x07},
	{0x8457,0x07},
	{0x8458,0xe4},
	{0x8459,0xb5},
	{0x845a,0x06},
	{0x845b,0x03},
	{0x845c,0xd3},
	{0x845d,0x80},
	{0x845e,0x02},
	{0x845f,0xa2},
	{0x8460,0x1b},
	{0x8461,0x92},
	{0x8462,0x1b},
	{0x8463,0xe5},
	{0x8464,0x4e},
	{0x8465,0x12},
	{0x8466,0x01},
	{0x8467,0xdd},
	{0x8468,0xad},
	{0x8469,0x0b},
	{0x846a,0x7c},
	{0x846b,0x00},
	{0x846c,0xef},
	{0x846d,0xb5},
	{0x846e,0x05},
	{0x846f,0x07},
	{0x8470,0xec},
	{0x8471,0xb5},
	{0x8472,0x06},
	{0x8473,0x03},
	{0x8474,0xd3},
	{0x8475,0x80},
	{0x8476,0x02},
	{0x8477,0xa2},
	{0x8478,0x1f},
	{0x8479,0x92},
	{0x847a,0x1f},
	{0x847b,0xe5},
	{0x847c,0x4d},
	{0x847d,0x12},
	{0x847e,0x01},
	{0x847f,0xdd},
	{0x8480,0xef},
	{0x8481,0xb5},
	{0x8482,0x05},
	{0x8483,0x07},
	{0x8484,0xee},
	{0x8485,0xb5},
	{0x8486,0x04},
	{0x8487,0x03},
	{0x8488,0xd3},
	{0x8489,0x80},
	{0x848a,0x02},
	{0x848b,0xa2},
	{0x848c,0x1e},
	{0x848d,0x92},
	{0x848e,0x1e},
	{0x848f,0xe5},
	{0x8490,0x4c},
	{0x8491,0x12},
	{0x8492,0x01},
	{0x8493,0xdd},
	{0x8494,0xad},
	{0x8495,0x0b},
	{0x8496,0x7c},
	{0x8497,0x00},
	{0x8498,0xef},
	{0x8499,0xb5},
	{0x849a,0x05},
	{0x849b,0x07},
	{0x849c,0xec},
	{0x849d,0xb5},
	{0x849e,0x06},
	{0x849f,0x03},
	{0x84a0,0xd3},
	{0x84a1,0x80},
	{0x84a2,0x02},
	{0x84a3,0xa2},
	{0x84a4,0x1d},
	{0x84a5,0x92},
	{0x84a6,0x1d},
	{0x84a7,0xe5},
	{0x84a8,0x4b},
	{0x84a9,0x12},
	{0x84aa,0x01},
	{0x84ab,0xdd},
	{0x84ac,0xef},
	{0x84ad,0xb5},
	{0x84ae,0x05},
	{0x84af,0x07},
	{0x84b0,0xee},
	{0x84b1,0xb5},
	{0x84b2,0x04},
	{0x84b3,0x03},
	{0x84b4,0xd3},
	{0x84b5,0x80},
	{0x84b6,0x02},
	{0x84b7,0xa2},
	{0x84b8,0x1c},
	{0x84b9,0x92},
	{0x84ba,0x1c},
	{0x84bb,0xe5},
	{0x84bc,0x4a},
	{0x84bd,0x12},
	{0x84be,0x01},
	{0x84bf,0xdd},
	{0x84c0,0x7c},
	{0x84c1,0x00},
	{0x84c2,0xef},
	{0x84c3,0xb5},
	{0x84c4,0x0b},
	{0x84c5,0x07},
	{0x84c6,0xec},
	{0x84c7,0xb5},
	{0x84c8,0x06},
	{0x84c9,0x03},
	{0x84ca,0xd3},
	{0x84cb,0x80},
	{0x84cc,0x02},
	{0x84cd,0xa2},
	{0x84ce,0x1b},
	{0x84cf,0x92},
	{0x84d0,0x1b},
	{0x84d1,0xe5},
	{0x84d2,0x30},
	{0x84d3,0xd3},
	{0x84d4,0x94},
	{0x84d5,0x00},
	{0x84d6,0x40},
	{0x84d7,0x04},
	{0x84d8,0xa2},
	{0x84d9,0x1f},
	{0x84da,0x80},
	{0x84db,0x01},
	{0x84dc,0xc3},
	{0x84dd,0x92},
	{0x84de,0x1f},
	{0x84df,0xe5},
	{0x84e0,0x2f},
	{0x84e1,0xd3},
	{0x84e2,0x94},
	{0x84e3,0x00},
	{0x84e4,0x40},
	{0x84e5,0x04},
	{0x84e6,0xa2},
	{0x84e7,0x1e},
	{0x84e8,0x80},
	{0x84e9,0x01},
	{0x84ea,0xc3},
	{0x84eb,0x92},
	{0x84ec,0x1e},
	{0x84ed,0xe5},
	{0x84ee,0x2e},
	{0x84ef,0xd3},
	{0x84f0,0x94},
	{0x84f1,0x00},
	{0x84f2,0x40},
	{0x84f3,0x04},
	{0x84f4,0xa2},
	{0x84f5,0x1d},
	{0x84f6,0x80},
	{0x84f7,0x01},
	{0x84f8,0xc3},
	{0x84f9,0x92},
	{0x84fa,0x1d},
	{0x84fb,0xe5},
	{0x84fc,0x2d},
	{0x84fd,0xd3},
	{0x84fe,0x94},
	{0x84ff,0x00},
	{0x8500,0x40},
	{0x8501,0x04},
	{0x8502,0xa2},
	{0x8503,0x1c},
	{0x8504,0x80},
	{0x8505,0x01},
	{0x8506,0xc3},
	{0x8507,0x92},
	{0x8508,0x1c},
	{0x8509,0xe5},
	{0x850a,0x2c},
	{0x850b,0xd3},
	{0x850c,0x94},
	{0x850d,0x00},
	{0x850e,0x40},
	{0x850f,0x04},
	{0x8510,0xa2},
	{0x8511,0x1b},
	{0x8512,0x80},
	{0x8513,0x01},
	{0x8514,0xc3},
	{0x8515,0x92},
	{0x8516,0x1b},
	{0x8517,0x85},
	{0x8518,0x0a},
	{0x8519,0x79},
	{0x851a,0xe5},
	{0x851b,0x7d},
	{0x851c,0xb5},
	{0x851d,0x0b},
	{0x851e,0x03},
	{0x851f,0x02},
	{0x8520,0x16},
	{0x8521,0xf7},
	{0x8522,0x85},
	{0x8523,0x0b},
	{0x8524,0x0c},
	{0x8525,0x12},
	{0x8526,0x0e},
	{0x8527,0xf9},
	{0x8528,0xd2},
	{0x8529,0x02},
	{0x852a,0xc2},
	{0x852b,0x01},
	{0x852c,0xd2},
	{0x852d,0x00},
	{0x852e,0x75},
	{0x852f,0x31},
	{0x8530,0x03},
	{0x8531,0x22},
	{0x8532,0xe5},
	{0x8533,0x7e},
	{0x8534,0x24},
	{0x8535,0xfe},
	{0x8536,0x60},
	{0x8537,0x27},
	{0x8538,0x14},
	{0x8539,0x60},
	{0x853a,0x31},
	{0x853b,0x24},
	{0x853c,0xf8},
	{0x853d,0x60},
	{0x853e,0x3a},
	{0x853f,0x14},
	{0x8540,0x60},
	{0x8541,0x4b},
	{0x8542,0x14},
	{0x8543,0x60},
	{0x8544,0x59},
	{0x8545,0x14},
	{0x8546,0x60},
	{0x8547,0x6a},
	{0x8548,0x24},
	{0x8549,0xfd},
	{0x854a,0x70},
	{0x854b,0x03},
	{0x854c,0x02},
	{0x854d,0x05},
	{0x854e,0xe7},
	{0x854f,0x24},
	{0x8550,0x10},
	{0x8551,0x60},
	{0x8552,0x03},
	{0x8553,0x02},
	{0x8554,0x06},
	{0x8555,0xe2},
	{0x8556,0xe4},
	{0x8557,0xf5},
	{0x8558,0x0a},
	{0x8559,0x12},
	{0x855a,0x13},
	{0x855b,0x9c},
	{0x855c,0x02},
	{0x855d,0x06},
	{0x855e,0xcb},
	{0x855f,0x75},
	{0x8560,0x0a},
	{0x8561,0x01},
	{0x8562,0x12},
	{0x8563,0x06},
	{0x8564,0xe3},
	{0x8565,0xc2},
	{0x8566,0x3c},
	{0x8567,0xd2},
	{0x8568,0x3b},
	{0x8569,0x02},
	{0x856a,0x06},
	{0x856b,0xdc},
	{0x856c,0x75},
	{0x856d,0x0a},
	{0x856e,0x02},
	{0x856f,0x12},
	{0x8570,0x06},
	{0x8571,0xe3},
	{0x8572,0xd2},
	{0x8573,0x3c},
	{0x8574,0xc2},
	{0x8575,0x3b},
	{0x8576,0x02},
	{0x8577,0x06},
	{0x8578,0xdc},
	{0x8579,0x30},
	{0x857a,0x38},
	{0x857b,0x0c},
	{0x857c,0x20},
	{0x857d,0x3c},
	{0x857e,0x03},
	{0x857f,0x30},
	{0x8580,0x3b},
	{0x8581,0x06},
	{0x8582,0xe4},
	{0x8583,0xf5},
	{0x8584,0x0a},
	{0x8585,0x12},
	{0x8586,0x15},
	{0x8587,0x10},
	{0x8588,0xd2},
	{0x8589,0x18},
	{0x858a,0xc2},
	{0x858b,0x19},
	{0x858c,0x22},
	{0x858d,0x30},
	{0x858e,0x38},
	{0x858f,0x09},
	{0x8590,0x20},
	{0x8591,0x3c},
	{0x8592,0x03},
	{0x8593,0x30},
	{0x8594,0x3b},
	{0x8595,0x03},
	{0x8596,0x12},
	{0x8597,0x06},
	{0x8598,0xf4},
	{0x8599,0xd2},
	{0x859a,0x18},
	{0x859b,0xd2},
	{0x859c,0x19},
	{0x859d,0x22},
	{0x859e,0x30},
	{0x859f,0x38},
	{0x85a0,0x0c},
	{0x85a1,0x20},
	{0x85a2,0x3c},
	{0x85a3,0x03},
	{0x85a4,0x30},
	{0x85a5,0x3b},
	{0x85a6,0x06},
	{0x85a7,0x75},
	{0x85a8,0x0a},
	{0x85a9,0x02},
	{0x85aa,0x12},
	{0x85ab,0x15},
	{0x85ac,0x10},
	{0x85ad,0xc2},
	{0x85ae,0x18},
	{0x85af,0xd2},
	{0x85b0,0x19},
	{0x85b1,0x22},
	{0x85b2,0x20},
	{0x85b3,0x3c},
	{0x85b4,0x06},
	{0x85b5,0x20},
	{0x85b6,0x3b},
	{0x85b7,0x03},
	{0x85b8,0x02},
	{0x85b9,0x06},
	{0x85ba,0xe2},
	{0x85bb,0xe5},
	{0x85bc,0x79},
	{0x85bd,0xd3},
	{0x85be,0x94},
	{0x85bf,0x03},
	{0x85c0,0x40},
	{0x85c1,0x04},
	{0x85c2,0x7f},
	{0x85c3,0x00},
	{0x85c4,0x80},
	{0x85c5,0x04},
	{0x85c6,0xe5},
	{0x85c7,0x79},
	{0x85c8,0x04},
	{0x85c9,0xff},
	{0x85ca,0x8f},
	{0x85cb,0x79},
	{0x85cc,0x30},
	{0x85cd,0x18},
	{0x85ce,0x06},
	{0x85cf,0x30},
	{0x85d0,0x19},
	{0x85d1,0x03},
	{0x85d2,0x12},
	{0x85d3,0x06},
	{0x85d4,0xf4},
	{0x85d5,0x30},
	{0x85d6,0x18},
	{0x85d7,0x03},
	{0x85d8,0x02},
	{0x85d9,0x06},
	{0x85da,0xe2},
	{0x85db,0x20},
	{0x85dc,0x19},
	{0x85dd,0x03},
	{0x85de,0x02},
	{0x85df,0x06},
	{0x85e0,0xe2},
	{0x85e1,0x75},
	{0x85e2,0x0a},
	{0x85e3,0x02},
	{0x85e4,0x02},
	{0x85e5,0x15},
	{0x85e6,0x10},
	{0x85e7,0xe5},
	{0x85e8,0x68},
	{0x85e9,0xd3},
	{0x85ea,0x94},
	{0x85eb,0x38},
	{0x85ec,0x40},
	{0x85ed,0x04},
	{0x85ee,0x7f},
	{0x85ef,0x34},
	{0x85f0,0x80},
	{0x85f1,0x02},
	{0x85f2,0xaf},
	{0x85f3,0x68},
	{0x85f4,0x8f},
	{0x85f5,0x68},
	{0x85f6,0xe5},
	{0x85f7,0x68},
	{0x85f8,0xc3},
	{0x85f9,0x94},
	{0x85fa,0x08},
	{0x85fb,0x50},
	{0x85fc,0x04},
	{0x85fd,0x7f},
	{0x85fe,0x08},
	{0x85ff,0x80},
	{0x8600,0x02},
	{0x8601,0xaf},
	{0x8602,0x68},
	{0x8603,0x8f},
	{0x8604,0x68},
	{0x8605,0xe5},
	{0x8606,0x69},
	{0x8607,0xd3},
	{0x8608,0x94},
	{0x8609,0x2a},
	{0x860a,0x40},
	{0x860b,0x04},
	{0x860c,0x7f},
	{0x860d,0x2a},
	{0x860e,0x80},
	{0x860f,0x02},
	{0x8610,0xaf},
	{0x8611,0x69},
	{0x8612,0x8f},
	{0x8613,0x69},
	{0x8614,0xe5},
	{0x8615,0x69},
	{0x8616,0xc3},
	{0x8617,0x94},
	{0x8618,0x06},
	{0x8619,0x50},
	{0x861a,0x04},
	{0x861b,0x7f},
	{0x861c,0x06},
	{0x861d,0x80},
	{0x861e,0x02},
	{0x861f,0xaf},
	{0x8620,0x69},
	{0x8621,0x8f},
	{0x8622,0x69},
	{0x8623,0xaf},
	{0x8624,0x68},
	{0x8625,0xef},
	{0x8626,0x24},
	{0x8627,0xf8},
	{0x8628,0xff},
	{0x8629,0xe4},
	{0x862a,0x34},
	{0x862b,0xff},
	{0x862c,0xfe},
	{0x862d,0xe4},
	{0x862e,0x8f},
	{0x862f,0x3f},
	{0x8630,0x8e},
	{0x8631,0x3e},
	{0x8632,0xf5},
	{0x8633,0x3d},
	{0x8634,0xf5},
	{0x8635,0x3c},
	{0x8636,0xac},
	{0x8637,0x3c},
	{0x8638,0x12},
	{0x8639,0x01},
	{0x863a,0xac},
	{0x863b,0xaf},
	{0x863c,0x69},
	{0x863d,0xef},
	{0x863e,0x24},
	{0x863f,0xfa},
	{0x8640,0xff},
	{0x8641,0xe4},
	{0x8642,0x34},
	{0x8643,0xff},
	{0x8644,0x12},
	{0x8645,0x01},
	{0x8646,0x8f},
	{0x8647,0xaf},
	{0x8648,0x68},
	{0x8649,0xef},
	{0x864a,0x24},
	{0x864b,0x08},
	{0x864c,0xff},
	{0x864d,0xe4},
	{0x864e,0x33},
	{0x864f,0x12},
	{0x8650,0x01},
	{0x8651,0x8f},
	{0x8652,0xaf},
	{0x8653,0x69},
	{0x8654,0xef},
	{0x8655,0x24},
	{0x8656,0x06},
	{0x8657,0xff},
	{0x8658,0xe4},
	{0x8659,0x33},
	{0x865a,0xfe},
	{0x865b,0xe4},
	{0x865c,0xfc},
	{0x865d,0xfd},
	{0x865e,0xe5},
	{0x865f,0x3f},
	{0x8660,0x2f},
	{0x8661,0xf5},
	{0x8662,0x3f},
	{0x8663,0xe5},
	{0x8664,0x3e},
	{0x8665,0x3e},
	{0x8666,0xf5},
	{0x8667,0x3e},
	{0x8668,0xed},
	{0x8669,0x35},
	{0x866a,0x3d},
	{0x866b,0xf5},
	{0x866c,0x3d},
	{0x866d,0xec},
	{0x866e,0x35},
	{0x866f,0x3c},
	{0x8670,0xf5},
	{0x8671,0x3c},
	{0x8672,0xe4},
	{0x8673,0x25},
	{0x8674,0x3f},
	{0x8675,0xf5},
	{0x8676,0x37},
	{0x8677,0xe4},
	{0x8678,0x35},
	{0x8679,0x3e},
	{0x867a,0xf5},
	{0x867b,0x36},
	{0x867c,0xe4},
	{0x867d,0x35},
	{0x867e,0x3d},
	{0x867f,0xf5},
	{0x8680,0x35},
	{0x8681,0xe5},
	{0x8682,0x3c},
	{0x8683,0x34},
	{0x8684,0x08},
	{0x8685,0xf5},
	{0x8686,0x34},
	{0x8687,0xe4},
	{0x8688,0x25},
	{0x8689,0x3f},
	{0x868a,0xf5},
	{0x868b,0x3b},
	{0x868c,0xe4},
	{0x868d,0x35},
	{0x868e,0x3e},
	{0x868f,0xf5},
	{0x8690,0x3a},
	{0x8691,0xe5},
	{0x8692,0x3d},
	{0x8693,0x34},
	{0x8694,0x06},
	{0x8695,0xf5},
	{0x8696,0x39},
	{0x8697,0xe4},
	{0x8698,0x35},
	{0x8699,0x3c},
	{0x869a,0xf5},
	{0x869b,0x38},
	{0x869c,0xe5},
	{0x869d,0x3f},
	{0x869e,0x24},
	{0x869f,0xfa},
	{0x86a0,0xf5},
	{0x86a1,0x43},
	{0x86a2,0xe5},
	{0x86a3,0x3e},
	{0x86a4,0x34},
	{0x86a5,0xff},
	{0x86a6,0xf5},
	{0x86a7,0x42},
	{0x86a8,0xe5},
	{0x86a9,0x3d},
	{0x86aa,0x34},
	{0x86ab,0xff},
	{0x86ac,0xf5},
	{0x86ad,0x41},
	{0x86ae,0xe5},
	{0x86af,0x3c},
	{0x86b0,0x34},
	{0x86b1,0xff},
	{0x86b2,0xf5},
	{0x86b3,0x40},
	{0x86b4,0xe4},
	{0x86b5,0x25},
	{0x86b6,0x3f},
	{0x86b7,0xf5},
	{0x86b8,0x47},
	{0x86b9,0xe5},
	{0x86ba,0x3e},
	{0x86bb,0x34},
	{0x86bc,0xf8},
	{0x86bd,0xf5},
	{0x86be,0x46},
	{0x86bf,0xe5},
	{0x86c0,0x3d},
	{0x86c1,0x34},
	{0x86c2,0xff},
	{0x86c3,0xf5},
	{0x86c4,0x45},
	{0x86c5,0xe5},
	{0x86c6,0x3c},
	{0x86c7,0x34},
	{0x86c8,0xff},
	{0x86c9,0xf5},
	{0x86ca,0x44},
	{0x86cb,0x75},
	{0x86cc,0x79},
	{0x86cd,0x02},
	{0x86ce,0x75},
	{0x86cf,0x0a},
	{0x86d0,0x01},
	{0x86d1,0x12},
	{0x86d2,0x15},
	{0x86d3,0x10},
	{0x86d4,0xd2},
	{0x86d5,0x18},
	{0x86d6,0xd2},
	{0x86d7,0x19},
	{0x86d8,0xc2},
	{0x86d9,0x3c},
	{0x86da,0xc2},
	{0x86db,0x3b},
	{0x86dc,0xd2},
	{0x86dd,0x1a},
	{0x86de,0xd2},
	{0x86df,0x38},
	{0x86e0,0xd2},
	{0x86e1,0x30},
	{0x86e2,0x22},
	{0x86e3,0x12},
	{0x86e4,0x13},
	{0x86e5,0x9c},
	{0x86e6,0x75},
	{0x86e7,0x79},
	{0x86e8,0x02},
	{0x86e9,0xe4},
	{0x86ea,0xf5},
	{0x86eb,0x0a},
	{0x86ec,0x12},
	{0x86ed,0x15},
	{0x86ee,0x10},
	{0x86ef,0xd2},
	{0x86f0,0x18},
	{0x86f1,0xc2},
	{0x86f2,0x19},
	{0x86f3,0x22},
	{0x86f4,0x75},
	{0x86f5,0x0a},
	{0x86f6,0x01},
	{0x86f7,0x12},
	{0x86f8,0x15},
	{0x86f9,0x10},
	{0x86fa,0x22},
	{0x86fb,0x90},
	{0x86fc,0x38},
	{0x86fd,0x04},
	{0x86fe,0xe0},
	{0x86ff,0xfe},
	{0x8700,0xa3},
	{0x8701,0xe0},
	{0x8702,0xfd},
	{0x8703,0xed},
	{0x8704,0xff},
	{0x8705,0xee},
	{0x8706,0x54},
	{0x8707,0x0f},
	{0x8708,0xf5},
	{0x8709,0x0e},
	{0x870a,0x8f},
	{0x870b,0x0f},
	{0x870c,0xa3},
	{0x870d,0xe0},
	{0x870e,0xfe},
	{0x870f,0xa3},
	{0x8710,0xe0},
	{0x8711,0xfd},
	{0x8712,0xed},
	{0x8713,0xff},
	{0x8714,0xee},
	{0x8715,0x54},
	{0x8716,0x07},
	{0x8717,0xf5},
	{0x8718,0x10},
	{0x8719,0x8f},
	{0x871a,0x11},
	{0x871b,0xe5},
	{0x871c,0x0e},
	{0x871d,0xc4},
	{0x871e,0xf8},
	{0x871f,0x54},
	{0x8720,0xf0},
	{0x8721,0xc8},
	{0x8722,0x68},
	{0x8723,0xf5},
	{0x8724,0x0e},
	{0x8725,0xe5},
	{0x8726,0x0f},
	{0x8727,0xc4},
	{0x8728,0x54},
	{0x8729,0x0f},
	{0x872a,0x48},
	{0x872b,0xf5},
	{0x872c,0x0f},
	{0x872d,0xe5},
	{0x872e,0x10},
	{0x872f,0xc4},
	{0x8730,0xf8},
	{0x8731,0x54},
	{0x8732,0xf0},
	{0x8733,0xc8},
	{0x8734,0x68},
	{0x8735,0xf5},
	{0x8736,0x10},
	{0x8737,0xe5},
	{0x8738,0x11},
	{0x8739,0xc4},
	{0x873a,0x54},
	{0x873b,0x0f},
	{0x873c,0x48},
	{0x873d,0xf5},
	{0x873e,0x11},
	{0x873f,0xe4},
	{0x8740,0xf5},
	{0x8741,0x17},
	{0x8742,0x75},
	{0x8743,0x16},
	{0x8744,0x04},
	{0x8745,0x12},
	{0x8746,0x02},
	{0x8747,0x73},
	{0x8748,0x24},
	{0x8749,0x34},
	{0x874a,0xf8},
	{0x874b,0xe6},
	{0x874c,0xf5},
	{0x874d,0x12},
	{0x874e,0x12},
	{0x874f,0x02},
	{0x8750,0x73},
	{0x8751,0x24},
	{0x8752,0x35},
	{0x8753,0xf8},
	{0x8754,0xe6},
	{0x8755,0xf5},
	{0x8756,0x14},
	{0x8757,0x12},
	{0x8758,0x02},
	{0x8759,0x73},
	{0x875a,0x24},
	{0x875b,0x36},
	{0x875c,0xf8},
	{0x875d,0xe6},
	{0x875e,0xf5},
	{0x875f,0x13},
	{0x8760,0x12},
	{0x8761,0x02},
	{0x8762,0x73},
	{0x8763,0x24},
	{0x8764,0x37},
	{0x8765,0xf8},
	{0x8766,0xe6},
	{0x8767,0xf5},
	{0x8768,0x15},
	{0x8769,0x12},
	{0x876a,0x02},
	{0x876b,0x86},
	{0x876c,0xaf},
	{0x876d,0x12},
	{0x876e,0x12},
	{0x876f,0x01},
	{0x8770,0x42},
	{0x8771,0x8f},
	{0x8772,0x12},
	{0x8773,0x12},
	{0x8774,0x02},
	{0x8775,0x86},
	{0x8776,0xaf},
	{0x8777,0x13},
	{0x8778,0x12},
	{0x8779,0x01},
	{0x877a,0x42},
	{0x877b,0x8f},
	{0x877c,0x13},
	{0x877d,0x12},
	{0x877e,0x02},
	{0x877f,0x35},
	{0x8780,0xaf},
	{0x8781,0x14},
	{0x8782,0xfc},
	{0x8783,0xfd},
	{0x8784,0xfe},
	{0x8785,0x12},
	{0x8786,0x08},
	{0x8787,0x9b},
	{0x8788,0x12},
	{0x8789,0x01},
	{0x878a,0x61},
	{0x878b,0x7b},
	{0x878c,0x30},
	{0x878d,0x12},
	{0x878e,0x01},
	{0x878f,0x5a},
	{0x8790,0x8f},
	{0x8791,0x14},
	{0x8792,0x12},
	{0x8793,0x02},
	{0x8794,0x35},
	{0x8795,0xaf},
	{0x8796,0x15},
	{0x8797,0xfc},
	{0x8798,0xfd},
	{0x8799,0xfe},
	{0x879a,0x12},
	{0x879b,0x08},
	{0x879c,0x9b},
	{0x879d,0x12},
	{0x879e,0x01},
	{0x879f,0x61},
	{0x87a0,0xe4},
	{0x87a1,0x7b},
	{0x87a2,0x30},
	{0x87a3,0x12},
	{0x87a4,0x01},
	{0x87a5,0x5b},
	{0x87a6,0x8f},
	{0x87a7,0x15},
	{0x87a8,0xc3},
	{0x87a9,0xe5},
	{0x87aa,0x13},
	{0x87ab,0x95},
	{0x87ac,0x12},
	{0x87ad,0xff},
	{0x87ae,0x0f},
	{0x87af,0xef},
	{0x87b0,0xc3},
	{0x87b1,0x13},
	{0x87b2,0xff},
	{0x87b3,0xc3},
	{0x87b4,0x94},
	{0x87b5,0x04},
	{0x87b6,0x50},
	{0x87b7,0x27},
	{0x87b8,0xe5},
	{0x87b9,0x12},
	{0x87ba,0x9f},
	{0x87bb,0x40},
	{0x87bc,0x06},
	{0x87bd,0xe5},
	{0x87be,0x12},
	{0x87bf,0x9f},
	{0x87c0,0xfe},
	{0x87c1,0x80},
	{0x87c2,0x02},
	{0x87c3,0x7e},
	{0x87c4,0x00},
	{0x87c5,0x8e},
	{0x87c6,0x12},
	{0x87c7,0xef},
	{0x87c8,0xfd},
	{0x87c9,0xe5},
	{0x87ca,0x13},
	{0x87cb,0x2d},
	{0x87cc,0xfd},
	{0x87cd,0xe4},
	{0x87ce,0x33},
	{0x87cf,0xfc},
	{0x87d0,0xc3},
	{0x87d1,0xed},
	{0x87d2,0x95},
	{0x87d3,0x0f},
	{0x87d4,0xec},
	{0x87d5,0x95},
	{0x87d6,0x0e},
	{0x87d7,0x50},
	{0x87d8,0x02},
	{0x87d9,0x80},
	{0x87da,0x02},
	{0x87db,0xad},
	{0x87dc,0x0f},
	{0x87dd,0x8d},
	{0x87de,0x13},
	{0x87df,0xc3},
	{0x87e0,0xe5},
	{0x87e1,0x15},
	{0x87e2,0x95},
	{0x87e3,0x14},
	{0x87e4,0xff},
	{0x87e5,0xc3},
	{0x87e6,0x94},
	{0x87e7,0x04},
	{0x87e8,0x50},
	{0x87e9,0x29},
	{0x87ea,0xe5},
	{0x87eb,0x14},
	{0x87ec,0x9f},
	{0x87ed,0x40},
	{0x87ee,0x06},
	{0x87ef,0xe5},
	{0x87f0,0x14},
	{0x87f1,0x9f},
	{0x87f2,0xfe},
	{0x87f3,0x80},
	{0x87f4,0x02},
	{0x87f5,0x7e},
	{0x87f6,0x00},
	{0x87f7,0x8e},
	{0x87f8,0x14},
	{0x87f9,0xef},
	{0x87fa,0xfd},
	{0x87fb,0xe5},
	{0x87fc,0x15},
	{0x87fd,0x2d},
	{0x87fe,0xfd},
	{0x87ff,0xe4},
	{0x8800,0x33},
	{0x8801,0xfc},
	{0x8802,0xc3},
	{0x8803,0xed},
	{0x8804,0x95},
	{0x8805,0x11},
	{0x8806,0xec},
	{0x8807,0x95},
	{0x8808,0x10},
	{0x8809,0x50},
	{0x880a,0x04},
	{0x880b,0xaf},
	{0x880c,0x05},
	{0x880d,0x80},
	{0x880e,0x02},
	{0x880f,0xaf},
	{0x8810,0x11},
	{0x8811,0x8f},
	{0x8812,0x15},
	{0x8813,0xe5},
	{0x8814,0x15},
	{0x8815,0xd3},
	{0x8816,0x95},
	{0x8817,0x17},
	{0x8818,0x40},
	{0x8819,0x04},
	{0x881a,0xaf},
	{0x881b,0x15},
	{0x881c,0x80},
	{0x881d,0x02},
	{0x881e,0xaf},
	{0x881f,0x17},
	{0x8820,0x8f},
	{0x8821,0x17},
	{0x8822,0xd3},
	{0x8823,0xe5},
	{0x8824,0x16},
	{0x8825,0x64},
	{0x8826,0x80},
	{0x8827,0x94},
	{0x8828,0x80},
	{0x8829,0x40},
	{0x882a,0x04},
	{0x882b,0xaf},
	{0x882c,0x15},
	{0x882d,0x80},
	{0x882e,0x02},
	{0x882f,0xaf},
	{0x8830,0x17},
	{0x8831,0x8f},
	{0x8832,0x15},
	{0x8833,0xe5},
	{0x8834,0x16},
	{0x8835,0xfd},
	{0x8836,0x33},
	{0x8837,0x95},
	{0x8838,0xe0},
	{0x8839,0xfc},
	{0x883a,0xed},
	{0x883b,0xae},
	{0x883c,0x04},
	{0x883d,0x78},
	{0x883e,0x02},
	{0x883f,0xc3},
	{0x8840,0x33},
	{0x8841,0xce},
	{0x8842,0x33},
	{0x8843,0xce},
	{0x8844,0xd8},
	{0x8845,0xf9},
	{0x8846,0xff},
	{0x8847,0x24},
	{0x8848,0x01},
	{0x8849,0xfb},
	{0x884a,0xee},
	{0x884b,0x34},
	{0x884c,0x60},
	{0x884d,0x8b},
	{0x884e,0x82},
	{0x884f,0xf5},
	{0x8850,0x83},
	{0x8851,0xe5},
	{0x8852,0x12},
	{0x8853,0xf0},
	{0x8854,0xef},
	{0x8855,0x24},
	{0x8856,0x02},
	{0x8857,0xff},
	{0x8858,0xee},
	{0x8859,0x34},
	{0x885a,0x60},
	{0x885b,0x8f},
	{0x885c,0x82},
	{0x885d,0xf5},
	{0x885e,0x83},
	{0x885f,0xe5},
	{0x8860,0x14},
	{0x8861,0xf0},
	{0x8862,0xed},
	{0x8863,0xae},
	{0x8864,0x04},
	{0x8865,0x78},
	{0x8866,0x02},
	{0x8867,0xc3},
	{0x8868,0x33},
	{0x8869,0xce},
	{0x886a,0x33},
	{0x886b,0xce},
	{0x886c,0xd8},
	{0x886d,0xf9},
	{0x886e,0xff},
	{0x886f,0x24},
	{0x8870,0x03},
	{0x8871,0xfd},
	{0x8872,0xee},
	{0x8873,0x34},
	{0x8874,0x60},
	{0x8875,0x8d},
	{0x8876,0x82},
	{0x8877,0xf5},
	{0x8878,0x83},
	{0x8879,0xe5},
	{0x887a,0x13},
	{0x887b,0xf0},
	{0x887c,0xef},
	{0x887d,0x24},
	{0x887e,0x04},
	{0x887f,0xff},
	{0x8880,0xee},
	{0x8881,0x34},
	{0x8882,0x60},
	{0x8883,0x8f},
	{0x8884,0x82},
	{0x8885,0xf5},
	{0x8886,0x83},
	{0x8887,0xe5},
	{0x8888,0x15},
	{0x8889,0xf0},
	{0x888a,0x15},
	{0x888b,0x16},
	{0x888c,0xc3},
	{0x888d,0xe5},
	{0x888e,0x16},
	{0x888f,0x64},
	{0x8890,0x80},
	{0x8891,0x94},
	{0x8892,0x80},
	{0x8893,0x40},
	{0x8894,0x03},
	{0x8895,0x02},
	{0x8896,0x07},
	{0x8897,0x45},
	{0x8898,0xc2},
	{0x8899,0x30},
	{0x889a,0x22},
	{0x889b,0xe8},
	{0x889c,0x8f},
	{0x889d,0xf0},
	{0x889e,0xa4},
	{0x889f,0xcc},
	{0x88a0,0x8b},
	{0x88a1,0xf0},
	{0x88a2,0xa4},
	{0x88a3,0x2c},
	{0x88a4,0xfc},
	{0x88a5,0xe9},
	{0x88a6,0x8e},
	{0x88a7,0xf0},
	{0x88a8,0xa4},
	{0x88a9,0x2c},
	{0x88aa,0xfc},
	{0x88ab,0x8a},
	{0x88ac,0xf0},
	{0x88ad,0xed},
	{0x88ae,0xa4},
	{0x88af,0x2c},
	{0x88b0,0xfc},
	{0x88b1,0xea},
	{0x88b2,0x8e},
	{0x88b3,0xf0},
	{0x88b4,0xa4},
	{0x88b5,0xcd},
	{0x88b6,0xa8},
	{0x88b7,0xf0},
	{0x88b8,0x8b},
	{0x88b9,0xf0},
	{0x88ba,0xa4},
	{0x88bb,0x2d},
	{0x88bc,0xcc},
	{0x88bd,0x38},
	{0x88be,0x25},
	{0x88bf,0xf0},
	{0x88c0,0xfd},
	{0x88c1,0xe9},
	{0x88c2,0x8f},
	{0x88c3,0xf0},
	{0x88c4,0xa4},
	{0x88c5,0x2c},
	{0x88c6,0xcd},
	{0x88c7,0x35},
	{0x88c8,0xf0},
	{0x88c9,0xfc},
	{0x88ca,0xeb},
	{0x88cb,0x8e},
	{0x88cc,0xf0},
	{0x88cd,0xa4},
	{0x88ce,0xfe},
	{0x88cf,0xa9},
	{0x88d0,0xf0},
	{0x88d1,0xeb},
	{0x88d2,0x8f},
	{0x88d3,0xf0},
	{0x88d4,0xa4},
	{0x88d5,0xcf},
	{0x88d6,0xc5},
	{0x88d7,0xf0},
	{0x88d8,0x2e},
	{0x88d9,0xcd},
	{0x88da,0x39},
	{0x88db,0xfe},
	{0x88dc,0xe4},
	{0x88dd,0x3c},
	{0x88de,0xfc},
	{0x88df,0xea},
	{0x88e0,0xa4},
	{0x88e1,0x2d},
	{0x88e2,0xce},
	{0x88e3,0x35},
	{0x88e4,0xf0},
	{0x88e5,0xfd},
	{0x88e6,0xe4},
	{0x88e7,0x3c},
	{0x88e8,0xfc},
	{0x88e9,0x22},
	{0x88ea,0x75},
	{0x88eb,0xf0},
	{0x88ec,0x08},
	{0x88ed,0x75},
	{0x88ee,0x82},
	{0x88ef,0x00},
	{0x88f0,0xef},
	{0x88f1,0x2f},
	{0x88f2,0xff},
	{0x88f3,0xee},
	{0x88f4,0x33},
	{0x88f5,0xfe},
	{0x88f6,0xcd},
	{0x88f7,0x33},
	{0x88f8,0xcd},
	{0x88f9,0xcc},
	{0x88fa,0x33},
	{0x88fb,0xcc},
	{0x88fc,0xc5},
	{0x88fd,0x82},
	{0x88fe,0x33},
	{0x88ff,0xc5},
	{0x8900,0x82},
	{0x8901,0x9b},
	{0x8902,0xed},
	{0x8903,0x9a},
	{0x8904,0xec},
	{0x8905,0x99},
	{0x8906,0xe5},
	{0x8907,0x82},
	{0x8908,0x98},
	{0x8909,0x40},
	{0x890a,0x0c},
	{0x890b,0xf5},
	{0x890c,0x82},
	{0x890d,0xee},
	{0x890e,0x9b},
	{0x890f,0xfe},
	{0x8910,0xed},
	{0x8911,0x9a},
	{0x8912,0xfd},
	{0x8913,0xec},
	{0x8914,0x99},
	{0x8915,0xfc},
	{0x8916,0x0f},
	{0x8917,0xd5},
	{0x8918,0xf0},
	{0x8919,0xd6},
	{0x891a,0xe4},
	{0x891b,0xce},
	{0x891c,0xfb},
	{0x891d,0xe4},
	{0x891e,0xcd},
	{0x891f,0xfa},
	{0x8920,0xe4},
	{0x8921,0xcc},
	{0x8922,0xf9},
	{0x8923,0xa8},
	{0x8924,0x82},
	{0x8925,0x22},
	{0x8926,0xb8},
	{0x8927,0x00},
	{0x8928,0xc1},
	{0x8929,0xb9},
	{0x892a,0x00},
	{0x892b,0x59},
	{0x892c,0xba},
	{0x892d,0x00},
	{0x892e,0x2d},
	{0x892f,0xec},
	{0x8930,0x8b},
	{0x8931,0xf0},
	{0x8932,0x84},
	{0x8933,0xcf},
	{0x8934,0xce},
	{0x8935,0xcd},
	{0x8936,0xfc},
	{0x8937,0xe5},
	{0x8938,0xf0},
	{0x8939,0xcb},
	{0x893a,0xf9},
	{0x893b,0x78},
	{0x893c,0x18},
	{0x893d,0xef},
	{0x893e,0x2f},
	{0x893f,0xff},
	{0x8940,0xee},
	{0x8941,0x33},
	{0x8942,0xfe},
	{0x8943,0xed},
	{0x8944,0x33},
	{0x8945,0xfd},
	{0x8946,0xec},
	{0x8947,0x33},
	{0x8948,0xfc},
	{0x8949,0xeb},
	{0x894a,0x33},
	{0x894b,0xfb},
	{0x894c,0x10},
	{0x894d,0xd7},
	{0x894e,0x03},
	{0x894f,0x99},
	{0x8950,0x40},
	{0x8951,0x04},
	{0x8952,0xeb},
	{0x8953,0x99},
	{0x8954,0xfb},
	{0x8955,0x0f},
	{0x8956,0xd8},
	{0x8957,0xe5},
	{0x8958,0xe4},
	{0x8959,0xf9},
	{0x895a,0xfa},
	{0x895b,0x22},
	{0x895c,0x78},
	{0x895d,0x18},
	{0x895e,0xef},
	{0x895f,0x2f},
	{0x8960,0xff},
	{0x8961,0xee},
	{0x8962,0x33},
	{0x8963,0xfe},
	{0x8964,0xed},
	{0x8965,0x33},
	{0x8966,0xfd},
	{0x8967,0xec},
	{0x8968,0x33},
	{0x8969,0xfc},
	{0x896a,0xc9},
	{0x896b,0x33},
	{0x896c,0xc9},
	{0x896d,0x10},
	{0x896e,0xd7},
	{0x896f,0x05},
	{0x8970,0x9b},
	{0x8971,0xe9},
	{0x8972,0x9a},
	{0x8973,0x40},
	{0x8974,0x07},
	{0x8975,0xec},
	{0x8976,0x9b},
	{0x8977,0xfc},
	{0x8978,0xe9},
	{0x8979,0x9a},
	{0x897a,0xf9},
	{0x897b,0x0f},
	{0x897c,0xd8},
	{0x897d,0xe0},
	{0x897e,0xe4},
	{0x897f,0xc9},
	{0x8980,0xfa},
	{0x8981,0xe4},
	{0x8982,0xcc},
	{0x8983,0xfb},
	{0x8984,0x22},
	{0x8985,0x75},
	{0x8986,0xf0},
	{0x8987,0x10},
	{0x8988,0xef},
	{0x8989,0x2f},
	{0x898a,0xff},
	{0x898b,0xee},
	{0x898c,0x33},
	{0x898d,0xfe},
	{0x898e,0xed},
	{0x898f,0x33},
	{0x8990,0xfd},
	{0x8991,0xcc},
	{0x8992,0x33},
	{0x8993,0xcc},
	{0x8994,0xc8},
	{0x8995,0x33},
	{0x8996,0xc8},
	{0x8997,0x10},
	{0x8998,0xd7},
	{0x8999,0x07},
	{0x899a,0x9b},
	{0x899b,0xec},
	{0x899c,0x9a},
	{0x899d,0xe8},
	{0x899e,0x99},
	{0x899f,0x40},
	{0x89a0,0x0a},
	{0x89a1,0xed},
	{0x89a2,0x9b},
	{0x89a3,0xfd},
	{0x89a4,0xec},
	{0x89a5,0x9a},
	{0x89a6,0xfc},
	{0x89a7,0xe8},
	{0x89a8,0x99},
	{0x89a9,0xf8},
	{0x89aa,0x0f},
	{0x89ab,0xd5},
	{0x89ac,0xf0},
	{0x89ad,0xda},
	{0x89ae,0xe4},
	{0x89af,0xcd},
	{0x89b0,0xfb},
	{0x89b1,0xe4},
	{0x89b2,0xcc},
	{0x89b3,0xfa},
	{0x89b4,0xe4},
	{0x89b5,0xc8},
	{0x89b6,0xf9},
	{0x89b7,0x22},
	{0x89b8,0xe8},
	{0x89b9,0x60},
	{0x89ba,0x0f},
	{0x89bb,0xec},
	{0x89bc,0xc3},
	{0x89bd,0x13},
	{0x89be,0xfc},
	{0x89bf,0xed},
	{0x89c0,0x13},
	{0x89c1,0xfd},
	{0x89c2,0xee},
	{0x89c3,0x13},
	{0x89c4,0xfe},
	{0x89c5,0xef},
	{0x89c6,0x13},
	{0x89c7,0xff},
	{0x89c8,0xd8},
	{0x89c9,0xf1},
	{0x89ca,0x22},
	{0x89cb,0xe8},
	{0x89cc,0x60},
	{0x89cd,0x0f},
	{0x89ce,0xef},
	{0x89cf,0xc3},
	{0x89d0,0x33},
	{0x89d1,0xff},
	{0x89d2,0xee},
	{0x89d3,0x33},
	{0x89d4,0xfe},
	{0x89d5,0xed},
	{0x89d6,0x33},
	{0x89d7,0xfd},
	{0x89d8,0xec},
	{0x89d9,0x33},
	{0x89da,0xfc},
	{0x89db,0xd8},
	{0x89dc,0xf1},
	{0x89dd,0x22},
	{0x89de,0xe4},
	{0x89df,0x93},
	{0x89e0,0xfc},
	{0x89e1,0x74},
	{0x89e2,0x01},
	{0x89e3,0x93},
	{0x89e4,0xfd},
	{0x89e5,0x74},
	{0x89e6,0x02},
	{0x89e7,0x93},
	{0x89e8,0xfe},
	{0x89e9,0x74},
	{0x89ea,0x03},
	{0x89eb,0x93},
	{0x89ec,0xff},
	{0x89ed,0x22},
	{0x89ee,0xa4},
	{0x89ef,0x25},
	{0x89f0,0x82},
	{0x89f1,0xf5},
	{0x89f2,0x82},
	{0x89f3,0xe5},
	{0x89f4,0xf0},
	{0x89f5,0x35},
	{0x89f6,0x83},
	{0x89f7,0xf5},
	{0x89f8,0x83},
	{0x89f9,0x22},
	{0x89fa,0xd0},
	{0x89fb,0x83},
	{0x89fc,0xd0},
	{0x89fd,0x82},
	{0x89fe,0xf8},
	{0x89ff,0xe4},
	{0x8a00,0x93},
	{0x8a01,0x70},
	{0x8a02,0x12},
	{0x8a03,0x74},
	{0x8a04,0x01},
	{0x8a05,0x93},
	{0x8a06,0x70},
	{0x8a07,0x0d},
	{0x8a08,0xa3},
	{0x8a09,0xa3},
	{0x8a0a,0x93},
	{0x8a0b,0xf8},
	{0x8a0c,0x74},
	{0x8a0d,0x01},
	{0x8a0e,0x93},
	{0x8a0f,0xf5},
	{0x8a10,0x82},
	{0x8a11,0x88},
	{0x8a12,0x83},
	{0x8a13,0xe4},
	{0x8a14,0x73},
	{0x8a15,0x74},
	{0x8a16,0x02},
	{0x8a17,0x93},
	{0x8a18,0x68},
	{0x8a19,0x60},
	{0x8a1a,0xef},
	{0x8a1b,0xa3},
	{0x8a1c,0xa3},
	{0x8a1d,0xa3},
	{0x8a1e,0x80},
	{0x8a1f,0xdf},
	{0x8a20,0x75},
	{0x8a21,0x13},
	{0x8a22,0x0a},
	{0x8a23,0xa2},
	{0x8a24,0xaf},
	{0x8a25,0x92},
	{0x8a26,0x32},
	{0x8a27,0xc2},
	{0x8a28,0xaf},
	{0x8a29,0xc2},
	{0x8a2a,0x33},
	{0x8a2b,0x12},
	{0x8a2c,0x01},
	{0x8a2d,0x6a},
	{0x8a2e,0x12},
	{0x8a2f,0x02},
	{0x8a30,0x2c},
	{0x8a31,0x12},
	{0x8a32,0x01},
	{0x8a33,0x6a},
	{0x8a34,0x75},
	{0x8a35,0x51},
	{0x8a36,0x05},
	{0x8a37,0xaf},
	{0x8a38,0x51},
	{0x8a39,0x15},
	{0x8a3a,0x51},
	{0x8a3b,0xef},
	{0x8a3c,0x70},
	{0x8a3d,0xf9},
	{0x8a3e,0xd2},
	{0x8a3f,0x28},
	{0x8a40,0x12},
	{0x8a41,0x01},
	{0x8a42,0x6c},
	{0x8a43,0x75},
	{0x8a44,0x51},
	{0x8a45,0x0a},
	{0x8a46,0xaf},
	{0x8a47,0x51},
	{0x8a48,0x15},
	{0x8a49,0x51},
	{0x8a4a,0xef},
	{0x8a4b,0x70},
	{0x8a4c,0xf9},
	{0x8a4d,0xc2},
	{0x8a4e,0x29},
	{0x8a4f,0x12},
	{0x8a50,0x01},
	{0x8a51,0x6c},
	{0x8a52,0x75},
	{0x8a53,0x51},
	{0x8a54,0x05},
	{0x8a55,0xaf},
	{0x8a56,0x51},
	{0x8a57,0x15},
	{0x8a58,0x51},
	{0x8a59,0xef},
	{0x8a5a,0x70},
	{0x8a5b,0xf9},
	{0x8a5c,0xc2},
	{0x8a5d,0x28},
	{0x8a5e,0x12},
	{0x8a5f,0x01},
	{0x8a60,0x6c},
	{0x8a61,0x75},
	{0x8a62,0x51},
	{0x8a63,0x05},
	{0x8a64,0xaf},
	{0x8a65,0x51},
	{0x8a66,0x15},
	{0x8a67,0x51},
	{0x8a68,0xef},
	{0x8a69,0x70},
	{0x8a6a,0xf9},
	{0x8a6b,0x75},
	{0x8a6c,0x14},
	{0x8a6d,0x18},
	{0x8a6e,0x12},
	{0x8a6f,0x0b},
	{0x8a70,0x60},
	{0x8a71,0x75},
	{0x8a72,0x51},
	{0x8a73,0x0a},
	{0x8a74,0xaf},
	{0x8a75,0x51},
	{0x8a76,0x15},
	{0x8a77,0x51},
	{0x8a78,0xef},
	{0x8a79,0x70},
	{0x8a7a,0xf9},
	{0x8a7b,0xd2},
	{0x8a7c,0x28},
	{0x8a7d,0x12},
	{0x8a7e,0x01},
	{0x8a7f,0x6c},
	{0x8a80,0x12},
	{0x8a81,0x02},
	{0x8a82,0x49},
	{0x8a83,0xaf},
	{0x8a84,0x51},
	{0x8a85,0x15},
	{0x8a86,0x51},
	{0x8a87,0xef},
	{0x8a88,0x70},
	{0x8a89,0xf9},
	{0x8a8a,0xc2},
	{0x8a8b,0x28},
	{0x8a8c,0x12},
	{0x8a8d,0x01},
	{0x8a8e,0x6c},
	{0x8a8f,0x75},
	{0x8a90,0x51},
	{0x8a91,0x0a},
	{0x8a92,0xaf},
	{0x8a93,0x51},
	{0x8a94,0x15},
	{0x8a95,0x51},
	{0x8a96,0xef},
	{0x8a97,0x70},
	{0x8a98,0xf9},
	{0x8a99,0x30},
	{0x8a9a,0x11},
	{0x8a9b,0x03},
	{0x8a9c,0x02},
	{0x8a9d,0x0b},
	{0x8a9e,0x17},
	{0x8a9f,0x12},
	{0x8aa0,0x01},
	{0x8aa1,0x6a},
	{0x8aa2,0x12},
	{0x8aa3,0x02},
	{0x8aa4,0x2c},
	{0x8aa5,0xe5},
	{0x8aa6,0x11},
	{0x8aa7,0xf5},
	{0x8aa8,0x14},
	{0x8aa9,0x12},
	{0x8aaa,0x0b},
	{0x8aab,0x60},
	{0x8aac,0x75},
	{0x8aad,0x51},
	{0x8aae,0x0a},
	{0x8aaf,0xaf},
	{0x8ab0,0x51},
	{0x8ab1,0x15},
	{0x8ab2,0x51},
	{0x8ab3,0xef},
	{0x8ab4,0x70},
	{0x8ab5,0xf9},
	{0x8ab6,0xd2},
	{0x8ab7,0x28},
	{0x8ab8,0x12},
	{0x8ab9,0x01},
	{0x8aba,0x6c},
	{0x8abb,0x12},
	{0x8abc,0x02},
	{0x8abd,0x49},
	{0x8abe,0xaf},
	{0x8abf,0x51},
	{0x8ac0,0x15},
	{0x8ac1,0x51},
	{0x8ac2,0xef},
	{0x8ac3,0x70},
	{0x8ac4,0xf9},
	{0x8ac5,0xc2},
	{0x8ac6,0x28},
	{0x8ac7,0x12},
	{0x8ac8,0x01},
	{0x8ac9,0x6c},
	{0x8aca,0x75},
	{0x8acb,0x51},
	{0x8acc,0x0a},
	{0x8acd,0xaf},
	{0x8ace,0x51},
	{0x8acf,0x15},
	{0x8ad0,0x51},
	{0x8ad1,0xef},
	{0x8ad2,0x70},
	{0x8ad3,0xf9},
	{0x8ad4,0x30},
	{0x8ad5,0x11},
	{0x8ad6,0x04},
	{0x8ad7,0x15},
	{0x8ad8,0x13},
	{0x8ad9,0x80},
	{0x8ada,0x45},
	{0x8adb,0x12},
	{0x8adc,0x01},
	{0x8add,0x6a},
	{0x8ade,0x12},
	{0x8adf,0x02},
	{0x8ae0,0x2c},
	{0x8ae1,0x85},
	{0x8ae2,0x12},
	{0x8ae3,0x14},
	{0x8ae4,0x12},
	{0x8ae5,0x16},
	{0x8ae6,0x3c},
	{0x8ae7,0xc2},
	{0x8ae8,0x09},
	{0x8ae9,0x12},
	{0x8aea,0x02},
	{0x8aeb,0x2e},
	{0x8aec,0x75},
	{0x8aed,0x51},
	{0x8aee,0x0a},
	{0x8aef,0xaf},
	{0x8af0,0x51},
	{0x8af1,0x15},
	{0x8af2,0x51},
	{0x8af3,0xef},
	{0x8af4,0x70},
	{0x8af5,0xf9},
	{0x8af6,0xd2},
	{0x8af7,0x28},
	{0x8af8,0x12},
	{0x8af9,0x01},
	{0x8afa,0x6c},
	{0x8afb,0x12},
	{0x8afc,0x02},
	{0x8afd,0x49},
	{0x8afe,0xaf},
	{0x8aff,0x51},
	{0x8b00,0x15},
	{0x8b01,0x51},
	{0x8b02,0xef},
	{0x8b03,0x70},
	{0x8b04,0xf9},
	{0x8b05,0xc2},
	{0x8b06,0x28},
	{0x8b07,0x12},
	{0x8b08,0x01},
	{0x8b09,0x6c},
	{0x8b0a,0x75},
	{0x8b0b,0x51},
	{0x8b0c,0x0a},
	{0x8b0d,0xaf},
	{0x8b0e,0x51},
	{0x8b0f,0x15},
	{0x8b10,0x51},
	{0x8b11,0xef},
	{0x8b12,0x70},
	{0x8b13,0xf9},
	{0x8b14,0x30},
	{0x8b15,0x11},
	{0x8b16,0x06},
	{0x8b17,0x15},
	{0x8b18,0x13},
	{0x8b19,0xd2},
	{0x8b1a,0x33},
	{0x8b1b,0x80},
	{0x8b1c,0x03},
	{0x8b1d,0xe4},
	{0x8b1e,0xf5},
	{0x8b1f,0x13},
	{0x8b20,0x12},
	{0x8b21,0x01},
	{0x8b22,0x6a},
	{0x8b23,0x12},
	{0x8b24,0x02},
	{0x8b25,0x2c},
	{0x8b26,0xc2},
	{0x8b27,0x29},
	{0x8b28,0x12},
	{0x8b29,0x01},
	{0x8b2a,0x6c},
	{0x8b2b,0x75},
	{0x8b2c,0x51},
	{0x8b2d,0x05},
	{0x8b2e,0xaf},
	{0x8b2f,0x51},
	{0x8b30,0x15},
	{0x8b31,0x51},
	{0x8b32,0xef},
	{0x8b33,0x70},
	{0x8b34,0xf9},
	{0x8b35,0xd2},
	{0x8b36,0x28},
	{0x8b37,0x12},
	{0x8b38,0x01},
	{0x8b39,0x6c},
	{0x8b3a,0x75},
	{0x8b3b,0x51},
	{0x8b3c,0x05},
	{0x8b3d,0xaf},
	{0x8b3e,0x51},
	{0x8b3f,0x15},
	{0x8b40,0x51},
	{0x8b41,0xef},
	{0x8b42,0x70},
	{0x8b43,0xf9},
	{0x8b44,0x12},
	{0x8b45,0x01},
	{0x8b46,0x6a},
	{0x8b47,0x75},
	{0x8b48,0x51},
	{0x8b49,0x05},
	{0x8b4a,0xaf},
	{0x8b4b,0x51},
	{0x8b4c,0x15},
	{0x8b4d,0x51},
	{0x8b4e,0xef},
	{0x8b4f,0x70},
	{0x8b50,0xf9},
	{0x8b51,0xa2},
	{0x8b52,0x32},
	{0x8b53,0x92},
	{0x8b54,0xaf},
	{0x8b55,0xe5},
	{0x8b56,0x13},
	{0x8b57,0xd3},
	{0x8b58,0x94},
	{0x8b59,0x00},
	{0x8b5a,0x40},
	{0x8b5b,0x03},
	{0x8b5c,0x02},
	{0x8b5d,0x0a},
	{0x8b5e,0x27},
	{0x8b5f,0x22},
	{0x8b60,0x12},
	{0x8b61,0x16},
	{0x8b62,0x3c},
	{0x8b63,0xc2},
	{0x8b64,0x09},
	{0x8b65,0x90},
	{0x8b66,0x30},
	{0x8b67,0x18},
	{0x8b68,0xe5},
	{0x8b69,0x21},
	{0x8b6a,0xf0},
	{0x8b6b,0x22},
	{0x8b6c,0x30},
	{0x8b6d,0x04},
	{0x8b6e,0x03},
	{0x8b6f,0x02},
	{0x8b70,0x0c},
	{0x8b71,0xa7},
	{0x8b72,0xd2},
	{0x8b73,0x04},
	{0x8b74,0xe5},
	{0x8b75,0x7e},
	{0x8b76,0xb4},
	{0x8b77,0x01},
	{0x8b78,0x06},
	{0x8b79,0x12},
	{0x8b7a,0x17},
	{0x8b7b,0x3c},
	{0x8b7c,0x02},
	{0x8b7d,0x0c},
	{0x8b7e,0xa0},
	{0x8b7f,0xe5},
	{0x8b80,0x7e},
	{0x8b81,0xb4},
	{0x8b82,0x02},
	{0x8b83,0x06},
	{0x8b84,0x12},
	{0x8b85,0x17},
	{0x8b86,0x4d},
	{0x8b87,0x02},
	{0x8b88,0x0c},
	{0x8b89,0xa0},
	{0x8b8a,0xe5},
	{0x8b8b,0x7e},
	{0x8b8c,0xb4},
	{0x8b8d,0x03},
	{0x8b8e,0x05},
	{0x8b8f,0xe4},
	{0x8b90,0xf5},
	{0x8b91,0x0c},
	{0x8b92,0x80},
	{0x8b93,0x08},
	{0x8b94,0xe5},
	{0x8b95,0x7e},
	{0x8b96,0xb4},
	{0x8b97,0x04},
	{0x8b98,0x09},
	{0x8b99,0x85},
	{0x8b9a,0x7c},
	{0x8b9b,0x0c},
	{0x8b9c,0x12},
	{0x8b9d,0x0e},
	{0x8b9e,0xf9},
	{0x8b9f,0x02},
	{0x8ba0,0x0c},
	{0x8ba1,0xa0},
	{0x8ba2,0xe5},
	{0x8ba3,0x7e},
	{0x8ba4,0x64},
	{0x8ba5,0x0f},
	{0x8ba6,0x70},
	{0x8ba7,0x3d},
	{0x8ba8,0xd3},
	{0x8ba9,0xe5},
	{0x8baa,0x69},
	{0x8bab,0x94},
	{0x8bac,0xff},
	{0x8bad,0xe5},
	{0x8bae,0x68},
	{0x8baf,0x94},
	{0x8bb0,0x03},
	{0x8bb1,0x40},
	{0x8bb2,0x06},
	{0x8bb3,0x7e},
	{0x8bb4,0x03},
	{0x8bb5,0x7f},
	{0x8bb6,0xff},
	{0x8bb7,0x80},
	{0x8bb8,0x04},
	{0x8bb9,0xae},
	{0x8bba,0x68},
	{0x8bbb,0xaf},
	{0x8bbc,0x69},
	{0x8bbd,0x8e},
	{0x8bbe,0x68},
	{0x8bbf,0x8f},
	{0x8bc0,0x69},
	{0x8bc1,0x85},
	{0x8bc2,0x68},
	{0x8bc3,0x64},
	{0x8bc4,0x85},
	{0x8bc5,0x69},
	{0x8bc6,0x65},
	{0x8bc7,0xe5},
	{0x8bc8,0x69},
	{0x8bc9,0xc4},
	{0x8bca,0xf8},
	{0x8bcb,0x54},
	{0x8bcc,0x0f},
	{0x8bcd,0xc8},
	{0x8bce,0x68},
	{0x8bcf,0xf5},
	{0x8bd0,0x69},
	{0x8bd1,0xe5},
	{0x8bd2,0x68},
	{0x8bd3,0xc4},
	{0x8bd4,0x54},
	{0x8bd5,0xf0},
	{0x8bd6,0x48},
	{0x8bd7,0xf5},
	{0x8bd8,0x68},
	{0x8bd9,0x85},
	{0x8bda,0x68},
	{0x8bdb,0x11},
	{0x8bdc,0x85},
	{0x8bdd,0x69},
	{0x8bde,0x12},
	{0x8bdf,0x12},
	{0x8be0,0x0a},
	{0x8be1,0x20},
	{0x8be2,0x02},
	{0x8be3,0x0c},
	{0x8be4,0xa0},
	{0x8be5,0xe5},
	{0x8be6,0x7e},
	{0x8be7,0x64},
	{0x8be8,0x10},
	{0x8be9,0x60},
	{0x8bea,0x03},
	{0x8beb,0x02},
	{0x8bec,0x0c},
	{0x8bed,0xa0},
	{0x8bee,0xf5},
	{0x8bef,0x66},
	{0x8bf0,0xf5},
	{0x8bf1,0x67},
	{0x8bf2,0xf5},
	{0x8bf3,0x68},
	{0x8bf4,0xab},
	{0x8bf5,0x69},
	{0x8bf6,0xaa},
	{0x8bf7,0x68},
	{0x8bf8,0xa9},
	{0x8bf9,0x67},
	{0x8bfa,0xa8},
	{0x8bfb,0x66},
	{0x8bfc,0x12},
	{0x8bfd,0x01},
	{0x8bfe,0x73},
	{0x8bff,0x12},
	{0x8c00,0x02},
	{0x8c01,0x11},
	{0x8c02,0xfe},
	{0x8c03,0xe4},
	{0x8c04,0xfc},
	{0x8c05,0xfd},
	{0x8c06,0x12},
	{0x8c07,0x01},
	{0x8c08,0xfd},
	{0x8c09,0xe4},
	{0x8c0a,0x7b},
	{0x8c0b,0xff},
	{0x8c0c,0xfa},
	{0x8c0d,0xf9},
	{0x8c0e,0xf8},
	{0x8c0f,0x12},
	{0x8c10,0x02},
	{0x8c11,0x7a},
	{0x8c12,0x12},
	{0x8c13,0x01},
	{0x8c14,0x88},
	{0x8c15,0xe4},
	{0x8c16,0x93},
	{0x8c17,0xfe},
	{0x8c18,0x74},
	{0x8c19,0x01},
	{0x8c1a,0x93},
	{0x8c1b,0xff},
	{0x8c1c,0xe4},
	{0x8c1d,0xfc},
	{0x8c1e,0xfd},
	{0x8c1f,0xe5},
	{0x8c20,0x69},
	{0x8c21,0x2f},
	{0x8c22,0xf5},
	{0x8c23,0x69},
	{0x8c24,0xe5},
	{0x8c25,0x68},
	{0x8c26,0x3e},
	{0x8c27,0xf5},
	{0x8c28,0x68},
	{0x8c29,0xed},
	{0x8c2a,0x35},
	{0x8c2b,0x67},
	{0x8c2c,0xf5},
	{0x8c2d,0x67},
	{0x8c2e,0xec},
	{0x8c2f,0x35},
	{0x8c30,0x66},
	{0x8c31,0xf5},
	{0x8c32,0x66},
	{0x8c33,0x85},
	{0x8c34,0x68},
	{0x8c35,0x66},
	{0x8c36,0x85},
	{0x8c37,0x69},
	{0x8c38,0x67},
	{0x8c39,0xd3},
	{0x8c3a,0xe5},
	{0x8c3b,0x67},
	{0x8c3c,0x94},
	{0x8c3d,0xff},
	{0x8c3e,0xe5},
	{0x8c3f,0x66},
	{0x8c40,0x94},
	{0x8c41,0x03},
	{0x8c42,0x40},
	{0x8c43,0x06},
	{0x8c44,0x7e},
	{0x8c45,0x03},
	{0x8c46,0x7f},
	{0x8c47,0xff},
	{0x8c48,0x80},
	{0x8c49,0x04},
	{0x8c4a,0xae},
	{0x8c4b,0x66},
	{0x8c4c,0xaf},
	{0x8c4d,0x67},
	{0x8c4e,0x8e},
	{0x8c4f,0x66},
	{0x8c50,0x8f},
	{0x8c51,0x67},
	{0x8c52,0x85},
	{0x8c53,0x66},
	{0x8c54,0x64},
	{0x8c55,0x85},
	{0x8c56,0x67},
	{0x8c57,0x65},
	{0x8c58,0xe5},
	{0x8c59,0x67},
	{0x8c5a,0xc4},
	{0x8c5b,0xf8},
	{0x8c5c,0x54},
	{0x8c5d,0x0f},
	{0x8c5e,0xc8},
	{0x8c5f,0x68},
	{0x8c60,0xf5},
	{0x8c61,0x67},
	{0x8c62,0xe5},
	{0x8c63,0x66},
	{0x8c64,0xc4},
	{0x8c65,0x54},
	{0x8c66,0xf0},
	{0x8c67,0x48},
	{0x8c68,0xf5},
	{0x8c69,0x66},
	{0x8c6a,0x85},
	{0x8c6b,0x66},
	{0x8c6c,0x11},
	{0x8c6d,0x85},
	{0x8c6e,0x67},
	{0x8c6f,0x12},
	{0x8c70,0x12},
	{0x8c71,0x0a},
	{0x8c72,0x20},
	{0x8c73,0xe4},
	{0x8c74,0xf5},
	{0x8c75,0x67},
	{0x8c76,0xf5},
	{0x8c77,0x67},
	{0x8c78,0xe5},
	{0x8c79,0x67},
	{0x8c7a,0xd3},
	{0x8c7b,0x95},
	{0x8c7c,0x7c},
	{0x8c7d,0x50},
	{0x8c7e,0x21},
	{0x8c7f,0x12},
	{0x8c80,0x01},
	{0x8c81,0x88},
	{0x8c82,0xaf},
	{0x8c83,0x67},
	{0x8c84,0x75},
	{0x8c85,0xf0},
	{0x8c86,0x02},
	{0x8c87,0xef},
	{0x8c88,0x12},
	{0x8c89,0x09},
	{0x8c8a,0xee},
	{0x8c8b,0xc3},
	{0x8c8c,0x74},
	{0x8c8d,0x01},
	{0x8c8e,0x93},
	{0x8c8f,0x95},
	{0x8c90,0x69},
	{0x8c91,0xe4},
	{0x8c92,0x93},
	{0x8c93,0x95},
	{0x8c94,0x68},
	{0x8c95,0x40},
	{0x8c96,0x05},
	{0x8c97,0x85},
	{0x8c98,0x67},
	{0x8c99,0x7d},
	{0x8c9a,0x80},
	{0x8c9b,0x04},
	{0x8c9c,0x05},
	{0x8c9d,0x67},
	{0x8c9e,0x80},
	{0x8c9f,0xd8},
	{0x8ca0,0x90},
	{0x8ca1,0x30},
	{0x8ca2,0x25},
	{0x8ca3,0xe4},
	{0x8ca4,0xf0},
	{0x8ca5,0xd2},
	{0x8ca6,0x34},
	{0x8ca7,0x22},
	{0x8ca8,0xe5},
	{0x8ca9,0x33},
	{0x8caa,0x70},
	{0x8cab,0x03},
	{0x8cac,0x02},
	{0x8cad,0x0d},
	{0x8cae,0xd0},
	{0x8caf,0xc2},
	{0x8cb0,0xaf},
	{0x8cb1,0xaf},
	{0x8cb2,0x33},
	{0x8cb3,0xe4},
	{0x8cb4,0xf5},
	{0x8cb5,0x33},
	{0x8cb6,0xd2},
	{0x8cb7,0xaf},
	{0x8cb8,0x90},
	{0x8cb9,0x30},
	{0x8cba,0x25},
	{0x8cbb,0xe0},
	{0x8cbc,0xf5},
	{0x8cbd,0x7e},
	{0x8cbe,0x90},
	{0x8cbf,0x50},
	{0x8cc0,0x82},
	{0x8cc1,0xe0},
	{0x8cc2,0xf5},
	{0x8cc3,0x66},
	{0x8cc4,0xa3},
	{0x8cc5,0xe0},
	{0x8cc6,0xf5},
	{0x8cc7,0x67},
	{0x8cc8,0xa3},
	{0x8cc9,0xe0},
	{0x8cca,0xf5},
	{0x8ccb,0x68},
	{0x8ccc,0xa3},
	{0x8ccd,0xe0},
	{0x8cce,0xf5},
	{0x8ccf,0x69},
	{0x8cd0,0xef},
	{0x8cd1,0x12},
	{0x8cd2,0x09},
	{0x8cd3,0xfa},
	{0x8cd4,0x0c},
	{0x8cd5,0xfc},
	{0x8cd6,0x03},
	{0x8cd7,0x0d},
	{0x8cd8,0x14},
	{0x8cd9,0x04},
	{0x8cda,0x0d},
	{0x8cdb,0x2f},
	{0x8cdc,0x05},
	{0x8cdd,0x0d},
	{0x8cde,0x53},
	{0x8cdf,0x06},
	{0x8ce0,0x0d},
	{0x8ce1,0x41},
	{0x8ce2,0x08},
	{0x8ce3,0x0d},
	{0x8ce4,0x60},
	{0x8ce5,0x10},
	{0x8ce6,0x0d},
	{0x8ce7,0x74},
	{0x8ce8,0x12},
	{0x8ce9,0x0d},
	{0x8cea,0x79},
	{0x8ceb,0x20},
	{0x8cec,0x0d},
	{0x8ced,0x87},
	{0x8cee,0x21},
	{0x8cef,0x0d},
	{0x8cf0,0x8c},
	{0x8cf1,0x30},
	{0x8cf2,0x0d},
	{0x8cf3,0xb5},
	{0x8cf4,0x50},
	{0x8cf5,0x0d},
	{0x8cf6,0x97},
	{0x8cf7,0xd8},
	{0x8cf8,0x00},
	{0x8cf9,0x00},
	{0x8cfa,0x0d},
	{0x8cfb,0xc2},
	{0x8cfc,0x30},
	{0x8cfd,0x00},
	{0x8cfe,0x03},
	{0x8cff,0x02},
	{0x8d00,0x0d},
	{0x8d01,0xc2},
	{0x8d02,0x20},
	{0x8d03,0x07},
	{0x8d04,0x06},
	{0x8d05,0x20},
	{0x8d06,0x06},
	{0x8d07,0x03},
	{0x8d08,0xc3},
	{0x8d09,0x80},
	{0x8d0a,0x01},
	{0x8d0b,0xd3},
	{0x8d0c,0x92},
	{0x8d0d,0x36},
	{0x8d0e,0xd2},
	{0x8d0f,0x07},
	{0x8d10,0xc2},
	{0x8d11,0x06},
	{0x8d12,0x80},
	{0x8d13,0x16},
	{0x8d14,0x30},
	{0x8d15,0x00},
	{0x8d16,0x03},
	{0x8d17,0x02},
	{0x8d18,0x0d},
	{0x8d19,0xc2},
	{0x8d1a,0x20},
	{0x8d1b,0x07},
	{0x8d1c,0x06},
	{0x8d1d,0x20},
	{0x8d1e,0x06},
	{0x8d1f,0x03},
	{0x8d20,0xc3},
	{0x8d21,0x80},
	{0x8d22,0x01},
	{0x8d23,0xd3},
	{0x8d24,0x92},
	{0x8d25,0x36},
	{0x8d26,0xd2},
	{0x8d27,0x07},
	{0x8d28,0xd2},
	{0x8d29,0x06},
	{0x8d2a,0x12},
	{0x8d2b,0x02},
	{0x8d2c,0x9d},
	{0x8d2d,0x80},
	{0x8d2e,0x1e},
	{0x8d2f,0x30},
	{0x8d30,0x00},
	{0x8d31,0x03},
	{0x8d32,0x02},
	{0x8d33,0x0d},
	{0x8d34,0xc2},
	{0x8d35,0xc2},
	{0x8d36,0x07},
	{0x8d37,0xd2},
	{0x8d38,0x06},
	{0x8d39,0x12},
	{0x8d3a,0x02},
	{0x8d3b,0xa8},
	{0x8d3c,0xc2},
	{0x8d3d,0x04},
	{0x8d3e,0x02},
	{0x8d3f,0x0d},
	{0x8d40,0xc2},
	{0x8d41,0x12},
	{0x8d42,0x02},
	{0x8d43,0x64},
	{0x8d44,0x30},
	{0x8d45,0x05},
	{0x8d46,0x06},
	{0x8d47,0xe4},
	{0x8d48,0xf5},
	{0x8d49,0x0c},
	{0x8d4a,0x12},
	{0x8d4b,0x0e},
	{0x8d4c,0xf9},
	{0x8d4d,0xc2},
	{0x8d4e,0x31},
	{0x8d4f,0xd2},
	{0x8d50,0x34},
	{0x8d51,0x80},
	{0x8d52,0x6f},
	{0x8d53,0x30},
	{0x8d54,0x07},
	{0x8d55,0x6c},
	{0x8d56,0x30},
	{0x8d57,0x06},
	{0x8d58,0x69},
	{0x8d59,0x12},
	{0x8d5a,0x02},
	{0x8d5b,0x9d},
	{0x8d5c,0xd2},
	{0x8d5d,0x31},
	{0x8d5e,0x80},
	{0x8d5f,0x62},
	{0x8d60,0x20},
	{0x8d61,0x07},
	{0x8d62,0x03},
	{0x8d63,0x30},
	{0x8d64,0x06},
	{0x8d65,0x09},
	{0x8d66,0xe5},
	{0x8d67,0x7e},
	{0x8d68,0x64},
	{0x8d69,0x0e},
	{0x8d6a,0x70},
	{0x8d6b,0x56},
	{0x8d6c,0x20},
	{0x8d6d,0x00},
	{0x8d6e,0x53},
	{0x8d6f,0x12},
	{0x8d70,0x05},
	{0x8d71,0x32},
	{0x8d72,0x80},
	{0x8d73,0x4e},
	{0x8d74,0x12},
	{0x8d75,0x06},
	{0x8d76,0xfb},
	{0x8d77,0x80},
	{0x8d78,0x49},
	{0x8d79,0x30},
	{0x8d7a,0x05},
	{0x8d7b,0x46},
	{0x8d7c,0x20},
	{0x8d7d,0x07},
	{0x8d7e,0x43},
	{0x8d7f,0x20},
	{0x8d80,0x06},
	{0x8d81,0x40},
	{0x8d82,0x12},
	{0x8d83,0x17},
	{0x8d84,0x5c},
	{0x8d85,0x80},
	{0x8d86,0x3b},
	{0x8d87,0x12},
	{0x8d88,0x10},
	{0x8d89,0x4b},
	{0x8d8a,0x80},
	{0x8d8b,0x36},
	{0x8d8c,0x20},
	{0x8d8d,0x07},
	{0x8d8e,0x33},
	{0x8d8f,0x20},
	{0x8d90,0x06},
	{0x8d91,0x30},
	{0x8d92,0x12},
	{0x8d93,0x17},
	{0x8d94,0x6b},
	{0x8d95,0x80},
	{0x8d96,0x2b},
	{0x8d97,0xe5},
	{0x8d98,0x7e},
	{0x8d99,0x64},
	{0x8d9a,0x01},
	{0x8d9b,0x70},
	{0x8d9c,0x25},
	{0x8d9d,0xd2},
	{0x8d9e,0x35},
	{0x8d9f,0x90},
	{0x8da0,0x50},
	{0x8da1,0x82},
	{0x8da2,0xe5},
	{0x8da3,0x74},
	{0x8da4,0xf0},
	{0x8da5,0xa3},
	{0x8da6,0xe5},
	{0x8da7,0x75},
	{0x8da8,0xf0},
	{0x8da9,0xa3},
	{0x8daa,0xe5},
	{0x8dab,0x76},
	{0x8dac,0xf0},
	{0x8dad,0xa3},
	{0x8dae,0xe5},
	{0x8daf,0x77},
	{0x8db0,0xf0},
	{0x8db1,0xc2},
	{0x8db2,0x35},
	{0x8db3,0x80},
	{0x8db4,0x0d},
	{0x8db5,0x90},
	{0x8db6,0x50},
	{0x8db7,0x82},
	{0x8db8,0x30},
	{0x8db9,0x33},
	{0x8dba,0x05},
	{0x8dbb,0x74},
	{0x8dbc,0x55},
	{0x8dbd,0xf0},
	{0x8dbe,0x80},
	{0x8dbf,0x02},
	{0x8dc0,0xe4},
	{0x8dc1,0xf0},
	{0x8dc2,0x20},
	{0x8dc3,0x07},
	{0x8dc4,0x06},
	{0x8dc5,0x30},
	{0x8dc6,0x06},
	{0x8dc7,0x03},
	{0x8dc8,0x30},
	{0x8dc9,0x04},
	{0x8dca,0x05},
	{0x8dcb,0x90},
	{0x8dcc,0x30},
	{0x8dcd,0x25},
	{0x8dce,0xe4},
	{0x8dcf,0xf0},
	{0x8dd0,0x22},
	{0x8dd1,0xc0},
	{0x8dd2,0xe0},
	{0x8dd3,0xc0},
	{0x8dd4,0xf0},
	{0x8dd5,0xc0},
	{0x8dd6,0x83},
	{0x8dd7,0xc0},
	{0x8dd8,0x82},
	{0x8dd9,0xc0},
	{0x8dda,0xd0},
	{0x8ddb,0x75},
	{0x8ddc,0xd0},
	{0x8ddd,0x00},
	{0x8dde,0xc0},
	{0x8ddf,0x00},
	{0x8de0,0xc0},
	{0x8de1,0x01},
	{0x8de2,0xc0},
	{0x8de3,0x02},
	{0x8de4,0xc0},
	{0x8de5,0x03},
	{0x8de6,0xc0},
	{0x8de7,0x04},
	{0x8de8,0xc0},
	{0x8de9,0x05},
	{0x8dea,0xc0},
	{0x8deb,0x06},
	{0x8dec,0xc0},
	{0x8ded,0x07},
	{0x8dee,0x90},
	{0x8def,0x3f},
	{0x8df0,0x0c},
	{0x8df1,0xe0},
	{0x8df2,0xf5},
	{0x8df3,0x08},
	{0x8df4,0xe5},
	{0x8df5,0x08},
	{0x8df6,0x20},
	{0x8df7,0xe3},
	{0x8df8,0x03},
	{0x8df9,0x02},
	{0x8dfa,0x0e},
	{0x8dfb,0x82},
	{0x8dfc,0x30},
	{0x8dfd,0x35},
	{0x8dfe,0x03},
	{0x8dff,0x02},
	{0x8e00,0x0e},
	{0x8e01,0x82},
	{0x8e02,0x90},
	{0x8e03,0x60},
	{0x8e04,0x16},
	{0x8e05,0xe0},
	{0x8e06,0xf5},
	{0x8e07,0x6a},
	{0x8e08,0xa3},
	{0x8e09,0xe0},
	{0x8e0a,0xf5},
	{0x8e0b,0x6b},
	{0x8e0c,0x90},
	{0x8e0d,0x60},
	{0x8e0e,0x1e},
	{0x8e0f,0xe0},
	{0x8e10,0xf5},
	{0x8e11,0x6c},
	{0x8e12,0xa3},
	{0x8e13,0xe0},
	{0x8e14,0xf5},
	{0x8e15,0x6d},
	{0x8e16,0x90},
	{0x8e17,0x60},
	{0x8e18,0x26},
	{0x8e19,0xe0},
	{0x8e1a,0xf5},
	{0x8e1b,0x6e},
	{0x8e1c,0xa3},
	{0x8e1d,0xe0},
	{0x8e1e,0xf5},
	{0x8e1f,0x6f},
	{0x8e20,0x90},
	{0x8e21,0x60},
	{0x8e22,0x2e},
	{0x8e23,0xe0},
	{0x8e24,0xf5},
	{0x8e25,0x70},
	{0x8e26,0xa3},
	{0x8e27,0xe0},
	{0x8e28,0xf5},
	{0x8e29,0x71},
	{0x8e2a,0x90},
	{0x8e2b,0x60},
	{0x8e2c,0x36},
	{0x8e2d,0x12},
	{0x8e2e,0x00},
	{0x8e2f,0x16},
	{0x8e30,0x12},
	{0x8e31,0x01},
	{0x8e32,0xbc},
	{0x8e33,0x40},
	{0x8e34,0x06},
	{0x8e35,0x75},
	{0x8e36,0x2a},
	{0x8e37,0xff},
	{0x8e38,0x75},
	{0x8e39,0x2b},
	{0x8e3a,0xff},
	{0x8e3b,0x85},
	{0x8e3c,0x2a},
	{0x8e3d,0x74},
	{0x8e3e,0x85},
	{0x8e3f,0x2b},
	{0x8e40,0x75},
	{0x8e41,0x90},
	{0x8e42,0x60},
	{0x8e43,0x1a},
	{0x8e44,0xe0},
	{0x8e45,0xf5},
	{0x8e46,0x6a},
	{0x8e47,0xa3},
	{0x8e48,0xe0},
	{0x8e49,0xf5},
	{0x8e4a,0x6b},
	{0x8e4b,0x90},
	{0x8e4c,0x60},
	{0x8e4d,0x22},
	{0x8e4e,0xe0},
	{0x8e4f,0xf5},
	{0x8e50,0x6c},
	{0x8e51,0xa3},
	{0x8e52,0xe0},
	{0x8e53,0xf5},
	{0x8e54,0x6d},
	{0x8e55,0x90},
	{0x8e56,0x60},
	{0x8e57,0x2a},
	{0x8e58,0xe0},
	{0x8e59,0xf5},
	{0x8e5a,0x6e},
	{0x8e5b,0xa3},
	{0x8e5c,0xe0},
	{0x8e5d,0xf5},
	{0x8e5e,0x6f},
	{0x8e5f,0x90},
	{0x8e60,0x60},
	{0x8e61,0x32},
	{0x8e62,0xe0},
	{0x8e63,0xf5},
	{0x8e64,0x70},
	{0x8e65,0xa3},
	{0x8e66,0xe0},
	{0x8e67,0xf5},
	{0x8e68,0x71},
	{0x8e69,0x90},
	{0x8e6a,0x60},
	{0x8e6b,0x3a},
	{0x8e6c,0x12},
	{0x8e6d,0x00},
	{0x8e6e,0x16},
	{0x8e6f,0x12},
	{0x8e70,0x01},
	{0x8e71,0xbc},
	{0x8e72,0x40},
	{0x8e73,0x06},
	{0x8e74,0x75},
	{0x8e75,0x2a},
	{0x8e76,0xff},
	{0x8e77,0x75},
	{0x8e78,0x2b},
	{0x8e79,0xff},
	{0x8e7a,0x85},
	{0x8e7b,0x2a},
	{0x8e7c,0x76},
	{0x8e7d,0x85},
	{0x8e7e,0x2b},
	{0x8e7f,0x77},
	{0x8e80,0xd2},
	{0x8e81,0x3d},
	{0x8e82,0xe5},
	{0x8e83,0x08},
	{0x8e84,0x30},
	{0x8e85,0xe5},
	{0x8e86,0x44},
	{0x8e87,0x90},
	{0x8e88,0x56},
	{0x8e89,0x90},
	{0x8e8a,0xe0},
	{0x8e8b,0xf5},
	{0x8e8c,0x55},
	{0x8e8d,0xe5},
	{0x8e8e,0x7b},
	{0x8e8f,0x24},
	{0x8e90,0x02},
	{0x8e91,0xff},
	{0x8e92,0xe4},
	{0x8e93,0x33},
	{0x8e94,0xfe},
	{0x8e95,0xad},
	{0x8e96,0x55},
	{0x8e97,0xc3},
	{0x8e98,0xef},
	{0x8e99,0x9d},
	{0x8e9a,0x74},
	{0x8e9b,0x80},
	{0x8e9c,0xf8},
	{0x8e9d,0x6e},
	{0x8e9e,0x98},
	{0x8e9f,0x50},
	{0x8ea0,0x02},
	{0x8ea1,0x80},
	{0x8ea2,0x01},
	{0x8ea3,0xc3},
	{0x8ea4,0x92},
	{0x8ea5,0x27},
	{0x8ea6,0xaf},
	{0x8ea7,0x55},
	{0x8ea8,0xef},
	{0x8ea9,0x24},
	{0x8eaa,0x02},
	{0x8eab,0xff},
	{0x8eac,0xe4},
	{0x8ead,0x33},
	{0x8eae,0xfe},
	{0x8eaf,0xc3},
	{0x8eb0,0xef},
	{0x8eb1,0x95},
	{0x8eb2,0x7b},
	{0x8eb3,0x74},
	{0x8eb4,0x80},
	{0x8eb5,0xf8},
	{0x8eb6,0x6e},
	{0x8eb7,0x98},
	{0x8eb8,0x50},
	{0x8eb9,0x02},
	{0x8eba,0x80},
	{0x8ebb,0x02},
	{0x8ebc,0xa2},
	{0x8ebd,0x27},
	{0x8ebe,0x92},
	{0x8ebf,0x27},
	{0x8ec0,0x30},
	{0x8ec1,0x27},
	{0x8ec2,0x04},
	{0x8ec3,0xaf},
	{0x8ec4,0x55},
	{0x8ec5,0x80},
	{0x8ec6,0x02},
	{0x8ec7,0xaf},
	{0x8ec8,0x7b},
	{0x8ec9,0x8f},
	{0x8eca,0x7b},
	{0x8ecb,0xe5},
	{0x8ecc,0x08},
	{0x8ecd,0x30},
	{0x8ece,0xe1},
	{0x8ecf,0x08},
	{0x8ed0,0x90},
	{0x8ed1,0x30},
	{0x8ed2,0x24},
	{0x8ed3,0xe0},
	{0x8ed4,0xf5},
	{0x8ed5,0x33},
	{0x8ed6,0xe4},
	{0x8ed7,0xf0},
	{0x8ed8,0x90},
	{0x8ed9,0x3f},
	{0x8eda,0x0c},
	{0x8edb,0xe5},
	{0x8edc,0x08},
	{0x8edd,0xf0},
	{0x8ede,0xd0},
	{0x8edf,0x07},
	{0x8ee0,0xd0},
	{0x8ee1,0x06},
	{0x8ee2,0xd0},
	{0x8ee3,0x05},
	{0x8ee4,0xd0},
	{0x8ee5,0x04},
	{0x8ee6,0xd0},
	{0x8ee7,0x03},
	{0x8ee8,0xd0},
	{0x8ee9,0x02},
	{0x8eea,0xd0},
	{0x8eeb,0x01},
	{0x8eec,0xd0},
	{0x8eed,0x00},
	{0x8eee,0xd0},
	{0x8eef,0xd0},
	{0x8ef0,0xd0},
	{0x8ef1,0x82},
	{0x8ef2,0xd0},
	{0x8ef3,0x83},
	{0x8ef4,0xd0},
	{0x8ef5,0xf0},
	{0x8ef6,0xd0},
	{0x8ef7,0xe0},
	{0x8ef8,0x32},
	{0x8ef9,0xe5},
	{0x8efa,0x0c},
	{0x8efb,0xd3},
	{0x8efc,0x95},
	{0x8efd,0x7c},
	{0x8efe,0x40},
	{0x8eff,0x01},
	{0x8f00,0x22},
	{0x8f01,0x12},
	{0x8f02,0x01},
	{0x8f03,0x88},
	{0x8f04,0x75},
	{0x8f05,0xf0},
	{0x8f06,0x02},
	{0x8f07,0xe5},
	{0x8f08,0x0c},
	{0x8f09,0x12},
	{0x8f0a,0x09},
	{0x8f0b,0xee},
	{0x8f0c,0xe4},
	{0x8f0d,0x93},
	{0x8f0e,0xf5},
	{0x8f0f,0x0d},
	{0x8f10,0x74},
	{0x8f11,0x01},
	{0x8f12,0x93},
	{0x8f13,0xf5},
	{0x8f14,0x0e},
	{0x8f15,0x45},
	{0x8f16,0x0d},
	{0x8f17,0x70},
	{0x8f18,0x08},
	{0x8f19,0x85},
	{0x8f1a,0x64},
	{0x8f1b,0x0f},
	{0x8f1c,0x85},
	{0x8f1d,0x65},
	{0x8f1e,0x10},
	{0x8f1f,0x80},
	{0x8f20,0x13},
	{0x8f21,0x12},
	{0x8f22,0x01},
	{0x8f23,0xe4},
	{0x8f24,0xf5},
	{0x8f25,0x11},
	{0x8f26,0x85},
	{0x8f27,0x0e},
	{0x8f28,0x12},
	{0x8f29,0x12},
	{0x8f2a,0x0a},
	{0x8f2b,0x20},
	{0x8f2c,0x30},
	{0x8f2d,0x33},
	{0x8f2e,0x02},
	{0x8f2f,0xc3},
	{0x8f30,0x22},
	{0x8f31,0x02},
	{0x8f32,0x0f},
	{0x8f33,0xa6},
	{0x8f34,0xd3},
	{0x8f35,0xe5},
	{0x8f36,0x10},
	{0x8f37,0x94},
	{0x8f38,0x64},
	{0x8f39,0xe5},
	{0x8f3a,0x0f},
	{0x8f3b,0x94},
	{0x8f3c,0x00},
	{0x8f3d,0x40},
	{0x8f3e,0x39},
	{0x8f3f,0xd3},
	{0x8f40,0xe5},
	{0x8f41,0x10},
	{0x8f42,0x94},
	{0x8f43,0xf4},
	{0x8f44,0xe5},
	{0x8f45,0x0f},
	{0x8f46,0x94},
	{0x8f47,0x01},
	{0x8f48,0x40},
	{0x8f49,0x08},
	{0x8f4a,0x75},
	{0x8f4b,0x0f},
	{0x8f4c,0x01},
	{0x8f4d,0x75},
	{0x8f4e,0x10},
	{0x8f4f,0xc2},
	{0x8f50,0x80},
	{0x8f51,0x1b},
	{0x8f52,0xd3},
	{0x8f53,0xe5},
	{0x8f54,0x10},
	{0x8f55,0x94},
	{0x8f56,0x5e},
	{0x8f57,0xe5},
	{0x8f58,0x0f},
	{0x8f59,0x94},
	{0x8f5a,0x01},
	{0x8f5b,0x40},
	{0x8f5c,0x04},
	{0x8f5d,0x74},
	{0x8f5e,0xce},
	{0x8f5f,0x80},
	{0x8f60,0x02},
	{0x8f61,0x74},
	{0x8f62,0xe2},
	{0x8f63,0x25},
	{0x8f64,0x10},
	{0x8f65,0xf5},
	{0x8f66,0x10},
	{0x8f67,0x74},
	{0x8f68,0xff},
	{0x8f69,0x35},
	{0x8f6a,0x0f},
	{0x8f6b,0xf5},
	{0x8f6c,0x0f},
	{0x8f6d,0x85},
	{0x8f6e,0x0f},
	{0x8f6f,0x0d},
	{0x8f70,0x85},
	{0x8f71,0x10},
	{0x8f72,0x0e},
	{0x8f73,0x12},
	{0x8f74,0x01},
	{0x8f75,0xe4},
	{0x8f76,0x80},
	{0x8f77,0x0e},
	{0x8f78,0xe4},
	{0x8f79,0xf5},
	{0x8f7a,0x0f},
	{0x8f7b,0xf5},
	{0x8f7c,0x10},
	{0x8f7d,0x75},
	{0x8f7e,0x0d},
	{0x8f7f,0x80},
	{0x8f80,0xf5},
	{0x8f81,0x0e},
	{0x8f82,0xf5},
	{0x8f83,0x64},
	{0x8f84,0xf5},
	{0x8f85,0x65},
	{0x8f86,0x85},
	{0x8f87,0x0d},
	{0x8f88,0x11},
	{0x8f89,0x85},
	{0x8f8a,0x0e},
	{0x8f8b,0x12},
	{0x8f8c,0x12},
	{0x8f8d,0x0a},
	{0x8f8e,0x20},
	{0x8f8f,0x30},
	{0x8f90,0x33},
	{0x8f91,0x02},
	{0x8f92,0xc3},
	{0x8f93,0x22},
	{0x8f94,0xe5},
	{0x8f95,0x10},
	{0x8f96,0x45},
	{0x8f97,0x0f},
	{0x8f98,0x60},
	{0x8f99,0x0c},
	{0x8f9a,0x75},
	{0x8f9b,0x11},
	{0x8f9c,0x00},
	{0x8f9d,0x75},
	{0x8f9e,0x12},
	{0x8f9f,0x32},
	{0x8fa0,0x12},
	{0x8fa1,0x16},
	{0x8fa2,0xd5},
	{0x8fa3,0x02},
	{0x8fa4,0x0f},
	{0x8fa5,0x34},
	{0x8fa6,0x85},
	{0x8fa7,0x0c},
	{0x8fa8,0x7d},
	{0x8fa9,0xd3},
	{0x8faa,0x22},
	{0x8fab,0x12},
	{0x8fac,0x02},
	{0x8fad,0x92},
	{0x8fae,0xb5},
	{0x8faf,0x07},
	{0x8fb0,0x03},
	{0x8fb1,0xd3},
	{0x8fb2,0x80},
	{0x8fb3,0x01},
	{0x8fb4,0xc3},
	{0x8fb5,0x40},
	{0x8fb6,0x03},
	{0x8fb7,0x02},
	{0x8fb8,0x10},
	{0x8fb9,0x4a},
	{0x8fba,0x90},
	{0x8fbb,0x30},
	{0x8fbc,0x04},
	{0x8fbd,0xe0},
	{0x8fbe,0x44},
	{0x8fbf,0x20},
	{0x8fc0,0xf0},
	{0x8fc1,0xa3},
	{0x8fc2,0xe0},
	{0x8fc3,0x44},
	{0x8fc4,0x40},
	{0x8fc5,0xf0},
	{0x8fc6,0x90},
	{0x8fc7,0x50},
	{0x8fc8,0x25},
	{0x8fc9,0xe0},
	{0x8fca,0x44},
	{0x8fcb,0x04},
	{0x8fcc,0xf0},
	{0x8fcd,0x90},
	{0x8fce,0x50},
	{0x8fcf,0x03},
	{0x8fd0,0xe0},
	{0x8fd1,0x54},
	{0x8fd2,0xfd},
	{0x8fd3,0xf0},
	{0x8fd4,0x90},
	{0x8fd5,0x50},
	{0x8fd6,0x27},
	{0x8fd7,0xe0},
	{0x8fd8,0x44},
	{0x8fd9,0x01},
	{0x8fda,0xf0},
	{0x8fdb,0x90},
	{0x8fdc,0x50},
	{0x8fdd,0x31},
	{0x8fde,0xe4},
	{0x8fdf,0xf0},
	{0x8fe0,0x90},
	{0x8fe1,0x50},
	{0x8fe2,0x33},
	{0x8fe3,0xf0},
	{0x8fe4,0x90},
	{0x8fe5,0x30},
	{0x8fe6,0x1e},
	{0x8fe7,0x12},
	{0x8fe8,0x02},
	{0x8fe9,0x1f},
	{0x8fea,0x90},
	{0x8feb,0x30},
	{0x8fec,0x18},
	{0x8fed,0x12},
	{0x8fee,0x02},
	{0x8fef,0x1f},
	{0x8ff0,0x90},
	{0x8ff1,0x30},
	{0x8ff2,0x1b},
	{0x8ff3,0x12},
	{0x8ff4,0x02},
	{0x8ff5,0x1f},
	{0x8ff6,0xe0},
	{0x8ff7,0xf5},
	{0x8ff8,0x25},
	{0x8ff9,0x90},
	{0x8ffa,0x30},
	{0x8ffb,0x18},
	{0x8ffc,0xe0},
	{0x8ffd,0xf5},
	{0x8ffe,0x21},
	{0x8fff,0x90},
	{0x9000,0x60},
	{0x9001,0x00},
	{0x9002,0x74},
	{0x9003,0xf5},
	{0x9004,0xf0},
	{0x9005,0x90},
	{0x9006,0x3f},
	{0x9007,0x01},
	{0x9008,0xe4},
	{0x9009,0xf0},
	{0x900a,0xa3},
	{0x900b,0xf0},
	{0x900c,0x90},
	{0x900d,0x3f},
	{0x900e,0x01},
	{0x900f,0xe0},
	{0x9010,0x44},
	{0x9011,0x08},
	{0x9012,0xf0},
	{0x9013,0xe0},
	{0x9014,0x44},
	{0x9015,0x20},
	{0x9016,0xf0},
	{0x9017,0x90},
	{0x9018,0x3f},
	{0x9019,0x05},
	{0x901a,0x74},
	{0x901b,0x30},
	{0x901c,0xf0},
	{0x901d,0xa3},
	{0x901e,0x74},
	{0x901f,0x24},
	{0x9020,0xf0},
	{0x9021,0x90},
	{0x9022,0x3f},
	{0x9023,0x0b},
	{0x9024,0xe0},
	{0x9025,0x44},
	{0x9026,0x0f},
	{0x9027,0xf0},
	{0x9028,0x90},
	{0x9029,0x3f},
	{0x902a,0x01},
	{0x902b,0xe0},
	{0x902c,0x44},
	{0x902d,0x02},
	{0x902e,0xf0},
	{0x902f,0xc2},
	{0x9030,0x8c},
	{0x9031,0x75},
	{0x9032,0x89},
	{0x9033,0x03},
	{0x9034,0x75},
	{0x9035,0xa8},
	{0x9036,0x07},
	{0x9037,0x75},
	{0x9038,0xb8},
	{0x9039,0x04},
	{0x903a,0xe4},
	{0x903b,0xf5},
	{0x903c,0xd8},
	{0x903d,0xf5},
	{0x903e,0xe8},
	{0x903f,0x90},
	{0x9040,0x30},
	{0x9041,0x01},
	{0x9042,0xe0},
	{0x9043,0x44},
	{0x9044,0x40},
	{0x9045,0xf0},
	{0x9046,0xe0},
	{0x9047,0x54},
	{0x9048,0xbf},
	{0x9049,0xf0},
	{0x904a,0x22},
	{0x904b,0xe5},
	{0x904c,0x7e},
	{0x904d,0x64},
	{0x904e,0x01},
	{0x904f,0x70},
	{0x9050,0x4f},
	{0x9051,0x12},
	{0x9052,0x01},
	{0x9053,0x88},
	{0x9054,0xe5},
	{0x9055,0x7d},
	{0x9056,0x12},
	{0x9057,0x01},
	{0x9058,0x7b},
	{0x9059,0x12},
	{0x905a,0x02},
	{0x905b,0x11},
	{0x905c,0xfe},
	{0x905d,0xe4},
	{0x905e,0x8f},
	{0x905f,0x69},
	{0x9060,0x8e},
	{0x9061,0x68},
	{0x9062,0xf5},
	{0x9063,0x67},
	{0x9064,0xf5},
	{0x9065,0x66},
	{0x9066,0x12},
	{0x9067,0x02},
	{0x9068,0x08},
	{0x9069,0x7b},
	{0x906a,0xff},
	{0x906b,0xfa},
	{0x906c,0xf9},
	{0x906d,0xf8},
	{0x906e,0x12},
	{0x906f,0x01},
	{0x9070,0xfd},
	{0x9071,0xc0},
	{0x9072,0x04},
	{0x9073,0xc0},
	{0x9074,0x05},
	{0x9075,0xc0},
	{0x9076,0x06},
	{0x9077,0xc0},
	{0x9078,0x07},
	{0x9079,0x12},
	{0x907a,0x01},
	{0x907b,0x73},
	{0x907c,0x12},
	{0x907d,0x02},
	{0x907e,0x11},
	{0x907f,0xab},
	{0x9080,0x07},
	{0x9081,0xfa},
	{0x9082,0xe4},
	{0x9083,0xf9},
	{0x9084,0xf8},
	{0x9085,0xd0},
	{0x9086,0x07},
	{0x9087,0xd0},
	{0x9088,0x06},
	{0x9089,0xd0},
	{0x908a,0x05},
	{0x908b,0xd0},
	{0x908c,0x04},
	{0x908d,0x12},
	{0x908e,0x02},
	{0x908f,0x7a},
	{0x9090,0x85},
	{0x9091,0x69},
	{0x9092,0x66},
	{0x9093,0x85},
	{0x9094,0x7d},
	{0x9095,0x67},
	{0x9096,0x12},
	{0x9097,0x01},
	{0x9098,0x88},
	{0x9099,0x75},
	{0x909a,0xf0},
	{0x909b,0x02},
	{0x909c,0xe5},
	{0x909d,0x7d},
	{0x909e,0x80},
	{0x909f,0x1d},
	{0x90a0,0xe5},
	{0x90a1,0x7e},
	{0x90a2,0xb4},
	{0x90a3,0x02},
	{0x90a4,0x08},
	{0x90a5,0xe4},
	{0x90a6,0xf5},
	{0x90a7,0x67},
	{0x90a8,0x12},
	{0x90a9,0x01},
	{0x90aa,0x88},
	{0x90ab,0x80},
	{0x90ac,0x14},
	{0x90ad,0xe5},
	{0x90ae,0x7e},
	{0x90af,0xb4},
	{0x90b0,0x03},
	{0x90b1,0x17},
	{0x90b2,0x85},
	{0x90b3,0x7c},
	{0x90b4,0x67},
	{0x90b5,0x12},
	{0x90b6,0x01},
	{0x90b7,0x88},
	{0x90b8,0x75},
	{0x90b9,0xf0},
	{0x90ba,0x02},
	{0x90bb,0xe5},
	{0x90bc,0x7c},
	{0x90bd,0x12},
	{0x90be,0x09},
	{0x90bf,0xee},
	{0x90c0,0xe4},
	{0x90c1,0x93},
	{0x90c2,0xf5},
	{0x90c3,0x68},
	{0x90c4,0x74},
	{0x90c5,0x01},
	{0x90c6,0x93},
	{0x90c7,0xf5},
	{0x90c8,0x69},
	{0x90c9,0x90},
	{0x90ca,0x50},
	{0x90cb,0x82},
	{0x90cc,0xe5},
	{0x90cd,0x66},
	{0x90ce,0xf0},
	{0x90cf,0xa3},
	{0x90d0,0xe5},
	{0x90d1,0x67},
	{0x90d2,0xf0},
	{0x90d3,0xa3},
	{0x90d4,0xe5},
	{0x90d5,0x68},
	{0x90d6,0xf0},
	{0x90d7,0xa3},
	{0x90d8,0xe5},
	{0x90d9,0x69},
	{0x90da,0xf0},
	{0x90db,0x22},
	{0x90dc,0x30},
	{0x90dd,0x3e},
	{0x90de,0x09},
	{0x90df,0x30},
	{0x90e0,0x20},
	{0x90e1,0x06},
	{0x90e2,0xae},
	{0x90e3,0x56},
	{0x90e4,0xaf},
	{0x90e5,0x57},
	{0x90e6,0x80},
	{0x90e7,0x04},
	{0x90e8,0xae},
	{0x90e9,0x6a},
	{0x90ea,0xaf},
	{0x90eb,0x6b},
	{0x90ec,0x8e},
	{0x90ed,0x56},
	{0x90ee,0x8f},
	{0x90ef,0x57},
	{0x90f0,0x30},
	{0x90f1,0x3e},
	{0x90f2,0x09},
	{0x90f3,0x30},
	{0x90f4,0x21},
	{0x90f5,0x06},
	{0x90f6,0xae},
	{0x90f7,0x58},
	{0x90f8,0xaf},
	{0x90f9,0x59},
	{0x90fa,0x80},
	{0x90fb,0x04},
	{0x90fc,0xae},
	{0x90fd,0x6c},
	{0x90fe,0xaf},
	{0x90ff,0x6d},
	{0x9100,0x8e},
	{0x9101,0x58},
	{0x9102,0x8f},
	{0x9103,0x59},
	{0x9104,0x30},
	{0x9105,0x3e},
	{0x9106,0x09},
	{0x9107,0x30},
	{0x9108,0x22},
	{0x9109,0x06},
	{0x910a,0xae},
	{0x910b,0x5a},
	{0x910c,0xaf},
	{0x910d,0x5b},
	{0x910e,0x80},
	{0x910f,0x04},
	{0x9110,0xae},
	{0x9111,0x6e},
	{0x9112,0xaf},
	{0x9113,0x6f},
	{0x9114,0x8e},
	{0x9115,0x5a},
	{0x9116,0x8f},
	{0x9117,0x5b},
	{0x9118,0x30},
	{0x9119,0x3e},
	{0x911a,0x09},
	{0x911b,0x30},
	{0x911c,0x23},
	{0x911d,0x06},
	{0x911e,0xae},
	{0x911f,0x5c},
	{0x9120,0xaf},
	{0x9121,0x5d},
	{0x9122,0x80},
	{0x9123,0x04},
	{0x9124,0xae},
	{0x9125,0x70},
	{0x9126,0xaf},
	{0x9127,0x71},
	{0x9128,0x8e},
	{0x9129,0x5c},
	{0x912a,0x8f},
	{0x912b,0x5d},
	{0x912c,0x30},
	{0x912d,0x3e},
	{0x912e,0x09},
	{0x912f,0x30},
	{0x9130,0x24},
	{0x9131,0x06},
	{0x9132,0xae},
	{0x9133,0x5e},
	{0x9134,0xaf},
	{0x9135,0x5f},
	{0x9136,0x80},
	{0x9137,0x04},
	{0x9138,0xae},
	{0x9139,0x72},
	{0x913a,0xaf},
	{0x913b,0x73},
	{0x913c,0x8e},
	{0x913d,0x5e},
	{0x913e,0x8f},
	{0x913f,0x5f},
	{0x9140,0x30},
	{0x9141,0x3e},
	{0x9142,0x09},
	{0x9143,0x30},
	{0x9144,0x25},
	{0x9145,0x06},
	{0x9146,0xae},
	{0x9147,0x60},
	{0x9148,0xaf},
	{0x9149,0x61},
	{0x914a,0x80},
	{0x914b,0x04},
	{0x914c,0xae},
	{0x914d,0x74},
	{0x914e,0xaf},
	{0x914f,0x75},
	{0x9150,0x8e},
	{0x9151,0x60},
	{0x9152,0x8f},
	{0x9153,0x61},
	{0x9154,0x30},
	{0x9155,0x3e},
	{0x9156,0x09},
	{0x9157,0x30},
	{0x9158,0x26},
	{0x9159,0x06},
	{0x915a,0xae},
	{0x915b,0x62},
	{0x915c,0xaf},
	{0x915d,0x63},
	{0x915e,0x80},
	{0x915f,0x04},
	{0x9160,0xae},
	{0x9161,0x76},
	{0x9162,0xaf},
	{0x9163,0x77},
	{0x9164,0x8e},
	{0x9165,0x62},
	{0x9166,0x8f},
	{0x9167,0x63},
	{0x9168,0x22},
	{0x9169,0x30},
	{0x916a,0x36},
	{0x916b,0x4e},
	{0x916c,0x12},
	{0x916d,0x11},
	{0x916e,0xe1},
	{0x916f,0xe5},
	{0x9170,0x32},
	{0x9171,0xd3},
	{0x9172,0x95},
	{0x9173,0x7d},
	{0x9174,0x40},
	{0x9175,0x0c},
	{0x9176,0xe5},
	{0x9177,0x32},
	{0x9178,0x04},
	{0x9179,0xf5},
	{0x917a,0x0c},
	{0x917b,0x12},
	{0x917c,0x0e},
	{0x917d,0xf9},
	{0x917e,0xd2},
	{0x917f,0x37},
	{0x9180,0x80},
	{0x9181,0x44},
	{0x9182,0xe5},
	{0x9183,0x7c},
	{0x9184,0xb5},
	{0x9185,0x7d},
	{0x9186,0x04},
	{0x9187,0x7f},
	{0x9188,0x01},
	{0x9189,0x80},
	{0x918a,0x02},
	{0x918b,0x7f},
	{0x918c,0x00},
	{0x918d,0xef},
	{0x918e,0x24},
	{0x918f,0xfb},
	{0x9190,0xd3},
	{0x9191,0x64},
	{0x9192,0x80},
	{0x9193,0xf8},
	{0x9194,0xe5},
	{0x9195,0x7d},
	{0x9196,0x64},
	{0x9197,0x80},
	{0x9198,0x98},
	{0x9199,0x40},
	{0x919a,0x12},
	{0x919b,0xc2},
	{0x919c,0x37},
	{0x919d,0xe5},
	{0x919e,0x7c},
	{0x919f,0xb5},
	{0x91a0,0x7d},
	{0x91a1,0x04},
	{0x91a2,0x7f},
	{0x91a3,0x01},
	{0x91a4,0x80},
	{0x91a5,0x02},
	{0x91a6,0x7f},
	{0x91a7,0x00},
	{0x91a8,0xef},
	{0x91a9,0x24},
	{0x91aa,0xfa},
	{0x91ab,0x80},
	{0x91ac,0x06},
	{0x91ad,0xd2},
	{0x91ae,0x37},
	{0x91af,0xe5},
	{0x91b0,0x7d},
	{0x91b1,0x24},
	{0x91b2,0x02},
	{0x91b3,0xf5},
	{0x91b4,0x0c},
	{0x91b5,0x12},
	{0x91b6,0x0e},
	{0x91b7,0xf9},
	{0x91b8,0x80},
	{0x91b9,0x0c},
	{0x91ba,0xe5},
	{0x91bb,0x7d},
	{0x91bc,0x70},
	{0x91bd,0x0f},
	{0x91be,0x12},
	{0x91bf,0x11},
	{0x91c0,0xe1},
	{0x91c1,0xc2},
	{0x91c2,0x03},
	{0x91c3,0x12},
	{0x91c4,0x17},
	{0x91c5,0x3c},
	{0x91c6,0xd2},
	{0x91c7,0x02},
	{0x91c8,0xd2},
	{0x91c9,0x01},
	{0x91ca,0xd2},
	{0x91cb,0x00},
	{0x91cc,0x22},
	{0x91cd,0x30},
	{0x91ce,0x03},
	{0x91cf,0x08},
	{0x91d0,0xc2},
	{0x91d1,0x03},
	{0x91d2,0xc2},
	{0x91d3,0x04},
	{0x91d4,0x12},
	{0x91d5,0x02},
	{0x91d6,0xa8},
	{0x91d7,0x22},
	{0x91d8,0xe4},
	{0x91d9,0xf5},
	{0x91da,0x0c},
	{0x91db,0x12},
	{0x91dc,0x0e},
	{0x91dd,0xf9},
	{0x91de,0xd2},
	{0x91df,0x03},
	{0x91e0,0x22},
	{0x91e1,0x12},
	{0x91e2,0x17},
	{0x91e3,0x28},
	{0x91e4,0xc2},
	{0x91e5,0x3e},
	{0x91e6,0x12},
	{0x91e7,0x10},
	{0x91e8,0xdc},
	{0x91e9,0xc2},
	{0x91ea,0x3e},
	{0x91eb,0x12},
	{0x91ec,0x14},
	{0x91ed,0x01},
	{0x91ee,0x22},
	{0x91ef,0xd3},
	{0x91f0,0xe5},
	{0x91f1,0x57},
	{0x91f2,0x95},
	{0x91f3,0x6b},
	{0x91f4,0xe5},
	{0x91f5,0x56},
	{0x91f6,0x95},
	{0x91f7,0x6a},
	{0x91f8,0x40},
	{0x91f9,0x03},
	{0x91fa,0xd3},
	{0x91fb,0x80},
	{0x91fc,0x01},
	{0x91fd,0xc3},
	{0x91fe,0x92},
	{0x91ff,0x20},
	{0x9200,0xd3},
	{0x9201,0xe5},
	{0x9202,0x59},
	{0x9203,0x95},
	{0x9204,0x6d},
	{0x9205,0xe5},
	{0x9206,0x58},
	{0x9207,0x95},
	{0x9208,0x6c},
	{0x9209,0x40},
	{0x920a,0x03},
	{0x920b,0xd3},
	{0x920c,0x80},
	{0x920d,0x01},
	{0x920e,0xc3},
	{0x920f,0x92},
	{0x9210,0x21},
	{0x9211,0xd3},
	{0x9212,0xe5},
	{0x9213,0x5b},
	{0x9214,0x95},
	{0x9215,0x6f},
	{0x9216,0xe5},
	{0x9217,0x5a},
	{0x9218,0x95},
	{0x9219,0x6e},
	{0x921a,0x40},
	{0x921b,0x03},
	{0x921c,0xd3},
	{0x921d,0x80},
	{0x921e,0x01},
	{0x921f,0xc3},
	{0x9220,0x92},
	{0x9221,0x22},
	{0x9222,0xd3},
	{0x9223,0xe5},
	{0x9224,0x5d},
	{0x9225,0x95},
	{0x9226,0x71},
	{0x9227,0xe5},
	{0x9228,0x5c},
	{0x9229,0x95},
	{0x922a,0x70},
	{0x922b,0x40},
	{0x922c,0x03},
	{0x922d,0xd3},
	{0x922e,0x80},
	{0x922f,0x01},
	{0x9230,0xc3},
	{0x9231,0x92},
	{0x9232,0x23},
	{0x9233,0xd3},
	{0x9234,0xe5},
	{0x9235,0x5f},
	{0x9236,0x95},
	{0x9237,0x73},
	{0x9238,0xe5},
	{0x9239,0x5e},
	{0x923a,0x95},
	{0x923b,0x72},
	{0x923c,0x40},
	{0x923d,0x03},
	{0x923e,0xd3},
	{0x923f,0x80},
	{0x9240,0x01},
	{0x9241,0xc3},
	{0x9242,0x92},
	{0x9243,0x24},
	{0x9244,0xd3},
	{0x9245,0xe5},
	{0x9246,0x61},
	{0x9247,0x95},
	{0x9248,0x75},
	{0x9249,0xe5},
	{0x924a,0x60},
	{0x924b,0x95},
	{0x924c,0x74},
	{0x924d,0x40},
	{0x924e,0x03},
	{0x924f,0xd3},
	{0x9250,0x80},
	{0x9251,0x01},
	{0x9252,0xc3},
	{0x9253,0x92},
	{0x9254,0x25},
	{0x9255,0xd3},
	{0x9256,0xe5},
	{0x9257,0x63},
	{0x9258,0x95},
	{0x9259,0x77},
	{0x925a,0xe5},
	{0x925b,0x62},
	{0x925c,0x95},
	{0x925d,0x76},
	{0x925e,0x40},
	{0x925f,0x03},
	{0x9260,0xd3},
	{0x9261,0x80},
	{0x9262,0x01},
	{0x9263,0xc3},
	{0x9264,0x92},
	{0x9265,0x26},
	{0x9266,0x22},
	{0x9267,0x56},
	{0x9268,0x0c},
	{0x9269,0x04},
	{0x926a,0x00},
	{0x926b,0x00},
	{0x926c,0x00},
	{0x926d,0xc8},
	{0x926e,0x01},
	{0x926f,0x2c},
	{0x9270,0x01},
	{0x9271,0x5e},
	{0x9272,0x01},
	{0x9273,0x8b},
	{0x9274,0x01},
	{0x9275,0xb8},
	{0x9276,0x01},
	{0x9277,0xe5},
	{0x9278,0x02},
	{0x9279,0x12},
	{0x927a,0x02},
	{0x927b,0x3f},
	{0x927c,0x02},
	{0x927d,0x6c},
	{0x927e,0x02},
	{0x927f,0x99},
	{0x9280,0x02},
	{0x9281,0xc6},
	{0x9282,0x02},
	{0x9283,0xf3},
	{0x9284,0x07},
	{0x9285,0x20},
	{0x9286,0x12},
	{0x9287,0x28},
	{0x9288,0x1e},
	{0x9289,0x18},
	{0x928a,0x18},
	{0x928b,0x28},
	{0x928c,0x1e},
	{0x928d,0x18},
	{0x928e,0x12},
	{0x928f,0x28},
	{0x9290,0x1e},
	{0x9291,0x18},
	{0x9292,0x12},
	{0x9293,0x28},
	{0x9294,0x18},
	{0x9295,0x18},
	{0x9296,0x12},
	{0x9297,0x20},
	{0x9298,0x18},
	{0x9299,0x28},
	{0x929a,0x1c},
	{0x929b,0x30},
	{0x929c,0x24},
	{0x929d,0x10},
	{0x929e,0x1c},
	{0x929f,0x18},
	{0x92a0,0x24},
	{0x92a1,0x1c},
	{0x92a2,0x14},
	{0x92a3,0x24},
	{0x92a4,0x1c},
	{0x92a5,0x28},
	{0x92a6,0x0c},
	{0x92a7,0x30},
	{0x92a8,0x14},
	{0x92a9,0x10},
	{0x92aa,0x0c},
	{0x92ab,0x18},
	{0x92ac,0x14},
	{0x92ad,0x1c},
	{0x92ae,0x20},
	{0x92af,0x24},
	{0x92b0,0x28},
	{0x92b1,0x0c},
	{0x92b2,0x14},
	{0x92b3,0x14},
	{0x92b4,0x1c},
	{0x92b5,0x1c},
	{0x92b6,0x14},
	{0x92b7,0x24},
	{0x92b8,0x1c},
	{0x92b9,0x2c},
	{0x92ba,0x14},
	{0x92bb,0x34},
	{0x92bc,0x1c},
	{0x92bd,0x1c},
	{0x92be,0x08},
	{0x92bf,0x24},
	{0x92c0,0x10},
	{0x92c1,0x19},
	{0x92c2,0x19},
	{0x92c3,0x1c},
	{0x92c4,0x19},
	{0x92c5,0x19},
	{0x92c6,0x10},
	{0x92c7,0x10},
	{0x92c8,0x10},
	{0x92c9,0x10},
	{0x92ca,0x10},
	{0x92cb,0x00},
	{0x92cc,0x00},
	{0x92cd,0x00},
	{0x92ce,0x00},
	{0x92cf,0x00},
	{0x92d0,0x12},
	{0x92d1,0x11},
	{0x92d2,0xef},
	{0x92d3,0x30},
	{0x92d4,0x36},
	{0x92d5,0x40},
	{0x92d6,0xe5},
	{0x92d7,0x24},
	{0x92d8,0x54},
	{0x92d9,0x1f},
	{0x92da,0xff},
	{0x92db,0x60},
	{0x92dc,0x0e},
	{0x92dd,0x64},
	{0x92de,0x1f},
	{0x92df,0x60},
	{0x92e0,0x0a},
	{0x92e1,0xe5},
	{0x92e2,0x7c},
	{0x92e3,0x65},
	{0x92e4,0x7d},
	{0x92e5,0x60},
	{0x92e6,0x04},
	{0x92e7,0xe5},
	{0x92e8,0x7d},
	{0x92e9,0x70},
	{0x92ea,0x18},
	{0x92eb,0xbf},
	{0x92ec,0x1f},
	{0x92ed,0x02},
	{0x92ee,0xb2},
	{0x92ef,0x37},
	{0x92f0,0xe5},
	{0x92f1,0x7c},
	{0x92f2,0xb5},
	{0x92f3,0x7d},
	{0x92f4,0x02},
	{0x92f5,0xc2},
	{0x92f6,0x37},
	{0x92f7,0xe5},
	{0x92f8,0x7d},
	{0x92f9,0x70},
	{0x92fa,0x02},
	{0x92fb,0xd2},
	{0x92fc,0x37},
	{0x92fd,0xc2},
	{0x92fe,0x02},
	{0x92ff,0xd2},
	{0x9300,0x01},
	{0x9301,0xd2},
	{0x9302,0x00},
	{0x9303,0xc2},
	{0x9304,0x3e},
	{0x9305,0x12},
	{0x9306,0x10},
	{0x9307,0xdc},
	{0x9308,0xc2},
	{0x9309,0x3e},
	{0x930a,0x12},
	{0x930b,0x14},
	{0x930c,0x01},
	{0x930d,0x30},
	{0x930e,0x37},
	{0x930f,0x03},
	{0x9310,0x02},
	{0x9311,0x17},
	{0x9312,0x3c},
	{0x9313,0x02},
	{0x9314,0x17},
	{0x9315,0x4d},
	{0x9316,0xd2},
	{0x9317,0x3e},
	{0x9318,0x12},
	{0x9319,0x10},
	{0x931a,0xdc},
	{0x931b,0xd2},
	{0x931c,0x3e},
	{0x931d,0x12},
	{0x931e,0x14},
	{0x931f,0x01},
	{0x9320,0x12},
	{0x9321,0x17},
	{0x9322,0x3c},
	{0x9323,0xe5},
	{0x9324,0x32},
	{0x9325,0xd3},
	{0x9326,0x95},
	{0x9327,0x7d},
	{0x9328,0x40},
	{0x9329,0x05},
	{0x932a,0xe4},
	{0x932b,0x95},
	{0x932c,0x7d},
	{0x932d,0x40},
	{0x932e,0x06},
	{0x932f,0xc2},
	{0x9330,0x02},
	{0x9331,0xd2},
	{0x9332,0x01},
	{0x9333,0xd2},
	{0x9334,0x00},
	{0x9335,0x22},
	{0x9336,0x12},
	{0x9337,0x11},
	{0x9338,0xef},
	{0x9339,0xc3},
	{0x933a,0x30},
	{0x933b,0x25},
	{0x933c,0x0c},
	{0x933d,0xe5},
	{0x933e,0x61},
	{0x933f,0x95},
	{0x9340,0x75},
	{0x9341,0xff},
	{0x9342,0xe5},
	{0x9343,0x60},
	{0x9344,0x95},
	{0x9345,0x74},
	{0x9346,0xfe},
	{0x9347,0x80},
	{0x9348,0x0a},
	{0x9349,0xe5},
	{0x934a,0x75},
	{0x934b,0x95},
	{0x934c,0x61},
	{0x934d,0xff},
	{0x934e,0xe5},
	{0x934f,0x74},
	{0x9350,0x95},
	{0x9351,0x60},
	{0x9352,0xfe},
	{0x9353,0x8e},
	{0x9354,0x0a},
	{0x9355,0x8f},
	{0x9356,0x0b},
	{0x9357,0x30},
	{0x9358,0x03},
	{0x9359,0x26},
	{0x935a,0x12},
	{0x935b,0x02},
	{0x935c,0xb6},
	{0x935d,0x50},
	{0x935e,0x03},
	{0x935f,0x30},
	{0x9360,0x27},
	{0x9361,0x07},
	{0x9362,0xc2},
	{0x9363,0x3e},
	{0x9364,0x12},
	{0x9365,0x10},
	{0x9366,0xdc},
	{0x9367,0x80},
	{0x9368,0x2f},
	{0x9369,0x05},
	{0x936a,0x31},
	{0x936b,0xe5},
	{0x936c,0x31},
	{0x936d,0xd3},
	{0x936e,0x94},
	{0x936f,0x02},
	{0x9370,0x40},
	{0x9371,0x29},
	{0x9372,0xe4},
	{0x9373,0xf5},
	{0x9374,0x31},
	{0x9375,0xc2},
	{0x9376,0x03},
	{0x9377,0xc2},
	{0x9378,0x02},
	{0x9379,0xc2},
	{0x937a,0x01},
	{0x937b,0xd2},
	{0x937c,0x00},
	{0x937d,0xd2},
	{0x937e,0x34},
	{0x937f,0x22},
	{0x9380,0x12},
	{0x9381,0x02},
	{0x9382,0xb6},
	{0x9383,0x50},
	{0x9384,0x03},
	{0x9385,0x30},
	{0x9386,0x27},
	{0x9387,0x04},
	{0x9388,0x05},
	{0x9389,0x31},
	{0x938a,0x80},
	{0x938b,0x03},
	{0x938c,0xe4},
	{0x938d,0xf5},
	{0x938e,0x31},
	{0x938f,0xe5},
	{0x9390,0x31},
	{0x9391,0xd3},
	{0x9392,0x94},
	{0x9393,0x02},
	{0x9394,0x40},
	{0x9395,0x05},
	{0x9396,0xd2},
	{0x9397,0x03},
	{0x9398,0xe4},
	{0x9399,0xf5},
	{0x939a,0x31},
	{0x939b,0x22},
	{0x939c,0xe5},
	{0x939d,0x0a},
	{0x939e,0x70},
	{0x939f,0x04},
	{0x93a0,0x7a},
	{0x93a1,0x12},
	{0x93a2,0x7b},
	{0x93a3,0x85},
	{0x93a4,0xe5},
	{0x93a5,0x0a},
	{0x93a6,0xb4},
	{0x93a7,0x01},
	{0x93a8,0x04},
	{0x93a9,0x7a},
	{0x93aa,0x12},
	{0x93ab,0x7b},
	{0x93ac,0x99},
	{0x93ad,0xe5},
	{0x93ae,0x0a},
	{0x93af,0xb4},
	{0x93b0,0x02},
	{0x93b1,0x04},
	{0x93b2,0x7a},
	{0x93b3,0x12},
	{0x93b4,0x7b},
	{0x93b5,0xad},
	{0x93b6,0x8b},
	{0x93b7,0x82},
	{0x93b8,0x8a},
	{0x93b9,0x83},
	{0x93ba,0x12},
	{0x93bb,0x09},
	{0x93bc,0xde},
	{0x93bd,0x8f},
	{0x93be,0x37},
	{0x93bf,0x8e},
	{0x93c0,0x36},
	{0x93c1,0x8d},
	{0x93c2,0x35},
	{0x93c3,0x8c},
	{0x93c4,0x34},
	{0x93c5,0xe5},
	{0x93c6,0x82},
	{0x93c7,0x24},
	{0x93c8,0x04},
	{0x93c9,0xf5},
	{0x93ca,0x82},
	{0x93cb,0xe4},
	{0x93cc,0x35},
	{0x93cd,0x83},
	{0x93ce,0xf5},
	{0x93cf,0x83},
	{0x93d0,0x12},
	{0x93d1,0x09},
	{0x93d2,0xde},
	{0x93d3,0x8f},
	{0x93d4,0x3b},
	{0x93d5,0x8e},
	{0x93d6,0x3a},
	{0x93d7,0x8d},
	{0x93d8,0x39},
	{0x93d9,0x8c},
	{0x93da,0x38},
	{0x93db,0xeb},
	{0x93dc,0x24},
	{0x93dd,0x08},
	{0x93de,0x12},
	{0x93df,0x02},
	{0x93e0,0x53},
	{0x93e1,0x12},
	{0x93e2,0x01},
	{0x93e3,0xb3},
	{0x93e4,0xeb},
	{0x93e5,0x24},
	{0x93e6,0x0c},
	{0x93e7,0x12},
	{0x93e8,0x02},
	{0x93e9,0x53},
	{0x93ea,0x8f},
	{0x93eb,0x43},
	{0x93ec,0x8e},
	{0x93ed,0x42},
	{0x93ee,0x8d},
	{0x93ef,0x41},
	{0x93f0,0x8c},
	{0x93f1,0x40},
	{0x93f2,0xeb},
	{0x93f3,0x24},
	{0x93f4,0x10},
	{0x93f5,0x12},
	{0x93f6,0x02},
	{0x93f7,0x53},
	{0x93f8,0x8f},
	{0x93f9,0x47},
	{0x93fa,0x8e},
	{0x93fb,0x46},
	{0x93fc,0x8d},
	{0x93fd,0x45},
	{0x93fe,0x8c},
	{0x93ff,0x44},
	{0x9400,0x22},
	{0x9401,0x30},
	{0x9402,0x3e},
	{0x9403,0x07},
	{0x9404,0x30},
	{0x9405,0x20},
	{0x9406,0x04},
	{0x9407,0xaf},
	{0x9408,0x4a},
	{0x9409,0x80},
	{0x940a,0x02},
	{0x940b,0xaf},
	{0x940c,0x7d},
	{0x940d,0x8f},
	{0x940e,0x4a},
	{0x940f,0x30},
	{0x9410,0x3e},
	{0x9411,0x07},
	{0x9412,0x30},
	{0x9413,0x21},
	{0x9414,0x04},
	{0x9415,0xaf},
	{0x9416,0x4b},
	{0x9417,0x80},
	{0x9418,0x02},
	{0x9419,0xaf},
	{0x941a,0x7d},
	{0x941b,0x8f},
	{0x941c,0x4b},
	{0x941d,0x30},
	{0x941e,0x3e},
	{0x941f,0x07},
	{0x9420,0x30},
	{0x9421,0x22},
	{0x9422,0x04},
	{0x9423,0xaf},
	{0x9424,0x4c},
	{0x9425,0x80},
	{0x9426,0x02},
	{0x9427,0xaf},
	{0x9428,0x7d},
	{0x9429,0x8f},
	{0x942a,0x4c},
	{0x942b,0x30},
	{0x942c,0x3e},
	{0x942d,0x07},
	{0x942e,0x30},
	{0x942f,0x23},
	{0x9430,0x04},
	{0x9431,0xaf},
	{0x9432,0x4d},
	{0x9433,0x80},
	{0x9434,0x02},
	{0x9435,0xaf},
	{0x9436,0x7d},
	{0x9437,0x8f},
	{0x9438,0x4d},
	{0x9439,0x30},
	{0x943a,0x3e},
	{0x943b,0x07},
	{0x943c,0x30},
	{0x943d,0x24},
	{0x943e,0x04},
	{0x943f,0xaf},
	{0x9440,0x4e},
	{0x9441,0x80},
	{0x9442,0x02},
	{0x9443,0xaf},
	{0x9444,0x7d},
	{0x9445,0x8f},
	{0x9446,0x4e},
	{0x9447,0x30},
	{0x9448,0x3e},
	{0x9449,0x07},
	{0x944a,0x30},
	{0x944b,0x25},
	{0x944c,0x04},
	{0x944d,0xaf},
	{0x944e,0x4f},
	{0x944f,0x80},
	{0x9450,0x02},
	{0x9451,0xaf},
	{0x9452,0x7d},
	{0x9453,0x8f},
	{0x9454,0x4f},
	{0x9455,0x30},
	{0x9456,0x3e},
	{0x9457,0x07},
	{0x9458,0x30},
	{0x9459,0x26},
	{0x945a,0x04},
	{0x945b,0xaf},
	{0x945c,0x50},
	{0x945d,0x80},
	{0x945e,0x02},
	{0x945f,0xaf},
	{0x9460,0x7d},
	{0x9461,0x8f},
	{0x9462,0x50},
	{0x9463,0x22},
	{0x9464,0x12},
	{0x9465,0x11},
	{0x9466,0xef},
	{0x9467,0xd2},
	{0x9468,0x3e},
	{0x9469,0x12},
	{0x946a,0x10},
	{0x946b,0xdc},
	{0x946c,0xd2},
	{0x946d,0x3e},
	{0x946e,0x12},
	{0x946f,0x14},
	{0x9470,0x01},
	{0x9471,0x30},
	{0x9472,0x36},
	{0x9473,0x26},
	{0x9474,0x30},
	{0x9475,0x37},
	{0x9476,0x06},
	{0x9477,0xe5},
	{0x9478,0x7c},
	{0x9479,0x65},
	{0x947a,0x7d},
	{0x947b,0x60},
	{0x947c,0x3e},
	{0x947d,0x20},
	{0x947e,0x37},
	{0x947f,0x04},
	{0x9480,0xe5},
	{0x9481,0x7d},
	{0x9482,0x60},
	{0x9483,0x37},
	{0x9484,0xe5},
	{0x9485,0x24},
	{0x9486,0x54},
	{0x9487,0x1f},
	{0x9488,0xff},
	{0x9489,0xbf},
	{0x948a,0x1f},
	{0x948b,0x06},
	{0x948c,0x30},
	{0x948d,0x25},
	{0x948e,0x03},
	{0x948f,0x20},
	{0x9490,0x26},
	{0x9491,0x29},
	{0x9492,0x30},
	{0x9493,0x37},
	{0x9494,0x02},
	{0x9495,0x80},
	{0x9496,0x21},
	{0x9497,0x02},
	{0x9498,0x17},
	{0x9499,0x4d},
	{0x949a,0xe5},
	{0x949b,0x7c},
	{0x949c,0xd3},
	{0x949d,0x95},
	{0x949e,0x7d},
	{0x949f,0x40},
	{0x94a0,0x03},
	{0x94a1,0xd3},
	{0x94a2,0x80},
	{0x94a3,0x01},
	{0x94a4,0xc3},
	{0x94a5,0x50},
	{0x94a6,0x14},
	{0x94a7,0x20},
	{0x94a8,0x39},
	{0x94a9,0x0e},
	{0x94aa,0xe5},
	{0x94ab,0x24},
	{0x94ac,0x54},
	{0x94ad,0x1f},
	{0x94ae,0xff},
	{0x94af,0xbf},
	{0x94b0,0x1f},
	{0x94b1,0x06},
	{0x94b2,0x30},
	{0x94b3,0x25},
	{0x94b4,0x03},
	{0x94b5,0x20},
	{0x94b6,0x26},
	{0x94b7,0x03},
	{0x94b8,0x02},
	{0x94b9,0x17},
	{0x94ba,0x3c},
	{0x94bb,0x12},
	{0x94bc,0x02},
	{0x94bd,0xc0},
	{0x94be,0x22},
	{0x94bf,0xc2},
	{0x94c0,0x34},
	{0x94c1,0x20},
	{0x94c2,0x07},
	{0x94c3,0x08},
	{0x94c4,0x20},
	{0x94c5,0x06},
	{0x94c6,0x05},
	{0x94c7,0xe4},
	{0x94c8,0xf5},
	{0x94c9,0x0a},
	{0x94ca,0x80},
	{0x94cb,0x2b},
	{0x94cc,0x20},
	{0x94cd,0x07},
	{0x94ce,0x08},
	{0x94cf,0x30},
	{0x94d0,0x06},
	{0x94d1,0x05},
	{0x94d2,0x75},
	{0x94d3,0x0a},
	{0x94d4,0x20},
	{0x94d5,0x80},
	{0x94d6,0x20},
	{0x94d7,0x30},
	{0x94d8,0x00},
	{0x94d9,0x05},
	{0x94da,0x75},
	{0x94db,0x0a},
	{0x94dc,0x01},
	{0x94dd,0x80},
	{0x94de,0x18},
	{0x94df,0xe5},
	{0x94e0,0x20},
	{0x94e1,0x54},
	{0x94e2,0x07},
	{0x94e3,0xff},
	{0x94e4,0xbf},
	{0x94e5,0x06},
	{0x94e6,0x0d},
	{0x94e7,0x30},
	{0x94e8,0x31},
	{0x94e9,0x04},
	{0x94ea,0x7f},
	{0x94eb,0x12},
	{0x94ec,0x80},
	{0x94ed,0x02},
	{0x94ee,0x7f},
	{0x94ef,0x02},
	{0x94f0,0x8f},
	{0x94f1,0x0a},
	{0x94f2,0x80},
	{0x94f3,0x03},
	{0x94f4,0x75},
	{0x94f5,0x0a},
	{0x94f6,0xfe},
	{0x94f7,0x90},
	{0x94f8,0x30},
	{0x94f9,0x27},
	{0x94fa,0xe5},
	{0x94fb,0x0a},
	{0x94fc,0xf0},
	{0x94fd,0xe5},
	{0x94fe,0x23},
	{0x94ff,0x54},
	{0x9500,0xf8},
	{0x9501,0xf5},
	{0x9502,0x0a},
	{0x9503,0xe5},
	{0x9504,0x79},
	{0x9505,0x25},
	{0x9506,0x0a},
	{0x9507,0xf5},
	{0x9508,0x0a},
	{0x9509,0x90},
	{0x950a,0x30},
	{0x950b,0x26},
	{0x950c,0xe5},
	{0x950d,0x0a},
	{0x950e,0xf0},
	{0x950f,0x22},
	{0x9510,0xe5},
	{0x9511,0x0a},
	{0x9512,0x70},
	{0x9513,0x04},
	{0x9514,0x7e},
	{0x9515,0x12},
	{0x9516,0x7f},
	{0x9517,0xc1},
	{0x9518,0xe5},
	{0x9519,0x0a},
	{0x951a,0xb4},
	{0x951b,0x01},
	{0x951c,0x04},
	{0x951d,0x7e},
	{0x951e,0x12},
	{0x951f,0x7f},
	{0x9520,0xc6},
	{0x9521,0xe5},
	{0x9522,0x0a},
	{0x9523,0xb4},
	{0x9524,0x02},
	{0x9525,0x04},
	{0x9526,0x7e},
	{0x9527,0x12},
	{0x9528,0x7f},
	{0x9529,0xcb},
	{0x952a,0x8f},
	{0x952b,0x82},
	{0x952c,0x8e},
	{0x952d,0x83},
	{0x952e,0xe4},
	{0x952f,0x93},
	{0x9530,0xf5},
	{0x9531,0x2c},
	{0x9532,0x74},
	{0x9533,0x01},
	{0x9534,0x93},
	{0x9535,0xf5},
	{0x9536,0x2d},
	{0x9537,0x74},
	{0x9538,0x02},
	{0x9539,0x93},
	{0x953a,0xf5},
	{0x953b,0x2e},
	{0x953c,0x74},
	{0x953d,0x03},
	{0x953e,0x93},
	{0x953f,0xf5},
	{0x9540,0x2f},
	{0x9541,0x74},
	{0x9542,0x04},
	{0x9543,0x93},
	{0x9544,0xf5},
	{0x9545,0x30},
	{0x9546,0xe5},
	{0x9547,0x0a},
	{0x9548,0xb4},
	{0x9549,0x01},
	{0x954a,0x07},
	{0x954b,0x74},
	{0x954c,0x2c},
	{0x954d,0x25},
	{0x954e,0x79},
	{0x954f,0xf8},
	{0x9550,0x76},
	{0x9551,0x40},
	{0x9552,0xe5},
	{0x9553,0x0a},
	{0x9554,0xb4},
	{0x9555,0x02},
	{0x9556,0x07},
	{0x9557,0x74},
	{0x9558,0x2c},
	{0x9559,0x25},
	{0x955a,0x79},
	{0x955b,0xf8},
	{0x955c,0x76},
	{0x955d,0x80},
	{0x955e,0x22},
	{0x955f,0xc2},
	{0x9560,0xaf},
	{0x9561,0x90},
	{0x9562,0x30},
	{0x9563,0x27},
	{0x9564,0x74},
	{0x9565,0xfa},
	{0x9566,0xf0},
	{0x9567,0x12},
	{0x9568,0x0f},
	{0x9569,0xab},
	{0x956a,0x12},
	{0x956b,0x16},
	{0x956c,0xad},
	{0x956d,0xe4},
	{0x956e,0xf5},
	{0x956f,0x33},
	{0x9570,0xd2},
	{0x9571,0xaf},
	{0x9572,0x12},
	{0x9573,0x0c},
	{0x9574,0xa8},
	{0x9575,0x30},
	{0x9576,0x30},
	{0x9577,0x03},
	{0x9578,0x12},
	{0x9579,0x06},
	{0x957a,0xfb},
	{0x957b,0x30},
	{0x957c,0x34},
	{0x957d,0x03},
	{0x957e,0x12},
	{0x957f,0x14},
	{0x9580,0xbf},
	{0x9581,0x30},
	{0x9582,0x3d},
	{0x9583,0xee},
	{0x9584,0xc2},
	{0x9585,0x3d},
	{0x9586,0xd2},
	{0x9587,0x35},
	{0x9588,0x30},
	{0x9589,0x00},
	{0x958a,0x05},
	{0x958b,0x12},
	{0x958c,0x16},
	{0x958d,0x80},
	{0x958e,0x80},
	{0x958f,0x17},
	{0x9590,0x30},
	{0x9591,0x07},
	{0x9592,0x0b},
	{0x9593,0x30},
	{0x9594,0x06},
	{0x9595,0x08},
	{0x9596,0x20},
	{0x9597,0x31},
	{0x9598,0x0e},
	{0x9599,0x12},
	{0x959a,0x13},
	{0x959b,0x36},
	{0x959c,0x80},
	{0x959d,0x09},
	{0x959e,0x20},
	{0x959f,0x07},
	{0x95a0,0x06},
	{0x95a1,0x30},
	{0x95a2,0x06},
	{0x95a3,0x03},
	{0x95a4,0x12},
	{0x95a5,0x0b},
	{0x95a6,0x6c},
	{0x95a7,0xc2},
	{0x95a8,0x35},
	{0x95a9,0x80},
	{0x95aa,0xc7},
	{0x95ab,0xc0},
	{0x95ac,0xe0},
	{0x95ad,0xc0},
	{0x95ae,0x83},
	{0x95af,0xc0},
	{0x95b0,0x82},
	{0x95b1,0xc0},
	{0x95b2,0xd0},
	{0x95b3,0x90},
	{0x95b4,0x3f},
	{0x95b5,0x0d},
	{0x95b6,0xe0},
	{0x95b7,0xf5},
	{0x95b8,0x09},
	{0x95b9,0xe5},
	{0x95ba,0x09},
	{0x95bb,0x30},
	{0x95bc,0xe0},
	{0x95bd,0x2e},
	{0x95be,0xe5},
	{0x95bf,0x7a},
	{0x95c0,0xb4},
	{0x95c1,0x01},
	{0x95c2,0x09},
	{0x95c3,0x90},
	{0x95c4,0x3a},
	{0x95c5,0x00},
	{0x95c6,0xe0},
	{0x95c7,0xf5},
	{0x95c8,0x78},
	{0x95c9,0x44},
	{0x95ca,0x01},
	{0x95cb,0xf0},
	{0x95cc,0xe5},
	{0x95cd,0x7a},
	{0x95ce,0xb4},
	{0x95cf,0x03},
	{0x95d0,0x09},
	{0x95d1,0x90},
	{0x95d2,0x3a},
	{0x95d3,0x00},
	{0x95d4,0xe0},
	{0x95d5,0xf5},
	{0x95d6,0x78},
	{0x95d7,0x54},
	{0x95d8,0xfe},
	{0x95d9,0xf0},
	{0x95da,0xe5},
	{0x95db,0x7a},
	{0x95dc,0xb4},
	{0x95dd,0x03},
	{0x95de,0x05},
	{0x95df,0x75},
	{0x95e0,0x7a},
	{0x95e1,0x00},
	{0x95e2,0x80},
	{0x95e3,0x02},
	{0x95e4,0x05},
	{0x95e5,0x7a},
	{0x95e6,0x90},
	{0x95e7,0x3f},
	{0x95e8,0x0d},
	{0x95e9,0x74},
	{0x95ea,0x01},
	{0x95eb,0xf0},
	{0x95ec,0xd0},
	{0x95ed,0xd0},
	{0x95ee,0xd0},
	{0x95ef,0x82},
	{0x95f0,0xd0},
	{0x95f1,0x83},
	{0x95f2,0xd0},
	{0x95f3,0xe0},
	{0x95f4,0x32},
	{0x95f5,0x90},
	{0x95f6,0x50},
	{0x95f7,0x27},
	{0x95f8,0xe0},
	{0x95f9,0x44},
	{0x95fa,0x01},
	{0x95fb,0xf0},
	{0x95fc,0x90},
	{0x95fd,0x50},
	{0x95fe,0x34},
	{0x95ff,0x74},
	{0x9600,0x80},
	{0x9601,0xf0},
	{0x9602,0xa3},
	{0x9603,0x74},
	{0x9604,0x2a},
	{0x9605,0xf0},
	{0x9606,0xa3},
	{0x9607,0x74},
	{0x9608,0x14},
	{0x9609,0xf0},
	{0x960a,0x90},
	{0x960b,0x50},
	{0x960c,0x30},
	{0x960d,0xe4},
	{0x960e,0xf0},
	{0x960f,0xa3},
	{0x9610,0x74},
	{0x9611,0x02},
	{0x9612,0xf0},
	{0x9613,0xa3},
	{0x9614,0xe4},
	{0x9615,0xf0},
	{0x9616,0xa3},
	{0x9617,0x74},
	{0x9618,0x80},
	{0x9619,0xf0},
	{0x961a,0xe4},
	{0x961b,0xf5},
	{0x961c,0x0a},
	{0x961d,0x12},
	{0x961e,0x13},
	{0x961f,0x9c},
	{0x9620,0x75},
	{0x9621,0x79},
	{0x9622,0x02},
	{0x9623,0x75},
	{0x9624,0x0a},
	{0x9625,0x01},
	{0x9626,0x12},
	{0x9627,0x15},
	{0x9628,0x10},
	{0x9629,0xd2},
	{0x962a,0x18},
	{0x962b,0xd2},
	{0x962c,0x19},
	{0x962d,0xc2},
	{0x962e,0x3c},
	{0x962f,0xc2},
	{0x9630,0x3b},
	{0x9631,0xd2},
	{0x9632,0x1a},
	{0x9633,0xd2},
	{0x9634,0x38},
	{0x9635,0xd2},
	{0x9636,0x30},
	{0x9637,0xc2},
	{0x9638,0x35},
	{0x9639,0xc2},
	{0x963a,0x3d},
	{0x963b,0x22},
	{0x963c,0x85},
	{0x963d,0x14},
	{0x963e,0x15},
	{0x963f,0x7f},
	{0x9640,0x08},
	{0x9641,0xe5},
	{0x9642,0x15},
	{0x9643,0x30},
	{0x9644,0xe7},
	{0x9645,0x04},
	{0x9646,0xd2},
	{0x9647,0x29},
	{0x9648,0x80},
	{0x9649,0x02},
	{0x964a,0xc2},
	{0x964b,0x29},
	{0x964c,0x12},
	{0x964d,0x01},
	{0x964e,0x6c},
	{0x964f,0x75},
	{0x9650,0x51},
	{0x9651,0x0a},
	{0x9652,0xae},
	{0x9653,0x51},
	{0x9654,0x15},
	{0x9655,0x51},
	{0x9656,0xee},
	{0x9657,0x70},
	{0x9658,0xf9},
	{0x9659,0xe5},
	{0x965a,0x15},
	{0x965b,0x25},
	{0x965c,0xe0},
	{0x965d,0xf5},
	{0x965e,0x15},
	{0x965f,0xd2},
	{0x9660,0x28},
	{0x9661,0x12},
	{0x9662,0x01},
	{0x9663,0x6c},
	{0x9664,0x75},
	{0x9665,0x51},
	{0x9666,0x0a},
	{0x9667,0xae},
	{0x9668,0x51},
	{0x9669,0x15},
	{0x966a,0x51},
	{0x966b,0xee},
	{0x966c,0x70},
	{0x966d,0xf9},
	{0x966e,0xc2},
	{0x966f,0x28},
	{0x9670,0x12},
	{0x9671,0x01},
	{0x9672,0x6c},
	{0x9673,0x75},
	{0x9674,0x51},
	{0x9675,0x05},
	{0x9676,0xae},
	{0x9677,0x51},
	{0x9678,0x15},
	{0x9679,0x51},
	{0x967a,0xee},
	{0x967b,0x70},
	{0x967c,0xf9},
	{0x967d,0xdf},
	{0x967e,0xc2},
	{0x967f,0x22},
	{0x9680,0xe5},
	{0x9681,0x20},
	{0x9682,0x54},
	{0x9683,0x07},
	{0x9684,0xff},
	{0x9685,0xbf},
	{0x9686,0x01},
	{0x9687,0x03},
	{0x9688,0x02},
	{0x9689,0x11},
	{0x968a,0x69},
	{0x968b,0xe5},
	{0x968c,0x20},
	{0x968d,0x54},
	{0x968e,0x07},
	{0x968f,0xff},
	{0x9690,0xbf},
	{0x9691,0x07},
	{0x9692,0x03},
	{0x9693,0x02},
	{0x9694,0x12},
	{0x9695,0xd0},
	{0x9696,0xe5},
	{0x9697,0x20},
	{0x9698,0x54},
	{0x9699,0x07},
	{0x969a,0xff},
	{0x969b,0xbf},
	{0x969c,0x03},
	{0x969d,0x03},
	{0x969e,0x02},
	{0x969f,0x14},
	{0x96a0,0x64},
	{0x96a1,0xe5},
	{0x96a2,0x20},
	{0x96a3,0x54},
	{0x96a4,0x07},
	{0x96a5,0xff},
	{0x96a6,0xbf},
	{0x96a7,0x05},
	{0x96a8,0x03},
	{0x96a9,0x12},
	{0x96aa,0x17},
	{0x96ab,0x7a},
	{0x96ac,0x22},
	{0x96ad,0x12},
	{0x96ae,0x15},
	{0x96af,0xf5},
	{0x96b0,0x12},
	{0x96b1,0x17},
	{0x96b2,0x88},
	{0x96b3,0x50},
	{0x96b4,0x04},
	{0x96b5,0xd2},
	{0x96b6,0x05},
	{0x96b7,0x80},
	{0x96b8,0x02},
	{0x96b9,0xc2},
	{0x96ba,0x05},
	{0x96bb,0x12},
	{0x96bc,0x02},
	{0x96bd,0x64},
	{0x96be,0xc2},
	{0x96bf,0x39},
	{0x96c0,0xc2},
	{0x96c1,0x36},
	{0x96c2,0xc2},
	{0x96c3,0x31},
	{0x96c4,0xd2},
	{0x96c5,0x34},
	{0x96c6,0x12},
	{0x96c7,0x02},
	{0x96c8,0x92},
	{0x96c9,0xb5},
	{0x96ca,0x07},
	{0x96cb,0x03},
	{0x96cc,0xd3},
	{0x96cd,0x80},
	{0x96ce,0x01},
	{0x96cf,0xc3},
	{0x96d0,0x40},
	{0x96d1,0x02},
	{0x96d2,0xc2},
	{0x96d3,0x05},
	{0x96d4,0x22},
	{0x96d5,0xe4},
	{0x96d6,0xff},
	{0x96d7,0xfe},
	{0x96d8,0xc3},
	{0x96d9,0xef},
	{0x96da,0x95},
	{0x96db,0x12},
	{0x96dc,0xee},
	{0x96dd,0x95},
	{0x96de,0x11},
	{0x96df,0x50},
	{0x96e0,0x15},
	{0x96e1,0x7d},
	{0x96e2,0x8a},
	{0x96e3,0x7c},
	{0x96e4,0x02},
	{0x96e5,0xed},
	{0x96e6,0x1d},
	{0x96e7,0xaa},
	{0x96e8,0x04},
	{0x96e9,0x70},
	{0x96ea,0x01},
	{0x96eb,0x1c},
	{0x96ec,0x4a},
	{0x96ed,0x70},
	{0x96ee,0xf6},
	{0x96ef,0x0f},
	{0x96f0,0xbf},
	{0x96f1,0x00},
	{0x96f2,0x01},
	{0x96f3,0x0e},
	{0x96f4,0x80},
	{0x96f5,0xe2},
	{0x96f6,0x22},
	{0x96f7,0xc2},
	{0x96f8,0x03},
	{0x96f9,0xd2},
	{0x96fa,0x04},
	{0x96fb,0x12},
	{0x96fc,0x02},
	{0x96fd,0xa8},
	{0x96fe,0x30},
	{0x96ff,0x07},
	{0x9700,0x05},
	{0x9701,0x30},
	{0x9702,0x06},
	{0x9703,0x02},
	{0x9704,0xd2},
	{0x9705,0x36},
	{0x9706,0xc2},
	{0x9707,0x3e},
	{0x9708,0x12},
	{0x9709,0x10},
	{0x970a,0xdc},
	{0x970b,0xc2},
	{0x970c,0x3e},
	{0x970d,0x12},
	{0x970e,0x14},
	{0x970f,0x01},
	{0x9710,0xd2},
	{0x9711,0x34},
	{0x9712,0x22},
	{0x9713,0x75},
	{0x9714,0x48},
	{0x9715,0x12},
	{0x9716,0x75},
	{0x9717,0x49},
	{0x9718,0x6a},
	{0x9719,0x90},
	{0x971a,0x12},
	{0x971b,0x68},
	{0x971c,0xe4},
	{0x971d,0x93},
	{0x971e,0xf5},
	{0x971f,0x7c},
	{0x9720,0xa3},
	{0x9721,0xe4},
	{0x9722,0x93},
	{0x9723,0xf5},
	{0x9724,0x32},
	{0x9725,0xc2},
	{0x9726,0x3a},
	{0x9727,0x22},
	{0x9728,0xe4},
	{0x9729,0xff},
	{0x972a,0xef},
	{0x972b,0x25},
	{0x972c,0xe0},
	{0x972d,0x24},
	{0x972e,0x56},
	{0x972f,0xf8},
	{0x9730,0xe4},
	{0x9731,0xf6},
	{0x9732,0x08},
	{0x9733,0xf6},
	{0x9734,0x0f},
	{0x9735,0xbf},
	{0x9736,0x07},
	{0x9737,0xf2},
	{0x9738,0x53},
	{0x9739,0x24},
	{0x973a,0x80},
	{0x973b,0x22},
	{0x973c,0xe5},
	{0x973d,0x7d},
	{0x973e,0xc3},
	{0x973f,0x95},
	{0x9740,0x7c},
	{0x9741,0x40},
	{0x9742,0x01},
	{0x9743,0x22},
	{0x9744,0xe5},
	{0x9745,0x7d},
	{0x9746,0x04},
	{0x9747,0xf5},
	{0x9748,0x0c},
	{0x9749,0x12},
	{0x974a,0x0e},
	{0x974b,0xf9},
	{0x974c,0x22},
	{0x974d,0xe5},
	{0x974e,0x7d},
	{0x974f,0x70},
	{0x9750,0x02},
	{0x9751,0xc3},
	{0x9752,0x22},
	{0x9753,0xe5},
	{0x9754,0x7d},
	{0x9755,0x14},
	{0x9756,0xf5},
	{0x9757,0x0c},
	{0x9758,0x12},
	{0x9759,0x0e},
	{0x975a,0xf9},
	{0x975b,0x22},
	{0x975c,0xe5},
	{0x975d,0x7e},
	{0x975e,0xb4},
	{0x975f,0x01},
	{0x9760,0x09},
	{0x9761,0x12},
	{0x9762,0x17},
	{0x9763,0x13},
	{0x9764,0xe4},
	{0x9765,0xf5},
	{0x9766,0x0c},
	{0x9767,0x12},
	{0x9768,0x0e},
	{0x9769,0xf9},
	{0x976a,0x22},
	{0x976b,0xe5},
	{0x976c,0x7e},
	{0x976d,0x24},
	{0x976e,0xfe},
	{0x976f,0x60},
	{0x9770,0x06},
	{0x9771,0x04},
	{0x9772,0x70},
	{0x9773,0x05},
	{0x9774,0xd2},
	{0x9775,0x39},
	{0x9776,0x22},
	{0x9777,0xc2},
	{0x9778,0x39},
	{0x9779,0x22},
	{0x977a,0xe5},
	{0x977b,0x31},
	{0x977c,0xd3},
	{0x977d,0x94},
	{0x977e,0x00},
	{0x977f,0x40},
	{0x9780,0x03},
	{0x9781,0x15},
	{0x9782,0x31},
	{0x9783,0x22},
	{0x9784,0x12},
	{0x9785,0x16},
	{0x9786,0xf7},
	{0x9787,0x22},
	{0x9788,0x12},
	{0x9789,0x17},
	{0x978a,0x13},
	{0x978b,0xe4},
	{0x978c,0xf5},
	{0x978d,0x0c},
	{0x978e,0x12},
	{0x978f,0x0e},
	{0x9790,0xf9},
	{0x9791,0x22},
	{0x3024,0x00},
	{0x3025,0x00},
	{0x5082,0x00},
	{0x5083,0x00},
	{0x5084,0x00},
	{0x5085,0x00},
	{0x3026,0x00},
	{0x3027,0xFF},
	{0x3000,0x00},
	{0x0000,0x00}
};
#elif (VCM_DRIVER == VCM_DRIVER_AD5820)
/* support const-focus */
static struct reginfo sensor_af_firmware[] =
{
	{0x3000,0x20},
	{0x8000,0x02},
	{0x8001,0x00},
	{0x8002,0x06},
	{0x8003,0x02},
	{0x8004,0x0c},
	{0x8005,0xa4},
	{0x8006,0x78},
	{0x8007,0x7f},
	{0x8008,0xe4},
	{0x8009,0xf6},
	{0x800a,0xd8},
	{0x800b,0xfd},
	{0x800c,0x75},
	{0x800d,0x81},
	{0x800e,0x7e},
	{0x800f,0x02},
	{0x8010,0x14},
	{0x8011,0xc7},
	{0x8012,0x00},
	{0x8013,0x02},
	{0x8014,0x15},
	{0x8015,0x13},
	{0x8016,0xe0},
	{0x8017,0xf5},
	{0x8018,0x72},
	{0x8019,0xa3},
	{0x801a,0xe0},
	{0x801b,0xf5},
	{0x801c,0x73},
	{0x801d,0xae},
	{0x801e,0x6a},
	{0x801f,0xe4},
	{0x8020,0x85},
	{0x8021,0x6b},
	{0x8022,0x55},
	{0x8023,0x8e},
	{0x8024,0x54},
	{0x8025,0xf5},
	{0x8026,0x53},
	{0x8027,0xf5},
	{0x8028,0x52},
	{0x8029,0xab},
	{0x802a,0x55},
	{0x802b,0xaa},
	{0x802c,0x54},
	{0x802d,0xa9},
	{0x802e,0x53},
	{0x802f,0xa8},
	{0x8030,0x52},
	{0x8031,0xaf},
	{0x8032,0x2c},
	{0x8033,0xfc},
	{0x8034,0xfd},
	{0x8035,0xfe},
	{0x8036,0x12},
	{0x8037,0x08},
	{0x8038,0x98},
	{0x8039,0x8f},
	{0x803a,0x55},
	{0x803b,0x8e},
	{0x803c,0x54},
	{0x803d,0x8d},
	{0x803e,0x53},
	{0x803f,0x8c},
	{0x8040,0x52},
	{0x8041,0xaf},
	{0x8042,0x55},
	{0x8043,0xae},
	{0x8044,0x54},
	{0x8045,0xad},
	{0x8046,0x53},
	{0x8047,0xac},
	{0x8048,0x52},
	{0x8049,0x8f},
	{0x804a,0x2b},
	{0x804b,0x8e},
	{0x804c,0x2a},
	{0x804d,0x8d},
	{0x804e,0x29},
	{0x804f,0x8c},
	{0x8050,0x28},
	{0x8051,0xae},
	{0x8052,0x6c},
	{0x8053,0xe4},
	{0x8054,0x85},
	{0x8055,0x6d},
	{0x8056,0x55},
	{0x8057,0x8e},
	{0x8058,0x54},
	{0x8059,0xf5},
	{0x805a,0x53},
	{0x805b,0xf5},
	{0x805c,0x52},
	{0x805d,0xab},
	{0x805e,0x55},
	{0x805f,0xaa},
	{0x8060,0x54},
	{0x8061,0xa9},
	{0x8062,0x53},
	{0x8063,0xa8},
	{0x8064,0x52},
	{0x8065,0xaf},
	{0x8066,0x2d},
	{0x8067,0xfc},
	{0x8068,0xfd},
	{0x8069,0xfe},
	{0x806a,0x12},
	{0x806b,0x08},
	{0x806c,0x98},
	{0x806d,0x8f},
	{0x806e,0x55},
	{0x806f,0x8e},
	{0x8070,0x54},
	{0x8071,0x8d},
	{0x8072,0x53},
	{0x8073,0x8c},
	{0x8074,0x52},
	{0x8075,0xe5},
	{0x8076,0x2b},
	{0x8077,0x25},
	{0x8078,0x55},
	{0x8079,0xf5},
	{0x807a,0x2b},
	{0x807b,0xe5},
	{0x807c,0x2a},
	{0x807d,0x35},
	{0x807e,0x54},
	{0x807f,0xf5},
	{0x8080,0x2a},
	{0x8081,0xe5},
	{0x8082,0x29},
	{0x8083,0x35},
	{0x8084,0x53},
	{0x8085,0xf5},
	{0x8086,0x29},
	{0x8087,0xe5},
	{0x8088,0x28},
	{0x8089,0x35},
	{0x808a,0x52},
	{0x808b,0xf5},
	{0x808c,0x28},
	{0x808d,0xae},
	{0x808e,0x6e},
	{0x808f,0xe4},
	{0x8090,0x85},
	{0x8091,0x6f},
	{0x8092,0x55},
	{0x8093,0x8e},
	{0x8094,0x54},
	{0x8095,0xf5},
	{0x8096,0x53},
	{0x8097,0xf5},
	{0x8098,0x52},
	{0x8099,0xab},
	{0x809a,0x55},
	{0x809b,0xaa},
	{0x809c,0x54},
	{0x809d,0xa9},
	{0x809e,0x53},
	{0x809f,0xa8},
	{0x80a0,0x52},
	{0x80a1,0xaf},
	{0x80a2,0x2e},
	{0x80a3,0xfc},
	{0x80a4,0xfd},
	{0x80a5,0xfe},
	{0x80a6,0x12},
	{0x80a7,0x08},
	{0x80a8,0x98},
	{0x80a9,0x8f},
	{0x80aa,0x55},
	{0x80ab,0x8e},
	{0x80ac,0x54},
	{0x80ad,0x8d},
	{0x80ae,0x53},
	{0x80af,0x8c},
	{0x80b0,0x52},
	{0x80b1,0xe5},
	{0x80b2,0x2b},
	{0x80b3,0x25},
	{0x80b4,0x55},
	{0x80b5,0xf5},
	{0x80b6,0x2b},
	{0x80b7,0xe5},
	{0x80b8,0x2a},
	{0x80b9,0x35},
	{0x80ba,0x54},
	{0x80bb,0xf5},
	{0x80bc,0x2a},
	{0x80bd,0xe5},
	{0x80be,0x29},
	{0x80bf,0x35},
	{0x80c0,0x53},
	{0x80c1,0xf5},
	{0x80c2,0x29},
	{0x80c3,0xe5},
	{0x80c4,0x28},
	{0x80c5,0x35},
	{0x80c6,0x52},
	{0x80c7,0xf5},
	{0x80c8,0x28},
	{0x80c9,0xae},
	{0x80ca,0x70},
	{0x80cb,0xe4},
	{0x80cc,0x85},
	{0x80cd,0x71},
	{0x80ce,0x55},
	{0x80cf,0x8e},
	{0x80d0,0x54},
	{0x80d1,0xf5},
	{0x80d2,0x53},
	{0x80d3,0xf5},
	{0x80d4,0x52},
	{0x80d5,0xab},
	{0x80d6,0x55},
	{0x80d7,0xaa},
	{0x80d8,0x54},
	{0x80d9,0xa9},
	{0x80da,0x53},
	{0x80db,0xa8},
	{0x80dc,0x52},
	{0x80dd,0xaf},
	{0x80de,0x2f},
	{0x80df,0xfc},
	{0x80e0,0xfd},
	{0x80e1,0xfe},
	{0x80e2,0x12},
	{0x80e3,0x08},
	{0x80e4,0x98},
	{0x80e5,0x8f},
	{0x80e6,0x55},
	{0x80e7,0x8e},
	{0x80e8,0x54},
	{0x80e9,0x8d},
	{0x80ea,0x53},
	{0x80eb,0x8c},
	{0x80ec,0x52},
	{0x80ed,0xe5},
	{0x80ee,0x2b},
	{0x80ef,0x25},
	{0x80f0,0x55},
	{0x80f1,0xf5},
	{0x80f2,0x2b},
	{0x80f3,0xe5},
	{0x80f4,0x2a},
	{0x80f5,0x35},
	{0x80f6,0x54},
	{0x80f7,0xf5},
	{0x80f8,0x2a},
	{0x80f9,0xe5},
	{0x80fa,0x29},
	{0x80fb,0x35},
	{0x80fc,0x53},
	{0x80fd,0xf5},
	{0x80fe,0x29},
	{0x80ff,0xe5},
	{0x8100,0x28},
	{0x8101,0x35},
	{0x8102,0x52},
	{0x8103,0xf5},
	{0x8104,0x28},
	{0x8105,0xae},
	{0x8106,0x72},
	{0x8107,0xe4},
	{0x8108,0x85},
	{0x8109,0x73},
	{0x810a,0x55},
	{0x810b,0x8e},
	{0x810c,0x54},
	{0x810d,0xf5},
	{0x810e,0x53},
	{0x810f,0xf5},
	{0x8110,0x52},
	{0x8111,0xab},
	{0x8112,0x55},
	{0x8113,0xaa},
	{0x8114,0x54},
	{0x8115,0xa9},
	{0x8116,0x53},
	{0x8117,0xa8},
	{0x8118,0x52},
	{0x8119,0xaf},
	{0x811a,0x30},
	{0x811b,0xfc},
	{0x811c,0xfd},
	{0x811d,0xfe},
	{0x811e,0x12},
	{0x811f,0x08},
	{0x8120,0x98},
	{0x8121,0x8f},
	{0x8122,0x55},
	{0x8123,0x8e},
	{0x8124,0x54},
	{0x8125,0x8d},
	{0x8126,0x53},
	{0x8127,0x8c},
	{0x8128,0x52},
	{0x8129,0xe5},
	{0x812a,0x2b},
	{0x812b,0x25},
	{0x812c,0x55},
	{0x812d,0xf5},
	{0x812e,0x2b},
	{0x812f,0xe5},
	{0x8130,0x2a},
	{0x8131,0x35},
	{0x8132,0x54},
	{0x8133,0xf5},
	{0x8134,0x2a},
	{0x8135,0xe5},
	{0x8136,0x29},
	{0x8137,0x35},
	{0x8138,0x53},
	{0x8139,0xf5},
	{0x813a,0x29},
	{0x813b,0xe5},
	{0x813c,0x28},
	{0x813d,0x35},
	{0x813e,0x52},
	{0x813f,0xf5},
	{0x8140,0x28},
	{0x8141,0x22},
	{0x8142,0xab},
	{0x8143,0x0d},
	{0x8144,0xaa},
	{0x8145,0x0c},
	{0x8146,0xa9},
	{0x8147,0x0b},
	{0x8148,0xa8},
	{0x8149,0x0a},
	{0x814a,0xfc},
	{0x814b,0xfd},
	{0x814c,0xfe},
	{0x814d,0x12},
	{0x814e,0x08},
	{0x814f,0x98},
	{0x8150,0x8f},
	{0x8151,0x0d},
	{0x8152,0x8e},
	{0x8153,0x0c},
	{0x8154,0x8d},
	{0x8155,0x0b},
	{0x8156,0x8c},
	{0x8157,0x0a},
	{0x8158,0x7b},
	{0x8159,0x40},
	{0x815a,0xe4},
	{0x815b,0xfa},
	{0x815c,0xf9},
	{0x815d,0xf8},
	{0x815e,0x12},
	{0x815f,0x09},
	{0x8160,0x23},
	{0x8161,0x8f},
	{0x8162,0x0d},
	{0x8163,0x8e},
	{0x8164,0x0c},
	{0x8165,0x8d},
	{0x8166,0x0b},
	{0x8167,0x8c},
	{0x8168,0x0a},
	{0x8169,0x22},
	{0x816a,0xd2},
	{0x816b,0x29},
	{0x816c,0x90},
	{0x816d,0x30},
	{0x816e,0x1b},
	{0x816f,0xe5},
	{0x8170,0x25},
	{0x8171,0xf0},
	{0x8172,0x22},
	{0x8173,0x85},
	{0x8174,0x49},
	{0x8175,0x82},
	{0x8176,0x85},
	{0x8177,0x48},
	{0x8178,0x83},
	{0x8179,0xe5},
	{0x817a,0x7c},
	{0x817b,0x75},
	{0x817c,0xf0},
	{0x817d,0x02},
	{0x817e,0x12},
	{0x817f,0x09},
	{0x8180,0xeb},
	{0x8181,0xe4},
	{0x8182,0x93},
	{0x8183,0xfe},
	{0x8184,0x74},
	{0x8185,0x01},
	{0x8186,0x93},
	{0x8187,0xff},
	{0x8188,0x85},
	{0x8189,0x49},
	{0x818a,0x82},
	{0x818b,0x85},
	{0x818c,0x48},
	{0x818d,0x83},
	{0x818e,0xe4},
	{0x818f,0x93},
	{0x8190,0xfc},
	{0x8191,0x74},
	{0x8192,0x01},
	{0x8193,0x93},
	{0x8194,0xfd},
	{0x8195,0xc3},
	{0x8196,0xef},
	{0x8197,0x9d},
	{0x8198,0xff},
	{0x8199,0xee},
	{0x819a,0x9c},
	{0x819b,0x22},
	{0x819c,0xfe},
	{0x819d,0xe4},
	{0x819e,0xfc},
	{0x819f,0xfd},
	{0x81a0,0xe5},
	{0x81a1,0x3f},
	{0x81a2,0x2f},
	{0x81a3,0xf5},
	{0x81a4,0x3f},
	{0x81a5,0xe5},
	{0x81a6,0x3e},
	{0x81a7,0x3e},
	{0x81a8,0xf5},
	{0x81a9,0x3e},
	{0x81aa,0xed},
	{0x81ab,0x35},
	{0x81ac,0x3d},
	{0x81ad,0xf5},
	{0x81ae,0x3d},
	{0x81af,0xec},
	{0x81b0,0x35},
	{0x81b1,0x3c},
	{0x81b2,0xf5},
	{0x81b3,0x3c},
	{0x81b4,0xaf},
	{0x81b5,0x3f},
	{0x81b6,0xae},
	{0x81b7,0x3e},
	{0x81b8,0xfc},
	{0x81b9,0xad},
	{0x81ba,0x3d},
	{0x81bb,0x78},
	{0x81bc,0x08},
	{0x81bd,0x12},
	{0x81be,0x09},
	{0x81bf,0xc8},
	{0x81c0,0x8f},
	{0x81c1,0x3f},
	{0x81c2,0x8e},
	{0x81c3,0x3e},
	{0x81c4,0x8d},
	{0x81c5,0x3d},
	{0x81c6,0x8c},
	{0x81c7,0x3c},
	{0x81c8,0x22},
	{0x81c9,0xaf},
	{0x81ca,0x2b},
	{0x81cb,0xae},
	{0x81cc,0x2a},
	{0x81cd,0xad},
	{0x81ce,0x29},
	{0x81cf,0xac},
	{0x81d0,0x28},
	{0x81d1,0x78},
	{0x81d2,0x06},
	{0x81d3,0x12},
	{0x81d4,0x09},
	{0x81d5,0xb5},
	{0x81d6,0x8f},
	{0x81d7,0x2b},
	{0x81d8,0x8e},
	{0x81d9,0x2a},
	{0x81da,0x8d},
	{0x81db,0x29},
	{0x81dc,0x8c},
	{0x81dd,0x28},
	{0x81de,0xd3},
	{0x81df,0xe5},
	{0x81e0,0x29},
	{0x81e1,0x94},
	{0x81e2,0x00},
	{0x81e3,0xe5},
	{0x81e4,0x28},
	{0x81e5,0x94},
	{0x81e6,0x00},
	{0x81e7,0x22},
	{0x81e8,0xe5},
	{0x81e9,0x0b},
	{0x81ea,0x24},
	{0x81eb,0x01},
	{0x81ec,0xff},
	{0x81ed,0xe4},
	{0x81ee,0x33},
	{0x81ef,0xfe},
	{0x81f0,0x22},
	{0x81f1,0x12},
	{0x81f2,0x08},
	{0x81f3,0x98},
	{0x81f4,0x8f},
	{0x81f5,0x69},
	{0x81f6,0x8e},
	{0x81f7,0x68},
	{0x81f8,0x8d},
	{0x81f9,0x67},
	{0x81fa,0x8c},
	{0x81fb,0x66},
	{0x81fc,0xaf},
	{0x81fd,0x69},
	{0x81fe,0xae},
	{0x81ff,0x68},
	{0x8200,0xad},
	{0x8201,0x67},
	{0x8202,0xac},
	{0x8203,0x66},
	{0x8204,0x22},
	{0x8205,0xe0},
	{0x8206,0x44},
	{0x8207,0x01},
	{0x8208,0xf0},
	{0x8209,0xe0},
	{0x820a,0x44},
	{0x820b,0x02},
	{0x820c,0xf0},
	{0x820d,0xe0},
	{0x820e,0x44},
	{0x820f,0x04},
	{0x8210,0xf0},
	{0x8211,0x22},
	{0x8212,0xd2},
	{0x8213,0x09},
	{0x8214,0x90},
	{0x8215,0x30},
	{0x8216,0x18},
	{0x8217,0xe5},
	{0x8218,0x21},
	{0x8219,0xf0},
	{0x821a,0x22},
	{0x821b,0xe4},
	{0x821c,0x85},
	{0x821d,0x11},
	{0x821e,0x0d},
	{0x821f,0x85},
	{0x8220,0x10},
	{0x8221,0x0c},
	{0x8222,0xf5},
	{0x8223,0x0b},
	{0x8224,0xf5},
	{0x8225,0x0a},
	{0x8226,0xab},
	{0x8227,0x0d},
	{0x8228,0xaa},
	{0x8229,0x0c},
	{0x822a,0xa9},
	{0x822b,0x0b},
	{0x822c,0xa8},
	{0x822d,0x0a},
	{0x822e,0x22},
	{0x822f,0x90},
	{0x8230,0x30},
	{0x8231,0x42},
	{0x8232,0xe0},
	{0x8233,0xf5},
	{0x8234,0x22},
	{0x8235,0x75},
	{0x8236,0x51},
	{0x8237,0x0a},
	{0x8238,0x22},
	{0x8239,0x85},
	{0x823a,0x49},
	{0x823b,0x82},
	{0x823c,0x85},
	{0x823d,0x48},
	{0x823e,0x83},
	{0x823f,0x22},
	{0x8240,0xf5},
	{0x8241,0x82},
	{0x8242,0xe4},
	{0x8243,0x3a},
	{0x8244,0xf5},
	{0x8245,0x83},
	{0x8246,0x02},
	{0x8247,0x09},
	{0x8248,0xdb},
	{0x8249,0x8f},
	{0x824a,0x0a},
	{0x824b,0x74},
	{0x824c,0x4a},
	{0x824d,0x2f},
	{0x824e,0xf8},
	{0x824f,0xe6},
	{0x8250,0x22},
	{0x8251,0xc2},
	{0x8252,0x07},
	{0x8253,0xc2},
	{0x8254,0x06},
	{0x8255,0xc2},
	{0x8256,0x02},
	{0x8257,0xc2},
	{0x8258,0x01},
	{0x8259,0xc2},
	{0x825a,0x00},
	{0x825b,0xc2},
	{0x825c,0x03},
	{0x825d,0xd2},
	{0x825e,0x04},
	{0x825f,0x22},
	{0x8260,0xe5},
	{0x8261,0x16},
	{0x8262,0x25},
	{0x8263,0xe0},
	{0x8264,0x25},
	{0x8265,0xe0},
	{0x8266,0x22},
	{0x8267,0x12},
	{0x8268,0x09},
	{0x8269,0x23},
	{0x826a,0x8f},
	{0x826b,0x69},
	{0x826c,0x8e},
	{0x826d,0x68},
	{0x826e,0x8d},
	{0x826f,0x67},
	{0x8270,0x8c},
	{0x8271,0x66},
	{0x8272,0x22},
	{0x8273,0xe4},
	{0x8274,0x85},
	{0x8275,0x0f},
	{0x8276,0x0d},
	{0x8277,0x85},
	{0x8278,0x0e},
	{0x8279,0x0c},
	{0x827a,0xf5},
	{0x827b,0x0b},
	{0x827c,0xf5},
	{0x827d,0x0a},
	{0x827e,0x22},
	{0x827f,0x90},
	{0x8280,0x11},
	{0x8281,0x67},
	{0x8282,0xe4},
	{0x8283,0x93},
	{0x8284,0xff},
	{0x8285,0x90},
	{0x8286,0x30},
	{0x8287,0x0a},
	{0x8288,0xe0},
	{0x8289,0x22},
	{0x828a,0xc2},
	{0x828b,0x02},
	{0x828c,0xc2},
	{0x828d,0x01},
	{0x828e,0xd2},
	{0x828f,0x00},
	{0x8290,0xc2},
	{0x8291,0x03},
	{0x8292,0xc2},
	{0x8293,0x04},
	{0x8294,0x22},
	{0x8295,0x75},
	{0x8296,0xf0},
	{0x8297,0x02},
	{0x8298,0x02},
	{0x8299,0x09},
	{0x829a,0xeb},
	{0x829b,0xd2},
	{0x829c,0x02},
	{0x829d,0xd2},
	{0x829e,0x01},
	{0x829f,0xc2},
	{0x82a0,0x00},
	{0x82a1,0x22},
	{0x82a2,0x74},
	{0x82a3,0x4a},
	{0x82a4,0x25},
	{0x82a5,0x0a},
	{0x82a6,0xf8},
	{0x82a7,0xe6},
	{0x82a8,0x22},
	{0x82a9,0xd3},
	{0x82aa,0xe5},
	{0x82ab,0x0b},
	{0x82ac,0x94},
	{0x82ad,0xff},
	{0x82ae,0xe5},
	{0x82af,0x0a},
	{0x82b0,0x94},
	{0x82b1,0x00},
	{0x82b2,0x22},
	{0x82b3,0xd3},
	{0x82b4,0xe5},
	{0x82b5,0x69},
	{0x82b6,0x94},
	{0x82b7,0xff},
	{0x82b8,0xe5},
	{0x82b9,0x68},
	{0x82ba,0x94},
	{0x82bb,0x03},
	{0x82bc,0x22},
	{0x82bd,0x30},
	{0x82be,0x18},
	{0x82bf,0x4d},
	{0x82c0,0x20},
	{0x82c1,0x19},
	{0x82c2,0x4a},
	{0x82c3,0x75},
	{0x82c4,0x0a},
	{0x82c5,0x02},
	{0x82c6,0x12},
	{0x82c7,0x02},
	{0x82c8,0xa2},
	{0x82c9,0xff},
	{0x82ca,0xe5},
	{0x82cb,0x4a},
	{0x82cc,0xd3},
	{0x82cd,0x9f},
	{0x82ce,0x40},
	{0x82cf,0x04},
	{0x82d0,0x7f},
	{0x82d1,0x00},
	{0x82d2,0x80},
	{0x82d3,0x02},
	{0x82d4,0xaf},
	{0x82d5,0x0a},
	{0x82d6,0x12},
	{0x82d7,0x02},
	{0x82d8,0x49},
	{0x82d9,0xff},
	{0x82da,0xe5},
	{0x82db,0x4b},
	{0x82dc,0xd3},
	{0x82dd,0x9f},
	{0x82de,0x40},
	{0x82df,0x04},
	{0x82e0,0x7f},
	{0x82e1,0x01},
	{0x82e2,0x80},
	{0x82e3,0x02},
	{0x82e4,0xaf},
	{0x82e5,0x0a},
	{0x82e6,0x12},
	{0x82e7,0x02},
	{0x82e8,0x49},
	{0x82e9,0xff},
	{0x82ea,0xe5},
	{0x82eb,0x4d},
	{0x82ec,0xd3},
	{0x82ed,0x9f},
	{0x82ee,0x40},
	{0x82ef,0x04},
	{0x82f0,0x7f},
	{0x82f1,0x03},
	{0x82f2,0x80},
	{0x82f3,0x02},
	{0x82f4,0xaf},
	{0x82f5,0x0a},
	{0x82f6,0x12},
	{0x82f7,0x02},
	{0x82f8,0x49},
	{0x82f9,0xff},
	{0x82fa,0xe5},
	{0x82fb,0x4e},
	{0x82fc,0xd3},
	{0x82fd,0x9f},
	{0x82fe,0x40},
	{0x82ff,0x04},
	{0x8300,0x7f},
	{0x8301,0x04},
	{0x8302,0x80},
	{0x8303,0x02},
	{0x8304,0xaf},
	{0x8305,0x0a},
	{0x8306,0x12},
	{0x8307,0x02},
	{0x8308,0x49},
	{0x8309,0xf5},
	{0x830a,0x0b},
	{0x830b,0x80},
	{0x830c,0x06},
	{0x830d,0x85},
	{0x830e,0x79},
	{0x830f,0x0a},
	{0x8310,0x85},
	{0x8311,0x4f},
	{0x8312,0x0b},
	{0x8313,0x7f},
	{0x8314,0x01},
	{0x8315,0xe4},
	{0x8316,0xfe},
	{0x8317,0x12},
	{0x8318,0x02},
	{0x8319,0xa2},
	{0x831a,0xfd},
	{0x831b,0xe5},
	{0x831c,0x0b},
	{0x831d,0xc3},
	{0x831e,0x9d},
	{0x831f,0x50},
	{0x8320,0x04},
	{0x8321,0x7d},
	{0x8322,0x01},
	{0x8323,0x80},
	{0x8324,0x02},
	{0x8325,0x7d},
	{0x8326,0xff},
	{0x8327,0xac},
	{0x8328,0x0b},
	{0x8329,0xe5},
	{0x832a,0x4e},
	{0x832b,0xb5},
	{0x832c,0x0b},
	{0x832d,0x03},
	{0x832e,0xd3},
	{0x832f,0x80},
	{0x8330,0x01},
	{0x8331,0xc3},
	{0x8332,0x92},
	{0x8333,0x1f},
	{0x8334,0xe5},
	{0x8335,0x4d},
	{0x8336,0xb5},
	{0x8337,0x0b},
	{0x8338,0x03},
	{0x8339,0xd3},
	{0x833a,0x80},
	{0x833b,0x01},
	{0x833c,0xc3},
	{0x833d,0x92},
	{0x833e,0x1e},
	{0x833f,0xe5},
	{0x8340,0x4c},
	{0x8341,0xb5},
	{0x8342,0x0b},
	{0x8343,0x03},
	{0x8344,0xd3},
	{0x8345,0x80},
	{0x8346,0x01},
	{0x8347,0xc3},
	{0x8348,0x92},
	{0x8349,0x1d},
	{0x834a,0xe5},
	{0x834b,0x4b},
	{0x834c,0xb5},
	{0x834d,0x0b},
	{0x834e,0x03},
	{0x834f,0xd3},
	{0x8350,0x80},
	{0x8351,0x01},
	{0x8352,0xc3},
	{0x8353,0x92},
	{0x8354,0x1c},
	{0x8355,0xe5},
	{0x8356,0x4a},
	{0x8357,0xb5},
	{0x8358,0x0b},
	{0x8359,0x03},
	{0x835a,0xd3},
	{0x835b,0x80},
	{0x835c,0x01},
	{0x835d,0xc3},
	{0x835e,0x92},
	{0x835f,0x1b},
	{0x8360,0xe5},
	{0x8361,0x30},
	{0x8362,0xd3},
	{0x8363,0x94},
	{0x8364,0x00},
	{0x8365,0x40},
	{0x8366,0x04},
	{0x8367,0xa2},
	{0x8368,0x1f},
	{0x8369,0x80},
	{0x836a,0x01},
	{0x836b,0xc3},
	{0x836c,0x92},
	{0x836d,0x1f},
	{0x836e,0xe5},
	{0x836f,0x2f},
	{0x8370,0xd3},
	{0x8371,0x94},
	{0x8372,0x00},
	{0x8373,0x40},
	{0x8374,0x04},
	{0x8375,0xa2},
	{0x8376,0x1e},
	{0x8377,0x80},
	{0x8378,0x01},
	{0x8379,0xc3},
	{0x837a,0x92},
	{0x837b,0x1e},
	{0x837c,0xe5},
	{0x837d,0x2e},
	{0x837e,0xd3},
	{0x837f,0x94},
	{0x8380,0x00},
	{0x8381,0x40},
	{0x8382,0x04},
	{0x8383,0xa2},
	{0x8384,0x1d},
	{0x8385,0x80},
	{0x8386,0x01},
	{0x8387,0xc3},
	{0x8388,0x92},
	{0x8389,0x1d},
	{0x838a,0xe5},
	{0x838b,0x2d},
	{0x838c,0xd3},
	{0x838d,0x94},
	{0x838e,0x00},
	{0x838f,0x40},
	{0x8390,0x04},
	{0x8391,0xa2},
	{0x8392,0x1c},
	{0x8393,0x80},
	{0x8394,0x01},
	{0x8395,0xc3},
	{0x8396,0x92},
	{0x8397,0x1c},
	{0x8398,0xe5},
	{0x8399,0x2c},
	{0x839a,0xd3},
	{0x839b,0x94},
	{0x839c,0x00},
	{0x839d,0x40},
	{0x839e,0x04},
	{0x839f,0xa2},
	{0x83a0,0x1b},
	{0x83a1,0x80},
	{0x83a2,0x01},
	{0x83a3,0xc3},
	{0x83a4,0x92},
	{0x83a5,0x1b},
	{0x83a6,0xe5},
	{0x83a7,0x23},
	{0x83a8,0x54},
	{0x83a9,0xf8},
	{0x83aa,0x70},
	{0x83ab,0x5b},
	{0x83ac,0xbf},
	{0x83ad,0x01},
	{0x83ae,0x08},
	{0x83af,0xed},
	{0x83b0,0xf4},
	{0x83b1,0x04},
	{0x83b2,0xfd},
	{0x83b3,0x7f},
	{0x83b4,0x02},
	{0x83b5,0x80},
	{0x83b6,0x06},
	{0x83b7,0xbf},
	{0x83b8,0x02},
	{0x83b9,0x02},
	{0x83ba,0x7f},
	{0x83bb,0x01},
	{0x83bc,0x0e},
	{0x83bd,0xd3},
	{0x83be,0xed},
	{0x83bf,0x64},
	{0x83c0,0x80},
	{0x83c1,0x94},
	{0x83c2,0x80},
	{0x83c3,0x40},
	{0x83c4,0x18},
	{0x83c5,0xec},
	{0x83c6,0x2e},
	{0x83c7,0xf5},
	{0x83c8,0x0b},
	{0x83c9,0xd3},
	{0x83ca,0x95},
	{0x83cb,0x7c},
	{0x83cc,0x40},
	{0x83cd,0x2c},
	{0x83ce,0x7d},
	{0x83cf,0xff},
	{0x83d0,0xef},
	{0x83d1,0x60},
	{0x83d2,0x04},
	{0x83d3,0x7b},
	{0x83d4,0x00},
	{0x83d5,0x80},
	{0x83d6,0x02},
	{0x83d7,0x7b},
	{0x83d8,0x03},
	{0x83d9,0xaf},
	{0x83da,0x03},
	{0x83db,0x80},
	{0x83dc,0x18},
	{0x83dd,0xec},
	{0x83de,0xc3},
	{0x83df,0x9e},
	{0x83e0,0x50},
	{0x83e1,0x13},
	{0x83e2,0x7d},
	{0x83e3,0x01},
	{0x83e4,0xef},
	{0x83e5,0x60},
	{0x83e6,0x04},
	{0x83e7,0x7b},
	{0x83e8,0x00},
	{0x83e9,0x80},
	{0x83ea,0x02},
	{0x83eb,0x7b},
	{0x83ec,0x03},
	{0x83ed,0xaf},
	{0x83ee,0x03},
	{0x83ef,0xec},
	{0x83f0,0x2e},
	{0x83f1,0xf5},
	{0x83f2,0x0b},
	{0x83f3,0x80},
	{0x83f4,0x05},
	{0x83f5,0xc3},
	{0x83f6,0xec},
	{0x83f7,0x9e},
	{0x83f8,0xf5},
	{0x83f9,0x0b},
	{0x83fa,0xef},
	{0x83fb,0x64},
	{0x83fc,0x03},
	{0x83fd,0x60},
	{0x83fe,0x03},
	{0x83ff,0x02},
	{0x8400,0x03},
	{0x8401,0x29},
	{0x8402,0x12},
	{0x8403,0x02},
	{0x8404,0xa2},
	{0x8405,0xf5},
	{0x8406,0x0b},
	{0x8407,0x12},
	{0x8408,0x01},
	{0x8409,0xe8},
	{0x840a,0xe5},
	{0x840b,0x4e},
	{0x840c,0xb5},
	{0x840d,0x07},
	{0x840e,0x07},
	{0x840f,0xe4},
	{0x8410,0xb5},
	{0x8411,0x06},
	{0x8412,0x03},
	{0x8413,0xd3},
	{0x8414,0x80},
	{0x8415,0x02},
	{0x8416,0xa2},
	{0x8417,0x1f},
	{0x8418,0x92},
	{0x8419,0x1f},
	{0x841a,0xe5},
	{0x841b,0x4d},
	{0x841c,0xb5},
	{0x841d,0x07},
	{0x841e,0x07},
	{0x841f,0xe4},
	{0x8420,0xb5},
	{0x8421,0x06},
	{0x8422,0x03},
	{0x8423,0xd3},
	{0x8424,0x80},
	{0x8425,0x02},
	{0x8426,0xa2},
	{0x8427,0x1e},
	{0x8428,0x92},
	{0x8429,0x1e},
	{0x842a,0x12},
	{0x842b,0x01},
	{0x842c,0xe8},
	{0x842d,0xe5},
	{0x842e,0x4c},
	{0x842f,0xb5},
	{0x8430,0x07},
	{0x8431,0x07},
	{0x8432,0xe4},
	{0x8433,0xb5},
	{0x8434,0x06},
	{0x8435,0x03},
	{0x8436,0xd3},
	{0x8437,0x80},
	{0x8438,0x02},
	{0x8439,0xa2},
	{0x843a,0x1d},
	{0x843b,0x92},
	{0x843c,0x1d},
	{0x843d,0xe5},
	{0x843e,0x4b},
	{0x843f,0xb5},
	{0x8440,0x07},
	{0x8441,0x07},
	{0x8442,0xe4},
	{0x8443,0xb5},
	{0x8444,0x06},
	{0x8445,0x03},
	{0x8446,0xd3},
	{0x8447,0x80},
	{0x8448,0x02},
	{0x8449,0xa2},
	{0x844a,0x1c},
	{0x844b,0x92},
	{0x844c,0x1c},
	{0x844d,0x12},
	{0x844e,0x01},
	{0x844f,0xe8},
	{0x8450,0xe5},
	{0x8451,0x4a},
	{0x8452,0xb5},
	{0x8453,0x07},
	{0x8454,0x07},
	{0x8455,0xe4},
	{0x8456,0xb5},
	{0x8457,0x06},
	{0x8458,0x03},
	{0x8459,0xd3},
	{0x845a,0x80},
	{0x845b,0x02},
	{0x845c,0xa2},
	{0x845d,0x1b},
	{0x845e,0x92},
	{0x845f,0x1b},
	{0x8460,0xe5},
	{0x8461,0x4e},
	{0x8462,0x12},
	{0x8463,0x01},
	{0x8464,0xea},
	{0x8465,0xad},
	{0x8466,0x0b},
	{0x8467,0x7c},
	{0x8468,0x00},
	{0x8469,0xef},
	{0x846a,0xb5},
	{0x846b,0x05},
	{0x846c,0x07},
	{0x846d,0xec},
	{0x846e,0xb5},
	{0x846f,0x06},
	{0x8470,0x03},
	{0x8471,0xd3},
	{0x8472,0x80},
	{0x8473,0x02},
	{0x8474,0xa2},
	{0x8475,0x1f},
	{0x8476,0x92},
	{0x8477,0x1f},
	{0x8478,0xe5},
	{0x8479,0x4d},
	{0x847a,0x12},
	{0x847b,0x01},
	{0x847c,0xea},
	{0x847d,0xef},
	{0x847e,0xb5},
	{0x847f,0x05},
	{0x8480,0x07},
	{0x8481,0xee},
	{0x8482,0xb5},
	{0x8483,0x04},
	{0x8484,0x03},
	{0x8485,0xd3},
	{0x8486,0x80},
	{0x8487,0x02},
	{0x8488,0xa2},
	{0x8489,0x1e},
	{0x848a,0x92},
	{0x848b,0x1e},
	{0x848c,0xe5},
	{0x848d,0x4c},
	{0x848e,0x12},
	{0x848f,0x01},
	{0x8490,0xea},
	{0x8491,0xad},
	{0x8492,0x0b},
	{0x8493,0x7c},
	{0x8494,0x00},
	{0x8495,0xef},
	{0x8496,0xb5},
	{0x8497,0x05},
	{0x8498,0x07},
	{0x8499,0xec},
	{0x849a,0xb5},
	{0x849b,0x06},
	{0x849c,0x03},
	{0x849d,0xd3},
	{0x849e,0x80},
	{0x849f,0x02},
	{0x84a0,0xa2},
	{0x84a1,0x1d},
	{0x84a2,0x92},
	{0x84a3,0x1d},
	{0x84a4,0xe5},
	{0x84a5,0x4b},
	{0x84a6,0x12},
	{0x84a7,0x01},
	{0x84a8,0xea},
	{0x84a9,0xef},
	{0x84aa,0xb5},
	{0x84ab,0x05},
	{0x84ac,0x07},
	{0x84ad,0xee},
	{0x84ae,0xb5},
	{0x84af,0x04},
	{0x84b0,0x03},
	{0x84b1,0xd3},
	{0x84b2,0x80},
	{0x84b3,0x02},
	{0x84b4,0xa2},
	{0x84b5,0x1c},
	{0x84b6,0x92},
	{0x84b7,0x1c},
	{0x84b8,0xe5},
	{0x84b9,0x4a},
	{0x84ba,0x12},
	{0x84bb,0x01},
	{0x84bc,0xea},
	{0x84bd,0x7c},
	{0x84be,0x00},
	{0x84bf,0xef},
	{0x84c0,0xb5},
	{0x84c1,0x0b},
	{0x84c2,0x07},
	{0x84c3,0xec},
	{0x84c4,0xb5},
	{0x84c5,0x06},
	{0x84c6,0x03},
	{0x84c7,0xd3},
	{0x84c8,0x80},
	{0x84c9,0x02},
	{0x84ca,0xa2},
	{0x84cb,0x1b},
	{0x84cc,0x92},
	{0x84cd,0x1b},
	{0x84ce,0xe5},
	{0x84cf,0x30},
	{0x84d0,0xd3},
	{0x84d1,0x94},
	{0x84d2,0x00},
	{0x84d3,0x40},
	{0x84d4,0x04},
	{0x84d5,0xa2},
	{0x84d6,0x1f},
	{0x84d7,0x80},
	{0x84d8,0x01},
	{0x84d9,0xc3},
	{0x84da,0x92},
	{0x84db,0x1f},
	{0x84dc,0xe5},
	{0x84dd,0x2f},
	{0x84de,0xd3},
	{0x84df,0x94},
	{0x84e0,0x00},
	{0x84e1,0x40},
	{0x84e2,0x04},
	{0x84e3,0xa2},
	{0x84e4,0x1e},
	{0x84e5,0x80},
	{0x84e6,0x01},
	{0x84e7,0xc3},
	{0x84e8,0x92},
	{0x84e9,0x1e},
	{0x84ea,0xe5},
	{0x84eb,0x2e},
	{0x84ec,0xd3},
	{0x84ed,0x94},
	{0x84ee,0x00},
	{0x84ef,0x40},
	{0x84f0,0x04},
	{0x84f1,0xa2},
	{0x84f2,0x1d},
	{0x84f3,0x80},
	{0x84f4,0x01},
	{0x84f5,0xc3},
	{0x84f6,0x92},
	{0x84f7,0x1d},
	{0x84f8,0xe5},
	{0x84f9,0x2d},
	{0x84fa,0xd3},
	{0x84fb,0x94},
	{0x84fc,0x00},
	{0x84fd,0x40},
	{0x84fe,0x04},
	{0x84ff,0xa2},
	{0x8500,0x1c},
	{0x8501,0x80},
	{0x8502,0x01},
	{0x8503,0xc3},
	{0x8504,0x92},
	{0x8505,0x1c},
	{0x8506,0xe5},
	{0x8507,0x2c},
	{0x8508,0xd3},
	{0x8509,0x94},
	{0x850a,0x00},
	{0x850b,0x40},
	{0x850c,0x04},
	{0x850d,0xa2},
	{0x850e,0x1b},
	{0x850f,0x80},
	{0x8510,0x01},
	{0x8511,0xc3},
	{0x8512,0x92},
	{0x8513,0x1b},
	{0x8514,0x85},
	{0x8515,0x0a},
	{0x8516,0x79},
	{0x8517,0xe5},
	{0x8518,0x7d},
	{0x8519,0xb5},
	{0x851a,0x0b},
	{0x851b,0x03},
	{0x851c,0x02},
	{0x851d,0x16},
	{0x851e,0x5f},
	{0x851f,0x85},
	{0x8520,0x0b},
	{0x8521,0x0c},
	{0x8522,0x12},
	{0x8523,0x13},
	{0x8524,0x64},
	{0x8525,0xd2},
	{0x8526,0x02},
	{0x8527,0xc2},
	{0x8528,0x01},
	{0x8529,0xd2},
	{0x852a,0x00},
	{0x852b,0x75},
	{0x852c,0x31},
	{0x852d,0x03},
	{0x852e,0x22},
	{0x852f,0xe5},
	{0x8530,0x7e},
	{0x8531,0x24},
	{0x8532,0xfe},
	{0x8533,0x60},
	{0x8534,0x27},
	{0x8535,0x14},
	{0x8536,0x60},
	{0x8537,0x31},
	{0x8538,0x24},
	{0x8539,0xf8},
	{0x853a,0x60},
	{0x853b,0x3a},
	{0x853c,0x14},
	{0x853d,0x60},
	{0x853e,0x4b},
	{0x853f,0x14},
	{0x8540,0x60},
	{0x8541,0x59},
	{0x8542,0x14},
	{0x8543,0x60},
	{0x8544,0x6a},
	{0x8545,0x24},
	{0x8546,0xfd},
	{0x8547,0x70},
	{0x8548,0x03},
	{0x8549,0x02},
	{0x854a,0x05},
	{0x854b,0xe4},
	{0x854c,0x24},
	{0x854d,0x10},
	{0x854e,0x60},
	{0x854f,0x03},
	{0x8550,0x02},
	{0x8551,0x06},
	{0x8552,0xdf},
	{0x8553,0xe4},
	{0x8554,0xf5},
	{0x8555,0x0a},
	{0x8556,0x12},
	{0x8557,0x12},
	{0x8558,0x9c},
	{0x8559,0x02},
	{0x855a,0x06},
	{0x855b,0xc8},
	{0x855c,0x75},
	{0x855d,0x0a},
	{0x855e,0x01},
	{0x855f,0x12},
	{0x8560,0x06},
	{0x8561,0xe0},
	{0x8562,0xc2},
	{0x8563,0x3c},
	{0x8564,0xd2},
	{0x8565,0x3b},
	{0x8566,0x02},
	{0x8567,0x06},
	{0x8568,0xd9},
	{0x8569,0x75},
	{0x856a,0x0a},
	{0x856b,0x02},
	{0x856c,0x12},
	{0x856d,0x06},
	{0x856e,0xe0},
	{0x856f,0xd2},
	{0x8570,0x3c},
	{0x8571,0xc2},
	{0x8572,0x3b},
	{0x8573,0x02},
	{0x8574,0x06},
	{0x8575,0xd9},
	{0x8576,0x30},
	{0x8577,0x38},
	{0x8578,0x0c},
	{0x8579,0x20},
	{0x857a,0x3c},
	{0x857b,0x03},
	{0x857c,0x30},
	{0x857d,0x3b},
	{0x857e,0x06},
	{0x857f,0xe4},
	{0x8580,0xf5},
	{0x8581,0x0a},
	{0x8582,0x12},
	{0x8583,0x14},
	{0x8584,0x78},
	{0x8585,0xd2},
	{0x8586,0x18},
	{0x8587,0xc2},
	{0x8588,0x19},
	{0x8589,0x22},
	{0x858a,0x30},
	{0x858b,0x38},
	{0x858c,0x09},
	{0x858d,0x20},
	{0x858e,0x3c},
	{0x858f,0x03},
	{0x8590,0x30},
	{0x8591,0x3b},
	{0x8592,0x03},
	{0x8593,0x12},
	{0x8594,0x06},
	{0x8595,0xf1},
	{0x8596,0xd2},
	{0x8597,0x18},
	{0x8598,0xd2},
	{0x8599,0x19},
	{0x859a,0x22},
	{0x859b,0x30},
	{0x859c,0x38},
	{0x859d,0x0c},
	{0x859e,0x20},
	{0x859f,0x3c},
	{0x85a0,0x03},
	{0x85a1,0x30},
	{0x85a2,0x3b},
	{0x85a3,0x06},
	{0x85a4,0x75},
	{0x85a5,0x0a},
	{0x85a6,0x02},
	{0x85a7,0x12},
	{0x85a8,0x14},
	{0x85a9,0x78},
	{0x85aa,0xc2},
	{0x85ab,0x18},
	{0x85ac,0xd2},
	{0x85ad,0x19},
	{0x85ae,0x22},
	{0x85af,0x20},
	{0x85b0,0x3c},
	{0x85b1,0x06},
	{0x85b2,0x20},
	{0x85b3,0x3b},
	{0x85b4,0x03},
	{0x85b5,0x02},
	{0x85b6,0x06},
	{0x85b7,0xdf},
	{0x85b8,0xe5},
	{0x85b9,0x79},
	{0x85ba,0xd3},
	{0x85bb,0x94},
	{0x85bc,0x03},
	{0x85bd,0x40},
	{0x85be,0x04},
	{0x85bf,0x7f},
	{0x85c0,0x00},
	{0x85c1,0x80},
	{0x85c2,0x04},
	{0x85c3,0xe5},
	{0x85c4,0x79},
	{0x85c5,0x04},
	{0x85c6,0xff},
	{0x85c7,0x8f},
	{0x85c8,0x79},
	{0x85c9,0x30},
	{0x85ca,0x18},
	{0x85cb,0x06},
	{0x85cc,0x30},
	{0x85cd,0x19},
	{0x85ce,0x03},
	{0x85cf,0x12},
	{0x85d0,0x06},
	{0x85d1,0xf1},
	{0x85d2,0x30},
	{0x85d3,0x18},
	{0x85d4,0x03},
	{0x85d5,0x02},
	{0x85d6,0x06},
	{0x85d7,0xdf},
	{0x85d8,0x20},
	{0x85d9,0x19},
	{0x85da,0x03},
	{0x85db,0x02},
	{0x85dc,0x06},
	{0x85dd,0xdf},
	{0x85de,0x75},
	{0x85df,0x0a},
	{0x85e0,0x02},
	{0x85e1,0x02},
	{0x85e2,0x14},
	{0x85e3,0x78},
	{0x85e4,0xe5},
	{0x85e5,0x68},
	{0x85e6,0xd3},
	{0x85e7,0x94},
	{0x85e8,0x38},
	{0x85e9,0x40},
	{0x85ea,0x04},
	{0x85eb,0x7f},
	{0x85ec,0x34},
	{0x85ed,0x80},
	{0x85ee,0x02},
	{0x85ef,0xaf},
	{0x85f0,0x68},
	{0x85f1,0x8f},
	{0x85f2,0x68},
	{0x85f3,0xe5},
	{0x85f4,0x68},
	{0x85f5,0xc3},
	{0x85f6,0x94},
	{0x85f7,0x08},
	{0x85f8,0x50},
	{0x85f9,0x04},
	{0x85fa,0x7f},
	{0x85fb,0x08},
	{0x85fc,0x80},
	{0x85fd,0x02},
	{0x85fe,0xaf},
	{0x85ff,0x68},
	{0x8600,0x8f},
	{0x8601,0x68},
	{0x8602,0xe5},
	{0x8603,0x69},
	{0x8604,0xd3},
	{0x8605,0x94},
	{0x8606,0x2a},
	{0x8607,0x40},
	{0x8608,0x04},
	{0x8609,0x7f},
	{0x860a,0x2a},
	{0x860b,0x80},
	{0x860c,0x02},
	{0x860d,0xaf},
	{0x860e,0x69},
	{0x860f,0x8f},
	{0x8610,0x69},
	{0x8611,0xe5},
	{0x8612,0x69},
	{0x8613,0xc3},
	{0x8614,0x94},
	{0x8615,0x06},
	{0x8616,0x50},
	{0x8617,0x04},
	{0x8618,0x7f},
	{0x8619,0x06},
	{0x861a,0x80},
	{0x861b,0x02},
	{0x861c,0xaf},
	{0x861d,0x69},
	{0x861e,0x8f},
	{0x861f,0x69},
	{0x8620,0xaf},
	{0x8621,0x68},
	{0x8622,0xef},
	{0x8623,0x24},
	{0x8624,0xf8},
	{0x8625,0xff},
	{0x8626,0xe4},
	{0x8627,0x34},
	{0x8628,0xff},
	{0x8629,0xfe},
	{0x862a,0xe4},
	{0x862b,0x8f},
	{0x862c,0x3f},
	{0x862d,0x8e},
	{0x862e,0x3e},
	{0x862f,0xf5},
	{0x8630,0x3d},
	{0x8631,0xf5},
	{0x8632,0x3c},
	{0x8633,0xac},
	{0x8634,0x3c},
	{0x8635,0x12},
	{0x8636,0x01},
	{0x8637,0xb9},
	{0x8638,0xaf},
	{0x8639,0x69},
	{0x863a,0xef},
	{0x863b,0x24},
	{0x863c,0xfa},
	{0x863d,0xff},
	{0x863e,0xe4},
	{0x863f,0x34},
	{0x8640,0xff},
	{0x8641,0x12},
	{0x8642,0x01},
	{0x8643,0x9c},
	{0x8644,0xaf},
	{0x8645,0x68},
	{0x8646,0xef},
	{0x8647,0x24},
	{0x8648,0x08},
	{0x8649,0xff},
	{0x864a,0xe4},
	{0x864b,0x33},
	{0x864c,0x12},
	{0x864d,0x01},
	{0x864e,0x9c},
	{0x864f,0xaf},
	{0x8650,0x69},
	{0x8651,0xef},
	{0x8652,0x24},
	{0x8653,0x06},
	{0x8654,0xff},
	{0x8655,0xe4},
	{0x8656,0x33},
	{0x8657,0xfe},
	{0x8658,0xe4},
	{0x8659,0xfc},
	{0x865a,0xfd},
	{0x865b,0xe5},
	{0x865c,0x3f},
	{0x865d,0x2f},
	{0x865e,0xf5},
	{0x865f,0x3f},
	{0x8660,0xe5},
	{0x8661,0x3e},
	{0x8662,0x3e},
	{0x8663,0xf5},
	{0x8664,0x3e},
	{0x8665,0xed},
	{0x8666,0x35},
	{0x8667,0x3d},
	{0x8668,0xf5},
	{0x8669,0x3d},
	{0x866a,0xec},
	{0x866b,0x35},
	{0x866c,0x3c},
	{0x866d,0xf5},
	{0x866e,0x3c},
	{0x866f,0xe4},
	{0x8670,0x25},
	{0x8671,0x3f},
	{0x8672,0xf5},
	{0x8673,0x37},
	{0x8674,0xe4},
	{0x8675,0x35},
	{0x8676,0x3e},
	{0x8677,0xf5},
	{0x8678,0x36},
	{0x8679,0xe4},
	{0x867a,0x35},
	{0x867b,0x3d},
	{0x867c,0xf5},
	{0x867d,0x35},
	{0x867e,0xe5},
	{0x867f,0x3c},
	{0x8680,0x34},
	{0x8681,0x08},
	{0x8682,0xf5},
	{0x8683,0x34},
	{0x8684,0xe4},
	{0x8685,0x25},
	{0x8686,0x3f},
	{0x8687,0xf5},
	{0x8688,0x3b},
	{0x8689,0xe4},
	{0x868a,0x35},
	{0x868b,0x3e},
	{0x868c,0xf5},
	{0x868d,0x3a},
	{0x868e,0xe5},
	{0x868f,0x3d},
	{0x8690,0x34},
	{0x8691,0x06},
	{0x8692,0xf5},
	{0x8693,0x39},
	{0x8694,0xe4},
	{0x8695,0x35},
	{0x8696,0x3c},
	{0x8697,0xf5},
	{0x8698,0x38},
	{0x8699,0xe5},
	{0x869a,0x3f},
	{0x869b,0x24},
	{0x869c,0xfa},
	{0x869d,0xf5},
	{0x869e,0x43},
	{0x869f,0xe5},
	{0x86a0,0x3e},
	{0x86a1,0x34},
	{0x86a2,0xff},
	{0x86a3,0xf5},
	{0x86a4,0x42},
	{0x86a5,0xe5},
	{0x86a6,0x3d},
	{0x86a7,0x34},
	{0x86a8,0xff},
	{0x86a9,0xf5},
	{0x86aa,0x41},
	{0x86ab,0xe5},
	{0x86ac,0x3c},
	{0x86ad,0x34},
	{0x86ae,0xff},
	{0x86af,0xf5},
	{0x86b0,0x40},
	{0x86b1,0xe4},
	{0x86b2,0x25},
	{0x86b3,0x3f},
	{0x86b4,0xf5},
	{0x86b5,0x47},
	{0x86b6,0xe5},
	{0x86b7,0x3e},
	{0x86b8,0x34},
	{0x86b9,0xf8},
	{0x86ba,0xf5},
	{0x86bb,0x46},
	{0x86bc,0xe5},
	{0x86bd,0x3d},
	{0x86be,0x34},
	{0x86bf,0xff},
	{0x86c0,0xf5},
	{0x86c1,0x45},
	{0x86c2,0xe5},
	{0x86c3,0x3c},
	{0x86c4,0x34},
	{0x86c5,0xff},
	{0x86c6,0xf5},
	{0x86c7,0x44},
	{0x86c8,0x75},
	{0x86c9,0x79},
	{0x86ca,0x02},
	{0x86cb,0x75},
	{0x86cc,0x0a},
	{0x86cd,0x01},
	{0x86ce,0x12},
	{0x86cf,0x14},
	{0x86d0,0x78},
	{0x86d1,0xd2},
	{0x86d2,0x18},
	{0x86d3,0xd2},
	{0x86d4,0x19},
	{0x86d5,0xc2},
	{0x86d6,0x3c},
	{0x86d7,0xc2},
	{0x86d8,0x3b},
	{0x86d9,0xd2},
	{0x86da,0x1a},
	{0x86db,0xd2},
	{0x86dc,0x38},
	{0x86dd,0xd2},
	{0x86de,0x30},
	{0x86df,0x22},
	{0x86e0,0x12},
	{0x86e1,0x12},
	{0x86e2,0x9c},
	{0x86e3,0x75},
	{0x86e4,0x79},
	{0x86e5,0x02},
	{0x86e6,0xe4},
	{0x86e7,0xf5},
	{0x86e8,0x0a},
	{0x86e9,0x12},
	{0x86ea,0x14},
	{0x86eb,0x78},
	{0x86ec,0xd2},
	{0x86ed,0x18},
	{0x86ee,0xc2},
	{0x86ef,0x19},
	{0x86f0,0x22},
	{0x86f1,0x75},
	{0x86f2,0x0a},
	{0x86f3,0x01},
	{0x86f4,0x12},
	{0x86f5,0x14},
	{0x86f6,0x78},
	{0x86f7,0x22},
	{0x86f8,0x90},
	{0x86f9,0x38},
	{0x86fa,0x04},
	{0x86fb,0xe0},
	{0x86fc,0xfe},
	{0x86fd,0xa3},
	{0x86fe,0xe0},
	{0x86ff,0xfd},
	{0x8700,0xed},
	{0x8701,0xff},
	{0x8702,0xee},
	{0x8703,0x54},
	{0x8704,0x0f},
	{0x8705,0xf5},
	{0x8706,0x0e},
	{0x8707,0x8f},
	{0x8708,0x0f},
	{0x8709,0xa3},
	{0x870a,0xe0},
	{0x870b,0xfe},
	{0x870c,0xa3},
	{0x870d,0xe0},
	{0x870e,0xfd},
	{0x870f,0xed},
	{0x8710,0xff},
	{0x8711,0xee},
	{0x8712,0x54},
	{0x8713,0x07},
	{0x8714,0xf5},
	{0x8715,0x10},
	{0x8716,0x8f},
	{0x8717,0x11},
	{0x8718,0xe5},
	{0x8719,0x0e},
	{0x871a,0xc4},
	{0x871b,0xf8},
	{0x871c,0x54},
	{0x871d,0xf0},
	{0x871e,0xc8},
	{0x871f,0x68},
	{0x8720,0xf5},
	{0x8721,0x0e},
	{0x8722,0xe5},
	{0x8723,0x0f},
	{0x8724,0xc4},
	{0x8725,0x54},
	{0x8726,0x0f},
	{0x8727,0x48},
	{0x8728,0xf5},
	{0x8729,0x0f},
	{0x872a,0xe5},
	{0x872b,0x10},
	{0x872c,0xc4},
	{0x872d,0xf8},
	{0x872e,0x54},
	{0x872f,0xf0},
	{0x8730,0xc8},
	{0x8731,0x68},
	{0x8732,0xf5},
	{0x8733,0x10},
	{0x8734,0xe5},
	{0x8735,0x11},
	{0x8736,0xc4},
	{0x8737,0x54},
	{0x8738,0x0f},
	{0x8739,0x48},
	{0x873a,0xf5},
	{0x873b,0x11},
	{0x873c,0xe4},
	{0x873d,0xf5},
	{0x873e,0x17},
	{0x873f,0x75},
	{0x8740,0x16},
	{0x8741,0x04},
	{0x8742,0x12},
	{0x8743,0x02},
	{0x8744,0x60},
	{0x8745,0x24},
	{0x8746,0x34},
	{0x8747,0xf8},
	{0x8748,0xe6},
	{0x8749,0xf5},
	{0x874a,0x12},
	{0x874b,0x12},
	{0x874c,0x02},
	{0x874d,0x60},
	{0x874e,0x24},
	{0x874f,0x35},
	{0x8750,0xf8},
	{0x8751,0xe6},
	{0x8752,0xf5},
	{0x8753,0x14},
	{0x8754,0x12},
	{0x8755,0x02},
	{0x8756,0x60},
	{0x8757,0x24},
	{0x8758,0x36},
	{0x8759,0xf8},
	{0x875a,0xe6},
	{0x875b,0xf5},
	{0x875c,0x13},
	{0x875d,0x12},
	{0x875e,0x02},
	{0x875f,0x60},
	{0x8760,0x24},
	{0x8761,0x37},
	{0x8762,0xf8},
	{0x8763,0xe6},
	{0x8764,0xf5},
	{0x8765,0x15},
	{0x8766,0x12},
	{0x8767,0x02},
	{0x8768,0x73},
	{0x8769,0xaf},
	{0x876a,0x12},
	{0x876b,0x12},
	{0x876c,0x01},
	{0x876d,0x42},
	{0x876e,0x8f},
	{0x876f,0x12},
	{0x8770,0x12},
	{0x8771,0x02},
	{0x8772,0x73},
	{0x8773,0xaf},
	{0x8774,0x13},
	{0x8775,0x12},
	{0x8776,0x01},
	{0x8777,0x42},
	{0x8778,0x8f},
	{0x8779,0x13},
	{0x877a,0x12},
	{0x877b,0x02},
	{0x877c,0x1b},
	{0x877d,0xaf},
	{0x877e,0x14},
	{0x877f,0xfc},
	{0x8780,0xfd},
	{0x8781,0xfe},
	{0x8782,0x12},
	{0x8783,0x08},
	{0x8784,0x98},
	{0x8785,0x12},
	{0x8786,0x01},
	{0x8787,0x61},
	{0x8788,0x7b},
	{0x8789,0x30},
	{0x878a,0x12},
	{0x878b,0x01},
	{0x878c,0x5a},
	{0x878d,0x8f},
	{0x878e,0x14},
	{0x878f,0x12},
	{0x8790,0x02},
	{0x8791,0x1b},
	{0x8792,0xaf},
	{0x8793,0x15},
	{0x8794,0xfc},
	{0x8795,0xfd},
	{0x8796,0xfe},
	{0x8797,0x12},
	{0x8798,0x08},
	{0x8799,0x98},
	{0x879a,0x12},
	{0x879b,0x01},
	{0x879c,0x61},
	{0x879d,0xe4},
	{0x879e,0x7b},
	{0x879f,0x30},
	{0x87a0,0x12},
	{0x87a1,0x01},
	{0x87a2,0x5b},
	{0x87a3,0x8f},
	{0x87a4,0x15},
	{0x87a5,0xc3},
	{0x87a6,0xe5},
	{0x87a7,0x13},
	{0x87a8,0x95},
	{0x87a9,0x12},
	{0x87aa,0xff},
	{0x87ab,0x0f},
	{0x87ac,0xef},
	{0x87ad,0xc3},
	{0x87ae,0x13},
	{0x87af,0xff},
	{0x87b0,0xc3},
	{0x87b1,0x94},
	{0x87b2,0x04},
	{0x87b3,0x50},
	{0x87b4,0x27},
	{0x87b5,0xe5},
	{0x87b6,0x12},
	{0x87b7,0x9f},
	{0x87b8,0x40},
	{0x87b9,0x06},
	{0x87ba,0xe5},
	{0x87bb,0x12},
	{0x87bc,0x9f},
	{0x87bd,0xfe},
	{0x87be,0x80},
	{0x87bf,0x02},
	{0x87c0,0x7e},
	{0x87c1,0x00},
	{0x87c2,0x8e},
	{0x87c3,0x12},
	{0x87c4,0xef},
	{0x87c5,0xfd},
	{0x87c6,0xe5},
	{0x87c7,0x13},
	{0x87c8,0x2d},
	{0x87c9,0xfd},
	{0x87ca,0xe4},
	{0x87cb,0x33},
	{0x87cc,0xfc},
	{0x87cd,0xc3},
	{0x87ce,0xed},
	{0x87cf,0x95},
	{0x87d0,0x0f},
	{0x87d1,0xec},
	{0x87d2,0x95},
	{0x87d3,0x0e},
	{0x87d4,0x50},
	{0x87d5,0x02},
	{0x87d6,0x80},
	{0x87d7,0x02},
	{0x87d8,0xad},
	{0x87d9,0x0f},
	{0x87da,0x8d},
	{0x87db,0x13},
	{0x87dc,0xc3},
	{0x87dd,0xe5},
	{0x87de,0x15},
	{0x87df,0x95},
	{0x87e0,0x14},
	{0x87e1,0xff},
	{0x87e2,0xc3},
	{0x87e3,0x94},
	{0x87e4,0x04},
	{0x87e5,0x50},
	{0x87e6,0x29},
	{0x87e7,0xe5},
	{0x87e8,0x14},
	{0x87e9,0x9f},
	{0x87ea,0x40},
	{0x87eb,0x06},
	{0x87ec,0xe5},
	{0x87ed,0x14},
	{0x87ee,0x9f},
	{0x87ef,0xfe},
	{0x87f0,0x80},
	{0x87f1,0x02},
	{0x87f2,0x7e},
	{0x87f3,0x00},
	{0x87f4,0x8e},
	{0x87f5,0x14},
	{0x87f6,0xef},
	{0x87f7,0xfd},
	{0x87f8,0xe5},
	{0x87f9,0x15},
	{0x87fa,0x2d},
	{0x87fb,0xfd},
	{0x87fc,0xe4},
	{0x87fd,0x33},
	{0x87fe,0xfc},
	{0x87ff,0xc3},
	{0x8800,0xed},
	{0x8801,0x95},
	{0x8802,0x11},
	{0x8803,0xec},
	{0x8804,0x95},
	{0x8805,0x10},
	{0x8806,0x50},
	{0x8807,0x04},
	{0x8808,0xaf},
	{0x8809,0x05},
	{0x880a,0x80},
	{0x880b,0x02},
	{0x880c,0xaf},
	{0x880d,0x11},
	{0x880e,0x8f},
	{0x880f,0x15},
	{0x8810,0xe5},
	{0x8811,0x15},
	{0x8812,0xd3},
	{0x8813,0x95},
	{0x8814,0x17},
	{0x8815,0x40},
	{0x8816,0x04},
	{0x8817,0xaf},
	{0x8818,0x15},
	{0x8819,0x80},
	{0x881a,0x02},
	{0x881b,0xaf},
	{0x881c,0x17},
	{0x881d,0x8f},
	{0x881e,0x17},
	{0x881f,0xd3},
	{0x8820,0xe5},
	{0x8821,0x16},
	{0x8822,0x64},
	{0x8823,0x80},
	{0x8824,0x94},
	{0x8825,0x80},
	{0x8826,0x40},
	{0x8827,0x04},
	{0x8828,0xaf},
	{0x8829,0x15},
	{0x882a,0x80},
	{0x882b,0x02},
	{0x882c,0xaf},
	{0x882d,0x17},
	{0x882e,0x8f},
	{0x882f,0x15},
	{0x8830,0xe5},
	{0x8831,0x16},
	{0x8832,0xfd},
	{0x8833,0x33},
	{0x8834,0x95},
	{0x8835,0xe0},
	{0x8836,0xfc},
	{0x8837,0xed},
	{0x8838,0xae},
	{0x8839,0x04},
	{0x883a,0x78},
	{0x883b,0x02},
	{0x883c,0xc3},
	{0x883d,0x33},
	{0x883e,0xce},
	{0x883f,0x33},
	{0x8840,0xce},
	{0x8841,0xd8},
	{0x8842,0xf9},
	{0x8843,0xff},
	{0x8844,0x24},
	{0x8845,0x01},
	{0x8846,0xfb},
	{0x8847,0xee},
	{0x8848,0x34},
	{0x8849,0x60},
	{0x884a,0x8b},
	{0x884b,0x82},
	{0x884c,0xf5},
	{0x884d,0x83},
	{0x884e,0xe5},
	{0x884f,0x12},
	{0x8850,0xf0},
	{0x8851,0xef},
	{0x8852,0x24},
	{0x8853,0x02},
	{0x8854,0xff},
	{0x8855,0xee},
	{0x8856,0x34},
	{0x8857,0x60},
	{0x8858,0x8f},
	{0x8859,0x82},
	{0x885a,0xf5},
	{0x885b,0x83},
	{0x885c,0xe5},
	{0x885d,0x14},
	{0x885e,0xf0},
	{0x885f,0xed},
	{0x8860,0xae},
	{0x8861,0x04},
	{0x8862,0x78},
	{0x8863,0x02},
	{0x8864,0xc3},
	{0x8865,0x33},
	{0x8866,0xce},
	{0x8867,0x33},
	{0x8868,0xce},
	{0x8869,0xd8},
	{0x886a,0xf9},
	{0x886b,0xff},
	{0x886c,0x24},
	{0x886d,0x03},
	{0x886e,0xfd},
	{0x886f,0xee},
	{0x8870,0x34},
	{0x8871,0x60},
	{0x8872,0x8d},
	{0x8873,0x82},
	{0x8874,0xf5},
	{0x8875,0x83},
	{0x8876,0xe5},
	{0x8877,0x13},
	{0x8878,0xf0},
	{0x8879,0xef},
	{0x887a,0x24},
	{0x887b,0x04},
	{0x887c,0xff},
	{0x887d,0xee},
	{0x887e,0x34},
	{0x887f,0x60},
	{0x8880,0x8f},
	{0x8881,0x82},
	{0x8882,0xf5},
	{0x8883,0x83},
	{0x8884,0xe5},
	{0x8885,0x15},
	{0x8886,0xf0},
	{0x8887,0x15},
	{0x8888,0x16},
	{0x8889,0xc3},
	{0x888a,0xe5},
	{0x888b,0x16},
	{0x888c,0x64},
	{0x888d,0x80},
	{0x888e,0x94},
	{0x888f,0x80},
	{0x8890,0x40},
	{0x8891,0x03},
	{0x8892,0x02},
	{0x8893,0x07},
	{0x8894,0x42},
	{0x8895,0xc2},
	{0x8896,0x30},
	{0x8897,0x22},
	{0x8898,0xe8},
	{0x8899,0x8f},
	{0x889a,0xf0},
	{0x889b,0xa4},
	{0x889c,0xcc},
	{0x889d,0x8b},
	{0x889e,0xf0},
	{0x889f,0xa4},
	{0x88a0,0x2c},
	{0x88a1,0xfc},
	{0x88a2,0xe9},
	{0x88a3,0x8e},
	{0x88a4,0xf0},
	{0x88a5,0xa4},
	{0x88a6,0x2c},
	{0x88a7,0xfc},
	{0x88a8,0x8a},
	{0x88a9,0xf0},
	{0x88aa,0xed},
	{0x88ab,0xa4},
	{0x88ac,0x2c},
	{0x88ad,0xfc},
	{0x88ae,0xea},
	{0x88af,0x8e},
	{0x88b0,0xf0},
	{0x88b1,0xa4},
	{0x88b2,0xcd},
	{0x88b3,0xa8},
	{0x88b4,0xf0},
	{0x88b5,0x8b},
	{0x88b6,0xf0},
	{0x88b7,0xa4},
	{0x88b8,0x2d},
	{0x88b9,0xcc},
	{0x88ba,0x38},
	{0x88bb,0x25},
	{0x88bc,0xf0},
	{0x88bd,0xfd},
	{0x88be,0xe9},
	{0x88bf,0x8f},
	{0x88c0,0xf0},
	{0x88c1,0xa4},
	{0x88c2,0x2c},
	{0x88c3,0xcd},
	{0x88c4,0x35},
	{0x88c5,0xf0},
	{0x88c6,0xfc},
	{0x88c7,0xeb},
	{0x88c8,0x8e},
	{0x88c9,0xf0},
	{0x88ca,0xa4},
	{0x88cb,0xfe},
	{0x88cc,0xa9},
	{0x88cd,0xf0},
	{0x88ce,0xeb},
	{0x88cf,0x8f},
	{0x88d0,0xf0},
	{0x88d1,0xa4},
	{0x88d2,0xcf},
	{0x88d3,0xc5},
	{0x88d4,0xf0},
	{0x88d5,0x2e},
	{0x88d6,0xcd},
	{0x88d7,0x39},
	{0x88d8,0xfe},
	{0x88d9,0xe4},
	{0x88da,0x3c},
	{0x88db,0xfc},
	{0x88dc,0xea},
	{0x88dd,0xa4},
	{0x88de,0x2d},
	{0x88df,0xce},
	{0x88e0,0x35},
	{0x88e1,0xf0},
	{0x88e2,0xfd},
	{0x88e3,0xe4},
	{0x88e4,0x3c},
	{0x88e5,0xfc},
	{0x88e6,0x22},
	{0x88e7,0x75},
	{0x88e8,0xf0},
	{0x88e9,0x08},
	{0x88ea,0x75},
	{0x88eb,0x82},
	{0x88ec,0x00},
	{0x88ed,0xef},
	{0x88ee,0x2f},
	{0x88ef,0xff},
	{0x88f0,0xee},
	{0x88f1,0x33},
	{0x88f2,0xfe},
	{0x88f3,0xcd},
	{0x88f4,0x33},
	{0x88f5,0xcd},
	{0x88f6,0xcc},
	{0x88f7,0x33},
	{0x88f8,0xcc},
	{0x88f9,0xc5},
	{0x88fa,0x82},
	{0x88fb,0x33},
	{0x88fc,0xc5},
	{0x88fd,0x82},
	{0x88fe,0x9b},
	{0x88ff,0xed},
	{0x8900,0x9a},
	{0x8901,0xec},
	{0x8902,0x99},
	{0x8903,0xe5},
	{0x8904,0x82},
	{0x8905,0x98},
	{0x8906,0x40},
	{0x8907,0x0c},
	{0x8908,0xf5},
	{0x8909,0x82},
	{0x890a,0xee},
	{0x890b,0x9b},
	{0x890c,0xfe},
	{0x890d,0xed},
	{0x890e,0x9a},
	{0x890f,0xfd},
	{0x8910,0xec},
	{0x8911,0x99},
	{0x8912,0xfc},
	{0x8913,0x0f},
	{0x8914,0xd5},
	{0x8915,0xf0},
	{0x8916,0xd6},
	{0x8917,0xe4},
	{0x8918,0xce},
	{0x8919,0xfb},
	{0x891a,0xe4},
	{0x891b,0xcd},
	{0x891c,0xfa},
	{0x891d,0xe4},
	{0x891e,0xcc},
	{0x891f,0xf9},
	{0x8920,0xa8},
	{0x8921,0x82},
	{0x8922,0x22},
	{0x8923,0xb8},
	{0x8924,0x00},
	{0x8925,0xc1},
	{0x8926,0xb9},
	{0x8927,0x00},
	{0x8928,0x59},
	{0x8929,0xba},
	{0x892a,0x00},
	{0x892b,0x2d},
	{0x892c,0xec},
	{0x892d,0x8b},
	{0x892e,0xf0},
	{0x892f,0x84},
	{0x8930,0xcf},
	{0x8931,0xce},
	{0x8932,0xcd},
	{0x8933,0xfc},
	{0x8934,0xe5},
	{0x8935,0xf0},
	{0x8936,0xcb},
	{0x8937,0xf9},
	{0x8938,0x78},
	{0x8939,0x18},
	{0x893a,0xef},
	{0x893b,0x2f},
	{0x893c,0xff},
	{0x893d,0xee},
	{0x893e,0x33},
	{0x893f,0xfe},
	{0x8940,0xed},
	{0x8941,0x33},
	{0x8942,0xfd},
	{0x8943,0xec},
	{0x8944,0x33},
	{0x8945,0xfc},
	{0x8946,0xeb},
	{0x8947,0x33},
	{0x8948,0xfb},
	{0x8949,0x10},
	{0x894a,0xd7},
	{0x894b,0x03},
	{0x894c,0x99},
	{0x894d,0x40},
	{0x894e,0x04},
	{0x894f,0xeb},
	{0x8950,0x99},
	{0x8951,0xfb},
	{0x8952,0x0f},
	{0x8953,0xd8},
	{0x8954,0xe5},
	{0x8955,0xe4},
	{0x8956,0xf9},
	{0x8957,0xfa},
	{0x8958,0x22},
	{0x8959,0x78},
	{0x895a,0x18},
	{0x895b,0xef},
	{0x895c,0x2f},
	{0x895d,0xff},
	{0x895e,0xee},
	{0x895f,0x33},
	{0x8960,0xfe},
	{0x8961,0xed},
	{0x8962,0x33},
	{0x8963,0xfd},
	{0x8964,0xec},
	{0x8965,0x33},
	{0x8966,0xfc},
	{0x8967,0xc9},
	{0x8968,0x33},
	{0x8969,0xc9},
	{0x896a,0x10},
	{0x896b,0xd7},
	{0x896c,0x05},
	{0x896d,0x9b},
	{0x896e,0xe9},
	{0x896f,0x9a},
	{0x8970,0x40},
	{0x8971,0x07},
	{0x8972,0xec},
	{0x8973,0x9b},
	{0x8974,0xfc},
	{0x8975,0xe9},
	{0x8976,0x9a},
	{0x8977,0xf9},
	{0x8978,0x0f},
	{0x8979,0xd8},
	{0x897a,0xe0},
	{0x897b,0xe4},
	{0x897c,0xc9},
	{0x897d,0xfa},
	{0x897e,0xe4},
	{0x897f,0xcc},
	{0x8980,0xfb},
	{0x8981,0x22},
	{0x8982,0x75},
	{0x8983,0xf0},
	{0x8984,0x10},
	{0x8985,0xef},
	{0x8986,0x2f},
	{0x8987,0xff},
	{0x8988,0xee},
	{0x8989,0x33},
	{0x898a,0xfe},
	{0x898b,0xed},
	{0x898c,0x33},
	{0x898d,0xfd},
	{0x898e,0xcc},
	{0x898f,0x33},
	{0x8990,0xcc},
	{0x8991,0xc8},
	{0x8992,0x33},
	{0x8993,0xc8},
	{0x8994,0x10},
	{0x8995,0xd7},
	{0x8996,0x07},
	{0x8997,0x9b},
	{0x8998,0xec},
	{0x8999,0x9a},
	{0x899a,0xe8},
	{0x899b,0x99},
	{0x899c,0x40},
	{0x899d,0x0a},
	{0x899e,0xed},
	{0x899f,0x9b},
	{0x89a0,0xfd},
	{0x89a1,0xec},
	{0x89a2,0x9a},
	{0x89a3,0xfc},
	{0x89a4,0xe8},
	{0x89a5,0x99},
	{0x89a6,0xf8},
	{0x89a7,0x0f},
	{0x89a8,0xd5},
	{0x89a9,0xf0},
	{0x89aa,0xda},
	{0x89ab,0xe4},
	{0x89ac,0xcd},
	{0x89ad,0xfb},
	{0x89ae,0xe4},
	{0x89af,0xcc},
	{0x89b0,0xfa},
	{0x89b1,0xe4},
	{0x89b2,0xc8},
	{0x89b3,0xf9},
	{0x89b4,0x22},
	{0x89b5,0xe8},
	{0x89b6,0x60},
	{0x89b7,0x0f},
	{0x89b8,0xec},
	{0x89b9,0xc3},
	{0x89ba,0x13},
	{0x89bb,0xfc},
	{0x89bc,0xed},
	{0x89bd,0x13},
	{0x89be,0xfd},
	{0x89bf,0xee},
	{0x89c0,0x13},
	{0x89c1,0xfe},
	{0x89c2,0xef},
	{0x89c3,0x13},
	{0x89c4,0xff},
	{0x89c5,0xd8},
	{0x89c6,0xf1},
	{0x89c7,0x22},
	{0x89c8,0xe8},
	{0x89c9,0x60},
	{0x89ca,0x0f},
	{0x89cb,0xef},
	{0x89cc,0xc3},
	{0x89cd,0x33},
	{0x89ce,0xff},
	{0x89cf,0xee},
	{0x89d0,0x33},
	{0x89d1,0xfe},
	{0x89d2,0xed},
	{0x89d3,0x33},
	{0x89d4,0xfd},
	{0x89d5,0xec},
	{0x89d6,0x33},
	{0x89d7,0xfc},
	{0x89d8,0xd8},
	{0x89d9,0xf1},
	{0x89da,0x22},
	{0x89db,0xe4},
	{0x89dc,0x93},
	{0x89dd,0xfc},
	{0x89de,0x74},
	{0x89df,0x01},
	{0x89e0,0x93},
	{0x89e1,0xfd},
	{0x89e2,0x74},
	{0x89e3,0x02},
	{0x89e4,0x93},
	{0x89e5,0xfe},
	{0x89e6,0x74},
	{0x89e7,0x03},
	{0x89e8,0x93},
	{0x89e9,0xff},
	{0x89ea,0x22},
	{0x89eb,0xa4},
	{0x89ec,0x25},
	{0x89ed,0x82},
	{0x89ee,0xf5},
	{0x89ef,0x82},
	{0x89f0,0xe5},
	{0x89f1,0xf0},
	{0x89f2,0x35},
	{0x89f3,0x83},
	{0x89f4,0xf5},
	{0x89f5,0x83},
	{0x89f6,0x22},
	{0x89f7,0xd0},
	{0x89f8,0x83},
	{0x89f9,0xd0},
	{0x89fa,0x82},
	{0x89fb,0xf8},
	{0x89fc,0xe4},
	{0x89fd,0x93},
	{0x89fe,0x70},
	{0x89ff,0x12},
	{0x8a00,0x74},
	{0x8a01,0x01},
	{0x8a02,0x93},
	{0x8a03,0x70},
	{0x8a04,0x0d},
	{0x8a05,0xa3},
	{0x8a06,0xa3},
	{0x8a07,0x93},
	{0x8a08,0xf8},
	{0x8a09,0x74},
	{0x8a0a,0x01},
	{0x8a0b,0x93},
	{0x8a0c,0xf5},
	{0x8a0d,0x82},
	{0x8a0e,0x88},
	{0x8a0f,0x83},
	{0x8a10,0xe4},
	{0x8a11,0x73},
	{0x8a12,0x74},
	{0x8a13,0x02},
	{0x8a14,0x93},
	{0x8a15,0x68},
	{0x8a16,0x60},
	{0x8a17,0xef},
	{0x8a18,0xa3},
	{0x8a19,0xa3},
	{0x8a1a,0xa3},
	{0x8a1b,0x80},
	{0x8a1c,0xdf},
	{0x8a1d,0x75},
	{0x8a1e,0x0f},
	{0x8a1f,0x0a},
	{0x8a20,0xa2},
	{0x8a21,0xaf},
	{0x8a22,0x92},
	{0x8a23,0x32},
	{0x8a24,0xc2},
	{0x8a25,0xaf},
	{0x8a26,0xc2},
	{0x8a27,0x33},
	{0x8a28,0x12},
	{0x8a29,0x01},
	{0x8a2a,0x6a},
	{0x8a2b,0x12},
	{0x8a2c,0x02},
	{0x8a2d,0x12},
	{0x8a2e,0x12},
	{0x8a2f,0x01},
	{0x8a30,0x6a},
	{0x8a31,0x75},
	{0x8a32,0x51},
	{0x8a33,0x05},
	{0x8a34,0xaf},
	{0x8a35,0x51},
	{0x8a36,0x15},
	{0x8a37,0x51},
	{0x8a38,0xef},
	{0x8a39,0x70},
	{0x8a3a,0xf9},
	{0x8a3b,0xd2},
	{0x8a3c,0x28},
	{0x8a3d,0x12},
	{0x8a3e,0x01},
	{0x8a3f,0x6c},
	{0x8a40,0x75},
	{0x8a41,0x51},
	{0x8a42,0x0a},
	{0x8a43,0xaf},
	{0x8a44,0x51},
	{0x8a45,0x15},
	{0x8a46,0x51},
	{0x8a47,0xef},
	{0x8a48,0x70},
	{0x8a49,0xf9},
	{0x8a4a,0xc2},
	{0x8a4b,0x29},
	{0x8a4c,0x12},
	{0x8a4d,0x01},
	{0x8a4e,0x6c},
	{0x8a4f,0x75},
	{0x8a50,0x51},
	{0x8a51,0x05},
	{0x8a52,0xaf},
	{0x8a53,0x51},
	{0x8a54,0x15},
	{0x8a55,0x51},
	{0x8a56,0xef},
	{0x8a57,0x70},
	{0x8a58,0xf9},
	{0x8a59,0xc2},
	{0x8a5a,0x28},
	{0x8a5b,0x12},
	{0x8a5c,0x01},
	{0x8a5d,0x6c},
	{0x8a5e,0x75},
	{0x8a5f,0x51},
	{0x8a60,0x05},
	{0x8a61,0xaf},
	{0x8a62,0x51},
	{0x8a63,0x15},
	{0x8a64,0x51},
	{0x8a65,0xef},
	{0x8a66,0x70},
	{0x8a67,0xf9},
	{0x8a68,0x75},
	{0x8a69,0x10},
	{0x8a6a,0x18},
	{0x8a6b,0x12},
	{0x8a6c,0x0b},
	{0x8a6d,0x5d},
	{0x8a6e,0x75},
	{0x8a6f,0x51},
	{0x8a70,0x0a},
	{0x8a71,0xaf},
	{0x8a72,0x51},
	{0x8a73,0x15},
	{0x8a74,0x51},
	{0x8a75,0xef},
	{0x8a76,0x70},
	{0x8a77,0xf9},
	{0x8a78,0xd2},
	{0x8a79,0x28},
	{0x8a7a,0x12},
	{0x8a7b,0x01},
	{0x8a7c,0x6c},
	{0x8a7d,0x12},
	{0x8a7e,0x02},
	{0x8a7f,0x2f},
	{0x8a80,0xaf},
	{0x8a81,0x51},
	{0x8a82,0x15},
	{0x8a83,0x51},
	{0x8a84,0xef},
	{0x8a85,0x70},
	{0x8a86,0xf9},
	{0x8a87,0xc2},
	{0x8a88,0x28},
	{0x8a89,0x12},
	{0x8a8a,0x01},
	{0x8a8b,0x6c},
	{0x8a8c,0x75},
	{0x8a8d,0x51},
	{0x8a8e,0x0a},
	{0x8a8f,0xaf},
	{0x8a90,0x51},
	{0x8a91,0x15},
	{0x8a92,0x51},
	{0x8a93,0xef},
	{0x8a94,0x70},
	{0x8a95,0xf9},
	{0x8a96,0x30},
	{0x8a97,0x11},
	{0x8a98,0x03},
	{0x8a99,0x02},
	{0x8a9a,0x0b},
	{0x8a9b,0x14},
	{0x8a9c,0x12},
	{0x8a9d,0x01},
	{0x8a9e,0x6a},
	{0x8a9f,0x12},
	{0x8aa0,0x02},
	{0x8aa1,0x12},
	{0x8aa2,0xe5},
	{0x8aa3,0x0d},
	{0x8aa4,0xf5},
	{0x8aa5,0x10},
	{0x8aa6,0x12},
	{0x8aa7,0x0b},
	{0x8aa8,0x5d},
	{0x8aa9,0x75},
	{0x8aaa,0x51},
	{0x8aab,0x0a},
	{0x8aac,0xaf},
	{0x8aad,0x51},
	{0x8aae,0x15},
	{0x8aaf,0x51},
	{0x8ab0,0xef},
	{0x8ab1,0x70},
	{0x8ab2,0xf9},
	{0x8ab3,0xd2},
	{0x8ab4,0x28},
	{0x8ab5,0x12},
	{0x8ab6,0x01},
	{0x8ab7,0x6c},
	{0x8ab8,0x12},
	{0x8ab9,0x02},
	{0x8aba,0x2f},
	{0x8abb,0xaf},
	{0x8abc,0x51},
	{0x8abd,0x15},
	{0x8abe,0x51},
	{0x8abf,0xef},
	{0x8ac0,0x70},
	{0x8ac1,0xf9},
	{0x8ac2,0xc2},
	{0x8ac3,0x28},
	{0x8ac4,0x12},
	{0x8ac5,0x01},
	{0x8ac6,0x6c},
	{0x8ac7,0x75},
	{0x8ac8,0x51},
	{0x8ac9,0x0a},
	{0x8aca,0xaf},
	{0x8acb,0x51},
	{0x8acc,0x15},
	{0x8acd,0x51},
	{0x8ace,0xef},
	{0x8acf,0x70},
	{0x8ad0,0xf9},
	{0x8ad1,0x30},
	{0x8ad2,0x11},
	{0x8ad3,0x04},
	{0x8ad4,0x15},
	{0x8ad5,0x0f},
	{0x8ad6,0x80},
	{0x8ad7,0x45},
	{0x8ad8,0x12},
	{0x8ad9,0x01},
	{0x8ada,0x6a},
	{0x8adb,0x12},
	{0x8adc,0x02},
	{0x8add,0x12},
	{0x8ade,0x85},
	{0x8adf,0x0e},
	{0x8ae0,0x10},
	{0x8ae1,0x12},
	{0x8ae2,0x15},
	{0x8ae3,0xa4},
	{0x8ae4,0xc2},
	{0x8ae5,0x09},
	{0x8ae6,0x12},
	{0x8ae7,0x02},
	{0x8ae8,0x14},
	{0x8ae9,0x75},
	{0x8aea,0x51},
	{0x8aeb,0x0a},
	{0x8aec,0xaf},
	{0x8aed,0x51},
	{0x8aee,0x15},
	{0x8aef,0x51},
	{0x8af0,0xef},
	{0x8af1,0x70},
	{0x8af2,0xf9},
	{0x8af3,0xd2},
	{0x8af4,0x28},
	{0x8af5,0x12},
	{0x8af6,0x01},
	{0x8af7,0x6c},
	{0x8af8,0x12},
	{0x8af9,0x02},
	{0x8afa,0x2f},
	{0x8afb,0xaf},
	{0x8afc,0x51},
	{0x8afd,0x15},
	{0x8afe,0x51},
	{0x8aff,0xef},
	{0x8b00,0x70},
	{0x8b01,0xf9},
	{0x8b02,0xc2},
	{0x8b03,0x28},
	{0x8b04,0x12},
	{0x8b05,0x01},
	{0x8b06,0x6c},
	{0x8b07,0x75},
	{0x8b08,0x51},
	{0x8b09,0x0a},
	{0x8b0a,0xaf},
	{0x8b0b,0x51},
	{0x8b0c,0x15},
	{0x8b0d,0x51},
	{0x8b0e,0xef},
	{0x8b0f,0x70},
	{0x8b10,0xf9},
	{0x8b11,0x30},
	{0x8b12,0x11},
	{0x8b13,0x06},
	{0x8b14,0x15},
	{0x8b15,0x0f},
	{0x8b16,0xd2},
	{0x8b17,0x33},
	{0x8b18,0x80},
	{0x8b19,0x03},
	{0x8b1a,0xe4},
	{0x8b1b,0xf5},
	{0x8b1c,0x0f},
	{0x8b1d,0x12},
	{0x8b1e,0x01},
	{0x8b1f,0x6a},
	{0x8b20,0x12},
	{0x8b21,0x02},
	{0x8b22,0x12},
	{0x8b23,0xc2},
	{0x8b24,0x29},
	{0x8b25,0x12},
	{0x8b26,0x01},
	{0x8b27,0x6c},
	{0x8b28,0x75},
	{0x8b29,0x51},
	{0x8b2a,0x05},
	{0x8b2b,0xaf},
	{0x8b2c,0x51},
	{0x8b2d,0x15},
	{0x8b2e,0x51},
	{0x8b2f,0xef},
	{0x8b30,0x70},
	{0x8b31,0xf9},
	{0x8b32,0xd2},
	{0x8b33,0x28},
	{0x8b34,0x12},
	{0x8b35,0x01},
	{0x8b36,0x6c},
	{0x8b37,0x75},
	{0x8b38,0x51},
	{0x8b39,0x05},
	{0x8b3a,0xaf},
	{0x8b3b,0x51},
	{0x8b3c,0x15},
	{0x8b3d,0x51},
	{0x8b3e,0xef},
	{0x8b3f,0x70},
	{0x8b40,0xf9},
	{0x8b41,0x12},
	{0x8b42,0x01},
	{0x8b43,0x6a},
	{0x8b44,0x75},
	{0x8b45,0x51},
	{0x8b46,0x05},
	{0x8b47,0xaf},
	{0x8b48,0x51},
	{0x8b49,0x15},
	{0x8b4a,0x51},
	{0x8b4b,0xef},
	{0x8b4c,0x70},
	{0x8b4d,0xf9},
	{0x8b4e,0xa2},
	{0x8b4f,0x32},
	{0x8b50,0x92},
	{0x8b51,0xaf},
	{0x8b52,0xe5},
	{0x8b53,0x0f},
	{0x8b54,0xd3},
	{0x8b55,0x94},
	{0x8b56,0x00},
	{0x8b57,0x40},
	{0x8b58,0x03},
	{0x8b59,0x02},
	{0x8b5a,0x0a},
	{0x8b5b,0x24},
	{0x8b5c,0x22},
	{0x8b5d,0x12},
	{0x8b5e,0x15},
	{0x8b5f,0xa4},
	{0x8b60,0xc2},
	{0x8b61,0x09},
	{0x8b62,0x90},
	{0x8b63,0x30},
	{0x8b64,0x18},
	{0x8b65,0xe5},
	{0x8b66,0x21},
	{0x8b67,0xf0},
	{0x8b68,0x22},
	{0x8b69,0xe5},
	{0x8b6a,0x33},
	{0x8b6b,0x70},
	{0x8b6c,0x03},
	{0x8b6d,0x02},
	{0x8b6e,0x0c},
	{0x8b6f,0xa3},
	{0x8b70,0xc2},
	{0x8b71,0xaf},
	{0x8b72,0xaf},
	{0x8b73,0x33},
	{0x8b74,0xe4},
	{0x8b75,0xf5},
	{0x8b76,0x33},
	{0x8b77,0xd2},
	{0x8b78,0xaf},
	{0x8b79,0x90},
	{0x8b7a,0x30},
	{0x8b7b,0x25},
	{0x8b7c,0xe0},
	{0x8b7d,0xf5},
	{0x8b7e,0x7e},
	{0x8b7f,0x90},
	{0x8b80,0x50},
	{0x8b81,0x82},
	{0x8b82,0xe0},
	{0x8b83,0xf5},
	{0x8b84,0x66},
	{0x8b85,0xa3},
	{0x8b86,0xe0},
	{0x8b87,0xf5},
	{0x8b88,0x67},
	{0x8b89,0xa3},
	{0x8b8a,0xe0},
	{0x8b8b,0xf5},
	{0x8b8c,0x68},
	{0x8b8d,0xa3},
	{0x8b8e,0xe0},
	{0x8b8f,0xf5},
	{0x8b90,0x69},
	{0x8b91,0xef},
	{0x8b92,0x12},
	{0x8b93,0x09},
	{0x8b94,0xf7},
	{0x8b95,0x0b},
	{0x8b96,0xbd},
	{0x8b97,0x03},
	{0x8b98,0x0b},
	{0x8b99,0xdb},
	{0x8b9a,0x04},
	{0x8b9b,0x0b},
	{0x8b9c,0xfc},
	{0x8b9d,0x05},
	{0x8b9e,0x0c},
	{0x8b9f,0x26},
	{0x8ba0,0x06},
	{0x8ba1,0x0c},
	{0x8ba2,0x14},
	{0x8ba3,0x08},
	{0x8ba4,0x0c},
	{0x8ba5,0x33},
	{0x8ba6,0x10},
	{0x8ba7,0x0c},
	{0x8ba8,0x47},
	{0x8ba9,0x12},
	{0x8baa,0x0c},
	{0x8bab,0x4c},
	{0x8bac,0x20},
	{0x8bad,0x0c},
	{0x8bae,0x5a},
	{0x8baf,0x21},
	{0x8bb0,0x0c},
	{0x8bb1,0x5f},
	{0x8bb2,0x30},
	{0x8bb3,0x0c},
	{0x8bb4,0x88},
	{0x8bb5,0x50},
	{0x8bb6,0x0c},
	{0x8bb7,0x6a},
	{0x8bb8,0xd8},
	{0x8bb9,0x00},
	{0x8bba,0x00},
	{0x8bbb,0x0c},
	{0x8bbc,0x95},
	{0x8bbd,0x20},
	{0x8bbe,0x05},
	{0x8bbf,0x03},
	{0x8bc0,0x02},
	{0x8bc1,0x0c},
	{0x8bc2,0x95},
	{0x8bc3,0x30},
	{0x8bc4,0x00},
	{0x8bc5,0x03},
	{0x8bc6,0x02},
	{0x8bc7,0x0c},
	{0x8bc8,0x95},
	{0x8bc9,0x20},
	{0x8bca,0x07},
	{0x8bcb,0x06},
	{0x8bcc,0x20},
	{0x8bcd,0x06},
	{0x8bce,0x03},
	{0x8bcf,0xc3},
	{0x8bd0,0x80},
	{0x8bd1,0x01},
	{0x8bd2,0xd3},
	{0x8bd3,0x92},
	{0x8bd4,0x36},
	{0x8bd5,0xd2},
	{0x8bd6,0x07},
	{0x8bd7,0xc2},
	{0x8bd8,0x06},
	{0x8bd9,0x80},
	{0x8bda,0x1c},
	{0x8bdb,0x20},
	{0x8bdc,0x05},
	{0x8bdd,0x03},
	{0x8bde,0x02},
	{0x8bdf,0x0c},
	{0x8be0,0x95},
	{0x8be1,0x30},
	{0x8be2,0x00},
	{0x8be3,0x03},
	{0x8be4,0x02},
	{0x8be5,0x0c},
	{0x8be6,0x95},
	{0x8be7,0x20},
	{0x8be8,0x07},
	{0x8be9,0x06},
	{0x8bea,0x20},
	{0x8beb,0x06},
	{0x8bec,0x03},
	{0x8bed,0xc3},
	{0x8bee,0x80},
	{0x8bef,0x01},
	{0x8bf0,0xd3},
	{0x8bf1,0x92},
	{0x8bf2,0x36},
	{0x8bf3,0xd2},
	{0x8bf4,0x07},
	{0x8bf5,0xd2},
	{0x8bf6,0x06},
	{0x8bf7,0x12},
	{0x8bf8,0x02},
	{0x8bf9,0x8a},
	{0x8bfa,0x80},
	{0x8bfb,0x24},
	{0x8bfc,0x20},
	{0x8bfd,0x05},
	{0x8bfe,0x03},
	{0x8bff,0x02},
	{0x8c00,0x0c},
	{0x8c01,0x95},
	{0x8c02,0x30},
	{0x8c03,0x00},
	{0x8c04,0x03},
	{0x8c05,0x02},
	{0x8c06,0x0c},
	{0x8c07,0x95},
	{0x8c08,0xc2},
	{0x8c09,0x07},
	{0x8c0a,0xd2},
	{0x8c0b,0x06},
	{0x8c0c,0x12},
	{0x8c0d,0x02},
	{0x8c0e,0x9b},
	{0x8c0f,0xc2},
	{0x8c10,0x04},
	{0x8c11,0x02},
	{0x8c12,0x0c},
	{0x8c13,0x95},
	{0x8c14,0x12},
	{0x8c15,0x02},
	{0x8c16,0x51},
	{0x8c17,0x30},
	{0x8c18,0x05},
	{0x8c19,0x06},
	{0x8c1a,0xe4},
	{0x8c1b,0xf5},
	{0x8c1c,0x0c},
	{0x8c1d,0x12},
	{0x8c1e,0x13},
	{0x8c1f,0x64},
	{0x8c20,0xc2},
	{0x8c21,0x31},
	{0x8c22,0xd2},
	{0x8c23,0x34},
	{0x8c24,0x80},
	{0x8c25,0x6f},
	{0x8c26,0x30},
	{0x8c27,0x07},
	{0x8c28,0x6c},
	{0x8c29,0x30},
	{0x8c2a,0x06},
	{0x8c2b,0x69},
	{0x8c2c,0x12},
	{0x8c2d,0x02},
	{0x8c2e,0x8a},
	{0x8c2f,0xd2},
	{0x8c30,0x31},
	{0x8c31,0x80},
	{0x8c32,0x62},
	{0x8c33,0x20},
	{0x8c34,0x07},
	{0x8c35,0x03},
	{0x8c36,0x30},
	{0x8c37,0x06},
	{0x8c38,0x09},
	{0x8c39,0xe5},
	{0x8c3a,0x7e},
	{0x8c3b,0x64},
	{0x8c3c,0x0e},
	{0x8c3d,0x70},
	{0x8c3e,0x56},
	{0x8c3f,0x20},
	{0x8c40,0x00},
	{0x8c41,0x53},
	{0x8c42,0x12},
	{0x8c43,0x05},
	{0x8c44,0x2f},
	{0x8c45,0x80},
	{0x8c46,0x4e},
	{0x8c47,0x12},
	{0x8c48,0x06},
	{0x8c49,0xf8},
	{0x8c4a,0x80},
	{0x8c4b,0x49},
	{0x8c4c,0x30},
	{0x8c4d,0x05},
	{0x8c4e,0x46},
	{0x8c4f,0x20},
	{0x8c50,0x07},
	{0x8c51,0x43},
	{0x8c52,0x20},
	{0x8c53,0x06},
	{0x8c54,0x40},
	{0x8c55,0x12},
	{0x8c56,0x16},
	{0x8c57,0xc4},
	{0x8c58,0x80},
	{0x8c59,0x3b},
	{0x8c5a,0x12},
	{0x8c5b,0x10},
	{0x8c5c,0xfe},
	{0x8c5d,0x80},
	{0x8c5e,0x36},
	{0x8c5f,0x20},
	{0x8c60,0x07},
	{0x8c61,0x33},
	{0x8c62,0x20},
	{0x8c63,0x06},
	{0x8c64,0x30},
	{0x8c65,0x12},
	{0x8c66,0x16},
	{0x8c67,0xd3},
	{0x8c68,0x80},
	{0x8c69,0x2b},
	{0x8c6a,0xe5},
	{0x8c6b,0x7e},
	{0x8c6c,0x64},
	{0x8c6d,0x01},
	{0x8c6e,0x70},
	{0x8c6f,0x25},
	{0x8c70,0xd2},
	{0x8c71,0x35},
	{0x8c72,0x90},
	{0x8c73,0x50},
	{0x8c74,0x82},
	{0x8c75,0xe5},
	{0x8c76,0x74},
	{0x8c77,0xf0},
	{0x8c78,0xa3},
	{0x8c79,0xe5},
	{0x8c7a,0x75},
	{0x8c7b,0xf0},
	{0x8c7c,0xa3},
	{0x8c7d,0xe5},
	{0x8c7e,0x76},
	{0x8c7f,0xf0},
	{0x8c80,0xa3},
	{0x8c81,0xe5},
	{0x8c82,0x77},
	{0x8c83,0xf0},
	{0x8c84,0xc2},
	{0x8c85,0x35},
	{0x8c86,0x80},
	{0x8c87,0x0d},
	{0x8c88,0x90},
	{0x8c89,0x50},
	{0x8c8a,0x82},
	{0x8c8b,0x30},
	{0x8c8c,0x33},
	{0x8c8d,0x05},
	{0x8c8e,0x74},
	{0x8c8f,0x55},
	{0x8c90,0xf0},
	{0x8c91,0x80},
	{0x8c92,0x02},
	{0x8c93,0xe4},
	{0x8c94,0xf0},
	{0x8c95,0x20},
	{0x8c96,0x07},
	{0x8c97,0x06},
	{0x8c98,0x30},
	{0x8c99,0x06},
	{0x8c9a,0x03},
	{0x8c9b,0x30},
	{0x8c9c,0x04},
	{0x8c9d,0x05},
	{0x8c9e,0x90},
	{0x8c9f,0x30},
	{0x8ca0,0x25},
	{0x8ca1,0xe4},
	{0x8ca2,0xf0},
	{0x8ca3,0x22},
	{0x8ca4,0xc0},
	{0x8ca5,0xe0},
	{0x8ca6,0xc0},
	{0x8ca7,0xf0},
	{0x8ca8,0xc0},
	{0x8ca9,0x83},
	{0x8caa,0xc0},
	{0x8cab,0x82},
	{0x8cac,0xc0},
	{0x8cad,0xd0},
	{0x8cae,0x75},
	{0x8caf,0xd0},
	{0x8cb0,0x00},
	{0x8cb1,0xc0},
	{0x8cb2,0x00},
	{0x8cb3,0xc0},
	{0x8cb4,0x01},
	{0x8cb5,0xc0},
	{0x8cb6,0x02},
	{0x8cb7,0xc0},
	{0x8cb8,0x03},
	{0x8cb9,0xc0},
	{0x8cba,0x04},
	{0x8cbb,0xc0},
	{0x8cbc,0x05},
	{0x8cbd,0xc0},
	{0x8cbe,0x06},
	{0x8cbf,0xc0},
	{0x8cc0,0x07},
	{0x8cc1,0x90},
	{0x8cc2,0x3f},
	{0x8cc3,0x0c},
	{0x8cc4,0xe0},
	{0x8cc5,0xf5},
	{0x8cc6,0x08},
	{0x8cc7,0xe5},
	{0x8cc8,0x08},
	{0x8cc9,0x20},
	{0x8cca,0xe3},
	{0x8ccb,0x03},
	{0x8ccc,0x02},
	{0x8ccd,0x0d},
	{0x8cce,0x55},
	{0x8ccf,0x30},
	{0x8cd0,0x35},
	{0x8cd1,0x03},
	{0x8cd2,0x02},
	{0x8cd3,0x0d},
	{0x8cd4,0x55},
	{0x8cd5,0x90},
	{0x8cd6,0x60},
	{0x8cd7,0x16},
	{0x8cd8,0xe0},
	{0x8cd9,0xf5},
	{0x8cda,0x6a},
	{0x8cdb,0xa3},
	{0x8cdc,0xe0},
	{0x8cdd,0xf5},
	{0x8cde,0x6b},
	{0x8cdf,0x90},
	{0x8ce0,0x60},
	{0x8ce1,0x1e},
	{0x8ce2,0xe0},
	{0x8ce3,0xf5},
	{0x8ce4,0x6c},
	{0x8ce5,0xa3},
	{0x8ce6,0xe0},
	{0x8ce7,0xf5},
	{0x8ce8,0x6d},
	{0x8ce9,0x90},
	{0x8cea,0x60},
	{0x8ceb,0x26},
	{0x8cec,0xe0},
	{0x8ced,0xf5},
	{0x8cee,0x6e},
	{0x8cef,0xa3},
	{0x8cf0,0xe0},
	{0x8cf1,0xf5},
	{0x8cf2,0x6f},
	{0x8cf3,0x90},
	{0x8cf4,0x60},
	{0x8cf5,0x2e},
	{0x8cf6,0xe0},
	{0x8cf7,0xf5},
	{0x8cf8,0x70},
	{0x8cf9,0xa3},
	{0x8cfa,0xe0},
	{0x8cfb,0xf5},
	{0x8cfc,0x71},
	{0x8cfd,0x90},
	{0x8cfe,0x60},
	{0x8cff,0x36},
	{0x8d00,0x12},
	{0x8d01,0x00},
	{0x8d02,0x16},
	{0x8d03,0x12},
	{0x8d04,0x01},
	{0x8d05,0xc9},
	{0x8d06,0x40},
	{0x8d07,0x06},
	{0x8d08,0x75},
	{0x8d09,0x2a},
	{0x8d0a,0xff},
	{0x8d0b,0x75},
	{0x8d0c,0x2b},
	{0x8d0d,0xff},
	{0x8d0e,0x85},
	{0x8d0f,0x2a},
	{0x8d10,0x74},
	{0x8d11,0x85},
	{0x8d12,0x2b},
	{0x8d13,0x75},
	{0x8d14,0x90},
	{0x8d15,0x60},
	{0x8d16,0x1a},
	{0x8d17,0xe0},
	{0x8d18,0xf5},
	{0x8d19,0x6a},
	{0x8d1a,0xa3},
	{0x8d1b,0xe0},
	{0x8d1c,0xf5},
	{0x8d1d,0x6b},
	{0x8d1e,0x90},
	{0x8d1f,0x60},
	{0x8d20,0x22},
	{0x8d21,0xe0},
	{0x8d22,0xf5},
	{0x8d23,0x6c},
	{0x8d24,0xa3},
	{0x8d25,0xe0},
	{0x8d26,0xf5},
	{0x8d27,0x6d},
	{0x8d28,0x90},
	{0x8d29,0x60},
	{0x8d2a,0x2a},
	{0x8d2b,0xe0},
	{0x8d2c,0xf5},
	{0x8d2d,0x6e},
	{0x8d2e,0xa3},
	{0x8d2f,0xe0},
	{0x8d30,0xf5},
	{0x8d31,0x6f},
	{0x8d32,0x90},
	{0x8d33,0x60},
	{0x8d34,0x32},
	{0x8d35,0xe0},
	{0x8d36,0xf5},
	{0x8d37,0x70},
	{0x8d38,0xa3},
	{0x8d39,0xe0},
	{0x8d3a,0xf5},
	{0x8d3b,0x71},
	{0x8d3c,0x90},
	{0x8d3d,0x60},
	{0x8d3e,0x3a},
	{0x8d3f,0x12},
	{0x8d40,0x00},
	{0x8d41,0x16},
	{0x8d42,0x12},
	{0x8d43,0x01},
	{0x8d44,0xc9},
	{0x8d45,0x40},
	{0x8d46,0x06},
	{0x8d47,0x75},
	{0x8d48,0x2a},
	{0x8d49,0xff},
	{0x8d4a,0x75},
	{0x8d4b,0x2b},
	{0x8d4c,0xff},
	{0x8d4d,0x85},
	{0x8d4e,0x2a},
	{0x8d4f,0x76},
	{0x8d50,0x85},
	{0x8d51,0x2b},
	{0x8d52,0x77},
	{0x8d53,0xd2},
	{0x8d54,0x3d},
	{0x8d55,0xe5},
	{0x8d56,0x08},
	{0x8d57,0x30},
	{0x8d58,0xe5},
	{0x8d59,0x44},
	{0x8d5a,0x90},
	{0x8d5b,0x56},
	{0x8d5c,0x90},
	{0x8d5d,0xe0},
	{0x8d5e,0xf5},
	{0x8d5f,0x55},
	{0x8d60,0xe5},
	{0x8d61,0x7b},
	{0x8d62,0x24},
	{0x8d63,0x02},
	{0x8d64,0xff},
	{0x8d65,0xe4},
	{0x8d66,0x33},
	{0x8d67,0xfe},
	{0x8d68,0xad},
	{0x8d69,0x55},
	{0x8d6a,0xc3},
	{0x8d6b,0xef},
	{0x8d6c,0x9d},
	{0x8d6d,0x74},
	{0x8d6e,0x80},
	{0x8d6f,0xf8},
	{0x8d70,0x6e},
	{0x8d71,0x98},
	{0x8d72,0x50},
	{0x8d73,0x02},
	{0x8d74,0x80},
	{0x8d75,0x01},
	{0x8d76,0xc3},
	{0x8d77,0x92},
	{0x8d78,0x27},
	{0x8d79,0xaf},
	{0x8d7a,0x55},
	{0x8d7b,0xef},
	{0x8d7c,0x24},
	{0x8d7d,0x02},
	{0x8d7e,0xff},
	{0x8d7f,0xe4},
	{0x8d80,0x33},
	{0x8d81,0xfe},
	{0x8d82,0xc3},
	{0x8d83,0xef},
	{0x8d84,0x95},
	{0x8d85,0x7b},
	{0x8d86,0x74},
	{0x8d87,0x80},
	{0x8d88,0xf8},
	{0x8d89,0x6e},
	{0x8d8a,0x98},
	{0x8d8b,0x50},
	{0x8d8c,0x02},
	{0x8d8d,0x80},
	{0x8d8e,0x02},
	{0x8d8f,0xa2},
	{0x8d90,0x27},
	{0x8d91,0x92},
	{0x8d92,0x27},
	{0x8d93,0x30},
	{0x8d94,0x27},
	{0x8d95,0x04},
	{0x8d96,0xaf},
	{0x8d97,0x55},
	{0x8d98,0x80},
	{0x8d99,0x02},
	{0x8d9a,0xaf},
	{0x8d9b,0x7b},
	{0x8d9c,0x8f},
	{0x8d9d,0x7b},
	{0x8d9e,0xe5},
	{0x8d9f,0x08},
	{0x8da0,0x30},
	{0x8da1,0xe1},
	{0x8da2,0x08},
	{0x8da3,0x90},
	{0x8da4,0x30},
	{0x8da5,0x24},
	{0x8da6,0xe0},
	{0x8da7,0xf5},
	{0x8da8,0x33},
	{0x8da9,0xe4},
	{0x8daa,0xf0},
	{0x8dab,0x90},
	{0x8dac,0x3f},
	{0x8dad,0x0c},
	{0x8dae,0xe5},
	{0x8daf,0x08},
	{0x8db0,0xf0},
	{0x8db1,0xd0},
	{0x8db2,0x07},
	{0x8db3,0xd0},
	{0x8db4,0x06},
	{0x8db5,0xd0},
	{0x8db6,0x05},
	{0x8db7,0xd0},
	{0x8db8,0x04},
	{0x8db9,0xd0},
	{0x8dba,0x03},
	{0x8dbb,0xd0},
	{0x8dbc,0x02},
	{0x8dbd,0xd0},
	{0x8dbe,0x01},
	{0x8dbf,0xd0},
	{0x8dc0,0x00},
	{0x8dc1,0xd0},
	{0x8dc2,0xd0},
	{0x8dc3,0xd0},
	{0x8dc4,0x82},
	{0x8dc5,0xd0},
	{0x8dc6,0x83},
	{0x8dc7,0xd0},
	{0x8dc8,0xf0},
	{0x8dc9,0xd0},
	{0x8dca,0xe0},
	{0x8dcb,0x32},
	{0x8dcc,0x30},
	{0x8dcd,0x04},
	{0x8dce,0x03},
	{0x8dcf,0x02},
	{0x8dd0,0x0e},
	{0x8dd1,0xac},
	{0x8dd2,0xd2},
	{0x8dd3,0x04},
	{0x8dd4,0xe5},
	{0x8dd5,0x7e},
	{0x8dd6,0xb4},
	{0x8dd7,0x01},
	{0x8dd8,0x06},
	{0x8dd9,0x12},
	{0x8dda,0x16},
	{0x8ddb,0xa4},
	{0x8ddc,0x02},
	{0x8ddd,0x0e},
	{0x8dde,0xa5},
	{0x8ddf,0xe5},
	{0x8de0,0x7e},
	{0x8de1,0xb4},
	{0x8de2,0x02},
	{0x8de3,0x06},
	{0x8de4,0x12},
	{0x8de5,0x16},
	{0x8de6,0xb5},
	{0x8de7,0x02},
	{0x8de8,0x0e},
	{0x8de9,0xa5},
	{0x8dea,0xe5},
	{0x8deb,0x7e},
	{0x8dec,0xb4},
	{0x8ded,0x03},
	{0x8dee,0x05},
	{0x8def,0xe4},
	{0x8df0,0xf5},
	{0x8df1,0x0c},
	{0x8df2,0x80},
	{0x8df3,0x08},
	{0x8df4,0xe5},
	{0x8df5,0x7e},
	{0x8df6,0xb4},
	{0x8df7,0x04},
	{0x8df8,0x09},
	{0x8df9,0x85},
	{0x8dfa,0x7c},
	{0x8dfb,0x0c},
	{0x8dfc,0x12},
	{0x8dfd,0x13},
	{0x8dfe,0x64},
	{0x8dff,0x02},
	{0x8e00,0x0e},
	{0x8e01,0xa5},
	{0x8e02,0xe5},
	{0x8e03,0x7e},
	{0x8e04,0x64},
	{0x8e05,0x0f},
	{0x8e06,0x70},
	{0x8e07,0x15},
	{0x8e08,0x12},
	{0x8e09,0x02},
	{0x8e0a,0xb3},
	{0x8e0b,0x40},
	{0x8e0c,0x06},
	{0x8e0d,0x7e},
	{0x8e0e,0x03},
	{0x8e0f,0x7f},
	{0x8e10,0xff},
	{0x8e11,0x80},
	{0x8e12,0x04},
	{0x8e13,0xae},
	{0x8e14,0x68},
	{0x8e15,0xaf},
	{0x8e16,0x69},
	{0x8e17,0x12},
	{0x8e18,0x0e},
	{0x8e19,0xad},
	{0x8e1a,0x02},
	{0x8e1b,0x0e},
	{0x8e1c,0xa5},
	{0x8e1d,0xe5},
	{0x8e1e,0x7e},
	{0x8e1f,0x64},
	{0x8e20,0x10},
	{0x8e21,0x60},
	{0x8e22,0x03},
	{0x8e23,0x02},
	{0x8e24,0x0e},
	{0x8e25,0xa5},
	{0x8e26,0xf5},
	{0x8e27,0x66},
	{0x8e28,0xf5},
	{0x8e29,0x67},
	{0x8e2a,0xf5},
	{0x8e2b,0x68},
	{0x8e2c,0xab},
	{0x8e2d,0x69},
	{0x8e2e,0xaa},
	{0x8e2f,0x68},
	{0x8e30,0xa9},
	{0x8e31,0x67},
	{0x8e32,0xa8},
	{0x8e33,0x66},
	{0x8e34,0x12},
	{0x8e35,0x01},
	{0x8e36,0x73},
	{0x8e37,0xfe},
	{0x8e38,0xe4},
	{0x8e39,0xfc},
	{0x8e3a,0xfd},
	{0x8e3b,0x12},
	{0x8e3c,0x01},
	{0x8e3d,0xf1},
	{0x8e3e,0xe4},
	{0x8e3f,0x7b},
	{0x8e40,0xff},
	{0x8e41,0xfa},
	{0x8e42,0xf9},
	{0x8e43,0xf8},
	{0x8e44,0x12},
	{0x8e45,0x02},
	{0x8e46,0x67},
	{0x8e47,0x12},
	{0x8e48,0x02},
	{0x8e49,0x39},
	{0x8e4a,0xe4},
	{0x8e4b,0x93},
	{0x8e4c,0xfe},
	{0x8e4d,0x74},
	{0x8e4e,0x01},
	{0x8e4f,0x93},
	{0x8e50,0xff},
	{0x8e51,0xe4},
	{0x8e52,0xfc},
	{0x8e53,0xfd},
	{0x8e54,0xe5},
	{0x8e55,0x69},
	{0x8e56,0x2f},
	{0x8e57,0xf5},
	{0x8e58,0x69},
	{0x8e59,0xe5},
	{0x8e5a,0x68},
	{0x8e5b,0x3e},
	{0x8e5c,0xf5},
	{0x8e5d,0x68},
	{0x8e5e,0xed},
	{0x8e5f,0x35},
	{0x8e60,0x67},
	{0x8e61,0xf5},
	{0x8e62,0x67},
	{0x8e63,0xec},
	{0x8e64,0x35},
	{0x8e65,0x66},
	{0x8e66,0xf5},
	{0x8e67,0x66},
	{0x8e68,0x12},
	{0x8e69,0x02},
	{0x8e6a,0xb3},
	{0x8e6b,0x40},
	{0x8e6c,0x06},
	{0x8e6d,0x7e},
	{0x8e6e,0x03},
	{0x8e6f,0x7f},
	{0x8e70,0xff},
	{0x8e71,0x80},
	{0x8e72,0x04},
	{0x8e73,0xae},
	{0x8e74,0x68},
	{0x8e75,0xaf},
	{0x8e76,0x69},
	{0x8e77,0x12},
	{0x8e78,0x0e},
	{0x8e79,0xad},
	{0x8e7a,0xe4},
	{0x8e7b,0xf5},
	{0x8e7c,0x67},
	{0x8e7d,0xf5},
	{0x8e7e,0x67},
	{0x8e7f,0xe5},
	{0x8e80,0x67},
	{0x8e81,0xd3},
	{0x8e82,0x95},
	{0x8e83,0x7c},
	{0x8e84,0x50},
	{0x8e85,0x1c},
	{0x8e86,0x12},
	{0x8e87,0x02},
	{0x8e88,0x39},
	{0x8e89,0xaf},
	{0x8e8a,0x67},
	{0x8e8b,0x75},
	{0x8e8c,0xf0},
	{0x8e8d,0x02},
	{0x8e8e,0xef},
	{0x8e8f,0x12},
	{0x8e90,0x09},
	{0x8e91,0xeb},
	{0x8e92,0xc3},
	{0x8e93,0x74},
	{0x8e94,0x01},
	{0x8e95,0x93},
	{0x8e96,0x95},
	{0x8e97,0x69},
	{0x8e98,0xe4},
	{0x8e99,0x93},
	{0x8e9a,0x95},
	{0x8e9b,0x68},
	{0x8e9c,0x50},
	{0x8e9d,0x04},
	{0x8e9e,0x05},
	{0x8e9f,0x67},
	{0x8ea0,0x80},
	{0x8ea1,0xdd},
	{0x8ea2,0x85},
	{0x8ea3,0x67},
	{0x8ea4,0x7d},
	{0x8ea5,0x90},
	{0x8ea6,0x30},
	{0x8ea7,0x25},
	{0x8ea8,0xe4},
	{0x8ea9,0xf0},
	{0x8eaa,0xd2},
	{0x8eab,0x34},
	{0x8eac,0x22},
	{0x8ead,0x8e},
	{0x8eae,0x68},
	{0x8eaf,0x8f},
	{0x8eb0,0x69},
	{0x8eb1,0x85},
	{0x8eb2,0x68},
	{0x8eb3,0x64},
	{0x8eb4,0x85},
	{0x8eb5,0x69},
	{0x8eb6,0x65},
	{0x8eb7,0xe5},
	{0x8eb8,0x69},
	{0x8eb9,0xc4},
	{0x8eba,0xf8},
	{0x8ebb,0x54},
	{0x8ebc,0x0f},
	{0x8ebd,0xc8},
	{0x8ebe,0x68},
	{0x8ebf,0xf5},
	{0x8ec0,0x69},
	{0x8ec1,0xe5},
	{0x8ec2,0x68},
	{0x8ec3,0xc4},
	{0x8ec4,0x54},
	{0x8ec5,0xf0},
	{0x8ec6,0x48},
	{0x8ec7,0xf5},
	{0x8ec8,0x68},
	{0x8ec9,0x85},
	{0x8eca,0x68},
	{0x8ecb,0x0d},
	{0x8ecc,0x85},
	{0x8ecd,0x69},
	{0x8ece,0x0e},
	{0x8ecf,0x12},
	{0x8ed0,0x0a},
	{0x8ed1,0x1d},
	{0x8ed2,0x22},
	{0x8ed3,0x12},
	{0x8ed4,0x02},
	{0x8ed5,0x7f},
	{0x8ed6,0xb5},
	{0x8ed7,0x07},
	{0x8ed8,0x03},
	{0x8ed9,0xd3},
	{0x8eda,0x80},
	{0x8edb,0x01},
	{0x8edc,0xc3},
	{0x8edd,0x40},
	{0x8ede,0x03},
	{0x8edf,0x02},
	{0x8ee0,0x0f},
	{0x8ee1,0x72},
	{0x8ee2,0x90},
	{0x8ee3,0x30},
	{0x8ee4,0x04},
	{0x8ee5,0xe0},
	{0x8ee6,0x44},
	{0x8ee7,0x20},
	{0x8ee8,0xf0},
	{0x8ee9,0xa3},
	{0x8eea,0xe0},
	{0x8eeb,0x44},
	{0x8eec,0x40},
	{0x8eed,0xf0},
	{0x8eee,0x90},
	{0x8eef,0x50},
	{0x8ef0,0x25},
	{0x8ef1,0xe0},
	{0x8ef2,0x44},
	{0x8ef3,0x04},
	{0x8ef4,0xf0},
	{0x8ef5,0x90},
	{0x8ef6,0x50},
	{0x8ef7,0x03},
	{0x8ef8,0xe0},
	{0x8ef9,0x54},
	{0x8efa,0xfd},
	{0x8efb,0xf0},
	{0x8efc,0x90},
	{0x8efd,0x50},
	{0x8efe,0x27},
	{0x8eff,0xe0},
	{0x8f00,0x44},
	{0x8f01,0x01},
	{0x8f02,0xf0},
	{0x8f03,0x90},
	{0x8f04,0x50},
	{0x8f05,0x31},
	{0x8f06,0xe4},
	{0x8f07,0xf0},
	{0x8f08,0x90},
	{0x8f09,0x50},
	{0x8f0a,0x33},
	{0x8f0b,0xf0},
	{0x8f0c,0x90},
	{0x8f0d,0x30},
	{0x8f0e,0x1e},
	{0x8f0f,0x12},
	{0x8f10,0x02},
	{0x8f11,0x05},
	{0x8f12,0x90},
	{0x8f13,0x30},
	{0x8f14,0x18},
	{0x8f15,0x12},
	{0x8f16,0x02},
	{0x8f17,0x05},
	{0x8f18,0x90},
	{0x8f19,0x30},
	{0x8f1a,0x1b},
	{0x8f1b,0x12},
	{0x8f1c,0x02},
	{0x8f1d,0x05},
	{0x8f1e,0xe0},
	{0x8f1f,0xf5},
	{0x8f20,0x25},
	{0x8f21,0x90},
	{0x8f22,0x30},
	{0x8f23,0x18},
	{0x8f24,0xe0},
	{0x8f25,0xf5},
	{0x8f26,0x21},
	{0x8f27,0x90},
	{0x8f28,0x60},
	{0x8f29,0x00},
	{0x8f2a,0x74},
	{0x8f2b,0xf5},
	{0x8f2c,0xf0},
	{0x8f2d,0x90},
	{0x8f2e,0x3f},
	{0x8f2f,0x01},
	{0x8f30,0xe4},
	{0x8f31,0xf0},
	{0x8f32,0xa3},
	{0x8f33,0xf0},
	{0x8f34,0x90},
	{0x8f35,0x3f},
	{0x8f36,0x01},
	{0x8f37,0xe0},
	{0x8f38,0x44},
	{0x8f39,0x08},
	{0x8f3a,0xf0},
	{0x8f3b,0xe0},
	{0x8f3c,0x44},
	{0x8f3d,0x20},
	{0x8f3e,0xf0},
	{0x8f3f,0x90},
	{0x8f40,0x3f},
	{0x8f41,0x05},
	{0x8f42,0x74},
	{0x8f43,0x30},
	{0x8f44,0xf0},
	{0x8f45,0xa3},
	{0x8f46,0x74},
	{0x8f47,0x24},
	{0x8f48,0xf0},
	{0x8f49,0x90},
	{0x8f4a,0x3f},
	{0x8f4b,0x0b},
	{0x8f4c,0xe0},
	{0x8f4d,0x44},
	{0x8f4e,0x0f},
	{0x8f4f,0xf0},
	{0x8f50,0x90},
	{0x8f51,0x3f},
	{0x8f52,0x01},
	{0x8f53,0xe0},
	{0x8f54,0x44},
	{0x8f55,0x02},
	{0x8f56,0xf0},
	{0x8f57,0xc2},
	{0x8f58,0x8c},
	{0x8f59,0x75},
	{0x8f5a,0x89},
	{0x8f5b,0x03},
	{0x8f5c,0x75},
	{0x8f5d,0xa8},
	{0x8f5e,0x07},
	{0x8f5f,0x75},
	{0x8f60,0xb8},
	{0x8f61,0x04},
	{0x8f62,0xe4},
	{0x8f63,0xf5},
	{0x8f64,0xd8},
	{0x8f65,0xf5},
	{0x8f66,0xe8},
	{0x8f67,0x90},
	{0x8f68,0x30},
	{0x8f69,0x01},
	{0x8f6a,0xe0},
	{0x8f6b,0x44},
	{0x8f6c,0x40},
	{0x8f6d,0xf0},
	{0x8f6e,0xe0},
	{0x8f6f,0x54},
	{0x8f70,0xbf},
	{0x8f71,0xf0},
	{0x8f72,0x22},
	{0x8f73,0x30},
	{0x8f74,0x3e},
	{0x8f75,0x09},
	{0x8f76,0x30},
	{0x8f77,0x20},
	{0x8f78,0x06},
	{0x8f79,0xae},
	{0x8f7a,0x56},
	{0x8f7b,0xaf},
	{0x8f7c,0x57},
	{0x8f7d,0x80},
	{0x8f7e,0x04},
	{0x8f7f,0xae},
	{0x8f80,0x6a},
	{0x8f81,0xaf},
	{0x8f82,0x6b},
	{0x8f83,0x8e},
	{0x8f84,0x56},
	{0x8f85,0x8f},
	{0x8f86,0x57},
	{0x8f87,0x30},
	{0x8f88,0x3e},
	{0x8f89,0x09},
	{0x8f8a,0x30},
	{0x8f8b,0x21},
	{0x8f8c,0x06},
	{0x8f8d,0xae},
	{0x8f8e,0x58},
	{0x8f8f,0xaf},
	{0x8f90,0x59},
	{0x8f91,0x80},
	{0x8f92,0x04},
	{0x8f93,0xae},
	{0x8f94,0x6c},
	{0x8f95,0xaf},
	{0x8f96,0x6d},
	{0x8f97,0x8e},
	{0x8f98,0x58},
	{0x8f99,0x8f},
	{0x8f9a,0x59},
	{0x8f9b,0x30},
	{0x8f9c,0x3e},
	{0x8f9d,0x09},
	{0x8f9e,0x30},
	{0x8f9f,0x22},
	{0x8fa0,0x06},
	{0x8fa1,0xae},
	{0x8fa2,0x5a},
	{0x8fa3,0xaf},
	{0x8fa4,0x5b},
	{0x8fa5,0x80},
	{0x8fa6,0x04},
	{0x8fa7,0xae},
	{0x8fa8,0x6e},
	{0x8fa9,0xaf},
	{0x8faa,0x6f},
	{0x8fab,0x8e},
	{0x8fac,0x5a},
	{0x8fad,0x8f},
	{0x8fae,0x5b},
	{0x8faf,0x30},
	{0x8fb0,0x3e},
	{0x8fb1,0x09},
	{0x8fb2,0x30},
	{0x8fb3,0x23},
	{0x8fb4,0x06},
	{0x8fb5,0xae},
	{0x8fb6,0x5c},
	{0x8fb7,0xaf},
	{0x8fb8,0x5d},
	{0x8fb9,0x80},
	{0x8fba,0x04},
	{0x8fbb,0xae},
	{0x8fbc,0x70},
	{0x8fbd,0xaf},
	{0x8fbe,0x71},
	{0x8fbf,0x8e},
	{0x8fc0,0x5c},
	{0x8fc1,0x8f},
	{0x8fc2,0x5d},
	{0x8fc3,0x30},
	{0x8fc4,0x3e},
	{0x8fc5,0x09},
	{0x8fc6,0x30},
	{0x8fc7,0x24},
	{0x8fc8,0x06},
	{0x8fc9,0xae},
	{0x8fca,0x5e},
	{0x8fcb,0xaf},
	{0x8fcc,0x5f},
	{0x8fcd,0x80},
	{0x8fce,0x04},
	{0x8fcf,0xae},
	{0x8fd0,0x72},
	{0x8fd1,0xaf},
	{0x8fd2,0x73},
	{0x8fd3,0x8e},
	{0x8fd4,0x5e},
	{0x8fd5,0x8f},
	{0x8fd6,0x5f},
	{0x8fd7,0x30},
	{0x8fd8,0x3e},
	{0x8fd9,0x09},
	{0x8fda,0x30},
	{0x8fdb,0x25},
	{0x8fdc,0x06},
	{0x8fdd,0xae},
	{0x8fde,0x60},
	{0x8fdf,0xaf},
	{0x8fe0,0x61},
	{0x8fe1,0x80},
	{0x8fe2,0x04},
	{0x8fe3,0xae},
	{0x8fe4,0x74},
	{0x8fe5,0xaf},
	{0x8fe6,0x75},
	{0x8fe7,0x8e},
	{0x8fe8,0x60},
	{0x8fe9,0x8f},
	{0x8fea,0x61},
	{0x8feb,0x30},
	{0x8fec,0x3e},
	{0x8fed,0x09},
	{0x8fee,0x30},
	{0x8fef,0x26},
	{0x8ff0,0x06},
	{0x8ff1,0xae},
	{0x8ff2,0x62},
	{0x8ff3,0xaf},
	{0x8ff4,0x63},
	{0x8ff5,0x80},
	{0x8ff6,0x04},
	{0x8ff7,0xae},
	{0x8ff8,0x76},
	{0x8ff9,0xaf},
	{0x8ffa,0x77},
	{0x8ffb,0x8e},
	{0x8ffc,0x62},
	{0x8ffd,0x8f},
	{0x8ffe,0x63},
	{0x8fff,0x22},
	{0x9000,0x30},
	{0x9001,0x36},
	{0x9002,0x4e},
	{0x9003,0x12},
	{0x9004,0x10},
	{0x9005,0x78},
	{0x9006,0xe5},
	{0x9007,0x32},
	{0x9008,0xd3},
	{0x9009,0x95},
	{0x900a,0x7d},
	{0x900b,0x40},
	{0x900c,0x0c},
	{0x900d,0xe5},
	{0x900e,0x32},
	{0x900f,0x04},
	{0x9010,0xf5},
	{0x9011,0x0c},
	{0x9012,0x12},
	{0x9013,0x13},
	{0x9014,0x64},
	{0x9015,0xd2},
	{0x9016,0x37},
	{0x9017,0x80},
	{0x9018,0x44},
	{0x9019,0xe5},
	{0x901a,0x7c},
	{0x901b,0xb5},
	{0x901c,0x7d},
	{0x901d,0x04},
	{0x901e,0x7f},
	{0x901f,0x01},
	{0x9020,0x80},
	{0x9021,0x02},
	{0x9022,0x7f},
	{0x9023,0x00},
	{0x9024,0xef},
	{0x9025,0x24},
	{0x9026,0xfb},
	{0x9027,0xd3},
	{0x9028,0x64},
	{0x9029,0x80},
	{0x902a,0xf8},
	{0x902b,0xe5},
	{0x902c,0x7d},
	{0x902d,0x64},
	{0x902e,0x80},
	{0x902f,0x98},
	{0x9030,0x40},
	{0x9031,0x12},
	{0x9032,0xc2},
	{0x9033,0x37},
	{0x9034,0xe5},
	{0x9035,0x7c},
	{0x9036,0xb5},
	{0x9037,0x7d},
	{0x9038,0x04},
	{0x9039,0x7f},
	{0x903a,0x01},
	{0x903b,0x80},
	{0x903c,0x02},
	{0x903d,0x7f},
	{0x903e,0x00},
	{0x903f,0xef},
	{0x9040,0x24},
	{0x9041,0xfa},
	{0x9042,0x80},
	{0x9043,0x06},
	{0x9044,0xd2},
	{0x9045,0x37},
	{0x9046,0xe5},
	{0x9047,0x7d},
	{0x9048,0x24},
	{0x9049,0x02},
	{0x904a,0xf5},
	{0x904b,0x0c},
	{0x904c,0x12},
	{0x904d,0x13},
	{0x904e,0x64},
	{0x904f,0x80},
	{0x9050,0x0c},
	{0x9051,0xe5},
	{0x9052,0x7d},
	{0x9053,0x70},
	{0x9054,0x0f},
	{0x9055,0x12},
	{0x9056,0x10},
	{0x9057,0x78},
	{0x9058,0xc2},
	{0x9059,0x03},
	{0x905a,0x12},
	{0x905b,0x16},
	{0x905c,0xa4},
	{0x905d,0xd2},
	{0x905e,0x02},
	{0x905f,0xd2},
	{0x9060,0x01},
	{0x9061,0xd2},
	{0x9062,0x00},
	{0x9063,0x22},
	{0x9064,0x30},
	{0x9065,0x03},
	{0x9066,0x08},
	{0x9067,0xc2},
	{0x9068,0x03},
	{0x9069,0xc2},
	{0x906a,0x04},
	{0x906b,0x12},
	{0x906c,0x02},
	{0x906d,0x9b},
	{0x906e,0x22},
	{0x906f,0xe4},
	{0x9070,0xf5},
	{0x9071,0x0c},
	{0x9072,0x12},
	{0x9073,0x13},
	{0x9074,0x64},
	{0x9075,0xd2},
	{0x9076,0x03},
	{0x9077,0x22},
	{0x9078,0x12},
	{0x9079,0x16},
	{0x907a,0x90},
	{0x907b,0xc2},
	{0x907c,0x3e},
	{0x907d,0x12},
	{0x907e,0x0f},
	{0x907f,0x73},
	{0x9080,0xc2},
	{0x9081,0x3e},
	{0x9082,0x12},
	{0x9083,0x13},
	{0x9084,0x01},
	{0x9085,0x22},
	{0x9086,0xd3},
	{0x9087,0xe5},
	{0x9088,0x57},
	{0x9089,0x95},
	{0x908a,0x6b},
	{0x908b,0xe5},
	{0x908c,0x56},
	{0x908d,0x95},
	{0x908e,0x6a},
	{0x908f,0x40},
	{0x9090,0x03},
	{0x9091,0xd3},
	{0x9092,0x80},
	{0x9093,0x01},
	{0x9094,0xc3},
	{0x9095,0x92},
	{0x9096,0x20},
	{0x9097,0xd3},
	{0x9098,0xe5},
	{0x9099,0x59},
	{0x909a,0x95},
	{0x909b,0x6d},
	{0x909c,0xe5},
	{0x909d,0x58},
	{0x909e,0x95},
	{0x909f,0x6c},
	{0x90a0,0x40},
	{0x90a1,0x03},
	{0x90a2,0xd3},
	{0x90a3,0x80},
	{0x90a4,0x01},
	{0x90a5,0xc3},
	{0x90a6,0x92},
	{0x90a7,0x21},
	{0x90a8,0xd3},
	{0x90a9,0xe5},
	{0x90aa,0x5b},
	{0x90ab,0x95},
	{0x90ac,0x6f},
	{0x90ad,0xe5},
	{0x90ae,0x5a},
	{0x90af,0x95},
	{0x90b0,0x6e},
	{0x90b1,0x40},
	{0x90b2,0x03},
	{0x90b3,0xd3},
	{0x90b4,0x80},
	{0x90b5,0x01},
	{0x90b6,0xc3},
	{0x90b7,0x92},
	{0x90b8,0x22},
	{0x90b9,0xd3},
	{0x90ba,0xe5},
	{0x90bb,0x5d},
	{0x90bc,0x95},
	{0x90bd,0x71},
	{0x90be,0xe5},
	{0x90bf,0x5c},
	{0x90c0,0x95},
	{0x90c1,0x70},
	{0x90c2,0x40},
	{0x90c3,0x03},
	{0x90c4,0xd3},
	{0x90c5,0x80},
	{0x90c6,0x01},
	{0x90c7,0xc3},
	{0x90c8,0x92},
	{0x90c9,0x23},
	{0x90ca,0xd3},
	{0x90cb,0xe5},
	{0x90cc,0x5f},
	{0x90cd,0x95},
	{0x90ce,0x73},
	{0x90cf,0xe5},
	{0x90d0,0x5e},
	{0x90d1,0x95},
	{0x90d2,0x72},
	{0x90d3,0x40},
	{0x90d4,0x03},
	{0x90d5,0xd3},
	{0x90d6,0x80},
	{0x90d7,0x01},
	{0x90d8,0xc3},
	{0x90d9,0x92},
	{0x90da,0x24},
	{0x90db,0xd3},
	{0x90dc,0xe5},
	{0x90dd,0x61},
	{0x90de,0x95},
	{0x90df,0x75},
	{0x90e0,0xe5},
	{0x90e1,0x60},
	{0x90e2,0x95},
	{0x90e3,0x74},
	{0x90e4,0x40},
	{0x90e5,0x03},
	{0x90e6,0xd3},
	{0x90e7,0x80},
	{0x90e8,0x01},
	{0x90e9,0xc3},
	{0x90ea,0x92},
	{0x90eb,0x25},
	{0x90ec,0xd3},
	{0x90ed,0xe5},
	{0x90ee,0x63},
	{0x90ef,0x95},
	{0x90f0,0x77},
	{0x90f1,0xe5},
	{0x90f2,0x62},
	{0x90f3,0x95},
	{0x90f4,0x76},
	{0x90f5,0x40},
	{0x90f6,0x03},
	{0x90f7,0xd3},
	{0x90f8,0x80},
	{0x90f9,0x01},
	{0x90fa,0xc3},
	{0x90fb,0x92},
	{0x90fc,0x26},
	{0x90fd,0x22},
	{0x90fe,0xe5},
	{0x90ff,0x7e},
	{0x9100,0x64},
	{0x9101,0x01},
	{0x9102,0x70},
	{0x9103,0x50},
	{0x9104,0x12},
	{0x9105,0x02},
	{0x9106,0x39},
	{0x9107,0xe5},
	{0x9108,0x7d},
	{0x9109,0x12},
	{0x910a,0x01},
	{0x910b,0x7b},
	{0x910c,0xfe},
	{0x910d,0xe4},
	{0x910e,0x8f},
	{0x910f,0x69},
	{0x9110,0x8e},
	{0x9111,0x68},
	{0x9112,0xf5},
	{0x9113,0x67},
	{0x9114,0xf5},
	{0x9115,0x66},
	{0x9116,0x12},
	{0x9117,0x01},
	{0x9118,0xfc},
	{0x9119,0x7b},
	{0x911a,0xff},
	{0x911b,0xfa},
	{0x911c,0xf9},
	{0x911d,0xf8},
	{0x911e,0x12},
	{0x911f,0x01},
	{0x9120,0xf1},
	{0x9121,0xc0},
	{0x9122,0x04},
	{0x9123,0xc0},
	{0x9124,0x05},
	{0x9125,0xc0},
	{0x9126,0x06},
	{0x9127,0xc0},
	{0x9128,0x07},
	{0x9129,0x12},
	{0x912a,0x01},
	{0x912b,0x73},
	{0x912c,0xab},
	{0x912d,0x07},
	{0x912e,0xfa},
	{0x912f,0xe4},
	{0x9130,0xf9},
	{0x9131,0xf8},
	{0x9132,0xd0},
	{0x9133,0x07},
	{0x9134,0xd0},
	{0x9135,0x06},
	{0x9136,0xd0},
	{0x9137,0x05},
	{0x9138,0xd0},
	{0x9139,0x04},
	{0x913a,0x12},
	{0x913b,0x02},
	{0x913c,0x67},
	{0x913d,0x85},
	{0x913e,0x69},
	{0x913f,0x66},
	{0x9140,0x85},
	{0x9141,0x7d},
	{0x9142,0x67},
	{0x9143,0x12},
	{0x9144,0x02},
	{0x9145,0x39},
	{0x9146,0xe5},
	{0x9147,0x7d},
	{0x9148,0x12},
	{0x9149,0x02},
	{0x914a,0x95},
	{0x914b,0xe4},
	{0x914c,0x93},
	{0x914d,0xf5},
	{0x914e,0x68},
	{0x914f,0x74},
	{0x9150,0x01},
	{0x9151,0x93},
	{0x9152,0xf5},
	{0x9153,0x69},
	{0x9154,0x90},
	{0x9155,0x50},
	{0x9156,0x82},
	{0x9157,0xe5},
	{0x9158,0x66},
	{0x9159,0xf0},
	{0x915a,0xa3},
	{0x915b,0xe5},
	{0x915c,0x67},
	{0x915d,0xf0},
	{0x915e,0xa3},
	{0x915f,0xe5},
	{0x9160,0x68},
	{0x9161,0xf0},
	{0x9162,0xa3},
	{0x9163,0xe5},
	{0x9164,0x69},
	{0x9165,0xf0},
	{0x9166,0x22},
	{0x9167,0x56},
	{0x9168,0x0c},
	{0x9169,0x04},
	{0x916a,0x00},
	{0x916b,0x00},
	{0x916c,0x00},
	{0x916d,0xc8},
	{0x916e,0x01},
	{0x916f,0x2c},
	{0x9170,0x01},
	{0x9171,0x5e},
	{0x9172,0x01},
	{0x9173,0x8b},
	{0x9174,0x01},
	{0x9175,0xb8},
	{0x9176,0x01},
	{0x9177,0xe5},
	{0x9178,0x02},
	{0x9179,0x12},
	{0x917a,0x02},
	{0x917b,0x3f},
	{0x917c,0x02},
	{0x917d,0x6c},
	{0x917e,0x02},
	{0x917f,0x99},
	{0x9180,0x02},
	{0x9181,0xc6},
	{0x9182,0x02},
	{0x9183,0xf3},
	{0x9184,0x07},
	{0x9185,0x20},
	{0x9186,0x12},
	{0x9187,0x28},
	{0x9188,0x1e},
	{0x9189,0x18},
	{0x918a,0x18},
	{0x918b,0x28},
	{0x918c,0x1e},
	{0x918d,0x18},
	{0x918e,0x12},
	{0x918f,0x28},
	{0x9190,0x1e},
	{0x9191,0x18},
	{0x9192,0x12},
	{0x9193,0x28},
	{0x9194,0x18},
	{0x9195,0x18},
	{0x9196,0x12},
	{0x9197,0x20},
	{0x9198,0x18},
	{0x9199,0x28},
	{0x919a,0x1c},
	{0x919b,0x30},
	{0x919c,0x24},
	{0x919d,0x10},
	{0x919e,0x1c},
	{0x919f,0x18},
	{0x91a0,0x24},
	{0x91a1,0x1c},
	{0x91a2,0x14},
	{0x91a3,0x24},
	{0x91a4,0x1c},
	{0x91a5,0x28},
	{0x91a6,0x0c},
	{0x91a7,0x30},
	{0x91a8,0x14},
	{0x91a9,0x10},
	{0x91aa,0x0c},
	{0x91ab,0x18},
	{0x91ac,0x14},
	{0x91ad,0x1c},
	{0x91ae,0x20},
	{0x91af,0x24},
	{0x91b0,0x28},
	{0x91b1,0x0c},
	{0x91b2,0x14},
	{0x91b3,0x14},
	{0x91b4,0x1c},
	{0x91b5,0x1c},
	{0x91b6,0x14},
	{0x91b7,0x24},
	{0x91b8,0x1c},
	{0x91b9,0x2c},
	{0x91ba,0x14},
	{0x91bb,0x34},
	{0x91bc,0x1c},
	{0x91bd,0x1c},
	{0x91be,0x08},
	{0x91bf,0x24},
	{0x91c0,0x10},
	{0x91c1,0x19},
	{0x91c2,0x19},
	{0x91c3,0x1c},
	{0x91c4,0x19},
	{0x91c5,0x19},
	{0x91c6,0x10},
	{0x91c7,0x10},
	{0x91c8,0x10},
	{0x91c9,0x10},
	{0x91ca,0x10},
	{0x91cb,0x00},
	{0x91cc,0x00},
	{0x91cd,0x00},
	{0x91ce,0x00},
	{0x91cf,0x00},
	{0x91d0,0x12},
	{0x91d1,0x10},
	{0x91d2,0x86},
	{0x91d3,0x30},
	{0x91d4,0x36},
	{0x91d5,0x40},
	{0x91d6,0xe5},
	{0x91d7,0x24},
	{0x91d8,0x54},
	{0x91d9,0x1f},
	{0x91da,0xff},
	{0x91db,0x60},
	{0x91dc,0x0e},
	{0x91dd,0x64},
	{0x91de,0x1f},
	{0x91df,0x60},
	{0x91e0,0x0a},
	{0x91e1,0xe5},
	{0x91e2,0x7c},
	{0x91e3,0x65},
	{0x91e4,0x7d},
	{0x91e5,0x60},
	{0x91e6,0x04},
	{0x91e7,0xe5},
	{0x91e8,0x7d},
	{0x91e9,0x70},
	{0x91ea,0x18},
	{0x91eb,0xbf},
	{0x91ec,0x1f},
	{0x91ed,0x02},
	{0x91ee,0xb2},
	{0x91ef,0x37},
	{0x91f0,0xe5},
	{0x91f1,0x7c},
	{0x91f2,0xb5},
	{0x91f3,0x7d},
	{0x91f4,0x02},
	{0x91f5,0xc2},
	{0x91f6,0x37},
	{0x91f7,0xe5},
	{0x91f8,0x7d},
	{0x91f9,0x70},
	{0x91fa,0x02},
	{0x91fb,0xd2},
	{0x91fc,0x37},
	{0x91fd,0xc2},
	{0x91fe,0x02},
	{0x91ff,0xd2},
	{0x9200,0x01},
	{0x9201,0xd2},
	{0x9202,0x00},
	{0x9203,0xc2},
	{0x9204,0x3e},
	{0x9205,0x12},
	{0x9206,0x0f},
	{0x9207,0x73},
	{0x9208,0xc2},
	{0x9209,0x3e},
	{0x920a,0x12},
	{0x920b,0x13},
	{0x920c,0x01},
	{0x920d,0x30},
	{0x920e,0x37},
	{0x920f,0x03},
	{0x9210,0x02},
	{0x9211,0x16},
	{0x9212,0xa4},
	{0x9213,0x02},
	{0x9214,0x16},
	{0x9215,0xb5},
	{0x9216,0xd2},
	{0x9217,0x3e},
	{0x9218,0x12},
	{0x9219,0x0f},
	{0x921a,0x73},
	{0x921b,0xd2},
	{0x921c,0x3e},
	{0x921d,0x12},
	{0x921e,0x13},
	{0x921f,0x01},
	{0x9220,0x12},
	{0x9221,0x16},
	{0x9222,0xa4},
	{0x9223,0xe5},
	{0x9224,0x32},
	{0x9225,0xd3},
	{0x9226,0x95},
	{0x9227,0x7d},
	{0x9228,0x40},
	{0x9229,0x05},
	{0x922a,0xe4},
	{0x922b,0x95},
	{0x922c,0x7d},
	{0x922d,0x40},
	{0x922e,0x06},
	{0x922f,0xc2},
	{0x9230,0x02},
	{0x9231,0xd2},
	{0x9232,0x01},
	{0x9233,0xd2},
	{0x9234,0x00},
	{0x9235,0x22},
	{0x9236,0x12},
	{0x9237,0x10},
	{0x9238,0x86},
	{0x9239,0xc3},
	{0x923a,0x30},
	{0x923b,0x25},
	{0x923c,0x0c},
	{0x923d,0xe5},
	{0x923e,0x61},
	{0x923f,0x95},
	{0x9240,0x75},
	{0x9241,0xff},
	{0x9242,0xe5},
	{0x9243,0x60},
	{0x9244,0x95},
	{0x9245,0x74},
	{0x9246,0xfe},
	{0x9247,0x80},
	{0x9248,0x0a},
	{0x9249,0xe5},
	{0x924a,0x75},
	{0x924b,0x95},
	{0x924c,0x61},
	{0x924d,0xff},
	{0x924e,0xe5},
	{0x924f,0x74},
	{0x9250,0x95},
	{0x9251,0x60},
	{0x9252,0xfe},
	{0x9253,0x8e},
	{0x9254,0x0a},
	{0x9255,0x8f},
	{0x9256,0x0b},
	{0x9257,0x30},
	{0x9258,0x03},
	{0x9259,0x26},
	{0x925a,0x12},
	{0x925b,0x02},
	{0x925c,0xa9},
	{0x925d,0x50},
	{0x925e,0x03},
	{0x925f,0x30},
	{0x9260,0x27},
	{0x9261,0x07},
	{0x9262,0xc2},
	{0x9263,0x3e},
	{0x9264,0x12},
	{0x9265,0x0f},
	{0x9266,0x73},
	{0x9267,0x80},
	{0x9268,0x2f},
	{0x9269,0x05},
	{0x926a,0x31},
	{0x926b,0xe5},
	{0x926c,0x31},
	{0x926d,0xd3},
	{0x926e,0x94},
	{0x926f,0x02},
	{0x9270,0x40},
	{0x9271,0x29},
	{0x9272,0xe4},
	{0x9273,0xf5},
	{0x9274,0x31},
	{0x9275,0xc2},
	{0x9276,0x03},
	{0x9277,0xc2},
	{0x9278,0x02},
	{0x9279,0xc2},
	{0x927a,0x01},
	{0x927b,0xd2},
	{0x927c,0x00},
	{0x927d,0xd2},
	{0x927e,0x34},
	{0x927f,0x22},
	{0x9280,0x12},
	{0x9281,0x02},
	{0x9282,0xa9},
	{0x9283,0x50},
	{0x9284,0x03},
	{0x9285,0x30},
	{0x9286,0x27},
	{0x9287,0x04},
	{0x9288,0x05},
	{0x9289,0x31},
	{0x928a,0x80},
	{0x928b,0x03},
	{0x928c,0xe4},
	{0x928d,0xf5},
	{0x928e,0x31},
	{0x928f,0xe5},
	{0x9290,0x31},
	{0x9291,0xd3},
	{0x9292,0x94},
	{0x9293,0x02},
	{0x9294,0x40},
	{0x9295,0x05},
	{0x9296,0xd2},
	{0x9297,0x03},
	{0x9298,0xe4},
	{0x9299,0xf5},
	{0x929a,0x31},
	{0x929b,0x22},
	{0x929c,0xe5},
	{0x929d,0x0a},
	{0x929e,0x70},
	{0x929f,0x04},
	{0x92a0,0x7a},
	{0x92a1,0x11},
	{0x92a2,0x7b},
	{0x92a3,0x85},
	{0x92a4,0xe5},
	{0x92a5,0x0a},
	{0x92a6,0xb4},
	{0x92a7,0x01},
	{0x92a8,0x04},
	{0x92a9,0x7a},
	{0x92aa,0x11},
	{0x92ab,0x7b},
	{0x92ac,0x99},
	{0x92ad,0xe5},
	{0x92ae,0x0a},
	{0x92af,0xb4},
	{0x92b0,0x02},
	{0x92b1,0x04},
	{0x92b2,0x7a},
	{0x92b3,0x11},
	{0x92b4,0x7b},
	{0x92b5,0xad},
	{0x92b6,0x8b},
	{0x92b7,0x82},
	{0x92b8,0x8a},
	{0x92b9,0x83},
	{0x92ba,0x12},
	{0x92bb,0x09},
	{0x92bc,0xdb},
	{0x92bd,0x8f},
	{0x92be,0x37},
	{0x92bf,0x8e},
	{0x92c0,0x36},
	{0x92c1,0x8d},
	{0x92c2,0x35},
	{0x92c3,0x8c},
	{0x92c4,0x34},
	{0x92c5,0xe5},
	{0x92c6,0x82},
	{0x92c7,0x24},
	{0x92c8,0x04},
	{0x92c9,0xf5},
	{0x92ca,0x82},
	{0x92cb,0xe4},
	{0x92cc,0x35},
	{0x92cd,0x83},
	{0x92ce,0xf5},
	{0x92cf,0x83},
	{0x92d0,0x12},
	{0x92d1,0x09},
	{0x92d2,0xdb},
	{0x92d3,0x8f},
	{0x92d4,0x3b},
	{0x92d5,0x8e},
	{0x92d6,0x3a},
	{0x92d7,0x8d},
	{0x92d8,0x39},
	{0x92d9,0x8c},
	{0x92da,0x38},
	{0x92db,0xeb},
	{0x92dc,0x24},
	{0x92dd,0x08},
	{0x92de,0x12},
	{0x92df,0x02},
	{0x92e0,0x40},
	{0x92e1,0x12},
	{0x92e2,0x01},
	{0x92e3,0xc0},
	{0x92e4,0xeb},
	{0x92e5,0x24},
	{0x92e6,0x0c},
	{0x92e7,0x12},
	{0x92e8,0x02},
	{0x92e9,0x40},
	{0x92ea,0x8f},
	{0x92eb,0x43},
	{0x92ec,0x8e},
	{0x92ed,0x42},
	{0x92ee,0x8d},
	{0x92ef,0x41},
	{0x92f0,0x8c},
	{0x92f1,0x40},
	{0x92f2,0xeb},
	{0x92f3,0x24},
	{0x92f4,0x10},
	{0x92f5,0x12},
	{0x92f6,0x02},
	{0x92f7,0x40},
	{0x92f8,0x8f},
	{0x92f9,0x47},
	{0x92fa,0x8e},
	{0x92fb,0x46},
	{0x92fc,0x8d},
	{0x92fd,0x45},
	{0x92fe,0x8c},
	{0x92ff,0x44},
	{0x9300,0x22},
	{0x9301,0x30},
	{0x9302,0x3e},
	{0x9303,0x07},
	{0x9304,0x30},
	{0x9305,0x20},
	{0x9306,0x04},
	{0x9307,0xaf},
	{0x9308,0x4a},
	{0x9309,0x80},
	{0x930a,0x02},
	{0x930b,0xaf},
	{0x930c,0x7d},
	{0x930d,0x8f},
	{0x930e,0x4a},
	{0x930f,0x30},
	{0x9310,0x3e},
	{0x9311,0x07},
	{0x9312,0x30},
	{0x9313,0x21},
	{0x9314,0x04},
	{0x9315,0xaf},
	{0x9316,0x4b},
	{0x9317,0x80},
	{0x9318,0x02},
	{0x9319,0xaf},
	{0x931a,0x7d},
	{0x931b,0x8f},
	{0x931c,0x4b},
	{0x931d,0x30},
	{0x931e,0x3e},
	{0x931f,0x07},
	{0x9320,0x30},
	{0x9321,0x22},
	{0x9322,0x04},
	{0x9323,0xaf},
	{0x9324,0x4c},
	{0x9325,0x80},
	{0x9326,0x02},
	{0x9327,0xaf},
	{0x9328,0x7d},
	{0x9329,0x8f},
	{0x932a,0x4c},
	{0x932b,0x30},
	{0x932c,0x3e},
	{0x932d,0x07},
	{0x932e,0x30},
	{0x932f,0x23},
	{0x9330,0x04},
	{0x9331,0xaf},
	{0x9332,0x4d},
	{0x9333,0x80},
	{0x9334,0x02},
	{0x9335,0xaf},
	{0x9336,0x7d},
	{0x9337,0x8f},
	{0x9338,0x4d},
	{0x9339,0x30},
	{0x933a,0x3e},
	{0x933b,0x07},
	{0x933c,0x30},
	{0x933d,0x24},
	{0x933e,0x04},
	{0x933f,0xaf},
	{0x9340,0x4e},
	{0x9341,0x80},
	{0x9342,0x02},
	{0x9343,0xaf},
	{0x9344,0x7d},
	{0x9345,0x8f},
	{0x9346,0x4e},
	{0x9347,0x30},
	{0x9348,0x3e},
	{0x9349,0x07},
	{0x934a,0x30},
	{0x934b,0x25},
	{0x934c,0x04},
	{0x934d,0xaf},
	{0x934e,0x4f},
	{0x934f,0x80},
	{0x9350,0x02},
	{0x9351,0xaf},
	{0x9352,0x7d},
	{0x9353,0x8f},
	{0x9354,0x4f},
	{0x9355,0x30},
	{0x9356,0x3e},
	{0x9357,0x07},
	{0x9358,0x30},
	{0x9359,0x26},
	{0x935a,0x04},
	{0x935b,0xaf},
	{0x935c,0x50},
	{0x935d,0x80},
	{0x935e,0x02},
	{0x935f,0xaf},
	{0x9360,0x7d},
	{0x9361,0x8f},
	{0x9362,0x50},
	{0x9363,0x22},
	{0x9364,0xe5},
	{0x9365,0x0c},
	{0x9366,0xd3},
	{0x9367,0x95},
	{0x9368,0x7c},
	{0x9369,0x40},
	{0x936a,0x01},
	{0x936b,0x22},
	{0x936c,0x12},
	{0x936d,0x02},
	{0x936e,0x39},
	{0x936f,0xe5},
	{0x9370,0x0c},
	{0x9371,0x12},
	{0x9372,0x02},
	{0x9373,0x95},
	{0x9374,0xe4},
	{0x9375,0x93},
	{0x9376,0xfe},
	{0x9377,0x74},
	{0x9378,0x01},
	{0x9379,0x93},
	{0x937a,0xff},
	{0x937b,0x4e},
	{0x937c,0x60},
	{0x937d,0x21},
	{0x937e,0x8e},
	{0x937f,0x64},
	{0x9380,0x8f},
	{0x9381,0x65},
	{0x9382,0xef},
	{0x9383,0xc4},
	{0x9384,0xf8},
	{0x9385,0x54},
	{0x9386,0x0f},
	{0x9387,0xc8},
	{0x9388,0x68},
	{0x9389,0xff},
	{0x938a,0xee},
	{0x938b,0xc4},
	{0x938c,0x54},
	{0x938d,0xf0},
	{0x938e,0x48},
	{0x938f,0xfe},
	{0x9390,0x43},
	{0x9391,0x07},
	{0x9392,0x0d},
	{0x9393,0x8e},
	{0x9394,0x0d},
	{0x9395,0x8f},
	{0x9396,0x0e},
	{0x9397,0x12},
	{0x9398,0x0a},
	{0x9399,0x1d},
	{0x939a,0x30},
	{0x939b,0x33},
	{0x939c,0x22},
	{0x939d,0xc3},
	{0x939e,0x22},
	{0x939f,0x75},
	{0x93a0,0x0d},
	{0x93a1,0x00},
	{0x93a2,0x75},
	{0x93a3,0x0e},
	{0x93a4,0x0d},
	{0x93a5,0x12},
	{0x93a6,0x0a},
	{0x93a7,0x1d},
	{0x93a8,0x30},
	{0x93a9,0x33},
	{0x93aa,0x02},
	{0x93ab,0xc3},
	{0x93ac,0x22},
	{0x93ad,0x75},
	{0x93ae,0x0d},
	{0x93af,0x00},
	{0x93b0,0x75},
	{0x93b1,0x0e},
	{0x93b2,0x64},
	{0x93b3,0x12},
	{0x93b4,0x16},
	{0x93b5,0x3d},
	{0x93b6,0x75},
	{0x93b7,0x0d},
	{0x93b8,0x80},
	{0x93b9,0x75},
	{0x93ba,0x0e},
	{0x93bb,0x00},
	{0x93bc,0x12},
	{0x93bd,0x0a},
	{0x93be,0x1d},
	{0x93bf,0x85},
	{0x93c0,0x0c},
	{0x93c1,0x7d},
	{0x93c2,0xd3},
	{0x93c3,0x22},
	{0x93c4,0x12},
	{0x93c5,0x10},
	{0x93c6,0x86},
	{0x93c7,0xd2},
	{0x93c8,0x3e},
	{0x93c9,0x12},
	{0x93ca,0x0f},
	{0x93cb,0x73},
	{0x93cc,0xd2},
	{0x93cd,0x3e},
	{0x93ce,0x12},
	{0x93cf,0x13},
	{0x93d0,0x01},
	{0x93d1,0x30},
	{0x93d2,0x36},
	{0x93d3,0x26},
	{0x93d4,0x30},
	{0x93d5,0x37},
	{0x93d6,0x06},
	{0x93d7,0xe5},
	{0x93d8,0x7c},
	{0x93d9,0x65},
	{0x93da,0x7d},
	{0x93db,0x60},
	{0x93dc,0x3e},
	{0x93dd,0x20},
	{0x93de,0x37},
	{0x93df,0x04},
	{0x93e0,0xe5},
	{0x93e1,0x7d},
	{0x93e2,0x60},
	{0x93e3,0x37},
	{0x93e4,0xe5},
	{0x93e5,0x24},
	{0x93e6,0x54},
	{0x93e7,0x1f},
	{0x93e8,0xff},
	{0x93e9,0xbf},
	{0x93ea,0x1f},
	{0x93eb,0x06},
	{0x93ec,0x30},
	{0x93ed,0x25},
	{0x93ee,0x03},
	{0x93ef,0x20},
	{0x93f0,0x26},
	{0x93f1,0x29},
	{0x93f2,0x30},
	{0x93f3,0x37},
	{0x93f4,0x02},
	{0x93f5,0x80},
	{0x93f6,0x21},
	{0x93f7,0x02},
	{0x93f8,0x16},
	{0x93f9,0xb5},
	{0x93fa,0xe5},
	{0x93fb,0x7c},
	{0x93fc,0xd3},
	{0x93fd,0x95},
	{0x93fe,0x7d},
	{0x93ff,0x40},
	{0x9400,0x03},
	{0x9401,0xd3},
	{0x9402,0x80},
	{0x9403,0x01},
	{0x9404,0xc3},
	{0x9405,0x50},
	{0x9406,0x14},
	{0x9407,0x20},
	{0x9408,0x39},
	{0x9409,0x0e},
	{0x940a,0xe5},
	{0x940b,0x24},
	{0x940c,0x54},
	{0x940d,0x1f},
	{0x940e,0xff},
	{0x940f,0xbf},
	{0x9410,0x1f},
	{0x9411,0x06},
	{0x9412,0x30},
	{0x9413,0x25},
	{0x9414,0x03},
	{0x9415,0x20},
	{0x9416,0x26},
	{0x9417,0x03},
	{0x9418,0x02},
	{0x9419,0x16},
	{0x941a,0xa4},
	{0x941b,0x12},
	{0x941c,0x02},
	{0x941d,0xbd},
	{0x941e,0x22},
	{0x941f,0xc2},
	{0x9420,0x34},
	{0x9421,0x20},
	{0x9422,0x05},
	{0x9423,0x05},
	{0x9424,0x75},
	{0x9425,0x0a},
	{0x9426,0xee},
	{0x9427,0x80},
	{0x9428,0x36},
	{0x9429,0x20},
	{0x942a,0x07},
	{0x942b,0x08},
	{0x942c,0x20},
	{0x942d,0x06},
	{0x942e,0x05},
	{0x942f,0xe4},
	{0x9430,0xf5},
	{0x9431,0x0a},
	{0x9432,0x80},
	{0x9433,0x2b},
	{0x9434,0x20},
	{0x9435,0x07},
	{0x9436,0x08},
	{0x9437,0x30},
	{0x9438,0x06},
	{0x9439,0x05},
	{0x943a,0x75},
	{0x943b,0x0a},
	{0x943c,0x20},
	{0x943d,0x80},
	{0x943e,0x20},
	{0x943f,0x30},
	{0x9440,0x00},
	{0x9441,0x05},
	{0x9442,0x75},
	{0x9443,0x0a},
	{0x9444,0x01},
	{0x9445,0x80},
	{0x9446,0x18},
	{0x9447,0xe5},
	{0x9448,0x20},
	{0x9449,0x54},
	{0x944a,0x07},
	{0x944b,0xff},
	{0x944c,0xbf},
	{0x944d,0x06},
	{0x944e,0x0d},
	{0x944f,0x30},
	{0x9450,0x31},
	{0x9451,0x04},
	{0x9452,0x7f},
	{0x9453,0x12},
	{0x9454,0x80},
	{0x9455,0x02},
	{0x9456,0x7f},
	{0x9457,0x02},
	{0x9458,0x8f},
	{0x9459,0x0a},
	{0x945a,0x80},
	{0x945b,0x03},
	{0x945c,0x75},
	{0x945d,0x0a},
	{0x945e,0xfe},
	{0x945f,0x90},
	{0x9460,0x30},
	{0x9461,0x27},
	{0x9462,0xe5},
	{0x9463,0x0a},
	{0x9464,0xf0},
	{0x9465,0xe5},
	{0x9466,0x23},
	{0x9467,0x54},
	{0x9468,0xf8},
	{0x9469,0xf5},
	{0x946a,0x0a},
	{0x946b,0xe5},
	{0x946c,0x79},
	{0x946d,0x25},
	{0x946e,0x0a},
	{0x946f,0xf5},
	{0x9470,0x0a},
	{0x9471,0x90},
	{0x9472,0x30},
	{0x9473,0x26},
	{0x9474,0xe5},
	{0x9475,0x0a},
	{0x9476,0xf0},
	{0x9477,0x22},
	{0x9478,0xe5},
	{0x9479,0x0a},
	{0x947a,0x70},
	{0x947b,0x04},
	{0x947c,0x7e},
	{0x947d,0x11},
	{0x947e,0x7f},
	{0x947f,0xc1},
	{0x9480,0xe5},
	{0x9481,0x0a},
	{0x9482,0xb4},
	{0x9483,0x01},
	{0x9484,0x04},
	{0x9485,0x7e},
	{0x9486,0x11},
	{0x9487,0x7f},
	{0x9488,0xc6},
	{0x9489,0xe5},
	{0x948a,0x0a},
	{0x948b,0xb4},
	{0x948c,0x02},
	{0x948d,0x04},
	{0x948e,0x7e},
	{0x948f,0x11},
	{0x9490,0x7f},
	{0x9491,0xcb},
	{0x9492,0x8f},
	{0x9493,0x82},
	{0x9494,0x8e},
	{0x9495,0x83},
	{0x9496,0xe4},
	{0x9497,0x93},
	{0x9498,0xf5},
	{0x9499,0x2c},
	{0x949a,0x74},
	{0x949b,0x01},
	{0x949c,0x93},
	{0x949d,0xf5},
	{0x949e,0x2d},
	{0x949f,0x74},
	{0x94a0,0x02},
	{0x94a1,0x93},
	{0x94a2,0xf5},
	{0x94a3,0x2e},
	{0x94a4,0x74},
	{0x94a5,0x03},
	{0x94a6,0x93},
	{0x94a7,0xf5},
	{0x94a8,0x2f},
	{0x94a9,0x74},
	{0x94aa,0x04},
	{0x94ab,0x93},
	{0x94ac,0xf5},
	{0x94ad,0x30},
	{0x94ae,0xe5},
	{0x94af,0x0a},
	{0x94b0,0xb4},
	{0x94b1,0x01},
	{0x94b2,0x07},
	{0x94b3,0x74},
	{0x94b4,0x2c},
	{0x94b5,0x25},
	{0x94b6,0x79},
	{0x94b7,0xf8},
	{0x94b8,0x76},
	{0x94b9,0x40},
	{0x94ba,0xe5},
	{0x94bb,0x0a},
	{0x94bc,0xb4},
	{0x94bd,0x02},
	{0x94be,0x07},
	{0x94bf,0x74},
	{0x94c0,0x2c},
	{0x94c1,0x25},
	{0x94c2,0x79},
	{0x94c3,0xf8},
	{0x94c4,0x76},
	{0x94c5,0x80},
	{0x94c6,0x22},
	{0x94c7,0xc2},
	{0x94c8,0xaf},
	{0x94c9,0x90},
	{0x94ca,0x30},
	{0x94cb,0x27},
	{0x94cc,0x74},
	{0x94cd,0xfa},
	{0x94ce,0xf0},
	{0x94cf,0x12},
	{0x94d0,0x0e},
	{0x94d1,0xd3},
	{0x94d2,0x12},
	{0x94d3,0x16},
	{0x94d4,0x15},
	{0x94d5,0xe4},
	{0x94d6,0xf5},
	{0x94d7,0x33},
	{0x94d8,0xd2},
	{0x94d9,0xaf},
	{0x94da,0x12},
	{0x94db,0x0b},
	{0x94dc,0x69},
	{0x94dd,0x30},
	{0x94de,0x30},
	{0x94df,0x03},
	{0x94e0,0x12},
	{0x94e1,0x06},
	{0x94e2,0xf8},
	{0x94e3,0x30},
	{0x94e4,0x34},
	{0x94e5,0x03},
	{0x94e6,0x12},
	{0x94e7,0x14},
	{0x94e8,0x1f},
	{0x94e9,0x30},
	{0x94ea,0x3d},
	{0x94eb,0xee},
	{0x94ec,0xc2},
	{0x94ed,0x3d},
	{0x94ee,0xd2},
	{0x94ef,0x35},
	{0x94f0,0x30},
	{0x94f1,0x00},
	{0x94f2,0x05},
	{0x94f3,0x12},
	{0x94f4,0x15},
	{0x94f5,0xe8},
	{0x94f6,0x80},
	{0x94f7,0x17},
	{0x94f8,0x30},
	{0x94f9,0x07},
	{0x94fa,0x0b},
	{0x94fb,0x30},
	{0x94fc,0x06},
	{0x94fd,0x08},
	{0x94fe,0x20},
	{0x94ff,0x31},
	{0x9500,0x0e},
	{0x9501,0x12},
	{0x9502,0x12},
	{0x9503,0x36},
	{0x9504,0x80},
	{0x9505,0x09},
	{0x9506,0x20},
	{0x9507,0x07},
	{0x9508,0x06},
	{0x9509,0x30},
	{0x950a,0x06},
	{0x950b,0x03},
	{0x950c,0x12},
	{0x950d,0x0d},
	{0x950e,0xcc},
	{0x950f,0xc2},
	{0x9510,0x35},
	{0x9511,0x80},
	{0x9512,0xc7},
	{0x9513,0xc0},
	{0x9514,0xe0},
	{0x9515,0xc0},
	{0x9516,0x83},
	{0x9517,0xc0},
	{0x9518,0x82},
	{0x9519,0xc0},
	{0x951a,0xd0},
	{0x951b,0x90},
	{0x951c,0x3f},
	{0x951d,0x0d},
	{0x951e,0xe0},
	{0x951f,0xf5},
	{0x9520,0x09},
	{0x9521,0xe5},
	{0x9522,0x09},
	{0x9523,0x30},
	{0x9524,0xe0},
	{0x9525,0x2e},
	{0x9526,0xe5},
	{0x9527,0x7a},
	{0x9528,0xb4},
	{0x9529,0x01},
	{0x952a,0x09},
	{0x952b,0x90},
	{0x952c,0x3a},
	{0x952d,0x00},
	{0x952e,0xe0},
	{0x952f,0xf5},
	{0x9530,0x78},
	{0x9531,0x44},
	{0x9532,0x01},
	{0x9533,0xf0},
	{0x9534,0xe5},
	{0x9535,0x7a},
	{0x9536,0xb4},
	{0x9537,0x03},
	{0x9538,0x09},
	{0x9539,0x90},
	{0x953a,0x3a},
	{0x953b,0x00},
	{0x953c,0xe0},
	{0x953d,0xf5},
	{0x953e,0x78},
	{0x953f,0x54},
	{0x9540,0xfe},
	{0x9541,0xf0},
	{0x9542,0xe5},
	{0x9543,0x7a},
	{0x9544,0xb4},
	{0x9545,0x03},
	{0x9546,0x05},
	{0x9547,0x75},
	{0x9548,0x7a},
	{0x9549,0x00},
	{0x954a,0x80},
	{0x954b,0x02},
	{0x954c,0x05},
	{0x954d,0x7a},
	{0x954e,0x90},
	{0x954f,0x3f},
	{0x9550,0x0d},
	{0x9551,0x74},
	{0x9552,0x01},
	{0x9553,0xf0},
	{0x9554,0xd0},
	{0x9555,0xd0},
	{0x9556,0xd0},
	{0x9557,0x82},
	{0x9558,0xd0},
	{0x9559,0x83},
	{0x955a,0xd0},
	{0x955b,0xe0},
	{0x955c,0x32},
	{0x955d,0x90},
	{0x955e,0x50},
	{0x955f,0x27},
	{0x9560,0xe0},
	{0x9561,0x44},
	{0x9562,0x01},
	{0x9563,0xf0},
	{0x9564,0x90},
	{0x9565,0x50},
	{0x9566,0x34},
	{0x9567,0x74},
	{0x9568,0x80},
	{0x9569,0xf0},
	{0x956a,0xa3},
	{0x956b,0x74},
	{0x956c,0x2a},
	{0x956d,0xf0},
	{0x956e,0xa3},
	{0x956f,0x74},
	{0x9570,0x14},
	{0x9571,0xf0},
	{0x9572,0x90},
	{0x9573,0x50},
	{0x9574,0x30},
	{0x9575,0xe4},
	{0x9576,0xf0},
	{0x9577,0xa3},
	{0x9578,0x74},
	{0x9579,0x02},
	{0x957a,0xf0},
	{0x957b,0xa3},
	{0x957c,0xe4},
	{0x957d,0xf0},
	{0x957e,0xa3},
	{0x957f,0x74},
	{0x9580,0x80},
	{0x9581,0xf0},
	{0x9582,0xe4},
	{0x9583,0xf5},
	{0x9584,0x0a},
	{0x9585,0x12},
	{0x9586,0x12},
	{0x9587,0x9c},
	{0x9588,0x75},
	{0x9589,0x79},
	{0x958a,0x02},
	{0x958b,0x75},
	{0x958c,0x0a},
	{0x958d,0x01},
	{0x958e,0x12},
	{0x958f,0x14},
	{0x9590,0x78},
	{0x9591,0xd2},
	{0x9592,0x18},
	{0x9593,0xd2},
	{0x9594,0x19},
	{0x9595,0xc2},
	{0x9596,0x3c},
	{0x9597,0xc2},
	{0x9598,0x3b},
	{0x9599,0xd2},
	{0x959a,0x1a},
	{0x959b,0xd2},
	{0x959c,0x38},
	{0x959d,0xd2},
	{0x959e,0x30},
	{0x959f,0xc2},
	{0x95a0,0x35},
	{0x95a1,0xc2},
	{0x95a2,0x3d},
	{0x95a3,0x22},
	{0x95a4,0x85},
	{0x95a5,0x10},
	{0x95a6,0x11},
	{0x95a7,0x7f},
	{0x95a8,0x08},
	{0x95a9,0xe5},
	{0x95aa,0x11},
	{0x95ab,0x30},
	{0x95ac,0xe7},
	{0x95ad,0x04},
	{0x95ae,0xd2},
	{0x95af,0x29},
	{0x95b0,0x80},
	{0x95b1,0x02},
	{0x95b2,0xc2},
	{0x95b3,0x29},
	{0x95b4,0x12},
	{0x95b5,0x01},
	{0x95b6,0x6c},
	{0x95b7,0x75},
	{0x95b8,0x51},
	{0x95b9,0x0a},
	{0x95ba,0xae},
	{0x95bb,0x51},
	{0x95bc,0x15},
	{0x95bd,0x51},
	{0x95be,0xee},
	{0x95bf,0x70},
	{0x95c0,0xf9},
	{0x95c1,0xe5},
	{0x95c2,0x11},
	{0x95c3,0x25},
	{0x95c4,0xe0},
	{0x95c5,0xf5},
	{0x95c6,0x11},
	{0x95c7,0xd2},
	{0x95c8,0x28},
	{0x95c9,0x12},
	{0x95ca,0x01},
	{0x95cb,0x6c},
	{0x95cc,0x75},
	{0x95cd,0x51},
	{0x95ce,0x0a},
	{0x95cf,0xae},
	{0x95d0,0x51},
	{0x95d1,0x15},
	{0x95d2,0x51},
	{0x95d3,0xee},
	{0x95d4,0x70},
	{0x95d5,0xf9},
	{0x95d6,0xc2},
	{0x95d7,0x28},
	{0x95d8,0x12},
	{0x95d9,0x01},
	{0x95da,0x6c},
	{0x95db,0x75},
	{0x95dc,0x51},
	{0x95dd,0x05},
	{0x95de,0xae},
	{0x95df,0x51},
	{0x95e0,0x15},
	{0x95e1,0x51},
	{0x95e2,0xee},
	{0x95e3,0x70},
	{0x95e4,0xf9},
	{0x95e5,0xdf},
	{0x95e6,0xc2},
	{0x95e7,0x22},
	{0x95e8,0xe5},
	{0x95e9,0x20},
	{0x95ea,0x54},
	{0x95eb,0x07},
	{0x95ec,0xff},
	{0x95ed,0xbf},
	{0x95ee,0x01},
	{0x95ef,0x03},
	{0x95f0,0x02},
	{0x95f1,0x10},
	{0x95f2,0x00},
	{0x95f3,0xe5},
	{0x95f4,0x20},
	{0x95f5,0x54},
	{0x95f6,0x07},
	{0x95f7,0xff},
	{0x95f8,0xbf},
	{0x95f9,0x07},
	{0x95fa,0x03},
	{0x95fb,0x02},
	{0x95fc,0x11},
	{0x95fd,0xd0},
	{0x95fe,0xe5},
	{0x95ff,0x20},
	{0x9600,0x54},
	{0x9601,0x07},
	{0x9602,0xff},
	{0x9603,0xbf},
	{0x9604,0x03},
	{0x9605,0x03},
	{0x9606,0x02},
	{0x9607,0x13},
	{0x9608,0xc4},
	{0x9609,0xe5},
	{0x960a,0x20},
	{0x960b,0x54},
	{0x960c,0x07},
	{0x960d,0xff},
	{0x960e,0xbf},
	{0x960f,0x05},
	{0x9610,0x03},
	{0x9611,0x12},
	{0x9612,0x16},
	{0x9613,0xe2},
	{0x9614,0x22},
	{0x9615,0x12},
	{0x9616,0x15},
	{0x9617,0x5d},
	{0x9618,0x12},
	{0x9619,0x16},
	{0x961a,0xf0},
	{0x961b,0x50},
	{0x961c,0x04},
	{0x961d,0xd2},
	{0x961e,0x05},
	{0x961f,0x80},
	{0x9620,0x02},
	{0x9621,0xc2},
	{0x9622,0x05},
	{0x9623,0x12},
	{0x9624,0x02},
	{0x9625,0x51},
	{0x9626,0xc2},
	{0x9627,0x39},
	{0x9628,0xc2},
	{0x9629,0x36},
	{0x962a,0xc2},
	{0x962b,0x31},
	{0x962c,0xd2},
	{0x962d,0x34},
	{0x962e,0x12},
	{0x962f,0x02},
	{0x9630,0x7f},
	{0x9631,0xb5},
	{0x9632,0x07},
	{0x9633,0x03},
	{0x9634,0xd3},
	{0x9635,0x80},
	{0x9636,0x01},
	{0x9637,0xc3},
	{0x9638,0x40},
	{0x9639,0x02},
	{0x963a,0xc2},
	{0x963b,0x05},
	{0x963c,0x22},
	{0x963d,0xe4},
	{0x963e,0xff},
	{0x963f,0xfe},
	{0x9640,0xc3},
	{0x9641,0xef},
	{0x9642,0x95},
	{0x9643,0x0e},
	{0x9644,0xee},
	{0x9645,0x95},
	{0x9646,0x0d},
	{0x9647,0x50},
	{0x9648,0x15},
	{0x9649,0x7d},
	{0x964a,0x8a},
	{0x964b,0x7c},
	{0x964c,0x02},
	{0x964d,0xed},
	{0x964e,0x1d},
	{0x964f,0xaa},
	{0x9650,0x04},
	{0x9651,0x70},
	{0x9652,0x01},
	{0x9653,0x1c},
	{0x9654,0x4a},
	{0x9655,0x70},
	{0x9656,0xf6},
	{0x9657,0x0f},
	{0x9658,0xbf},
	{0x9659,0x00},
	{0x965a,0x01},
	{0x965b,0x0e},
	{0x965c,0x80},
	{0x965d,0xe2},
	{0x965e,0x22},
	{0x965f,0xc2},
	{0x9660,0x03},
	{0x9661,0xd2},
	{0x9662,0x04},
	{0x9663,0x12},
	{0x9664,0x02},
	{0x9665,0x9b},
	{0x9666,0x30},
	{0x9667,0x07},
	{0x9668,0x05},
	{0x9669,0x30},
	{0x966a,0x06},
	{0x966b,0x02},
	{0x966c,0xd2},
	{0x966d,0x36},
	{0x966e,0xc2},
	{0x966f,0x3e},
	{0x9670,0x12},
	{0x9671,0x0f},
	{0x9672,0x73},
	{0x9673,0xc2},
	{0x9674,0x3e},
	{0x9675,0x12},
	{0x9676,0x13},
	{0x9677,0x01},
	{0x9678,0xd2},
	{0x9679,0x34},
	{0x967a,0x22},
	{0x967b,0x75},
	{0x967c,0x48},
	{0x967d,0x11},
	{0x967e,0x75},
	{0x967f,0x49},
	{0x9680,0x6a},
	{0x9681,0x90},
	{0x9682,0x11},
	{0x9683,0x68},
	{0x9684,0xe4},
	{0x9685,0x93},
	{0x9686,0xf5},
	{0x9687,0x7c},
	{0x9688,0xa3},
	{0x9689,0xe4},
	{0x968a,0x93},
	{0x968b,0xf5},
	{0x968c,0x32},
	{0x968d,0xc2},
	{0x968e,0x3a},
	{0x968f,0x22},
	{0x9690,0xe4},
	{0x9691,0xff},
	{0x9692,0xef},
	{0x9693,0x25},
	{0x9694,0xe0},
	{0x9695,0x24},
	{0x9696,0x56},
	{0x9697,0xf8},
	{0x9698,0xe4},
	{0x9699,0xf6},
	{0x969a,0x08},
	{0x969b,0xf6},
	{0x969c,0x0f},
	{0x969d,0xbf},
	{0x969e,0x07},
	{0x969f,0xf2},
	{0x96a0,0x53},
	{0x96a1,0x24},
	{0x96a2,0x80},
	{0x96a3,0x22},
	{0x96a4,0xe5},
	{0x96a5,0x7d},
	{0x96a6,0xc3},
	{0x96a7,0x95},
	{0x96a8,0x7c},
	{0x96a9,0x40},
	{0x96aa,0x01},
	{0x96ab,0x22},
	{0x96ac,0xe5},
	{0x96ad,0x7d},
	{0x96ae,0x04},
	{0x96af,0xf5},
	{0x96b0,0x0c},
	{0x96b1,0x12},
	{0x96b2,0x13},
	{0x96b3,0x64},
	{0x96b4,0x22},
	{0x96b5,0xe5},
	{0x96b6,0x7d},
	{0x96b7,0x70},
	{0x96b8,0x02},
	{0x96b9,0xc3},
	{0x96ba,0x22},
	{0x96bb,0xe5},
	{0x96bc,0x7d},
	{0x96bd,0x14},
	{0x96be,0xf5},
	{0x96bf,0x0c},
	{0x96c0,0x12},
	{0x96c1,0x13},
	{0x96c2,0x64},
	{0x96c3,0x22},
	{0x96c4,0xe5},
	{0x96c5,0x7e},
	{0x96c6,0xb4},
	{0x96c7,0x01},
	{0x96c8,0x09},
	{0x96c9,0x12},
	{0x96ca,0x16},
	{0x96cb,0x7b},
	{0x96cc,0xe4},
	{0x96cd,0xf5},
	{0x96ce,0x0c},
	{0x96cf,0x12},
	{0x96d0,0x13},
	{0x96d1,0x64},
	{0x96d2,0x22},
	{0x96d3,0xe5},
	{0x96d4,0x7e},
	{0x96d5,0x24},
	{0x96d6,0xfe},
	{0x96d7,0x60},
	{0x96d8,0x06},
	{0x96d9,0x04},
	{0x96da,0x70},
	{0x96db,0x05},
	{0x96dc,0xd2},
	{0x96dd,0x39},
	{0x96de,0x22},
	{0x96df,0xc2},
	{0x96e0,0x39},
	{0x96e1,0x22},
	{0x96e2,0xe5},
	{0x96e3,0x31},
	{0x96e4,0xd3},
	{0x96e5,0x94},
	{0x96e6,0x00},
	{0x96e7,0x40},
	{0x96e8,0x03},
	{0x96e9,0x15},
	{0x96ea,0x31},
	{0x96eb,0x22},
	{0x96ec,0x12},
	{0x96ed,0x16},
	{0x96ee,0x5f},
	{0x96ef,0x22},
	{0x96f0,0x12},
	{0x96f1,0x16},
	{0x96f2,0x7b},
	{0x96f3,0xe4},
	{0x96f4,0xf5},
	{0x96f5,0x0c},
	{0x96f6,0x12},
	{0x96f7,0x13},
	{0x96f8,0x64},
	{0x96f9,0x22},
	{0x3024,0x00},
	{0x3025,0x00},
	{0x5082,0x00},
	{0x5083,0x00},
	{0x5084,0x00},
	{0x5085,0x00},
	{0x3026,0x00},
	{0x3027,0xFF},
	{0x3000,0x00},
	{0x0000,0x00}
};
#elif (VCM_DRIVER == VCM_DRIVER_DW9710)
static struct reginfo sensor_af_firmware[] =
{
	{0x3000,0x20},
	{0x8000,0x02},
	{0x8001,0x00},
	{0x8002,0x06},
	{0x8003,0x02},
	{0x8004,0x0c},
	{0x8005,0x90},
	{0x8006,0x78},
	{0x8007,0x7f},
	{0x8008,0xe4},
	{0x8009,0xf6},
	{0x800a,0xd8},
	{0x800b,0xfd},
	{0x800c,0x75},
	{0x800d,0x81},
	{0x800e,0x7d},
	{0x800f,0x02},
	{0x8010,0x14},
	{0x8011,0xc7},
	{0x8012,0x00},
	{0x8013,0x02},
	{0x8014,0x15},
	{0x8015,0x13},
	{0x8016,0xe0},
	{0x8017,0xf5},
	{0x8018,0x71},
	{0x8019,0xa3},
	{0x801a,0xe0},
	{0x801b,0xf5},
	{0x801c,0x72},
	{0x801d,0xae},
	{0x801e,0x69},
	{0x801f,0xe4},
	{0x8020,0x85},
	{0x8021,0x6a},
	{0x8022,0x55},
	{0x8023,0x8e},
	{0x8024,0x54},
	{0x8025,0xf5},
	{0x8026,0x53},
	{0x8027,0xf5},
	{0x8028,0x52},
	{0x8029,0xab},
	{0x802a,0x55},
	{0x802b,0xaa},
	{0x802c,0x54},
	{0x802d,0xa9},
	{0x802e,0x53},
	{0x802f,0xa8},
	{0x8030,0x52},
	{0x8031,0xaf},
	{0x8032,0x2c},
	{0x8033,0xfc},
	{0x8034,0xfd},
	{0x8035,0xfe},
	{0x8036,0x12},
	{0x8037,0x08},
	{0x8038,0xa2},
	{0x8039,0x8f},
	{0x803a,0x55},
	{0x803b,0x8e},
	{0x803c,0x54},
	{0x803d,0x8d},
	{0x803e,0x53},
	{0x803f,0x8c},
	{0x8040,0x52},
	{0x8041,0xaf},
	{0x8042,0x55},
	{0x8043,0xae},
	{0x8044,0x54},
	{0x8045,0xad},
	{0x8046,0x53},
	{0x8047,0xac},
	{0x8048,0x52},
	{0x8049,0x8f},
	{0x804a,0x2b},
	{0x804b,0x8e},
	{0x804c,0x2a},
	{0x804d,0x8d},
	{0x804e,0x29},
	{0x804f,0x8c},
	{0x8050,0x28},
	{0x8051,0xae},
	{0x8052,0x6b},
	{0x8053,0xe4},
	{0x8054,0x85},
	{0x8055,0x6c},
	{0x8056,0x55},
	{0x8057,0x8e},
	{0x8058,0x54},
	{0x8059,0xf5},
	{0x805a,0x53},
	{0x805b,0xf5},
	{0x805c,0x52},
	{0x805d,0xab},
	{0x805e,0x55},
	{0x805f,0xaa},
	{0x8060,0x54},
	{0x8061,0xa9},
	{0x8062,0x53},
	{0x8063,0xa8},
	{0x8064,0x52},
	{0x8065,0xaf},
	{0x8066,0x2d},
	{0x8067,0xfc},
	{0x8068,0xfd},
	{0x8069,0xfe},
	{0x806a,0x12},
	{0x806b,0x08},
	{0x806c,0xa2},
	{0x806d,0x8f},
	{0x806e,0x55},
	{0x806f,0x8e},
	{0x8070,0x54},
	{0x8071,0x8d},
	{0x8072,0x53},
	{0x8073,0x8c},
	{0x8074,0x52},
	{0x8075,0xe5},
	{0x8076,0x2b},
	{0x8077,0x25},
	{0x8078,0x55},
	{0x8079,0xf5},
	{0x807a,0x2b},
	{0x807b,0xe5},
	{0x807c,0x2a},
	{0x807d,0x35},
	{0x807e,0x54},
	{0x807f,0xf5},
	{0x8080,0x2a},
	{0x8081,0xe5},
	{0x8082,0x29},
	{0x8083,0x35},
	{0x8084,0x53},
	{0x8085,0xf5},
	{0x8086,0x29},
	{0x8087,0xe5},
	{0x8088,0x28},
	{0x8089,0x35},
	{0x808a,0x52},
	{0x808b,0xf5},
	{0x808c,0x28},
	{0x808d,0xae},
	{0x808e,0x6d},
	{0x808f,0xe4},
	{0x8090,0x85},
	{0x8091,0x6e},
	{0x8092,0x55},
	{0x8093,0x8e},
	{0x8094,0x54},
	{0x8095,0xf5},
	{0x8096,0x53},
	{0x8097,0xf5},
	{0x8098,0x52},
	{0x8099,0xab},
	{0x809a,0x55},
	{0x809b,0xaa},
	{0x809c,0x54},
	{0x809d,0xa9},
	{0x809e,0x53},
	{0x809f,0xa8},
	{0x80a0,0x52},
	{0x80a1,0xaf},
	{0x80a2,0x2e},
	{0x80a3,0xfc},
	{0x80a4,0xfd},
	{0x80a5,0xfe},
	{0x80a6,0x12},
	{0x80a7,0x08},
	{0x80a8,0xa2},
	{0x80a9,0x8f},
	{0x80aa,0x55},
	{0x80ab,0x8e},
	{0x80ac,0x54},
	{0x80ad,0x8d},
	{0x80ae,0x53},
	{0x80af,0x8c},
	{0x80b0,0x52},
	{0x80b1,0xe5},
	{0x80b2,0x2b},
	{0x80b3,0x25},
	{0x80b4,0x55},
	{0x80b5,0xf5},
	{0x80b6,0x2b},
	{0x80b7,0xe5},
	{0x80b8,0x2a},
	{0x80b9,0x35},
	{0x80ba,0x54},
	{0x80bb,0xf5},
	{0x80bc,0x2a},
	{0x80bd,0xe5},
	{0x80be,0x29},
	{0x80bf,0x35},
	{0x80c0,0x53},
	{0x80c1,0xf5},
	{0x80c2,0x29},
	{0x80c3,0xe5},
	{0x80c4,0x28},
	{0x80c5,0x35},
	{0x80c6,0x52},
	{0x80c7,0xf5},
	{0x80c8,0x28},
	{0x80c9,0xae},
	{0x80ca,0x6f},
	{0x80cb,0xe4},
	{0x80cc,0x85},
	{0x80cd,0x70},
	{0x80ce,0x55},
	{0x80cf,0x8e},
	{0x80d0,0x54},
	{0x80d1,0xf5},
	{0x80d2,0x53},
	{0x80d3,0xf5},
	{0x80d4,0x52},
	{0x80d5,0xab},
	{0x80d6,0x55},
	{0x80d7,0xaa},
	{0x80d8,0x54},
	{0x80d9,0xa9},
	{0x80da,0x53},
	{0x80db,0xa8},
	{0x80dc,0x52},
	{0x80dd,0xaf},
	{0x80de,0x2f},
	{0x80df,0xfc},
	{0x80e0,0xfd},
	{0x80e1,0xfe},
	{0x80e2,0x12},
	{0x80e3,0x08},
	{0x80e4,0xa2},
	{0x80e5,0x8f},
	{0x80e6,0x55},
	{0x80e7,0x8e},
	{0x80e8,0x54},
	{0x80e9,0x8d},
	{0x80ea,0x53},
	{0x80eb,0x8c},
	{0x80ec,0x52},
	{0x80ed,0xe5},
	{0x80ee,0x2b},
	{0x80ef,0x25},
	{0x80f0,0x55},
	{0x80f1,0xf5},
	{0x80f2,0x2b},
	{0x80f3,0xe5},
	{0x80f4,0x2a},
	{0x80f5,0x35},
	{0x80f6,0x54},
	{0x80f7,0xf5},
	{0x80f8,0x2a},
	{0x80f9,0xe5},
	{0x80fa,0x29},
	{0x80fb,0x35},
	{0x80fc,0x53},
	{0x80fd,0xf5},
	{0x80fe,0x29},
	{0x80ff,0xe5},
	{0x8100,0x28},
	{0x8101,0x35},
	{0x8102,0x52},
	{0x8103,0xf5},
	{0x8104,0x28},
	{0x8105,0xae},
	{0x8106,0x71},
	{0x8107,0xe4},
	{0x8108,0x85},
	{0x8109,0x72},
	{0x810a,0x55},
	{0x810b,0x8e},
	{0x810c,0x54},
	{0x810d,0xf5},
	{0x810e,0x53},
	{0x810f,0xf5},
	{0x8110,0x52},
	{0x8111,0xab},
	{0x8112,0x55},
	{0x8113,0xaa},
	{0x8114,0x54},
	{0x8115,0xa9},
	{0x8116,0x53},
	{0x8117,0xa8},
	{0x8118,0x52},
	{0x8119,0xaf},
	{0x811a,0x30},
	{0x811b,0xfc},
	{0x811c,0xfd},
	{0x811d,0xfe},
	{0x811e,0x12},
	{0x811f,0x08},
	{0x8120,0xa2},
	{0x8121,0x8f},
	{0x8122,0x55},
	{0x8123,0x8e},
	{0x8124,0x54},
	{0x8125,0x8d},
	{0x8126,0x53},
	{0x8127,0x8c},
	{0x8128,0x52},
	{0x8129,0xe5},
	{0x812a,0x2b},
	{0x812b,0x25},
	{0x812c,0x55},
	{0x812d,0xf5},
	{0x812e,0x2b},
	{0x812f,0xe5},
	{0x8130,0x2a},
	{0x8131,0x35},
	{0x8132,0x54},
	{0x8133,0xf5},
	{0x8134,0x2a},
	{0x8135,0xe5},
	{0x8136,0x29},
	{0x8137,0x35},
	{0x8138,0x53},
	{0x8139,0xf5},
	{0x813a,0x29},
	{0x813b,0xe5},
	{0x813c,0x28},
	{0x813d,0x35},
	{0x813e,0x52},
	{0x813f,0xf5},
	{0x8140,0x28},
	{0x8141,0x22},
	{0x8142,0xab},
	{0x8143,0x0d},
	{0x8144,0xaa},
	{0x8145,0x0c},
	{0x8146,0xa9},
	{0x8147,0x0b},
	{0x8148,0xa8},
	{0x8149,0x0a},
	{0x814a,0xfc},
	{0x814b,0xfd},
	{0x814c,0xfe},
	{0x814d,0x12},
	{0x814e,0x08},
	{0x814f,0xa2},
	{0x8150,0x8f},
	{0x8151,0x0d},
	{0x8152,0x8e},
	{0x8153,0x0c},
	{0x8154,0x8d},
	{0x8155,0x0b},
	{0x8156,0x8c},
	{0x8157,0x0a},
	{0x8158,0x7b},
	{0x8159,0x40},
	{0x815a,0xe4},
	{0x815b,0xfa},
	{0x815c,0xf9},
	{0x815d,0xf8},
	{0x815e,0x12},
	{0x815f,0x09},
	{0x8160,0x2d},
	{0x8161,0x8f},
	{0x8162,0x0d},
	{0x8163,0x8e},
	{0x8164,0x0c},
	{0x8165,0x8d},
	{0x8166,0x0b},
	{0x8167,0x8c},
	{0x8168,0x0a},
	{0x8169,0x22},
	{0x816a,0xd2},
	{0x816b,0x29},
	{0x816c,0x90},
	{0x816d,0x30},
	{0x816e,0x1b},
	{0x816f,0xe5},
	{0x8170,0x25},
	{0x8171,0xf0},
	{0x8172,0x22},
	{0x8173,0xfe},
	{0x8174,0xe4},
	{0x8175,0xfc},
	{0x8176,0xfd},
	{0x8177,0xe5},
	{0x8178,0x3f},
	{0x8179,0x2f},
	{0x817a,0xf5},
	{0x817b,0x3f},
	{0x817c,0xe5},
	{0x817d,0x3e},
	{0x817e,0x3e},
	{0x817f,0xf5},
	{0x8180,0x3e},
	{0x8181,0xed},
	{0x8182,0x35},
	{0x8183,0x3d},
	{0x8184,0xf5},
	{0x8185,0x3d},
	{0x8186,0xec},
	{0x8187,0x35},
	{0x8188,0x3c},
	{0x8189,0xf5},
	{0x818a,0x3c},
	{0x818b,0xaf},
	{0x818c,0x3f},
	{0x818d,0xae},
	{0x818e,0x3e},
	{0x818f,0xfc},
	{0x8190,0xad},
	{0x8191,0x3d},
	{0x8192,0x78},
	{0x8193,0x08},
	{0x8194,0x12},
	{0x8195,0x09},
	{0x8196,0xd2},
	{0x8197,0x8f},
	{0x8198,0x3f},
	{0x8199,0x8e},
	{0x819a,0x3e},
	{0x819b,0x8d},
	{0x819c,0x3d},
	{0x819d,0x8c},
	{0x819e,0x3c},
	{0x819f,0x22},
	{0x81a0,0xe5},
	{0x81a1,0x49},
	{0x81a2,0x25},
	{0x81a3,0x7b},
	{0x81a4,0xf5},
	{0x81a5,0x82},
	{0x81a6,0xe4},
	{0x81a7,0x35},
	{0x81a8,0x48},
	{0x81a9,0xf5},
	{0x81aa,0x83},
	{0x81ab,0xe4},
	{0x81ac,0x93},
	{0x81ad,0xff},
	{0x81ae,0x85},
	{0x81af,0x49},
	{0x81b0,0x82},
	{0x81b1,0x85},
	{0x81b2,0x48},
	{0x81b3,0x83},
	{0x81b4,0xe4},
	{0x81b5,0x93},
	{0x81b6,0xfd},
	{0x81b7,0xc3},
	{0x81b8,0xef},
	{0x81b9,0x9d},
	{0x81ba,0xff},
	{0x81bb,0xe4},
	{0x81bc,0x94},
	{0x81bd,0x00},
	{0x81be,0x22},
	{0x81bf,0xaf},
	{0x81c0,0x2b},
	{0x81c1,0xae},
	{0x81c2,0x2a},
	{0x81c3,0xad},
	{0x81c4,0x29},
	{0x81c5,0xac},
	{0x81c6,0x28},
	{0x81c7,0x78},
	{0x81c8,0x06},
	{0x81c9,0x12},
	{0x81ca,0x09},
	{0x81cb,0xbf},
	{0x81cc,0x8f},
	{0x81cd,0x2b},
	{0x81ce,0x8e},
	{0x81cf,0x2a},
	{0x81d0,0x8d},
	{0x81d1,0x29},
	{0x81d2,0x8c},
	{0x81d3,0x28},
	{0x81d4,0xd3},
	{0x81d5,0xe5},
	{0x81d6,0x29},
	{0x81d7,0x94},
	{0x81d8,0x00},
	{0x81d9,0xe5},
	{0x81da,0x28},
	{0x81db,0x94},
	{0x81dc,0x00},
	{0x81dd,0x22},
	{0x81de,0xe5},
	{0x81df,0x0b},
	{0x81e0,0x24},
	{0x81e1,0x01},
	{0x81e2,0xff},
	{0x81e3,0xe4},
	{0x81e4,0x33},
	{0x81e5,0xfe},
	{0x81e6,0x22},
	{0x81e7,0x12},
	{0x81e8,0x08},
	{0x81e9,0xa2},
	{0x81ea,0x8f},
	{0x81eb,0x68},
	{0x81ec,0x8e},
	{0x81ed,0x67},
	{0x81ee,0x8d},
	{0x81ef,0x66},
	{0x81f0,0x8c},
	{0x81f1,0x65},
	{0x81f2,0xaf},
	{0x81f3,0x68},
	{0x81f4,0xae},
	{0x81f5,0x67},
	{0x81f6,0xad},
	{0x81f7,0x66},
	{0x81f8,0xac},
	{0x81f9,0x65},
	{0x81fa,0x22},
	{0x81fb,0xe0},
	{0x81fc,0x44},
	{0x81fd,0x01},
	{0x81fe,0xf0},
	{0x81ff,0xe0},
	{0x8200,0x44},
	{0x8201,0x02},
	{0x8202,0xf0},
	{0x8203,0xe0},
	{0x8204,0x44},
	{0x8205,0x04},
	{0x8206,0xf0},
	{0x8207,0x22},
	{0x8208,0xd2},
	{0x8209,0x09},
	{0x820a,0x90},
	{0x820b,0x30},
	{0x820c,0x18},
	{0x820d,0xe5},
	{0x820e,0x21},
	{0x820f,0xf0},
	{0x8210,0x22},
	{0x8211,0xe4},
	{0x8212,0x85},
	{0x8213,0x11},
	{0x8214,0x0d},
	{0x8215,0x85},
	{0x8216,0x10},
	{0x8217,0x0c},
	{0x8218,0xf5},
	{0x8219,0x0b},
	{0x821a,0xf5},
	{0x821b,0x0a},
	{0x821c,0xab},
	{0x821d,0x0d},
	{0x821e,0xaa},
	{0x821f,0x0c},
	{0x8220,0xa9},
	{0x8221,0x0b},
	{0x8222,0xa8},
	{0x8223,0x0a},
	{0x8224,0x22},
	{0x8225,0x90},
	{0x8226,0x30},
	{0x8227,0x42},
	{0x8228,0xe0},
	{0x8229,0xf5},
	{0x822a,0x22},
	{0x822b,0x75},
	{0x822c,0x51},
	{0x822d,0x0a},
	{0x822e,0x22},
	{0x822f,0xf5},
	{0x8230,0x82},
	{0x8231,0xe4},
	{0x8232,0x3a},
	{0x8233,0xf5},
	{0x8234,0x83},
	{0x8235,0x02},
	{0x8236,0x09},
	{0x8237,0xe5},
	{0x8238,0x8f},
	{0x8239,0x0a},
	{0x823a,0x74},
	{0x823b,0x4a},
	{0x823c,0x2f},
	{0x823d,0xf8},
	{0x823e,0xe6},
	{0x823f,0x22},
	{0x8240,0xc2},
	{0x8241,0x07},
	{0x8242,0xc2},
	{0x8243,0x06},
	{0x8244,0xc2},
	{0x8245,0x02},
	{0x8246,0xc2},
	{0x8247,0x01},
	{0x8248,0xc2},
	{0x8249,0x00},
	{0x824a,0xc2},
	{0x824b,0x03},
	{0x824c,0xd2},
	{0x824d,0x04},
	{0x824e,0x22},
	{0x824f,0xf5},
	{0x8250,0x82},
	{0x8251,0xe4},
	{0x8252,0x35},
	{0x8253,0x48},
	{0x8254,0xf5},
	{0x8255,0x83},
	{0x8256,0xe4},
	{0x8257,0x22},
	{0x8258,0x8e},
	{0x8259,0x67},
	{0x825a,0x8f},
	{0x825b,0x68},
	{0x825c,0x85},
	{0x825d,0x68},
	{0x825e,0x64},
	{0x825f,0xe5},
	{0x8260,0x68},
	{0x8261,0xae},
	{0x8262,0x67},
	{0x8263,0x78},
	{0x8264,0x06},
	{0x8265,0x22},
	{0x8266,0xe5},
	{0x8267,0x16},
	{0x8268,0x25},
	{0x8269,0xe0},
	{0x826a,0x25},
	{0x826b,0xe0},
	{0x826c,0x22},
	{0x826d,0x12},
	{0x826e,0x09},
	{0x826f,0x2d},
	{0x8270,0x8f},
	{0x8271,0x68},
	{0x8272,0x8e},
	{0x8273,0x67},
	{0x8274,0x8d},
	{0x8275,0x66},
	{0x8276,0x8c},
	{0x8277,0x65},
	{0x8278,0x22},
	{0x8279,0xe4},
	{0x827a,0x85},
	{0x827b,0x0f},
	{0x827c,0x0d},
	{0x827d,0x85},
	{0x827e,0x0e},
	{0x827f,0x0c},
	{0x8280,0xf5},
	{0x8281,0x0b},
	{0x8282,0xf5},
	{0x8283,0x0a},
	{0x8284,0x22},
	{0x8285,0x90},
	{0x8286,0x13},
	{0x8287,0x70},
	{0x8288,0xe4},
	{0x8289,0x93},
	{0x828a,0xff},
	{0x828b,0x90},
	{0x828c,0x30},
	{0x828d,0x0a},
	{0x828e,0xe0},
	{0x828f,0x22},
	{0x8290,0xc2},
	{0x8291,0x02},
	{0x8292,0xc2},
	{0x8293,0x01},
	{0x8294,0xd2},
	{0x8295,0x00},
	{0x8296,0xc2},
	{0x8297,0x03},
	{0x8298,0xc2},
	{0x8299,0x04},
	{0x829a,0x22},
	{0x829b,0x85},
	{0x829c,0x0e},
	{0x829d,0x64},
	{0x829e,0xe5},
	{0x829f,0x0e},
	{0x82a0,0xae},
	{0x82a1,0x0d},
	{0x82a2,0x78},
	{0x82a3,0x06},
	{0x82a4,0x22},
	{0x82a5,0xd2},
	{0x82a6,0x02},
	{0x82a7,0xd2},
	{0x82a8,0x01},
	{0x82a9,0xc2},
	{0x82aa,0x00},
	{0x82ab,0x22},
	{0x82ac,0x74},
	{0x82ad,0x4a},
	{0x82ae,0x25},
	{0x82af,0x0a},
	{0x82b0,0xf8},
	{0x82b1,0xe6},
	{0x82b2,0x22},
	{0x82b3,0xd3},
	{0x82b4,0xe5},
	{0x82b5,0x0b},
	{0x82b6,0x94},
	{0x82b7,0xff},
	{0x82b8,0xe5},
	{0x82b9,0x0a},
	{0x82ba,0x94},
	{0x82bb,0x00},
	{0x82bc,0x22},
	{0x82bd,0xd3},
	{0x82be,0xe5},
	{0x82bf,0x68},
	{0x82c0,0x94},
	{0x82c1,0xff},
	{0x82c2,0xe5},
	{0x82c3,0x67},
	{0x82c4,0x94},
	{0x82c5,0x00},
	{0x82c6,0x22},
	{0x82c7,0x30},
	{0x82c8,0x18},
	{0x82c9,0x4d},
	{0x82ca,0x20},
	{0x82cb,0x19},
	{0x82cc,0x4a},
	{0x82cd,0x75},
	{0x82ce,0x0a},
	{0x82cf,0x02},
	{0x82d0,0x12},
	{0x82d1,0x02},
	{0x82d2,0xac},
	{0x82d3,0xff},
	{0x82d4,0xe5},
	{0x82d5,0x4a},
	{0x82d6,0xd3},
	{0x82d7,0x9f},
	{0x82d8,0x40},
	{0x82d9,0x04},
	{0x82da,0x7f},
	{0x82db,0x00},
	{0x82dc,0x80},
	{0x82dd,0x02},
	{0x82de,0xaf},
	{0x82df,0x0a},
	{0x82e0,0x12},
	{0x82e1,0x02},
	{0x82e2,0x38},
	{0x82e3,0xff},
	{0x82e4,0xe5},
	{0x82e5,0x4b},
	{0x82e6,0xd3},
	{0x82e7,0x9f},
	{0x82e8,0x40},
	{0x82e9,0x04},
	{0x82ea,0x7f},
	{0x82eb,0x01},
	{0x82ec,0x80},
	{0x82ed,0x02},
	{0x82ee,0xaf},
	{0x82ef,0x0a},
	{0x82f0,0x12},
	{0x82f1,0x02},
	{0x82f2,0x38},
	{0x82f3,0xff},
	{0x82f4,0xe5},
	{0x82f5,0x4d},
	{0x82f6,0xd3},
	{0x82f7,0x9f},
	{0x82f8,0x40},
	{0x82f9,0x04},
	{0x82fa,0x7f},
	{0x82fb,0x03},
	{0x82fc,0x80},
	{0x82fd,0x02},
	{0x82fe,0xaf},
	{0x82ff,0x0a},
	{0x8300,0x12},
	{0x8301,0x02},
	{0x8302,0x38},
	{0x8303,0xff},
	{0x8304,0xe5},
	{0x8305,0x4e},
	{0x8306,0xd3},
	{0x8307,0x9f},
	{0x8308,0x40},
	{0x8309,0x04},
	{0x830a,0x7f},
	{0x830b,0x04},
	{0x830c,0x80},
	{0x830d,0x02},
	{0x830e,0xaf},
	{0x830f,0x0a},
	{0x8310,0x12},
	{0x8311,0x02},
	{0x8312,0x38},
	{0x8313,0xf5},
	{0x8314,0x0b},
	{0x8315,0x80},
	{0x8316,0x06},
	{0x8317,0x85},
	{0x8318,0x78},
	{0x8319,0x0a},
	{0x831a,0x85},
	{0x831b,0x4f},
	{0x831c,0x0b},
	{0x831d,0x7f},
	{0x831e,0x01},
	{0x831f,0xe4},
	{0x8320,0xfe},
	{0x8321,0x12},
	{0x8322,0x02},
	{0x8323,0xac},
	{0x8324,0xfd},
	{0x8325,0xe5},
	{0x8326,0x0b},
	{0x8327,0xc3},
	{0x8328,0x9d},
	{0x8329,0x50},
	{0x832a,0x04},
	{0x832b,0x7d},
	{0x832c,0x01},
	{0x832d,0x80},
	{0x832e,0x02},
	{0x832f,0x7d},
	{0x8330,0xff},
	{0x8331,0xac},
	{0x8332,0x0b},
	{0x8333,0xe5},
	{0x8334,0x4e},
	{0x8335,0xb5},
	{0x8336,0x0b},
	{0x8337,0x03},
	{0x8338,0xd3},
	{0x8339,0x80},
	{0x833a,0x01},
	{0x833b,0xc3},
	{0x833c,0x92},
	{0x833d,0x1f},
	{0x833e,0xe5},
	{0x833f,0x4d},
	{0x8340,0xb5},
	{0x8341,0x0b},
	{0x8342,0x03},
	{0x8343,0xd3},
	{0x8344,0x80},
	{0x8345,0x01},
	{0x8346,0xc3},
	{0x8347,0x92},
	{0x8348,0x1e},
	{0x8349,0xe5},
	{0x834a,0x4c},
	{0x834b,0xb5},
	{0x834c,0x0b},
	{0x834d,0x03},
	{0x834e,0xd3},
	{0x834f,0x80},
	{0x8350,0x01},
	{0x8351,0xc3},
	{0x8352,0x92},
	{0x8353,0x1d},
	{0x8354,0xe5},
	{0x8355,0x4b},
	{0x8356,0xb5},
	{0x8357,0x0b},
	{0x8358,0x03},
	{0x8359,0xd3},
	{0x835a,0x80},
	{0x835b,0x01},
	{0x835c,0xc3},
	{0x835d,0x92},
	{0x835e,0x1c},
	{0x835f,0xe5},
	{0x8360,0x4a},
	{0x8361,0xb5},
	{0x8362,0x0b},
	{0x8363,0x03},
	{0x8364,0xd3},
	{0x8365,0x80},
	{0x8366,0x01},
	{0x8367,0xc3},
	{0x8368,0x92},
	{0x8369,0x1b},
	{0x836a,0xe5},
	{0x836b,0x30},
	{0x836c,0xd3},
	{0x836d,0x94},
	{0x836e,0x00},
	{0x836f,0x40},
	{0x8370,0x04},
	{0x8371,0xa2},
	{0x8372,0x1f},
	{0x8373,0x80},
	{0x8374,0x01},
	{0x8375,0xc3},
	{0x8376,0x92},
	{0x8377,0x1f},
	{0x8378,0xe5},
	{0x8379,0x2f},
	{0x837a,0xd3},
	{0x837b,0x94},
	{0x837c,0x00},
	{0x837d,0x40},
	{0x837e,0x04},
	{0x837f,0xa2},
	{0x8380,0x1e},
	{0x8381,0x80},
	{0x8382,0x01},
	{0x8383,0xc3},
	{0x8384,0x92},
	{0x8385,0x1e},
	{0x8386,0xe5},
	{0x8387,0x2e},
	{0x8388,0xd3},
	{0x8389,0x94},
	{0x838a,0x00},
	{0x838b,0x40},
	{0x838c,0x04},
	{0x838d,0xa2},
	{0x838e,0x1d},
	{0x838f,0x80},
	{0x8390,0x01},
	{0x8391,0xc3},
	{0x8392,0x92},
	{0x8393,0x1d},
	{0x8394,0xe5},
	{0x8395,0x2d},
	{0x8396,0xd3},
	{0x8397,0x94},
	{0x8398,0x00},
	{0x8399,0x40},
	{0x839a,0x04},
	{0x839b,0xa2},
	{0x839c,0x1c},
	{0x839d,0x80},
	{0x839e,0x01},
	{0x839f,0xc3},
	{0x83a0,0x92},
	{0x83a1,0x1c},
	{0x83a2,0xe5},
	{0x83a3,0x2c},
	{0x83a4,0xd3},
	{0x83a5,0x94},
	{0x83a6,0x00},
	{0x83a7,0x40},
	{0x83a8,0x04},
	{0x83a9,0xa2},
	{0x83aa,0x1b},
	{0x83ab,0x80},
	{0x83ac,0x01},
	{0x83ad,0xc3},
	{0x83ae,0x92},
	{0x83af,0x1b},
	{0x83b0,0xe5},
	{0x83b1,0x23},
	{0x83b2,0x54},
	{0x83b3,0xf8},
	{0x83b4,0x70},
	{0x83b5,0x5b},
	{0x83b6,0xbf},
	{0x83b7,0x01},
	{0x83b8,0x08},
	{0x83b9,0xed},
	{0x83ba,0xf4},
	{0x83bb,0x04},
	{0x83bc,0xfd},
	{0x83bd,0x7f},
	{0x83be,0x02},
	{0x83bf,0x80},
	{0x83c0,0x06},
	{0x83c1,0xbf},
	{0x83c2,0x02},
	{0x83c3,0x02},
	{0x83c4,0x7f},
	{0x83c5,0x01},
	{0x83c6,0x0e},
	{0x83c7,0xd3},
	{0x83c8,0xed},
	{0x83c9,0x64},
	{0x83ca,0x80},
	{0x83cb,0x94},
	{0x83cc,0x80},
	{0x83cd,0x40},
	{0x83ce,0x18},
	{0x83cf,0xec},
	{0x83d0,0x2e},
	{0x83d1,0xf5},
	{0x83d2,0x0b},
	{0x83d3,0xd3},
	{0x83d4,0x95},
	{0x83d5,0x7b},
	{0x83d6,0x40},
	{0x83d7,0x2c},
	{0x83d8,0x7d},
	{0x83d9,0xff},
	{0x83da,0xef},
	{0x83db,0x60},
	{0x83dc,0x04},
	{0x83dd,0x7b},
	{0x83de,0x00},
	{0x83df,0x80},
	{0x83e0,0x02},
	{0x83e1,0x7b},
	{0x83e2,0x03},
	{0x83e3,0xaf},
	{0x83e4,0x03},
	{0x83e5,0x80},
	{0x83e6,0x18},
	{0x83e7,0xec},
	{0x83e8,0xc3},
	{0x83e9,0x9e},
	{0x83ea,0x50},
	{0x83eb,0x13},
	{0x83ec,0x7d},
	{0x83ed,0x01},
	{0x83ee,0xef},
	{0x83ef,0x60},
	{0x83f0,0x04},
	{0x83f1,0x7b},
	{0x83f2,0x00},
	{0x83f3,0x80},
	{0x83f4,0x02},
	{0x83f5,0x7b},
	{0x83f6,0x03},
	{0x83f7,0xaf},
	{0x83f8,0x03},
	{0x83f9,0xec},
	{0x83fa,0x2e},
	{0x83fb,0xf5},
	{0x83fc,0x0b},
	{0x83fd,0x80},
	{0x83fe,0x05},
	{0x83ff,0xc3},
	{0x8400,0xec},
	{0x8401,0x9e},
	{0x8402,0xf5},
	{0x8403,0x0b},
	{0x8404,0xef},
	{0x8405,0x64},
	{0x8406,0x03},
	{0x8407,0x60},
	{0x8408,0x03},
	{0x8409,0x02},
	{0x840a,0x03},
	{0x840b,0x33},
	{0x840c,0x12},
	{0x840d,0x02},
	{0x840e,0xac},
	{0x840f,0xf5},
	{0x8410,0x0b},
	{0x8411,0x12},
	{0x8412,0x01},
	{0x8413,0xde},
	{0x8414,0xe5},
	{0x8415,0x4e},
	{0x8416,0xb5},
	{0x8417,0x07},
	{0x8418,0x07},
	{0x8419,0xe4},
	{0x841a,0xb5},
	{0x841b,0x06},
	{0x841c,0x03},
	{0x841d,0xd3},
	{0x841e,0x80},
	{0x841f,0x02},
	{0x8420,0xa2},
	{0x8421,0x1f},
	{0x8422,0x92},
	{0x8423,0x1f},
	{0x8424,0xe5},
	{0x8425,0x4d},
	{0x8426,0xb5},
	{0x8427,0x07},
	{0x8428,0x07},
	{0x8429,0xe4},
	{0x842a,0xb5},
	{0x842b,0x06},
	{0x842c,0x03},
	{0x842d,0xd3},
	{0x842e,0x80},
	{0x842f,0x02},
	{0x8430,0xa2},
	{0x8431,0x1e},
	{0x8432,0x92},
	{0x8433,0x1e},
	{0x8434,0x12},
	{0x8435,0x01},
	{0x8436,0xde},
	{0x8437,0xe5},
	{0x8438,0x4c},
	{0x8439,0xb5},
	{0x843a,0x07},
	{0x843b,0x07},
	{0x843c,0xe4},
	{0x843d,0xb5},
	{0x843e,0x06},
	{0x843f,0x03},
	{0x8440,0xd3},
	{0x8441,0x80},
	{0x8442,0x02},
	{0x8443,0xa2},
	{0x8444,0x1d},
	{0x8445,0x92},
	{0x8446,0x1d},
	{0x8447,0xe5},
	{0x8448,0x4b},
	{0x8449,0xb5},
	{0x844a,0x07},
	{0x844b,0x07},
	{0x844c,0xe4},
	{0x844d,0xb5},
	{0x844e,0x06},
	{0x844f,0x03},
	{0x8450,0xd3},
	{0x8451,0x80},
	{0x8452,0x02},
	{0x8453,0xa2},
	{0x8454,0x1c},
	{0x8455,0x92},
	{0x8456,0x1c},
	{0x8457,0x12},
	{0x8458,0x01},
	{0x8459,0xde},
	{0x845a,0xe5},
	{0x845b,0x4a},
	{0x845c,0xb5},
	{0x845d,0x07},
	{0x845e,0x07},
	{0x845f,0xe4},
	{0x8460,0xb5},
	{0x8461,0x06},
	{0x8462,0x03},
	{0x8463,0xd3},
	{0x8464,0x80},
	{0x8465,0x02},
	{0x8466,0xa2},
	{0x8467,0x1b},
	{0x8468,0x92},
	{0x8469,0x1b},
	{0x846a,0xe5},
	{0x846b,0x4e},
	{0x846c,0x12},
	{0x846d,0x01},
	{0x846e,0xe0},
	{0x846f,0xad},
	{0x8470,0x0b},
	{0x8471,0x7c},
	{0x8472,0x00},
	{0x8473,0xef},
	{0x8474,0xb5},
	{0x8475,0x05},
	{0x8476,0x07},
	{0x8477,0xec},
	{0x8478,0xb5},
	{0x8479,0x06},
	{0x847a,0x03},
	{0x847b,0xd3},
	{0x847c,0x80},
	{0x847d,0x02},
	{0x847e,0xa2},
	{0x847f,0x1f},
	{0x8480,0x92},
	{0x8481,0x1f},
	{0x8482,0xe5},
	{0x8483,0x4d},
	{0x8484,0x12},
	{0x8485,0x01},
	{0x8486,0xe0},
	{0x8487,0xef},
	{0x8488,0xb5},
	{0x8489,0x05},
	{0x848a,0x07},
	{0x848b,0xee},
	{0x848c,0xb5},
	{0x848d,0x04},
	{0x848e,0x03},
	{0x848f,0xd3},
	{0x8490,0x80},
	{0x8491,0x02},
	{0x8492,0xa2},
	{0x8493,0x1e},
	{0x8494,0x92},
	{0x8495,0x1e},
	{0x8496,0xe5},
	{0x8497,0x4c},
	{0x8498,0x12},
	{0x8499,0x01},
	{0x849a,0xe0},
	{0x849b,0xad},
	{0x849c,0x0b},
	{0x849d,0x7c},
	{0x849e,0x00},
	{0x849f,0xef},
	{0x84a0,0xb5},
	{0x84a1,0x05},
	{0x84a2,0x07},
	{0x84a3,0xec},
	{0x84a4,0xb5},
	{0x84a5,0x06},
	{0x84a6,0x03},
	{0x84a7,0xd3},
	{0x84a8,0x80},
	{0x84a9,0x02},
	{0x84aa,0xa2},
	{0x84ab,0x1d},
	{0x84ac,0x92},
	{0x84ad,0x1d},
	{0x84ae,0xe5},
	{0x84af,0x4b},
	{0x84b0,0x12},
	{0x84b1,0x01},
	{0x84b2,0xe0},
	{0x84b3,0xef},
	{0x84b4,0xb5},
	{0x84b5,0x05},
	{0x84b6,0x07},
	{0x84b7,0xee},
	{0x84b8,0xb5},
	{0x84b9,0x04},
	{0x84ba,0x03},
	{0x84bb,0xd3},
	{0x84bc,0x80},
	{0x84bd,0x02},
	{0x84be,0xa2},
	{0x84bf,0x1c},
	{0x84c0,0x92},
	{0x84c1,0x1c},
	{0x84c2,0xe5},
	{0x84c3,0x4a},
	{0x84c4,0x12},
	{0x84c5,0x01},
	{0x84c6,0xe0},
	{0x84c7,0x7c},
	{0x84c8,0x00},
	{0x84c9,0xef},
	{0x84ca,0xb5},
	{0x84cb,0x0b},
	{0x84cc,0x07},
	{0x84cd,0xec},
	{0x84ce,0xb5},
	{0x84cf,0x06},
	{0x84d0,0x03},
	{0x84d1,0xd3},
	{0x84d2,0x80},
	{0x84d3,0x02},
	{0x84d4,0xa2},
	{0x84d5,0x1b},
	{0x84d6,0x92},
	{0x84d7,0x1b},
	{0x84d8,0xe5},
	{0x84d9,0x30},
	{0x84da,0xd3},
	{0x84db,0x94},
	{0x84dc,0x00},
	{0x84dd,0x40},
	{0x84de,0x04},
	{0x84df,0xa2},
	{0x84e0,0x1f},
	{0x84e1,0x80},
	{0x84e2,0x01},
	{0x84e3,0xc3},
	{0x84e4,0x92},
	{0x84e5,0x1f},
	{0x84e6,0xe5},
	{0x84e7,0x2f},
	{0x84e8,0xd3},
	{0x84e9,0x94},
	{0x84ea,0x00},
	{0x84eb,0x40},
	{0x84ec,0x04},
	{0x84ed,0xa2},
	{0x84ee,0x1e},
	{0x84ef,0x80},
	{0x84f0,0x01},
	{0x84f1,0xc3},
	{0x84f2,0x92},
	{0x84f3,0x1e},
	{0x84f4,0xe5},
	{0x84f5,0x2e},
	{0x84f6,0xd3},
	{0x84f7,0x94},
	{0x84f8,0x00},
	{0x84f9,0x40},
	{0x84fa,0x04},
	{0x84fb,0xa2},
	{0x84fc,0x1d},
	{0x84fd,0x80},
	{0x84fe,0x01},
	{0x84ff,0xc3},
	{0x8500,0x92},
	{0x8501,0x1d},
	{0x8502,0xe5},
	{0x8503,0x2d},
	{0x8504,0xd3},
	{0x8505,0x94},
	{0x8506,0x00},
	{0x8507,0x40},
	{0x8508,0x04},
	{0x8509,0xa2},
	{0x850a,0x1c},
	{0x850b,0x80},
	{0x850c,0x01},
	{0x850d,0xc3},
	{0x850e,0x92},
	{0x850f,0x1c},
	{0x8510,0xe5},
	{0x8511,0x2c},
	{0x8512,0xd3},
	{0x8513,0x94},
	{0x8514,0x00},
	{0x8515,0x40},
	{0x8516,0x04},
	{0x8517,0xa2},
	{0x8518,0x1b},
	{0x8519,0x80},
	{0x851a,0x01},
	{0x851b,0xc3},
	{0x851c,0x92},
	{0x851d,0x1b},
	{0x851e,0x85},
	{0x851f,0x0a},
	{0x8520,0x78},
	{0x8521,0xe5},
	{0x8522,0x7c},
	{0x8523,0xb5},
	{0x8524,0x0b},
	{0x8525,0x03},
	{0x8526,0x02},
	{0x8527,0x16},
	{0x8528,0x5f},
	{0x8529,0x85},
	{0x852a,0x0b},
	{0x852b,0x0c},
	{0x852c,0x12},
	{0x852d,0x0f},
	{0x852e,0x52},
	{0x852f,0xd2},
	{0x8530,0x02},
	{0x8531,0xc2},
	{0x8532,0x01},
	{0x8533,0xd2},
	{0x8534,0x00},
	{0x8535,0x75},
	{0x8536,0x31},
	{0x8537,0x03},
	{0x8538,0x22},
	{0x8539,0xe5},
	{0x853a,0x7d},
	{0x853b,0x24},
	{0x853c,0xfe},
	{0x853d,0x60},
	{0x853e,0x27},
	{0x853f,0x14},
	{0x8540,0x60},
	{0x8541,0x31},
	{0x8542,0x24},
	{0x8543,0xf8},
	{0x8544,0x60},
	{0x8545,0x3a},
	{0x8546,0x14},
	{0x8547,0x60},
	{0x8548,0x4b},
	{0x8549,0x14},
	{0x854a,0x60},
	{0x854b,0x59},
	{0x854c,0x14},
	{0x854d,0x60},
	{0x854e,0x6a},
	{0x854f,0x24},
	{0x8550,0xfd},
	{0x8551,0x70},
	{0x8552,0x03},
	{0x8553,0x02},
	{0x8554,0x05},
	{0x8555,0xee},
	{0x8556,0x24},
	{0x8557,0x10},
	{0x8558,0x60},
	{0x8559,0x03},
	{0x855a,0x02},
	{0x855b,0x06},
	{0x855c,0xe9},
	{0x855d,0xe4},
	{0x855e,0xf5},
	{0x855f,0x0a},
	{0x8560,0x12},
	{0x8561,0x12},
	{0x8562,0x48},
	{0x8563,0x02},
	{0x8564,0x06},
	{0x8565,0xd2},
	{0x8566,0x75},
	{0x8567,0x0a},
	{0x8568,0x01},
	{0x8569,0x12},
	{0x856a,0x06},
	{0x856b,0xea},
	{0x856c,0xc2},
	{0x856d,0x3c},
	{0x856e,0xd2},
	{0x856f,0x3b},
	{0x8570,0x02},
	{0x8571,0x06},
	{0x8572,0xe3},
	{0x8573,0x75},
	{0x8574,0x0a},
	{0x8575,0x02},
	{0x8576,0x12},
	{0x8577,0x06},
	{0x8578,0xea},
	{0x8579,0xd2},
	{0x857a,0x3c},
	{0x857b,0xc2},
	{0x857c,0x3b},
	{0x857d,0x02},
	{0x857e,0x06},
	{0x857f,0xe3},
	{0x8580,0x30},
	{0x8581,0x38},
	{0x8582,0x0c},
	{0x8583,0x20},
	{0x8584,0x3c},
	{0x8585,0x03},
	{0x8586,0x30},
	{0x8587,0x3b},
	{0x8588,0x06},
	{0x8589,0xe4},
	{0x858a,0xf5},
	{0x858b,0x0a},
	{0x858c,0x12},
	{0x858d,0x14},
	{0x858e,0x78},
	{0x858f,0xd2},
	{0x8590,0x18},
	{0x8591,0xc2},
	{0x8592,0x19},
	{0x8593,0x22},
	{0x8594,0x30},
	{0x8595,0x38},
	{0x8596,0x09},
	{0x8597,0x20},
	{0x8598,0x3c},
	{0x8599,0x03},
	{0x859a,0x30},
	{0x859b,0x3b},
	{0x859c,0x03},
	{0x859d,0x12},
	{0x859e,0x06},
	{0x859f,0xfb},
	{0x85a0,0xd2},
	{0x85a1,0x18},
	{0x85a2,0xd2},
	{0x85a3,0x19},
	{0x85a4,0x22},
	{0x85a5,0x30},
	{0x85a6,0x38},
	{0x85a7,0x0c},
	{0x85a8,0x20},
	{0x85a9,0x3c},
	{0x85aa,0x03},
	{0x85ab,0x30},
	{0x85ac,0x3b},
	{0x85ad,0x06},
	{0x85ae,0x75},
	{0x85af,0x0a},
	{0x85b0,0x02},
	{0x85b1,0x12},
	{0x85b2,0x14},
	{0x85b3,0x78},
	{0x85b4,0xc2},
	{0x85b5,0x18},
	{0x85b6,0xd2},
	{0x85b7,0x19},
	{0x85b8,0x22},
	{0x85b9,0x20},
	{0x85ba,0x3c},
	{0x85bb,0x06},
	{0x85bc,0x20},
	{0x85bd,0x3b},
	{0x85be,0x03},
	{0x85bf,0x02},
	{0x85c0,0x06},
	{0x85c1,0xe9},
	{0x85c2,0xe5},
	{0x85c3,0x78},
	{0x85c4,0xd3},
	{0x85c5,0x94},
	{0x85c6,0x03},
	{0x85c7,0x40},
	{0x85c8,0x04},
	{0x85c9,0x7f},
	{0x85ca,0x00},
	{0x85cb,0x80},
	{0x85cc,0x04},
	{0x85cd,0xe5},
	{0x85ce,0x78},
	{0x85cf,0x04},
	{0x85d0,0xff},
	{0x85d1,0x8f},
	{0x85d2,0x78},
	{0x85d3,0x30},
	{0x85d4,0x18},
	{0x85d5,0x06},
	{0x85d6,0x30},
	{0x85d7,0x19},
	{0x85d8,0x03},
	{0x85d9,0x12},
	{0x85da,0x06},
	{0x85db,0xfb},
	{0x85dc,0x30},
	{0x85dd,0x18},
	{0x85de,0x03},
	{0x85df,0x02},
	{0x85e0,0x06},
	{0x85e1,0xe9},
	{0x85e2,0x20},
	{0x85e3,0x19},
	{0x85e4,0x03},
	{0x85e5,0x02},
	{0x85e6,0x06},
	{0x85e7,0xe9},
	{0x85e8,0x75},
	{0x85e9,0x0a},
	{0x85ea,0x02},
	{0x85eb,0x02},
	{0x85ec,0x14},
	{0x85ed,0x78},
	{0x85ee,0xe5},
	{0x85ef,0x67},
	{0x85f0,0xd3},
	{0x85f1,0x94},
	{0x85f2,0x38},
	{0x85f3,0x40},
	{0x85f4,0x04},
	{0x85f5,0x7f},
	{0x85f6,0x34},
	{0x85f7,0x80},
	{0x85f8,0x02},
	{0x85f9,0xaf},
	{0x85fa,0x67},
	{0x85fb,0x8f},
	{0x85fc,0x67},
	{0x85fd,0xe5},
	{0x85fe,0x67},
	{0x85ff,0xc3},
	{0x8600,0x94},
	{0x8601,0x08},
	{0x8602,0x50},
	{0x8603,0x04},
	{0x8604,0x7f},
	{0x8605,0x08},
	{0x8606,0x80},
	{0x8607,0x02},
	{0x8608,0xaf},
	{0x8609,0x67},
	{0x860a,0x8f},
	{0x860b,0x67},
	{0x860c,0xe5},
	{0x860d,0x68},
	{0x860e,0xd3},
	{0x860f,0x94},
	{0x8610,0x2a},
	{0x8611,0x40},
	{0x8612,0x04},
	{0x8613,0x7f},
	{0x8614,0x2a},
	{0x8615,0x80},
	{0x8616,0x02},
	{0x8617,0xaf},
	{0x8618,0x68},
	{0x8619,0x8f},
	{0x861a,0x68},
	{0x861b,0xe5},
	{0x861c,0x68},
	{0x861d,0xc3},
	{0x861e,0x94},
	{0x861f,0x06},
	{0x8620,0x50},
	{0x8621,0x04},
	{0x8622,0x7f},
	{0x8623,0x06},
	{0x8624,0x80},
	{0x8625,0x02},
	{0x8626,0xaf},
	{0x8627,0x68},
	{0x8628,0x8f},
	{0x8629,0x68},
	{0x862a,0xaf},
	{0x862b,0x67},
	{0x862c,0xef},
	{0x862d,0x24},
	{0x862e,0xf8},
	{0x862f,0xff},
	{0x8630,0xe4},
	{0x8631,0x34},
	{0x8632,0xff},
	{0x8633,0xfe},
	{0x8634,0xe4},
	{0x8635,0x8f},
	{0x8636,0x3f},
	{0x8637,0x8e},
	{0x8638,0x3e},
	{0x8639,0xf5},
	{0x863a,0x3d},
	{0x863b,0xf5},
	{0x863c,0x3c},
	{0x863d,0xac},
	{0x863e,0x3c},
	{0x863f,0x12},
	{0x8640,0x01},
	{0x8641,0x90},
	{0x8642,0xaf},
	{0x8643,0x68},
	{0x8644,0xef},
	{0x8645,0x24},
	{0x8646,0xfa},
	{0x8647,0xff},
	{0x8648,0xe4},
	{0x8649,0x34},
	{0x864a,0xff},
	{0x864b,0x12},
	{0x864c,0x01},
	{0x864d,0x73},
	{0x864e,0xaf},
	{0x864f,0x67},
	{0x8650,0xef},
	{0x8651,0x24},
	{0x8652,0x08},
	{0x8653,0xff},
	{0x8654,0xe4},
	{0x8655,0x33},
	{0x8656,0x12},
	{0x8657,0x01},
	{0x8658,0x73},
	{0x8659,0xaf},
	{0x865a,0x68},
	{0x865b,0xef},
	{0x865c,0x24},
	{0x865d,0x06},
	{0x865e,0xff},
	{0x865f,0xe4},
	{0x8660,0x33},
	{0x8661,0xfe},
	{0x8662,0xe4},
	{0x8663,0xfc},
	{0x8664,0xfd},
	{0x8665,0xe5},
	{0x8666,0x3f},
	{0x8667,0x2f},
	{0x8668,0xf5},
	{0x8669,0x3f},
	{0x866a,0xe5},
	{0x866b,0x3e},
	{0x866c,0x3e},
	{0x866d,0xf5},
	{0x866e,0x3e},
	{0x866f,0xed},
	{0x8670,0x35},
	{0x8671,0x3d},
	{0x8672,0xf5},
	{0x8673,0x3d},
	{0x8674,0xec},
	{0x8675,0x35},
	{0x8676,0x3c},
	{0x8677,0xf5},
	{0x8678,0x3c},
	{0x8679,0xe4},
	{0x867a,0x25},
	{0x867b,0x3f},
	{0x867c,0xf5},
	{0x867d,0x37},
	{0x867e,0xe4},
	{0x867f,0x35},
	{0x8680,0x3e},
	{0x8681,0xf5},
	{0x8682,0x36},
	{0x8683,0xe4},
	{0x8684,0x35},
	{0x8685,0x3d},
	{0x8686,0xf5},
	{0x8687,0x35},
	{0x8688,0xe5},
	{0x8689,0x3c},
	{0x868a,0x34},
	{0x868b,0x08},
	{0x868c,0xf5},
	{0x868d,0x34},
	{0x868e,0xe4},
	{0x868f,0x25},
	{0x8690,0x3f},
	{0x8691,0xf5},
	{0x8692,0x3b},
	{0x8693,0xe4},
	{0x8694,0x35},
	{0x8695,0x3e},
	{0x8696,0xf5},
	{0x8697,0x3a},
	{0x8698,0xe5},
	{0x8699,0x3d},
	{0x869a,0x34},
	{0x869b,0x06},
	{0x869c,0xf5},
	{0x869d,0x39},
	{0x869e,0xe4},
	{0x869f,0x35},
	{0x86a0,0x3c},
	{0x86a1,0xf5},
	{0x86a2,0x38},
	{0x86a3,0xe5},
	{0x86a4,0x3f},
	{0x86a5,0x24},
	{0x86a6,0xfa},
	{0x86a7,0xf5},
	{0x86a8,0x43},
	{0x86a9,0xe5},
	{0x86aa,0x3e},
	{0x86ab,0x34},
	{0x86ac,0xff},
	{0x86ad,0xf5},
	{0x86ae,0x42},
	{0x86af,0xe5},
	{0x86b0,0x3d},
	{0x86b1,0x34},
	{0x86b2,0xff},
	{0x86b3,0xf5},
	{0x86b4,0x41},
	{0x86b5,0xe5},
	{0x86b6,0x3c},
	{0x86b7,0x34},
	{0x86b8,0xff},
	{0x86b9,0xf5},
	{0x86ba,0x40},
	{0x86bb,0xe4},
	{0x86bc,0x25},
	{0x86bd,0x3f},
	{0x86be,0xf5},
	{0x86bf,0x47},
	{0x86c0,0xe5},
	{0x86c1,0x3e},
	{0x86c2,0x34},
	{0x86c3,0xf8},
	{0x86c4,0xf5},
	{0x86c5,0x46},
	{0x86c6,0xe5},
	{0x86c7,0x3d},
	{0x86c8,0x34},
	{0x86c9,0xff},
	{0x86ca,0xf5},
	{0x86cb,0x45},
	{0x86cc,0xe5},
	{0x86cd,0x3c},
	{0x86ce,0x34},
	{0x86cf,0xff},
	{0x86d0,0xf5},
	{0x86d1,0x44},
	{0x86d2,0x75},
	{0x86d3,0x78},
	{0x86d4,0x02},
	{0x86d5,0x75},
	{0x86d6,0x0a},
	{0x86d7,0x01},
	{0x86d8,0x12},
	{0x86d9,0x14},
	{0x86da,0x78},
	{0x86db,0xd2},
	{0x86dc,0x18},
	{0x86dd,0xd2},
	{0x86de,0x19},
	{0x86df,0xc2},
	{0x86e0,0x3c},
	{0x86e1,0xc2},
	{0x86e2,0x3b},
	{0x86e3,0xd2},
	{0x86e4,0x1a},
	{0x86e5,0xd2},
	{0x86e6,0x38},
	{0x86e7,0xd2},
	{0x86e8,0x30},
	{0x86e9,0x22},
	{0x86ea,0x12},
	{0x86eb,0x12},
	{0x86ec,0x48},
	{0x86ed,0x75},
	{0x86ee,0x78},
	{0x86ef,0x02},
	{0x86f0,0xe4},
	{0x86f1,0xf5},
	{0x86f2,0x0a},
	{0x86f3,0x12},
	{0x86f4,0x14},
	{0x86f5,0x78},
	{0x86f6,0xd2},
	{0x86f7,0x18},
	{0x86f8,0xc2},
	{0x86f9,0x19},
	{0x86fa,0x22},
	{0x86fb,0x75},
	{0x86fc,0x0a},
	{0x86fd,0x01},
	{0x86fe,0x12},
	{0x86ff,0x14},
	{0x8700,0x78},
	{0x8701,0x22},
	{0x8702,0x90},
	{0x8703,0x38},
	{0x8704,0x04},
	{0x8705,0xe0},
	{0x8706,0xfe},
	{0x8707,0xa3},
	{0x8708,0xe0},
	{0x8709,0xfd},
	{0x870a,0xed},
	{0x870b,0xff},
	{0x870c,0xee},
	{0x870d,0x54},
	{0x870e,0x0f},
	{0x870f,0xf5},
	{0x8710,0x0e},
	{0x8711,0x8f},
	{0x8712,0x0f},
	{0x8713,0xa3},
	{0x8714,0xe0},
	{0x8715,0xfe},
	{0x8716,0xa3},
	{0x8717,0xe0},
	{0x8718,0xfd},
	{0x8719,0xed},
	{0x871a,0xff},
	{0x871b,0xee},
	{0x871c,0x54},
	{0x871d,0x07},
	{0x871e,0xf5},
	{0x871f,0x10},
	{0x8720,0x8f},
	{0x8721,0x11},
	{0x8722,0xe5},
	{0x8723,0x0e},
	{0x8724,0xc4},
	{0x8725,0xf8},
	{0x8726,0x54},
	{0x8727,0xf0},
	{0x8728,0xc8},
	{0x8729,0x68},
	{0x872a,0xf5},
	{0x872b,0x0e},
	{0x872c,0xe5},
	{0x872d,0x0f},
	{0x872e,0xc4},
	{0x872f,0x54},
	{0x8730,0x0f},
	{0x8731,0x48},
	{0x8732,0xf5},
	{0x8733,0x0f},
	{0x8734,0xe5},
	{0x8735,0x10},
	{0x8736,0xc4},
	{0x8737,0xf8},
	{0x8738,0x54},
	{0x8739,0xf0},
	{0x873a,0xc8},
	{0x873b,0x68},
	{0x873c,0xf5},
	{0x873d,0x10},
	{0x873e,0xe5},
	{0x873f,0x11},
	{0x8740,0xc4},
	{0x8741,0x54},
	{0x8742,0x0f},
	{0x8743,0x48},
	{0x8744,0xf5},
	{0x8745,0x11},
	{0x8746,0xe4},
	{0x8747,0xf5},
	{0x8748,0x17},
	{0x8749,0x75},
	{0x874a,0x16},
	{0x874b,0x04},
	{0x874c,0x12},
	{0x874d,0x02},
	{0x874e,0x66},
	{0x874f,0x24},
	{0x8750,0x34},
	{0x8751,0xf8},
	{0x8752,0xe6},
	{0x8753,0xf5},
	{0x8754,0x12},
	{0x8755,0x12},
	{0x8756,0x02},
	{0x8757,0x66},
	{0x8758,0x24},
	{0x8759,0x35},
	{0x875a,0xf8},
	{0x875b,0xe6},
	{0x875c,0xf5},
	{0x875d,0x14},
	{0x875e,0x12},
	{0x875f,0x02},
	{0x8760,0x66},
	{0x8761,0x24},
	{0x8762,0x36},
	{0x8763,0xf8},
	{0x8764,0xe6},
	{0x8765,0xf5},
	{0x8766,0x13},
	{0x8767,0x12},
	{0x8768,0x02},
	{0x8769,0x66},
	{0x876a,0x24},
	{0x876b,0x37},
	{0x876c,0xf8},
	{0x876d,0xe6},
	{0x876e,0xf5},
	{0x876f,0x15},
	{0x8770,0x12},
	{0x8771,0x02},
	{0x8772,0x79},
	{0x8773,0xaf},
	{0x8774,0x12},
	{0x8775,0x12},
	{0x8776,0x01},
	{0x8777,0x42},
	{0x8778,0x8f},
	{0x8779,0x12},
	{0x877a,0x12},
	{0x877b,0x02},
	{0x877c,0x79},
	{0x877d,0xaf},
	{0x877e,0x13},
	{0x877f,0x12},
	{0x8780,0x01},
	{0x8781,0x42},
	{0x8782,0x8f},
	{0x8783,0x13},
	{0x8784,0x12},
	{0x8785,0x02},
	{0x8786,0x11},
	{0x8787,0xaf},
	{0x8788,0x14},
	{0x8789,0xfc},
	{0x878a,0xfd},
	{0x878b,0xfe},
	{0x878c,0x12},
	{0x878d,0x08},
	{0x878e,0xa2},
	{0x878f,0x12},
	{0x8790,0x01},
	{0x8791,0x61},
	{0x8792,0x7b},
	{0x8793,0x30},
	{0x8794,0x12},
	{0x8795,0x01},
	{0x8796,0x5a},
	{0x8797,0x8f},
	{0x8798,0x14},
	{0x8799,0x12},
	{0x879a,0x02},
	{0x879b,0x11},
	{0x879c,0xaf},
	{0x879d,0x15},
	{0x879e,0xfc},
	{0x879f,0xfd},
	{0x87a0,0xfe},
	{0x87a1,0x12},
	{0x87a2,0x08},
	{0x87a3,0xa2},
	{0x87a4,0x12},
	{0x87a5,0x01},
	{0x87a6,0x61},
	{0x87a7,0xe4},
	{0x87a8,0x7b},
	{0x87a9,0x30},
	{0x87aa,0x12},
	{0x87ab,0x01},
	{0x87ac,0x5b},
	{0x87ad,0x8f},
	{0x87ae,0x15},
	{0x87af,0xc3},
	{0x87b0,0xe5},
	{0x87b1,0x13},
	{0x87b2,0x95},
	{0x87b3,0x12},
	{0x87b4,0xff},
	{0x87b5,0x0f},
	{0x87b6,0xef},
	{0x87b7,0xc3},
	{0x87b8,0x13},
	{0x87b9,0xff},
	{0x87ba,0xc3},
	{0x87bb,0x94},
	{0x87bc,0x04},
	{0x87bd,0x50},
	{0x87be,0x27},
	{0x87bf,0xe5},
	{0x87c0,0x12},
	{0x87c1,0x9f},
	{0x87c2,0x40},
	{0x87c3,0x06},
	{0x87c4,0xe5},
	{0x87c5,0x12},
	{0x87c6,0x9f},
	{0x87c7,0xfe},
	{0x87c8,0x80},
	{0x87c9,0x02},
	{0x87ca,0x7e},
	{0x87cb,0x00},
	{0x87cc,0x8e},
	{0x87cd,0x12},
	{0x87ce,0xef},
	{0x87cf,0xfd},
	{0x87d0,0xe5},
	{0x87d1,0x13},
	{0x87d2,0x2d},
	{0x87d3,0xfd},
	{0x87d4,0xe4},
	{0x87d5,0x33},
	{0x87d6,0xfc},
	{0x87d7,0xc3},
	{0x87d8,0xed},
	{0x87d9,0x95},
	{0x87da,0x0f},
	{0x87db,0xec},
	{0x87dc,0x95},
	{0x87dd,0x0e},
	{0x87de,0x50},
	{0x87df,0x02},
	{0x87e0,0x80},
	{0x87e1,0x02},
	{0x87e2,0xad},
	{0x87e3,0x0f},
	{0x87e4,0x8d},
	{0x87e5,0x13},
	{0x87e6,0xc3},
	{0x87e7,0xe5},
	{0x87e8,0x15},
	{0x87e9,0x95},
	{0x87ea,0x14},
	{0x87eb,0xff},
	{0x87ec,0xc3},
	{0x87ed,0x94},
	{0x87ee,0x04},
	{0x87ef,0x50},
	{0x87f0,0x29},
	{0x87f1,0xe5},
	{0x87f2,0x14},
	{0x87f3,0x9f},
	{0x87f4,0x40},
	{0x87f5,0x06},
	{0x87f6,0xe5},
	{0x87f7,0x14},
	{0x87f8,0x9f},
	{0x87f9,0xfe},
	{0x87fa,0x80},
	{0x87fb,0x02},
	{0x87fc,0x7e},
	{0x87fd,0x00},
	{0x87fe,0x8e},
	{0x87ff,0x14},
	{0x8800,0xef},
	{0x8801,0xfd},
	{0x8802,0xe5},
	{0x8803,0x15},
	{0x8804,0x2d},
	{0x8805,0xfd},
	{0x8806,0xe4},
	{0x8807,0x33},
	{0x8808,0xfc},
	{0x8809,0xc3},
	{0x880a,0xed},
	{0x880b,0x95},
	{0x880c,0x11},
	{0x880d,0xec},
	{0x880e,0x95},
	{0x880f,0x10},
	{0x8810,0x50},
	{0x8811,0x04},
	{0x8812,0xaf},
	{0x8813,0x05},
	{0x8814,0x80},
	{0x8815,0x02},
	{0x8816,0xaf},
	{0x8817,0x11},
	{0x8818,0x8f},
	{0x8819,0x15},
	{0x881a,0xe5},
	{0x881b,0x15},
	{0x881c,0xd3},
	{0x881d,0x95},
	{0x881e,0x17},
	{0x881f,0x40},
	{0x8820,0x04},
	{0x8821,0xaf},
	{0x8822,0x15},
	{0x8823,0x80},
	{0x8824,0x02},
	{0x8825,0xaf},
	{0x8826,0x17},
	{0x8827,0x8f},
	{0x8828,0x17},
	{0x8829,0xd3},
	{0x882a,0xe5},
	{0x882b,0x16},
	{0x882c,0x64},
	{0x882d,0x80},
	{0x882e,0x94},
	{0x882f,0x80},
	{0x8830,0x40},
	{0x8831,0x04},
	{0x8832,0xaf},
	{0x8833,0x15},
	{0x8834,0x80},
	{0x8835,0x02},
	{0x8836,0xaf},
	{0x8837,0x17},
	{0x8838,0x8f},
	{0x8839,0x15},
	{0x883a,0xe5},
	{0x883b,0x16},
	{0x883c,0xfd},
	{0x883d,0x33},
	{0x883e,0x95},
	{0x883f,0xe0},
	{0x8840,0xfc},
	{0x8841,0xed},
	{0x8842,0xae},
	{0x8843,0x04},
	{0x8844,0x78},
	{0x8845,0x02},
	{0x8846,0xc3},
	{0x8847,0x33},
	{0x8848,0xce},
	{0x8849,0x33},
	{0x884a,0xce},
	{0x884b,0xd8},
	{0x884c,0xf9},
	{0x884d,0xff},
	{0x884e,0x24},
	{0x884f,0x01},
	{0x8850,0xfb},
	{0x8851,0xee},
	{0x8852,0x34},
	{0x8853,0x60},
	{0x8854,0x8b},
	{0x8855,0x82},
	{0x8856,0xf5},
	{0x8857,0x83},
	{0x8858,0xe5},
	{0x8859,0x12},
	{0x885a,0xf0},
	{0x885b,0xef},
	{0x885c,0x24},
	{0x885d,0x02},
	{0x885e,0xff},
	{0x885f,0xee},
	{0x8860,0x34},
	{0x8861,0x60},
	{0x8862,0x8f},
	{0x8863,0x82},
	{0x8864,0xf5},
	{0x8865,0x83},
	{0x8866,0xe5},
	{0x8867,0x14},
	{0x8868,0xf0},
	{0x8869,0xed},
	{0x886a,0xae},
	{0x886b,0x04},
	{0x886c,0x78},
	{0x886d,0x02},
	{0x886e,0xc3},
	{0x886f,0x33},
	{0x8870,0xce},
	{0x8871,0x33},
	{0x8872,0xce},
	{0x8873,0xd8},
	{0x8874,0xf9},
	{0x8875,0xff},
	{0x8876,0x24},
	{0x8877,0x03},
	{0x8878,0xfd},
	{0x8879,0xee},
	{0x887a,0x34},
	{0x887b,0x60},
	{0x887c,0x8d},
	{0x887d,0x82},
	{0x887e,0xf5},
	{0x887f,0x83},
	{0x8880,0xe5},
	{0x8881,0x13},
	{0x8882,0xf0},
	{0x8883,0xef},
	{0x8884,0x24},
	{0x8885,0x04},
	{0x8886,0xff},
	{0x8887,0xee},
	{0x8888,0x34},
	{0x8889,0x60},
	{0x888a,0x8f},
	{0x888b,0x82},
	{0x888c,0xf5},
	{0x888d,0x83},
	{0x888e,0xe5},
	{0x888f,0x15},
	{0x8890,0xf0},
	{0x8891,0x15},
	{0x8892,0x16},
	{0x8893,0xc3},
	{0x8894,0xe5},
	{0x8895,0x16},
	{0x8896,0x64},
	{0x8897,0x80},
	{0x8898,0x94},
	{0x8899,0x80},
	{0x889a,0x40},
	{0x889b,0x03},
	{0x889c,0x02},
	{0x889d,0x07},
	{0x889e,0x4c},
	{0x889f,0xc2},
	{0x88a0,0x30},
	{0x88a1,0x22},
	{0x88a2,0xe8},
	{0x88a3,0x8f},
	{0x88a4,0xf0},
	{0x88a5,0xa4},
	{0x88a6,0xcc},
	{0x88a7,0x8b},
	{0x88a8,0xf0},
	{0x88a9,0xa4},
	{0x88aa,0x2c},
	{0x88ab,0xfc},
	{0x88ac,0xe9},
	{0x88ad,0x8e},
	{0x88ae,0xf0},
	{0x88af,0xa4},
	{0x88b0,0x2c},
	{0x88b1,0xfc},
	{0x88b2,0x8a},
	{0x88b3,0xf0},
	{0x88b4,0xed},
	{0x88b5,0xa4},
	{0x88b6,0x2c},
	{0x88b7,0xfc},
	{0x88b8,0xea},
	{0x88b9,0x8e},
	{0x88ba,0xf0},
	{0x88bb,0xa4},
	{0x88bc,0xcd},
	{0x88bd,0xa8},
	{0x88be,0xf0},
	{0x88bf,0x8b},
	{0x88c0,0xf0},
	{0x88c1,0xa4},
	{0x88c2,0x2d},
	{0x88c3,0xcc},
	{0x88c4,0x38},
	{0x88c5,0x25},
	{0x88c6,0xf0},
	{0x88c7,0xfd},
	{0x88c8,0xe9},
	{0x88c9,0x8f},
	{0x88ca,0xf0},
	{0x88cb,0xa4},
	{0x88cc,0x2c},
	{0x88cd,0xcd},
	{0x88ce,0x35},
	{0x88cf,0xf0},
	{0x88d0,0xfc},
	{0x88d1,0xeb},
	{0x88d2,0x8e},
	{0x88d3,0xf0},
	{0x88d4,0xa4},
	{0x88d5,0xfe},
	{0x88d6,0xa9},
	{0x88d7,0xf0},
	{0x88d8,0xeb},
	{0x88d9,0x8f},
	{0x88da,0xf0},
	{0x88db,0xa4},
	{0x88dc,0xcf},
	{0x88dd,0xc5},
	{0x88de,0xf0},
	{0x88df,0x2e},
	{0x88e0,0xcd},
	{0x88e1,0x39},
	{0x88e2,0xfe},
	{0x88e3,0xe4},
	{0x88e4,0x3c},
	{0x88e5,0xfc},
	{0x88e6,0xea},
	{0x88e7,0xa4},
	{0x88e8,0x2d},
	{0x88e9,0xce},
	{0x88ea,0x35},
	{0x88eb,0xf0},
	{0x88ec,0xfd},
	{0x88ed,0xe4},
	{0x88ee,0x3c},
	{0x88ef,0xfc},
	{0x88f0,0x22},
	{0x88f1,0x75},
	{0x88f2,0xf0},
	{0x88f3,0x08},
	{0x88f4,0x75},
	{0x88f5,0x82},
	{0x88f6,0x00},
	{0x88f7,0xef},
	{0x88f8,0x2f},
	{0x88f9,0xff},
	{0x88fa,0xee},
	{0x88fb,0x33},
	{0x88fc,0xfe},
	{0x88fd,0xcd},
	{0x88fe,0x33},
	{0x88ff,0xcd},
	{0x8900,0xcc},
	{0x8901,0x33},
	{0x8902,0xcc},
	{0x8903,0xc5},
	{0x8904,0x82},
	{0x8905,0x33},
	{0x8906,0xc5},
	{0x8907,0x82},
	{0x8908,0x9b},
	{0x8909,0xed},
	{0x890a,0x9a},
	{0x890b,0xec},
	{0x890c,0x99},
	{0x890d,0xe5},
	{0x890e,0x82},
	{0x890f,0x98},
	{0x8910,0x40},
	{0x8911,0x0c},
	{0x8912,0xf5},
	{0x8913,0x82},
	{0x8914,0xee},
	{0x8915,0x9b},
	{0x8916,0xfe},
	{0x8917,0xed},
	{0x8918,0x9a},
	{0x8919,0xfd},
	{0x891a,0xec},
	{0x891b,0x99},
	{0x891c,0xfc},
	{0x891d,0x0f},
	{0x891e,0xd5},
	{0x891f,0xf0},
	{0x8920,0xd6},
	{0x8921,0xe4},
	{0x8922,0xce},
	{0x8923,0xfb},
	{0x8924,0xe4},
	{0x8925,0xcd},
	{0x8926,0xfa},
	{0x8927,0xe4},
	{0x8928,0xcc},
	{0x8929,0xf9},
	{0x892a,0xa8},
	{0x892b,0x82},
	{0x892c,0x22},
	{0x892d,0xb8},
	{0x892e,0x00},
	{0x892f,0xc1},
	{0x8930,0xb9},
	{0x8931,0x00},
	{0x8932,0x59},
	{0x8933,0xba},
	{0x8934,0x00},
	{0x8935,0x2d},
	{0x8936,0xec},
	{0x8937,0x8b},
	{0x8938,0xf0},
	{0x8939,0x84},
	{0x893a,0xcf},
	{0x893b,0xce},
	{0x893c,0xcd},
	{0x893d,0xfc},
	{0x893e,0xe5},
	{0x893f,0xf0},
	{0x8940,0xcb},
	{0x8941,0xf9},
	{0x8942,0x78},
	{0x8943,0x18},
	{0x8944,0xef},
	{0x8945,0x2f},
	{0x8946,0xff},
	{0x8947,0xee},
	{0x8948,0x33},
	{0x8949,0xfe},
	{0x894a,0xed},
	{0x894b,0x33},
	{0x894c,0xfd},
	{0x894d,0xec},
	{0x894e,0x33},
	{0x894f,0xfc},
	{0x8950,0xeb},
	{0x8951,0x33},
	{0x8952,0xfb},
	{0x8953,0x10},
	{0x8954,0xd7},
	{0x8955,0x03},
	{0x8956,0x99},
	{0x8957,0x40},
	{0x8958,0x04},
	{0x8959,0xeb},
	{0x895a,0x99},
	{0x895b,0xfb},
	{0x895c,0x0f},
	{0x895d,0xd8},
	{0x895e,0xe5},
	{0x895f,0xe4},
	{0x8960,0xf9},
	{0x8961,0xfa},
	{0x8962,0x22},
	{0x8963,0x78},
	{0x8964,0x18},
	{0x8965,0xef},
	{0x8966,0x2f},
	{0x8967,0xff},
	{0x8968,0xee},
	{0x8969,0x33},
	{0x896a,0xfe},
	{0x896b,0xed},
	{0x896c,0x33},
	{0x896d,0xfd},
	{0x896e,0xec},
	{0x896f,0x33},
	{0x8970,0xfc},
	{0x8971,0xc9},
	{0x8972,0x33},
	{0x8973,0xc9},
	{0x8974,0x10},
	{0x8975,0xd7},
	{0x8976,0x05},
	{0x8977,0x9b},
	{0x8978,0xe9},
	{0x8979,0x9a},
	{0x897a,0x40},
	{0x897b,0x07},
	{0x897c,0xec},
	{0x897d,0x9b},
	{0x897e,0xfc},
	{0x897f,0xe9},
	{0x8980,0x9a},
	{0x8981,0xf9},
	{0x8982,0x0f},
	{0x8983,0xd8},
	{0x8984,0xe0},
	{0x8985,0xe4},
	{0x8986,0xc9},
	{0x8987,0xfa},
	{0x8988,0xe4},
	{0x8989,0xcc},
	{0x898a,0xfb},
	{0x898b,0x22},
	{0x898c,0x75},
	{0x898d,0xf0},
	{0x898e,0x10},
	{0x898f,0xef},
	{0x8990,0x2f},
	{0x8991,0xff},
	{0x8992,0xee},
	{0x8993,0x33},
	{0x8994,0xfe},
	{0x8995,0xed},
	{0x8996,0x33},
	{0x8997,0xfd},
	{0x8998,0xcc},
	{0x8999,0x33},
	{0x899a,0xcc},
	{0x899b,0xc8},
	{0x899c,0x33},
	{0x899d,0xc8},
	{0x899e,0x10},
	{0x899f,0xd7},
	{0x89a0,0x07},
	{0x89a1,0x9b},
	{0x89a2,0xec},
	{0x89a3,0x9a},
	{0x89a4,0xe8},
	{0x89a5,0x99},
	{0x89a6,0x40},
	{0x89a7,0x0a},
	{0x89a8,0xed},
	{0x89a9,0x9b},
	{0x89aa,0xfd},
	{0x89ab,0xec},
	{0x89ac,0x9a},
	{0x89ad,0xfc},
	{0x89ae,0xe8},
	{0x89af,0x99},
	{0x89b0,0xf8},
	{0x89b1,0x0f},
	{0x89b2,0xd5},
	{0x89b3,0xf0},
	{0x89b4,0xda},
	{0x89b5,0xe4},
	{0x89b6,0xcd},
	{0x89b7,0xfb},
	{0x89b8,0xe4},
	{0x89b9,0xcc},
	{0x89ba,0xfa},
	{0x89bb,0xe4},
	{0x89bc,0xc8},
	{0x89bd,0xf9},
	{0x89be,0x22},
	{0x89bf,0xe8},
	{0x89c0,0x60},
	{0x89c1,0x0f},
	{0x89c2,0xec},
	{0x89c3,0xc3},
	{0x89c4,0x13},
	{0x89c5,0xfc},
	{0x89c6,0xed},
	{0x89c7,0x13},
	{0x89c8,0xfd},
	{0x89c9,0xee},
	{0x89ca,0x13},
	{0x89cb,0xfe},
	{0x89cc,0xef},
	{0x89cd,0x13},
	{0x89ce,0xff},
	{0x89cf,0xd8},
	{0x89d0,0xf1},
	{0x89d1,0x22},
	{0x89d2,0xe8},
	{0x89d3,0x60},
	{0x89d4,0x0f},
	{0x89d5,0xef},
	{0x89d6,0xc3},
	{0x89d7,0x33},
	{0x89d8,0xff},
	{0x89d9,0xee},
	{0x89da,0x33},
	{0x89db,0xfe},
	{0x89dc,0xed},
	{0x89dd,0x33},
	{0x89de,0xfd},
	{0x89df,0xec},
	{0x89e0,0x33},
	{0x89e1,0xfc},
	{0x89e2,0xd8},
	{0x89e3,0xf1},
	{0x89e4,0x22},
	{0x89e5,0xe4},
	{0x89e6,0x93},
	{0x89e7,0xfc},
	{0x89e8,0x74},
	{0x89e9,0x01},
	{0x89ea,0x93},
	{0x89eb,0xfd},
	{0x89ec,0x74},
	{0x89ed,0x02},
	{0x89ee,0x93},
	{0x89ef,0xfe},
	{0x89f0,0x74},
	{0x89f1,0x03},
	{0x89f2,0x93},
	{0x89f3,0xff},
	{0x89f4,0x22},
	{0x89f5,0xd0},
	{0x89f6,0x83},
	{0x89f7,0xd0},
	{0x89f8,0x82},
	{0x89f9,0xf8},
	{0x89fa,0xe4},
	{0x89fb,0x93},
	{0x89fc,0x70},
	{0x89fd,0x12},
	{0x89fe,0x74},
	{0x89ff,0x01},
	{0x8a00,0x93},
	{0x8a01,0x70},
	{0x8a02,0x0d},
	{0x8a03,0xa3},
	{0x8a04,0xa3},
	{0x8a05,0x93},
	{0x8a06,0xf8},
	{0x8a07,0x74},
	{0x8a08,0x01},
	{0x8a09,0x93},
	{0x8a0a,0xf5},
	{0x8a0b,0x82},
	{0x8a0c,0x88},
	{0x8a0d,0x83},
	{0x8a0e,0xe4},
	{0x8a0f,0x73},
	{0x8a10,0x74},
	{0x8a11,0x02},
	{0x8a12,0x93},
	{0x8a13,0x68},
	{0x8a14,0x60},
	{0x8a15,0xef},
	{0x8a16,0xa3},
	{0x8a17,0xa3},
	{0x8a18,0xa3},
	{0x8a19,0x80},
	{0x8a1a,0xdf},
	{0x8a1b,0x75},
	{0x8a1c,0x12},
	{0x8a1d,0x0a},
	{0x8a1e,0xa2},
	{0x8a1f,0xaf},
	{0x8a20,0x92},
	{0x8a21,0x32},
	{0x8a22,0xc2},
	{0x8a23,0xaf},
	{0x8a24,0xc2},
	{0x8a25,0x33},
	{0x8a26,0x12},
	{0x8a27,0x01},
	{0x8a28,0x6a},
	{0x8a29,0x12},
	{0x8a2a,0x02},
	{0x8a2b,0x08},
	{0x8a2c,0x12},
	{0x8a2d,0x01},
	{0x8a2e,0x6a},
	{0x8a2f,0x75},
	{0x8a30,0x51},
	{0x8a31,0x05},
	{0x8a32,0xaf},
	{0x8a33,0x51},
	{0x8a34,0x15},
	{0x8a35,0x51},
	{0x8a36,0xef},
	{0x8a37,0x70},
	{0x8a38,0xf9},
	{0x8a39,0xd2},
	{0x8a3a,0x28},
	{0x8a3b,0x12},
	{0x8a3c,0x01},
	{0x8a3d,0x6c},
	{0x8a3e,0x75},
	{0x8a3f,0x51},
	{0x8a40,0x0a},
	{0x8a41,0xaf},
	{0x8a42,0x51},
	{0x8a43,0x15},
	{0x8a44,0x51},
	{0x8a45,0xef},
	{0x8a46,0x70},
	{0x8a47,0xf9},
	{0x8a48,0xc2},
	{0x8a49,0x29},
	{0x8a4a,0x12},
	{0x8a4b,0x01},
	{0x8a4c,0x6c},
	{0x8a4d,0x75},
	{0x8a4e,0x51},
	{0x8a4f,0x05},
	{0x8a50,0xaf},
	{0x8a51,0x51},
	{0x8a52,0x15},
	{0x8a53,0x51},
	{0x8a54,0xef},
	{0x8a55,0x70},
	{0x8a56,0xf9},
	{0x8a57,0xc2},
	{0x8a58,0x28},
	{0x8a59,0x12},
	{0x8a5a,0x01},
	{0x8a5b,0x6c},
	{0x8a5c,0x75},
	{0x8a5d,0x51},
	{0x8a5e,0x05},
	{0x8a5f,0xaf},
	{0x8a60,0x51},
	{0x8a61,0x15},
	{0x8a62,0x51},
	{0x8a63,0xef},
	{0x8a64,0x70},
	{0x8a65,0xf9},
	{0x8a66,0x75},
	{0x8a67,0x13},
	{0x8a68,0x18},
	{0x8a69,0x12},
	{0x8a6a,0x0b},
	{0x8a6b,0x5b},
	{0x8a6c,0x75},
	{0x8a6d,0x51},
	{0x8a6e,0x0a},
	{0x8a6f,0xaf},
	{0x8a70,0x51},
	{0x8a71,0x15},
	{0x8a72,0x51},
	{0x8a73,0xef},
	{0x8a74,0x70},
	{0x8a75,0xf9},
	{0x8a76,0xd2},
	{0x8a77,0x28},
	{0x8a78,0x12},
	{0x8a79,0x01},
	{0x8a7a,0x6c},
	{0x8a7b,0x12},
	{0x8a7c,0x02},
	{0x8a7d,0x25},
	{0x8a7e,0xaf},
	{0x8a7f,0x51},
	{0x8a80,0x15},
	{0x8a81,0x51},
	{0x8a82,0xef},
	{0x8a83,0x70},
	{0x8a84,0xf9},
	{0x8a85,0xc2},
	{0x8a86,0x28},
	{0x8a87,0x12},
	{0x8a88,0x01},
	{0x8a89,0x6c},
	{0x8a8a,0x75},
	{0x8a8b,0x51},
	{0x8a8c,0x0a},
	{0x8a8d,0xaf},
	{0x8a8e,0x51},
	{0x8a8f,0x15},
	{0x8a90,0x51},
	{0x8a91,0xef},
	{0x8a92,0x70},
	{0x8a93,0xf9},
	{0x8a94,0x30},
	{0x8a95,0x11},
	{0x8a96,0x03},
	{0x8a97,0x02},
	{0x8a98,0x0b},
	{0x8a99,0x12},
	{0x8a9a,0x12},
	{0x8a9b,0x01},
	{0x8a9c,0x6a},
	{0x8a9d,0x12},
	{0x8a9e,0x02},
	{0x8a9f,0x08},
	{0x8aa0,0xe5},
	{0x8aa1,0x10},
	{0x8aa2,0xf5},
	{0x8aa3,0x13},
	{0x8aa4,0x12},
	{0x8aa5,0x0b},
	{0x8aa6,0x5b},
	{0x8aa7,0x75},
	{0x8aa8,0x51},
	{0x8aa9,0x0a},
	{0x8aaa,0xaf},
	{0x8aab,0x51},
	{0x8aac,0x15},
	{0x8aad,0x51},
	{0x8aae,0xef},
	{0x8aaf,0x70},
	{0x8ab0,0xf9},
	{0x8ab1,0xd2},
	{0x8ab2,0x28},
	{0x8ab3,0x12},
	{0x8ab4,0x01},
	{0x8ab5,0x6c},
	{0x8ab6,0x12},
	{0x8ab7,0x02},
	{0x8ab8,0x25},
	{0x8ab9,0xaf},
	{0x8aba,0x51},
	{0x8abb,0x15},
	{0x8abc,0x51},
	{0x8abd,0xef},
	{0x8abe,0x70},
	{0x8abf,0xf9},
	{0x8ac0,0xc2},
	{0x8ac1,0x28},
	{0x8ac2,0x12},
	{0x8ac3,0x01},
	{0x8ac4,0x6c},
	{0x8ac5,0x75},
	{0x8ac6,0x51},
	{0x8ac7,0x0a},
	{0x8ac8,0xaf},
	{0x8ac9,0x51},
	{0x8aca,0x15},
	{0x8acb,0x51},
	{0x8acc,0xef},
	{0x8acd,0x70},
	{0x8ace,0xf9},
	{0x8acf,0x30},
	{0x8ad0,0x11},
	{0x8ad1,0x04},
	{0x8ad2,0x15},
	{0x8ad3,0x12},
	{0x8ad4,0x80},
	{0x8ad5,0x45},
	{0x8ad6,0x12},
	{0x8ad7,0x01},
	{0x8ad8,0x6a},
	{0x8ad9,0x12},
	{0x8ada,0x02},
	{0x8adb,0x08},
	{0x8adc,0x85},
	{0x8add,0x11},
	{0x8ade,0x13},
	{0x8adf,0x12},
	{0x8ae0,0x15},
	{0x8ae1,0xa4},
	{0x8ae2,0xc2},
	{0x8ae3,0x09},
	{0x8ae4,0x12},
	{0x8ae5,0x02},
	{0x8ae6,0x0a},
	{0x8ae7,0x75},
	{0x8ae8,0x51},
	{0x8ae9,0x0a},
	{0x8aea,0xaf},
	{0x8aeb,0x51},
	{0x8aec,0x15},
	{0x8aed,0x51},
	{0x8aee,0xef},
	{0x8aef,0x70},
	{0x8af0,0xf9},
	{0x8af1,0xd2},
	{0x8af2,0x28},
	{0x8af3,0x12},
	{0x8af4,0x01},
	{0x8af5,0x6c},
	{0x8af6,0x12},
	{0x8af7,0x02},
	{0x8af8,0x25},
	{0x8af9,0xaf},
	{0x8afa,0x51},
	{0x8afb,0x15},
	{0x8afc,0x51},
	{0x8afd,0xef},
	{0x8afe,0x70},
	{0x8aff,0xf9},
	{0x8b00,0xc2},
	{0x8b01,0x28},
	{0x8b02,0x12},
	{0x8b03,0x01},
	{0x8b04,0x6c},
	{0x8b05,0x75},
	{0x8b06,0x51},
	{0x8b07,0x0a},
	{0x8b08,0xaf},
	{0x8b09,0x51},
	{0x8b0a,0x15},
	{0x8b0b,0x51},
	{0x8b0c,0xef},
	{0x8b0d,0x70},
	{0x8b0e,0xf9},
	{0x8b0f,0x30},
	{0x8b10,0x11},
	{0x8b11,0x06},
	{0x8b12,0x15},
	{0x8b13,0x12},
	{0x8b14,0xd2},
	{0x8b15,0x33},
	{0x8b16,0x80},
	{0x8b17,0x03},
	{0x8b18,0xe4},
	{0x8b19,0xf5},
	{0x8b1a,0x12},
	{0x8b1b,0x12},
	{0x8b1c,0x01},
	{0x8b1d,0x6a},
	{0x8b1e,0x12},
	{0x8b1f,0x02},
	{0x8b20,0x08},
	{0x8b21,0xc2},
	{0x8b22,0x29},
	{0x8b23,0x12},
	{0x8b24,0x01},
	{0x8b25,0x6c},
	{0x8b26,0x75},
	{0x8b27,0x51},
	{0x8b28,0x05},
	{0x8b29,0xaf},
	{0x8b2a,0x51},
	{0x8b2b,0x15},
	{0x8b2c,0x51},
	{0x8b2d,0xef},
	{0x8b2e,0x70},
	{0x8b2f,0xf9},
	{0x8b30,0xd2},
	{0x8b31,0x28},
	{0x8b32,0x12},
	{0x8b33,0x01},
	{0x8b34,0x6c},
	{0x8b35,0x75},
	{0x8b36,0x51},
	{0x8b37,0x05},
	{0x8b38,0xaf},
	{0x8b39,0x51},
	{0x8b3a,0x15},
	{0x8b3b,0x51},
	{0x8b3c,0xef},
	{0x8b3d,0x70},
	{0x8b3e,0xf9},
	{0x8b3f,0x12},
	{0x8b40,0x01},
	{0x8b41,0x6a},
	{0x8b42,0x75},
	{0x8b43,0x51},
	{0x8b44,0x05},
	{0x8b45,0xaf},
	{0x8b46,0x51},
	{0x8b47,0x15},
	{0x8b48,0x51},
	{0x8b49,0xef},
	{0x8b4a,0x70},
	{0x8b4b,0xf9},
	{0x8b4c,0xa2},
	{0x8b4d,0x32},
	{0x8b4e,0x92},
	{0x8b4f,0xaf},
	{0x8b50,0xe5},
	{0x8b51,0x12},
	{0x8b52,0xd3},
	{0x8b53,0x94},
	{0x8b54,0x00},
	{0x8b55,0x40},
	{0x8b56,0x03},
	{0x8b57,0x02},
	{0x8b58,0x0a},
	{0x8b59,0x22},
	{0x8b5a,0x22},
	{0x8b5b,0x12},
	{0x8b5c,0x15},
	{0x8b5d,0xa4},
	{0x8b5e,0xc2},
	{0x8b5f,0x09},
	{0x8b60,0x90},
	{0x8b61,0x30},
	{0x8b62,0x18},
	{0x8b63,0xe5},
	{0x8b64,0x21},
	{0x8b65,0xf0},
	{0x8b66,0x22},
	{0x8b67,0xe5},
	{0x8b68,0x33},
	{0x8b69,0x70},
	{0x8b6a,0x03},
	{0x8b6b,0x02},
	{0x8b6c,0x0c},
	{0x8b6d,0x8f},
	{0x8b6e,0xc2},
	{0x8b6f,0xaf},
	{0x8b70,0xaf},
	{0x8b71,0x33},
	{0x8b72,0xe4},
	{0x8b73,0xf5},
	{0x8b74,0x33},
	{0x8b75,0xd2},
	{0x8b76,0xaf},
	{0x8b77,0x90},
	{0x8b78,0x30},
	{0x8b79,0x25},
	{0x8b7a,0xe0},
	{0x8b7b,0xf5},
	{0x8b7c,0x7d},
	{0x8b7d,0x90},
	{0x8b7e,0x50},
	{0x8b7f,0x82},
	{0x8b80,0xe0},
	{0x8b81,0xf5},
	{0x8b82,0x65},
	{0x8b83,0xa3},
	{0x8b84,0xe0},
	{0x8b85,0xf5},
	{0x8b86,0x66},
	{0x8b87,0xa3},
	{0x8b88,0xe0},
	{0x8b89,0xf5},
	{0x8b8a,0x67},
	{0x8b8b,0xa3},
	{0x8b8c,0xe0},
	{0x8b8d,0xf5},
	{0x8b8e,0x68},
	{0x8b8f,0xef},
	{0x8b90,0x12},
	{0x8b91,0x09},
	{0x8b92,0xf5},
	{0x8b93,0x0b},
	{0x8b94,0xbb},
	{0x8b95,0x03},
	{0x8b96,0x0b},
	{0x8b97,0xd3},
	{0x8b98,0x04},
	{0x8b99,0x0b},
	{0x8b9a,0xee},
	{0x8b9b,0x05},
	{0x8b9c,0x0c},
	{0x8b9d,0x12},
	{0x8b9e,0x06},
	{0x8b9f,0x0c},
	{0x8ba0,0x00},
	{0x8ba1,0x08},
	{0x8ba2,0x0c},
	{0x8ba3,0x1f},
	{0x8ba4,0x10},
	{0x8ba5,0x0c},
	{0x8ba6,0x33},
	{0x8ba7,0x12},
	{0x8ba8,0x0c},
	{0x8ba9,0x38},
	{0x8baa,0x20},
	{0x8bab,0x0c},
	{0x8bac,0x46},
	{0x8bad,0x21},
	{0x8bae,0x0c},
	{0x8baf,0x4b},
	{0x8bb0,0x30},
	{0x8bb1,0x0c},
	{0x8bb2,0x74},
	{0x8bb3,0x50},
	{0x8bb4,0x0c},
	{0x8bb5,0x56},
	{0x8bb6,0xd8},
	{0x8bb7,0x00},
	{0x8bb8,0x00},
	{0x8bb9,0x0c},
	{0x8bba,0x81},
	{0x8bbb,0x30},
	{0x8bbc,0x00},
	{0x8bbd,0x03},
	{0x8bbe,0x02},
	{0x8bbf,0x0c},
	{0x8bc0,0x81},
	{0x8bc1,0x20},
	{0x8bc2,0x07},
	{0x8bc3,0x06},
	{0x8bc4,0x20},
	{0x8bc5,0x06},
	{0x8bc6,0x03},
	{0x8bc7,0xc3},
	{0x8bc8,0x80},
	{0x8bc9,0x01},
	{0x8bca,0xd3},
	{0x8bcb,0x92},
	{0x8bcc,0x36},
	{0x8bcd,0xd2},
	{0x8bce,0x07},
	{0x8bcf,0xc2},
	{0x8bd0,0x06},
	{0x8bd1,0x80},
	{0x8bd2,0x16},
	{0x8bd3,0x30},
	{0x8bd4,0x00},
	{0x8bd5,0x03},
	{0x8bd6,0x02},
	{0x8bd7,0x0c},
	{0x8bd8,0x81},
	{0x8bd9,0x20},
	{0x8bda,0x07},
	{0x8bdb,0x06},
	{0x8bdc,0x20},
	{0x8bdd,0x06},
	{0x8bde,0x03},
	{0x8bdf,0xc3},
	{0x8be0,0x80},
	{0x8be1,0x01},
	{0x8be2,0xd3},
	{0x8be3,0x92},
	{0x8be4,0x36},
	{0x8be5,0xd2},
	{0x8be6,0x07},
	{0x8be7,0xd2},
	{0x8be8,0x06},
	{0x8be9,0x12},
	{0x8bea,0x02},
	{0x8beb,0x90},
	{0x8bec,0x80},
	{0x8bed,0x1e},
	{0x8bee,0x30},
	{0x8bef,0x00},
	{0x8bf0,0x03},
	{0x8bf1,0x02},
	{0x8bf2,0x0c},
	{0x8bf3,0x81},
	{0x8bf4,0xc2},
	{0x8bf5,0x07},
	{0x8bf6,0xd2},
	{0x8bf7,0x06},
	{0x8bf8,0x12},
	{0x8bf9,0x02},
	{0x8bfa,0xa5},
	{0x8bfb,0xc2},
	{0x8bfc,0x04},
	{0x8bfd,0x02},
	{0x8bfe,0x0c},
	{0x8bff,0x81},
	{0x8c00,0x12},
	{0x8c01,0x02},
	{0x8c02,0x40},
	{0x8c03,0x30},
	{0x8c04,0x05},
	{0x8c05,0x06},
	{0x8c06,0xe4},
	{0x8c07,0xf5},
	{0x8c08,0x0c},
	{0x8c09,0x12},
	{0x8c0a,0x0f},
	{0x8c0b,0x52},
	{0x8c0c,0xc2},
	{0x8c0d,0x31},
	{0x8c0e,0xd2},
	{0x8c0f,0x34},
	{0x8c10,0x80},
	{0x8c11,0x6f},
	{0x8c12,0x30},
	{0x8c13,0x07},
	{0x8c14,0x6c},
	{0x8c15,0x30},
	{0x8c16,0x06},
	{0x8c17,0x69},
	{0x8c18,0x12},
	{0x8c19,0x02},
	{0x8c1a,0x90},
	{0x8c1b,0xd2},
	{0x8c1c,0x31},
	{0x8c1d,0x80},
	{0x8c1e,0x62},
	{0x8c1f,0x20},
	{0x8c20,0x07},
	{0x8c21,0x03},
	{0x8c22,0x30},
	{0x8c23,0x06},
	{0x8c24,0x09},
	{0x8c25,0xe5},
	{0x8c26,0x7d},
	{0x8c27,0x64},
	{0x8c28,0x0e},
	{0x8c29,0x70},
	{0x8c2a,0x56},
	{0x8c2b,0x20},
	{0x8c2c,0x00},
	{0x8c2d,0x53},
	{0x8c2e,0x12},
	{0x8c2f,0x05},
	{0x8c30,0x39},
	{0x8c31,0x80},
	{0x8c32,0x4e},
	{0x8c33,0x12},
	{0x8c34,0x07},
	{0x8c35,0x02},
	{0x8c36,0x80},
	{0x8c37,0x49},
	{0x8c38,0x30},
	{0x8c39,0x05},
	{0x8c3a,0x46},
	{0x8c3b,0x20},
	{0x8c3c,0x07},
	{0x8c3d,0x43},
	{0x8c3e,0x20},
	{0x8c3f,0x06},
	{0x8c40,0x40},
	{0x8c41,0x12},
	{0x8c42,0x16},
	{0x8c43,0xc4},
	{0x8c44,0x80},
	{0x8c45,0x3b},
	{0x8c46,0x12},
	{0x8c47,0x13},
	{0x8c48,0x10},
	{0x8c49,0x80},
	{0x8c4a,0x36},
	{0x8c4b,0x20},
	{0x8c4c,0x07},
	{0x8c4d,0x33},
	{0x8c4e,0x20},
	{0x8c4f,0x06},
	{0x8c50,0x30},
	{0x8c51,0x12},
	{0x8c52,0x16},
	{0x8c53,0xd3},
	{0x8c54,0x80},
	{0x8c55,0x2b},
	{0x8c56,0xe5},
	{0x8c57,0x7d},
	{0x8c58,0x64},
	{0x8c59,0x01},
	{0x8c5a,0x70},
	{0x8c5b,0x25},
	{0x8c5c,0xd2},
	{0x8c5d,0x35},
	{0x8c5e,0x90},
	{0x8c5f,0x50},
	{0x8c60,0x82},
	{0x8c61,0xe5},
	{0x8c62,0x73},
	{0x8c63,0xf0},
	{0x8c64,0xa3},
	{0x8c65,0xe5},
	{0x8c66,0x74},
	{0x8c67,0xf0},
	{0x8c68,0xa3},
	{0x8c69,0xe5},
	{0x8c6a,0x75},
	{0x8c6b,0xf0},
	{0x8c6c,0xa3},
	{0x8c6d,0xe5},
	{0x8c6e,0x76},
	{0x8c6f,0xf0},
	{0x8c70,0xc2},
	{0x8c71,0x35},
	{0x8c72,0x80},
	{0x8c73,0x0d},
	{0x8c74,0x90},
	{0x8c75,0x50},
	{0x8c76,0x82},
	{0x8c77,0x30},
	{0x8c78,0x33},
	{0x8c79,0x05},
	{0x8c7a,0x74},
	{0x8c7b,0x55},
	{0x8c7c,0xf0},
	{0x8c7d,0x80},
	{0x8c7e,0x02},
	{0x8c7f,0xe4},
	{0x8c80,0xf0},
	{0x8c81,0x20},
	{0x8c82,0x07},
	{0x8c83,0x06},
	{0x8c84,0x30},
	{0x8c85,0x06},
	{0x8c86,0x03},
	{0x8c87,0x30},
	{0x8c88,0x04},
	{0x8c89,0x05},
	{0x8c8a,0x90},
	{0x8c8b,0x30},
	{0x8c8c,0x25},
	{0x8c8d,0xe4},
	{0x8c8e,0xf0},
	{0x8c8f,0x22},
	{0x8c90,0xc0},
	{0x8c91,0xe0},
	{0x8c92,0xc0},
	{0x8c93,0xf0},
	{0x8c94,0xc0},
	{0x8c95,0x83},
	{0x8c96,0xc0},
	{0x8c97,0x82},
	{0x8c98,0xc0},
	{0x8c99,0xd0},
	{0x8c9a,0x75},
	{0x8c9b,0xd0},
	{0x8c9c,0x00},
	{0x8c9d,0xc0},
	{0x8c9e,0x00},
	{0x8c9f,0xc0},
	{0x8ca0,0x01},
	{0x8ca1,0xc0},
	{0x8ca2,0x02},
	{0x8ca3,0xc0},
	{0x8ca4,0x03},
	{0x8ca5,0xc0},
	{0x8ca6,0x04},
	{0x8ca7,0xc0},
	{0x8ca8,0x05},
	{0x8ca9,0xc0},
	{0x8caa,0x06},
	{0x8cab,0xc0},
	{0x8cac,0x07},
	{0x8cad,0x90},
	{0x8cae,0x3f},
	{0x8caf,0x0c},
	{0x8cb0,0xe0},
	{0x8cb1,0xf5},
	{0x8cb2,0x08},
	{0x8cb3,0xe5},
	{0x8cb4,0x08},
	{0x8cb5,0x20},
	{0x8cb6,0xe3},
	{0x8cb7,0x03},
	{0x8cb8,0x02},
	{0x8cb9,0x0d},
	{0x8cba,0x41},
	{0x8cbb,0x30},
	{0x8cbc,0x35},
	{0x8cbd,0x03},
	{0x8cbe,0x02},
	{0x8cbf,0x0d},
	{0x8cc0,0x41},
	{0x8cc1,0x90},
	{0x8cc2,0x60},
	{0x8cc3,0x16},
	{0x8cc4,0xe0},
	{0x8cc5,0xf5},
	{0x8cc6,0x69},
	{0x8cc7,0xa3},
	{0x8cc8,0xe0},
	{0x8cc9,0xf5},
	{0x8cca,0x6a},
	{0x8ccb,0x90},
	{0x8ccc,0x60},
	{0x8ccd,0x1e},
	{0x8cce,0xe0},
	{0x8ccf,0xf5},
	{0x8cd0,0x6b},
	{0x8cd1,0xa3},
	{0x8cd2,0xe0},
	{0x8cd3,0xf5},
	{0x8cd4,0x6c},
	{0x8cd5,0x90},
	{0x8cd6,0x60},
	{0x8cd7,0x26},
	{0x8cd8,0xe0},
	{0x8cd9,0xf5},
	{0x8cda,0x6d},
	{0x8cdb,0xa3},
	{0x8cdc,0xe0},
	{0x8cdd,0xf5},
	{0x8cde,0x6e},
	{0x8cdf,0x90},
	{0x8ce0,0x60},
	{0x8ce1,0x2e},
	{0x8ce2,0xe0},
	{0x8ce3,0xf5},
	{0x8ce4,0x6f},
	{0x8ce5,0xa3},
	{0x8ce6,0xe0},
	{0x8ce7,0xf5},
	{0x8ce8,0x70},
	{0x8ce9,0x90},
	{0x8cea,0x60},
	{0x8ceb,0x36},
	{0x8cec,0x12},
	{0x8ced,0x00},
	{0x8cee,0x16},
	{0x8cef,0x12},
	{0x8cf0,0x01},
	{0x8cf1,0xbf},
	{0x8cf2,0x40},
	{0x8cf3,0x06},
	{0x8cf4,0x75},
	{0x8cf5,0x2a},
	{0x8cf6,0xff},
	{0x8cf7,0x75},
	{0x8cf8,0x2b},
	{0x8cf9,0xff},
	{0x8cfa,0x85},
	{0x8cfb,0x2a},
	{0x8cfc,0x73},
	{0x8cfd,0x85},
	{0x8cfe,0x2b},
	{0x8cff,0x74},
	{0x8d00,0x90},
	{0x8d01,0x60},
	{0x8d02,0x1a},
	{0x8d03,0xe0},
	{0x8d04,0xf5},
	{0x8d05,0x69},
	{0x8d06,0xa3},
	{0x8d07,0xe0},
	{0x8d08,0xf5},
	{0x8d09,0x6a},
	{0x8d0a,0x90},
	{0x8d0b,0x60},
	{0x8d0c,0x22},
	{0x8d0d,0xe0},
	{0x8d0e,0xf5},
	{0x8d0f,0x6b},
	{0x8d10,0xa3},
	{0x8d11,0xe0},
	{0x8d12,0xf5},
	{0x8d13,0x6c},
	{0x8d14,0x90},
	{0x8d15,0x60},
	{0x8d16,0x2a},
	{0x8d17,0xe0},
	{0x8d18,0xf5},
	{0x8d19,0x6d},
	{0x8d1a,0xa3},
	{0x8d1b,0xe0},
	{0x8d1c,0xf5},
	{0x8d1d,0x6e},
	{0x8d1e,0x90},
	{0x8d1f,0x60},
	{0x8d20,0x32},
	{0x8d21,0xe0},
	{0x8d22,0xf5},
	{0x8d23,0x6f},
	{0x8d24,0xa3},
	{0x8d25,0xe0},
	{0x8d26,0xf5},
	{0x8d27,0x70},
	{0x8d28,0x90},
	{0x8d29,0x60},
	{0x8d2a,0x3a},
	{0x8d2b,0x12},
	{0x8d2c,0x00},
	{0x8d2d,0x16},
	{0x8d2e,0x12},
	{0x8d2f,0x01},
	{0x8d30,0xbf},
	{0x8d31,0x40},
	{0x8d32,0x06},
	{0x8d33,0x75},
	{0x8d34,0x2a},
	{0x8d35,0xff},
	{0x8d36,0x75},
	{0x8d37,0x2b},
	{0x8d38,0xff},
	{0x8d39,0x85},
	{0x8d3a,0x2a},
	{0x8d3b,0x75},
	{0x8d3c,0x85},
	{0x8d3d,0x2b},
	{0x8d3e,0x76},
	{0x8d3f,0xd2},
	{0x8d40,0x3d},
	{0x8d41,0xe5},
	{0x8d42,0x08},
	{0x8d43,0x30},
	{0x8d44,0xe5},
	{0x8d45,0x44},
	{0x8d46,0x90},
	{0x8d47,0x56},
	{0x8d48,0x90},
	{0x8d49,0xe0},
	{0x8d4a,0xf5},
	{0x8d4b,0x55},
	{0x8d4c,0xe5},
	{0x8d4d,0x7a},
	{0x8d4e,0x24},
	{0x8d4f,0x02},
	{0x8d50,0xff},
	{0x8d51,0xe4},
	{0x8d52,0x33},
	{0x8d53,0xfe},
	{0x8d54,0xad},
	{0x8d55,0x55},
	{0x8d56,0xc3},
	{0x8d57,0xef},
	{0x8d58,0x9d},
	{0x8d59,0x74},
	{0x8d5a,0x80},
	{0x8d5b,0xf8},
	{0x8d5c,0x6e},
	{0x8d5d,0x98},
	{0x8d5e,0x50},
	{0x8d5f,0x02},
	{0x8d60,0x80},
	{0x8d61,0x01},
	{0x8d62,0xc3},
	{0x8d63,0x92},
	{0x8d64,0x27},
	{0x8d65,0xaf},
	{0x8d66,0x55},
	{0x8d67,0xef},
	{0x8d68,0x24},
	{0x8d69,0x02},
	{0x8d6a,0xff},
	{0x8d6b,0xe4},
	{0x8d6c,0x33},
	{0x8d6d,0xfe},
	{0x8d6e,0xc3},
	{0x8d6f,0xef},
	{0x8d70,0x95},
	{0x8d71,0x7a},
	{0x8d72,0x74},
	{0x8d73,0x80},
	{0x8d74,0xf8},
	{0x8d75,0x6e},
	{0x8d76,0x98},
	{0x8d77,0x50},
	{0x8d78,0x02},
	{0x8d79,0x80},
	{0x8d7a,0x02},
	{0x8d7b,0xa2},
	{0x8d7c,0x27},
	{0x8d7d,0x92},
	{0x8d7e,0x27},
	{0x8d7f,0x30},
	{0x8d80,0x27},
	{0x8d81,0x04},
	{0x8d82,0xaf},
	{0x8d83,0x55},
	{0x8d84,0x80},
	{0x8d85,0x02},
	{0x8d86,0xaf},
	{0x8d87,0x7a},
	{0x8d88,0x8f},
	{0x8d89,0x7a},
	{0x8d8a,0xe5},
	{0x8d8b,0x08},
	{0x8d8c,0x30},
	{0x8d8d,0xe1},
	{0x8d8e,0x08},
	{0x8d8f,0x90},
	{0x8d90,0x30},
	{0x8d91,0x24},
	{0x8d92,0xe0},
	{0x8d93,0xf5},
	{0x8d94,0x33},
	{0x8d95,0xe4},
	{0x8d96,0xf0},
	{0x8d97,0x90},
	{0x8d98,0x3f},
	{0x8d99,0x0c},
	{0x8d9a,0xe5},
	{0x8d9b,0x08},
	{0x8d9c,0xf0},
	{0x8d9d,0xd0},
	{0x8d9e,0x07},
	{0x8d9f,0xd0},
	{0x8da0,0x06},
	{0x8da1,0xd0},
	{0x8da2,0x05},
	{0x8da3,0xd0},
	{0x8da4,0x04},
	{0x8da5,0xd0},
	{0x8da6,0x03},
	{0x8da7,0xd0},
	{0x8da8,0x02},
	{0x8da9,0xd0},
	{0x8daa,0x01},
	{0x8dab,0xd0},
	{0x8dac,0x00},
	{0x8dad,0xd0},
	{0x8dae,0xd0},
	{0x8daf,0xd0},
	{0x8db0,0x82},
	{0x8db1,0xd0},
	{0x8db2,0x83},
	{0x8db3,0xd0},
	{0x8db4,0xf0},
	{0x8db5,0xd0},
	{0x8db6,0xe0},
	{0x8db7,0x32},
	{0x8db8,0x30},
	{0x8db9,0x04},
	{0x8dba,0x03},
	{0x8dbb,0x02},
	{0x8dbc,0x0e},
	{0x8dbd,0xa3},
	{0x8dbe,0xd2},
	{0x8dbf,0x04},
	{0x8dc0,0xe5},
	{0x8dc1,0x7d},
	{0x8dc2,0xb4},
	{0x8dc3,0x01},
	{0x8dc4,0x06},
	{0x8dc5,0x12},
	{0x8dc6,0x16},
	{0x8dc7,0xa4},
	{0x8dc8,0x02},
	{0x8dc9,0x0e},
	{0x8dca,0x9c},
	{0x8dcb,0xe5},
	{0x8dcc,0x7d},
	{0x8dcd,0xb4},
	{0x8dce,0x02},
	{0x8dcf,0x06},
	{0x8dd0,0x12},
	{0x8dd1,0x16},
	{0x8dd2,0xb5},
	{0x8dd3,0x02},
	{0x8dd4,0x0e},
	{0x8dd5,0x9c},
	{0x8dd6,0xe5},
	{0x8dd7,0x7d},
	{0x8dd8,0xb4},
	{0x8dd9,0x03},
	{0x8dda,0x05},
	{0x8ddb,0xe4},
	{0x8ddc,0xf5},
	{0x8ddd,0x0c},
	{0x8dde,0x80},
	{0x8ddf,0x08},
	{0x8de0,0xe5},
	{0x8de1,0x7d},
	{0x8de2,0xb4},
	{0x8de3,0x04},
	{0x8de4,0x09},
	{0x8de5,0x85},
	{0x8de6,0x7b},
	{0x8de7,0x0c},
	{0x8de8,0x12},
	{0x8de9,0x0f},
	{0x8dea,0x52},
	{0x8deb,0x02},
	{0x8dec,0x0e},
	{0x8ded,0x9c},
	{0x8dee,0xe5},
	{0x8def,0x7d},
	{0x8df0,0x64},
	{0x8df1,0x0f},
	{0x8df2,0x70},
	{0x8df3,0x1f},
	{0x8df4,0x12},
	{0x8df5,0x02},
	{0x8df6,0xbd},
	{0x8df7,0x40},
	{0x8df8,0x06},
	{0x8df9,0x7e},
	{0x8dfa,0x00},
	{0x8dfb,0x7f},
	{0x8dfc,0xff},
	{0x8dfd,0x80},
	{0x8dfe,0x04},
	{0x8dff,0xae},
	{0x8e00,0x67},
	{0x8e01,0xaf},
	{0x8e02,0x68},
	{0x8e03,0x12},
	{0x8e04,0x02},
	{0x8e05,0x58},
	{0x8e06,0xc3},
	{0x8e07,0x33},
	{0x8e08,0xce},
	{0x8e09,0x33},
	{0x8e0a,0xce},
	{0x8e0b,0xd8},
	{0x8e0c,0xf9},
	{0x8e0d,0x12},
	{0x8e0e,0x0e},
	{0x8e0f,0xa4},
	{0x8e10,0x02},
	{0x8e11,0x0e},
	{0x8e12,0x9c},
	{0x8e13,0xe5},
	{0x8e14,0x7d},
	{0x8e15,0x64},
	{0x8e16,0x10},
	{0x8e17,0x60},
	{0x8e18,0x03},
	{0x8e19,0x02},
	{0x8e1a,0x0e},
	{0x8e1b,0x9c},
	{0x8e1c,0xf5},
	{0x8e1d,0x65},
	{0x8e1e,0xf5},
	{0x8e1f,0x66},
	{0x8e20,0xf5},
	{0x8e21,0x67},
	{0x8e22,0xab},
	{0x8e23,0x68},
	{0x8e24,0xaa},
	{0x8e25,0x67},
	{0x8e26,0xa9},
	{0x8e27,0x66},
	{0x8e28,0xa8},
	{0x8e29,0x65},
	{0x8e2a,0x12},
	{0x8e2b,0x01},
	{0x8e2c,0xa0},
	{0x8e2d,0xfe},
	{0x8e2e,0xe4},
	{0x8e2f,0xfc},
	{0x8e30,0xfd},
	{0x8e31,0x12},
	{0x8e32,0x01},
	{0x8e33,0xe7},
	{0x8e34,0xe4},
	{0x8e35,0x7b},
	{0x8e36,0xff},
	{0x8e37,0xfa},
	{0x8e38,0xf9},
	{0x8e39,0xf8},
	{0x8e3a,0x12},
	{0x8e3b,0x02},
	{0x8e3c,0x6d},
	{0x8e3d,0x85},
	{0x8e3e,0x49},
	{0x8e3f,0x82},
	{0x8e40,0x85},
	{0x8e41,0x48},
	{0x8e42,0x83},
	{0x8e43,0xe4},
	{0x8e44,0x93},
	{0x8e45,0xff},
	{0x8e46,0xe4},
	{0x8e47,0xfc},
	{0x8e48,0xfd},
	{0x8e49,0xfe},
	{0x8e4a,0xe5},
	{0x8e4b,0x68},
	{0x8e4c,0x2f},
	{0x8e4d,0xf5},
	{0x8e4e,0x68},
	{0x8e4f,0xee},
	{0x8e50,0x35},
	{0x8e51,0x67},
	{0x8e52,0xf5},
	{0x8e53,0x67},
	{0x8e54,0xed},
	{0x8e55,0x35},
	{0x8e56,0x66},
	{0x8e57,0xf5},
	{0x8e58,0x66},
	{0x8e59,0xec},
	{0x8e5a,0x35},
	{0x8e5b,0x65},
	{0x8e5c,0xf5},
	{0x8e5d,0x65},
	{0x8e5e,0x12},
	{0x8e5f,0x02},
	{0x8e60,0xbd},
	{0x8e61,0x40},
	{0x8e62,0x04},
	{0x8e63,0x7f},
	{0x8e64,0xff},
	{0x8e65,0x80},
	{0x8e66,0x04},
	{0x8e67,0xae},
	{0x8e68,0x67},
	{0x8e69,0xaf},
	{0x8e6a,0x68},
	{0x8e6b,0x12},
	{0x8e6c,0x02},
	{0x8e6d,0x58},
	{0x8e6e,0xc3},
	{0x8e6f,0x33},
	{0x8e70,0xce},
	{0x8e71,0x33},
	{0x8e72,0xce},
	{0x8e73,0xd8},
	{0x8e74,0xf9},
	{0x8e75,0x12},
	{0x8e76,0x0e},
	{0x8e77,0xa4},
	{0x8e78,0xe4},
	{0x8e79,0xf5},
	{0x8e7a,0x66},
	{0x8e7b,0xf5},
	{0x8e7c,0x66},
	{0x8e7d,0xe5},
	{0x8e7e,0x66},
	{0x8e7f,0xd3},
	{0x8e80,0x95},
	{0x8e81,0x7b},
	{0x8e82,0x50},
	{0x8e83,0x15},
	{0x8e84,0xaf},
	{0x8e85,0x66},
	{0x8e86,0xe5},
	{0x8e87,0x49},
	{0x8e88,0x2f},
	{0x8e89,0x12},
	{0x8e8a,0x02},
	{0x8e8b,0x4f},
	{0x8e8c,0x93},
	{0x8e8d,0xc3},
	{0x8e8e,0x95},
	{0x8e8f,0x68},
	{0x8e90,0xe4},
	{0x8e91,0x95},
	{0x8e92,0x67},
	{0x8e93,0x50},
	{0x8e94,0x04},
	{0x8e95,0x05},
	{0x8e96,0x66},
	{0x8e97,0x80},
	{0x8e98,0xe4},
	{0x8e99,0x85},
	{0x8e9a,0x66},
	{0x8e9b,0x7c},
	{0x8e9c,0x90},
	{0x8e9d,0x30},
	{0x8e9e,0x25},
	{0x8e9f,0xe4},
	{0x8ea0,0xf0},
	{0x8ea1,0xd2},
	{0x8ea2,0x34},
	{0x8ea3,0x22},
	{0x8ea4,0xf5},
	{0x8ea5,0x68},
	{0x8ea6,0x8e},
	{0x8ea7,0x67},
	{0x8ea8,0x85},
	{0x8ea9,0x67},
	{0x8eaa,0x10},
	{0x8eab,0x85},
	{0x8eac,0x68},
	{0x8ead,0x11},
	{0x8eae,0x12},
	{0x8eaf,0x0a},
	{0x8eb0,0x1b},
	{0x8eb1,0x22},
	{0x8eb2,0x12},
	{0x8eb3,0x02},
	{0x8eb4,0x85},
	{0x8eb5,0xb5},
	{0x8eb6,0x07},
	{0x8eb7,0x03},
	{0x8eb8,0xd3},
	{0x8eb9,0x80},
	{0x8eba,0x01},
	{0x8ebb,0xc3},
	{0x8ebc,0x40},
	{0x8ebd,0x03},
	{0x8ebe,0x02},
	{0x8ebf,0x0f},
	{0x8ec0,0x51},
	{0x8ec1,0x90},
	{0x8ec2,0x30},
	{0x8ec3,0x04},
	{0x8ec4,0xe0},
	{0x8ec5,0x44},
	{0x8ec6,0x20},
	{0x8ec7,0xf0},
	{0x8ec8,0xa3},
	{0x8ec9,0xe0},
	{0x8eca,0x44},
	{0x8ecb,0x40},
	{0x8ecc,0xf0},
	{0x8ecd,0x90},
	{0x8ece,0x50},
	{0x8ecf,0x25},
	{0x8ed0,0xe0},
	{0x8ed1,0x44},
	{0x8ed2,0x04},
	{0x8ed3,0xf0},
	{0x8ed4,0x90},
	{0x8ed5,0x50},
	{0x8ed6,0x03},
	{0x8ed7,0xe0},
	{0x8ed8,0x54},
	{0x8ed9,0xfd},
	{0x8eda,0xf0},
	{0x8edb,0x90},
	{0x8edc,0x50},
	{0x8edd,0x27},
	{0x8ede,0xe0},
	{0x8edf,0x44},
	{0x8ee0,0x01},
	{0x8ee1,0xf0},
	{0x8ee2,0x90},
	{0x8ee3,0x50},
	{0x8ee4,0x31},
	{0x8ee5,0xe4},
	{0x8ee6,0xf0},
	{0x8ee7,0x90},
	{0x8ee8,0x50},
	{0x8ee9,0x33},
	{0x8eea,0xf0},
	{0x8eeb,0x90},
	{0x8eec,0x30},
	{0x8eed,0x1e},
	{0x8eee,0x12},
	{0x8eef,0x01},
	{0x8ef0,0xfb},
	{0x8ef1,0x90},
	{0x8ef2,0x30},
	{0x8ef3,0x18},
	{0x8ef4,0x12},
	{0x8ef5,0x01},
	{0x8ef6,0xfb},
	{0x8ef7,0x90},
	{0x8ef8,0x30},
	{0x8ef9,0x1b},
	{0x8efa,0x12},
	{0x8efb,0x01},
	{0x8efc,0xfb},
	{0x8efd,0xe0},
	{0x8efe,0xf5},
	{0x8eff,0x25},
	{0x8f00,0x90},
	{0x8f01,0x30},
	{0x8f02,0x18},
	{0x8f03,0xe0},
	{0x8f04,0xf5},
	{0x8f05,0x21},
	{0x8f06,0x90},
	{0x8f07,0x60},
	{0x8f08,0x00},
	{0x8f09,0x74},
	{0x8f0a,0xf5},
	{0x8f0b,0xf0},
	{0x8f0c,0x90},
	{0x8f0d,0x3f},
	{0x8f0e,0x01},
	{0x8f0f,0xe4},
	{0x8f10,0xf0},
	{0x8f11,0xa3},
	{0x8f12,0xf0},
	{0x8f13,0x90},
	{0x8f14,0x3f},
	{0x8f15,0x01},
	{0x8f16,0xe0},
	{0x8f17,0x44},
	{0x8f18,0x08},
	{0x8f19,0xf0},
	{0x8f1a,0xe0},
	{0x8f1b,0x44},
	{0x8f1c,0x20},
	{0x8f1d,0xf0},
	{0x8f1e,0x90},
	{0x8f1f,0x3f},
	{0x8f20,0x05},
	{0x8f21,0x74},
	{0x8f22,0x30},
	{0x8f23,0xf0},
	{0x8f24,0xa3},
	{0x8f25,0x74},
	{0x8f26,0x24},
	{0x8f27,0xf0},
	{0x8f28,0x90},
	{0x8f29,0x3f},
	{0x8f2a,0x0b},
	{0x8f2b,0xe0},
	{0x8f2c,0x44},
	{0x8f2d,0x0f},
	{0x8f2e,0xf0},
	{0x8f2f,0x90},
	{0x8f30,0x3f},
	{0x8f31,0x01},
	{0x8f32,0xe0},
	{0x8f33,0x44},
	{0x8f34,0x02},
	{0x8f35,0xf0},
	{0x8f36,0xc2},
	{0x8f37,0x8c},
	{0x8f38,0x75},
	{0x8f39,0x89},
	{0x8f3a,0x03},
	{0x8f3b,0x75},
	{0x8f3c,0xa8},
	{0x8f3d,0x07},
	{0x8f3e,0x75},
	{0x8f3f,0xb8},
	{0x8f40,0x04},
	{0x8f41,0xe4},
	{0x8f42,0xf5},
	{0x8f43,0xd8},
	{0x8f44,0xf5},
	{0x8f45,0xe8},
	{0x8f46,0x90},
	{0x8f47,0x30},
	{0x8f48,0x01},
	{0x8f49,0xe0},
	{0x8f4a,0x44},
	{0x8f4b,0x40},
	{0x8f4c,0xf0},
	{0x8f4d,0xe0},
	{0x8f4e,0x54},
	{0x8f4f,0xbf},
	{0x8f50,0xf0},
	{0x8f51,0x22},
	{0x8f52,0xe5},
	{0x8f53,0x0c},
	{0x8f54,0xd3},
	{0x8f55,0x95},
	{0x8f56,0x7b},
	{0x8f57,0x40},
	{0x8f58,0x01},
	{0x8f59,0x22},
	{0x8f5a,0xe5},
	{0x8f5b,0x49},
	{0x8f5c,0x25},
	{0x8f5d,0x0c},
	{0x8f5e,0x12},
	{0x8f5f,0x02},
	{0x8f60,0x4f},
	{0x8f61,0x93},
	{0x8f62,0x75},
	{0x8f63,0x0d},
	{0x8f64,0x00},
	{0x8f65,0xf5},
	{0x8f66,0x0e},
	{0x8f67,0x45},
	{0x8f68,0x0d},
	{0x8f69,0x70},
	{0x8f6a,0x05},
	{0x8f6b,0x85},
	{0x8f6c,0x64},
	{0x8f6d,0x0f},
	{0x8f6e,0x80},
	{0x8f6f,0x1b},
	{0x8f70,0x12},
	{0x8f71,0x02},
	{0x8f72,0x9b},
	{0x8f73,0xc3},
	{0x8f74,0x33},
	{0x8f75,0xce},
	{0x8f76,0x33},
	{0x8f77,0xce},
	{0x8f78,0xd8},
	{0x8f79,0xf9},
	{0x8f7a,0xf5},
	{0x8f7b,0x0e},
	{0x8f7c,0x8e},
	{0x8f7d,0x0d},
	{0x8f7e,0x85},
	{0x8f7f,0x0d},
	{0x8f80,0x10},
	{0x8f81,0xf5},
	{0x8f82,0x11},
	{0x8f83,0x12},
	{0x8f84,0x0a},
	{0x8f85,0x1b},
	{0x8f86,0x30},
	{0x8f87,0x33},
	{0x8f88,0x63},
	{0x8f89,0xc3},
	{0x8f8a,0x22},
	{0x8f8b,0xe5},
	{0x8f8c,0x0f},
	{0x8f8d,0xd3},
	{0x8f8e,0x94},
	{0x8f8f,0x10},
	{0x8f90,0x40},
	{0x8f91,0x33},
	{0x8f92,0xe5},
	{0x8f93,0x0f},
	{0x8f94,0xd3},
	{0x8f95,0x94},
	{0x8f96,0x60},
	{0x8f97,0x40},
	{0x8f98,0x05},
	{0x8f99,0x75},
	{0x8f9a,0x0f},
	{0x8f9b,0x58},
	{0x8f9c,0x80},
	{0x8f9d,0x11},
	{0x8f9e,0xe5},
	{0x8f9f,0x0f},
	{0x8fa0,0xd3},
	{0x8fa1,0x94},
	{0x8fa2,0x40},
	{0x8fa3,0x40},
	{0x8fa4,0x04},
	{0x8fa5,0x74},
	{0x8fa6,0xf0},
	{0x8fa7,0x80},
	{0x8fa8,0x02},
	{0x8fa9,0x74},
	{0x8faa,0xf8},
	{0x8fab,0x25},
	{0x8fac,0x0f},
	{0x8fad,0xf5},
	{0x8fae,0x0f},
	{0x8faf,0x75},
	{0x8fb0,0x0d},
	{0x8fb1,0x00},
	{0x8fb2,0x85},
	{0x8fb3,0x0f},
	{0x8fb4,0x0e},
	{0x8fb5,0x12},
	{0x8fb6,0x02},
	{0x8fb7,0x9b},
	{0x8fb8,0xc3},
	{0x8fb9,0x33},
	{0x8fba,0xce},
	{0x8fbb,0x33},
	{0x8fbc,0xce},
	{0x8fbd,0xd8},
	{0x8fbe,0xf9},
	{0x8fbf,0xf5},
	{0x8fc0,0x0e},
	{0x8fc1,0x8e},
	{0x8fc2,0x0d},
	{0x8fc3,0x80},
	{0x8fc4,0x0a},
	{0x8fc5,0xe4},
	{0x8fc6,0xf5},
	{0x8fc7,0x0f},
	{0x8fc8,0x75},
	{0x8fc9,0x0d},
	{0x8fca,0x80},
	{0x8fcb,0xf5},
	{0x8fcc,0x0e},
	{0x8fcd,0xf5},
	{0x8fce,0x64},
	{0x8fcf,0x85},
	{0x8fd0,0x0d},
	{0x8fd1,0x10},
	{0x8fd2,0x85},
	{0x8fd3,0x0e},
	{0x8fd4,0x11},
	{0x8fd5,0x12},
	{0x8fd6,0x0a},
	{0x8fd7,0x1b},
	{0x8fd8,0x30},
	{0x8fd9,0x33},
	{0x8fda,0x02},
	{0x8fdb,0xc3},
	{0x8fdc,0x22},
	{0x8fdd,0xe5},
	{0x8fde,0x0f},
	{0x8fdf,0x60},
	{0x8fe0,0x0b},
	{0x8fe1,0x75},
	{0x8fe2,0x10},
	{0x8fe3,0x00},
	{0x8fe4,0x75},
	{0x8fe5,0x11},
	{0x8fe6,0x32},
	{0x8fe7,0x12},
	{0x8fe8,0x16},
	{0x8fe9,0x3d},
	{0x8fea,0x80},
	{0x8feb,0x9f},
	{0x8fec,0x85},
	{0x8fed,0x0c},
	{0x8fee,0x7c},
	{0x8fef,0xd3},
	{0x8ff0,0x22},
	{0x8ff1,0x30},
	{0x8ff2,0x3e},
	{0x8ff3,0x09},
	{0x8ff4,0x30},
	{0x8ff5,0x20},
	{0x8ff6,0x06},
	{0x8ff7,0xae},
	{0x8ff8,0x56},
	{0x8ff9,0xaf},
	{0x8ffa,0x57},
	{0x8ffb,0x80},
	{0x8ffc,0x04},
	{0x8ffd,0xae},
	{0x8ffe,0x69},
	{0x8fff,0xaf},
	{0x9000,0x6a},
	{0x9001,0x8e},
	{0x9002,0x56},
	{0x9003,0x8f},
	{0x9004,0x57},
	{0x9005,0x30},
	{0x9006,0x3e},
	{0x9007,0x09},
	{0x9008,0x30},
	{0x9009,0x21},
	{0x900a,0x06},
	{0x900b,0xae},
	{0x900c,0x58},
	{0x900d,0xaf},
	{0x900e,0x59},
	{0x900f,0x80},
	{0x9010,0x04},
	{0x9011,0xae},
	{0x9012,0x6b},
	{0x9013,0xaf},
	{0x9014,0x6c},
	{0x9015,0x8e},
	{0x9016,0x58},
	{0x9017,0x8f},
	{0x9018,0x59},
	{0x9019,0x30},
	{0x901a,0x3e},
	{0x901b,0x09},
	{0x901c,0x30},
	{0x901d,0x22},
	{0x901e,0x06},
	{0x901f,0xae},
	{0x9020,0x5a},
	{0x9021,0xaf},
	{0x9022,0x5b},
	{0x9023,0x80},
	{0x9024,0x04},
	{0x9025,0xae},
	{0x9026,0x6d},
	{0x9027,0xaf},
	{0x9028,0x6e},
	{0x9029,0x8e},
	{0x902a,0x5a},
	{0x902b,0x8f},
	{0x902c,0x5b},
	{0x902d,0x30},
	{0x902e,0x3e},
	{0x902f,0x09},
	{0x9030,0x30},
	{0x9031,0x23},
	{0x9032,0x06},
	{0x9033,0xae},
	{0x9034,0x5c},
	{0x9035,0xaf},
	{0x9036,0x5d},
	{0x9037,0x80},
	{0x9038,0x04},
	{0x9039,0xae},
	{0x903a,0x6f},
	{0x903b,0xaf},
	{0x903c,0x70},
	{0x903d,0x8e},
	{0x903e,0x5c},
	{0x903f,0x8f},
	{0x9040,0x5d},
	{0x9041,0x30},
	{0x9042,0x3e},
	{0x9043,0x09},
	{0x9044,0x30},
	{0x9045,0x24},
	{0x9046,0x06},
	{0x9047,0xae},
	{0x9048,0x5e},
	{0x9049,0xaf},
	{0x904a,0x5f},
	{0x904b,0x80},
	{0x904c,0x04},
	{0x904d,0xae},
	{0x904e,0x71},
	{0x904f,0xaf},
	{0x9050,0x72},
	{0x9051,0x8e},
	{0x9052,0x5e},
	{0x9053,0x8f},
	{0x9054,0x5f},
	{0x9055,0x30},
	{0x9056,0x3e},
	{0x9057,0x09},
	{0x9058,0x30},
	{0x9059,0x25},
	{0x905a,0x06},
	{0x905b,0xae},
	{0x905c,0x60},
	{0x905d,0xaf},
	{0x905e,0x61},
	{0x905f,0x80},
	{0x9060,0x04},
	{0x9061,0xae},
	{0x9062,0x73},
	{0x9063,0xaf},
	{0x9064,0x74},
	{0x9065,0x8e},
	{0x9066,0x60},
	{0x9067,0x8f},
	{0x9068,0x61},
	{0x9069,0x30},
	{0x906a,0x3e},
	{0x906b,0x09},
	{0x906c,0x30},
	{0x906d,0x26},
	{0x906e,0x06},
	{0x906f,0xae},
	{0x9070,0x62},
	{0x9071,0xaf},
	{0x9072,0x63},
	{0x9073,0x80},
	{0x9074,0x04},
	{0x9075,0xae},
	{0x9076,0x75},
	{0x9077,0xaf},
	{0x9078,0x76},
	{0x9079,0x8e},
	{0x907a,0x62},
	{0x907b,0x8f},
	{0x907c,0x63},
	{0x907d,0x22},
	{0x907e,0x30},
	{0x907f,0x36},
	{0x9080,0x4e},
	{0x9081,0x12},
	{0x9082,0x10},
	{0x9083,0xf6},
	{0x9084,0xe5},
	{0x9085,0x32},
	{0x9086,0xd3},
	{0x9087,0x95},
	{0x9088,0x7c},
	{0x9089,0x40},
	{0x908a,0x0c},
	{0x908b,0xe5},
	{0x908c,0x32},
	{0x908d,0x04},
	{0x908e,0xf5},
	{0x908f,0x0c},
	{0x9090,0x12},
	{0x9091,0x0f},
	{0x9092,0x52},
	{0x9093,0xd2},
	{0x9094,0x37},
	{0x9095,0x80},
	{0x9096,0x44},
	{0x9097,0xe5},
	{0x9098,0x7b},
	{0x9099,0xb5},
	{0x909a,0x7c},
	{0x909b,0x04},
	{0x909c,0x7f},
	{0x909d,0x01},
	{0x909e,0x80},
	{0x909f,0x02},
	{0x90a0,0x7f},
	{0x90a1,0x00},
	{0x90a2,0xef},
	{0x90a3,0x24},
	{0x90a4,0xfb},
	{0x90a5,0xd3},
	{0x90a6,0x64},
	{0x90a7,0x80},
	{0x90a8,0xf8},
	{0x90a9,0xe5},
	{0x90aa,0x7c},
	{0x90ab,0x64},
	{0x90ac,0x80},
	{0x90ad,0x98},
	{0x90ae,0x40},
	{0x90af,0x12},
	{0x90b0,0xc2},
	{0x90b1,0x37},
	{0x90b2,0xe5},
	{0x90b3,0x7b},
	{0x90b4,0xb5},
	{0x90b5,0x7c},
	{0x90b6,0x04},
	{0x90b7,0x7f},
	{0x90b8,0x01},
	{0x90b9,0x80},
	{0x90ba,0x02},
	{0x90bb,0x7f},
	{0x90bc,0x00},
	{0x90bd,0xef},
	{0x90be,0x24},
	{0x90bf,0xfa},
	{0x90c0,0x80},
	{0x90c1,0x06},
	{0x90c2,0xd2},
	{0x90c3,0x37},
	{0x90c4,0xe5},
	{0x90c5,0x7c},
	{0x90c6,0x24},
	{0x90c7,0x02},
	{0x90c8,0xf5},
	{0x90c9,0x0c},
	{0x90ca,0x12},
	{0x90cb,0x0f},
	{0x90cc,0x52},
	{0x90cd,0x80},
	{0x90ce,0x0c},
	{0x90cf,0xe5},
	{0x90d0,0x7c},
	{0x90d1,0x70},
	{0x90d2,0x0f},
	{0x90d3,0x12},
	{0x90d4,0x10},
	{0x90d5,0xf6},
	{0x90d6,0xc2},
	{0x90d7,0x03},
	{0x90d8,0x12},
	{0x90d9,0x16},
	{0x90da,0xa4},
	{0x90db,0xd2},
	{0x90dc,0x02},
	{0x90dd,0xd2},
	{0x90de,0x01},
	{0x90df,0xd2},
	{0x90e0,0x00},
	{0x90e1,0x22},
	{0x90e2,0x30},
	{0x90e3,0x03},
	{0x90e4,0x08},
	{0x90e5,0xc2},
	{0x90e6,0x03},
	{0x90e7,0xc2},
	{0x90e8,0x04},
	{0x90e9,0x12},
	{0x90ea,0x02},
	{0x90eb,0xa5},
	{0x90ec,0x22},
	{0x90ed,0xe4},
	{0x90ee,0xf5},
	{0x90ef,0x0c},
	{0x90f0,0x12},
	{0x90f1,0x0f},
	{0x90f2,0x52},
	{0x90f3,0xd2},
	{0x90f4,0x03},
	{0x90f5,0x22},
	{0x90f6,0x12},
	{0x90f7,0x16},
	{0x90f8,0x90},
	{0x90f9,0xc2},
	{0x90fa,0x3e},
	{0x90fb,0x12},
	{0x90fc,0x0f},
	{0x90fd,0xf1},
	{0x90fe,0xc2},
	{0x90ff,0x3e},
	{0x9100,0x12},
	{0x9101,0x12},
	{0x9102,0xad},
	{0x9103,0x22},
	{0x9104,0xd3},
	{0x9105,0xe5},
	{0x9106,0x57},
	{0x9107,0x95},
	{0x9108,0x6a},
	{0x9109,0xe5},
	{0x910a,0x56},
	{0x910b,0x95},
	{0x910c,0x69},
	{0x910d,0x40},
	{0x910e,0x03},
	{0x910f,0xd3},
	{0x9110,0x80},
	{0x9111,0x01},
	{0x9112,0xc3},
	{0x9113,0x92},
	{0x9114,0x20},
	{0x9115,0xd3},
	{0x9116,0xe5},
	{0x9117,0x59},
	{0x9118,0x95},
	{0x9119,0x6c},
	{0x911a,0xe5},
	{0x911b,0x58},
	{0x911c,0x95},
	{0x911d,0x6b},
	{0x911e,0x40},
	{0x911f,0x03},
	{0x9120,0xd3},
	{0x9121,0x80},
	{0x9122,0x01},
	{0x9123,0xc3},
	{0x9124,0x92},
	{0x9125,0x21},
	{0x9126,0xd3},
	{0x9127,0xe5},
	{0x9128,0x5b},
	{0x9129,0x95},
	{0x912a,0x6e},
	{0x912b,0xe5},
	{0x912c,0x5a},
	{0x912d,0x95},
	{0x912e,0x6d},
	{0x912f,0x40},
	{0x9130,0x03},
	{0x9131,0xd3},
	{0x9132,0x80},
	{0x9133,0x01},
	{0x9134,0xc3},
	{0x9135,0x92},
	{0x9136,0x22},
	{0x9137,0xd3},
	{0x9138,0xe5},
	{0x9139,0x5d},
	{0x913a,0x95},
	{0x913b,0x70},
	{0x913c,0xe5},
	{0x913d,0x5c},
	{0x913e,0x95},
	{0x913f,0x6f},
	{0x9140,0x40},
	{0x9141,0x03},
	{0x9142,0xd3},
	{0x9143,0x80},
	{0x9144,0x01},
	{0x9145,0xc3},
	{0x9146,0x92},
	{0x9147,0x23},
	{0x9148,0xd3},
	{0x9149,0xe5},
	{0x914a,0x5f},
	{0x914b,0x95},
	{0x914c,0x72},
	{0x914d,0xe5},
	{0x914e,0x5e},
	{0x914f,0x95},
	{0x9150,0x71},
	{0x9151,0x40},
	{0x9152,0x03},
	{0x9153,0xd3},
	{0x9154,0x80},
	{0x9155,0x01},
	{0x9156,0xc3},
	{0x9157,0x92},
	{0x9158,0x24},
	{0x9159,0xd3},
	{0x915a,0xe5},
	{0x915b,0x61},
	{0x915c,0x95},
	{0x915d,0x74},
	{0x915e,0xe5},
	{0x915f,0x60},
	{0x9160,0x95},
	{0x9161,0x73},
	{0x9162,0x40},
	{0x9163,0x03},
	{0x9164,0xd3},
	{0x9165,0x80},
	{0x9166,0x01},
	{0x9167,0xc3},
	{0x9168,0x92},
	{0x9169,0x25},
	{0x916a,0xd3},
	{0x916b,0xe5},
	{0x916c,0x63},
	{0x916d,0x95},
	{0x916e,0x76},
	{0x916f,0xe5},
	{0x9170,0x62},
	{0x9171,0x95},
	{0x9172,0x75},
	{0x9173,0x40},
	{0x9174,0x03},
	{0x9175,0xd3},
	{0x9176,0x80},
	{0x9177,0x01},
	{0x9178,0xc3},
	{0x9179,0x92},
	{0x917a,0x26},
	{0x917b,0x22},
	{0x917c,0x12},
	{0x917d,0x11},
	{0x917e,0x04},
	{0x917f,0x30},
	{0x9180,0x36},
	{0x9181,0x40},
	{0x9182,0xe5},
	{0x9183,0x24},
	{0x9184,0x54},
	{0x9185,0x1f},
	{0x9186,0xff},
	{0x9187,0x60},
	{0x9188,0x0e},
	{0x9189,0x64},
	{0x918a,0x1f},
	{0x918b,0x60},
	{0x918c,0x0a},
	{0x918d,0xe5},
	{0x918e,0x7b},
	{0x918f,0x65},
	{0x9190,0x7c},
	{0x9191,0x60},
	{0x9192,0x04},
	{0x9193,0xe5},
	{0x9194,0x7c},
	{0x9195,0x70},
	{0x9196,0x18},
	{0x9197,0xbf},
	{0x9198,0x1f},
	{0x9199,0x02},
	{0x919a,0xb2},
	{0x919b,0x37},
	{0x919c,0xe5},
	{0x919d,0x7b},
	{0x919e,0xb5},
	{0x919f,0x7c},
	{0x91a0,0x02},
	{0x91a1,0xc2},
	{0x91a2,0x37},
	{0x91a3,0xe5},
	{0x91a4,0x7c},
	{0x91a5,0x70},
	{0x91a6,0x02},
	{0x91a7,0xd2},
	{0x91a8,0x37},
	{0x91a9,0xc2},
	{0x91aa,0x02},
	{0x91ab,0xd2},
	{0x91ac,0x01},
	{0x91ad,0xd2},
	{0x91ae,0x00},
	{0x91af,0xc2},
	{0x91b0,0x3e},
	{0x91b1,0x12},
	{0x91b2,0x0f},
	{0x91b3,0xf1},
	{0x91b4,0xc2},
	{0x91b5,0x3e},
	{0x91b6,0x12},
	{0x91b7,0x12},
	{0x91b8,0xad},
	{0x91b9,0x30},
	{0x91ba,0x37},
	{0x91bb,0x03},
	{0x91bc,0x02},
	{0x91bd,0x16},
	{0x91be,0xa4},
	{0x91bf,0x02},
	{0x91c0,0x16},
	{0x91c1,0xb5},
	{0x91c2,0xd2},
	{0x91c3,0x3e},
	{0x91c4,0x12},
	{0x91c5,0x0f},
	{0x91c6,0xf1},
	{0x91c7,0xd2},
	{0x91c8,0x3e},
	{0x91c9,0x12},
	{0x91ca,0x12},
	{0x91cb,0xad},
	{0x91cc,0x12},
	{0x91cd,0x16},
	{0x91ce,0xa4},
	{0x91cf,0xe5},
	{0x91d0,0x32},
	{0x91d1,0xd3},
	{0x91d2,0x95},
	{0x91d3,0x7c},
	{0x91d4,0x40},
	{0x91d5,0x05},
	{0x91d6,0xe4},
	{0x91d7,0x95},
	{0x91d8,0x7c},
	{0x91d9,0x40},
	{0x91da,0x06},
	{0x91db,0xc2},
	{0x91dc,0x02},
	{0x91dd,0xd2},
	{0x91de,0x01},
	{0x91df,0xd2},
	{0x91e0,0x00},
	{0x91e1,0x22},
	{0x91e2,0x12},
	{0x91e3,0x11},
	{0x91e4,0x04},
	{0x91e5,0xc3},
	{0x91e6,0x30},
	{0x91e7,0x25},
	{0x91e8,0x0c},
	{0x91e9,0xe5},
	{0x91ea,0x61},
	{0x91eb,0x95},
	{0x91ec,0x74},
	{0x91ed,0xff},
	{0x91ee,0xe5},
	{0x91ef,0x60},
	{0x91f0,0x95},
	{0x91f1,0x73},
	{0x91f2,0xfe},
	{0x91f3,0x80},
	{0x91f4,0x0a},
	{0x91f5,0xe5},
	{0x91f6,0x74},
	{0x91f7,0x95},
	{0x91f8,0x61},
	{0x91f9,0xff},
	{0x91fa,0xe5},
	{0x91fb,0x73},
	{0x91fc,0x95},
	{0x91fd,0x60},
	{0x91fe,0xfe},
	{0x91ff,0x8e},
	{0x9200,0x0a},
	{0x9201,0x8f},
	{0x9202,0x0b},
	{0x9203,0x30},
	{0x9204,0x03},
	{0x9205,0x26},
	{0x9206,0x12},
	{0x9207,0x02},
	{0x9208,0xb3},
	{0x9209,0x50},
	{0x920a,0x03},
	{0x920b,0x30},
	{0x920c,0x27},
	{0x920d,0x07},
	{0x920e,0xc2},
	{0x920f,0x3e},
	{0x9210,0x12},
	{0x9211,0x0f},
	{0x9212,0xf1},
	{0x9213,0x80},
	{0x9214,0x2f},
	{0x9215,0x05},
	{0x9216,0x31},
	{0x9217,0xe5},
	{0x9218,0x31},
	{0x9219,0xd3},
	{0x921a,0x94},
	{0x921b,0x02},
	{0x921c,0x40},
	{0x921d,0x29},
	{0x921e,0xe4},
	{0x921f,0xf5},
	{0x9220,0x31},
	{0x9221,0xc2},
	{0x9222,0x03},
	{0x9223,0xc2},
	{0x9224,0x02},
	{0x9225,0xc2},
	{0x9226,0x01},
	{0x9227,0xd2},
	{0x9228,0x00},
	{0x9229,0xd2},
	{0x922a,0x34},
	{0x922b,0x22},
	{0x922c,0x12},
	{0x922d,0x02},
	{0x922e,0xb3},
	{0x922f,0x50},
	{0x9230,0x03},
	{0x9231,0x30},
	{0x9232,0x27},
	{0x9233,0x04},
	{0x9234,0x05},
	{0x9235,0x31},
	{0x9236,0x80},
	{0x9237,0x03},
	{0x9238,0xe4},
	{0x9239,0xf5},
	{0x923a,0x31},
	{0x923b,0xe5},
	{0x923c,0x31},
	{0x923d,0xd3},
	{0x923e,0x94},
	{0x923f,0x02},
	{0x9240,0x40},
	{0x9241,0x05},
	{0x9242,0xd2},
	{0x9243,0x03},
	{0x9244,0xe4},
	{0x9245,0xf5},
	{0x9246,0x31},
	{0x9247,0x22},
	{0x9248,0xe5},
	{0x9249,0x0a},
	{0x924a,0x70},
	{0x924b,0x04},
	{0x924c,0x7a},
	{0x924d,0x13},
	{0x924e,0x7b},
	{0x924f,0x81},
	{0x9250,0xe5},
	{0x9251,0x0a},
	{0x9252,0xb4},
	{0x9253,0x01},
	{0x9254,0x04},
	{0x9255,0x7a},
	{0x9256,0x13},
	{0x9257,0x7b},
	{0x9258,0x95},
	{0x9259,0xe5},
	{0x925a,0x0a},
	{0x925b,0xb4},
	{0x925c,0x02},
	{0x925d,0x04},
	{0x925e,0x7a},
	{0x925f,0x13},
	{0x9260,0x7b},
	{0x9261,0xa9},
	{0x9262,0x8b},
	{0x9263,0x82},
	{0x9264,0x8a},
	{0x9265,0x83},
	{0x9266,0x12},
	{0x9267,0x09},
	{0x9268,0xe5},
	{0x9269,0x8f},
	{0x926a,0x37},
	{0x926b,0x8e},
	{0x926c,0x36},
	{0x926d,0x8d},
	{0x926e,0x35},
	{0x926f,0x8c},
	{0x9270,0x34},
	{0x9271,0xe5},
	{0x9272,0x82},
	{0x9273,0x24},
	{0x9274,0x04},
	{0x9275,0xf5},
	{0x9276,0x82},
	{0x9277,0xe4},
	{0x9278,0x35},
	{0x9279,0x83},
	{0x927a,0xf5},
	{0x927b,0x83},
	{0x927c,0x12},
	{0x927d,0x09},
	{0x927e,0xe5},
	{0x927f,0x8f},
	{0x9280,0x3b},
	{0x9281,0x8e},
	{0x9282,0x3a},
	{0x9283,0x8d},
	{0x9284,0x39},
	{0x9285,0x8c},
	{0x9286,0x38},
	{0x9287,0xeb},
	{0x9288,0x24},
	{0x9289,0x08},
	{0x928a,0x12},
	{0x928b,0x02},
	{0x928c,0x2f},
	{0x928d,0x12},
	{0x928e,0x01},
	{0x928f,0x97},
	{0x9290,0xeb},
	{0x9291,0x24},
	{0x9292,0x0c},
	{0x9293,0x12},
	{0x9294,0x02},
	{0x9295,0x2f},
	{0x9296,0x8f},
	{0x9297,0x43},
	{0x9298,0x8e},
	{0x9299,0x42},
	{0x929a,0x8d},
	{0x929b,0x41},
	{0x929c,0x8c},
	{0x929d,0x40},
	{0x929e,0xeb},
	{0x929f,0x24},
	{0x92a0,0x10},
	{0x92a1,0x12},
	{0x92a2,0x02},
	{0x92a3,0x2f},
	{0x92a4,0x8f},
	{0x92a5,0x47},
	{0x92a6,0x8e},
	{0x92a7,0x46},
	{0x92a8,0x8d},
	{0x92a9,0x45},
	{0x92aa,0x8c},
	{0x92ab,0x44},
	{0x92ac,0x22},
	{0x92ad,0x30},
	{0x92ae,0x3e},
	{0x92af,0x07},
	{0x92b0,0x30},
	{0x92b1,0x20},
	{0x92b2,0x04},
	{0x92b3,0xaf},
	{0x92b4,0x4a},
	{0x92b5,0x80},
	{0x92b6,0x02},
	{0x92b7,0xaf},
	{0x92b8,0x7c},
	{0x92b9,0x8f},
	{0x92ba,0x4a},
	{0x92bb,0x30},
	{0x92bc,0x3e},
	{0x92bd,0x07},
	{0x92be,0x30},
	{0x92bf,0x21},
	{0x92c0,0x04},
	{0x92c1,0xaf},
	{0x92c2,0x4b},
	{0x92c3,0x80},
	{0x92c4,0x02},
	{0x92c5,0xaf},
	{0x92c6,0x7c},
	{0x92c7,0x8f},
	{0x92c8,0x4b},
	{0x92c9,0x30},
	{0x92ca,0x3e},
	{0x92cb,0x07},
	{0x92cc,0x30},
	{0x92cd,0x22},
	{0x92ce,0x04},
	{0x92cf,0xaf},
	{0x92d0,0x4c},
	{0x92d1,0x80},
	{0x92d2,0x02},
	{0x92d3,0xaf},
	{0x92d4,0x7c},
	{0x92d5,0x8f},
	{0x92d6,0x4c},
	{0x92d7,0x30},
	{0x92d8,0x3e},
	{0x92d9,0x07},
	{0x92da,0x30},
	{0x92db,0x23},
	{0x92dc,0x04},
	{0x92dd,0xaf},
	{0x92de,0x4d},
	{0x92df,0x80},
	{0x92e0,0x02},
	{0x92e1,0xaf},
	{0x92e2,0x7c},
	{0x92e3,0x8f},
	{0x92e4,0x4d},
	{0x92e5,0x30},
	{0x92e6,0x3e},
	{0x92e7,0x07},
	{0x92e8,0x30},
	{0x92e9,0x24},
	{0x92ea,0x04},
	{0x92eb,0xaf},
	{0x92ec,0x4e},
	{0x92ed,0x80},
	{0x92ee,0x02},
	{0x92ef,0xaf},
	{0x92f0,0x7c},
	{0x92f1,0x8f},
	{0x92f2,0x4e},
	{0x92f3,0x30},
	{0x92f4,0x3e},
	{0x92f5,0x07},
	{0x92f6,0x30},
	{0x92f7,0x25},
	{0x92f8,0x04},
	{0x92f9,0xaf},
	{0x92fa,0x4f},
	{0x92fb,0x80},
	{0x92fc,0x02},
	{0x92fd,0xaf},
	{0x92fe,0x7c},
	{0x92ff,0x8f},
	{0x9300,0x4f},
	{0x9301,0x30},
	{0x9302,0x3e},
	{0x9303,0x07},
	{0x9304,0x30},
	{0x9305,0x26},
	{0x9306,0x04},
	{0x9307,0xaf},
	{0x9308,0x50},
	{0x9309,0x80},
	{0x930a,0x02},
	{0x930b,0xaf},
	{0x930c,0x7c},
	{0x930d,0x8f},
	{0x930e,0x50},
	{0x930f,0x22},
	{0x9310,0xe5},
	{0x9311,0x7d},
	{0x9312,0x64},
	{0x9313,0x01},
	{0x9314,0x70},
	{0x9315,0x47},
	{0x9316,0xe5},
	{0x9317,0x49},
	{0x9318,0x25},
	{0x9319,0x7c},
	{0x931a,0x12},
	{0x931b,0x01},
	{0x931c,0xa4},
	{0x931d,0xfe},
	{0x931e,0xe4},
	{0x931f,0x8f},
	{0x9320,0x68},
	{0x9321,0x8e},
	{0x9322,0x67},
	{0x9323,0xf5},
	{0x9324,0x66},
	{0x9325,0xf5},
	{0x9326,0x65},
	{0x9327,0x12},
	{0x9328,0x01},
	{0x9329,0xf2},
	{0x932a,0x7b},
	{0x932b,0xff},
	{0x932c,0xfa},
	{0x932d,0xf9},
	{0x932e,0xf8},
	{0x932f,0x12},
	{0x9330,0x01},
	{0x9331,0xe7},
	{0x9332,0xc0},
	{0x9333,0x05},
	{0x9334,0xc0},
	{0x9335,0x06},
	{0x9336,0xc0},
	{0x9337,0x07},
	{0x9338,0x12},
	{0x9339,0x01},
	{0x933a,0xa0},
	{0x933b,0xab},
	{0x933c,0x07},
	{0x933d,0xfa},
	{0x933e,0xe4},
	{0x933f,0xf9},
	{0x9340,0xf8},
	{0x9341,0xd0},
	{0x9342,0x07},
	{0x9343,0xd0},
	{0x9344,0x06},
	{0x9345,0xd0},
	{0x9346,0x05},
	{0x9347,0x12},
	{0x9348,0x02},
	{0x9349,0x6d},
	{0x934a,0x85},
	{0x934b,0x68},
	{0x934c,0x65},
	{0x934d,0x85},
	{0x934e,0x7c},
	{0x934f,0x66},
	{0x9350,0xe5},
	{0x9351,0x49},
	{0x9352,0x25},
	{0x9353,0x7c},
	{0x9354,0x12},
	{0x9355,0x02},
	{0x9356,0x4f},
	{0x9357,0x93},
	{0x9358,0x75},
	{0x9359,0x67},
	{0x935a,0x00},
	{0x935b,0xf5},
	{0x935c,0x68},
	{0x935d,0x90},
	{0x935e,0x50},
	{0x935f,0x82},
	{0x9360,0xe5},
	{0x9361,0x65},
	{0x9362,0xf0},
	{0x9363,0xa3},
	{0x9364,0xe5},
	{0x9365,0x66},
	{0x9366,0xf0},
	{0x9367,0xa3},
	{0x9368,0xe5},
	{0x9369,0x67},
	{0x936a,0xf0},
	{0x936b,0xa3},
	{0x936c,0xe5},
	{0x936d,0x68},
	{0x936e,0xf0},
	{0x936f,0x22},
	{0x9370,0x56},
	{0x9371,0x0c},
	{0x9372,0x04},
	{0x9373,0x00},
	{0x9374,0x2a},
	{0x9375,0x35},
	{0x9376,0x40},
	{0x9377,0x49},
	{0x9378,0x52},
	{0x9379,0x5b},
	{0x937a,0x64},
	{0x937b,0x6d},
	{0x937c,0x76},
	{0x937d,0x7f},
	{0x937e,0x88},
	{0x937f,0x91},
	{0x9380,0x07},
	{0x9381,0x20},
	{0x9382,0x12},
	{0x9383,0x28},
	{0x9384,0x1e},
	{0x9385,0x18},
	{0x9386,0x18},
	{0x9387,0x28},
	{0x9388,0x1e},
	{0x9389,0x18},
	{0x938a,0x12},
	{0x938b,0x28},
	{0x938c,0x1e},
	{0x938d,0x18},
	{0x938e,0x12},
	{0x938f,0x28},
	{0x9390,0x18},
	{0x9391,0x18},
	{0x9392,0x12},
	{0x9393,0x20},
	{0x9394,0x18},
	{0x9395,0x28},
	{0x9396,0x1c},
	{0x9397,0x30},
	{0x9398,0x24},
	{0x9399,0x10},
	{0x939a,0x1c},
	{0x939b,0x18},
	{0x939c,0x24},
	{0x939d,0x1c},
	{0x939e,0x14},
	{0x939f,0x24},
	{0x93a0,0x1c},
	{0x93a1,0x28},
	{0x93a2,0x0c},
	{0x93a3,0x30},
	{0x93a4,0x14},
	{0x93a5,0x10},
	{0x93a6,0x0c},
	{0x93a7,0x18},
	{0x93a8,0x14},
	{0x93a9,0x1c},
	{0x93aa,0x20},
	{0x93ab,0x24},
	{0x93ac,0x28},
	{0x93ad,0x0c},
	{0x93ae,0x14},
	{0x93af,0x14},
	{0x93b0,0x1c},
	{0x93b1,0x1c},
	{0x93b2,0x14},
	{0x93b3,0x24},
	{0x93b4,0x1c},
	{0x93b5,0x2c},
	{0x93b6,0x14},
	{0x93b7,0x34},
	{0x93b8,0x1c},
	{0x93b9,0x1c},
	{0x93ba,0x08},
	{0x93bb,0x24},
	{0x93bc,0x10},
	{0x93bd,0x19},
	{0x93be,0x19},
	{0x93bf,0x1c},
	{0x93c0,0x19},
	{0x93c1,0x19},
	{0x93c2,0x10},
	{0x93c3,0x10},
	{0x93c4,0x10},
	{0x93c5,0x10},
	{0x93c6,0x10},
	{0x93c7,0x00},
	{0x93c8,0x00},
	{0x93c9,0x00},
	{0x93ca,0x00},
	{0x93cb,0x00},
	{0x93cc,0x12},
	{0x93cd,0x11},
	{0x93ce,0x04},
	{0x93cf,0xd2},
	{0x93d0,0x3e},
	{0x93d1,0x12},
	{0x93d2,0x0f},
	{0x93d3,0xf1},
	{0x93d4,0xd2},
	{0x93d5,0x3e},
	{0x93d6,0x12},
	{0x93d7,0x12},
	{0x93d8,0xad},
	{0x93d9,0x30},
	{0x93da,0x36},
	{0x93db,0x26},
	{0x93dc,0x30},
	{0x93dd,0x37},
	{0x93de,0x06},
	{0x93df,0xe5},
	{0x93e0,0x7b},
	{0x93e1,0x65},
	{0x93e2,0x7c},
	{0x93e3,0x60},
	{0x93e4,0x3e},
	{0x93e5,0x20},
	{0x93e6,0x37},
	{0x93e7,0x04},
	{0x93e8,0xe5},
	{0x93e9,0x7c},
	{0x93ea,0x60},
	{0x93eb,0x37},
	{0x93ec,0xe5},
	{0x93ed,0x24},
	{0x93ee,0x54},
	{0x93ef,0x1f},
	{0x93f0,0xff},
	{0x93f1,0xbf},
	{0x93f2,0x1f},
	{0x93f3,0x06},
	{0x93f4,0x30},
	{0x93f5,0x25},
	{0x93f6,0x03},
	{0x93f7,0x20},
	{0x93f8,0x26},
	{0x93f9,0x29},
	{0x93fa,0x30},
	{0x93fb,0x37},
	{0x93fc,0x02},
	{0x93fd,0x80},
	{0x93fe,0x21},
	{0x93ff,0x02},
	{0x9400,0x16},
	{0x9401,0xb5},
	{0x9402,0xe5},
	{0x9403,0x7b},
	{0x9404,0xd3},
	{0x9405,0x95},
	{0x9406,0x7c},
	{0x9407,0x40},
	{0x9408,0x03},
	{0x9409,0xd3},
	{0x940a,0x80},
	{0x940b,0x01},
	{0x940c,0xc3},
	{0x940d,0x50},
	{0x940e,0x14},
	{0x940f,0x20},
	{0x9410,0x39},
	{0x9411,0x0e},
	{0x9412,0xe5},
	{0x9413,0x24},
	{0x9414,0x54},
	{0x9415,0x1f},
	{0x9416,0xff},
	{0x9417,0xbf},
	{0x9418,0x1f},
	{0x9419,0x06},
	{0x941a,0x30},
	{0x941b,0x25},
	{0x941c,0x03},
	{0x941d,0x20},
	{0x941e,0x26},
	{0x941f,0x03},
	{0x9420,0x02},
	{0x9421,0x16},
	{0x9422,0xa4},
	{0x9423,0x12},
	{0x9424,0x02},
	{0x9425,0xc7},
	{0x9426,0x22},
	{0x9427,0xc2},
	{0x9428,0x34},
	{0x9429,0x20},
	{0x942a,0x07},
	{0x942b,0x08},
	{0x942c,0x20},
	{0x942d,0x06},
	{0x942e,0x05},
	{0x942f,0xe4},
	{0x9430,0xf5},
	{0x9431,0x0a},
	{0x9432,0x80},
	{0x9433,0x2b},
	{0x9434,0x20},
	{0x9435,0x07},
	{0x9436,0x08},
	{0x9437,0x30},
	{0x9438,0x06},
	{0x9439,0x05},
	{0x943a,0x75},
	{0x943b,0x0a},
	{0x943c,0x20},
	{0x943d,0x80},
	{0x943e,0x20},
	{0x943f,0x30},
	{0x9440,0x00},
	{0x9441,0x05},
	{0x9442,0x75},
	{0x9443,0x0a},
	{0x9444,0x01},
	{0x9445,0x80},
	{0x9446,0x18},
	{0x9447,0xe5},
	{0x9448,0x20},
	{0x9449,0x54},
	{0x944a,0x07},
	{0x944b,0xff},
	{0x944c,0xbf},
	{0x944d,0x06},
	{0x944e,0x0d},
	{0x944f,0x30},
	{0x9450,0x31},
	{0x9451,0x04},
	{0x9452,0x7f},
	{0x9453,0x12},
	{0x9454,0x80},
	{0x9455,0x02},
	{0x9456,0x7f},
	{0x9457,0x02},
	{0x9458,0x8f},
	{0x9459,0x0a},
	{0x945a,0x80},
	{0x945b,0x03},
	{0x945c,0x75},
	{0x945d,0x0a},
	{0x945e,0xfe},
	{0x945f,0x90},
	{0x9460,0x30},
	{0x9461,0x27},
	{0x9462,0xe5},
	{0x9463,0x0a},
	{0x9464,0xf0},
	{0x9465,0xe5},
	{0x9466,0x23},
	{0x9467,0x54},
	{0x9468,0xf8},
	{0x9469,0xf5},
	{0x946a,0x0a},
	{0x946b,0xe5},
	{0x946c,0x78},
	{0x946d,0x25},
	{0x946e,0x0a},
	{0x946f,0xf5},
	{0x9470,0x0a},
	{0x9471,0x90},
	{0x9472,0x30},
	{0x9473,0x26},
	{0x9474,0xe5},
	{0x9475,0x0a},
	{0x9476,0xf0},
	{0x9477,0x22},
	{0x9478,0xe5},
	{0x9479,0x0a},
	{0x947a,0x70},
	{0x947b,0x04},
	{0x947c,0x7e},
	{0x947d,0x13},
	{0x947e,0x7f},
	{0x947f,0xbd},
	{0x9480,0xe5},
	{0x9481,0x0a},
	{0x9482,0xb4},
	{0x9483,0x01},
	{0x9484,0x04},
	{0x9485,0x7e},
	{0x9486,0x13},
	{0x9487,0x7f},
	{0x9488,0xc2},
	{0x9489,0xe5},
	{0x948a,0x0a},
	{0x948b,0xb4},
	{0x948c,0x02},
	{0x948d,0x04},
	{0x948e,0x7e},
	{0x948f,0x13},
	{0x9490,0x7f},
	{0x9491,0xc7},
	{0x9492,0x8f},
	{0x9493,0x82},
	{0x9494,0x8e},
	{0x9495,0x83},
	{0x9496,0xe4},
	{0x9497,0x93},
	{0x9498,0xf5},
	{0x9499,0x2c},
	{0x949a,0x74},
	{0x949b,0x01},
	{0x949c,0x93},
	{0x949d,0xf5},
	{0x949e,0x2d},
	{0x949f,0x74},
	{0x94a0,0x02},
	{0x94a1,0x93},
	{0x94a2,0xf5},
	{0x94a3,0x2e},
	{0x94a4,0x74},
	{0x94a5,0x03},
	{0x94a6,0x93},
	{0x94a7,0xf5},
	{0x94a8,0x2f},
	{0x94a9,0x74},
	{0x94aa,0x04},
	{0x94ab,0x93},
	{0x94ac,0xf5},
	{0x94ad,0x30},
	{0x94ae,0xe5},
	{0x94af,0x0a},
	{0x94b0,0xb4},
	{0x94b1,0x01},
	{0x94b2,0x07},
	{0x94b3,0x74},
	{0x94b4,0x2c},
	{0x94b5,0x25},
	{0x94b6,0x78},
	{0x94b7,0xf8},
	{0x94b8,0x76},
	{0x94b9,0x40},
	{0x94ba,0xe5},
	{0x94bb,0x0a},
	{0x94bc,0xb4},
	{0x94bd,0x02},
	{0x94be,0x07},
	{0x94bf,0x74},
	{0x94c0,0x2c},
	{0x94c1,0x25},
	{0x94c2,0x78},
	{0x94c3,0xf8},
	{0x94c4,0x76},
	{0x94c5,0x80},
	{0x94c6,0x22},
	{0x94c7,0xc2},
	{0x94c8,0xaf},
	{0x94c9,0x90},
	{0x94ca,0x30},
	{0x94cb,0x27},
	{0x94cc,0x74},
	{0x94cd,0xfa},
	{0x94ce,0xf0},
	{0x94cf,0x12},
	{0x94d0,0x0e},
	{0x94d1,0xb2},
	{0x94d2,0x12},
	{0x94d3,0x16},
	{0x94d4,0x15},
	{0x94d5,0xe4},
	{0x94d6,0xf5},
	{0x94d7,0x33},
	{0x94d8,0xd2},
	{0x94d9,0xaf},
	{0x94da,0x12},
	{0x94db,0x0b},
	{0x94dc,0x67},
	{0x94dd,0x30},
	{0x94de,0x30},
	{0x94df,0x03},
	{0x94e0,0x12},
	{0x94e1,0x07},
	{0x94e2,0x02},
	{0x94e3,0x30},
	{0x94e4,0x34},
	{0x94e5,0x03},
	{0x94e6,0x12},
	{0x94e7,0x14},
	{0x94e8,0x27},
	{0x94e9,0x30},
	{0x94ea,0x3d},
	{0x94eb,0xee},
	{0x94ec,0xc2},
	{0x94ed,0x3d},
	{0x94ee,0xd2},
	{0x94ef,0x35},
	{0x94f0,0x30},
	{0x94f1,0x00},
	{0x94f2,0x05},
	{0x94f3,0x12},
	{0x94f4,0x15},
	{0x94f5,0xe8},
	{0x94f6,0x80},
	{0x94f7,0x17},
	{0x94f8,0x30},
	{0x94f9,0x07},
	{0x94fa,0x0b},
	{0x94fb,0x30},
	{0x94fc,0x06},
	{0x94fd,0x08},
	{0x94fe,0x20},
	{0x94ff,0x31},
	{0x9500,0x0e},
	{0x9501,0x12},
	{0x9502,0x11},
	{0x9503,0xe2},
	{0x9504,0x80},
	{0x9505,0x09},
	{0x9506,0x20},
	{0x9507,0x07},
	{0x9508,0x06},
	{0x9509,0x30},
	{0x950a,0x06},
	{0x950b,0x03},
	{0x950c,0x12},
	{0x950d,0x0d},
	{0x950e,0xb8},
	{0x950f,0xc2},
	{0x9510,0x35},
	{0x9511,0x80},
	{0x9512,0xc7},
	{0x9513,0xc0},
	{0x9514,0xe0},
	{0x9515,0xc0},
	{0x9516,0x83},
	{0x9517,0xc0},
	{0x9518,0x82},
	{0x9519,0xc0},
	{0x951a,0xd0},
	{0x951b,0x90},
	{0x951c,0x3f},
	{0x951d,0x0d},
	{0x951e,0xe0},
	{0x951f,0xf5},
	{0x9520,0x09},
	{0x9521,0xe5},
	{0x9522,0x09},
	{0x9523,0x30},
	{0x9524,0xe0},
	{0x9525,0x2e},
	{0x9526,0xe5},
	{0x9527,0x79},
	{0x9528,0xb4},
	{0x9529,0x01},
	{0x952a,0x09},
	{0x952b,0x90},
	{0x952c,0x3a},
	{0x952d,0x00},
	{0x952e,0xe0},
	{0x952f,0xf5},
	{0x9530,0x77},
	{0x9531,0x44},
	{0x9532,0x01},
	{0x9533,0xf0},
	{0x9534,0xe5},
	{0x9535,0x79},
	{0x9536,0xb4},
	{0x9537,0x03},
	{0x9538,0x09},
	{0x9539,0x90},
	{0x953a,0x3a},
	{0x953b,0x00},
	{0x953c,0xe0},
	{0x953d,0xf5},
	{0x953e,0x77},
	{0x953f,0x54},
	{0x9540,0xfe},
	{0x9541,0xf0},
	{0x9542,0xe5},
	{0x9543,0x79},
	{0x9544,0xb4},
	{0x9545,0x03},
	{0x9546,0x05},
	{0x9547,0x75},
	{0x9548,0x79},
	{0x9549,0x00},
	{0x954a,0x80},
	{0x954b,0x02},
	{0x954c,0x05},
	{0x954d,0x79},
	{0x954e,0x90},
	{0x954f,0x3f},
	{0x9550,0x0d},
	{0x9551,0x74},
	{0x9552,0x01},
	{0x9553,0xf0},
	{0x9554,0xd0},
	{0x9555,0xd0},
	{0x9556,0xd0},
	{0x9557,0x82},
	{0x9558,0xd0},
	{0x9559,0x83},
	{0x955a,0xd0},
	{0x955b,0xe0},
	{0x955c,0x32},
	{0x955d,0x90},
	{0x955e,0x50},
	{0x955f,0x27},
	{0x9560,0xe0},
	{0x9561,0x44},
	{0x9562,0x01},
	{0x9563,0xf0},
	{0x9564,0x90},
	{0x9565,0x50},
	{0x9566,0x34},
	{0x9567,0x74},
	{0x9568,0x80},
	{0x9569,0xf0},
	{0x956a,0xa3},
	{0x956b,0x74},
	{0x956c,0x2a},
	{0x956d,0xf0},
	{0x956e,0xa3},
	{0x956f,0x74},
	{0x9570,0x14},
	{0x9571,0xf0},
	{0x9572,0x90},
	{0x9573,0x50},
	{0x9574,0x30},
	{0x9575,0xe4},
	{0x9576,0xf0},
	{0x9577,0xa3},
	{0x9578,0x74},
	{0x9579,0x02},
	{0x957a,0xf0},
	{0x957b,0xa3},
	{0x957c,0xe4},
	{0x957d,0xf0},
	{0x957e,0xa3},
	{0x957f,0x74},
	{0x9580,0x80},
	{0x9581,0xf0},
	{0x9582,0xe4},
	{0x9583,0xf5},
	{0x9584,0x0a},
	{0x9585,0x12},
	{0x9586,0x12},
	{0x9587,0x48},
	{0x9588,0x75},
	{0x9589,0x78},
	{0x958a,0x02},
	{0x958b,0x75},
	{0x958c,0x0a},
	{0x958d,0x01},
	{0x958e,0x12},
	{0x958f,0x14},
	{0x9590,0x78},
	{0x9591,0xd2},
	{0x9592,0x18},
	{0x9593,0xd2},
	{0x9594,0x19},
	{0x9595,0xc2},
	{0x9596,0x3c},
	{0x9597,0xc2},
	{0x9598,0x3b},
	{0x9599,0xd2},
	{0x959a,0x1a},
	{0x959b,0xd2},
	{0x959c,0x38},
	{0x959d,0xd2},
	{0x959e,0x30},
	{0x959f,0xc2},
	{0x95a0,0x35},
	{0x95a1,0xc2},
	{0x95a2,0x3d},
	{0x95a3,0x22},
	{0x95a4,0x85},
	{0x95a5,0x13},
	{0x95a6,0x14},
	{0x95a7,0x7f},
	{0x95a8,0x08},
	{0x95a9,0xe5},
	{0x95aa,0x14},
	{0x95ab,0x30},
	{0x95ac,0xe7},
	{0x95ad,0x04},
	{0x95ae,0xd2},
	{0x95af,0x29},
	{0x95b0,0x80},
	{0x95b1,0x02},
	{0x95b2,0xc2},
	{0x95b3,0x29},
	{0x95b4,0x12},
	{0x95b5,0x01},
	{0x95b6,0x6c},
	{0x95b7,0x75},
	{0x95b8,0x51},
	{0x95b9,0x0a},
	{0x95ba,0xae},
	{0x95bb,0x51},
	{0x95bc,0x15},
	{0x95bd,0x51},
	{0x95be,0xee},
	{0x95bf,0x70},
	{0x95c0,0xf9},
	{0x95c1,0xe5},
	{0x95c2,0x14},
	{0x95c3,0x25},
	{0x95c4,0xe0},
	{0x95c5,0xf5},
	{0x95c6,0x14},
	{0x95c7,0xd2},
	{0x95c8,0x28},
	{0x95c9,0x12},
	{0x95ca,0x01},
	{0x95cb,0x6c},
	{0x95cc,0x75},
	{0x95cd,0x51},
	{0x95ce,0x0a},
	{0x95cf,0xae},
	{0x95d0,0x51},
	{0x95d1,0x15},
	{0x95d2,0x51},
	{0x95d3,0xee},
	{0x95d4,0x70},
	{0x95d5,0xf9},
	{0x95d6,0xc2},
	{0x95d7,0x28},
	{0x95d8,0x12},
	{0x95d9,0x01},
	{0x95da,0x6c},
	{0x95db,0x75},
	{0x95dc,0x51},
	{0x95dd,0x05},
	{0x95de,0xae},
	{0x95df,0x51},
	{0x95e0,0x15},
	{0x95e1,0x51},
	{0x95e2,0xee},
	{0x95e3,0x70},
	{0x95e4,0xf9},
	{0x95e5,0xdf},
	{0x95e6,0xc2},
	{0x95e7,0x22},
	{0x95e8,0xe5},
	{0x95e9,0x20},
	{0x95ea,0x54},
	{0x95eb,0x07},
	{0x95ec,0xff},
	{0x95ed,0xbf},
	{0x95ee,0x01},
	{0x95ef,0x03},
	{0x95f0,0x02},
	{0x95f1,0x10},
	{0x95f2,0x7e},
	{0x95f3,0xe5},
	{0x95f4,0x20},
	{0x95f5,0x54},
	{0x95f6,0x07},
	{0x95f7,0xff},
	{0x95f8,0xbf},
	{0x95f9,0x07},
	{0x95fa,0x03},
	{0x95fb,0x02},
	{0x95fc,0x11},
	{0x95fd,0x7c},
	{0x95fe,0xe5},
	{0x95ff,0x20},
	{0x9600,0x54},
	{0x9601,0x07},
	{0x9602,0xff},
	{0x9603,0xbf},
	{0x9604,0x03},
	{0x9605,0x03},
	{0x9606,0x02},
	{0x9607,0x13},
	{0x9608,0xcc},
	{0x9609,0xe5},
	{0x960a,0x20},
	{0x960b,0x54},
	{0x960c,0x07},
	{0x960d,0xff},
	{0x960e,0xbf},
	{0x960f,0x05},
	{0x9610,0x03},
	{0x9611,0x12},
	{0x9612,0x16},
	{0x9613,0xe2},
	{0x9614,0x22},
	{0x9615,0x12},
	{0x9616,0x15},
	{0x9617,0x5d},
	{0x9618,0x12},
	{0x9619,0x16},
	{0x961a,0xf0},
	{0x961b,0x50},
	{0x961c,0x04},
	{0x961d,0xd2},
	{0x961e,0x05},
	{0x961f,0x80},
	{0x9620,0x02},
	{0x9621,0xc2},
	{0x9622,0x05},
	{0x9623,0x12},
	{0x9624,0x02},
	{0x9625,0x40},
	{0x9626,0xc2},
	{0x9627,0x39},
	{0x9628,0xc2},
	{0x9629,0x36},
	{0x962a,0xc2},
	{0x962b,0x31},
	{0x962c,0xd2},
	{0x962d,0x34},
	{0x962e,0x12},
	{0x962f,0x02},
	{0x9630,0x85},
	{0x9631,0xb5},
	{0x9632,0x07},
	{0x9633,0x03},
	{0x9634,0xd3},
	{0x9635,0x80},
	{0x9636,0x01},
	{0x9637,0xc3},
	{0x9638,0x40},
	{0x9639,0x02},
	{0x963a,0xc2},
	{0x963b,0x05},
	{0x963c,0x22},
	{0x963d,0xe4},
	{0x963e,0xff},
	{0x963f,0xfe},
	{0x9640,0xc3},
	{0x9641,0xef},
	{0x9642,0x95},
	{0x9643,0x11},
	{0x9644,0xee},
	{0x9645,0x95},
	{0x9646,0x10},
	{0x9647,0x50},
	{0x9648,0x15},
	{0x9649,0x7d},
	{0x964a,0x8a},
	{0x964b,0x7c},
	{0x964c,0x02},
	{0x964d,0xed},
	{0x964e,0x1d},
	{0x964f,0xaa},
	{0x9650,0x04},
	{0x9651,0x70},
	{0x9652,0x01},
	{0x9653,0x1c},
	{0x9654,0x4a},
	{0x9655,0x70},
	{0x9656,0xf6},
	{0x9657,0x0f},
	{0x9658,0xbf},
	{0x9659,0x00},
	{0x965a,0x01},
	{0x965b,0x0e},
	{0x965c,0x80},
	{0x965d,0xe2},
	{0x965e,0x22},
	{0x965f,0xc2},
	{0x9660,0x03},
	{0x9661,0xd2},
	{0x9662,0x04},
	{0x9663,0x12},
	{0x9664,0x02},
	{0x9665,0xa5},
	{0x9666,0x30},
	{0x9667,0x07},
	{0x9668,0x05},
	{0x9669,0x30},
	{0x966a,0x06},
	{0x966b,0x02},
	{0x966c,0xd2},
	{0x966d,0x36},
	{0x966e,0xc2},
	{0x966f,0x3e},
	{0x9670,0x12},
	{0x9671,0x0f},
	{0x9672,0xf1},
	{0x9673,0xc2},
	{0x9674,0x3e},
	{0x9675,0x12},
	{0x9676,0x12},
	{0x9677,0xad},
	{0x9678,0xd2},
	{0x9679,0x34},
	{0x967a,0x22},
	{0x967b,0x75},
	{0x967c,0x48},
	{0x967d,0x13},
	{0x967e,0x75},
	{0x967f,0x49},
	{0x9680,0x73},
	{0x9681,0x90},
	{0x9682,0x13},
	{0x9683,0x71},
	{0x9684,0xe4},
	{0x9685,0x93},
	{0x9686,0xf5},
	{0x9687,0x7b},
	{0x9688,0xa3},
	{0x9689,0xe4},
	{0x968a,0x93},
	{0x968b,0xf5},
	{0x968c,0x32},
	{0x968d,0xc2},
	{0x968e,0x3a},
	{0x968f,0x22},
	{0x9690,0xe4},
	{0x9691,0xff},
	{0x9692,0xef},
	{0x9693,0x25},
	{0x9694,0xe0},
	{0x9695,0x24},
	{0x9696,0x56},
	{0x9697,0xf8},
	{0x9698,0xe4},
	{0x9699,0xf6},
	{0x969a,0x08},
	{0x969b,0xf6},
	{0x969c,0x0f},
	{0x969d,0xbf},
	{0x969e,0x07},
	{0x969f,0xf2},
	{0x96a0,0x53},
	{0x96a1,0x24},
	{0x96a2,0x80},
	{0x96a3,0x22},
	{0x96a4,0xe5},
	{0x96a5,0x7c},
	{0x96a6,0xc3},
	{0x96a7,0x95},
	{0x96a8,0x7b},
	{0x96a9,0x40},
	{0x96aa,0x01},
	{0x96ab,0x22},
	{0x96ac,0xe5},
	{0x96ad,0x7c},
	{0x96ae,0x04},
	{0x96af,0xf5},
	{0x96b0,0x0c},
	{0x96b1,0x12},
	{0x96b2,0x0f},
	{0x96b3,0x52},
	{0x96b4,0x22},
	{0x96b5,0xe5},
	{0x96b6,0x7c},
	{0x96b7,0x70},
	{0x96b8,0x02},
	{0x96b9,0xc3},
	{0x96ba,0x22},
	{0x96bb,0xe5},
	{0x96bc,0x7c},
	{0x96bd,0x14},
	{0x96be,0xf5},
	{0x96bf,0x0c},
	{0x96c0,0x12},
	{0x96c1,0x0f},
	{0x96c2,0x52},
	{0x96c3,0x22},
	{0x96c4,0xe5},
	{0x96c5,0x7d},
	{0x96c6,0xb4},
	{0x96c7,0x01},
	{0x96c8,0x09},
	{0x96c9,0x12},
	{0x96ca,0x16},
	{0x96cb,0x7b},
	{0x96cc,0xe4},
	{0x96cd,0xf5},
	{0x96ce,0x0c},
	{0x96cf,0x12},
	{0x96d0,0x0f},
	{0x96d1,0x52},
	{0x96d2,0x22},
	{0x96d3,0xe5},
	{0x96d4,0x7d},
	{0x96d5,0x24},
	{0x96d6,0xfe},
	{0x96d7,0x60},
	{0x96d8,0x06},
	{0x96d9,0x04},
	{0x96da,0x70},
	{0x96db,0x05},
	{0x96dc,0xd2},
	{0x96dd,0x39},
	{0x96de,0x22},
	{0x96df,0xc2},
	{0x96e0,0x39},
	{0x96e1,0x22},
	{0x96e2,0xe5},
	{0x96e3,0x31},
	{0x96e4,0xd3},
	{0x96e5,0x94},
	{0x96e6,0x00},
	{0x96e7,0x40},
	{0x96e8,0x03},
	{0x96e9,0x15},
	{0x96ea,0x31},
	{0x96eb,0x22},
	{0x96ec,0x12},
	{0x96ed,0x16},
	{0x96ee,0x5f},
	{0x96ef,0x22},
	{0x96f0,0x12},
	{0x96f1,0x16},
	{0x96f2,0x7b},
	{0x96f3,0xe4},
	{0x96f4,0xf5},
	{0x96f5,0x0c},
	{0x96f6,0x12},
	{0x96f7,0x0f},
	{0x96f8,0x52},
	{0x96f9,0x22},
	{0x3024,0x00},
	{0x3025,0x00},
	{0x5082,0x00},
	{0x5083,0x00},
	{0x5084,0x00},
	{0x5085,0x00},
	{0x3026,0x00},
	{0x3027,0xFF},
	{0x3000,0x00},
	{0x0000,0x00}
};
#endif

