 /*
  * drivers/media/video/hm5065.c
  *
  * Copyright (C) ROCKCHIP, Inc.
  * This software is licensed under the terms of the GNU General Public
  * License version 2, as published by the Free Software Foundation, and
  * may be copied, distributed, and modified under those terms.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  */

 #include "generic_sensor.h"

/*
*      Driver Version Note
*v0.0.1: this driver is compatible with generic_sensor
*v0.1.1:
*        add sensor_focus_af_const_pause_usr_cb;
*/
static int version = KERNEL_VERSION(0,1,1);
module_param(version, int, S_IRUGO);


static int debug=1;
module_param(debug, int, S_IRUGO|S_IWUSR);

#define dprintk(level, fmt, arg...) do {			\
	if (debug >= level) 					\
	printk(KERN_WARNING fmt , ## arg); } while (0)

/* Sensor Driver Configuration Begin */
#define SENSOR_NAME RK29_CAM_SENSOR_HM5065
#define SENSOR_V4L2_IDENT V4L2_IDENT_HM5065
#define SENSOR_ID 0x039E
#define SENSOR_BUS_PARAM                     (V4L2_MBUS_MASTER |\
															 V4L2_MBUS_PCLK_SAMPLE_RISING|V4L2_MBUS_HSYNC_ACTIVE_HIGH| V4L2_MBUS_VSYNC_ACTIVE_LOW|\
															 V4L2_MBUS_DATA_ACTIVE_HIGH  |SOCAM_MCLK_24MHZ)
#define SENSOR_PREVIEW_W					1280 //800
#define SENSOR_PREVIEW_H					 960//600
#define SENSOR_PREVIEW_FPS					 15000	   // 15fps 
#define SENSOR_FULLRES_L_FPS				 7500	   // 7.5fps
#define SENSOR_FULLRES_H_FPS				 7500	   // 7.5fps
#define SENSOR_720P_FPS 					 30000
#define SENSOR_1080P_FPS					 15000

#define SENSOR_REGISTER_LEN 				 2		   // sensor register address bytes
#define SENSOR_VALUE_LEN					 1		   // sensor register value bytes

#define  SENSOR_AF_CONFIG     1

#ifdef 	SENSOR_AF_CONFIG								
static unsigned int SensorConfiguration = (CFG_WhiteBalance|CFG_Effect
                                           |CFG_Scene|CFG_Focus|CFG_FocusContinues
                                           |CFG_FocusZone);

#else
static unsigned int SensorConfiguration = (CFG_WhiteBalance|CFG_Effect
                                           |CFG_Scene);
#endif

static unsigned int SensorChipID[] = {SENSOR_ID};
/* Sensor Driver Configuration End */


#define SENSOR_NAME_STRING(a) STR(CONS(SENSOR_NAME, a))
#define SENSOR_NAME_VARFUN(a) CONS(SENSOR_NAME, a)

#define SensorRegVal(a,b) CONS4(SensorReg,SENSOR_REGISTER_LEN,Val,SENSOR_VALUE_LEN)(a,b)
#define sensor_write(client,reg,v) CONS4(sensor_write_reg,SENSOR_REGISTER_LEN,val,SENSOR_VALUE_LEN)(client,(reg),(v))
#define sensor_read(client,reg,v) CONS4(sensor_read_reg,SENSOR_REGISTER_LEN,val,SENSOR_VALUE_LEN)(client,(reg),(v))
#define sensor_write_array generic_sensor_write_array


/* hm5065 VCM Command and Status Registers */
#define AF_TARGETPOS_REG_H         0x0700
#define AF_TARGETPOS_REG_L         0x0701

#define AF_MODES_REG               0x070A
#define AF_AUTOCMDS_REG            0x070b
#define AF_LENSPOS_REG_H           0x06F0
#define AF_LENSPOS_REG_L           0x06F1
#define AF_MANUCMDS_REG            0x070c
#define AF_FINISHCHK_REG           0x07ae   //[0]: false    [1] : true

#define FACE_LC                    0x0714   //[0] : focus , [1] : AE 
#define FACE_START_XH 	           0x0715
#define FACE_START_XL 	           0x0716
#define FACE_SIZE_XH  	           0x0717
#define FACE_SIZE_XL	           0x0718
#define FACE_START_YH	           0x0719
#define FACE_START_YL	           0x071A
#define FACE_SIZE_YH	           0x071B
#define FACE_SIZE_YL 	           0x071C


#define AF_ZONE0_WEIGHT            0x0808
#define AF_ZONE1_WEIGHT            0x0809
#define AF_ZONE2_WEIGHT            0x080A
#define AF_ZONE3_WEIGHT            0x080B
#define AF_ZONE4_WEIGHT            0x080C
#define AF_ZONE5_WEIGHT            0x080D
#define AF_ZONE6_WEIGHT            0x080E


struct sensor_parameter
{
    int af_pos[2];
};

struct specific_sensor{
	struct generic_sensor common_sensor;
	//define user data below
	struct sensor_parameter parameter;

};

/*
*  The follow setting need been filled.
*  
*  Must Filled:
*  sensor_init_data :				Sensor initial setting;
*  sensor_fullres_lowfps_data : 	Sensor full resolution setting with best auality, recommand for video;
*  sensor_preview_data :			Sensor preview resolution setting, recommand it is vga or svga;
*  sensor_softreset_data :			Sensor software reset register;
*  sensor_check_id_data :			Sensir chip id register;
*
*  Optional filled:
*  sensor_fullres_highfps_data: 	Sensor full resolution setting with high framerate, recommand for video;
*  sensor_720p: 					Sensor 720p setting, it is for video;
*  sensor_1080p:					Sensor 1080p setting, it is for video;
*
*  :::::WARNING:::::
*  The SensorEnd which is the setting end flag must be filled int the last of each setting;
*/

/* Sensor initial setting */
static struct rk_sensor_reg sensor_init_data[] = {

	{0xffff,0x01},    // 2013-03-01 Start new patch 
	{0x9000,0x03}, 
	{0xA000,0x90}, 
	{0xA001,0x0C}, 
	{0xA002,0x56}, 
	{0xA003,0xE0}, 
	{0xA004,0xFE}, 
	{0xA005,0xA3}, 
	{0xA006,0xE0}, 
	{0xA007,0xFF}, 
	{0xA008,0x12}, 
	{0xA009,0x42}, 
	{0xA00A,0x85}, 
	{0xA00B,0x90}, 
	{0xA00C,0x01}, 
	{0xA00D,0xB7}, 
	{0xA00E,0xEE}, 
	{0xA00F,0xF0}, 
	{0xA010,0xFC}, 
	{0xA011,0xA3}, 
	{0xA012,0xEF}, 
	{0xA013,0xF0}, 
	{0xA014,0xFD}, 
	{0xA015,0x90}, 
	{0xA016,0x06}, 
	{0xA017,0x05}, 
	{0xA018,0xE0}, 
	{0xA019,0x75}, 
	{0xA01A,0xF0}, 
	{0xA01B,0x02}, 
	{0xA01C,0xA4}, 
	{0xA01D,0x2D}, 
	{0xA01E,0xFF}, 
	{0xA01F,0xE5}, 
	{0xA020,0xF0}, 
	{0xA021,0x3C}, 
	{0xA022,0xFE}, 
	{0xA023,0xAB}, 
	{0xA024,0x07}, 
	{0xA025,0xFA}, 
	{0xA026,0x33}, 
	{0xA027,0x95}, 
	{0xA028,0xE0}, 
	{0xA029,0xF9}, 
	{0xA02A,0xF8}, 
	{0xA02B,0x90}, 
	{0xA02C,0x0B}, 
	{0xA02D,0x4B}, 
	{0xA02E,0xE0}, 
	{0xA02F,0xFE}, 
	{0xA030,0xA3}, 
	{0xA031,0xE0}, 
	{0xA032,0xFF}, 
	{0xA033,0xEE}, 
	{0xA034,0x33}, 
	{0xA035,0x95}, 
	{0xA036,0xE0}, 
	{0xA037,0xFD}, 
	{0xA038,0xFC}, 
	{0xA039,0x12}, 
	{0xA03A,0x0C}, 
	{0xA03B,0x7B}, 
	{0xA03C,0x90}, 
	{0xA03D,0x01}, 
	{0xA03E,0xB9}, 
	{0xA03F,0x12}, 
	{0xA040,0x0E}, 
	{0xA041,0x05}, 
	{0xA042,0x90}, 
	{0xA043,0x01}, 
	{0xA044,0xB9}, 
	{0xA045,0xE0}, 
	{0xA046,0xFC}, 
	{0xA047,0xA3}, 
	{0xA048,0xE0}, 
	{0xA049,0xFD}, 
	{0xA04A,0xA3}, 
	{0xA04B,0xE0}, 
	{0xA04C,0xFE}, 
	{0xA04D,0xA3}, 
	{0xA04E,0xE0}, 
	{0xA04F,0xFF}, 
	{0xA050,0x78}, 
	{0xA051,0x08}, 
	{0xA052,0x12}, 
	{0xA053,0x0D}, 
	{0xA054,0xBF}, 
	{0xA055,0xA8}, 
	{0xA056,0x04}, 
	{0xA057,0xA9}, 
	{0xA058,0x05}, 
	{0xA059,0xAA}, 
	{0xA05A,0x06}, 
	{0xA05B,0xAB}, 
	{0xA05C,0x07}, 
	{0xA05D,0x90}, 
	{0xA05E,0x0B}, 
	{0xA05F,0x49}, 
	{0xA060,0xE0}, 
	{0xA061,0xFE}, 
	{0xA062,0xA3}, 
	{0xA063,0xE0}, 
	{0xA064,0xFF}, 
	{0xA065,0xEE}, 
	{0xA066,0x33}, 
	{0xA067,0x95}, 
	{0xA068,0xE0}, 
	{0xA069,0xFD}, 
	{0xA06A,0xFC}, 
	{0xA06B,0xC3}, 
	{0xA06C,0xEF}, 
	{0xA06D,0x9B}, 
	{0xA06E,0xFF}, 
	{0xA06F,0xEE}, 
	{0xA070,0x9A}, 
	{0xA071,0xFE}, 
	{0xA072,0xED}, 
	{0xA073,0x99}, 
	{0xA074,0xFD}, 
	{0xA075,0xEC}, 
	{0xA076,0x98}, 
	{0xA077,0xFC}, 
	{0xA078,0x78}, 
	{0xA079,0x01}, 
	{0xA07A,0x12}, 
	{0xA07B,0x0D}, 
	{0xA07C,0xBF}, 
	{0xA07D,0x90}, 
	{0xA07E,0x0C}, 
	{0xA07F,0x4A}, 
	{0xA080,0xE0}, 
	{0xA081,0xFC}, 
	{0xA082,0xA3}, 
	{0xA083,0xE0}, 
	{0xA084,0xF5}, 
	{0xA085,0x82}, 
	{0xA086,0x8C}, 
	{0xA087,0x83}, 
	{0xA088,0xC0}, 
	{0xA089,0x83}, 
	{0xA08A,0xC0}, 
	{0xA08B,0x82}, 
	{0xA08C,0x90}, 
	{0xA08D,0x0B}, 
	{0xA08E,0x48}, 
	{0xA08F,0xE0}, 
	{0xA090,0xD0}, 
	{0xA091,0x82}, 
	{0xA092,0xD0}, 
	{0xA093,0x83}, 
	{0xA094,0x75}, 
	{0xA095,0xF0}, 
	{0xA096,0x02}, 
	{0xA097,0x12}, 
	{0xA098,0x0E}, 
	{0xA099,0x45}, 
	{0xA09A,0xEE}, 
	{0xA09B,0xF0}, 
	{0xA09C,0xA3}, 
	{0xA09D,0xEF}, 
	{0xA09E,0xF0}, 
	{0xA09F,0x02}, 
	{0xA0A0,0xBA}, 
	{0xA0A1,0xD8}, 
	{0xA0A2,0x90}, 
	{0xA0A3,0x30}, 
	{0xA0A4,0x18}, 
	{0xA0A5,0xe4}, 
	{0xA0A6,0xf0}, 
	{0xA0A7,0x74}, 
	{0xA0A8,0x3f}, 
	{0xA0A9,0xf0}, 
	{0xA0AA,0x22}, 
	{0xA0BF,0x90}, 
	{0xA0C0,0x00}, 
	{0xA0C1,0x5E}, 
	{0xA0C2,0xE0}, 
	{0xA0C3,0xFF}, 
	{0xA0C4,0x70}, 
	{0xA0C5,0x20}, 
	{0xA0C6,0x90}, 
	{0xA0C7,0x47}, 
	{0xA0C8,0x04}, 
	{0xA0C9,0x74}, 
	{0xA0CA,0x0A}, 
	{0xA0CB,0xF0}, 
	{0xA0CC,0xA3}, 
	{0xA0CD,0x74}, 
	{0xA0CE,0x30}, 
	{0xA0CF,0xF0}, 
	{0xA0D0,0x90}, 
	{0xA0D1,0x47}, 
	{0xA0D2,0x0C}, 
	{0xA0D3,0x74}, 
	{0xA0D4,0x07}, 
	{0xA0D5,0xF0}, 
	{0xA0D6,0xA3}, 
	{0xA0D7,0x74}, 
	{0xA0D8,0xA8}, 
	{0xA0D9,0xF0}, 
	{0xA0DA,0x90}, 
	{0xA0DB,0x47}, 
	{0xA0DC,0xA4}, 
	{0xA0DD,0x74}, 
	{0xA0DE,0x01}, 
	{0xA0DF,0xF0}, 
	{0xA0E0,0x90}, 
	{0xA0E1,0x47}, 
	{0xA0E2,0xA8}, 
	{0xA0E3,0xF0}, 
	{0xA0E4,0x80}, 
	{0xA0E5,0x50}, 
	{0xA0E6,0xEF}, 
	{0xA0E7,0x64}, 
	{0xA0E8,0x01}, 
	{0xA0E9,0x60}, 
	{0xA0EA,0x04}, 
	{0xA0EB,0xEF}, 
	{0xA0EC,0xB4}, 
	{0xA0ED,0x03}, 
	{0xA0EE,0x20}, 
	{0xA0EF,0x90}, 
	{0xA0F0,0x47}, 
	{0xA0F1,0x04}, 
	{0xA0F2,0x74}, 
	{0xA0F3,0x05}, 
	{0xA0F4,0xF0}, 
	{0xA0F5,0xA3}, 
	{0xA0F6,0x74}, 
	{0xA0F7,0x18}, 
	{0xA0F8,0xF0}, 
	{0xA0F9,0x90}, 
	{0xA0FA,0x47}, 
	{0xA0FB,0x0C}, 
	{0xA0FC,0x74}, 
	{0xA0FD,0x03}, 
	{0xA0FE,0xF0}, 
	{0xA0FF,0xA3}, 
	{0xA100,0x74}, 
	{0xA101,0xD4}, 
	{0xA102,0xF0}, 
	{0xA103,0x90}, 
	{0xA104,0x47}, 
	{0xA105,0xA4}, 
	{0xA106,0x74}, 
	{0xA107,0x02}, 
	{0xA108,0xF0}, 
	{0xA109,0x90}, 
	{0xA10A,0x47}, 
	{0xA10B,0xA8}, 
	{0xA10C,0xF0}, 
	{0xA10D,0x80}, 
	{0xA10E,0x27}, 
	{0xA10F,0xEF}, 
	{0xA110,0x64}, 
	{0xA111,0x02}, 
	{0xA112,0x60}, 
	{0xA113,0x04}, 
	{0xA114,0xEF}, 
	{0xA115,0xB4}, 
	{0xA116,0x04}, 
	{0xA117,0x1E}, 
	{0xA118,0x90}, 
	{0xA119,0x47}, 
	{0xA11A,0x04}, 
	{0xA11B,0x74}, 
	{0xA11C,0x02}, 
	{0xA11D,0xF0}, 
	{0xA11E,0xA3}, 
	{0xA11F,0x74}, 
	{0xA120,0x8C}, 
	{0xA121,0xF0}, 
	{0xA122,0x90}, 
	{0xA123,0x47}, 
	{0xA124,0x0C}, 
	{0xA125,0x74}, 
	{0xA126,0x01}, 
	{0xA127,0xF0}, 
	{0xA128,0xA3}, 
	{0xA129,0x74}, 
	{0xA12A,0xEA}, 
	{0xA12B,0xF0}, 
	{0xA12C,0x90}, 
	{0xA12D,0x47}, 
	{0xA12E,0xA4}, 
	{0xA12F,0x74}, 
	{0xA130,0x04}, 
	{0xA131,0xF0}, 
	{0xA132,0x90}, 
	{0xA133,0x47}, 
	{0xA134,0xA8}, 
	{0xA135,0xF0}, 
	{0xA136,0x22}, 
	{0xA137,0x74}, 
	{0xA138,0x04}, 
	{0xA139,0xF0}, 
	{0xA13A,0xA3}, 
	{0xA13B,0x74}, 
	{0xA13C,0x20}, 
	{0xA13D,0xF0}, 
	{0xA13E,0xE4}, 
	{0xA13F,0xF5}, 
	{0xA140,0x22}, 
	{0xA141,0xE5}, 
	{0xA142,0x22}, 
	{0xA143,0xC3}, 
	{0xA144,0x94}, 
	{0xA145,0x40}, 
	{0xA146,0x40}, 
	{0xA147,0x03}, 
	{0xA148,0x02}, 
	{0xA149,0xF1}, 
	{0xA14A,0xFD}, 
	{0xA14B,0x90}, 
	{0xA14C,0x0A}, 
	{0xA14D,0xBA}, 
	{0xA14E,0xE0}, 
	{0xA14F,0xFE}, 
	{0xA150,0xA3}, 
	{0xA151,0xE0}, 
	{0xA152,0xFF}, 
	{0xA153,0xF5}, 
	{0xA154,0x82}, 
	{0xA155,0x8E}, 
	{0xA156,0x83}, 
	{0xA157,0xE0}, 
	{0xA158,0x54}, 
	{0xA159,0x70}, 
	{0xA15A,0xFD}, 
	{0xA15B,0xC4}, 
	{0xA15C,0x54}, 
	{0xA15D,0x0F}, 
	{0xA15E,0xFD}, 
	{0xA15F,0x90}, 
	{0xA160,0x0A}, 
	{0xA161,0xBC}, 
	{0xA162,0xE0}, 
	{0xA163,0xFA}, 
	{0xA164,0xA3}, 
	{0xA165,0xE0}, 
	{0xA166,0xF5}, 
	{0xA167,0x82}, 
	{0xA168,0x8A}, 
	{0xA169,0x83}, 
	{0xA16A,0xED}, 
	{0xA16B,0xF0}, 
	{0xA16C,0x90}, 
	{0xA16D,0x0A}, 
	{0xA16E,0xBD}, 
	{0xA16F,0xE0}, 
	{0xA170,0x04}, 
	{0xA171,0xF0}, 
	{0xA172,0x70}, 
	{0xA173,0x06}, 
	{0xA174,0x90}, 
	{0xA175,0x0A}, 
	{0xA176,0xBC}, 
	{0xA177,0xE0}, 
	{0xA178,0x04}, 
	{0xA179,0xF0}, 
	{0xA17A,0x8F}, 
	{0xA17B,0x82}, 
	{0xA17C,0x8E}, 
	{0xA17D,0x83}, 
	{0xA17E,0xA3}, 
	{0xA17F,0xE0}, 
	{0xA180,0xFF}, 
	{0xA181,0x90}, 
	{0xA182,0x0A}, 
	{0xA183,0xBC}, 
	{0xA184,0xE0}, 
	{0xA185,0xFC}, 
	{0xA186,0xA3}, 
	{0xA187,0xE0}, 
	{0xA188,0xF5}, 
	{0xA189,0x82}, 
	{0xA18A,0x8C}, 
	{0xA18B,0x83}, 
	{0xA18C,0xEF}, 
	{0xA18D,0xF0}, 
	{0xA18E,0x90}, 
	{0xA18F,0x0A}, 
	{0xA190,0xBD}, 
	{0xA191,0xE0}, 
	{0xA192,0x04}, 
	{0xA193,0xF0}, 
	{0xA194,0x70}, 
	{0xA195,0x06}, 
	{0xA196,0x90}, 
	{0xA197,0x0A}, 
	{0xA198,0xBC}, 
	{0xA199,0xE0}, 
	{0xA19A,0x04}, 
	{0xA19B,0xF0}, 
	{0xA19C,0x90}, 
	{0xA19D,0x0A}, 
	{0xA19E,0xBA}, 
	{0xA19F,0xE0}, 
	{0xA1A0,0xFE}, 
	{0xA1A1,0xA3}, 
	{0xA1A2,0xE0}, 
	{0xA1A3,0xFF}, 
	{0xA1A4,0xF5}, 
	{0xA1A5,0x82}, 
	{0xA1A6,0x8E}, 
	{0xA1A7,0x83}, 
	{0xA1A8,0xE0}, 
	{0xA1A9,0x54}, 
	{0xA1AA,0x07}, 
	{0xA1AB,0xFD}, 
	{0xA1AC,0x90}, 
	{0xA1AD,0x0A}, 
	{0xA1AE,0xBC}, 
	{0xA1AF,0xE0}, 
	{0xA1B0,0xFA}, 
	{0xA1B1,0xA3}, 
	{0xA1B2,0xE0}, 
	{0xA1B3,0xF5}, 
	{0xA1B4,0x82}, 
	{0xA1B5,0x8A}, 
	{0xA1B6,0x83}, 
	{0xA1B7,0xED}, 
	{0xA1B8,0xF0}, 
	{0xA1B9,0x90}, 
	{0xA1BA,0x0A}, 
	{0xA1BB,0xBD}, 
	{0xA1BC,0xE0}, 
	{0xA1BD,0x04}, 
	{0xA1BE,0xF0}, 
	{0xA1BF,0x70}, 
	{0xA1C0,0x06}, 
	{0xA1C1,0x90}, 
	{0xA1C2,0x0A}, 
	{0xA1C3,0xBC}, 
	{0xA1C4,0xE0}, 
	{0xA1C5,0x04}, 
	{0xA1C6,0xF0}, 
	{0xA1C7,0x8F}, 
	{0xA1C8,0x82}, 
	{0xA1C9,0x8E}, 
	{0xA1CA,0x83}, 
	{0xA1CB,0xA3}, 
	{0xA1CC,0xA3}, 
	{0xA1CD,0xE0}, 
	{0xA1CE,0xFF}, 
	{0xA1CF,0x90}, 
	{0xA1D0,0x0A}, 
	{0xA1D1,0xBC}, 
	{0xA1D2,0xE0}, 
	{0xA1D3,0xFC}, 
	{0xA1D4,0xA3}, 
	{0xA1D5,0xE0}, 
	{0xA1D6,0xF5}, 
	{0xA1D7,0x82}, 
	{0xA1D8,0x8C}, 
	{0xA1D9,0x83}, 
	{0xA1DA,0xEF}, 
	{0xA1DB,0xF0}, 
	{0xA1DC,0x90}, 
	{0xA1DD,0x0A}, 
	{0xA1DE,0xBD}, 
	{0xA1DF,0xE0}, 
	{0xA1E0,0x04}, 
	{0xA1E1,0xF0}, 
	{0xA1E2,0x70}, 
	{0xA1E3,0x06}, 
	{0xA1E4,0x90}, 
	{0xA1E5,0x0A}, 
	{0xA1E6,0xBC}, 
	{0xA1E7,0xE0}, 
	{0xA1E8,0x04}, 
	{0xA1E9,0xF0}, 
	{0xA1EA,0x90}, 
	{0xA1EB,0x0A}, 
	{0xA1EC,0xBB}, 
	{0xA1ED,0xE0}, 
	{0xA1EE,0x24}, 
	{0xA1EF,0x03}, 
	{0xA1F0,0xF0}, 
	{0xA1F1,0x90}, 
	{0xA1F2,0x0A}, 
	{0xA1F3,0xBA}, 
	{0xA1F4,0xE0}, 
	{0xA1F5,0x34}, 
	{0xA1F6,0x00}, 
	{0xA1F7,0xF0}, 
	{0xA1F8,0x05}, 
	{0xA1F9,0x22}, 
	{0xA1FA,0x02}, 
	{0xA1FB,0xF1}, 
	{0xA1FC,0x41}, 
	{0xA1FD,0x90}, 
	{0xA1FE,0x0A}, 
	{0xA1FF,0xBA}, 
	{0xA200,0x74}, 
	{0xA201,0x0E}, 
	{0xA202,0xF0}, 
	{0xA203,0xA3}, 
	{0xA204,0x74}, 
	{0xA205,0xDC}, 
	{0xA206,0xF0}, 
	{0xA207,0xA3}, 
	{0xA208,0x74}, 
	{0xA209,0x05}, 
	{0xA20A,0xF0}, 
	{0xA20B,0xA3}, 
	{0xA20C,0x74}, 
	{0xA20D,0x61}, 
	{0xA20E,0xF0}, 
	{0xA20F,0x90}, 
	{0xA210,0x0A}, 
	{0xA211,0xBA}, 
	{0xA212,0xE0}, 
	{0xA213,0xFE}, 
	{0xA214,0xA3}, 
	{0xA215,0xE0}, 
	{0xA216,0xAA}, 
	{0xA217,0x06}, 
	{0xA218,0xF9}, 
	{0xA219,0x7B}, 
	{0xA21A,0x01}, 
	{0xA21B,0xC0}, 
	{0xA21C,0x02}, 
	{0xA21D,0xA3}, 
	{0xA21E,0xE0}, 
	{0xA21F,0xFE}, 
	{0xA220,0xA3}, 
	{0xA221,0xE0}, 
	{0xA222,0xAA}, 
	{0xA223,0x06}, 
	{0xA224,0xF8}, 
	{0xA225,0xAC}, 
	{0xA226,0x02}, 
	{0xA227,0x7D}, 
	{0xA228,0x01}, 
	{0xA229,0xD0}, 
	{0xA22A,0x02}, 
	{0xA22B,0x7E}, 
	{0xA22C,0x00}, 
	{0xA22D,0x7F}, 
	{0xA22E,0x04}, 
	{0xA22F,0x12}, 
	{0xA230,0x0F}, 
	{0xA231,0x6F}, 
	{0xA232,0x02}, 
	{0xA233,0x66}, 
	{0xA234,0xD9}, 
	{0xA235,0x90}, 
	{0xA236,0x07}, 
	{0xA237,0xD0}, 
	{0xA238,0x02}, 
	{0xA239,0xA2}, 
	{0xA23A,0x69}, 
	{0xA240,0x02}, 
	{0xA241,0x21}, 
	{0xA242,0x7F}, 
	{0xA243,0x02}, 
	{0xA244,0x21}, 
	{0xA245,0xF4}, 
	{0xA246,0x02}, 
	{0xA247,0xA6}, 
	{0xA248,0x15}, 
	{0xA249,0x60}, 
	{0xA24A,0x0A}, 
	{0xA24B,0xEF}, 
	{0xA24C,0xB4}, 
	{0xA24D,0x01}, 
	{0xA24E,0x16}, 
	{0xA24F,0x90}, 
	{0xA250,0x00}, 
	{0xA251,0x5D}, 
	{0xA252,0xE0}, 
	{0xA253,0x70}, 
	{0xA254,0x10}, 
	{0xA255,0x12}, 
	{0xA256,0x26}, 
	{0xA257,0xC8}, 
	{0xA258,0x90}, 
	{0xA259,0x00}, 
	{0xA25A,0x11}, 
	{0xA25B,0x74}, 
	{0xA25C,0x30}, 
	{0xA25D,0xF0}, 
	{0xA25E,0x90}, 
	{0xA25F,0x00}, 
	{0xA260,0x10}, 
	{0xA261,0x74}, 
	{0xA262,0x01}, 
	{0xA263,0xF0}, 
	{0xA264,0x22}, 
	{0xA265,0x12}, 
	{0xA266,0x25}, 
	{0xA267,0xA8}, 
	{0xA268,0x02}, 
	{0xA269,0x29}, 
	{0xA26A,0xFC}, 
	{0xA26B,0x44}, 
	{0xA26C,0x18}, 
	{0xA26D,0xF0}, 
	{0xA26E,0x90}, 
	{0xA26F,0x72}, 
	{0xA270,0x18}, 
	{0xA271,0xE0}, 
	{0xA272,0x44}, 
	{0xA273,0x18}, 
	{0xA274,0xF0}, 
	{0xA275,0x00}, 
	{0xA276,0x00}, 
	{0xA277,0x00}, 
	{0xA278,0x00}, 
	{0xA279,0x00}, 
	{0xA27A,0x00}, 
	{0xA27B,0x90}, 
	{0xA27C,0x72}, 
	{0xA27D,0x08}, 
	{0xA27E,0xE0}, 
	{0xA27F,0x44}, 
	{0xA280,0x10}, 
	{0xA281,0xF0}, 
	{0xA282,0x90}, 
	{0xA283,0x72}, 
	{0xA284,0x14}, 
	{0xA285,0xE0}, 
	{0xA286,0x54}, 
	{0xA287,0xFD}, 
	{0xA288,0xF0}, 
	{0xA289,0x22}, 
	{0xA29B,0xF0}, 
	{0xA29C,0xD3}, 
	{0xA29D,0x90}, 
	{0xA29E,0x07}, 
	{0xA29F,0x91}, 
	{0xA2A0,0xE0}, 
	{0xA2A1,0x94}, 
	{0xA2A2,0x21}, 
	{0xA2A3,0x90}, 
	{0xA2A4,0x07}, 
	{0xA2A5,0x90}, 
	{0xA2A6,0xE0}, 
	{0xA2A7,0x64}, 
	{0xA2A8,0x80}, 
	{0xA2A9,0x94}, 
	{0xA2AA,0x81}, 
	{0xA2AB,0x40}, 
	{0xA2AC,0x08}, 
	{0xA2AD,0x90}, 
	{0xA2AE,0x07}, 
	{0xA2AF,0xCB}, 
	{0xA2B0,0x74}, 
	{0xA2B1,0xFF}, 
	{0xA2B2,0xF0}, 
	{0xA2B3,0x80}, 
	{0xA2B4,0x06}, 
	{0xA2B5,0x90}, 
	{0xA2B6,0x07}, 
	{0xA2B7,0xCB}, 
	{0xA2B8,0x74}, 
	{0xA2B9,0x01}, 
	{0xA2BA,0xF0}, 
	{0xA2BB,0x02}, 
	{0xA2BC,0xB5}, 
	{0xA2BD,0xC3}, 
	{0xA2BE,0x90}, 
	{0xA2BF,0x08}, 
	{0xA2C0,0x34}, 
	{0xA2C1,0xE0}, 
	{0xA2C2,0xFC}, 
	{0xA2C3,0xA3}, 
	{0xA2C4,0xE0}, 
	{0xA2C5,0xFD}, 
	{0xA2C6,0xA3}, 
	{0xA2C7,0xE0}, 
	{0xA2C8,0xFE}, 
	{0xA2C9,0xA3}, 
	{0xA2CA,0xE0}, 
	{0xA2CB,0xFF}, 
	{0xA2CC,0x90}, 
	{0xA2CD,0x07}, 
	{0xA2CE,0xD0}, 
	{0xA2CF,0xE0}, 
	{0xA2D0,0xF8}, 
	{0xA2D1,0xA3}, 
	{0xA2D2,0xE0}, 
	{0xA2D3,0xF9}, 
	{0xA2D4,0xA3}, 
	{0xA2D5,0xE0}, 
	{0xA2D6,0xFA}, 
	{0xA2D7,0xA3}, 
	{0xA2D8,0xE0}, 
	{0xA2D9,0xFB}, 
	{0xA2DA,0xD3}, 
	{0xA2DB,0x12}, 
	{0xA2DC,0x0D}, 
	{0xA2DD,0xAE}, 
	{0xA2DE,0x40}, 
	{0xA2DF,0x0B}, 
	{0xA2E0,0x12}, 
	{0xA2E1,0xB5}, 
	{0xA2E2,0x49}, 
	{0xA2E3,0x90}, 
	{0xA2E4,0x07}, 
	{0xA2E5,0xA4}, 
	{0xA2E6,0x74}, 
	{0xA2E7,0x02}, 
	{0xA2E8,0xF0}, 
	{0xA2E9,0x80}, 
	{0xA2EA,0x09}, 
	{0xA2EB,0x12}, 
	{0xA2EC,0xB7}, 
	{0xA2ED,0x51}, 
	{0xA2EE,0x90}, 
	{0xA2EF,0x07}, 
	{0xA2F0,0xA4}, 
	{0xA2F1,0x74}, 
	{0xA2F2,0x05}, 
	{0xA2F3,0xF0}, 
	{0xA2F4,0x02}, 
	{0xA2F5,0xA2}, 
	{0xA2F6,0xDA}, 
	{0xA2F7,0x90}, 
	{0xA2F8,0x0E}, 
	{0xA2F9,0xE0}, 
	{0xA2FA,0xE0}, 
	{0xA2FB,0xFD}, 
	{0xA2FC,0xA3}, 
	{0xA2FD,0xE0}, 
	{0xA2FE,0x90}, 
	{0xA2FF,0x02}, 
	{0xA300,0xA2}, 
	{0xA301,0xCD}, 
	{0xA302,0xF0}, 
	{0xA303,0xA3}, 
	{0xA304,0xED}, 
	{0xA305,0xF0}, 
	{0xA306,0x90}, 
	{0xA307,0x0E}, 
	{0xA308,0xE2}, 
	{0xA309,0xE0}, 
	{0xA30A,0xFD}, 
	{0xA30B,0xA3}, 
	{0xA30C,0xE0}, 
	{0xA30D,0x90}, 
	{0xA30E,0x02}, 
	{0xA30F,0xA8}, 
	{0xA310,0xCD}, 
	{0xA311,0xF0}, 
	{0xA312,0xA3}, 
	{0xA313,0xED}, 
	{0xA314,0xF0}, 
	{0xA315,0xE4}, 
	{0xA316,0x90}, 
	{0xA317,0x06}, 
	{0xA318,0x38}, 
	{0xA319,0xF0}, 
	{0xA31A,0x02}, 
	{0xA31B,0x67}, 
	{0xA31C,0x63}, 
	{0xA31D,0x90}, 
	{0xA31E,0x0E}, 
	{0xA31F,0xE8}, 
	{0xA320,0xE0}, 
	{0xA321,0x90}, 
	{0xA322,0x02}, 
	{0xA323,0x62}, 
	{0xA324,0xF0}, 
	{0xA325,0x90}, 
	{0xA326,0x0E}, 
	{0xA327,0xE9}, 
	{0xA328,0xE0}, 
	{0xA329,0x90}, 
	{0xA32A,0x02}, 
	{0xA32B,0x63}, 
	{0xA32C,0xF0}, 
	{0xA32D,0x02}, 
	{0xA32E,0x67}, 
	{0xA32F,0x1F}, 
	{0xA33B,0x90}, 
	{0xA33C,0x0E}, 
	{0xA33D,0x14}, 
	{0xA33E,0xE0}, 
	{0xA33F,0xFE}, 
	{0xA340,0xA3}, 
	{0xA341,0xE0}, 
	{0xA342,0xFF}, 
	{0xA343,0x90}, 
	{0xA344,0x06}, 
	{0xA345,0xD9}, 
	{0xA346,0xEE}, 
	{0xA347,0xF0}, 
	{0xA348,0xA3}, 
	{0xA349,0xEF}, 
	{0xA34A,0xF0}, 
	{0xA34B,0x90}, 
	{0xA34C,0x0E}, 
	{0xA34D,0x18}, 
	{0xA34E,0xE0}, 
	{0xA34F,0xFD}, 
	{0xA350,0x7C}, 
	{0xA351,0x00}, 
	{0xA352,0xC3}, 
	{0xA353,0xEF}, 
	{0xA354,0x9D}, 
	{0xA355,0xEE}, 
	{0xA356,0x9C}, 
	{0xA357,0x50}, 
	{0xA358,0x09}, 
	{0xA359,0xE4}, 
	{0xA35A,0x90}, 
	{0xA35B,0x06}, 
	{0xA35C,0xD7}, 
	{0xA35D,0xF0}, 
	{0xA35E,0xA3}, 
	{0xA35F,0xF0}, 
	{0xA360,0x80}, 
	{0xA361,0x13}, 
	{0xA362,0xC3}, 
	{0xA363,0x90}, 
	{0xA364,0x06}, 
	{0xA365,0xDA}, 
	{0xA366,0xE0}, 
	{0xA367,0x9D}, 
	{0xA368,0xFE}, 
	{0xA369,0x90}, 
	{0xA36A,0x06}, 
	{0xA36B,0xD9}, 
	{0xA36C,0xE0}, 
	{0xA36D,0x9C}, 
	{0xA36E,0x90}, 
	{0xA36F,0x06}, 
	{0xA370,0xD7}, 
	{0xA371,0xF0}, 
	{0xA372,0xA3}, 
	{0xA373,0xCE}, 
	{0xA374,0xF0}, 
	{0xA375,0x90}, 
	{0xA376,0x0E}, 
	{0xA377,0x18}, 
	{0xA378,0xE0}, 
	{0xA379,0xF9}, 
	{0xA37A,0xFF}, 
	{0xA37B,0x90}, 
	{0xA37C,0x06}, 
	{0xA37D,0xC2}, 
	{0xA37E,0xE0}, 
	{0xA37F,0xFC}, 
	{0xA380,0xA3}, 
	{0xA381,0xE0}, 
	{0xA382,0xFD}, 
	{0xA383,0xC3}, 
	{0xA384,0x9F}, 
	{0xA385,0xFF}, 
	{0xA386,0xEC}, 
	{0xA387,0x94}, 
	{0xA388,0x00}, 
	{0xA389,0xFE}, 
	{0xA38A,0x90}, 
	{0xA38B,0x0E}, 
	{0xA38C,0x16}, 
	{0xA38D,0xE0}, 
	{0xA38E,0xFA}, 
	{0xA38F,0xA3}, 
	{0xA390,0xE0}, 
	{0xA391,0xFB}, 
	{0xA392,0xD3}, 
	{0xA393,0x9F}, 
	{0xA394,0xEA}, 
	{0xA395,0x9E}, 
	{0xA396,0x40}, 
	{0xA397,0x0A}, 
	{0xA398,0x90}, 
	{0xA399,0x06}, 
	{0xA39A,0xD5}, 
	{0xA39B,0xEC}, 
	{0xA39C,0xF0}, 
	{0xA39D,0xA3}, 
	{0xA39E,0xED}, 
	{0xA39F,0xF0}, 
	{0xA3A0,0x80}, 
	{0xA3A1,0x0E}, 
	{0xA3A2,0xE9}, 
	{0xA3A3,0x7E}, 
	{0xA3A4,0x00}, 
	{0xA3A5,0x2B}, 
	{0xA3A6,0xFF}, 
	{0xA3A7,0xEE}, 
	{0xA3A8,0x3A}, 
	{0xA3A9,0x90}, 
	{0xA3AA,0x06}, 
	{0xA3AB,0xD5}, 
	{0xA3AC,0xF0}, 
	{0xA3AD,0xA3}, 
	{0xA3AE,0xEF}, 
	{0xA3AF,0xF0}, 
	{0xA3B0,0xE9}, 
	{0xA3B1,0xFB}, 
	{0xA3B2,0x7A}, 
	{0xA3B3,0x00}, 
	{0xA3B4,0x90}, 
	{0xA3B5,0x0E}, 
	{0xA3B6,0x15}, 
	{0xA3B7,0xE0}, 
	{0xA3B8,0x2B}, 
	{0xA3B9,0xFE}, 
	{0xA3BA,0x90}, 
	{0xA3BB,0x0E}, 
	{0xA3BC,0x14}, 
	{0xA3BD,0xE0}, 
	{0xA3BE,0x3A}, 
	{0xA3BF,0x90}, 
	{0xA3C0,0x06}, 
	{0xA3C1,0xE1}, 
	{0xA3C2,0xF0}, 
	{0xA3C3,0xA3}, 
	{0xA3C4,0xCE}, 
	{0xA3C5,0xF0}, 
	{0xA3C6,0xC3}, 
	{0xA3C7,0x90}, 
	{0xA3C8,0x0E}, 
	{0xA3C9,0x17}, 
	{0xA3CA,0xE0}, 
	{0xA3CB,0x9B}, 
	{0xA3CC,0xFE}, 
	{0xA3CD,0x90}, 
	{0xA3CE,0x0E}, 
	{0xA3CF,0x16}, 
	{0xA3D0,0x02}, 
	{0xA3D1,0x20}, 
	{0xA3D2,0xD5}, 
	{0xA3D3,0x90}, 
	{0xA3d4,0x0E}, 
	{0xA3d5,0xE4}, 
	{0xA3d6,0xE0}, 
	{0xA3d7,0x90}, 
	{0xA3d8,0x02}, 
	{0xA3d9,0x66}, 
	{0xA3da,0xF0}, 
	{0xA3DB,0x90}, 
	{0xA3dc,0x0E}, 
	{0xA3dd,0xE5}, 
	{0xA3de,0xE0}, 
	{0xA3df,0x90}, 
	{0xA3e0,0x02}, 
	{0xA3e1,0x64}, 
	{0xA3e2,0xF0}, 
	{0xA3e3,0x90}, 
	{0xA3e4,0x0E}, 
	{0xA3e5,0xE6}, 
	{0xA3e6,0xE0}, 
	{0xA3e7,0x90}, 
	{0xA3e8,0x02}, 
	{0xA3e9,0x65}, 
	{0xA3ea,0xF0}, 
	{0xA3eb,0x02}, 
	{0xA3ec,0x67}, 
	{0xA3ed,0xA5}, 
	{0xA3f0,0x12}, 
	{0xA3f1,0x47}, 
	{0xA3f2,0x59}, 
	{0xA3f3,0x90}, 
	{0xA3f4,0x00}, 
	{0xA3f5,0xB5}, 
	{0xA3f6,0xE0}, 
	{0xA3f7,0xB4}, 
	{0xA3f8,0x02}, 
	{0xA3f9,0x03}, 
	{0xA3fa,0x12}, 
	{0xA3fb,0x47}, 
	{0xA3fc,0x59}, 
	{0xA3fd,0x02}, 
	{0xA3fe,0xC5}, 
	{0xA3ff,0xC3}, 
	{0xA400,0x90}, 
	{0xA401,0x00}, 
	{0xA402,0x3D}, 
	{0xA403,0xF0}, 
	{0xA404,0x90}, 
	{0xA405,0x00}, 
	{0xA406,0x84}, 
	{0xA407,0xE0}, 
	{0xA408,0xFE}, 
	{0xA409,0x90}, 
	{0xA40A,0x00}, 
	{0xA40B,0x3E}, 
	{0xA40C,0xF0}, 
	{0xA40D,0xEF}, 
	{0xA40E,0x70}, 
	{0xA40F,0x03}, 
	{0xA410,0xEE}, 
	{0xA411,0x60}, 
	{0xA412,0x04}, 
	{0xA413,0x7F}, 
	{0xA414,0x01}, 
	{0xA415,0x80}, 
	{0xA416,0x02}, 
	{0xA417,0x7F}, 
	{0xA418,0x00}, 
	{0xA419,0x90}, 
	{0xA41A,0x00}, 
	{0xA41B,0x3F}, 
	{0xA41C,0xEF}, 
	{0xA41D,0xF0}, 
	{0xA41E,0x02}, 
	{0xA41F,0x89}, 
	{0xA420,0xD3}, 
	{0xA421,0x90}, 
	{0xA422,0x00}, 
	{0xA423,0x12}, 
	{0xA424,0xE0}, 
	{0xA425,0xFF}, 
	{0xA426,0x70}, 
	{0xA427,0x0C}, 
	{0xA428,0x90}, 
	{0xA429,0x00}, 
	{0xA42A,0x46}, 
	{0xA42B,0xE0}, 
	{0xA42C,0xC3}, 
	{0xA42D,0x94}, 
	{0xA42E,0x07}, 
	{0xA42F,0x40}, 
	{0xA430,0x03}, 
	{0xA431,0x75}, 
	{0xA432,0x2E}, 
	{0xA433,0x02}, 
	{0xA434,0xEF}, 
	{0xA435,0xB4}, 
	{0xA436,0x01}, 
	{0xA437,0x0C}, 
	{0xA438,0x90}, 
	{0xA439,0x00}, 
	{0xA43A,0x66}, 
	{0xA43B,0xE0}, 
	{0xA43C,0xC3}, 
	{0xA43D,0x94}, 
	{0xA43E,0x07}, 
	{0xA43F,0x40}, 
	{0xA440,0x03}, 
	{0xA441,0x75}, 
	{0xA442,0x2E}, 
	{0xA443,0x02}, 
	{0xA444,0x02}, 
	{0xA445,0xA7}, 
	{0xA446,0x9E}, 
	{0xA447,0xC3}, 
	{0xA448,0x90}, 
	{0xA449,0x0B}, 
	{0xA44A,0x8F}, 
	{0xA44B,0xE0}, 
	{0xA44C,0x94}, 
	{0xA44D,0x00}, 
	{0xA44E,0x90}, 
	{0xA44F,0x0B}, 
	{0xA450,0x8E}, 
	{0xA451,0xE0}, 
	{0xA452,0x94}, 
	{0xA453,0x41}, 
	{0xA454,0x40}, 
	{0xA455,0x22}, 
	{0xA456,0x90}, 
	{0xA457,0x0B}, 
	{0xA458,0x91}, 
	{0xA459,0xE0}, 
	{0xA45A,0x94}, 
	{0xA45B,0x00}, 
	{0xA45C,0x90}, 
	{0xA45D,0x0B}, 
	{0xA45E,0x90}, 
	{0xA45F,0xE0}, 
	{0xA460,0x94}, 
	{0xA461,0x41}, 
	{0xA462,0x40}, 
	{0xA463,0x14}, 
	{0xA464,0x90}, 
	{0xA465,0x0B}, 
	{0xA466,0x93}, 
	{0xA467,0xE0}, 
	{0xA468,0x94}, 
	{0xA469,0x00}, 
	{0xA46A,0x90}, 
	{0xA46B,0x0B}, 
	{0xA46C,0x92}, 
	{0xA46D,0xE0}, 
	{0xA46E,0x94}, 
	{0xA46F,0x41}, 
	{0xA470,0x40}, 
	{0xA471,0x06}, 
	{0xA472,0x90}, 
	{0xA473,0x01}, 
	{0xA474,0xA4}, 
	{0xA475,0x02}, 
	{0xA476,0x86}, 
	{0xA477,0x57}, 
	{0xA478,0x02}, 
	{0xA479,0x86}, 
	{0xA47A,0x5C}, 
	{0xA500,0xF5}, 
	{0xA501,0x3B}, 
	{0xA502,0x90}, 
	{0xA503,0x06}, 
	{0xA504,0x6C}, 
	{0xA505,0xE0}, 
	{0xA506,0xFF}, 
	{0xA507,0xE5}, 
	{0xA508,0x3B}, 
	{0xA509,0xC3}, 
	{0xA50A,0x9F}, 
	{0xA50B,0x40}, 
	{0xA50C,0x03}, 
	{0xA50D,0x02}, 
	{0xA50E,0xF6}, 
	{0xA50F,0x0E}, 
	{0xA510,0x90}, 
	{0xA511,0x0B}, 
	{0xA512,0xC6}, 
	{0xA513,0xE0}, 
	{0xA514,0x14}, 
	{0xA515,0x60}, 
	{0xA516,0x3C}, 
	{0xA517,0x14}, 
	{0xA518,0x60}, 
	{0xA519,0x6B}, 
	{0xA51A,0x24}, 
	{0xA51B,0x02}, 
	{0xA51C,0x60}, 
	{0xA51D,0x03}, 
	{0xA51E,0x02}, 
	{0xA51F,0xF5}, 
	{0xA520,0xB5}, 
	{0xA521,0x90}, 
	{0xA522,0x0A}, 
	{0xA523,0x9A}, 
	{0xA524,0xE0}, 
	{0xA525,0xFB}, 
	{0xA526,0xA3}, 
	{0xA527,0xE0}, 
	{0xA528,0xFA}, 
	{0xA529,0xA3}, 
	{0xA52A,0xE0}, 
	{0xA52B,0xF9}, 
	{0xA52C,0x85}, 
	{0xA52D,0x3B}, 
	{0xA52E,0x82}, 
	{0xA52F,0x75}, 
	{0xA530,0x83}, 
	{0xA531,0x00}, 
	{0xA532,0x12}, 
	{0xA533,0x0A}, 
	{0xA534,0xB8}, 
	{0xA535,0xFF}, 
	{0xA536,0x74}, 
	{0xA537,0xAB}, 
	{0xA538,0x25}, 
	{0xA539,0x3B}, 
	{0xA53A,0xF5}, 
	{0xA53B,0x82}, 
	{0xA53C,0xE4}, 
	{0xA53D,0x34}, 
	{0xA53E,0x0A}, 
	{0xA53F,0xF5}, 
	{0xA540,0x83}, 
	{0xA541,0xE0}, 
	{0xA542,0xFD}, 
	{0xA543,0xC3}, 
	{0xA544,0xEF}, 
	{0xA545,0x9D}, 
	{0xA546,0xFE}, 
	{0xA547,0xE4}, 
	{0xA548,0x94}, 
	{0xA549,0x00}, 
	{0xA54A,0x90}, 
	{0xA54B,0x0B}, 
	{0xA54C,0xCA}, 
	{0xA54D,0xF0}, 
	{0xA54E,0xA3}, 
	{0xA54F,0xCE}, 
	{0xA550,0xF0}, 
	{0xA551,0x80}, 
	{0xA552,0x62}, 
	{0xA553,0x90}, 
	{0xA554,0x0A}, 
	{0xA555,0x9A}, 
	{0xA556,0xE0}, 
	{0xA557,0xFB}, 
	{0xA558,0xA3}, 
	{0xA559,0xE0}, 
	{0xA55A,0xFA}, 
	{0xA55B,0xA3}, 
	{0xA55C,0xE0}, 
	{0xA55D,0xF9}, 
	{0xA55E,0x85}, 
	{0xA55F,0x3B}, 
	{0xA560,0x82}, 
	{0xA561,0x75}, 
	{0xA562,0x83}, 
	{0xA563,0x00}, 
	{0xA564,0x12}, 
	{0xA565,0x0A}, 
	{0xA566,0xB8}, 
	{0xA567,0xFF}, 
	{0xA568,0x74}, 
	{0xA569,0x9D}, 
	{0xA56A,0x25}, 
	{0xA56B,0x3B}, 
	{0xA56C,0xF5}, 
	{0xA56D,0x82}, 
	{0xA56E,0xE4}, 
	{0xA56F,0x34}, 
	{0xA570,0x0A}, 
	{0xA571,0xF5}, 
	{0xA572,0x83}, 
	{0xA573,0xE0}, 
	{0xA574,0xFD}, 
	{0xA575,0xC3}, 
	{0xA576,0xEF}, 
	{0xA577,0x9D}, 
	{0xA578,0xFE}, 
	{0xA579,0xE4}, 
	{0xA57A,0x94}, 
	{0xA57B,0x00}, 
	{0xA57C,0x90}, 
	{0xA57D,0x0B}, 
	{0xA57E,0xCA}, 
	{0xA57F,0xF0}, 
	{0xA580,0xA3}, 
	{0xA581,0xCE}, 
	{0xA582,0xF0}, 
	{0xA583,0x80}, 
	{0xA584,0x30}, 
	{0xA585,0x90}, 
	{0xA586,0x0A}, 
	{0xA587,0x9A}, 
	{0xA588,0xE0}, 
	{0xA589,0xFB}, 
	{0xA58A,0xA3}, 
	{0xA58B,0xE0}, 
	{0xA58C,0xFA}, 
	{0xA58D,0xA3}, 
	{0xA58E,0xE0}, 
	{0xA58F,0xF9}, 
	{0xA590,0x85}, 
	{0xA591,0x3B}, 
	{0xA592,0x82}, 
	{0xA593,0x75}, 
	{0xA594,0x83}, 
	{0xA595,0x00}, 
	{0xA596,0x12}, 
	{0xA597,0x0A}, 
	{0xA598,0xB8}, 
	{0xA599,0xFF}, 
	{0xA59A,0x74}, 
	{0xA59B,0xA4}, 
	{0xA59C,0x25}, 
	{0xA59D,0x3B}, 
	{0xA59E,0xF5}, 
	{0xA59F,0x82}, 
	{0xA5A0,0xE4}, 
	{0xA5A1,0x34}, 
	{0xA5A2,0x0A}, 
	{0xA5A3,0xF5}, 
	{0xA5A4,0x83}, 
	{0xA5A5,0xE0}, 
	{0xA5A6,0xFD}, 
	{0xA5A7,0xC3}, 
	{0xA5A8,0xEF}, 
	{0xA5A9,0x9D}, 
	{0xA5AA,0xFE}, 
	{0xA5AB,0xE4}, 
	{0xA5AC,0x94}, 
	{0xA5AD,0x00}, 
	{0xA5AE,0x90}, 
	{0xA5AF,0x0B}, 
	{0xA5B0,0xCA}, 
	{0xA5B1,0xF0}, 
	{0xA5B2,0xA3}, 
	{0xA5B3,0xCE}, 
	{0xA5B4,0xF0}, 
	{0xA5B5,0x90}, 
	{0xA5B6,0x07}, 
	{0xA5B7,0x83}, 
	{0xA5B8,0xE0}, 
	{0xA5B9,0xFF}, 
	{0xA5BA,0x7E}, 
	{0xA5BB,0x00}, 
	{0xA5BC,0x90}, 
	{0xA5BD,0x0D}, 
	{0xA5BE,0xF6}, 
	{0xA5BF,0xEE}, 
	{0xA5C0,0xF0}, 
	{0xA5C1,0xA3}, 
	{0xA5C2,0xEF}, 
	{0xA5C3,0xF0}, 
	{0xA5C4,0x90}, 
	{0xA5C5,0x0B}, 
	{0xA5C6,0xCA}, 
	{0xA5C7,0xE0}, 
	{0xA5C8,0xFC}, 
	{0xA5C9,0xA3}, 
	{0xA5CA,0xE0}, 
	{0xA5CB,0xFD}, 
	{0xA5CC,0xD3}, 
	{0xA5CD,0x9F}, 
	{0xA5CE,0x74}, 
	{0xA5CF,0x80}, 
	{0xA5D0,0xF8}, 
	{0xA5D1,0xEC}, 
	{0xA5D2,0x64}, 
	{0xA5D3,0x80}, 
	{0xA5D4,0x98}, 
	{0xA5D5,0x40}, 
	{0xA5D6,0x0C}, 
	{0xA5D7,0x90}, 
	{0xA5D8,0x0B}, 
	{0xA5D9,0xC8}, 
	{0xA5DA,0xE0}, 
	{0xA5DB,0x04}, 
	{0xA5DC,0xF0}, 
	{0xA5DD,0xA3}, 
	{0xA5DE,0xE0}, 
	{0xA5DF,0x04}, 
	{0xA5E0,0xF0}, 
	{0xA5E1,0x80}, 
	{0xA5E2,0x26}, 
	{0xA5E3,0x90}, 
	{0xA5E4,0x0D}, 
	{0xA5E5,0xF6}, 
	{0xA5E6,0xE0}, 
	{0xA5E7,0xFE}, 
	{0xA5E8,0xA3}, 
	{0xA5E9,0xE0}, 
	{0xA5EA,0xFF}, 
	{0xA5EB,0xC3}, 
	{0xA5EC,0xE4}, 
	{0xA5ED,0x9F}, 
	{0xA5EE,0xFF}, 
	{0xA5EF,0xE4}, 
	{0xA5F0,0x9E}, 
	{0xA5F1,0xFE}, 
	{0xA5F2,0xC3}, 
	{0xA5F3,0xED}, 
	{0xA5F4,0x9F}, 
	{0xA5F5,0xEE}, 
	{0xA5F6,0x64}, 
	{0xA5F7,0x80}, 
	{0xA5F8,0xF8}, 
	{0xA5F9,0xEC}, 
	{0xA5FA,0x64}, 
	{0xA5FB,0x80}, 
	{0xA5FC,0x98}, 
	{0xA5FD,0x50}, 
	{0xA5FE,0x0A}, 
	{0xA5FF,0x90}, 
	{0xA600,0x0B}, 
	{0xA601,0xC8}, 
	{0xA602,0xE0}, 
	{0xA603,0x14}, 
	{0xA604,0xF0}, 
	{0xA605,0xA3}, 
	{0xA606,0xE0}, 
	{0xA607,0x04}, 
	{0xA608,0xF0}, 
	{0xA609,0x05}, 
	{0xA60A,0x3B}, 
	{0xA60B,0x02}, 
	{0xA60C,0xF5}, 
	{0xA60D,0x02}, 
	{0xA60E,0x90}, 
	{0xA60F,0x08}, 
	{0xA610,0x58}, 
	{0xA611,0x02}, 
	{0xA612,0x9D}, 
	{0xA613,0x50}, 
	{0x9006,0xBA}, 
	{0x9007,0x75}, 
	{0x9008,0x00}, 
	{0x9009,0x00}, 
	{0x900A,0x02}, 
	{0x900D,0x01}, 
	{0x900E,0xA2}, 
	{0x900F,0x8F}, 
	{0x9010,0x00}, 
	{0x9011,0xCB}, 
	{0x9012,0x03}, 
	{0x9016,0xE6}, 
	{0x9017,0x6B}, 
	{0x9018,0x02}, 
	{0x9019,0x6B}, 
	{0x901A,0x02}, 
	{0x901D,0x01}, 
	{0x901E,0xAC}, 
	{0x901F,0x70}, 
	{0x9020,0x00}, 
	{0x9021,0xC5}, 
	{0x9022,0x03}, 
	{0x9026,0x9C}, 
	{0x9027,0x5B}, 
	{0x9028,0x00}, 
	{0x9029,0xBF}, 
	{0x902A,0x02}, 
	{0x902E,0x60}, 
	{0x902F,0x1C}, 
	{0x9030,0x01}, 
	{0x9031,0x37}, 
	{0x9032,0x02}, 
	{0x9035,0x01}, 
	{0x9036,0xBA}, 
	{0x9037,0x70}, 
	{0x9038,0x00}, 
	{0x9039,0x00}, 
	{0x903A,0x03}, 
	{0x903E,0x21}, 
	{0x903F,0x3F}, 
	{0x9040,0x02}, 
	{0x9041,0x40}, 
	{0x9042,0x02}, 
	{0x9046,0x21}, 
	{0x9047,0xEA}, 
	{0x9048,0x02}, 
	{0x9049,0x43}, 
	{0x904A,0x02}, 
	{0x904E,0xA6}, 
	{0x904F,0x12}, 
	{0x9050,0x02}, 
	{0x9051,0x46}, 
	{0x9052,0x02}, 
	{0x9056,0x29}, 
	{0x9057,0xE3}, 
	{0x9058,0x02}, 
	{0x9059,0x49}, 
	{0x905A,0x02}, 
	{0x905D,0x01}, 
	{0x905E,0x9C}, 
	{0x905F,0x6E}, 
	{0x9060,0x05}, 
	{0x9061,0x00}, 
	{0x9062,0x02}, 
	{0x9065,0x01}, 
	{0x9066,0xA2}, 
	{0x9067,0x66}, 
	{0x9068,0x02}, 
	{0x9069,0x35}, 
	{0x906A,0x02}, 
	{0x906D,0x01}, 
	{0x906E,0xB5}, 
	{0x906F,0xC2}, 
	{0x9070,0x02}, 
	{0x9071,0x9B}, 
	{0x9072,0x02}, 
	{0x9075,0x01}, 
	{0x9076,0xA2}, 
	{0x9077,0xD4}, 
	{0x9078,0x02}, 
	{0x9079,0xBE}, 
	{0x907A,0x02}, 
	{0x907D,0x01}, 
	{0x907E,0xB7}, 
	{0x907F,0xEA}, 
	{0x9080,0x00}, 
	{0x9081,0x02}, 
	{0x9082,0x03}, 
	{0x9086,0x67}, 
	{0x9087,0x31}, 
	{0x9088,0x02}, 
	{0x9089,0xF7}, 
	{0x908A,0x02}, 
	{0x908E,0x66}, 
	{0x908F,0xED}, 
	{0x9090,0x03}, 
	{0x9091,0x1D}, 
	{0x9092,0x02}, 
	{0x9096,0x67}, 
	{0x9097,0x73}, 
	{0x9098,0x03}, 
	{0x9099,0xD3}, 
	{0x909A,0x02}, 
	{0x909E,0x20}, 
	{0x909F,0x40}, 
	{0x90A0,0x03}, 
	{0x90A1,0x3B}, 
	{0x90A2,0x02}, 
	{0x90A6,0xC5}, 
	{0x90A7,0xC0}, 
	{0x90A8,0x03}, 
	{0x90A9,0xF0}, 
	{0x90AA,0x02}, 
	{0x90AE,0x41}, 
	{0x90AF,0xB3}, 
	{0x90B0,0x00}, 
	{0x90B1,0xA2}, 
	{0x90B2,0x02}, 
	{0x90B6,0x44}, 
	{0x90B7,0xBA}, 
	{0x90B8,0x00}, 
	{0x90B9,0xF0}, 
	{0x90BA,0x03}, 
	{0x90BE,0x89}, 
	{0x90BF,0x99}, 
	{0x90C0,0x04}, 
	{0x90C1,0x00}, 
	{0x90C2,0x02}, 
	{0x90C6,0xA7}, 
	{0x90C7,0x91}, 
	{0x90C8,0x04}, 
	{0x90C9,0x21}, 
	{0x90CA,0x02}, 
	{0x90CE,0x3A}, 
	{0x90CF,0x51}, 
	{0x90D0,0x00}, 
	{0x90D1,0xA2}, 
	{0x90D2,0x02}, 
	{0x90D6,0x86}, 
	{0x90D7,0x54}, 
	{0x90D8,0x04}, 
	{0x90D9,0x47}, 
	{0x90DA,0x02}, 
	{0x9000,0x01}, 
	{0xffff,0x00},   // 2013-03-01 end
	SensorWaitMs(200),
    {0x0009,0x16}, //10
    {0x0085,0x00}, 
    {0x0040,0x00},
    {0x0016,0x00},
    {0x0046,0x00},
    {0x0041,0x00},
   // {0x00B5,0x02},
    {0x7101,0x44},
    {0x00ED,0x0d},
    {0x00EE,0x1E},
    //{0x00B3,0x80},
    {0x7104,0x00},
    {0x7105,0x80},
    {0x019C,0x4B},
    {0x019D,0x20},
    {0x0129,0x02},
    {0x0130,0x00},
    {0x0083,0x00},
    {0x0084,0x00},
    {0x01A1,0x80},
    {0x01A2,0x80},
    {0x01A3,0x80},
    {0x01A0,0x01},
    {0x0021,0x00},
    {0x0022,0x01},

    {0x0040,0x00}, //00
    {0x0060,0x00},
    {0x0013,0x00},
    {0x0041,0x00},//00:5M 03:SVGA

    {0x0061,0x00},
    {0x0046,0x02},
    {0x0066,0x02},
    {0x0012,0x00},
    {0x7102,0x09},
    {0x7103,0x00},
    {0x7158,0x00},
    {0x00E8,0x01},
    {0x7000,0x2C},
    {0x5200,0x01},
    {0x7000,0x0C},
    {0x0143,0x5F},
    {0x0144,0x0D},
    {0x02C2,0x00},
    {0x02C3,0xc0},
    {0x015E,0x40},
    {0x015F,0x00},
    {0x0390,0x01},
    {0x0391,0x00},
    {0x0392,0x00},
    {0x03A0,0x14},
    {0x03A1,0x00},
    {0x03A2,0x5A},
    {0x03A3,0xEE},
    {0x03A4,0x69},
    {0x03A5,0x49},
    {0x03A6,0x3E},
    {0x03A7,0x00},
    {0x03A8,0x39},
    {0x03A9,0x33},
    {0x03B0,0x60},
    {0x03B1,0x00},
    {0x03B2,0x5A},
    {0x03B3,0xEE},
    {0x03B4,0x69},
    {0x03B5,0x49},
    {0x03B6,0x3E},
    {0x03B7,0x00},
    {0x03B8,0x3D},
    {0x03B9,0x20},
    {0x03C0,0x10},
    {0x03C1,0x00},
    {0x03C2,0x5A},
    {0x03C3,0xEE},
    {0x03C4,0x69},
    {0x03C5,0x49},
    {0x03C6,0x3A},
    {0x03C7,0x80},
    {0x03D0,0x64},
    {0x03D1,0x00},
    {0x03D2,0x5A},
    {0x03D3,0xEE},
    {0x03D4,0x69},
    {0x03D5,0x49},
    {0x03D6,0x34},
    {0x03D7,0xD1},
    {0x004C,0x0D},//enoch
    {0x006C,0x08},
    {0x0350,0x00},
    {0x0351,0x5A},
    {0x0352,0xEE},
    {0x0353,0x69},
    {0x0354,0x49},
    {0x0355,0x39},
    {0x0356,0x6D},
    {0x0357,0x3c},
    {0x0358,0x00},
    {0x0359,0x3C},
    {0x035A,0x5A},
    {0x035B,0xEE},
    {0x035C,0x69},
    {0x035D,0x49},
    {0x035E,0x39},
    {0x035F,0x85},
	{0x0049,0x14},	// PipeSetupBank0 bGammaGain 
	{0x004A,0x0E},	// PipeSetupBank0 bGammaInterpolationGain
	{0x0069,0x14},	// PipeSetupBank1 bGammaGain 
	{0x006A,0x0E},	// PipeSetupBank1 bGammaInterpolationGain
	{0x0090,0x5A},	// GammaGainDamperControl fpX1 {MSB}   //24000
	{0x0091,0xEE},	// GammaGainDamperControl fpX1 {LSB}
	{0x0092,0x3E},	// GammaGainDamperControl fpY1 {MSB}   //1
	{0x0093,0x00},	// GammaGainDamperControl fpY1 {LSB}
	{0x0094,0x69},	// GammaGainDamperControl fpX2 {MSB}   //3444736
	{0x0095,0x49},	// GammaGainDamperControl fpX2 {LSB}
	{0x0096,0x39},	// GammaGainDamperControl fpY2 {MSB}   //0.238
	{0x0097,0xCF},	// GammaGainDamperControl fpY2 {LSB}
	{0x0098,0x01},	// GammaGainDamperControl fDisable
	{0x00A0,0x5A},	// GammaInterpolationDamperControl fpX1 {MSB}	//24000 
	{0x00A1,0xEE},	// GammaInterpolationDamperControl fpX1 {LSB} 
	{0x00A2,0x3E},	// GammaInterpolationDamperControl fpY1 {MSB}	//1 
	{0x00A3,0x00},	// GammaInterpolationDamperControl fpY1 {LSB} 
	{0x00A4,0x69},	// GammaInterpolationDamperControl fpX2 {MSB}	//3444736 
	{0x00A5,0x49},	// GammaInterpolationDamperControl fpX2 {LSB} 
	{0x00A6,0x3B},	// GammaInterpolationDamperControl fpY2 {MSB}	//0.4375 
	{0x00A7,0x80},	// GammaInterpolationDamperControl fpY2 {LSB} 
	{0x00A8,0x01},	// GammaInterpolationDamperControl fDisable
#if 0	
    {0x0420,0x00},     //new LSC start - 0306
    {0x0421,0x26},
    {0x0422,0xff},
    {0x0423,0x03},
    {0x0424,0x00},
    {0x0425,0x63},
    {0x0426,0x00},
    {0x0427,0x8e},
    {0x0428,0xff},
    {0x0429,0xf3},
    {0x042A,0x00},
    {0x042B,0x26},
    {0x042C,0xff},
    {0x042D,0xc8},
    {0x042E,0xff},
    {0x042F,0x5f},
    {0x0430,0x00},
    {0x0431,0x10}, 
    {0x0432,0xfe},
    {0x0433,0xcf}, 
    {0x0434,0x00},
    {0x0435,0xc2}, 
    {0x0436,0x00},
    {0x0437,0xf2}, 
    {0x0438,0xff},
    {0x0439,0xd0}, 
    {0x043A,0x00},
    {0x043B,0xa1}, 
    {0x043C,0x00},
    {0x043D,0x2f}, 
    {0x043E,0xfe},
    {0x043F,0xdc},
    {0x0450,0x00},
    {0x0451,0x36},  
    {0x0452,0xff},
    {0x0453,0x60},  
    {0x0454,0x00},
    {0x0455,0x43},  
    {0x0456,0x00},
    {0x0457,0x6b},  
    {0x0458,0xff},
    {0x0459,0xdf},  
    {0x045A,0x00},
    {0x045B,0x83},  
    {0x045C,0xff},
    {0x045D,0xeb},  
    {0x045E,0xff},
    {0x045F,0x5f},
    {0x0440,0x00},
    {0x0441,0x36},        
    {0x0442,0xff},
    {0x0443,0x3e},        
    {0x0444,0x00},
    {0x0445,0x6d},        
    {0x0446,0x00},
    {0x0447,0x87},        
    {0x0448,0x00},
    {0x0449,0x0f},        
    {0x044A,0xff},
    {0x044B,0xd3},        
    {0x044C,0x00},
    {0x044D,0x18},        
    {0x044E,0xff},
    {0x044F,0x4f},
    {0x0561,0x08},
    {0x0460,0x00},
    {0x0461,0x22},
    {0x0462,0xff},
    {0x0463,0x0a},
    {0x0464,0x00},
    {0x0465,0x63},
    {0x0466,0x00},
    {0x0467,0x8b},
    {0x0468,0xff},
    {0x0469,0xf9},
    {0x046A,0x00},
    {0x046B,0x17},
    {0x046C,0xff},
    {0x046D,0xbd},
    {0x046E,0xff},
    {0x046F,0x65},
    {0x0470,0x00},
    {0x0471,0x15}, 
    {0x0472,0xfe},
    {0x0473,0xd7}, 
    {0x0474,0x00},
    {0x0475,0xb6}, 
    {0x0476,0x00},
    {0x0477,0xe5}, 
    {0x0478,0xff},
    {0x0479,0xd0}, 
    {0x047A,0x00},
    {0x047B,0xb2}, 
    {0x047C,0x00},
    {0x047D,0x2c}, 
    {0x047E,0xfe},
    {0x047F,0xe6},
    {0x0490,0x00},
    {0x0491,0x2b},  
    {0x0492,0xff},
    {0x0493,0x71},  
    {0x0494,0x00},
    {0x0495,0x43},  
    {0x0496,0x00},
    {0x0497,0x69},  
    {0x0498,0xff},
    {0x0499,0xd7},  
    {0x049A,0x00},
    {0x049B,0x59},  
    {0x049C,0xff},
    {0x049D,0xde},  
    {0x049E,0xff},
    {0x049F,0x76},                                    
    {0x0480,0x00},
    {0x0481,0x38},        
    {0x0482,0xff},
    {0x0483,0x3a},        
    {0x0484,0x00},
    {0x0485,0x6b},        
    {0x0486,0x00},
    {0x0487,0x86},        
    {0x0488,0x00},
    {0x0489,0x14},        
    {0x048A,0xff},
    {0x048B,0xd7},        
    {0x048C,0x00},
    {0x048D,0x13},        
    {0x048E,0xff},
    {0x048F,0x58},
    {0x0562,0x08},
    {0x04A0,0x00},
    {0x04A1,0x17},
    {0x04A2,0xff},
    {0x04A3,0x2e},
    {0x04A4,0x00},
    {0x04A5,0x5d},
    {0x04A6,0x00},
    {0x04A7,0x7a},
    {0x04A8,0xff},
    {0x04A9,0xf9},
    {0x04AA,0xff},
    {0x04AB,0xc0},
    {0x04AC,0xff},
    {0x04AD,0xc7},
    {0x04AE,0xff},
    {0x04AF,0x7d},
    {0x04B0,0x00},
    {0x04B1,0x13}, 
    {0x04B2,0xff},
    {0x04B3,0x45}, 
    {0x04B4,0x00},
    {0x04B5,0x70}, 
    {0x04B6,0x00},
    {0x04B7,0x96}, 
    {0x04B8,0xff},
    {0x04B9,0xde}, 
    {0x04BA,0x00},
    {0x04BB,0x17}, 
    {0x04BC,0x00},
    {0x04BD,0x23}, 
    {0x04BE,0xff},
    {0x04BF,0x46},
    {0x04D0,0x00},
    {0x04D1,0x17},  
    {0x04D2,0xff},
    {0x04D3,0x99},  
    {0x04D4,0x00},
    {0x04D5,0x3d},  
    {0x04D6,0x00},
    {0x04D7,0x5f},  
    {0x04D8,0xff},
    {0x04D9,0xd1},  
    {0x04DA,0xff},
    {0x04DB,0xe2},  
    {0x04DC,0xff},
    {0x04DD,0xc6},  
    {0x04DE,0xff},
    {0x04DF,0x9c},                                    
    {0x04C0,0x00},
    {0x04C1,0x32},        
    {0x04C2,0xff},
    {0x04C3,0x4e},        
    {0x04C4,0x00},
    {0x04C5,0x5e},        
    {0x04C6,0x00},
    {0x04C7,0x7c},        
    {0x04C8,0x00},
    {0x04C9,0x17},        
    {0x04CA,0xff},
    {0x04CB,0x9b},        
    {0x04CC,0x00},
    {0x04CD,0x06},        
    {0x04CE,0xff},
    {0x04CF,0x70},
    {0x0563,0x05},
    {0x04E0,0x00},
    {0x04E1,0x11},
    {0x04E2,0xff},
    {0x04E3,0x20},
    {0x04E4,0x00},
    {0x04E5,0x5f},
    {0x04E6,0x00},
    {0x04E7,0x7b},
    {0x04E8,0x00},
    {0x04E9,0x02},
    {0x04EA,0xff},
    {0x04EB,0xf1},
    {0x04EC,0xff},
    {0x04ED,0xb7},
    {0x04EE,0xff},
    {0x04EF,0x7b},
    {0x04F0,0x00},
    {0x04F1,0x1c}, 
    {0x04F2,0xff},
    {0x04F3,0x08}, 
    {0x04F4,0x00},
    {0x04F5,0x7e}, 
    {0x04F6,0x00},
    {0x04F7,0xac}, 
    {0x04F8,0xff},
    {0x04F9,0xeb}, 
    {0x04FA,0x00},
    {0x04FB,0x93}, 
    {0x04FC,0x00},
    {0x04FD,0x1b}, 
    {0x04FE,0xff},
    {0x04FF,0x11}, 
    {0x0510,0xff},
    {0x0511,0xfe},  
    {0x0512,0xff},
    {0x0513,0x8e},  
    {0x0514,0x00},
    {0x0515,0x4a},  
    {0x0516,0x00},
    {0x0517,0x6e},  
    {0x0518,0xff},
    {0x0519,0xbb},  
    {0x051A,0xff},
    {0x051B,0xcc},  
    {0x051C,0xff},
    {0x051D,0x9a},  
    {0x051E,0xff},
    {0x051F,0xa2},  
    {0x0500,0x00},
    {0x0501,0x30},        
    {0x0502,0xff},
    {0x0503,0x36},        
    {0x0504,0x00},
    {0x0505,0x5d},        
    {0x0506,0x00},
    {0x0507,0x81},        
    {0x0508,0x00},
    {0x0509,0x1f},        
    {0x050A,0xff},
    {0x050B,0xd4},        
    {0x050C,0xff},
    {0x050D,0xfe},        
    {0x050E,0xff},
    {0x050F,0x75},
    {0x0564,0x00}, //new LSC end
#else

{0x0420,0x00},   //C0_GreenRed_X
{0x0421,0x1E},   //C0_GreenRed_X LSB
{0x0422,0xFF},   //C0_GreenRed_Y
{0x0423,0xF3},   //C0_GreenRed_Y LSB
{0x0424,0x00},   //C0_GreenRed_X2
{0x0425,0x6E},   //C0_GreenRed_X2 LSB
{0x0426,0x00},   //C0_GreenRed_Y2
{0x0427,0x96},   //C0_GreenRed_Y2 LSB
{0x0428,0x00},   //C0_GreenRed_XY
{0x0429,0x40},   //C0_GreenRed_XY LSB
{0x042A,0x00},   //C0_GreenRed_X2Y
{0x042B,0x3F},   //C0_GreenRed_X2Y LSB
{0x042C,0x00},   //C0_GreenRed_XY2
{0x042D,0x99},   //C0_GreenRed_XY2 LSB
{0x042E,0xFF},   //C0_GreenRed_X2Y2
{0x042F,0xCD},   //C0_GreenRed_X2Y2 LSB
{0x0430,0xFF},   //C0_Red_X
{0x0431,0xC1},   //C0_Red_X LSB
{0x0432,0xFF},   //C0_Red_Y
{0x0433,0x8C},   //C0_Red_Y LSB
{0x0434,0x00},   //C0_Red_X2
{0x0435,0xD1},   //C0_Red_X2 LSB
{0x0436,0x00},   //C0_Red_Y2
{0x0437,0xF9},   //C0_Red_Y2 LSB
{0x0438,0xFF},   //C0_Red_XY
{0x0439,0xD0},   //C0_Red_XY LSB
{0x043A,0xFF},   //C0_Red_X2Y
{0x043B,0xD4},   //C0_Red_X2Y LSB
{0x043C,0x00},   //C0_Red_XY2
{0x043D,0x46},   //C0_Red_XY2 LSB
{0x043E,0xFF},   //C0_Red_X2Y2
{0x043F,0x1F},   //C0_Red_X2Y2 LSB
{0x0440,0x00},   //C0_GreenBlue_X
{0x0441,0x00},   //C0_GreenBlue_X LSB
{0x0442,0xFF},   //C0_GreenBlue_Y
{0x0443,0xEC},   //C0_GreenBlue_Y LSB
{0x0444,0x00},   //C0_GreenBlue_X2
{0x0445,0x7D},   //C0_GreenBlue_X2 LSB
{0x0446,0x00},   //C0_GreenBlue_Y2
{0x0447,0x89},   //C0_GreenBlue_Y2 LSB
{0x0448,0x00},   //C0_GreenBlue_XY
{0x0449,0x4A},   //C0_GreenBlue_XY LSB
{0x044A,0x00},   //C0_GreenBlue_X2Y
{0x044B,0x00},   //C0_GreenBlue_X2Y LSB
{0x044C,0x00},   //C0_GreenBlue_XY2
{0x044D,0x6C},   //C0_GreenBlue_XY2 LSB
{0x044E,0xFF},   //C0_GreenBlue_X2Y2
{0x044F,0xB5},   //C0_GreenBlue_X2Y2 LSB	// C9
{0x0450,0x00},   //C0_Blue_X
{0x0451,0x03},   //C0_Blue_X LSB
{0x0452,0xFF},   //C0_Blue_Y
{0x0453,0xC8},   //C0_Blue_Y LSB
{0x0454,0x00},   //C0_Blue_X2
{0x0455,0x5D},   //C0_Blue_X2 LSB
{0x0456,0x00},   //C0_Blue_Y2
{0x0457,0x7F},   //C0_Blue_Y2 LSB
{0x0458,0xFF},   //C0_Blue_XY
{0x0459,0xD0},   //C0_Blue_XY LSB
{0x045A,0x00},   //C0_Blue_X2Y
{0x045B,0x1A},   //C0_Blue_X2Y LSB
{0x045C,0xFF},   //C0_Blue_XY2
{0x045D,0xC8},   //C0_Blue_XY2 LSB
{0x045E,0xFF},   //C0_Blue_X2Y2
{0x045F,0xDA},   //C0_Blue_X2Y2 LSB
{0x0460,0x00},   //C1_GreenRed_X
{0x0461,0x25},   //C1_GreenRed_X LSB
{0x0462,0x00},   //C1_GreenRed_Y
{0x0463,0x00},   //C1_GreenRed_Y LSB
{0x0464,0x00},   //C1_GreenRed_X2
{0x0465,0x65},   //C1_GreenRed_X2 LSB
{0x0466,0x00},   //C1_GreenRed_Y2
{0x0467,0x85},   //C1_GreenRed_Y2 LSB
{0x0468,0x00},   //C1_GreenRed_XY
{0x0469,0x41},   //C1_GreenRed_XY LSB
{0x046A,0x00},   //C1_GreenRed_X2Y
{0x046B,0x42},   //C1_GreenRed_X2Y LSB
{0x046C,0x00},   //C1_GreenRed_XY2
{0x046D,0x91},   //C1_GreenRed_XY2 LSB
{0x046E,0xFF},   //C1_GreenRed_X2Y2
{0x046F,0xDA},   //C1_GreenRed_X2Y2 LSB	// F0
{0x0470,0xFF},   //C1_Red_X
{0x0471,0xD7},   //C1_Red_X LSB
{0x0472,0xFF},   //C1_Red_Y
{0x0473,0xA0},   //C1_Red_Y LSB
{0x0474,0x00},   //C1_Red_X2
{0x0475,0x8C},   //C1_Red_X2 LSB
{0x0476,0x00},   //C1_Red_Y2
{0x0477,0xA5},   //C1_Red_Y2 LSB
{0x0478,0xFF},   //C1_Red_XY
{0x0479,0xD6},   //C1_Red_XY LSB
{0x047A,0xFF},   //C1_Red_X2Y
{0x047B,0xDA},   //C1_Red_X2Y LSB
{0x047C,0x00},   //C1_Red_XY2
{0x047D,0x58},   //C1_Red_XY2 LSB
{0x047E,0xFF},   //C1_Red_X2Y2
{0x047F,0xC4},   //C1_Red_X2Y2 LSB
{0x0480,0x00},   //C1_GreenBlue_X
{0x0481,0x04},   //C1_GreenBlue_X LSB
{0x0482,0xFF},   //C1_GreenBlue_Y
{0x0483,0xFA},   //C1_GreenBlue_Y LSB
{0x0484,0x00},   //C1_GreenBlue_X2
{0x0485,0x70},   //C1_GreenBlue_X2 LSB
{0x0486,0x00},   //C1_GreenBlue_Y2
{0x0487,0x7B},   //C1_GreenBlue_Y2 LSB
{0x0488,0x00},   //C1_GreenBlue_XY
{0x0489,0x4E},   //C1_GreenBlue_XY LSB
{0x048A,0x00},   //C1_GreenBlue_X2Y
{0x048B,0x00},   //C1_GreenBlue_X2Y LSB
{0x048C,0x00},   //C1_GreenBlue_XY2
{0x048D,0x8F},   //C1_GreenBlue_XY2 LSB
{0x048E,0xFF},   //C1_GreenBlue_X2Y2
{0x048F,0xEC},   //C1_GreenBlue_X2Y2 LSB
{0x0490,0x00},   //C1_Blue_X
{0x0491,0x08},   //C1_Blue_X LSB
{0x0492,0xFF},   //C1_Blue_Y
{0x0493,0xD0},   //C1_Blue_Y LSB
{0x0494,0x00},   //C1_Blue_X2
{0x0495,0x55},   //C1_Blue_X2 LSB
{0x0496,0x00},   //C1_Blue_Y2
{0x0497,0x70},   //C1_Blue_Y2 LSB
{0x0498,0xFF},   //C1_Blue_XY
{0x0499,0xC4},   //C1_Blue_XY LSB
{0x049A,0x00},   //C1_Blue_X2Y
{0x049B,0x03},   //C1_Blue_X2Y LSB
{0x049C,0xFF},   //C1_Blue_XY2
{0x049D,0xD2},   //C1_Blue_XY2 LSB
{0x049E,0x00},   //C1_Blue_X2Y2
{0x049F,0x04},   //C1_Blue_X2Y2 LSB
{0x04A0,0x00},   //C2_GreenRed_X
{0x04A1,0x28},   //C2_GreenRed_X LSB
{0x04A2,0xFF},   //C2_GreenRed_Y
{0x04A3,0xFA},   //C2_GreenRed_Y LSB
{0x04A4,0x00},   //C2_GreenRed_X2
{0x04A5,0x69},   //C2_GreenRed_X2 LSB
{0x04A6,0x00},   //C2_GreenRed_Y2
{0x04A7,0x88},   //C2_GreenRed_Y2 LSB
{0x04A8,0x00},   //C2_GreenRed_XY
{0x04A9,0x47},   //C2_GreenRed_XY LSB
{0x04AA,0x00},   //C2_GreenRed_X2Y
{0x04AB,0x46},   //C2_GreenRed_X2Y LSB
{0x04AC,0x00},   //C2_GreenRed_XY2
{0x04AD,0xA2},   //C2_GreenRed_XY2 LSB
{0x04AE,0xFF},   //C2_GreenRed_X2Y2
{0x04AF,0xCF},   //C2_GreenRed_X2Y2 LSB	// EA
{0x04B0,0xFF},   //C2_Red_X
{0x04B1,0xDC},   //C2_Red_X LSB
{0x04B2,0xFF},   //C2_Red_Y
{0x04B3,0xA4},   //C2_Red_Y LSB
{0x04B4,0x00},   //C2_Red_X2
{0x04B5,0x93},   //C2_Red_X2 LSB
{0x04B6,0x00},   //C2_Red_Y2
{0x04B7,0xB2},   //C2_Red_Y2 LSB
{0x04B8,0xFF},   //C2_Red_XY
{0x04B9,0xD8},   //C2_Red_XY LSB
{0x04BA,0xFF},   //C2_Red_X2Y
{0x04BB,0xCD},   //C2_Red_X2Y LSB
{0x04BC,0x00},   //C2_Red_XY2
{0x04BD,0x48},   //C2_Red_XY2 LSB
{0x04BE,0xFF},   //C2_Red_X2Y2
{0x04BF,0x9B},   //C2_Red_X2Y2 LSB
{0x04C0,0x00},   //C2_GreenBlue_X
{0x04C1,0x08},   //C2_GreenBlue_X LSB
{0x04C2,0x00},   //C2_GreenBlue_Y
{0x04C3,0x00},   //C2_GreenBlue_Y LSB
{0x04C4,0x00},   //C2_GreenBlue_X2
{0x04C5,0x73},   //C2_GreenBlue_X2 LSB
{0x04C6,0x00},   //C2_GreenBlue_Y2
{0x04C7,0x80},   //C2_GreenBlue_Y2 LSB
{0x04C8,0x00},   //C2_GreenBlue_XY
{0x04C9,0x4F},   //C2_GreenBlue_XY LSB
{0x04CA,0xFF},   //C2_GreenBlue_X2Y
{0x04CB,0xEF},   //C2_GreenBlue_X2Y LSB
{0x04CC,0x00},   //C2_GreenBlue_XY2
{0x04CD,0x89},   //C2_GreenBlue_XY2 LSB
{0x04CE,0xFF},   //C2_GreenBlue_X2Y2
{0x04CF,0xE2},   //C2_GreenBlue_X2Y2 LSB
{0x04D0,0x00},   //C2_Blue_X
{0x04D1,0x0C},   //C2_Blue_X LSB
{0x04D2,0xFF},   //C2_Blue_Y
{0x04D3,0xCE},   //C2_Blue_Y LSB
{0x04D4,0x00},   //C2_Blue_X2
{0x04D5,0x57},   //C2_Blue_X2 LSB
{0x04D6,0x00},   //C2_Blue_Y2
{0x04D7,0x72},   //C2_Blue_Y2 LSB
{0x04D8,0xFF},   //C2_Blue_XY
{0x04D9,0xC4},   //C2_Blue_XY LSB
{0x04DA,0x00},   //C2_Blue_X2Y
{0x04DB,0x09},   //C2_Blue_X2Y LSB
{0x04DC,0xFF},   //C2_Blue_XY2
{0x04DD,0xD2},   //C2_Blue_XY2 LSB
{0x04DE,0xFF},   //C2_Blue_X2Y2
{0x04DF,0xFC},   //C2_Blue_X2Y2 LSB
{0x04E0,0x00},   //C3_GreenRed_X
{0x04E1,0x2C},   //C3_GreenRed_X LSB
{0x04E2,0xFF},   //C3_GreenRed_Y
{0x04E3,0xFB},   //C3_GreenRed_Y LSB
{0x04E4,0x00},   //C3_GreenRed_X2
{0x04E5,0x69},   //C3_GreenRed_X2 LSB
{0x04E6,0x00},   //C3_GreenRed_Y2
{0x04E7,0x87},   //C3_GreenRed_Y2 LSB
{0x04E8,0x00},   //C3_GreenRed_XY
{0x04E9,0x4A},   //C3_GreenRed_XY LSB
{0x04EA,0x00},   //C3_GreenRed_X2Y
{0x04EB,0x56},   //C3_GreenRed_X2Y LSB
{0x04EC,0x00},   //C3_GreenRed_XY2
{0x04ED,0x9A},   //C3_GreenRed_XY2 LSB
{0x04EE,0xFF},   //C3_GreenRed_X2Y2
{0x04EF,0xBE},   //C3_GreenRed_X2Y2 LSB	// DC
{0x04F0,0xFF},   //C3_Red_X
{0x04F1,0xEB},   //C3_Red_X LSB
{0x04F2,0xFF},   //C3_Red_Y
{0x04F3,0x9B},   //C3_Red_Y LSB
{0x04F4,0x00},   //C3_Red_X2
{0x04F5,0xA5},   //C3_Red_X2 LSB
{0x04F6,0x00},   //C3_Red_Y2
{0x04F7,0xCC},   //C3_Red_Y2 LSB
{0x04F8,0xFF},   //C3_Red_XY
{0x04F9,0xE1},   //C3_Red_XY LSB
{0x04FA,0xFF},   //C3_Red_X2Y
{0x04FB,0xD9},   //C3_Red_X2Y LSB
{0x04FC,0x00},   //C3_Red_XY2
{0x04FD,0x6A},   //C3_Red_XY2 LSB
{0x04FE,0xFF},   //C3_Red_X2Y2
{0x04FF,0x5E},   //C3_Red_X2Y2 LSB
{0x0500,0x00},   //C3_GreenBlue_X
{0x0501,0x06},   //C3_GreenBlue_X LSB
{0x0502,0xFF},   //C3_GreenBlue_Y
{0x0503,0xFC},   //C3_GreenBlue_Y LSB
{0x0504,0x00},   //C3_GreenBlue_X2
{0x0505,0x6F},   //C3_GreenBlue_X2 LSB
{0x0506,0x00},   //C3_GreenBlue_Y2
{0x0507,0x83},   //C3_GreenBlue_Y2 LSB
{0x0508,0x00},   //C3_GreenBlue_XY
{0x0509,0x5A},   //C3_GreenBlue_XY LSB
{0x050A,0xFF},   //C3_GreenBlue_X2Y
{0x050B,0xF7},   //C3_GreenBlue_X2Y LSB
{0x050C,0x00},   //C3_GreenBlue_XY2
{0x050D,0x80},   //C3_GreenBlue_XY2 LSB
{0x050E,0xFF},   //C3_GreenBlue_X2Y2
{0x050F,0xD3},   //C3_GreenBlue_X2Y2 LSB
{0x0510,0x00},   //C3_Blue_X
{0x0511,0x0B},   //C3_Blue_X LSB
{0x0512,0xFF},   //C3_Blue_Y
{0x0513,0xCE},   //C3_Blue_Y LSB
{0x0514,0x00},   //C3_Blue_X2
{0x0515,0x58},   //C3_Blue_X2 LSB
{0x0516,0x00},   //C3_Blue_Y2
{0x0517,0x73},   //C3_Blue_Y2 LSB
{0x0518,0xFF},   //C3_Blue_XY
{0x0519,0xBE},   //C3_Blue_XY LSB
{0x051A,0xFF},   //C3_Blue_X2Y
{0x051B,0xFB},   //C3_Blue_X2Y LSB
{0x051C,0xFF},   //C3_Blue_XY2
{0x051D,0xD2},   //C3_Blue_XY2 LSB
{0x051E,0xFF},   //C3_Blue_X2Y2
{0x051F,0xFA},   //C3_Blue_X2Y2 LSB
{0x0561,0x05},   //C0 Unity
{0x0562,0x01},   //C1 Unity
{0x0563,0x01},   //C2 Unity
{0x0564,0x09},   //C3 Unity


#endif

    {0x0324,0x39},
    {0x0325,0xAE},
    {0x0326,0x3A},
    {0x0327,0x29},
    {0x0328,0x3B},
    {0x0329,0x0A},
    {0x032A,0x3B},
    {0x032B,0x62},
    {0x0320,0x01},
    {0x0321,0x04},
    {0x0322,0x01},
    {0x0323,0x01},
    {0x0330,0x01},
    {0x0384,0x00},
    {0x0337,0x01},
    {0x03EC,0x39},
    {0x03ED,0x85},
    {0x03FC,0x3A},
    {0x03FD,0x14},
    {0x040C,0x3A},
    {0x040D,0xF6},
    {0x041C,0x3B},
    {0x041D,0x9A},
    {0x03E0,0xB6},
    {0x03E1,0x04},
    {0x03E2,0xBB},
    {0x03E3,0xE9},
    {0x03E4,0xBC},
    {0x03E5,0x70},
    {0x03E6,0x37},
    {0x03E7,0x02},
    {0x03E8,0xBC},
    {0x03E9,0x00},
    {0x03EA,0xBF},
    {0x03EB,0x12},
    {0x03F0,0xBA},
    {0x03F1,0x7B},
    {0x03F2,0xBA},
    {0x03F3,0x83},
    {0x03F4,0xBB},
    {0x03F5,0xBC},
    {0x03F6,0x38},
    {0x03F7,0x2D},
    {0x03F8,0xBB},
    {0x03F9,0x23},
    {0x03FA,0xBD},
    {0x03FB,0xAC},
    {0x0400,0xBE},
    {0x0401,0x96},
    {0x0402,0xB9},
    {0x0403,0xBE},
    {0x0404,0xBB},
    {0x0405,0x57},
    {0x0406,0x3A},
    {0x0407,0xBB},
    {0x0408,0xB3},
    {0x0409,0x17},
    {0x040A,0xBE},
    {0x040B,0x66},
    {0x0410,0xBB},
    {0x0411,0x2A},
    {0x0412,0xBA},
    {0x0413,0x00},
    {0x0414,0xBB},
    {0x0415,0x10},
    {0x0416,0xB8},
    {0x0417,0xCD},
    {0x0418,0xB7},
    {0x0419,0x5C},
    {0x041A,0xBB},
    {0x041B,0x6C},
    {0x01f8,0x3c},
    {0x01f9,0x00},
    {0x01fa,0x00},
    {0x02a2,0x3e},
    {0x02a3,0x00},
    {0x02a4,0x3e},
    {0x02a5,0x00},
    {0x02a6,0x3e},
    {0x02a7,0x00},
    {0x02a8,0x3e},
    {0x02a9,0x00},
    {0x056c,0x42},
    {0x056d,0x00},
    {0x056e,0x42},
    {0x056f,0x00},
    {0x0570,0x42},
    {0x0571,0x00},
    {0x0572,0x42},
    {0x0573,0x10},
    {0x0081,0x64},  //6E->55
    {0x0588,0x00},
    {0x0589,0x5A},
    {0x058A,0xEE},
    {0x058B,0x69},
    {0x058C,0x49},
    {0x058D,0x3D},
    {0x058E,0x3D},
    {0x0080,0x64},
    {0x0082,0x5a},
  //  {0x0010,0x01},

   // SensorWaitMs(200),

    {0x4708,0x00},
    {0x4709,0x00},
    {0x4710,0x00},
    {0x4711,0x00},
    //AF intial setting
    {0x0659,0x01},//03-06 new af @ vcm
    {0x065A,0x00},
    {0x06C9,0x01},
    {0x06CD,0x01},
    {0x06CE,0xBD},
    {0x06CF,0x00},
    {0x06D0,0x60},
    {0x06D1,0x02},
    {0x06D2,0x30},
    {0x06D3,0xD4},
    {0x06D4,0x01},
    {0x06D5,0x01},
	{0x06D6,0xBD},//60->BC->66
	{0x06D7,0x00},
	{0x06D8,0x60},//93
	{0x06D9,0x00},
	{0x06DA,0x60},//93
    {0x06DB,0x59},
    {0x06DC,0x0d},
    {0x0730,0x00},
    {0x0731,0x00},
    {0x0732,0x03},
    {0x0733,0xFF},
    {0x0734,0x03},
    {0x0735,0x70},
    {0x0755,0x01},
    {0x0756,0x00},
    {0x075A,0x00},
    {0x075B,0x01},
    {0x075E,0x00},
    {0x0764,0x01},
    {0x0766,0x01},
    {0x0768,0x01},
    {0x076A,0x00},
    {0x0758,0x01},
    {0x075C,0x01},
    {0x0770,0x98},
    {0x0771,0x19},
    {0x0772,0x1B},
    {0x0774,0x01},
    {0x0775,0x4a},
    {0x0777,0x00},
    {0x0778,0x45},
    {0x0779,0x00},
    {0x077A,0x02},
    {0x077D,0x01},
    {0x077E,0x03},
    {0x0783,0x10},
    {0x0785,0x14},
    {0x0788,0x04},
    {0x0846,0x06},
    {0x0847,0x05},
    {0xC41A,0x05},
    {0xC423,0x11},
    {0xC427,0x11},
    {0x300B,0x09},

    {0x7000,0x08}, 
    {0x5200,0x09}, 
    {0x00B2,0x50}, 
    {0x00B3,0x80}, 
    {0x00B5,0x02}, 
    {0x0030,0x11}, 
   // {0x0040,0x01}, //AB2
   // {0x0041,0x03}, //SVGA mode
	{0x0040,0x01},
    {0x0041,0x0A},
	{0x0042,0x05},
	{0x0043,0x00},
	{0x0044,0x03},
	{0x0045,0xC0},

    {0x0010,0x01},
    SensorWaitMs(150),
    SensorEnd
};
/* Senor full resolution setting: recommand for capture */
static struct rk_sensor_reg sensor_fullres_lowfps_data[] ={

   // {0x0010,0x02},
   // SensorWaitMs(100),    
    //{0x00B5, 0x02}, 
    //{0x0030, 0x11}, 
  {0x0040, 0x00},
	{0x0041, 0x00},
	{0x004c, 0x12},
	 //{0x0010, 0x01},
   // SensorWaitMs(150),

	SensorEnd
};
/* Senor full resolution setting: recommand for video */
static struct rk_sensor_reg sensor_fullres_highfps_data[] ={
	SensorEnd
};
/* Preview resolution setting*/
static struct rk_sensor_reg sensor_preview_data[] =
{

   // {0x0010,0x02},
   // SensorWaitMs(100),    
   // {0x00B5, 0x01}, 
   // {0x0030, 0x12}, 
	{0x0040,0x01},
  {0x0041,0x0A},
	{0x0042,0x05},
	{0x0043,0x00},
	{0x0044,0x03},
	{0x0045,0xC0},
	{0x004c,0x0e},
	//{0x00ed,0x0d},
	//{0x0010, 0x01},
	// SensorWaitMs(150),

	SensorEnd
};
/* 1280x720 */
static struct rk_sensor_reg sensor_720p[]={
	SensorEnd
};

/* 1920x1080 */
static struct rk_sensor_reg sensor_1080p[]={
	SensorEnd
};


static struct rk_sensor_reg sensor_softreset_data[]={
	SensorEnd
};

static struct rk_sensor_reg sensor_check_id_data[]={
	SensorRegVal(0x0000,0),
	SensorRegVal(0x0001,0),
	SensorEnd
};
/*
*  The following setting must been filled, if the function is turn on by CONFIG_SENSOR_xxxx
*/
static struct rk_sensor_reg sensor_WhiteB_Auto[]=
{
	{0x01A0,0x01},
	SensorEnd
};
/* Cloudy Colour Temperature : 6500K - 8000K  */
static	struct rk_sensor_reg sensor_WhiteB_Cloudy[]=
{
	{0x01A0,0x04},
	SensorEnd
};
/* ClearDay Colour Temperature : 5000K - 6500K	*/
static	struct rk_sensor_reg sensor_WhiteB_ClearDay[]=
{
	{0x01A0,0x05},
	SensorEnd
};
/* Office Colour Temperature : 3500K - 5000K  */
static	struct rk_sensor_reg sensor_WhiteB_TungstenLamp1[]=
{
	{0x01A0,0x07},
	SensorEnd

};
/* Home Colour Temperature : 2500K - 3500K	*/
static	struct rk_sensor_reg sensor_WhiteB_TungstenLamp2[]=
{
	{0x01A0,0x08},
	SensorEnd
};
static struct rk_sensor_reg *sensor_WhiteBalanceSeqe[] = {sensor_WhiteB_Auto, sensor_WhiteB_TungstenLamp1,sensor_WhiteB_TungstenLamp2,
	sensor_WhiteB_ClearDay, sensor_WhiteB_Cloudy,NULL,
};

static	struct rk_sensor_reg sensor_Brightness0[]=
{
	// Brightness -2
	SensorEnd
};

static	struct rk_sensor_reg sensor_Brightness1[]=
{
	// Brightness -1

	SensorEnd
};

static	struct rk_sensor_reg sensor_Brightness2[]=
{
	//	Brightness 0

	SensorEnd
};

static	struct rk_sensor_reg sensor_Brightness3[]=
{
	// Brightness +1

	SensorEnd
};

static	struct rk_sensor_reg sensor_Brightness4[]=
{
	//	Brightness +2

	SensorEnd
};

static	struct rk_sensor_reg sensor_Brightness5[]=
{
	//	Brightness +3

	SensorEnd
};
static struct rk_sensor_reg *sensor_BrightnessSeqe[] = {sensor_Brightness0, sensor_Brightness1, sensor_Brightness2, sensor_Brightness3,
	sensor_Brightness4, sensor_Brightness5,NULL,
};

static	struct rk_sensor_reg sensor_Effect_Normal[] =
{
	{0x0380,0x0},
	{0x0381,0x0},
	{0x0382,0x0},
	{0x0384,0x0},
	SensorEnd
};

static	struct rk_sensor_reg sensor_Effect_WandB[] =
{
	{0x0380,0x0},
	{0x0381,0x0},
	{0x0382,0x0},
	{0x0384,0x5},
	SensorEnd
};

static	struct rk_sensor_reg sensor_Effect_Sepia[] =
{
	{0x0380,0x0},
	{0x0381,0x0},
	{0x0382,0x0},
	{0x0384,0x6},
	SensorEnd
};

static	struct rk_sensor_reg sensor_Effect_Negative[] =
{
	//Negative
	{0x0380,0x0},
	{0x0381,0x0},
	{0x0382,0x0},
	{0x0384,0x8},
	SensorEnd
};
static	struct rk_sensor_reg sensor_Effect_Bluish[] =
{
	// Bluish
	{0x0380,0x0},
	{0x0381,0x0},
	{0x0382,0x0},
	{0x0384,0x4},
	SensorEnd
};

static	struct rk_sensor_reg sensor_Effect_Green[] =
{
	//	Greenish
	{0x0380,0x0},
	{0x0381,0x0},
	{0x0382,0x0},
	{0x0384,0x3},
	SensorEnd
};
static struct rk_sensor_reg *sensor_EffectSeqe[] = {sensor_Effect_Normal, sensor_Effect_WandB, sensor_Effect_Negative,sensor_Effect_Sepia,
	sensor_Effect_Bluish, sensor_Effect_Green,NULL,
};

static	struct rk_sensor_reg sensor_Exposure0[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Exposure1[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Exposure2[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Exposure3[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Exposure4[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Exposure5[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Exposure6[]=
{
	SensorEnd
};

static struct rk_sensor_reg *sensor_ExposureSeqe[] = {sensor_Exposure0, sensor_Exposure1, sensor_Exposure2, sensor_Exposure3,
	sensor_Exposure4, sensor_Exposure5,sensor_Exposure6,NULL,
};

static	struct rk_sensor_reg sensor_Saturation0[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Saturation1[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Saturation2[]=
{
	SensorEnd
};
static struct rk_sensor_reg *sensor_SaturationSeqe[] = {sensor_Saturation0, sensor_Saturation1, sensor_Saturation2, NULL,};

static	struct rk_sensor_reg sensor_Contrast0[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Contrast1[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Contrast2[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Contrast3[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Contrast4[]=
{
	SensorEnd
};


static	struct rk_sensor_reg sensor_Contrast5[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Contrast6[]=
{
	SensorEnd
};
static struct rk_sensor_reg *sensor_ContrastSeqe[] = {sensor_Contrast0, sensor_Contrast1, sensor_Contrast2, sensor_Contrast3,
	sensor_Contrast4, sensor_Contrast5, sensor_Contrast6, NULL,
};
static	struct rk_sensor_reg sensor_SceneAuto[] =
{
	{0x3a00, 0x78},
	SensorEnd
};

static	struct rk_sensor_reg sensor_SceneNight[] =
{
	SensorEnd
};
static struct rk_sensor_reg *sensor_SceneSeqe[] = {sensor_SceneAuto, sensor_SceneNight,NULL,};

static struct rk_sensor_reg sensor_Zoom0[] =
{
	SensorEnd
};

static struct rk_sensor_reg sensor_Zoom1[] =
{
	SensorEnd
};

static struct rk_sensor_reg sensor_Zoom2[] =
{
	SensorEnd
};


static struct rk_sensor_reg sensor_Zoom3[] =
{
	SensorEnd
};
static struct rk_sensor_reg *sensor_ZoomSeqe[] = {sensor_Zoom0, sensor_Zoom1, sensor_Zoom2, sensor_Zoom3, NULL,};

/*
* User could be add v4l2_querymenu in sensor_controls by new_usr_v4l2menu
*/
static struct v4l2_querymenu sensor_menus[] =
{
};
/*
* User could be add v4l2_queryctrl in sensor_controls by new_user_v4l2ctrl
*/
static struct sensor_v4l2ctrl_usr_s sensor_controls[] =
{
};

//MUST define the current used format as the first item   
static struct rk_sensor_datafmt sensor_colour_fmts[] = {
	{MEDIA_BUS_FMT_UYVY8_2X8, V4L2_COLORSPACE_JPEG}
};


/*
**********************************************************
* Following is local code:
* 
* Please codeing your program here 
**********************************************************
*/


/*
**********************************************************
* Following is callback
* If necessary, you could coding these callback
**********************************************************
*/

/*
* the function is called in open sensor  
*/
static int sensor_activate_cb(struct i2c_client *client)
{
	SENSOR_DG("%s",__FUNCTION__);
	return 0;
}
/*
* the function is called in close sensor
*/
static int sensor_deactivate_cb(struct i2c_client *client)
{
    SENSOR_DG("%s",__FUNCTION__);
    return 0;
}
/*
* the function is called before sensor register setting in VIDIOC_S_FMT  
*/
static int sensor_s_fmt_cb_th(struct i2c_client *client,struct v4l2_mbus_framefmt *mf, bool capture)
{
	//struct generic_sensor*sensor = to_generic_sensor(client);
	
	
	return 0;
}
static int sensor_softrest_usr_cb(struct i2c_client *client,struct rk_sensor_reg *series)
{
	
	return 0;
}
static int sensor_check_id_usr_cb(struct i2c_client *client,struct rk_sensor_reg *series)
{
	return 0;
}

/*
* the function is called after sensor register setting finished in VIDIOC_S_FMT  
*/
static int sensor_s_fmt_cb_bh (struct i2c_client *client,struct v4l2_mbus_framefmt *mf, bool capture)
{
	struct soc_camera_subdev_desc *ssdd = client->dev.platform_data;
	struct soc_camera_device *icd = ssdd->socdev;
	struct generic_sensor *gsensor = to_generic_sensor(client);
	
    if (capture) {
        generic_sensor_af_workqueue_set(icd, WqCmd_af_special_pos,0,true);
    } else {
        if (gsensor->sensor_focus.focus_mode == V4L2_CID_FOCUS_AUTO) {
          generic_sensor_af_workqueue_set(icd, WqCmd_af_close,0,false);
        } else if (gsensor->sensor_focus.focus_mode == V4L2_CID_FOCUS_CONTINUOUS) {
            generic_sensor_af_workqueue_set(icd,WqCmd_af_continues,0,false);    
        }
    }
	return 0;
}
static int sensor_try_fmt_cb_th(struct i2c_client *client,struct v4l2_mbus_framefmt *mf)
{
	struct soc_camera_subdev_desc *ssdd = client->dev.platform_data;
    struct soc_camera_device *icd = ssdd->socdev;
	struct generic_sensor *gsensor = to_generic_sensor(client);
    
    if (gsensor->sensor_focus.focus_mode == V4L2_CID_FOCUS_CONTINUOUS) {
        generic_sensor_af_workqueue_set(icd,WqCmd_af_continues_pause,0,true);    
    }
	return 0;
}

static int sensor_suspend(struct soc_camera_device *icd, pm_message_t pm_msg)
{
	//struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
		
	if (pm_msg.event == PM_EVENT_SUSPEND) {
		SENSOR_DG("Suspend");
		
	} else {
		SENSOR_TR("pm_msg.event(0x%x) != PM_EVENT_SUSPEND\n",pm_msg.event);
		return -EINVAL;
	}
	return 0;
}

static int sensor_resume(struct soc_camera_device *icd)
{

	SENSOR_DG("Resume");

	return 0;

}
static int sensor_mirror_cb (struct i2c_client *client, int mirror)
{
	
	SENSOR_DG("mirror: %d",mirror);

	return 0;    
}
/*
* the function is v4l2 control V4L2_CID_HFLIP callback	
*/
static int sensor_v4l2ctrl_mirror_cb(struct soc_camera_device *icd, struct sensor_v4l2ctrl_info_s *ctrl_info, 
													 struct v4l2_ext_control *ext_ctrl)
{
	struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

	if (sensor_mirror_cb(client,ext_ctrl->value) != 0)
		SENSOR_TR("sensor_mirror failed, value:0x%x",ext_ctrl->value);
	
	SENSOR_DG("sensor_mirror success, value:0x%x",ext_ctrl->value);
	return 0;
}

static int sensor_flip_cb(struct i2c_client *client, int flip)
{
	SENSOR_DG("flip: %d",flip);

	return 0;    
}
/*
* the function is v4l2 control V4L2_CID_VFLIP callback	
*/
static int sensor_v4l2ctrl_flip_cb(struct soc_camera_device *icd, struct sensor_v4l2ctrl_info_s *ctrl_info, 
													 struct v4l2_ext_control *ext_ctrl)
{
	struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

	if (sensor_flip_cb(client,ext_ctrl->value) != 0)
		SENSOR_TR("sensor_flip failed, value:0x%x",ext_ctrl->value);
	
	SENSOR_DG("sensor_flip success, value:0x%x",ext_ctrl->value);
	return 0;
}
/*
* the functions are focus callbacks
*/
static int sensor_focus_af_single_usr_cb(struct i2c_client *client);

static int sensor_focus_init_usr_cb(struct i2c_client *client)
{
    return 0;
}

static int sensor_focus_af_single_usr_cb(struct i2c_client *client) 
{
	int ret = 0;

#ifdef 	SENSOR_AF_CONFIG  //xhh
    struct generic_sensor *sensor = to_generic_sensor(client);
    struct specific_sensor *ssensor = to_specific_sensor(sensor);
    
    sensor_write(client,0x0751,0x00);//add by jink 20141127
	  ret |= sensor_write(client,AF_MODES_REG,0x03);
    msleep(200); //add by jink 20141127
    ret |= sensor_write(client,AF_AUTOCMDS_REG,0x01);
    msleep(200);//add by jink 20141127
    ret |= sensor_write(client,AF_AUTOCMDS_REG,0x02);
    msleep(300);

   // do  {
   //     msleep(20);
   //     sensor_read(client,AF_FINISHCHK_REG,&state);
   //    cnt++;
   // }while ((state != 1) && (cnt<100));

   // if (state == 1) {
        sensor_read(client, AF_LENSPOS_REG_H,(char*)&ssensor->parameter.af_pos[0]);
       sensor_read(client, AF_LENSPOS_REG_L,(char*)&ssensor->parameter.af_pos[1]);
   // }

    //SENSOR_DG("single focus, state: %d cnt: %d",state,cnt);
#endif    
//sensor_af_single_end:
	return ret;
}

static int sensor_focus_af_near_usr_cb(struct i2c_client *client)
{
	return 0;
}

static int sensor_focus_af_far_usr_cb(struct i2c_client *client)
{
	
	return 0;
}

static int sensor_focus_af_specialpos_usr_cb(struct i2c_client *client,int pos)
{
    struct generic_sensor *sensor = to_generic_sensor(client);
    struct specific_sensor *ssensor = to_specific_sensor(sensor);
 #ifdef 	SENSOR_AF_CONFIG //xhh    
    sensor_write(client,0x070A, 0x00);
	sensor_write(client,0x0734, ssensor->parameter.af_pos[0]& 0xFF);
	sensor_write(client,0x0735, ssensor->parameter.af_pos[1] & 0xFF);
	sensor_write(client,0x070C, 0x00);
	mdelay(100);
    sensor_write(client,0x070C, 0x05);
#endif
	return 0;
}

static int sensor_focus_af_const_usr_cb(struct i2c_client *client)
{
    int ret;
 #ifdef 	SENSOR_AF_CONFIG //xhh
     sensor_write(client,0x0751,0x00);//add by jink 20141127
    ret = sensor_write(client, AF_MODES_REG, 0x01);
    #endif
//sensor_af_const_end:
	return ret;
}
static int sensor_focus_af_const_pause_usr_cb(struct i2c_client *client)
{
    int ret = 0;
    #ifdef 	SENSOR_AF_CONFIG //xhh
    char status = 0;
    struct generic_sensor *sensor = to_generic_sensor(client);
    struct specific_sensor *ssensor = to_specific_sensor(sensor);
    
    sensor_read(client, 0x07ae, &status);  //add by jink 20141127

    if (status == 1) {
        sensor_read(client, AF_LENSPOS_REG_H,(char*)&ssensor->parameter.af_pos[0]);
        sensor_read(client, AF_LENSPOS_REG_L,(char*)&ssensor->parameter.af_pos[1]);
    } else {
        sensor_focus_af_single_usr_cb(client);
   }
  #endif  
	return ret;
}
static int sensor_focus_af_close_usr_cb(struct i2c_client *client)
{
    int ret =0;
    #ifdef 	SENSOR_AF_CONFIG  //xhh
     sensor_write(client,0x0751,0x01);//add by jink 20141127
    /*
    ret |= sensor_write(client,0x070A, 0x00);
    ret |= sensor_write(client,0x0700, 0x03);
    ret |= sensor_write(client,0x0701, 0xFF);	
    ret |= sensor_write(client,0x070C, 0x00);
    ret |= sensor_write(client,0x070C, 0x07);
    */
    #endif
    SENSOR_DG("%s",__FUNCTION__);
	return ret;
}

static int sensor_focus_af_zoneupdate_usr_cb(struct i2c_client *client, int *zone_tm_pos)
{
    int ret = 0;
    #ifdef 	SENSOR_AF_CONFIG  //xhh
    int xstart,ystart;
    
    *zone_tm_pos += 1000;
    *(zone_tm_pos+1) += 1000;
    *(zone_tm_pos+2) += 1000;
    *(zone_tm_pos+3) += 1000;

    xstart = ((*zone_tm_pos + *(zone_tm_pos+2))>>1)*800/2000;
    ystart = ((*(zone_tm_pos+1) + *(zone_tm_pos+3))>>1)*600/2000;

    if (xstart>0xa0) {
        xstart -= 0xa0;
    } else {
        xstart = 0;
    }

    if (ystart>0xa0) {
        ystart -= 0xa0;
    } else {
        ystart = 0;
    }
    
    ret |= sensor_write(client, AF_ZONE0_WEIGHT,0x01);
    ret |= sensor_write(client, AF_ZONE1_WEIGHT,0x00); 
    ret |= sensor_write(client, AF_ZONE2_WEIGHT,0x00);
    ret |= sensor_write(client, AF_ZONE3_WEIGHT,0x00);  
    ret |= sensor_write(client, AF_ZONE4_WEIGHT,0x00);	  
    ret |= sensor_write(client, AF_ZONE5_WEIGHT,0x00);
    ret |= sensor_write(client, AF_ZONE6_WEIGHT,0x00);    
    ret |= sensor_write(client, FACE_LC,0x01); 

    ret |= sensor_write(client, FACE_START_XH, ((xstart&0xff00)>>8));
    ret |= sensor_write(client, FACE_START_XL, xstart&0xff);
    ret |= sensor_write(client, FACE_START_YH, ((ystart&0xff00)>>8));
    ret |= sensor_write(client, FACE_START_YL, ystart&0xff);	

    ret |= sensor_write(client, FACE_SIZE_XH, 0x01);
	ret |= sensor_write(client, FACE_SIZE_XL, 0x40);
	ret |= sensor_write(client, FACE_SIZE_YH, 0x01);
	ret |= sensor_write(client, FACE_SIZE_YL, 0x40);
	#endif
//sensor_af_zone_end:
	return ret;
}

/*
face defect call back
*/
static int	sensor_face_detect_usr_cb(struct i2c_client *client,int on){
	return 0;
}

/*
*	The function can been run in sensor_init_parametres which run in sensor_probe, so user can do some
* initialization in the function. 
*/
static void sensor_init_parameters_user(struct specific_sensor* spsensor,struct soc_camera_device *icd)
{
	return;
}

/*
* :::::WARNING:::::
* It is not allowed to modify the following code
*/

sensor_init_parameters_default_code();

sensor_v4l2_struct_initialization();

sensor_probe_default_code();

sensor_remove_default_code();

sensor_driver_default_module_code();

 


