/*
 * ov13850 sensor driver
 *
 * Copyright (C) 2016 Fuzhou Rockchip Electronics Co., Ltd.
 *
 * Copyright (C) 2012-2014 Intel Mobile Communications GmbH
 *
 * Copyright (C) 2008 Texas Instruments.
 *
 * This file is licensed under the terms of the GNU General Public License
 * version 2. This program is licensed "as is" without any warranty of any
 * kind, whether express or implied.
 *
 */

#include <linux/i2c.h>
#include <linux/io.h>
#include <linux/delay.h>
#include <linux/module.h>
#include <media/v4l2-subdev.h>
#include <media/videobuf-core.h>
#include <linux/slab.h>
#include "ov_camera_module.h"

#define ov13850_DRIVER_NAME "ov13850"

/* Bit 2-0    gain 10 -8 */
#define ov13850_AEC_PK_LONG_GAIN_HIGH_REG 0x350A
/* Bits 7 -0  gain  7-0 */
#define ov13850_AEC_PK_LONG_GAIN_LOW_REG	 0x350B
#define ov13850_FETCH_LSB_GAIN(VAL) ((VAL) & 0x00ff)
#define ov13850_FETCH_MSB_GAIN(VAL) (((VAL) >> 8) & 0xff)

/* Exposure Bits 16-19 */
#define ov13850_AEC_PK_LONG_EXPO_3RD_REG 0x3500
/* Exposure Bits 8-15 */
#define ov13850_AEC_PK_LONG_EXPO_2ND_REG 0x3501
/* Exposure Bits 0-7 */
#define ov13850_AEC_PK_LONG_EXPO_1ST_REG 0x3502
/* 4 Bits */
#define ov13850_FETCH_3RD_BYTE_EXP(VAL) (((VAL) >> 12) & 0xF)
/* 8 Bits */
#define ov13850_FETCH_2ND_BYTE_EXP(VAL) (((VAL) >> 4) & 0xFF)
/* 4 Bits */
#define ov13850_FETCH_1ST_BYTE_EXP(VAL) (((VAL) & 0x0F) << 4)

#define ov13850_AEC_GROUP_UPDATE_ADDRESS		0x3208
#define ov13850_AEC_GROUP_UPDATE_START_DATA	0x00
#define ov13850_AEC_GROUP_UPDATE_END_DATA	0x10
#define ov13850_AEC_GROUP_UPDATE_END_LAUNCH	0xA0

#define ov13850_PIDH_ADDR    0x300A
#define ov13850_PIDL_ADDR	0x300B

#define ov13850_PIDH_MAGIC	0xD8
#define ov13850_PIDL_MAGIC	0x50

#define ov13850_TIMING_VTS_HIGH_REG 0x380e
#define ov13850_TIMING_VTS_LOW_REG 0x380f
#define ov13850_TIMING_HTS_HIGH_REG 0x380c
#define ov13850_TIMING_HTS_LOW_REG 0x380d
#define ov13850_INTEGRATION_TIME_MARGIN 8
#define ov13850_FINE_INTG_TIME_MIN 0
#define ov13850_FINE_INTG_TIME_MAX_MARGIN 0
#define ov13850_COARSE_INTG_TIME_MIN 16
#define ov13850_COARSE_INTG_TIME_MAX_MARGIN 4
#define ov13850_TIMING_X_INC		0x3814
#define ov13850_TIMING_Y_INC		0x3815
#define ov13850_HORIZONTAL_START_HIGH_REG 0x3800
#define ov13850_HORIZONTAL_START_LOW_REG 0x3801
#define ov13850_VERTICAL_START_HIGH_REG 0x3802
#define ov13850_VERTICAL_START_LOW_REG 0x3803
#define ov13850_HORIZONTAL_END_HIGH_REG 0x3804
#define ov13850_HORIZONTAL_END_LOW_REG 0x3805
#define ov13850_VERTICAL_END_HIGH_REG 0x3806
#define ov13850_VERTICAL_END_LOW_REG 0x3807
#define ov13850_HORIZONTAL_OUTPUT_SIZE_HIGH_REG 0x3808
#define ov13850_HORIZONTAL_OUTPUT_SIZE_LOW_REG 0x3809
#define ov13850_VERTICAL_OUTPUT_SIZE_HIGH_REG 0x380a
#define ov13850_VERTICAL_OUTPUT_SIZE_LOW_REG 0x380b
#define ov13850_FLIP_REG                     0x3820
#define ov13850_MIRROR_REG					0x3821

#define ov13850_EXT_CLK 24000000

#define ov13850_FULL_SIZE_RESOLUTION_WIDTH 4224
#define ov13850_BINING_SIZE_RESOLUTION_WIDTH 2112

//#define OV13850_ONE_LANE

//#define OV13850_COLORBAR_TEST

static struct ov_camera_module ov13850;
static struct ov_camera_module_custom_config ov13850_custom_config;

/* ======================================================================== */
/* Base sensor configs */
/* ======================================================================== */

#ifndef OV13850_ONE_LANE
#ifdef OV13850_SENSOR_R1A
/* MCLK:24MHz  4224x3136  7fps   mipi 2lane    600 Mbps/  2lane */
static struct ov_camera_module_reg
ov13850_init_tab_4224_3136_7fps_twolane_r1a[] = {
/* global setting */
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0300, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0301, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0302, 0x28},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0303, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x030a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x300f, 0x11},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3010, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3011, 0x76},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3012, 0x21},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3013, 0x12},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3014, 0x11},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3015, 0xc0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x301f, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3106, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3210, 0x47},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3500, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3501, 0x60},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3502, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3506, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3507, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3508, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350b, 0x3f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350f, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3600, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3601, 0xfc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3602, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3603, 0x48},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3604, 0xa5},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3605, 0x9f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3607, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360a, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360b, 0x91},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360c, 0x49},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360f, 0x8a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3611, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3612, 0x27},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3613, 0x33},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3615, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3641, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3660, 0x82},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3668, 0x54},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3669, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3667, 0xa0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3702, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3703, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3704, 0x2c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3705, 0x24},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3706, 0x50},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3707, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3708, 0x3c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3709, 0x1f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370a, 0x26},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370b, 0x3c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3720, 0x66},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3722, 0x84},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3728, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372f, 0x90},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3710, 0x28},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3716, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3718, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3719, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x371c, 0xfc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3760, 0x13},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3761, 0x34},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3767, 0x24},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3768, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3769, 0x45},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x376c, 0x23},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d84, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d85, 0x17},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d8c, 0x73},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d8d, 0xbf},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3800, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3801, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3802, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3803, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3804, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3805, 0x97},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3806, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3807, 0x4b},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3808, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3809, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380a, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380b, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380c, 0x12},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380d, 0xc0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380e, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380f, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3810, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3811, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3812, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3813, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3814, 0x31},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3815, 0x31},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3820, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3821, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3834, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3835, 0x1c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3836, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3837, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4000, 0xf1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4001, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x400b, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4011, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401b, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401d, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4020, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4021, 0xE4},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4022, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4023, 0x5F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4024, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4025, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4026, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4027, 0x47},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4028, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4029, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402a, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402b, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402c, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402d, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402e, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402f, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x403d, 0x2c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x403f, 0x7f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4500, 0x82},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4501, 0x38},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4601, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4602, 0x22},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4603, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4837, 0x1b},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d00, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d01, 0x42},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d02, 0xd1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d03, 0x90},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d04, 0x66},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d05, 0x65},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5000, 0x0e},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5001, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5002, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5013, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x501c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x501d, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5242, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5243, 0xb8},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5244, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5245, 0xf9},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5246, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5247, 0xf6},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5248, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5249, 0xa6},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5300, 0xfc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5301, 0xdf},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5302, 0x3f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5303, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5304, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5305, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5306, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5307, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5308, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5309, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x530a, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x530b, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x530c, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x530d, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x530e, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x530f, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5310, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5400, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5401, 0x61},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5402, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5403, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5404, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5405, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x540c, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b00, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b01, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b02, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b03, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b04, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b05, 0x6c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b09, 0x02},
#ifndef OV13850_COLORBAR_TEST
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5e00, 0x00},
#else
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5e00, 0x80},
#endif
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5e10, 0x1c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0100, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3612, 0x2f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370a, 0x24},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372a, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372f, 0xa0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3801, 0x0C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3805, 0x93},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3807, 0x4B},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3808, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3809, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380a, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380b, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380e, 0x0d},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380f, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3813, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3814, 0x11},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3815, 0x11},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3820, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3821, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3836, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3837, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4601, 0x87},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4603, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4020, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4021, 0x4C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4022, 0x0E},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4023, 0x37},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4024, 0x0F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4025, 0x1C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4026, 0x0F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4027, 0x1F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4603, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5401, 0x71},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5405, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4800, 0x24}
};

/* MCLK:24MHz  2112x1568  30fps  mipi 2lane  Mbps/lane */
static struct ov_camera_module_reg
ov13850_regs_2112_1568_30fps_twolane_r1a[] = {
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0103, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0300, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0301, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0302, 0x32},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0303, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x030a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x300f, 0x11},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3010, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3011, 0x76},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3012, 0x21},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3013, 0x12},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3014, 0x11},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3015, 0xc0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x301f, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3106, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3210, 0x47},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3500, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3501, 0x60},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3502, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3506, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3507, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3508, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350b, 0x3f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350f, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3600, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3601, 0xfc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3602, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3603, 0x48},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3604, 0xa5},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3605, 0x9f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3607, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360a, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360b, 0x91},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360c, 0x49},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360f, 0x8a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3611, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3612, 0x27},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3613, 0x33},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3615, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3641, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3660, 0x82},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3668, 0x54},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3669, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3667, 0xa0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3702, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3703, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3704, 0x2c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3705, 0x24},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3706, 0x50},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3707, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3708, 0x3c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3709, 0x1f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370a, 0x26},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370b, 0x3c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3720, 0x66},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3722, 0x84},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3728, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372f, 0x90},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3710, 0x28},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3716, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3718, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3719, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x371c, 0xfc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3760, 0x13},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3761, 0x34},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3767, 0x24},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3768, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3769, 0x45},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x376c, 0x23},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d84, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d85, 0x17},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d8c, 0x73},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d8d, 0xbf},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3800, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3801, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3802, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3803, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3804, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3805, 0x97},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3806, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3807, 0x4b},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3808, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3809, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380a, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380b, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380c, 0x12},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380d, 0xc0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380e, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380f, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3810, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3811, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3812, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3813, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3814, 0x31},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3815, 0x31},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3820, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3821, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3834, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3835, 0x1c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3836, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3837, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4000, 0xf1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4001, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x400b, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4011, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401b, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401d, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4020, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4021, 0xE4},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4022, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4023, 0x5F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4024, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4025, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4026, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4027, 0x47},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4028, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4029, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402a, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402b, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402c, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402d, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402e, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402f, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x403d, 0x2c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x403f, 0x7f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4500, 0x82},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4501, 0x38},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4601, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4602, 0x22},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4603, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4837, 0x1b},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d00, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d01, 0x42},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d02, 0xd1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d03, 0x90},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d04, 0x66},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d05, 0x65},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5000, 0x0e},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5001, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5002, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5013, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x501c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x501d, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5242, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5243, 0xb8},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5244, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5245, 0xf9},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5246, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5247, 0xf6},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5248, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5249, 0xa6},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5300, 0xfc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5301, 0xdf},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5302, 0x3f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5303, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5304, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5305, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5306, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5307, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5308, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5309, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x530a, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x530b, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x530c, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x530d, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x530e, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x530f, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5310, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5400, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5401, 0x61},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5402, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5403, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5404, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5405, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x540c, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b00, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b01, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b02, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b03, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b04, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b05, 0x6c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b09, 0x02},
#ifndef OV13850_COLORBAR_TEST
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5e00, 0x00},
#else
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5e00, 0x80},
#endif
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5e10, 0x1c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0100, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3612, 0x27},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370a, 0x26},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372f, 0x90},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3801, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3805, 0x97},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3807, 0x4b},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3808, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3809, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380a, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380b, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380e, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380f, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3813, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3814, 0x31},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3815, 0x31},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3820, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3821, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3836, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3837, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4601, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4603, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4020, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4021, 0xE4},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4022, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4023, 0x5F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4024, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4025, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4026, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4027, 0x47},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4603, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5401, 0x61},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5405, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4800, 0x24}
};
#endif
static struct ov_camera_module_reg
ov13850_regs_2112_1568_30fps_twolane_r2a[] = {
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0300, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0301, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0302, 0x28},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0303, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x030a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x300f, 0x11},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3010, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3011, 0x76},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3012, 0x21},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3013, 0x12},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3014, 0x11},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x301f, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3106, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3210, 0x47},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3500, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3501, 0x60},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3502, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3506, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3507, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3508, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350b, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350f, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x351a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x351b, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x351c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x351d, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x351e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x351f, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3520, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3521, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3600, 0xc0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3601, 0xfc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3602, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3603, 0x78},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3604, 0xb1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3605, 0xb5},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3606, 0x73},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3607, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3609, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360a, 0x30},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360b, 0x91},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360c, 0x09},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360f, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3611, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3612, 0x27},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3613, 0x33},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3615, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3616, 0x0e},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3641, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3660, 0x82},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3668, 0x54},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3669, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x366a, 0x3f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3667, 0xa0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3702, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3703, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3704, 0x2c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3705, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3706, 0x15},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3707, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3708, 0x3c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3709, 0x1f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370a, 0x27},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370b, 0x3c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3720, 0x55},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3722, 0x84},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3728, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372b, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372e, 0x22},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372f, 0x90},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3730, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3731, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3732, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3733, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3710, 0x28},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3716, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3718, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3719, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x371a, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x371c, 0xfc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3748, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3760, 0x13},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3761, 0x33},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3762, 0x86},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3763, 0x16},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3767, 0x24},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3768, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3769, 0x45},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x376c, 0x23},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x376f, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3773, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d84, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d85, 0x17},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d8c, 0x73},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d8d, 0xbf},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3800, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3801, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3802, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3803, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3804, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3805, 0x97},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3806, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3807, 0x4b},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3808, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3809, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380a, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380b, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3810, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3811, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3812, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3813, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3814, 0x31},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3815, 0x31},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3820, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3821, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3823, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3826, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3827, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3834, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3835, 0x1c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3836, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3837, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4000, 0xf1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4001, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4006, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4007, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x400b, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4011, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401b, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401d, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4020, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4021, 0xe4},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4022, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4023, 0xd7},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4024, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4025, 0xbc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4026, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4027, 0xbf},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4028, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4029, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402a, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402b, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402c, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402d, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402e, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402f, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x403d, 0x2c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x403f, 0x7f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4041, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4500, 0x82},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4501, 0x3c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x458b, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x459c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x459d, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x459e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4601, 0x83},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4602, 0x22},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4603, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4837, 0x19},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d00, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d01, 0x42},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d02, 0xd1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d03, 0x90},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d04, 0x66},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d05, 0x65},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d0b, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5000, 0x0e},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5001, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5002, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5013, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x501c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x501d, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x510f, 0xfc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5110, 0xf0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5111, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x536d, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x536e, 0x67},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x536f, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5370, 0x4c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5400, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5400, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5401, 0x61},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5402, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5403, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5404, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5405, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x540c, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5501, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b00, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b01, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b02, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b03, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b04, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b05, 0x6c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b09, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5e00, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5e10, 0x1c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0100, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0100, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3612, 0x27},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370a, 0x26},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372f, 0x90},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3801, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3805, 0x97},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3807, 0x4b},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3808, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3809, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380a, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380b, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380e, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380f, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3813, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3814, 0x31},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3815, 0x31},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3820, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3821, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3836, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3837, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4601, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4603, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4020, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4021, 0xE4},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4022, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4023, 0x5F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4024, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4025, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4026, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4027, 0x47},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4603, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5401, 0x61},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5405, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380c, 0x12},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380d, 0xc0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380e, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380f, 0x80},
};

static struct ov_camera_module_reg
ov13850_regs_4224_3136_7fps_twolane_r2a[] = {
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0300, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0301, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0302, 0x28},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0303, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x030a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x300f, 0x11},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3010, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3011, 0x76},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3012, 0x21},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3013, 0x12},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3014, 0x11},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x301f, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3106, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3210, 0x47},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3500, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3501, 0x60},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3502, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3506, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3507, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3508, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350b, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350f, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x351a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x351b, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x351c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x351d, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x351e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x351f, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3520, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3521, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3600, 0xc0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3601, 0xfc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3602, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3603, 0x78},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3604, 0xb1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3605, 0xb5},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3606, 0x73},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3607, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3609, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360a, 0x30},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360b, 0x91},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360c, 0x09},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360f, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3611, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3612, 0x27},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3613, 0x33},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3615, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3616, 0x0e},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3641, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3660, 0x82},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3668, 0x54},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3669, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x366a, 0x3f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3667, 0xa0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3702, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3703, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3704, 0x2c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3705, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3706, 0x15},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3707, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3708, 0x3c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3709, 0x1f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370a, 0x27},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370b, 0x3c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3720, 0x55},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3722, 0x84},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3728, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372b, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372e, 0x22},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372f, 0x90},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3730, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3731, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3732, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3733, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3710, 0x28},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3716, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3718, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3719, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x371a, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x371c, 0xfc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3748, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3760, 0x13},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3761, 0x33},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3762, 0x86},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3763, 0x16},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3767, 0x24},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3768, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3769, 0x45},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x376c, 0x23},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x376f, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3773, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d84, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d85, 0x17},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d8c, 0x73},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d8d, 0xbf},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3800, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3801, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3802, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3803, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3804, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3805, 0x97},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3806, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3807, 0x4b},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3808, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3809, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380a, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380b, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3810, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3811, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3812, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3813, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3814, 0x31},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3815, 0x31},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3820, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3821, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3823, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3826, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3827, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3834, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3835, 0x1c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3836, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3837, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4000, 0xf1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4001, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4006, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4007, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x400b, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4011, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401b, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401d, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4020, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4021, 0xe4},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4022, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4023, 0xd7},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4024, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4025, 0xbc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4026, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4027, 0xbf},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4028, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4029, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402a, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402b, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402c, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402d, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402e, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402f, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x403d, 0x2c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x403f, 0x7f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4041, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4500, 0x82},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4501, 0x3c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x458b, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x459c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x459d, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x459e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4601, 0x83},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4602, 0x22},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4603, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4837, 0x19},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d00, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d01, 0x42},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d02, 0xd1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d03, 0x90},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d04, 0x66},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d05, 0x65},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d0b, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5000, 0x0e},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5001, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5002, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5013, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x501c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x501d, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x510f, 0xfc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5110, 0xf0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5111, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x536d, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x536e, 0x67},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x536f, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5370, 0x4c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5400, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5400, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5401, 0x61},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5402, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5403, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5404, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5405, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x540c, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5501, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b00, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b01, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b02, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b03, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b04, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b05, 0x6c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b09, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5e00, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5e10, 0x1c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0100, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0100, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3612, 0x27},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370a, 0x26},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372f, 0x90},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3801, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3805, 0x97},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3807, 0x4b},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3808, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3809, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380a, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380b, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380e, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380f, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3813, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3814, 0x31},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3815, 0x31},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3820, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3821, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3836, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3837, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4601, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4603, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4020, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4021, 0xE4},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4022, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4023, 0x5F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4024, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4025, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4026, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4027, 0x47},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4603, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5401, 0x61},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5405, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380c, 0x12},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380d, 0xc0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380e, 0x0d},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380f, 0x00},
};

#else
/* RES_2112x1568_15fps_digital_bin_1lane
 * ;sclk=60Mhz, Mipiclk=640Mbps.
 * ;HTS=0x11a0, VTS=0xd00.
 */
static struct ov_camera_module_reg ov13850_init_tab_2112_1568_15fps[] = {
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0103, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0300, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0301, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0302, 0x28},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0303, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x030a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x300f, 0x11},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3010, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3011, 0x76},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3012, 0x11},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3013, 0x12},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3014, 0x11},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x301f, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3106, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3210, 0x47},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3500, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3501, 0x60},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3502, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3506, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3507, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3508, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350b, 0x3f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350f, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x351a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x351b, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x351c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x351d, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x351e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x351f, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3520, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3521, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3600, 0xc0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3601, 0xfc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3602, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3603, 0x78},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3604, 0xb1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3605, 0x95},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3606, 0x73},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3607, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3609, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360a, 0x30},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360b, 0x91},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360C, 0x09},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360f, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3611, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3612, 0x27},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3613, 0x33},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3615, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3616, 0x0e},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3641, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3660, 0x82},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3668, 0x54},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3669, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x366a, 0x3f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3667, 0xa0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3702, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3703, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3704, 0x2c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3705, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3706, 0x15},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3707, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3708, 0x3c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3709, 0x1f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370a, 0x27},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370b, 0x3c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3720, 0x55},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3722, 0x84},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3728, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372b, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372e, 0x22},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372f, 0xa0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3730, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3731, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3732, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3733, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3710, 0x28},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3716, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3718, 0x1c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3719, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x371a, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x371c, 0xfc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3748, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3760, 0x13},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3761, 0x33},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3762, 0x86},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3763, 0x16},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3767, 0x24},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3768, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3769, 0x45},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x376c, 0x23},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x376f, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3773, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d84, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d85, 0x17},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d8c, 0x73},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d8d, 0xbf},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3800, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3801, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3802, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3803, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3804, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3805, 0x9f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3806, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3807, 0x4b},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3808, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3809, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380a, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380b, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380c, 0x11},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380d, 0xa0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380e, 0x0d},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380f, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3810, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3811, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3812, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3813, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3814, 0x31},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3815, 0x31},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3820, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3821, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3823, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3826, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3827, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3834, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3835, 0x1c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3836, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3837, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4000, 0xf1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4001, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x400b, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4011, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401b, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401d, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4020, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4021, 0xe4},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4022, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4023, 0xd7},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4024, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4025, 0xbc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4026, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4027, 0xbf},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4028, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4029, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402a, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402b, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402c, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402d, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402e, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402f, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x403d, 0x2c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x403f, 0x7F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4041, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4500, 0x82},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4501, 0x3c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x458b, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x459c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x459d, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x459e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4601, 0x83},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4602, 0x22},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4603, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4837, 0x19},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d00, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d01, 0x42},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d02, 0xd1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d03, 0x90},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d04, 0x66},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d05, 0x65},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d0b, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5000, 0x0e},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5001, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5002, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5003, 0x4f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5013, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x501c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x501d, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5100, 0x30},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5101, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5102, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5103, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5104, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5105, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5106, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5107, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5108, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5109, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x510f, 0xfc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5110, 0xf0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5111, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x536d, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x536e, 0x67},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x536f, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5370, 0x4c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5400, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5400, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5401, 0x61},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5402, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5403, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5404, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5405, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x540c, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5501, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b00, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b01, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b02, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b03, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b04, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b05, 0x6c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b09, 0x02},
#ifndef OV13850_COLORBAR_TEST
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5e00, 0x00},
#else
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5e00, 0x80},
#endif
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5e10, 0x1c}
};

#endif

#ifndef OV13850_ONE_LANE
static struct ov_camera_module_config ov13850_configs[] = {
	{
		.name = "2112x1568_30fps",
		.frm_fmt = {
			.width = 2112,
			.height = 1568,
			.code = MEDIA_BUS_FMT_SBGGR10_1X10
		},
		.frm_intrvl = {
			.interval = {
				.numerator = 1,
				.denominator = 30
			}
		},
		.auto_exp_enabled = false,
		.auto_gain_enabled = false,
		.auto_wb_enabled = false,
		.reg_table = (void *)ov13850_regs_2112_1568_30fps_twolane_r2a,
		.reg_table_num_entries =
			sizeof(ov13850_regs_2112_1568_30fps_twolane_r2a) /
			sizeof(ov13850_regs_2112_1568_30fps_twolane_r2a[0]),
		.v_blanking_time_us = 5000,
		.max_exp_gain_h = 16,
		.max_exp_gain_l = 0,
		PLTFRM_CAM_ITF_MIPI_CFG(0, 2, 600, ov13850_EXT_CLK)
	},

	{
		.name = "4224x3136_7fps",
		.frm_fmt = {
			.width = 4224,
			.height = 3136,
			.code = MEDIA_BUS_FMT_SBGGR10_1X10
		},
		.frm_intrvl = {
			.interval = {
				.numerator = 1,
				.denominator = 7
			}
		},
		.auto_exp_enabled = false,
		.auto_gain_enabled = false,
		.auto_wb_enabled = false,
		.reg_table = (void *)ov13850_regs_4224_3136_7fps_twolane_r2a,
		.reg_table_num_entries =
			sizeof(ov13850_regs_4224_3136_7fps_twolane_r2a) /
			sizeof(ov13850_regs_4224_3136_7fps_twolane_r2a[0]),
		.v_blanking_time_us = 5000,
		.max_exp_gain_h = 16,
		.max_exp_gain_l = 0,
		PLTFRM_CAM_ITF_MIPI_CFG(0, 2, 600, ov13850_EXT_CLK)
	}
};
#else
static struct ov_camera_module_config ov13850_onelane_configs[] = {
	{
		.name = "2112x1568_15fps",
		.frm_fmt = {
			.width = 2112,
			.height = 1568,
			.code = MEDIA_BUS_FMT_SBGGR10_1X10
		},
		.frm_intrvl = {
			.interval = {
				.numerator = 1,
				.denominator = 15
			}
		},
		.auto_exp_enabled = false,
		.auto_gain_enabled = false,
		.auto_wb_enabled = false,
		.reg_table = (void *)ov13850_init_tab_2112_1568_15fps,
		.reg_table_num_entries =
			sizeof(ov13850_init_tab_2112_1568_15fps) /
			sizeof(ov13850_init_tab_2112_1568_15fps[0]),
		.v_blanking_time_us = 5000,
		.max_exp_gain_h = 16,
		.max_exp_gain_l = 0,
		PLTFRM_CAM_ITF_MIPI_CFG(0, 1, 640, ov13850_EXT_CLK)
	}
};
#endif

static int ov13850_g_VTS(struct ov_camera_module *cam_mod, u32 *vts)
{
	u32 msb, lsb;
	int ret;

	ret = ov_camera_module_read_reg_table(cam_mod,
		ov13850_TIMING_VTS_HIGH_REG,
		&msb);
	if (IS_ERR_VALUE(ret))
		goto err;

	ret = ov_camera_module_read_reg_table(cam_mod,
		ov13850_TIMING_VTS_LOW_REG,
		&lsb);
	if (IS_ERR_VALUE(ret))
		goto err;

	*vts = (msb << 8) | lsb;

	return 0;
err:
	ov_camera_module_pr_err(cam_mod, "failed with error (%d)\n", ret);
	return ret;
}

static int ov13850_auto_adjust_fps(struct ov_camera_module *cam_mod,
	u32 exp_time)
{
	int ret;
	u32 vts;

	if ((exp_time + ov13850_COARSE_INTG_TIME_MAX_MARGIN)
		> cam_mod->vts_min)
		vts = exp_time + ov13850_COARSE_INTG_TIME_MAX_MARGIN;
	else
		vts = cam_mod->vts_min;
	ret = ov_camera_module_write_reg(cam_mod,
		ov13850_TIMING_VTS_LOW_REG, vts & 0xFF);
	ret |= ov_camera_module_write_reg(cam_mod,
		ov13850_TIMING_VTS_HIGH_REG,
		(vts >> 8) & 0xFF);

	if (IS_ERR_VALUE(ret)) {
		ov_camera_module_pr_err(cam_mod,
			"failed with error (%d)\n", ret);
	} else {
		ov_camera_module_pr_info(cam_mod,
			"updated vts = %d,vts_min=%d\n",
			vts, cam_mod->vts_min);
		cam_mod->vts_cur = vts;
	}

	return ret;
}

static int ov13850_set_vts(struct ov_camera_module *cam_mod,
	u32 vts)
{
	int ret = 0;

	if (vts < cam_mod->vts_min)
		return ret;

	if (vts > 0xfff)
		vts = 0xfff;

	ret = ov_camera_module_write_reg(cam_mod,
		ov13850_TIMING_VTS_LOW_REG, vts & 0xFF);
	ret |= ov_camera_module_write_reg(cam_mod,
		ov13850_TIMING_VTS_HIGH_REG,
		(vts >> 8) & 0xFF);

	if (IS_ERR_VALUE(ret)) {
		ov_camera_module_pr_err(cam_mod, "failed with error (%d)\n", ret);
	} else {
		ov_camera_module_pr_info(cam_mod, "updated vts=%d,vts_min=%d\n", vts, cam_mod->vts_min);
		cam_mod->vts_cur = vts;
	}
	return ret;
}

static int ov13850_write_aec(struct ov_camera_module *cam_mod)
{
	int ret = 0;

	//return ret;  //xhh test

	ov_camera_module_pr_debug(cam_mod,
				  "exp_time = %d, gain = %d, flash_mode = %d\n",
				  cam_mod->exp_config.exp_time,
				  cam_mod->exp_config.gain,
				  cam_mod->exp_config.flash_mode);

	/*
	 * if the sensor is already streaming, write to shadow registers,
	 * if the sensor is in SW standby, write to active registers,
	 * if the sensor is off/registers are not writeable, do nothing
	 */
	if (cam_mod->state == OV_CAMERA_MODULE_SW_STANDBY ||
		cam_mod->state == OV_CAMERA_MODULE_STREAMING) {
		u32 a_gain = cam_mod->exp_config.gain;
		u32 exp_time = cam_mod->exp_config.exp_time;

		a_gain = a_gain * cam_mod->exp_config.gain_percent / 100;

		mutex_lock(&cam_mod->lock);
		if (cam_mod->state == OV_CAMERA_MODULE_STREAMING)
			ret = ov_camera_module_write_reg(cam_mod,
				ov13850_AEC_GROUP_UPDATE_ADDRESS,
				ov13850_AEC_GROUP_UPDATE_START_DATA);
		if (!IS_ERR_VALUE(ret) && cam_mod->auto_adjust_fps)
			ret = ov13850_auto_adjust_fps(cam_mod,
						cam_mod->exp_config.exp_time);
		ret |= ov_camera_module_write_reg(cam_mod,
			ov13850_AEC_PK_LONG_GAIN_HIGH_REG,
			ov13850_FETCH_MSB_GAIN(a_gain));
		ret |= ov_camera_module_write_reg(cam_mod,
			ov13850_AEC_PK_LONG_GAIN_LOW_REG,
			ov13850_FETCH_LSB_GAIN(a_gain));
		ret = ov_camera_module_write_reg(cam_mod,
			ov13850_AEC_PK_LONG_EXPO_3RD_REG,
			ov13850_FETCH_3RD_BYTE_EXP(exp_time));
		ret |= ov_camera_module_write_reg(cam_mod,
			ov13850_AEC_PK_LONG_EXPO_2ND_REG,
			ov13850_FETCH_2ND_BYTE_EXP(exp_time));
		ret |= ov_camera_module_write_reg(cam_mod,
			ov13850_AEC_PK_LONG_EXPO_1ST_REG,
			ov13850_FETCH_1ST_BYTE_EXP(exp_time));
		if (!cam_mod->auto_adjust_fps)
			ret |= ov13850_set_vts(cam_mod, cam_mod->exp_config.vts_value);
		if (cam_mod->state == OV_CAMERA_MODULE_STREAMING) {
			ret = ov_camera_module_write_reg(cam_mod,
				ov13850_AEC_GROUP_UPDATE_ADDRESS,
				ov13850_AEC_GROUP_UPDATE_END_DATA);
			ret = ov_camera_module_write_reg(cam_mod,
				ov13850_AEC_GROUP_UPDATE_ADDRESS,
				ov13850_AEC_GROUP_UPDATE_END_LAUNCH);
		}
		mutex_unlock(&cam_mod->lock);
	}

	if (IS_ERR_VALUE(ret))
		ov_camera_module_pr_err(cam_mod,
			"failed with error (%d)\n", ret);
	return ret;
}

/*--------------------------------------------------------------------------*/

static int ov13850_g_ctrl(struct ov_camera_module *cam_mod, u32 ctrl_id)
{
	int ret = 0;

	ov_camera_module_pr_debug(cam_mod, "\n");

	switch (ctrl_id) {
	case V4L2_CID_GAIN:
	case V4L2_CID_EXPOSURE:
	case V4L2_CID_FLASH_LED_MODE:
		/* nothing to be done here */
		break;
	default:
		ret = -EINVAL;
		break;
	}

	if (IS_ERR_VALUE(ret))
		ov_camera_module_pr_debug(cam_mod,
			"failed with error (%d)\n", ret);
	return ret;
}

static int ov13850_filltimings(struct ov_camera_module_custom_config *custom)
{
	int i, j;
	struct ov_camera_module_config *config;
	struct ov_camera_module_timings *timings;
	struct ov_camera_module_reg *reg_table;
	int reg_table_num_entries;

	for (i = 0; i < custom->num_configs; i++) {
		config = &custom->configs[i];
		reg_table = config->reg_table;
		reg_table_num_entries = config->reg_table_num_entries;
		timings = &config->timings;

		for (j = 0; j < reg_table_num_entries; j++) {
			switch (reg_table[j].reg) {
			case ov13850_TIMING_VTS_HIGH_REG:
				timings->frame_length_lines =
					reg_table[j].val << 8;
				break;
			case ov13850_TIMING_VTS_LOW_REG:
				timings->frame_length_lines |= reg_table[j].val;
				break;
			case ov13850_TIMING_HTS_HIGH_REG:
				timings->line_length_pck =
					(reg_table[j].val << 8);
				break;
			case ov13850_TIMING_HTS_LOW_REG:
				timings->line_length_pck |= reg_table[j].val;
				break;
			case ov13850_TIMING_X_INC:
				timings->binning_factor_x =
					((reg_table[j].val >> 4) + 1) / 2;
				if (timings->binning_factor_x == 0)
					timings->binning_factor_x = 1;
				break;
			case ov13850_TIMING_Y_INC:
				timings->binning_factor_y =
					((reg_table[j].val >> 4) + 1) / 2;
				if (timings->binning_factor_y == 0)
					timings->binning_factor_y = 1;
				break;
			case ov13850_HORIZONTAL_START_HIGH_REG:
				timings->crop_horizontal_start =
					reg_table[j].val << 8;
				break;
			case ov13850_HORIZONTAL_START_LOW_REG:
				timings->crop_horizontal_start |=
					reg_table[j].val;
				break;
			case ov13850_VERTICAL_START_HIGH_REG:
				timings->crop_vertical_start =
					reg_table[j].val << 8;
				break;
			case ov13850_VERTICAL_START_LOW_REG:
				timings->crop_vertical_start |=
					reg_table[j].val;
				break;
			case ov13850_HORIZONTAL_END_HIGH_REG:
				timings->crop_horizontal_end =
					reg_table[j].val << 8;
				break;
			case ov13850_HORIZONTAL_END_LOW_REG:
				timings->crop_horizontal_end |=
					reg_table[j].val;
				break;
			case ov13850_VERTICAL_END_HIGH_REG:
				timings->crop_vertical_end =
					reg_table[j].val << 8;
				break;
			case ov13850_VERTICAL_END_LOW_REG:
				timings->crop_vertical_end |= reg_table[j].val;
				break;
			case ov13850_HORIZONTAL_OUTPUT_SIZE_HIGH_REG:
				timings->sensor_output_width =
					reg_table[j].val << 8;
				break;
			case ov13850_HORIZONTAL_OUTPUT_SIZE_LOW_REG:
				timings->sensor_output_width |=
					reg_table[j].val;
				break;
			case ov13850_VERTICAL_OUTPUT_SIZE_HIGH_REG:
				timings->sensor_output_height =
					reg_table[j].val << 8;
				break;
			case ov13850_VERTICAL_OUTPUT_SIZE_LOW_REG:
				timings->sensor_output_height |=
					reg_table[j].val;
				break;
			}
		}

		timings->vt_pix_clk_freq_hz =
			config->frm_intrvl.interval.denominator *
				timings->frame_length_lines *
				timings->line_length_pck;

		timings->coarse_integration_time_min =
			ov13850_COARSE_INTG_TIME_MIN;
		timings->coarse_integration_time_max_margin =
			ov13850_COARSE_INTG_TIME_MAX_MARGIN;

		/* OV Sensor do not use fine integration time. */
		timings->fine_integration_time_min = ov13850_FINE_INTG_TIME_MIN;
		timings->fine_integration_time_max_margin =
				ov13850_FINE_INTG_TIME_MAX_MARGIN;
	}

	return 0;
}

static int ov13850_g_timings(struct ov_camera_module *cam_mod,
	struct ov_camera_module_timings *timings)
{
	int ret = 0;
	unsigned int vts;

	if (IS_ERR_OR_NULL(cam_mod->active_config))
		goto err;

	*timings = cam_mod->active_config->timings;

	vts = (!cam_mod->vts_cur) ?
		timings->frame_length_lines :
		cam_mod->vts_cur;
	if (cam_mod->frm_intrvl_valid)
		timings->vt_pix_clk_freq_hz =
			cam_mod->frm_intrvl.interval.denominator
			* vts
			* timings->line_length_pck;
	else
		timings->vt_pix_clk_freq_hz =
			cam_mod->active_config->frm_intrvl.interval.denominator
			* vts
			* timings->line_length_pck;

	timings->frame_length_lines = vts;
	return ret;
err:
	ov_camera_module_pr_err(cam_mod, "failed with error (%d)\n", ret);
	return ret;
}

/*--------------------------------------------------------------------------*/

static int ov13850_set_flip(struct ov_camera_module *cam_mod,
	struct pltfrm_camera_module_reg reglist[],
	int len)
{
	int i, mode = 0;
	u16 match_reg[2];

	mode = ov_camera_module_get_flip_mirror(cam_mod);
	if (mode == -1) {
		ov_camera_module_pr_info(cam_mod,
			"dts don't set flip, return!\n");
		return 0;
	}

	if (!IS_ERR_OR_NULL(cam_mod->active_config)) {
		switch (cam_mod->active_config->frm_fmt.width) {
		case ov13850_FULL_SIZE_RESOLUTION_WIDTH:
			if (mode == OV_FLIP_BIT_MASK) {
				match_reg[0] = 0x06;
				match_reg[1] = 0x00;
			} else if (mode == OV_MIRROR_BIT_MASK) {
				match_reg[0] = 0x00;
				match_reg[1] = 0x06;
			} else if (mode == (OV_MIRROR_BIT_MASK |
				OV_FLIP_BIT_MASK)) {
				match_reg[0] = 0x06;
				match_reg[1] = 0x06;
			} else {
				match_reg[0] = 0x00;
				match_reg[1] = 0x00;
			}
			break;
		case ov13850_BINING_SIZE_RESOLUTION_WIDTH:
			if (mode == OV_FLIP_BIT_MASK) {
				match_reg[0] = 0x16;
				match_reg[1] = 0x01;
			} else if (mode == OV_MIRROR_BIT_MASK) {
				match_reg[0] = 0x16;
				match_reg[1] = 0x07;
			} else if (mode == (OV_MIRROR_BIT_MASK |
				OV_FLIP_BIT_MASK)) {
				match_reg[0] = 0x16;
				match_reg[1] = 0x07;
			} else {
				match_reg[0] = 0x10;
				match_reg[1] = 0x01;
			}
			break;
		default:
				return 0;
		}

		for (i = len; i > 0; i--) {
			if (reglist[i].reg == ov13850_FLIP_REG)
				reglist[i].val = match_reg[0];
			else if (reglist[i].reg == ov13850_MIRROR_REG)
				reglist[i].val = match_reg[1];
		}
	}

	return 0;
}

/*--------------------------------------------------------------------------*/

static int ov13850_s_ctrl(struct ov_camera_module *cam_mod, u32 ctrl_id)
{
	int ret = 0;

	ov_camera_module_pr_debug(cam_mod, "\n");

	switch (ctrl_id) {
	case V4L2_CID_GAIN:
	case V4L2_CID_EXPOSURE:
		ret = ov13850_write_aec(cam_mod);
		break;
	case V4L2_CID_FLASH_LED_MODE:
		/* nothing to be done here */
		break;
	default:
		ret = -EINVAL;
		break;
	}

	if (IS_ERR_VALUE(ret))
		ov_camera_module_pr_debug(cam_mod,
			"failed with error (%d) 0x%x\n", ret, ctrl_id);
	return ret;
}

/*--------------------------------------------------------------------------*/

static int ov13850_s_ext_ctrls(struct ov_camera_module *cam_mod,
	struct ov_camera_module_ext_ctrls *ctrls)
{
	int ret = 0;

	/* Handles only exposure and gain together special case. */
	if ((ctrls->ctrls[0].id == V4L2_CID_GAIN ||
		ctrls->ctrls[0].id == V4L2_CID_EXPOSURE))
		ret = ov13850_write_aec(cam_mod);
	else
		ret = -EINVAL;

	if (IS_ERR_VALUE(ret))
		ov_camera_module_pr_debug(cam_mod,
			"failed with error (%d)\n", ret);
	return ret;
}

/*--------------------------------------------------------------------------*/

static int ov13850_start_streaming(struct ov_camera_module *cam_mod)
{
	int ret = 0;

	ov_camera_module_pr_debug(cam_mod,
		"active config=%s\n", cam_mod->active_config->name);

	ret = ov13850_g_VTS(cam_mod, &cam_mod->vts_min);
	if (IS_ERR_VALUE(ret))
		goto err;

	mutex_lock(&cam_mod->lock);
	ret = ov_camera_module_write_reg(cam_mod, 0x0100, 1);
	mutex_unlock(&cam_mod->lock);
	if (IS_ERR_VALUE(ret))
		goto err;

	msleep(25);

	return 0;
err:
	ov_camera_module_pr_err(cam_mod, "failed with error (%d)\n",
		ret);
	return ret;
}

/*--------------------------------------------------------------------------*/

static int ov13850_stop_streaming(struct ov_camera_module *cam_mod)
{
	int ret = 0;

	ov_camera_module_pr_debug(cam_mod, "\n");

	mutex_lock(&cam_mod->lock);
	ret = ov_camera_module_write_reg(cam_mod, 0x0100, 0);
	mutex_unlock(&cam_mod->lock);
	if (IS_ERR_VALUE(ret))
		goto err;

	msleep(25);

	return 0;
err:
	ov_camera_module_pr_err(cam_mod, "failed with error (%d)\n", ret);
	return ret;
}

/*--------------------------------------------------------------------------*/
static int ov13850_check_camera_id(struct ov_camera_module *cam_mod)
{
	u32 pidh, pidl;
	int ret = 0;

	ov_camera_module_pr_debug(cam_mod, "\n");

	ret |= ov_camera_module_read_reg(cam_mod, 1, ov13850_PIDH_ADDR, &pidh);
	ret |= ov_camera_module_read_reg(cam_mod, 1, ov13850_PIDL_ADDR, &pidl);
	if (IS_ERR_VALUE(ret)) {
		ov_camera_module_pr_err(cam_mod,
			"register read failed, camera module powered off?\n");
		goto err;
	}

	if (pidh == ov13850_PIDH_MAGIC && pidl == ov13850_PIDL_MAGIC) {
		ov_camera_module_pr_err(cam_mod,
			"successfully detected camera ID 0x%02x%02x\n",
			pidh, pidl);
	} else {
		ov_camera_module_pr_err(cam_mod,
			"wrong camera ID, expected 0x%02x%02x, detected 0x%02x%02x\n",
			ov13850_PIDH_MAGIC, ov13850_PIDL_MAGIC, pidh, pidl);
		ret = -EINVAL;
		goto err;
	}

	return 0;
err:
	ov_camera_module_pr_err(cam_mod, "failed with error (%d)\n", ret);
	return ret;
}

/* ======================================================================== */
/* This part is platform dependent */
/* ======================================================================== */

static struct v4l2_subdev_core_ops ov13850_camera_module_core_ops = {
	.g_ctrl = ov_camera_module_g_ctrl,
	.s_ctrl = ov_camera_module_s_ctrl,
	.s_ext_ctrls = ov_camera_module_s_ext_ctrls,
	.s_power = ov_camera_module_s_power,
	.ioctl = ov_camera_module_ioctl
};

static struct v4l2_subdev_video_ops ov13850_camera_module_video_ops = {
	.s_frame_interval = ov_camera_module_s_frame_interval,
	.g_frame_interval = ov_camera_module_g_frame_interval,
	.s_stream = ov_camera_module_s_stream
};

static struct v4l2_subdev_pad_ops ov13850_camera_module_pad_ops = {
	.enum_frame_interval = ov_camera_module_enum_frameintervals,
	.get_fmt = ov_camera_module_g_fmt,
	.set_fmt = ov_camera_module_s_fmt,
};

static struct v4l2_subdev_ops ov13850_camera_module_ops = {
	.core = &ov13850_camera_module_core_ops,
	.video = &ov13850_camera_module_video_ops,
	.pad = &ov13850_camera_module_pad_ops
};

static struct ov_camera_module_custom_config ov13850_custom_config = {
	.start_streaming = ov13850_start_streaming,
	.stop_streaming = ov13850_stop_streaming,
	.s_ctrl = ov13850_s_ctrl,
	.s_ext_ctrls = ov13850_s_ext_ctrls,
	.g_ctrl = ov13850_g_ctrl,
	.g_timings = ov13850_g_timings,
	.check_camera_id = ov13850_check_camera_id,
	.s_vts = ov13850_auto_adjust_fps,
	.set_flip = ov13850_set_flip,
#ifdef OV13850_ONE_LANE
	.configs = ov13850_onelane_configs,
	.num_configs = ARRAY_SIZE(ov13850_onelane_configs),

#else
	.configs = ov13850_configs,
	.num_configs = ARRAY_SIZE(ov13850_configs),
#endif
	.power_up_delays_ms = {5, 20, 0},
	/*
	*0: Exposure time valid fileds;
	*1: Exposure gain valid fileds;
	*(2 fileds == 1 frames)
	*/
	.exposure_valid_frame = {4, 4}
};

static int ov13850_probe(struct i2c_client *client,
	const struct i2c_device_id *id)
{
	dev_info(&client->dev, "probing...\n");

	ov13850_filltimings(&ov13850_custom_config);
	v4l2_i2c_subdev_init(&ov13850.sd, client, &ov13850_camera_module_ops);
	ov13850.sd.flags |= V4L2_SUBDEV_FL_HAS_DEVNODE;
	ov13850.custom = ov13850_custom_config;

	mutex_init(&ov13850.lock);
	dev_info(&client->dev, "probing successful\n");
	return 0;
}

static int ov13850_remove(struct i2c_client *client)
{
	struct ov_camera_module *cam_mod = i2c_get_clientdata(client);

	dev_info(&client->dev, "removing device...\n");

	if (!client->adapter)
		return -ENODEV;	/* our client isn't attached */

	mutex_destroy(&cam_mod->lock);
	ov_camera_module_release(cam_mod);

	dev_info(&client->dev, "removed\n");
	return 0;
}

static const struct i2c_device_id ov13850_id[] = {
	{ ov13850_DRIVER_NAME, 0 },
	{ }
};

static const struct of_device_id ov13850_of_match[] = {
	{.compatible = "omnivision,ov13850-v4l2-i2c-subdev"},
	{},
};

MODULE_DEVICE_TABLE(i2c, ov13850_id);

static struct i2c_driver ov13850_i2c_driver = {
	.driver = {
		.name = ov13850_DRIVER_NAME,
		.owner = THIS_MODULE,
		.of_match_table = ov13850_of_match
	},
	.probe = ov13850_probe,
	.remove = ov13850_remove,
	.id_table = ov13850_id,
};

module_i2c_driver(ov13850_i2c_driver);

MODULE_DESCRIPTION("SoC Camera driver for ov13850");
MODULE_AUTHOR("George");
MODULE_LICENSE("GPL");
