// SPDX-License-Identifier: GPL-2.0
/*
 * ISL79987 sensor driver
 *
 * Copyright (C) 2018 Fuzhou Rockchip Electronics Co.,  Ltd.
 *
 * Copyright (C) 2012-2014 Intel Mobile Communications GmbH
 *
 * Copyright (C) 2008 Texas Instruments.
 *
 * This file is licensed under the terms of the GNU General Public License
 * version 2. This program is licensed "as is" without any warranty of any
 * kind,  whether express or implied.
 *
 * Note:
 *
 * v0.1.0:
 * 1. Initialize version;
 */

#include <linux/i2c.h>
#include <linux/io.h>
#include <linux/delay.h>
#include <linux/module.h>
#include <media/v4l2-subdev.h>
#include <media/videobuf-core.h>
#include <linux/slab.h>
#include <media/v4l2-controls_rockchip.h>
#include "ov_camera_module.h"

#define ISL79987_DRIVER_NAME "ISL79987"

/* ======================================================================== */
/* Base sensor configs */
/* ======================================================================== */
/* MCLK:24MHz 724 x (240*4) 60fps yuv422_2*8 mipi 2lane 432Mbps/lane */
static struct ov_camera_module_reg ISL79987_init_tab_724_960_60fps[] = {
/* Page00 */
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xFF, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x00, 0x87},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x01, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x02, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x03, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x04, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x05, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x06, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x07, 0x12},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x08, 0x1F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x09, 0x43},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0A, 0x4F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0B, 0x41},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0C, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0D, 0xC9},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0E, 0xC9},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x10, 0x0F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x11, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x12, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x13, 0x0C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x14, 0x0D},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x15, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x16, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x17, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x18, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x19, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x1A, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x1B, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x1C, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x1D, 0x0C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x1E, 0x0C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x1F, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x20, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3F, 0x00},

/* Page01 */
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xFF, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x02, 0x48},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x03, 0x78},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x04, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x06, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x07, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x08, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x09, 0xF0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0A, 0x0F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0B, 0xD0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0C, 0xCC},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0D, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x10, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x11, 0x64},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x12, 0x11},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x13, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x14, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x15, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x17, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x18, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x1C, 0x0F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x1D, 0x7F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x20, 0x50},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x21, 0x22},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x22, 0xF0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x23, 0xD8},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x24, 0xBC},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x25, 0xB8},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x26, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x27, 0x38},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x28, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x29, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2A, 0x78},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2B, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2C, 0x30},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2D, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2E, 0xA5},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2F, 0xE6},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x30, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x31, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x32, 0xFF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x33, 0x85},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x34, 0x1A},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x35, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x36, 0xB0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x38, 0x2C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x39, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3A, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3B, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3C, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3D, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3F, 0x1A},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x80, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x81, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x82, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x83, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x84, 0x09},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x85, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x86, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x87, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x88, 0x38},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x89, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8A, 0x1C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8B, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8C, 0x0A},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8D, 0x1F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8E, 0x1A},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8F, 0x0C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x90, 0x0C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x91, 0x0C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x92, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x93, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x94, 0x0C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x95, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x96, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x97, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x98, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x99, 0x68},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x9A, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x9B, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x9C, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA0, 0x97},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA1, 0x96},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA2, 0x5D},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA3, 0xC2},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA4, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA5, 0xE2},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA6, 0xF1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA7, 0xF3},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA8, 0xFD},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA9, 0x32},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAA, 0x3F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAB, 0x49},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAC, 0x4D},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAD, 0x53},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAE, 0x96},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAF, 0xC0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB0, 0x45},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB1, 0x87},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB2, 0xB7},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB3, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB4, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB5, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC0, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC1, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC2, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC3, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC4, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC5, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC6, 0xCF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC7, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC8, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC9, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCA, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCB, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCC, 0xEF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCD, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCE, 0xCF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCF, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD0, 0xEF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD1, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD2, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD3, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD4, 0x78},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD5, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD6, 0x68},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD7, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD8, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD9, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDA, 0x67},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDB, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDC, 0xEF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDD, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDE, 0xCF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDF, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE0, 0x77},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE1, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE2, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE3, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE4, 0x19},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE5, 0xBD},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE6, 0x50},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE7, 0x00},
/* Page02 */
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xFF, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x02, 0x48},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x03, 0x78},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x04, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x06, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x07, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x08, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x09, 0xF0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0A, 0x0F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0B, 0xD0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0C, 0xCC},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0D, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x10, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x11, 0x64},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x12, 0x11},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x13, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x14, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x15, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x17, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x18, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x1C, 0x0F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x1D, 0x7F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x20, 0x50},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x21, 0x22},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x22, 0xF0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x23, 0xD8},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x24, 0xBC},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x25, 0xB8},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x26, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x27, 0x38},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x28, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x29, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2A, 0x78},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2B, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2C, 0x30},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2D, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2E, 0xA5},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2F, 0xE6},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x30, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x31, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x32, 0xFF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x33, 0x85},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x34, 0x1A},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x35, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x36, 0xB0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x38, 0x2C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x39, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3A, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3B, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3C, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3D, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3F, 0x1A},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x80, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x81, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x82, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x83, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x84, 0x09},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x85, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x86, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x87, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x88, 0x38},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x89, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8A, 0x1C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8B, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8C, 0x0A},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8D, 0x1F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8E, 0x1A},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8F, 0x0C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x90, 0x0C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x91, 0x0C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x92, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x93, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x94, 0x0C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x95, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x96, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x97, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x98, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x99, 0x68},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x9A, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x9B, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x9C, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA0, 0x97},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA1, 0x96},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA2, 0x5D},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA3, 0xC2},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA4, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA5, 0xE2},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA6, 0xF1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA7, 0xF3},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA8, 0xFD},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA9, 0x32},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAA, 0x3F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAB, 0x49},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAC, 0x4D},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAD, 0x53},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAE, 0x96},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAF, 0xC0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB0, 0x45},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB1, 0x87},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB2, 0xB7},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB3, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB4, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB5, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC0, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC1, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC2, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC3, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC4, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC5, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC6, 0xCF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC7, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC8, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC9, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCA, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCB, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCC, 0xEF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCD, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCE, 0xCF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCF, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD0, 0xEF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD1, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD2, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD3, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD4, 0x78},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD5, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD6, 0x68},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD7, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD8, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD9, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDA, 0x67},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDB, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDC, 0xEF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDD, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDE, 0xCF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDF, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE0, 0x77},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE1, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE2, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE3, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE4, 0x19},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE5, 0xBD},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE6, 0x50},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE7, 0x00},

/* Page03 */
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xFF, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x02, 0x48},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x03, 0x78},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x04, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x06, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x07, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x08, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x09, 0xF0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0A, 0x0F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0B, 0xD0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0C, 0xCC},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0D, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x10, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x11, 0x64},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x12, 0x11},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x13, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x14, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x15, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x17, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x18, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x1C, 0x0F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x1D, 0x7F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x20, 0x50},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x21, 0x22},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x22, 0xF0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x23, 0xD8},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x24, 0xBC},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x25, 0xB8},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x26, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x27, 0x38},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x28, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x29, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2A, 0x78},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2B, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2C, 0x30},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2D, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2E, 0xA5},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2F, 0xE6},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x30, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x31, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x32, 0xFF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x33, 0x85},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x34, 0x1A},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x35, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x36, 0xB0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x38, 0x2C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x39, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3A, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3B, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3C, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3D, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3F, 0x1A},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x80, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x81, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x82, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x83, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x84, 0x09},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x85, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x86, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x87, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x88, 0x38},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x89, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8A, 0x1C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8B, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8C, 0x0A},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8D, 0x1F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8E, 0x1A},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8F, 0x0C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x90, 0x0C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x91, 0x0C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x92, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x93, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x94, 0x0C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x95, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x96, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x97, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x98, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x99, 0x68},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x9A, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x9B, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x9C, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA0, 0x97},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA1, 0x96},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA2, 0x5D},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA3, 0xC2},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA4, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA5, 0xE2},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA6, 0xF1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA7, 0xF3},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA8, 0xFD},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA9, 0x32},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAA, 0x3F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAB, 0x49},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAC, 0x4D},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAD, 0x53},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAE, 0x96},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAF, 0xC0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB0, 0x45},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB1, 0x87},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB2, 0xB7},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB3, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB4, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB5, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC0, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC1, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC2, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC3, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC4, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC5, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC6, 0xCF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC7, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC8, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC9, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCA, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCB, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCC, 0xEF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCD, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCE, 0xCF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCF, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD0, 0xEF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD1, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD2, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD3, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD4, 0x78},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD5, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD6, 0x68},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD7, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD8, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD9, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDA, 0x67},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDB, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDC, 0xEF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDD, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDE, 0xCF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDF, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE0, 0x77},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE1, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE2, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE3, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE4, 0x19},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE5, 0xBD},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE6, 0x50},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE7, 0x00},
/* page04 */
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xFF, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x02, 0x48},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x03, 0x78},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x04, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x06, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x07, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x08, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x09, 0xF0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0A, 0x0F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0B, 0xD0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0C, 0xCC},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0D, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x10, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x11, 0x64},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x12, 0x11},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x13, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x14, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x15, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x17, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x18, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x1C, 0x0F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x1D, 0x7F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x20, 0x50},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x21, 0x22},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x22, 0xF0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x23, 0xD8},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x24, 0xBC},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x25, 0xB8},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x26, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x27, 0x38},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x28, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x29, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2A, 0x78},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2B, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2C, 0x30},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2D, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2E, 0xA5},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2F, 0xE6},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x30, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x31, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x32, 0xFF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x33, 0x85},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x34, 0x1A},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x35, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x36, 0xB0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x38, 0x2C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x39, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3A, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3B, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3C, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3D, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3F, 0x1A},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x80, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x81, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x82, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x83, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x84, 0x09},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x85, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x86, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x87, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x88, 0x38},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x89, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8A, 0x1C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8B, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8C, 0x0A},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8D, 0x1F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8E, 0x1A},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x8F, 0x0C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x90, 0x0C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x91, 0x0C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x92, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x93, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x94, 0x0C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x95, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x96, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x97, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x98, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x99, 0x68},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x9A, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x9B, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x9C, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA0, 0x97},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA1, 0x96},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA2, 0x5D},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA3, 0xC2},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA4, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA5, 0xE2},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA6, 0xF1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA7, 0xF3},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA8, 0xFD},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xA9, 0x32},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAA, 0x3F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAB, 0x49},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAC, 0x4D},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAD, 0x53},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAE, 0x96},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xAF, 0xC0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB0, 0x45},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB1, 0x87},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB2, 0xB7},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB3, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB4, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xB5, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC0, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC1, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC2, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC3, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC4, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC5, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC6, 0xCF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC7, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC8, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xC9, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCA, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCB, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCC, 0xEF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCD, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCE, 0xCF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xCF, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD0, 0xEF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD1, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD2, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD3, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD4, 0x78},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD5, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD6, 0x68},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD7, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD8, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xD9, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDA, 0x67},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDB, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDC, 0xEF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDD, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDE, 0xCF},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xDF, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE0, 0x77},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE1, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE2, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE3, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE4, 0x19},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE5, 0xBD},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE6, 0x50},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xE7, 0x00},
/* Page05 */
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0xFF, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x00, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x01, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x02, 0xA0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x03, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x04, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x05, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x06, 0x61},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x07, 0x2B},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x08, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x09, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0A, 0x62},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0B, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0C, 0x36},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0D, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0E, 0x6C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0F, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x10, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x11, 0xA0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x12, 0x77},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x13, 0x17},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x14, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x15, 0x38},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x16, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x17, 0xF6},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x18, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x19, 0x17},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x1A, 0x0A},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x1B, 0x71},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x1C, 0x7A},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x1D, 0x0F},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x1E, 0x8C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x1F, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x20, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x21, 0x0C},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x22, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x24, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x25, 0xF0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x26, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x28, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x29, 0x0E},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2A, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2B, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2C, 0x18},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2D, 0xF1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2E, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x2F, 0xF1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x30, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x31, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x32, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x33, 0xC0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x34, 0x18},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x35, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x36, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x38, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x39, 0xC0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3A, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3B, 0xB3},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3C, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3D, 0xF1},

};

static struct ov_camera_module_config ISL79987_configs[] = {
	{
		.name = "724x960_60fps",	/* "724x(240*4)_30fps" */
		.frm_fmt = {
			.width = 724,
			.height = (240 * 4),
			.code = MEDIA_BUS_FMT_UYVY8_2X8
		},
		.frm_intrvl = {
			.interval = {
				.numerator = 1,
				.denominator = 60
			}
		},
		.auto_exp_enabled = false,
		.auto_gain_enabled = false,
		.auto_wb_enabled = false,
		.reg_table = (void *)ISL79987_init_tab_724_960_60fps,
		.reg_table_num_entries = ARRAY_SIZE(ISL79987_init_tab_724_960_60fps),
		.v_blanking_time_us = 1600,
		PLTFRM_CAM_ITF_MIPI_CFG(0, 2, 432, ISL79987_EXT_CLK)
	}
};

static int ISL79987_set_flip(struct ov_camera_module *cam_mod,
			     struct pltfrm_camera_module_reg reglist[], int len)
{
	ov_camera_module_pr_err(cam_mod, "========> %s %d\n",
				__func__, __LINE__);
	return 0;
}

static int ISL79987_g_VTS(struct ov_camera_module *cam_mod, u32 *vts)
{
	ov_camera_module_pr_err(cam_mod, "========> %s %d\n",
				__func__, __LINE__);
	return 0;
}

static int ISL79987_g_ctrl(struct ov_camera_module *cam_mod, u32 ctrl_id)
{
	int ret = 0;

	ov_camera_module_pr_debug(cam_mod, "========> %s %d\n",
				  __func__, __LINE__);
	switch (ctrl_id) {
	case V4L2_CID_GAIN:
	case V4L2_CID_EXPOSURE:
	case V4L2_CID_FLASH_LED_MODE:
		/* nothing to be done here */
		break;
	default:
		ret = -EINVAL;
		break;
	}

	if (IS_ERR_VALUE(ret))
		ov_camera_module_pr_debug(cam_mod, "failed with error (%d)\n",
					  ret);
	return ret;
}

static int ISL79987_filltimings(struct ov_camera_module_custom_config *custom)
{
	return 0;
}

static int ISL79987_g_timings(struct ov_camera_module *cam_mod,
			      struct ov_camera_module_timings *timings)
{
	ov_camera_module_pr_err(cam_mod, "========> %s %d\n",
				__func__, __LINE__);
	return 0;
}

static int ISL79987_s_ctrl(struct ov_camera_module *cam_mod, u32 ctrl_id)
{
	ov_camera_module_pr_debug(cam_mod, "\n");
	return 0;
}

static int ISL79987_s_ext_ctrls(struct ov_camera_module *cam_mod,
				struct ov_camera_module_ext_ctrls *ctrls)
{
	return 0;
}

static int ISL79987_start_streaming(struct ov_camera_module *cam_mod)
{
	int ret = 0;

	ov_camera_module_pr_info(cam_mod, "active config=%s\n",
				 cam_mod->active_config->name);
	ret = ISL79987_g_VTS(cam_mod, &cam_mod->vts_min);
	if (IS_ERR_VALUE(ret))
		goto err;

	/*
	 * mutex_lock(&cam_mod->lock);
	 * ret = ov_camera_module_write_reg(cam_mod,  0x3012,  0x01);
	 * mutex_unlock(&cam_mod->lock);
	 * if (IS_ERR_VALUE(ret))
	 * goto err;
	 */

	msleep(25);
	return 0;
err:
	ov_camera_module_pr_err(cam_mod, "failed with error (%d)\n", ret);
	return ret;
}

static int ISL79987_stop_streaming(struct ov_camera_module *cam_mod)
{
	return 0;
}

static int ISL79987_check_camera_id(struct ov_camera_module *cam_mod)
{
	u32 pid;
	int ret = 0;

	ov_camera_module_pr_debug(cam_mod, "========> %s %d\n",
				  __func__, __LINE__);
	ov_camera_module_pr_debug(cam_mod, "\n");
	ov_camera_module_write_reg(cam_mod, 0xff, 0x00);

	ret |= ov_camera_module_read_reg(cam_mod, 1, 0x00, &pid);
	if (IS_ERR_VALUE(ret)) {
		ov_camera_module_pr_err(cam_mod,
					"register read failed,  camera module powered off?\n");
		goto err;
	}

	if (pid == 0x87) {
		ov_camera_module_pr_info(cam_mod,
					 "successfully detected camera ID 0x%02x\n",
					 pid);
	} else {
		ov_camera_module_pr_err(cam_mod,
					"wrong camera ID 0x%02x\n", pid);
		ret = -EINVAL;
		goto err;
	}

	return 0;
err:
	ov_camera_module_pr_err(cam_mod, "failed with error (%d)\n", ret);
	return ret;
}

/* ======================================================================== */
/* This part is platform dependent */
/* ======================================================================== */

static struct v4l2_subdev_core_ops ISL79987_camera_module_core_ops = {
	.g_ctrl = ov_camera_module_g_ctrl,
	.s_ctrl = ov_camera_module_s_ctrl,
	.s_ext_ctrls = ov_camera_module_s_ext_ctrls,
	.s_power = ov_camera_module_s_power,
	.ioctl = ov_camera_module_ioctl
};

static struct v4l2_subdev_video_ops ISL79987_camera_module_video_ops = {
	.s_frame_interval = ov_camera_module_s_frame_interval,
	.s_stream = ov_camera_module_s_stream
};

static struct v4l2_subdev_pad_ops ISL79987_camera_module_pad_ops = {
	.enum_frame_interval = ov_camera_module_enum_frameintervals,
	.get_fmt = ov_camera_module_g_fmt,
	.set_fmt = ov_camera_module_s_fmt,
};

static struct v4l2_subdev_ops ISL79987_camera_module_ops = {
	.core = &ISL79987_camera_module_core_ops,
	.video = &ISL79987_camera_module_video_ops,
	.pad = &ISL79987_camera_module_pad_ops
};

static struct ov_camera_module ISL79987;

static struct ov_camera_module_custom_config ISL79987_custom_config = {
	.start_streaming = ISL79987_start_streaming,
	.stop_streaming = ISL79987_stop_streaming,
	.s_ctrl = ISL79987_s_ctrl,
	.g_ctrl = ISL79987_g_ctrl,
	.s_ext_ctrls = ISL79987_s_ext_ctrls,
	.g_timings = ISL79987_g_timings,
	.set_flip = ISL79987_set_flip,
	.check_camera_id = ISL79987_check_camera_id,
	.configs = ISL79987_configs,
	.num_configs = ARRAY_SIZE(ISL79987_configs),
	.power_up_delays_ms = {5, 30, 30},
};

static int ISL79987_probe(struct i2c_client *client,
			  const struct i2c_device_id *id)
{
	dev_info(&client->dev, "probing...\n");
	ISL79987_filltimings(&ISL79987_custom_config);

	v4l2_i2c_subdev_init(&ISL79987.sd, client, &ISL79987_camera_module_ops);
	ISL79987.sd.flags |= V4L2_SUBDEV_FL_HAS_DEVNODE;

	ISL79987.custom = ISL79987_custom_config;
	/* mutex_init(&ISL79987.lock); */
	dev_info(&client->dev, "probing successful\n");

	return 0;
}

static int ISL79987_remove(struct i2c_client *client)
{
	struct ov_camera_module *cam_mod = i2c_get_clientdata(client);

	dev_info(&client->dev, "removing device...\n");

	if (!client->adapter)
		return -ENODEV;
	/* mutex_destroy(&cam_mod->lock); */
	ov_camera_module_release(cam_mod);

	dev_info(&client->dev, "removed\n");
	return 0;
}

static const struct i2c_device_id ISL79987_id[] = {
	{
		ISL79987_DRIVER_NAME,
		0
	},
	{}
};

static const struct of_device_id ISL79987_of_match[] = {
	{
		.compatible = "omnivision,ISL79987-v4l2-i2c-subdev"
	},
	{},
};

MODULE_DEVICE_TABLE(i2c, ISL79987_id);

static struct i2c_driver ISL79987_i2c_driver = {
	.driver = {
		.name = ISL79987_DRIVER_NAME,
		.of_match_table = ISL79987_of_match
	},
	.probe = ISL79987_probe,
	.remove = ISL79987_remove,
	.id_table = ISL79987_id,
};

module_i2c_driver(ISL79987_i2c_driver);

MODULE_DESCRIPTION("SoC Camera driver for ISL79987");
MODULE_AUTHOR("Eike Grimpe");
MODULE_LICENSE("GPL");
