/* SPDX-License-Identifier: GPL-2.0 */
/********************************************************************************
 *
 *  Copyright (C) 2017 	NEXTCHIP Inc. All rights reserved.
 *  Module		: video_eq_table.c
 *  Description	:
 *  Author		:
 *  Date         :
 *  Version		: Version 1.0
 *
 ********************************************************************************
 *  History      :
 *
 *
 ********************************************************************************/
#ifndef _CABLE_A_VIDEO_EQ_TABLE_H_
#define _CABLE_A_VIDEO_EQ_TABLE_H_

#include "jaguar1_common.h"
#include "jaguar1_video_eq.h"

/*=====================================================================================
 * Cable : 3C2V
 *=====================================================================================*/
_jaguar1_video_eq_value_table_s equalizer_value_fmtdef_cableA[ ] =
{
	[ AHD20_SD_H720_NT_SINGLE_ENDED ] =
	{
		.name         = "AHD20_SD_H720_NT_SINGLE_ENDED",
		.video_fmt    = AHD20_SD_SH720_NT,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.eq_gain_sel = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deq_a_on = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deq_a_sel = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.c_filter = { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0xD4, 0xD4, 0xD4, 0xD4, 0xD4, 0xD4 },
			.h_delay_b = { 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },
		},
		/* clock */
		{
			.clk_adc = { 0x06, 0x06, 0x06, 0x06, 0x06, 0x06 },
			.clk_adc_pre= { 0x07, 0x07, 0x07, 0x07, 0x07, 0x07 },
			.clk_adc_post = { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_scaler2 = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.sd_mode= { 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },
			.spl_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.vblk_end = { 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
		},
	},

	[ AHD20_SD_H720_PAL_SINGLE_ENDED ] =
	{
		.name         = "AHD20_SD_H720_PAL_SINGLE_ENDED",
		.video_fmt    = AHD20_SD_SH720_PAL,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.eq_gain_sel = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deq_a_on = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deq_a_sel = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.c_filter = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.pal_cm_off= { 0x02, 0x02, 0x02, 0x02, 0x02, 0x02 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8 },
			.h_delay_b = { 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },
		},
		{
			.clk_adc = { 0x06, 0x06, 0x06, 0x06, 0x06, 0x06 },
			.clk_adc_pre= { 0x07, 0x07, 0x07, 0x07, 0x07, 0x07 },
			.clk_adc_post = { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
		},
		{
			.h_scaler1 = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_scaler2 = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.fsc_lock_speed = { 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc },
			.ahd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.sd_mode= { 0x05, 0x05, 0x05, 0x05, 0x05, 0x05 },
			.spl_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.vblk_end = { 0x21, 0x21, 0x21, 0x21, 0x21, 0x21 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
		},
	},
	[ AHD20_SD_H1440_NT_SINGLE_ENDED ] =
	{
		.name         = "AHD20_SD_H1440_NT_SINGLE_ENDED",
		.video_fmt    = AHD20_SD_H1440_NT,
		.analog_input = SINGLE_ENDED,
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.eq_gain_sel = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deq_a_on = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deq_a_sel = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
		},
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		{
			.contrast = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.c_filter = { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		{
			.h_delay_a = { 0xD4, 0xD4, 0xD4, 0xD4, 0xD4, 0xD4 },
			.h_delay_b = { 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },
		},
		{
			.clk_adc = { 0x06, 0x06, 0x06, 0x06, 0x06, 0x06 },
			.clk_adc_pre= { 0x07, 0x07, 0x07, 0x07, 0x07, 0x07 },
			.clk_adc_post = { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
		},
		{
			.h_scaler1 = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_scaler2 = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.sd_mode= { 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },
			.spl_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.vblk_end = { 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
		},
	},
	[ AHD20_SD_H1440_PAL_SINGLE_ENDED ] =
	{
		.name         = "AHD20_SD_H1440_PAL_SINGLE_ENDED",
		.video_fmt    = AHD20_SD_H1440_PAL,
		.analog_input = SINGLE_ENDED,
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.eq_gain_sel = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deq_a_on = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deq_a_sel = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
		},
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		{
			.contrast = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.c_filter = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.pal_cm_off= { 0x02, 0x02, 0x02, 0x02, 0x02, 0x02 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		{
			.h_delay_a = { 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8 },
			.h_delay_b = { 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },
		},
		/* clock */
		{
			.clk_adc = { 0x06, 0x06, 0x06, 0x06, 0x06, 0x06 },
			.clk_adc_pre= { 0x07, 0x07, 0x07, 0x07, 0x07, 0x07 },
			.clk_adc_post = { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_scaler2 = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.fsc_lock_speed = { 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc },
			.ahd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.sd_mode= { 0x05, 0x05, 0x05, 0x05, 0x05, 0x05 },
			.spl_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.vblk_end = { 0x21, 0x21, 0x21, 0x21, 0x21, 0x21 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
		},
	},

	//=======================================================================================================


	[ AHD20_SD_H960_2EX_Btype_NT_SINGLE_ENDED ] =
	{
		.name         = "AHD20_SD_H960_2EX_Btype_NT_SINGLE_ENDED",
		.video_fmt    = AHD20_SD_H960_2EX_Btype_NT,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x77, 0x77, 0x77 },
			.eq_gain_sel = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deq_a_on = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deq_a_sel = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x8, 0x8, 0x8, 0x8, 0x8, 0x8 },
			.c_filter = { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x70, 0x70, 0x70, 0x70, 0x70, 0x70 },
			.h_delay_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_scaler2 = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.sd_mode= { 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },
			.spl_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.vblk_end = { 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
		},
	},

	[ AHD20_SD_H960_2EX_Btype_PAL_SINGLE_ENDED ] =
	{
		.name         = "AHD20_SD_H960_2EX_Btype_PAL_SINGLE_ENDED",
		.video_fmt    = AHD20_SD_H960_2EX_Btype_PAL,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x77, 0x77, 0x77 },
			.eq_gain_sel = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deq_a_on = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deq_a_sel = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x8, 0x8, 0x8, 0x8, 0x8, 0x8 },
			.c_filter = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x68, 0x68, 0x68, 0x68, 0x68, 0x68 },
			.h_delay_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x7, 0x7, 0x7, 0x7, 0x7, 0x7 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_scaler2 = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.fsc_lock_speed = { 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc },
			.ahd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.sd_mode= { 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },
			.spl_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.vblk_end = { 0x21, 0x21, 0x21, 0x21, 0x21, 0x21 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
		},
	},

#if 0
	[ AHD20_SD_H960_2EX_Btype_PAL_SINGLE_ENDED ] =
	{
		.name         = "AHD20_SD_H960_2EX_Btype_PAL_SINGLE_ENDED",
		.video_fmt    = AHD20_SD_H960_2EX_Btype_PAL,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x77, 0x77, 0x77 },
			.eq_gain_sel = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deq_a_on = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deq_a_sel = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x8, 0x8, 0x8, 0x8, 0x8, 0x8 },
			.c_filter = { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.pal_cm_off= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x60, 0x60, 0x60, 0x60, 0x60, 0x60 },
			.h_delay_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_scaler2 = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.sd_mode= { 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },
			.spl_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.vblk_end = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
		},
	},
#endif
	[ AHD20_1080P_30P_SINGLE_ENDED ] =
	{
		.name         = "AHD20_1080P_30P_SINGLE_ENDED",
		.video_fmt    = AHD20_1080P_30P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x77, 0x57, 0x57 },
			.eq_gain_sel = { 0x78, 0x7b, 0x7f, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x91, 0x87, 0x89, 0x93, 0x94 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x86, 0x82, 0x82, 0x7e, 0x7c, 0x77 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0xf, 0xf },
			.c_filter = { 0x82, 0x82, 0x82, 0x82, 0xa2, 0xb2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0xfe, 0xfe, 0xfe },
			.u_gain = { 0x0, 0x0, 0x4, 0x10, 0x10, 0x18 },
			.v_gain = { 0x0, 0x0, 0xf0, 0xe, 0xe, 0x14 },
			.u_offset = { 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe },
			.v_offset = { 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb },
			.black_level = { 0x80, 0x81, 0x81, 0x83, 0x83, 0x87 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xa8, 0xa8, 0xa8, 0x90, 0x90 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x90, 0x90, 0x90, 0xa0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x48, 0x48, 0x48, 0x48, 0x48, 0x48 },
			.h_delay_b = { 0x13, 0x13, 0x13, 0x13, 0x13, 0x13 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.vblk_end = { 0x21, 0x21, 0x21, 0x21, 0x21, 0x21 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ AHD20_1080P_25P_SINGLE_ENDED ] =
	{
		.name         = "AHD20_1080P_25P_SINGLE_ENDED",
		.video_fmt    = AHD20_1080P_25P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x77, 0x57, 0x57 },
			.eq_gain_sel = { 0x78, 0x7b, 0x7f, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x91, 0x87, 0x89, 0x93, 0x94 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x86, 0x82, 0x82, 0x7e, 0x7c, 0x77 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0xf, 0xf },
			.c_filter = { 0x82, 0x82, 0x82, 0x82, 0xa2, 0xb2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0xfe, 0xfe, 0xfe },
			.u_gain = { 0x0, 0x0, 0x4, 0x10, 0x10, 0x18 },
			.v_gain = { 0x0, 0x0, 0xf0, 0x0e, 0xe, 0x14 },
			.u_offset = { 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe },
			.v_offset = { 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb },
			.black_level = { 0x80, 0x81, 0x81, 0x83, 0x83, 0x87 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xa8, 0xa8, 0xa8, 0x90, 0x90 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x90, 0x90, 0x90, 0xa0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x48, 0x48, 0x48, 0x48, 0x48, 0x48 },
			.h_delay_b = { 0x13, 0x13, 0x13, 0x13, 0x13, 0x13 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x3, 0x3, 0x3, 0x3, 0x3, 0x3 },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.vblk_end = { 0x21, 0x21, 0x21, 0x21, 0x21, 0x21 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ AHD20_720P_60P_SINGLE_ENDED ] =
	{
		.name         = "AHD20_720P_60P_SINGLE_ENDED",
		.video_fmt    = AHD20_720P_60P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x77, 0x57, 0x57 },
			.eq_gain_sel = { 0x78, 0x7b, 0x7f, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x91, 0x87, 0x89, 0x93, 0x94 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x86, 0x82, 0x82, 0x7e, 0x7c, 0x77 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0xf, 0xf },
			.c_filter = { 0x82, 0x82, 0x82, 0x82, 0xa2, 0xb2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x3, 0x3, 0x3, 0x3, 0x3, 0x3 },
			.u_gain = { 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc },
			.v_gain = { 0x0, 0x0, 0xf0, 0xe, 0xe, 0x14 },
			.u_offset = { 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8 },
			.v_offset = { 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8 },
			.black_level = { 0x80, 0x80, 0x80, 0x83, 0x83, 0x87 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xa8, 0xa8, 0xa8, 0x90, 0x90 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x90, 0x90, 0x90, 0xa0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.h_delay_b = { 0x14, 0x14, 0x14, 0x14, 0x14, 0x14 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.vblk_end = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ AHD20_720P_50P_SINGLE_ENDED ] =
	{
		.name         = "AHD20_720P_50P_SINGLE_ENDED",
		.video_fmt    = AHD20_720P_50P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x77, 0x57, 0x57 },
			.eq_gain_sel = { 0x78, 0x7b, 0x7f, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x91, 0x87, 0x89, 0x93, 0x94 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x86, 0x82, 0x82, 0x7e, 0x7c, 0x77 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0xf, 0xf },
			.c_filter = { 0x82, 0x82, 0x82, 0x82, 0xa2, 0xb2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x3, 0x3, 0x3, 0x3, 0x3, 0x3 },
			.u_gain = { 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc },
			.v_gain = { 0x0, 0x0, 0xf0, 0xe, 0xe, 0x14 },
			.u_offset = { 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8 },
			.v_offset = { 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8 },
			.black_level = { 0x80, 0x80, 0x80, 0x83, 0x83, 0x87 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xa8, 0xa8, 0xa8, 0x90, 0x90 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x90, 0x90, 0x90, 0xa0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x48, 0x48, 0x48, 0x48, 0x48, 0x48 },
			.h_delay_b = { 0x13, 0x13, 0x13, 0x13, 0x13, 0x13 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.vblk_end = { 0x21, 0x21, 0x21, 0x21, 0x21, 0x21 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ AHD20_720P_25P_EX_Btype_SINGLE_ENDED ] =
	{
		.name         = "AHD20_720P_25P_EX_Btype_SINGLE_ENDED",
		.video_fmt    = AHD20_720P_25P_EX_Btype,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass 	 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x77, 0x67, 0x57 },
			.eq_gain_sel = { 0x78, 0x78, 0x7a, 0x7f, 0x7f, 0x7f },
			.deq_a_on 	 = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel 	 = { 0x0, 0x86, 0x87, 0x93, 0x8e, 0x8e },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x88, 0x88, 0x78, 0x88, 0x88, 0x7e },
			.y_peaking_mode= { 0x3, 0x3, 0x3, 0x3, 0x3, 0x3 },
			.y_fir_mode = { 0xf, 0xf, 0xf, 0xf, 0xf, 0xf },
			.c_filter = { 0x82, 0x82, 0x82, 0x82, 0x92, 0x92 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x84, 0x84, 0x84, 0x84, 0x84, 0x86 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xab, 0xb0, 0xb0, 0xa4, 0xa0 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x80, 0x80, 0x90, 0x90 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x43, 0x43, 0x43, 0x43, 0x43, 0x43 },
			.h_delay_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto   = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.vblk_end = { 0x21, 0x21, 0x21, 0x21, 0x21, 0x21 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ AHD20_720P_30P_EX_Btype_SINGLE_ENDED ] =
	{
		.name         = "AHD20_720P_30P_EX_Btype_SINGLE_ENDED",
		.video_fmt    = AHD20_720P_30P_EX_Btype,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x77, 0x67, 0x57 },
			.eq_gain_sel = { 0x78, 0x78, 0x7a, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x86, 0x87, 0x93, 0x8e, 0x8e },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x88, 0x88, 0x78, 0x88, 0x88, 0x7e },
			.y_peaking_mode= { 0x3, 0x3, 0x3, 0x3, 0x3, 0x3 },
			.y_fir_mode = { 0xf, 0xf, 0xf, 0xf, 0xf, 0xf },
			.c_filter = { 0x82, 0x82, 0x82, 0x82, 0x92, 0x92 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x84, 0x84, 0x84, 0x84, 0x84, 0x86 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xab, 0xb0, 0xb0, 0xa4, 0xa0 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x80, 0x80, 0x90, 0x90 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A },
			.h_delay_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.vblk_end = { 0x21, 0x21, 0x21, 0x21, 0x21, 0x21 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ AHD20_720P_25P_SINGLE_ENDED ] =
	{
		.name         = "AHD20_720P_25P_SINGLE_ENDED",
		.video_fmt    = AHD20_720P_25P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x77, 0x67, 0x57 },
			.eq_gain_sel = { 0x78, 0x78, 0x7a, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x86, 0x87, 0x93, 0x8e, 0x8e },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x88, 0x88, 0x78, 0x88, 0x88, 0x7e },
			.y_peaking_mode= { 0x3, 0x3, 0x3, 0x3, 0x3, 0x3 },
			.y_fir_mode = { 0xf, 0xf, 0xf, 0xf, 0xf, 0xf },
			.c_filter = { 0x82, 0x82, 0x82, 0x82, 0x92, 0x92 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x84, 0x84, 0x84, 0x84, 0x84, 0x86 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xab, 0xb0, 0xb0, 0xa4, 0xa0 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x80, 0x80, 0x90, 0x90 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.h_delay_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.vblk_end = { 0x21, 0x21, 0x21, 0x21, 0x21, 0x21 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ AHD20_720P_30P_SINGLE_ENDED ] =
	{
		.name         = "AHD20_720P_30P_SINGLE_ENDED",
		.video_fmt    = AHD20_720P_30P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x77, 0x67, 0x57 },
			.eq_gain_sel = { 0x78, 0x78, 0x7a, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x86, 0x87, 0x93, 0x8e, 0x8e },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x88, 0x88, 0x78, 0x88, 0x88, 0x7e },
			.y_peaking_mode= { 0x3, 0x3, 0x3, 0x3, 0x3, 0x3 },
			.y_fir_mode = { 0xf, 0xf, 0xf, 0xf, 0xf, 0xf },
			.c_filter = { 0x82, 0x82, 0x82, 0x82, 0x92, 0x92 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x84, 0x84, 0x84, 0x84, 0x84, 0x86 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xab, 0xb0, 0xb0, 0xa4, 0xa0 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x80, 0x80, 0x90, 0x90 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.h_delay_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.vblk_end = { 0x21, 0x21, 0x21, 0x21, 0x21, 0x21 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ AHD20_960P_30P_SINGLE_ENDED ] =
	{
		.name         = "AHD20_960P_30P_SINGLE_ENDED",
		.video_fmt    = AHD20_720P_960P_30P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x77, 0x57, 0x57 },
			.eq_gain_sel = { 0x78, 0x7b, 0x7f, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x91, 0x87, 0x89, 0x93, 0x94 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x86, 0x82, 0x82, 0x7e, 0x7c, 0x77 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0xf, 0xf },
			.c_filter = { 0x82, 0x82, 0x82, 0x82, 0xa2, 0xb2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0xfe, 0xfe, 0xfe },
			.u_gain = { 0x0, 0x0, 0x4, 0x10, 0x10, 0x18 },
			.v_gain = { 0x0, 0x0, 0xf0, 0xe, 0xe, 0x14 },
			.u_offset = { 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe },
			.v_offset = { 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb },
			.black_level = { 0x80, 0x81, 0x81, 0x83, 0x83, 0x87 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xa8, 0xa8, 0xa8, 0x90, 0x90 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.c_option = { 0x80, 0x80, 0x90, 0x90, 0x90, 0xa0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c },
			.h_delay_b = { 0x13, 0x13, 0x13, 0x13, 0x13, 0x13 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.vblk_end = { 0x21, 0x21, 0x21, 0x21, 0x21, 0x21 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ AHD20_960P_25P_SINGLE_ENDED ] =
	{
		.name         = "AHD20_960P_25P_SINGLE_ENDED",
		.video_fmt    = AHD20_720P_960P_25P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x77, 0x57, 0x57 },
			.eq_gain_sel = { 0x78, 0x7b, 0x7f, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x91, 0x87, 0x89, 0x93, 0x94 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x86, 0x82, 0x82, 0x7e, 0x7c, 0x77 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0xf, 0xf },
			.c_filter = { 0x82, 0x82, 0x82, 0x82, 0xa2, 0xb2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0xfe, 0xfe, 0xfe },
			.u_gain = { 0x0, 0x0, 0x4, 0x10, 0x10, 0x18 },
			.v_gain = { 0x0, 0x0, 0xf0, 0x0e, 0xe, 0x14 },
			.u_offset = { 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe },
			.v_offset = { 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb },
			.black_level = { 0x80, 0x81, 0x81, 0x83, 0x83, 0x87 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xa8, 0xa8, 0xa8, 0x90, 0x90 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.c_option = { 0x80, 0x80, 0x90, 0x90, 0x90, 0xa0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x81, 0x81, 0x81, 0x81, 0x81, 0x81 },
			.h_delay_b = { 0x13, 0x13, 0x13, 0x13, 0x13, 0x13 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x3, 0x3, 0x3, 0x3, 0x3, 0x3 },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.vblk_end = { 0x21, 0x21, 0x21, 0x21, 0x21, 0x21 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ CVI_FHD_25P_SINGLE_ENDED ] =
	{
		.name         = "CVI_FHD_25P_SINGLE_ENDED",
		.video_fmt    = CVI_FHD_25P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x77, 0x67, 0x47 },
			.eq_gain_sel = { 0x78, 0x7f, 0x6f, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x92, 0x93, 0x94, 0x95, 0x93 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x98, 0x98, 0x98, 0x98, 0x98, 0x98 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_filter = { 0x92, 0x92, 0x92, 0x92, 0xb2, 0xb2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x3, 0x3, 0x4, 0x4, 0x4, 0x4 },
			.u_gain = { 0xc, 0xc, 0xc, 0xc, 0xc, 0xc },
			.v_gain = { 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a },
			.u_offset = { 0xfa, 0xfa, 0xfa, 0xfa, 0xfa, 0xfa },
			.v_offset = { 0xfa, 0xfa, 0xfa, 0xfa, 0xfa, 0xfa },
			.black_level = { 0x86, 0x7a, 0x88, 0x84, 0x84, 0x84 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x47, 0x37 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xa0, 0xa0, 0x90, 0x90, 0x90 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.h_delay_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* clock */
		{
			.clk_adc = { 0x8, 0x8, 0x8, 0x8, 0x8, 0x8 },
			.clk_adc_pre= { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0xF9, 0xF9, 0xF9, 0xF9, 0xF9, 0xF9 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.h_scaler5 = { 0x88, 0x88, 0x88, 0x88, 0x88, 0x88 },
			.h_scaler6 = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.h_scaler7 = { 0x8c, 0x8c, 0x8c, 0x8c, 0x8c, 0x8c },
			.h_scaler8 = { 0xc8, 0xc8, 0xc8, 0xc8, 0xc8, 0xc8 },
			.h_scaler9 = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x3, 0x3, 0x3, 0x3, 0x3, 0x3 },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.vblk_end = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ CVI_FHD_30P_SINGLE_ENDED ] =
	{
		.name         = "CVI_FHD_30P_SINGLE_ENDED",
		.video_fmt    = CVI_FHD_30P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x77, 0x67, 0x47 },
			.eq_gain_sel = { 0x78, 0x7f, 0x6f, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x92, 0x93, 0x94, 0x95, 0x93 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x98, 0x98, 0x98, 0x98, 0x98, 0x98 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_filter = { 0x92, 0x92, 0x92, 0x92, 0xb2, 0xb2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x3, 0x3, 0x4, 0x4, 0x4, 0x4 },
			.u_gain = { 0xc, 0xc, 0xc, 0xc, 0xc, 0xc },
			.v_gain = { 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a },
			.u_offset = { 0xfa, 0xfa, 0xfa, 0xfa, 0xfa, 0xfa },
			.v_offset = { 0xfa, 0xfa, 0xfa, 0xfa, 0xfa, 0xfa },
			.black_level = { 0x89, 0x7a, 0x88, 0x84, 0x84, 0x84 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x47, 0x37 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xa0, 0xa0, 0x90, 0x90, 0x90 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
			.h_delay_b = { 0x16, 0x16, 0x16, 0x16, 0x16, 0x16 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* clock */
		{
			.clk_adc = { 0x8, 0x8, 0x8, 0x8, 0x8, 0x8 },
			.clk_adc_pre= { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x39, 0x39, 0x39, 0x39, 0x39, 0x39 },
			.h_scaler3 = { 0x50, 0x50, 0x50, 0x50, 0x50, 0x50 },
			.h_scaler4 = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.vblk_end = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ CVI_HD_25P_SINGLE_ENDED ] =
	{
		.name         = "CVI_HD_25P_SINGLE_ENDED",
		.video_fmt    = CVI_HD_25P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x67, 0x57, 0x57, 0x57, 0x47 },
			.eq_gain_sel = { 0x78, 0x78, 0x78, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x91, 0x92, 0x93, 0x93, 0x93 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x88, 0x8c, 0x8a, 0x87, 0x85, 0x84 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_filter = { 0x82, 0x92, 0x92, 0x92, 0xa2, 0xa2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x84, 0x86, 0x84, 0x84, 0x86, 0x88 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xaa, 0xaa, 0xac, 0xa8, 0xa6 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x80, 0x80, 0xa0, 0xa0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_delay_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x29, 0x29, 0x29, 0x29, 0x29, 0x29 },
			.h_scaler3 = { 0x70, 0x70, 0x70, 0x70, 0x70, 0x70 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.vblk_end = { 0x21, 0x21, 0x21, 0x21, 0x21, 0x21 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ CVI_HD_30P_SINGLE_ENDED ] =
	{
		.name         = "CVI_HD_30P_SINGLE_ENDED",
		.video_fmt    = CVI_HD_30P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x67, 0x57, 0x57, 0x57, 0x47 },
			.eq_gain_sel = { 0x78, 0x78, 0x78, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x91, 0x92, 0x93, 0x93, 0x93 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x88, 0x8c, 0x8a, 0x87, 0x85, 0x84 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_filter = { 0x82, 0x92, 0x92, 0x92, 0xa2, 0xa2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x84, 0x86, 0x84, 0x84, 0x86, 0x88 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xaa, 0xaa, 0xac, 0xa8, 0xa6 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x80, 0x80, 0xa0, 0xa0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 },
			.h_delay_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x19, 0x19, 0x19, 0x19, 0x19, 0x19 },
			.h_scaler3 = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
			.h_scaler4 = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.vblk_end = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ CVI_HD_25P_EX_SINGLE_ENDED ] =
	{
		.name         = "CVI_HD_25P_EX_SINGLE_ENDED",
		.video_fmt    = CVI_HD_25P_EX,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x67, 0x57, 0x57, 0x57, 0x47 },
			.eq_gain_sel = { 0x78, 0x78, 0x78, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x91, 0x92, 0x93, 0x93, 0x93 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x88, 0x8c, 0x8a, 0x87, 0x85, 0x84 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_filter = { 0x82, 0x92, 0x92, 0x92, 0xa2, 0xa2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x84, 0x86, 0x84, 0x84, 0x86, 0x88 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xaa, 0xaa, 0xac, 0xa8, 0xa6 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x80, 0x80, 0xa0, 0xa0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_delay_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x29, 0x29, 0x29, 0x29, 0x29, 0x29 },
			.h_scaler3 = { 0x70, 0x70, 0x70, 0x70, 0x70, 0x70 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.vblk_end = { 0x21, 0x21, 0x21, 0x21, 0x21, 0x21 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ CVI_HD_30P_EX_SINGLE_ENDED ] =
	{
		.name         = "CVI_HD_30P_EX_SINGLE_ENDED",
		.video_fmt    = CVI_HD_30P_EX,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x67, 0x57, 0x57, 0x57, 0x47 },
			.eq_gain_sel = { 0x78, 0x78, 0x78, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x91, 0x92, 0x93, 0x93, 0x93 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x88, 0x8c, 0x8a, 0x87, 0x85, 0x84 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_filter = { 0x82, 0x92, 0x92, 0x92, 0xa2, 0xa2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x84, 0x86, 0x84, 0x84, 0x86, 0x88 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xaa, 0xaa, 0xac, 0xa8, 0xa6 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x80, 0x80, 0xa0, 0xa0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 },
			.h_delay_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x19, 0x19, 0x19, 0x19, 0x19, 0x19 },
			.h_scaler3 = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
			.h_scaler4 = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.vblk_end = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ CVI_HD_50P_SINGLE_ENDED ] =
	{
		.name         = "CVI_HD_50P_SINGLE_ENDED",
		.video_fmt    = CVI_HD_50P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x77, 0x67, 0x47 },
			.eq_gain_sel = { 0x78, 0x7f, 0x6f, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x92, 0x93, 0x94, 0x95, 0x93 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x98, 0x98, 0x98, 0x98, 0x98, 0x98 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_filter = { 0x92, 0x92, 0x92, 0x92, 0xb2, 0xb2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x3, 0x3, 0x4, 0x4, 0x4, 0x4 },
			.u_gain = { 0xc, 0xc, 0xc, 0xc, 0xc, 0xc },
			.v_gain = { 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a },
			.u_offset = { 0xfa, 0xfa, 0xfa, 0xfa, 0xfa, 0xfa },
			.v_offset = { 0xfa, 0xfa, 0xfa, 0xfa, 0xfa, 0xfa },
			.black_level = { 0x86, 0x7a, 0x88, 0x84, 0x84, 0x84 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x47, 0x37 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xa0, 0xa0, 0x90, 0x90, 0x90 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x68, 0x68, 0x68, 0x68, 0x68, 0x68 },
			.h_delay_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* clock */
		{
			.clk_adc = { 0x8, 0x8, 0x8, 0x8, 0x8, 0x8 },
			.clk_adc_pre= { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x29, 0x29, 0x29, 0x29, 0x29, 0x29 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.vblk_end = { 0x21, 0x21, 0x21, 0x21, 0x21, 0x21 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ CVI_HD_60P_SINGLE_ENDED ] =
	{
		.name         = "CVI_HD_60P_SINGLE_ENDED",
		.video_fmt    = CVI_HD_60P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x77, 0x67, 0x47 },
			.eq_gain_sel = { 0x78, 0x7f, 0x6f, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x92, 0x93, 0x94, 0x95, 0x93 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x98, 0x98, 0x98, 0x98, 0x98, 0x98 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_filter = { 0x92, 0x92, 0x92, 0x92, 0xb2, 0xb2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x3, 0x3, 0x4, 0x4, 0x4, 0x4 },
			.u_gain = { 0x0c, 0xc, 0xc, 0xc, 0xc, 0xc },
			.v_gain = { 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a },
			.u_offset = { 0xfa, 0xfa, 0xfa, 0xfa, 0xfa, 0xfa },
			.v_offset = { 0xfa, 0xfa, 0xfa, 0xfa, 0xfa, 0xfa },
			.black_level = { 0x86, 0x7a, 0x88, 0x84, 0x84, 0x84 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x47, 0x37 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xa0, 0xa0, 0x90, 0x90, 0x90 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x59, 0x59, 0x59, 0x59, 0x59, 0x59 },
			.h_delay_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* clock */
		{
			.clk_adc = { 0x8, 0x8, 0x8, 0x8, 0x8, 0x8 },
			.clk_adc_pre= { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x19, 0x19, 0x19, 0x19, 0x19, 0x19 },
			.h_scaler3 = { 0x68, 0x68, 0x68, 0x68, 0x68, 0x68 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.vblk_end = { 0x21, 0x21, 0x21, 0x21, 0x21, 0x21 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ TVI_FHD_25P_SINGLE_ENDED ] =
	{
		.name         = "TVI_FHD_25P_SINGLE_ENDED",
		.video_fmt    = TVI_FHD_25P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x67, 0x57, 0x37 },
			.eq_gain_sel = { 0x78, 0x78, 0x6f, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x91, 0x93, 0x94, 0x95, 0x93 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x82, 0x7c, 0x78, 0x6c, 0x70, 0x68 },
			.y_peaking_mode= { 0x3, 0x3, 0x3, 0x3, 0x3, 0x3 },
			.y_fir_mode = { 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },
			.c_filter = { 0x82, 0x82, 0x92, 0xb2, 0xb2, 0xb2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe },
			.u_gain = { 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_gain = { 0x0, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8 },
			.u_offset = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x86, 0x88, 0x88, 0x8c, 0x8f, 0x8f },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x27 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xdf, 0xe0, 0xe0, 0xe0, 0xa0, 0x80 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x80, 0xa0, 0xb0, 0xb0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x60, 0x60, 0x60, 0x60, 0x60, 0x60 },
			.h_delay_b = { 0x12, 0x12, 0x12, 0x12, 0x12, 0x12 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x8, 0x8, 0x8, 0x8, 0x8, 0x8 },
			.clk_adc_pre= { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x0, 0x0, 0x0, 0x10, 0x10, 0x10 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x3, 0x3, 0x3, 0x3, 0x3, 0x3 },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.vblk_end = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ TVI_FHD_30P_SINGLE_ENDED ] =
	{
		.name         = "TVI_FHD_30P_SINGLE_ENDED",
		.video_fmt    = TVI_FHD_30P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x67, 0x57, 0x37 },
			.eq_gain_sel = { 0x78, 0x78, 0x6f, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x91, 0x93, 0x94, 0x95, 0x93 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x82, 0x7c, 0x78, 0x6c, 0x70, 0x68 },
			.y_peaking_mode= { 0x3, 0x3, 0x3, 0x3, 0x3, 0x3 },
			.y_fir_mode = { 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },
			.c_filter = { 0x82, 0x82, 0x92, 0xb2, 0xb2, 0xb2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe },
			.u_gain = { 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_gain = { 0x0, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8 },
			.u_offset = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x86, 0x88, 0x88, 0x8c, 0x8f, 0x8f },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x27 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xdf, 0xe0, 0xe0, 0xe0, 0xa0, 0x80 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x80, 0xa0, 0xb0, 0xb0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x68, 0x68, 0x68, 0x68, 0x68, 0x68 },
			.h_delay_b = { 0x13, 0x13, 0x13, 0x13, 0x13, 0x13 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x7, 0x7, 0x7, 0x7, 0x7, 0x7 },
		},
		/* clock */
		{
			.clk_adc = { 0x8, 0x8, 0x8, 0x8, 0x8, 0x8 },
			.clk_adc_pre= { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x0, 0x0, 0x0, 0x10, 0x10, 0x10 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.vblk_end = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ TVI_HD_50P_SINGLE_ENDED ] =
	{
		.name         = "TVI_HD_50P_SINGLE_ENDED",
		.video_fmt    = TVI_HD_50P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x67, 0x57, 0x37 },
			.eq_gain_sel = { 0x78, 0x78, 0x6f, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x91, 0x93, 0x94, 0x95, 0x93 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x82, 0x7c, 0x78, 0x6c, 0x70, 0x68 },
			.y_peaking_mode= { 0x3, 0x3, 0x3, 0x3, 0x3, 0x3 },
			.y_fir_mode = { 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },
			.c_filter = { 0x2, 0x82, 0x92, 0xb2, 0xb2, 0xb2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe },
			.u_gain = { 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_gain = { 0x0, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8 },
			.u_offset = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x86, 0x88, 0x88, 0x8c, 0x8f, 0x8f },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x27 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xdf, 0xe0, 0xe0, 0xe0, 0xa0, 0x80 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x80, 0xa0, 0xb0, 0xb0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x60, 0x60, 0x60, 0x60, 0x60, 0x60 },
			.h_delay_b = { 0x12, 0x12, 0x12, 0x12, 0x12, 0x12 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x8, 0x8, 0x8, 0x8, 0x8, 0x8 },
			.clk_adc_pre= { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.vblk_end = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ TVI_HD_60P_SINGLE_ENDED ] =
	{
		.name         = "TVI_HD_60P_SINGLE_ENDED",
		.video_fmt    = TVI_HD_60P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x67, 0x57, 0x37 },
			.eq_gain_sel = { 0x78, 0x78, 0x6f, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x91, 0x93, 0x94, 0x95, 0x93 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x82, 0x7c, 0x78, 0x6c, 0x70, 0x68 },
			.y_peaking_mode= { 0x3, 0x3, 0x3, 0x3, 0x3, 0x3 },
			.y_fir_mode = { 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },
			.c_filter = { 0x82, 0x82, 0x92, 0xb2, 0xb2, 0xb2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe },
			.u_gain = { 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_gain = { 0x0, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8 },
			.u_offset = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x86, 0x88, 0x88, 0x8c, 0x8f, 0x8f },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x27 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xdf, 0xe0, 0xe0, 0xe0, 0xa0, 0x80 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.c_option = { 0x80, 0x80, 0x80, 0xa0, 0xb0, 0xb0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x68, 0x68, 0x68, 0x68, 0x68, 0x68 },
			.h_delay_b = { 0x13, 0x13, 0x13, 0x13, 0x13, 0x13 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x7, 0x7, 0x7, 0x7, 0x7, 0x7 },
		},
		/* clock */
		{
			.clk_adc = { 0x8, 0x8, 0x8, 0x8, 0x8, 0x8 },
			.clk_adc_pre= { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x0, 0x0, 0x0, 0x10, 0x10, 0x10 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.vblk_end = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ TVI_HD_25P_SINGLE_ENDED ] =
	{
		.name         = "TVI_HD_25P_SINGLE_ENDED",
		.video_fmt    = TVI_HD_25P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x67, 0x57, 0x57, 0x57, 0x47 },
			.eq_gain_sel = { 0x78, 0x78, 0x78, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x91, 0x92, 0x93, 0x93, 0x93 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xac, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x82, 0x86, 0x84, 0x81, 0x7f, 0x7e },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_filter = { 0x2, 0x92, 0x92, 0xa2, 0xa2, 0xa2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x86, 0x88, 0x86, 0x86, 0x88, 0x8a },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xaa, 0xaa, 0xac, 0xa8, 0xa6 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_option = { 0x80, 0x80, 0x80, 0xb0, 0xb0, 0xb0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x70, 0x70, 0x70, 0x70, 0x70, 0x70 },
			.h_delay_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x59, 0x59, 0x59, 0x59, 0x59, 0x59 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.vblk_end = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ TVI_HD_30P_SINGLE_ENDED ] =
	{
		.name         = "TVI_HD_30P_SINGLE_ENDED",
		.video_fmt    = TVI_HD_30P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x67, 0x57, 0x57, 0x57, 0x47 },
			.eq_gain_sel = { 0x78, 0x78, 0x78, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x91, 0x92, 0x93, 0x93, 0x93 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xac, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x82, 0x86, 0x84, 0x81, 0x7f, 0x7e },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_filter = { 0x2, 0x92, 0x92, 0xa2, 0xa2, 0xa2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x86, 0x88, 0x86, 0x86, 0x88, 0x8a },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xaa, 0xaa, 0xac, 0xa8, 0xa6 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_option = { 0x80, 0x80, 0x80, 0xb0, 0xb0, 0xb0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x70, 0x70, 0x70, 0x70, 0x70, 0x70 },
			.h_delay_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x59, 0x59, 0x59, 0x59, 0x59, 0x59 },
			.h_scaler3 = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.vblk_end = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ TVI_HD_B_25P_SINGLE_ENDED ] =
	{
		.name         = "TVI_HD_B_25P_SINGLE_ENDED",
		.video_fmt    = TVI_HD_B_25P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x77, 0x77, 0x77 },
			.eq_gain_sel = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deq_a_on = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deq_a_sel = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_filter = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x86, 0x86, 0x86, 0x86, 0x86, 0x86 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_option = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x60, 0x60, 0x60, 0x60, 0x60, 0x60 },
			.h_delay_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc_pre = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_post= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.h_scaler2 = { 0x59, 0x59, 0x59, 0x59, 0x59, 0x59 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.vblk_end = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ TVI_HD_B_30P_SINGLE_ENDED ] =
	{
		.name         = "TVI_HD_B_30P_SINGLE_ENDED",
		.video_fmt    = TVI_HD_B_30P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x77, 0x77, 0x77, 0x77, 0x77 },
			.eq_gain_sel = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deq_a_on = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deq_a_sel = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_filter = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x86, 0x86, 0x86, 0x86, 0x86, 0x86 },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_option = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.h_delay_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc_pre = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_post= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.h_scaler2 = { 0x59, 0x59, 0x59, 0x59, 0x59, 0x59 },
			.h_scaler3 = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.vblk_end = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ TVI_HD_25P_EX_SINGLE_ENDED ] =
	{
		.name         = "TVI_HD_25P_EX_SINGLE_ENDED",
		.video_fmt    = TVI_HD_25P_EX,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x67, 0x57, 0x57, 0x57, 0x47 },
			.eq_gain_sel = { 0x78, 0x78, 0x78, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x91, 0x92, 0x93, 0x93, 0x93 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0x0a, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x82, 0x86, 0x84, 0x81, 0x7f, 0x7e },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_filter = { 0x2, 0x92, 0x92, 0xa2, 0xa2, 0xa2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x86, 0x88, 0x86, 0x86, 0x88, 0x8a },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xaa, 0xaa, 0xac, 0xa8, 0xa6 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_option = { 0x80, 0x80, 0x80, 0xb0, 0xb0, 0xb0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.h_delay_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x59, 0x59, 0x59, 0x59, 0x59, 0x59 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.vblk_end = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ TVI_HD_30P_EX_SINGLE_ENDED ] =
	{
		.name         = "TVI_HD_30P_EX_SINGLE_ENDED",
		.video_fmt    = TVI_HD_30P_EX,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x67, 0x57, 0x57, 0x57, 0x47 },
			.eq_gain_sel = { 0x78, 0x78, 0x78, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x91, 0x92, 0x93, 0x93, 0x93 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0x0a, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x82, 0x86, 0x84, 0x81, 0x7f, 0x7e },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_filter = { 0x82, 0x92, 0x92, 0xa2, 0xa2, 0xa2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x86, 0x88, 0x86, 0x86, 0x88, 0x8a },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xaa, 0xaa, 0xac, 0xa8, 0xa6 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_option = { 0x80, 0x80, 0x80, 0xb0, 0xb0, 0xb0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.h_delay_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x59, 0x59, 0x59, 0x59, 0x59, 0x59 },
			.h_scaler3 = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.vblk_end = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ TVI_HD_B_25P_EX_SINGLE_ENDED ] =
	{
		.name         = "TVI_HD_B_25P_EX_SINGLE_ENDED",
		.video_fmt    = TVI_HD_B_25P_EX,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x67, 0x57, 0x57, 0x57, 0x47 },
			.eq_gain_sel = { 0x78, 0x78, 0x78, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x91, 0x92, 0x93, 0x93, 0x93 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x82, 0x86, 0x84, 0x81, 0x7f, 0x7e },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_filter = { 0x82, 0x92, 0x92, 0xa2, 0xa2, 0xa2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0xff, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x86, 0x88, 0x86, 0x86, 0x88, 0x8a },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xaa, 0xaa, 0xac, 0xa8, 0xa6 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_option = { 0x80, 0x80, 0x80, 0xb0, 0xb0, 0xb0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x60, 0x60, 0x60, 0x60, 0x60, 0x60 },
			.h_delay_b = { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x3, 0x3, 0x3, 0x3, 0x3, 0x3 },
			.vblk_end = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},

	[ TVI_HD_B_30P_EX_SINGLE_ENDED ] =
	{
		.name         = "TVI_HD_B_30P_EX_SINGLE_ENDED",
		.video_fmt    = TVI_HD_B_30P_EX,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.eq_band_sel = { 0x77, 0x67, 0x57, 0x57, 0x57, 0x47 },
			.eq_gain_sel = { 0x78, 0x78, 0x78, 0x7f, 0x7f, 0x7f },
			.deq_a_on = { 0x0, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.deq_a_sel = { 0x0, 0x91, 0x92, 0x93, 0x93, 0x93 },
		},
		/* coeff_ */
		{
			.deqA_01 = { 0xac, 0xac, 0xac, 0xac, 0xac, 0xac },
			.deqA_02 = { 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },
			.deqA_03 = { 0x17, 0x17, 0x17, 0x17, 0x17, 0x17 },
			.deqA_04 = { 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1 },
			.deqA_05 = { 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
			.deqA_06 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_07 = { 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3 },
			.deqA_08 = { 0xa, 0xa, 0xa, 0xa, 0xa, 0xa },
			.deqA_09 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_10 = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
			.deqA_11 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.deqA_12 = { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 },
		},
		/* color */
		{
			.contrast = { 0x82, 0x86, 0x84, 0x81, 0x7f, 0x7e },
			.y_peaking_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_fir_mode = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_filter = { 0x82, 0x92, 0x92, 0xa2, 0xa2, 0xa2 },
			.pal_cm_off= { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
			.hue = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_gain = { 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0 },
			.v_gain = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.u_offset = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },
			.v_offset = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.black_level = { 0x86, 0x88, 0x86, 0x86, 0x88, 0x8a },
			.acc_ref = { 0x57, 0x57, 0x57, 0x57, 0x57, 0x57 },
			.cti_delay = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.saturation_b = { 0xa8, 0xaa, 0xaa, 0xac, 0xa8, 0xa6 },
			.burst_dec_a = { 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a },
			.burst_dec_b = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.burst_dec_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.c_option = { 0x80, 0x80, 0x80, 0xb0, 0xb0, 0xb0 },
			.y_filter_b = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.y_filter_b_sel = { 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			.h_delay_b = { 0x12, 0x12, 0x12, 0x12, 0x12, 0x12 },
			.h_delay_c = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.y_delay = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
		},
		/* clock */
		{
			.clk_adc = { 0x4, 0x4, 0x4, 0x4, 0x4, 0x4 },
			.clk_adc_pre= { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1 },
			.clk_adc_post = { 0x2, 0x2, 0x2, 0x2, 0x2, 0x2 },
		},
		/* timing_b */
		{
			.h_scaler1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler2 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler7 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler8 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.h_scaler9 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.pn_auto = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.comb_mode = { 0x5, 0x5, 0x5, 0x5, 0x5, 0x5 },
			.h_pll_op_a = { 0x72, 0x72, 0x72, 0x72, 0x72, 0x72 },
			.mem_path = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
			.fsc_lock_speed = { 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc },
			.ahd_mode= { 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },
			.sd_mode= { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
			.spl_mode = { 0x3, 0x3, 0x3, 0x3, 0x3, 0x3 },
			.vblk_end = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
			.afe_g_sel= { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
			.afe_ctr_clp= { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
			.d_agc_option = { 0x24, 0x24, 0x24, 0x24, 0x24, 0x24 },
		},
	},



	[ AHD20_SD_H960_2EX_Btype_NT_DIFFERENTIAL ] = /* o */
	{
		.name         = "AHD20_SD_H960_2EX_Btype_NT_DIFFERENTIAL",
		.video_fmt    = AHD20_SD_H960_2EX_Btype_NT,
		.analog_input = DIFFERENTIAL,
	},

	[ AHD20_SD_H960_2EX_Btype_PAL_DIFFERENTIAL ] = /* o */
	{
		.name         = "AHD20_SD_H960_2EX_Btype_PAL_DIFFERENTIAL",
		.video_fmt    = AHD20_SD_H960_2EX_Btype_PAL,
		.analog_input = DIFFERENTIAL,
	},

	[ AHD20_1080P_30P_DIFFERENTIAL ] = /* o */
	{
		.name         = "AHD20_1080P_30P_DIFFERENTIAL",
		.video_fmt    = AHD20_1080P_30P,
		.analog_input = DIFFERENTIAL,
	},

	[ AHD20_1080P_25P_DIFFERENTIAL ] =
	{
		.name         = "AHD20_1080P_25P_DIFFERENTIAL",
		.video_fmt    = AHD20_1080P_25P,
		.analog_input = DIFFERENTIAL,
	},

	[ AHD20_720P_25P_EX_Btype_DIFFERENTIAL ] =
	{
		.name         = "AHD20_720P_25P_EX_Btype_DIFFERENTIAL",
		.video_fmt    = AHD20_720P_25P_EX_Btype,
		.analog_input = DIFFERENTIAL,
	},

	[ AHD20_720P_30P_EX_Btype_DIFFERENTIAL ] =
	{
		.name         = "AHD20_720P_30P_EX_Btype_DIFFERENTIAL",
		.video_fmt    = AHD20_720P_30P_EX_Btype,
		.analog_input = DIFFERENTIAL,
	},

	[ AHD20_720P_25P_DIFFERENTIAL ] =
	{
		.name         = "AHD20_720P_25P_DIFFERENTIAL",
		.video_fmt    = AHD20_720P_25P,
		.analog_input = DIFFERENTIAL,
	},

	[ AHD20_720P_30P_DIFFERENTIAL ] =
	{
		.name         = "AHD20_720P_30P_DIFFERENTIAL",
		.video_fmt    = AHD20_720P_30P,
		.analog_input = DIFFERENTIAL,
	},

	[ CVI_FHD_25P_DIFFERENTIAL ] =
	{
		.name         = "CVI_FHD_25P_DIFFERENTIAL",
		.video_fmt    = CVI_FHD_25P,
		.analog_input = DIFFERENTIAL,
	},

	[ CVI_FHD_30P_DIFFERENTIAL ] =
	{
		.name         = "CVI_FHD_30P_DIFFERENTIAL",
		.video_fmt    = CVI_FHD_30P,
		.analog_input = DIFFERENTIAL,
	},

	[ CVI_HD_25P_DIFFERENTIAL ] =
	{
		.name         = "CVI_HD_25P_DIFFERENTIAL",
		.video_fmt    = CVI_HD_25P,
		.analog_input = DIFFERENTIAL,
	},

	[ CVI_HD_30P_DIFFERENTIAL ] =
	{
		.name         = "CVI_HD_30P_DIFFERENTIAL",
		.video_fmt    = CVI_HD_30P,
		.analog_input = DIFFERENTIAL,
	},

	[ CVI_HD_25P_EX_DIFFERENTIAL ] =
	{
		.name         = "CVI_HD_25P_EX_DIFFERENTIAL",
		.video_fmt    = CVI_HD_25P_EX,
		.analog_input = DIFFERENTIAL,
	},

	[ CVI_HD_30P_EX_DIFFERENTIAL ] =
	{
		.name         = "CVI_HD_30P_EX_DIFFERENTIAL",
		.video_fmt    = CVI_HD_30P_EX,
		.analog_input = DIFFERENTIAL,
	},

	[ CVI_HD_50P_DIFFERENTIAL ] =
	{
		.name         = "CVI_HD_50P_DIFFERENTIAL",
		.video_fmt    = CVI_HD_50P,
		.analog_input = DIFFERENTIAL,
	},

	[ CVI_HD_60P_DIFFERENTIAL ] =
	{
		.name         = "CVI_HD_60P_DIFFERENTIAL",
		.video_fmt    = CVI_HD_60P,
		.analog_input = DIFFERENTIAL,
	},



	[ TVI_FHD_25P_DIFFERENTIAL ] =
	{
		.name         = "TVI_FHD_25P_DIFFERENTIAL",
		.video_fmt    = TVI_FHD_25P,
		.analog_input = DIFFERENTIAL,

	},

	[ TVI_FHD_30P_DIFFERENTIAL ] =
	{
		.name         = "TVI_FHD_30P_DIFFERENTIAL",
		.video_fmt    = TVI_FHD_30P,
		.analog_input = DIFFERENTIAL,
	},

	[ TVI_HD_25P_DIFFERENTIAL ] =
	{
		.name         = "TVI_HD_25P_DIFFERENTIAL",
		.video_fmt    = TVI_HD_25P,
		.analog_input = DIFFERENTIAL,
	},

	[ TVI_HD_30P_DIFFERENTIAL ] =
	{
		.name         = "TVI_HD_30P_DIFFERENTIAL",
		.video_fmt    = TVI_HD_30P,
		.analog_input = DIFFERENTIAL,
	},

	[ TVI_HD_B_25P_DIFFERENTIAL ] =
	{
		.name         = "TVI_HD_B_25P_DIFFERENTIAL",
		.video_fmt    = TVI_HD_B_25P,
		.analog_input = DIFFERENTIAL,
	},

	[ TVI_HD_B_30P_DIFFERENTIAL ] =
	{
		.name         = "TVI_HD_B_30P_DIFFERENTIAL",
		.video_fmt    = TVI_HD_B_30P,
		.analog_input = DIFFERENTIAL,
	},

	[ TVI_HD_25P_EX_DIFFERENTIAL ] =
	{
		.name         = "TVI_HD_25P_EX_DIFFERENTIAL",
		.video_fmt    = TVI_HD_25P_EX,
		.analog_input = DIFFERENTIAL,
	},

	[ TVI_HD_30P_EX_DIFFERENTIAL ] =
	{
		.name         = "TVI_HD_30P_EX_DIFFERENTIAL",
		.video_fmt    = TVI_HD_30P_EX,
		.analog_input = DIFFERENTIAL,

	},

	[ TVI_HD_B_25P_EX_DIFFERENTIAL ] =
	{
		.name         = "TVI_HD_B_25P_EX_DIFFERENTIAL",
		.video_fmt    = TVI_HD_B_25P_EX,
		.analog_input = DIFFERENTIAL,
	},

	[ TVI_HD_B_30P_EX_DIFFERENTIAL ] =
	{
		.name         = "TVI_HD_B_30P_EX_DIFFERENTIAL",
		.video_fmt    = TVI_HD_B_30P_EX,
		.analog_input = DIFFERENTIAL,
	},

};




#endif /* EXTDRV_JAGUAR1_VIDEO_INPUT_TABLE_H_ */
