#define JLCD_ONLY

#include "sn65dsi83.h"

#include <asm/io.h>
#include <asm/hardware.h>
#include <asm/gpio.h>


#ifndef JLCD_ONLY
static struct gpio_desc st_gpio_main, st_gpio_jog;
#else
static struct gpio_desc st_gpio_jog;
#endif

void disable_sn65(int id)
{
	ofnode node = ofnode_path("/sn65_en");

	if (ofnode_valid(node)) {
		if (id == 0) {
#ifndef JLCD_ONLY
			if (gpio_request_by_name_nodev(node, "sn65en-main", 0, &st_gpio_main, GPIOD_IS_OUT)) {
				printf("%s: could not find a /sn65_en/sn65en-main\n", __func__);
			}
			else {
				dm_gpio_set_value(&st_gpio_main, 0);
			}
#endif
			if (gpio_request_by_name_nodev(node, "sn65en-jog", 0, &st_gpio_jog, GPIOD_IS_OUT)) {
				printf("%s: could not find a /sn65_en/sn65en-jog\n", __func__);
			}
			else {
				dm_gpio_set_value(&st_gpio_jog, 0);
			}
		}
	}
}

void enable_sn65(int id)
{
	ofnode node = ofnode_path("/sn65_en");

	udelay(10000);

	if (ofnode_valid(node)) {
#ifndef JLCD_ONLY
		if (id == 0) {
			if (dm_gpio_is_valid(&st_gpio_main)) {
				dm_gpio_set_value(&st_gpio_main, 1);
			}
			else {
				printf("%s: could not find a /sn65_en/sn65en-main\n", __func__);
			}
		}
		else if (id == 1) {
#else
		if (id == 1) {
#endif
			if (dm_gpio_is_valid(&st_gpio_jog)) {
				dm_gpio_set_value(&st_gpio_jog, 1);
			}
			else {
				printf("%s: could not find a /sn65_en/sn65en-jog\n", __func__);
			}
		}
	}

	udelay(10000);
}

#ifndef JLCD_ONLY
static int initialize_sn65dsi_main(void)
{
	struct udevice *dev;
	int ret;
	u8 buf[8];

	ret = i2c_get_chip_for_busnum(3, 0x2C, 1, &dev);
	if (ret) {
		printf("%s: could not find a sn65dsi83\n", __func__);
		return -ENODEV;
	}
	/* Clear SOFT_RESET, PLL_EN */
	buf[0] = 0x00;
	ret = dm_i2c_write(dev, 0x09, buf, 1);
	ret = dm_i2c_write(dev, 0x0D, buf, 1);
	/* LVDS_PLL */
	buf[0] = 0x03;
	ret = dm_i2c_write(dev, 0x0A, buf, 1);
	/* DSI_CLK */
	buf[0] = 0x24;
	ret = dm_i2c_write(dev, 0x12, buf, 1);
	/* RC_DSI_CLK */
	buf[0] = 0x10;
	ret = dm_i2c_write(dev, 0x0B, buf, 1);
	/* DSI_LANE */
	buf[0] = 0x26;
	ret = dm_i2c_write(dev, 0x10, buf, 1);
	/* DSI_EQ */
	buf[0] = 0x00;
	ret = dm_i2c_write(dev, 0x11, buf, 1);
	/* LVDS_FMT */
	buf[0] = 0x78;
	ret = dm_i2c_write(dev, 0x18, buf, 1);
	/* LVDS_VOCM */
	buf[0] = 0x05;
	ret = dm_i2c_write(dev, 0x19, buf, 1);
	/* LVDS_LANE */
	buf[0] = 0x01;
	ret = dm_i2c_write(dev, 0x1A, buf, 1);
	/* LVDS_CM */
	buf[0] = 0x00;
	ret = dm_i2c_write(dev, 0x1B, buf, 1);
	/* VID_CHA_ACTIVE_LINE_LENGTH */
	buf[0] = 0x00;
	buf[1] = 0x05;
	ret = dm_i2c_write(dev, 0x20, buf, 2);
	/* VID_CHA_VERTICAL_DISPLAY_SIZE */
	buf[0] = 0xD0;
	buf[1] = 0x02;
	ret = dm_i2c_write(dev, 0x24, buf, 2);
	/* VID_CHA_SYNC_DELAY */
	buf[0] = 0x21;
	buf[1] = 0x00;
	ret = dm_i2c_write(dev, 0x28, buf, 2);
	/* VID_CHA_HSYNC_PULSE_WIDTH */
	buf[0] = 0x18;
	buf[1] = 0x00;
	ret = dm_i2c_write(dev, 0x2C, buf, 2);
	/* VID_CHA_VSYNC_PULSE_WIDTH */
	buf[0] = 0x06;
	buf[1] = 0x00;
	ret = dm_i2c_write(dev, 0x30, buf, 2);
	/* VID_CHA_HORIZONTAL_BACK_PORCH */
	buf[0] = 0x14;
	ret = dm_i2c_write(dev, 0x34, buf, 1);
	/* VID_CHA_VERTICAL_BACK_PORCH */
	buf[0] = 0x06;
	ret = dm_i2c_write(dev, 0x36, buf, 1);
	/* VID_CHA_HORIZONTAL_FRONT_PORCH */
	buf[0] = 0x14;
	ret = dm_i2c_write(dev, 0x38, buf, 1);
	/* VID_CHA_VERTICAL_FRONT_PORCH */
	buf[0] = 0x06;
	ret = dm_i2c_write(dev, 0x3A, buf, 1);
	/* VID_CHA_TEST_PATTERN */
	buf[0] = 0x00;
	ret = dm_i2c_write(dev, 0x3C, buf, 1);
	/* RC_PLL_EN */
	buf[0] = 0x01;
	ret = dm_i2c_write(dev, 0x0D, buf, 1);
	/* 10ms delay */
	udelay(10000);
	/* RC_RESET */
	buf[0] = 0x01;
	ret = dm_i2c_write(dev, 0x09, buf, 1);

	return 0;
}
#endif

static int initialize_sn65dsi_jog(void)
{
	struct udevice *dev;
	int ret;
	u8 buf[8];

	ret = i2c_get_chip_for_busnum(3, 0x2D, 1, &dev);
	if (ret) {
		printf("%s: could not find a sn65dsi83\n", __func__);
		return -ENODEV;
	}
	/* Clear SOFT_RESET, PLL_EN */
	buf[0] = 0x00;
	ret = dm_i2c_write(dev, 0x09, buf, 1);
	ret = dm_i2c_write(dev, 0x0D, buf, 1);
	/* LVDS_PLL */
	buf[0] = 0x01;
	ret = dm_i2c_write(dev, 0x0A, buf, 1);
	/* DSI_CLK */
	buf[0] = 0x24;
	ret = dm_i2c_write(dev, 0x12, buf, 1);
	/* RC_DSI_CLK */
	buf[0] = 0x20;
	ret = dm_i2c_write(dev, 0x0B, buf, 1);
	/* DSI_LANE */
	buf[0] = 0x26;
//	buf[0] = 0x2E;		// 4lanes -> 3lanes
	ret = dm_i2c_write(dev, 0x10, buf, 1);
	/* DSI_EQ */
	buf[0] = 0x00;
	ret = dm_i2c_write(dev, 0x11, buf, 1);
	/* LVDS_FMT */
	buf[0] = 0xD2;
	ret = dm_i2c_write(dev, 0x18, buf, 1);
	/* LVDS_VOCM */
	buf[0] = 0x00; /* 0x05->0x00 */
	ret = dm_i2c_write(dev, 0x19, buf, 1);
	/* LVDS_LANE */
	buf[0] = 0x01;
	ret = dm_i2c_write(dev, 0x1A, buf, 1);
	/* LVDS_CM */
	buf[0] = 0x00;
	ret = dm_i2c_write(dev, 0x1B, buf, 1);
	/* VID_CHA_ACTIVE_LINE_LENGTH */
	buf[0] = 0x00;
	buf[1] = 0x05;
	ret = dm_i2c_write(dev, 0x20, buf, 2);
	/* VID_CHA_VERTICAL_DISPLAY_SIZE */
	buf[0] = 0xF0;
	buf[1] = 0x00;
	ret = dm_i2c_write(dev, 0x24, buf, 2);
	/* VID_CHA_SYNC_DELAY */
	buf[0] = 0x21;
	buf[1] = 0x00;
	ret = dm_i2c_write(dev, 0x28, buf, 2);
	/* VID_CHA_HSYNC_PULSE_WIDTH */
	buf[0] = 0x01;
	buf[1] = 0x00;
	ret = dm_i2c_write(dev, 0x2C, buf, 2);
	/* VID_CHA_VSYNC_PULSE_WIDTH */
	buf[0] = 0x04;
	buf[1] = 0x00;
	ret = dm_i2c_write(dev, 0x30, buf, 2);
	/* VID_CHA_HORIZONTAL_BACK_PORCH */
	buf[0] = 0xFB;
//	buf[0] = 0xBB;		// 251 -> 187
	ret = dm_i2c_write(dev, 0x34, buf, 1);
	/* VID_CHA_VERTICAL_BACK_PORCH */
	buf[0] = 0x0E;
	ret = dm_i2c_write(dev, 0x36, buf, 1);
	/* VID_CHA_HORIZONTAL_FRONT_PORCH */
	buf[0] = 0xFC;
//	buf[0] = 0xBC;		// 252 -> 188
	ret = dm_i2c_write(dev, 0x38, buf, 1);
	/* VID_CHA_VERTICAL_FRONT_PORCH */
	buf[0] = 0x19;
	ret = dm_i2c_write(dev, 0x3A, buf, 1);
	/* VID_CHA_TEST_PATTERN */
	buf[0] = 0x00;
	ret = dm_i2c_write(dev, 0x3C, buf, 1);
	/* RC_PLL_EN */
	buf[0] = 0x01;
	ret = dm_i2c_write(dev, 0x0D, buf, 1);
	/* 10ms delay */
	udelay(10000);
	/* RC_RESET */
	buf[0] = 0x01;
	ret = dm_i2c_write(dev, 0x09, buf, 1);

	return 0;
}

int initialize_sn65dsi(int id)
{
	int ret = 0;

#ifndef JLCD_ONLY
	if (id == 0) {
		ret = initialize_sn65dsi_main();
	}
	else if (id == 1) {
#else
	if (id == 1) {
#endif
		ret = initialize_sn65dsi_jog();
	}
	else {
		ret = -EINVAL;
	}
	/* 10ms delay */
	udelay(10000);

	return ret;
}

int verify_sn65dsi(struct connector_state *conn_state)
{
	struct udevice *dev;
	int ret;
	u8 buf[8];

	/* 10ms delay */
	udelay(10000);

	if (conn_state && conn_state->node.np) {
#ifndef JLCD_ONLY
		if (strcmp(conn_state->node.np->full_name, MAIN_LCD) == 0)
		{
			ret = i2c_get_chip_for_busnum(3, 0x2C, 1, &dev);
			if (ret) {
				printf("%s: could not find a sn65dsi83\n", __func__);
				return -ENODEV;
			}
			/* IRQ_STAT */
			buf[0] = 0xFF;
			ret = dm_i2c_write(dev, 0xE5, buf, 1);
			if (ret) {
				printf("Failed to write IO expander value via I2C\n");
				return -EIO;
			}
			/* 100ms delay */
			mdelay(100);
			ret = dm_i2c_read(dev, 0xE5, buf, 1);
			if (ret) {
				printf("Failed to read IO expander value via I2C\n");
				return -EIO;
			}
			if (buf[0] != 0x00) {
				printf("%s() 0xE5:0x%02X %s\n",__func__,buf[0],conn_state->node.np->full_name);
				reset_cpu(0);
			}
		}
		else if (strcmp(conn_state->node.np->full_name, JOG_LCD) == 0)
#else
		if (strcmp(conn_state->node.np->full_name, JOG_LCD) == 0)
#endif
		{
			ret = i2c_get_chip_for_busnum(3, 0x2D, 1, &dev);
			if (ret) {
				printf("%s: could not find a sn65dsi83\n", __func__);
				return -ENODEV;
			}
			/* IRQ_STAT */
			buf[0] = 0xFF;
			ret = dm_i2c_write(dev, 0xE5, buf, 1);
			if (ret) {
				printf("Failed to write IO expander value via I2C\n");
				return -EIO;
			}
			/* 100ms delay */
			mdelay(100);
			ret = dm_i2c_read(dev, 0xE5, buf, 1);
			if (ret) {
				printf("Failed to read IO expander value via I2C\n");
				return -EIO;
			}
			if (buf[0] != 0x00) {
				printf("%s() 0xE5:0x%02X %s\n",__func__,buf[0],conn_state->node.np->full_name);
				reset_cpu(0);
			}
			/* check dedet_b */
			{
				ofnode node;
				struct gpio_desc st_gpio;		
				node = ofnode_path("/dedet_b");
				if (ofnode_valid(node)) {
					if (gpio_request_by_name_nodev(node, "dedet-jog-lcd", 0, &st_gpio, GPIOD_IS_IN)) {
						printf("%s: could not find a /dedet_b/dedet-jog-lcd\n", __func__);
					}
					else {
						if (dm_gpio_get_value(&st_gpio) == 1) {
							printf("%s: detect jog lcd failure.\n", __func__);
							reset_cpu(0);
						}
						else {
							printf("%s: detect LOW.\n", __func__);
						}
					}
				}
				else {
					printf("%s: no /dedet_b node?\n", __func__);
				}
			}
		}
	}

	return 0;
}
