/*
 * es9017.h  --  ES9017 ALSA SoC Audio driver
 *
 * Copyright (C) 2023 AlphaTheta Corporation
 */

#ifndef _ES9017_H
#define _ES9017_H

/* ES9017 register space */

/* Read,Write */
#define ES9017_SYSTEM_CONFIG					0x00
	#define ES9017_SYSTEM_CONFIG_SOFT_RESET				0x80
	#define ES9017_SYSTEM_CONFIG_ENABLE_64FS_MODE		0x40
	#define ES9017_SYSTEM_CONFIG_ENABLE_DOP_DECODE		0x10
	#define ES9017_SYSTEM_CONFIG_ENABLE_DSD_DECODE		0x08
	#define ES9017_SYSTEM_CONFIG_ENABLE_TDM_DECODE		0x04
	#define ES9017_SYSTEM_CONFIG_DAC_MODE_REG			0x02
#define ES9017_SYS_MODE_CONFIG					0x01
#define ES9017_DAC_CLOCK_CONFIG					0x02
#define ES9017_CLOCK_CONFIG						0x03
#define ES9017_CONFIG							0x04
/* Reserved: 0x05 - 0x0F */
#define ES9017_GPIO1_2_CONFIG					0x10
#define ES9017_GPIO3_4_CONFIG					0x11
#define ES9017_GPIO5_6_CONFIG					0x12
#define ES9017_GPIO7_8_CONFIG					0x13
#define ES9017_GPIO_OUTPUT_ENABLE				0x14
#define ES9017_GPIO_INPUT						0x15
#define ES9017_GPIO_OUTPUT_LOGIC_LOW			0x17
#define ES9017_GPIO_OUTPUT_LOGIC_HIGH			0x18
#define ES9017_INPUT_SELECTION					0x19
#define ES9017_SERIAL_MASTER_ENCODER_CONFIG		0x1A
#define ES9017_TDM_CONFIG						0x1B
#define ES9017_TDM_CONFIG1						0x1C
#define ES9017_TDM_CONFIG2						0x1D
#define ES9017_BCK_WS_MONITOR_CONFIG			0x1E
/* Reserved: 0x1F */
#define ES9017_TDM_CH1_CONFIG					0x20
#define ES9017_TDM_CH2_CONFIG					0x21
#define ES9017_TDM_CH3_CONFIG					0x22
#define ES9017_TDM_CH4_CONFIG					0x23
#define ES9017_TDM_CH5_CONFIG					0x24
#define ES9017_TDM_CH6_CONFIG					0x25
#define ES9017_TDM_CH7_CONFIG					0x26
#define ES9017_TDM_CH8_CONFIG					0x27
	#define ES9017_TDM_CHn_CONFIG_LINE_SEL_MASK			0x60
	#define ES9017_TDM_CHn_CONFIG_LINE_SEL_DATA2		0x00
	#define ES9017_TDM_CHn_CONFIG_LINE_SEL_DATA3		0x20
	#define ES9017_TDM_CHn_CONFIG_LINE_SEL_DATA4		0x40
	#define ES9017_TDM_CHn_CONFIG_LINE_SEL_DATA5		0x60
    #define ES9017_TDM_CHn_CONFIG_SLOT_SEL_MASK			0x1F
	#define ES9017_TDM_CHn_CONFIG_SLOT_SEL_SLOT(n)		\
			((unsigned int)(n) & ES9017_TDM_CHn_CONFIG_SLOT_SEL_MASK)
#define ES9017_VOLUME1							0x28
#define ES9017_VOLUME2							0x29
#define ES9017_VOLUME3							0x2A
#define ES9017_VOLUME4							0x2B
#define ES9017_VOLUME5							0x2C
#define ES9017_VOLUME6							0x2D
#define ES9017_VOLUME7							0x2E
#define ES9017_VOLUME8							0x2F
#define ES9017_DAC_VOL_UP_RATE					0x30
#define ES9017_DAC_VOL_DOWN_RATE				0x31
#define ES9017_DAC_VOL_DOWN_RATE_FAST			0x32
#define ES9017_DAC_MUTE							0x33
#define ES9017_DAC_INVERT						0x34
#define ES9017_FILTER_SHAPE						0x35
	#define ES9017_FILTER_SHAPE_MASK										0x07
	#define ES9017_FILTER_SHAPE_MINIMUM_PHASE								0x00
	#define ES9017_FILTER_SHAPE_LINEAR_PHASE_APODIZING						0x01
	#define ES9017_FILTER_SHAPE_LINEAR_PHASE_FAST_ROLLOFF					0x02
	#define ES9017_FILTER_SHAPE_LINEAR_PHASE_SLOW_ROLLOFF					0x04
	#define ES9017_FILTER_SHAPE_MINIMUM_PHASE_FAST_ROLLOFF					0x05
	#define ES9017_FILTER_SHAPE_MINIMUM_PHASE_SLOW_ROLLOFF					0x06
	#define ES9017_FILTER_SHAPE_MINIMUM_PHASE_SLOW_ROLLOFF_LOW_DISPERSION	0x07
#define ES9017_IIR_BANDWIDTH					0x36
#define ES9017_DAC_PATH_CONFIG					0x37
#define ES9017_AUTOMUTE_ENABLE					0x38
#define ES9017_AUTOMUTE_TIME_LOW				0x39
#define ES9017_AUTOMUTE_TIME_HIGH				0x3A
#define ES9017_AUTOMUTE_LEVEL_LOW				0x3B
#define ES9017_AUTOMUTE_LEVEL_HIGH				0x3C
#define ES9017_AUTOMUTE_OFF_LEVEL_LOW			0x3D
#define ES9017_AUTOMUTE_OFF_LEVEL_HIGH			0x3E
#define ES9017_SOFT_RAMP_CONFIG					0x3F
/* Reserved: 0x40 - 0x41 */

/* Read Only */
#define ES9017_SYS_READ							0xE0
#define ES9017_CHIP_ID_READ						0xE1
	#define ES9017_CHIP_ID						0x60
/* Reserved: 0xE2 - 0xE4 */
#define ES9017_RATIO_VALID_READ					0xE5
#define ES9017_INPUT_READBACK					0xE6
/* Reserved: 0xE7 - 0xE9 */

#endif /* _ES9017_H */
