/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2020 Fuzhou Rockchip Electronics Co., Ltd
 */

#ifndef _DT_BINDINGS_SOC_ROCKCHIP_IO_DOMAIN_H
#define _DT_BINDINGS_SOC_ROCKCHIP_IO_DOMAIN_H

/* RK3399 GRF_IO_VSEL */
#define BT656_GPIO2AB_MS(x)     ((x) << 0 | 1 << 16)
#define AUDIO_GPIO3D4A_MS(x)	((x) << 1 | 1 << 17)
#define SDMMC_GPIO4B_MS(x)	((x) << 2 | 1 << 18)
#define GPIO1833_GPIO4CD_MS(x)	((x) << 3 | 1 << 19)

/* RK3399 PMUGRF_SOC_CON0 */
#define PMU1830_VOLSEL(x)	((x) << 8 | 1 << 24)
#define PMU1830_VOL(x)		((x) << 9 | 1 << 25)

#define RK3399_BT656_VDD_1V8	BT656_GPIO2AB_MS(1)
#define RK3399_BT656_VDD_3V3	BT656_GPIO2AB_MS(0)
#define RK3399_SDMMC_VDD_1V8	SDMMC_GPIO4B_MS(1)
#define RK3399_SDMMC_VDD_3V3	SDMMC_GPIO4B_MS(0)
#define RK3399_GPIO1833_VDD_1V8	GPIO1833_GPIO4CD_MS(1)
#define RK3399_GPIO1833_VDD_3V3	GPIO1833_GPIO4CD_MS(0)
#define RK3399_AUDIO_VDD_1V8	AUDIO_GPIO3D4A_MS(1)
#define RK3399_AUDIO_VDD_3V3	AUDIO_GPIO3D4A_MS(0)
#define RK3399_PMU1830_VDD_1V8	(PMU1830_VOL(1) | PMU1830_VOLSEL(1))
#define RK3399_PMU1830_VDD_3V0	(PMU1830_VOL(0) | PMU1830_VOLSEL(1))

#endif
