/*
 * subucom_spi.h
 *
 * Copyright (C) 2020 AlphaTheta Corp.
 * Copyright (C) 2015-2017 Pioneer DJ Corp.
 * Copyright (C) 2011-2014 Pioneer Corp.
 * Yasurnori Shibata <yasunori.shibata@pioneerdj.com>
 *
 * Based on spidev.h by Andrea Paterniani
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
#ifndef _SUBUCOM_SPI_H
#define _SUBUCOM_SPI_H

#include <linux/types.h>
#include <linux/ioctl.h>

/* IOCTL commands */

#define SUBUCOM_IOC_MAGIC		'p'

struct subucom_ioc_transfer {
	__u8		multi_id;	/* multiplex index */
	__u8		_reserved;
	__u8		part_id;	/* partition index */
	__u8		part_num;	/* number of partitions */
	__u32		bytes;		/* bytes */
	__u64		tx_buf;		/* Tx buffer pointer */
};

#define SUBUCOM_MSGSIZE(N) \
	((((N)*(sizeof (struct subucom_ioc_transfer))) < (1 << _IOC_SIZEBITS)) \
	? ((N)*(sizeof (struct subucom_ioc_transfer))) : 0)

/* Transmit Tx message */
#define SUBUCOM_IOC_MESSAGE(N)	_IOW(SUBUCOM_IOC_MAGIC, 0, char[SUBUCOM_MSGSIZE(N)])

/* Read / Write timer status */
#define SUBUCOM_IOC_RD_TIMER_STATUS	_IOR(SUBUCOM_IOC_MAGIC, 1, __u8)
#define SUBUCOM_IOC_WR_TIMER_STATUS	_IOW(SUBUCOM_IOC_MAGIC, 1, __u8)

/* Read / Write timer interval msec */
#define SUBUCOM_IOC_RD_TIMER_INTERVAL	_IOR(SUBUCOM_IOC_MAGIC, 2, __u32)
#define SUBUCOM_IOC_WR_TIMER_INTERVAL	_IOW(SUBUCOM_IOC_MAGIC, 2, __u32)

/* Read / Write SPI device word length (1..N) */
#define SUBUCOM_IOC_RD_BITS_PER_WORD	_IOR(SUBUCOM_IOC_MAGIC, 3, __u16)
#define SUBUCOM_IOC_WR_BITS_PER_WORD	_IOW(SUBUCOM_IOC_MAGIC, 3, __u16)

/* Read / Write SPI Rx bytes */
#define SUBUCOM_IOC_RD_RX_BYTES		_IOR(SUBUCOM_IOC_MAGIC, 4, __u32)
#define SUBUCOM_IOC_WR_RX_BYTES		_IOW(SUBUCOM_IOC_MAGIC, 4, __u32)

/* Read / Write limit wait times(usec) PANEL busy */
#define SUBUCOM_IOC_RD_BUSYWAIT_UTIME	_IOR(SUBUCOM_IOC_MAGIC, 6, __u16)
#define SUBUCOM_IOC_WR_BUSYWAIT_UTIME	_IOW(SUBUCOM_IOC_MAGIC, 6, __u16)

#define SUBUCOM_IOC_WR_DEBUG			_IOW(SUBUCOM_IOC_MAGIC, 7, __u8)

#define SUBUCOM_IOC_RD_GPIO_REQ			_IOR(SUBUCOM_IOC_MAGIC, 11, __u32)
#define SUBUCOM_IOC_WR_GPIO_CONT		_IOW(SUBUCOM_IOC_MAGIC, 12, __u32)

#define SUBUCOM_IOC_RD_MAX_SPEED_HZ		_IOR(SUBUCOM_IOC_MAGIC, 255, __u32)
#define SUBUCOM_IOC_WR_MAX_SPEED_HZ		_IOW(SUBUCOM_IOC_MAGIC, 255, __u32)

#endif /* _SUBUCOM_SPI_H */
