/*
 * Driver for OV5642 CMOS Image Sensor from OmniVision
 *
 * Copyright (C) 2008, Guennadi Liakhovetski <kernel@pengutronix.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/videodev2.h>
#include <linux/slab.h>
#include <linux/i2c.h>
#include <linux/log2.h>
#include <linux/platform_device.h>
#include <linux/delay.h>
#include <linux/circ_buf.h>
#include <linux/hardirq.h>
#include <linux/miscdevice.h>
#include <asm/io.h>

#include <media/v4l2-common.h>
#include <media/v4l2-chip-ident.h>
#include <media/soc_camera.h>
#include <plat/rk_camera.h>
#include "mt9p111.h"

static int debug;
module_param(debug, int, S_IRUGO|S_IWUSR);

#define dprintk(level, fmt, arg...) do {			\
	if (debug >= level) 					\
	printk(KERN_WARNING fmt , ## arg); } while (0)

#define SENSOR_TR(format, ...) printk(KERN_ERR format, ## __VA_ARGS__)
#define SENSOR_DG(format, ...) dprintk(1, format, ## __VA_ARGS__)

#define _CONS(a,b) a##b
#define CONS(a,b) _CONS(a,b)

#define __STR(x) #x
#define _STR(x) __STR(x)
#define STR(x) _STR(x)

#define MIN(x,y)   ((x<y) ? x: y)
#define MAX(x,y)    ((x>y) ? x: y)

/* Sensor Driver Configuration */
#define SENSOR_NAME RK29_CAM_SENSOR_MT9P111
#define SENSOR_V4L2_IDENT V4L2_IDENT_MT9P111
#define SENSOR_ID SEQUENCE_END
#define SENSOR_ID_REG SEQUENCE_END
#define SENSOR_RESET_REG 0x0010
#define SENSOR_RESET_VAL 0x0115
#define SENSOR_RESET_REG_LEN  WORD_LEN
#define SENSOR_MIN_WIDTH    176
#define SENSOR_MIN_HEIGHT   144
#define SENSOR_MAX_WIDTH    2592
#define SENSOR_MAX_HEIGHT   1944
#define SENSOR_INIT_WIDTH	640			/* Sensor pixel size for sensor_init_data array */
#define SENSOR_INIT_HEIGHT  480
#define SENSOR_INIT_WINSEQADR sensor_vga
#define SENSOR_INIT_PIXFMT  V4L2_MBUS_FMT_UYVY8_2X8
#define YUV420_BUFFER_MAX_SIZE  7558272     /* 2592*1944*1.5*/ 

#define CONFIG_SENSOR_WhiteBalance	0
#define CONFIG_SENSOR_Brightness	0
#define CONFIG_SENSOR_Contrast      0
#define CONFIG_SENSOR_Saturation    0
#define CONFIG_SENSOR_Effect        0
#define CONFIG_SENSOR_Scene         0
#define CONFIG_SENSOR_DigitalZoom   0
#define CONFIG_SENSOR_Exposure      0
#define CONFIG_SENSOR_Flash         0
#define CONFIG_SENSOR_Mirror        0
#define CONFIG_SENSOR_Flip          0
#define CONFIG_SENSOR_Focus         1


#define CONFIG_SENSOR_I2C_SPEED     100000       /* Hz */
//#define CONFIG_SENSOR_I2C_SPEED   350000       /* Hz */
   
/* Sensor write register continues by preempt_disable/preempt_enable for current process not be scheduled */
#define CONFIG_SENSOR_I2C_NOSCHED   0
#define CONFIG_SENSOR_I2C_RDWRCHK   0


#define SENSOR_BUS_PARAM  (SOCAM_MASTER | SOCAM_PCLK_SAMPLE_RISING|\
                          SOCAM_HSYNC_ACTIVE_HIGH | SOCAM_VSYNC_ACTIVE_HIGH|\
                          SOCAM_DATA_ACTIVE_HIGH | SOCAM_DATAWIDTH_8  |SOCAM_MCLK_24MHZ)

#define COLOR_TEMPERATURE_CLOUDY_DN    6500
#define COLOR_TEMPERATURE_CLOUDY_UP    8000
#define COLOR_TEMPERATURE_CLEARDAY_DN  5000
#define COLOR_TEMPERATURE_CLEARDAY_UP    6500
#define COLOR_TEMPERATURE_OFFICE_DN     3500
#define COLOR_TEMPERATURE_OFFICE_UP     5000
#define COLOR_TEMPERATURE_HOME_DN       2500
#define COLOR_TEMPERATURE_HOME_UP       3500

#define SENSOR_NAME_STRING(a) STR(CONS(SENSOR_NAME, a))
#define SENSOR_NAME_VARFUN(a) CONS(SENSOR_NAME, a)

#define SENSOR_AF_IS_ERR    (0x00<<0)
#define SENSOR_AF_IS_OK		(0x01<<0)
#define SENSOR_INIT_IS_ERR   (0x00<<28)
#define SENSOR_INIT_IS_OK    (0x01<<28)



#if CONFIG_SENSOR_Focus
/*#define SENSOR_AF_MODE_INFINITY    0
#define SENSOR_AF_MODE_MACRO       1
#define SENSOR_AF_MODE_FIXED       2
#define SENSOR_AF_MODE_AUTO        3
#define SENSOR_AF_MODE_CONTINUOUS  4
#define SENSOR_AF_MODE_CLOSE       5*/
#define SENSOR_AF_MODE_AUTO        0
#define SENSOR_AF_MODE_CLOSE       1
#define SENSOR_AF_MODE_CONTINUOUS  2
#endif

//flash off in fixed time to prevent from too hot , zyc
struct  flash_timer{
	int status;
	struct soc_camera_device *icd;
	struct hrtimer timer;
};
static enum hrtimer_restart flash_off_func(struct hrtimer *timer);

static struct  flash_timer flash_off_timer;
//for user defined if user want to customize the series , zyc
#ifdef CONFIG_MT9P111_USER_DEFINED_SERIES
#include "mt9p111_user_series.c"
#else

/* init 640X480 VGA */
static struct reginfo sensor_init_data[] =
{     
{ 0x0010, 0x0340, WORD_LEN, 0 },           


{ 0x0010, 0x0340, WORD_LEN, 0 }, 	// PLL_DIVIDERS
{ 0x0012, 0x0080, WORD_LEN, 0 }, 	// PLL_P_DIVIDERS
{ 0x0014, 0x2025, WORD_LEN, 0 }, 	// PLL_CONTROL
{ 0x001E, 0x0565, WORD_LEN, 0 }, 	// PAD_SLEW_PAD_CONFIG
{ 0x0022, 0x0030, WORD_LEN, 0 }, 	// VDD_DIS_COUNTER
{ 0x002A, 0x7FFF, WORD_LEN, 0 }, 	// PLL_P4_P5_P6_DIVIDERS
{ 0x002C, 0x0000, WORD_LEN, 0 }, 	// PLL_P7_DIVIDER
{ 0x002E, 0x0000, WORD_LEN, 0 }, 	// SENSOR_CLOCK_DIVIDER
{ 0x0018, 0x400c, WORD_LEN, 0 }, 	// STANDBY_CONTROL_AND_STATUS
//delay = 100
{SEQUENCE_WAIT_MS,300,WORD_LEN,0},
{ 0x098E, 0x483A, WORD_LEN, 0 }, 	// LOGICAL_ADDRESS_ACCESS
{ 0xC83A, 0x000C, WORD_LEN, 0 }, 	// CAM_CORE_A_Y_ADDR_START
{ 0xC83C, 0x0018, WORD_LEN, 0 }, 	// CAM_CORE_A_X_ADDR_START
{ 0xC83E, 0x07B1, WORD_LEN, 0 }, 	// CAM_CORE_A_Y_ADDR_END
{ 0xC840, 0x0A45, WORD_LEN, 0 }, 	// CAM_CORE_A_X_ADDR_END
{ 0xC842, 0x0001, WORD_LEN, 0 }, 	// CAM_CORE_A_ROW_SPEED
{ 0xC844, 0x0103, WORD_LEN, 0 }, 	// CAM_CORE_A_SKIP_X_CORE
{ 0xC846, 0x0103, WORD_LEN, 0 }, 	// CAM_CORE_A_SKIP_Y_CORE
{ 0xC848, 0x0103, WORD_LEN, 0 }, 	// CAM_CORE_A_SKIP_X_PIPE
{ 0xC84A, 0x0103, WORD_LEN, 0 }, 	// CAM_CORE_A_SKIP_Y_PIPE
{ 0xC84C, 0x00F6, WORD_LEN, 0 }, 	// CAM_CORE_A_POWER_MODE
{ 0xC84E, 0x0001, WORD_LEN, 0 }, 	// CAM_CORE_A_BIN_MODE
{ 0xC850, 0x00, BYTE_LEN, 0}, 	// CAM_CORE_A_ORIENTATION
{ 0xC851, 0x00, BYTE_LEN, 0}, 	// CAM_CORE_A_PIXEL_ORDER
{ 0xC852, 0x019C, WORD_LEN, 0 }, 	// CAM_CORE_A_FINE_CORRECTION
{ 0xC854, 0x0732, WORD_LEN, 0 }, 	// CAM_CORE_A_FINE_ITMIN
{ 0xC858, 0x0000, WORD_LEN, 0 }, 	// CAM_CORE_A_COARSE_ITMIN
{ 0xC85A, 0x0001, WORD_LEN, 0 }, 	// CAM_CORE_A_COARSE_ITMAX_MARGIN
{ 0xC85C, 0x0423, WORD_LEN, 0 }, 	// CAM_CORE_A_MIN_FRAME_LENGTH_LINES
{ 0xC85E, 0xFFFF, WORD_LEN, 0 }, 	// CAM_CORE_A_MAX_FRAME_LENGTH_LINES
{ 0xC860, 0x0423, WORD_LEN, 0 }, 	// CAM_CORE_A_BASE_FRAME_LENGTH_LINES
{ 0xC862, 0x1194, WORD_LEN, 0 }, 	// CAM_CORE_A_MIN_LINE_LENGTH_PCLK
{ 0xC864, 0xFFFE, WORD_LEN, 0 }, 	// CAM_CORE_A_MAX_LINE_LENGTH_PCLK
{ 0xC866, 0x7F7F, WORD_LEN, 0 }, 	// CAM_CORE_A_P4_5_6_DIVIDER
{ 0xC868, 0x0423, WORD_LEN, 0 }, 	// CAM_CORE_A_FRAME_LENGTH_LINES
{ 0xC86A, 0x1194, WORD_LEN, 0 }, 	// CAM_CORE_A_LINE_LENGTH_PCK
{ 0xC86C, 0x0518, WORD_LEN, 0 }, 	// CAM_CORE_A_OUTPUT_SIZE_WIDTH
{ 0xC86E, 0x03D4, WORD_LEN, 0 }, 	// CAM_CORE_A_OUTPUT_SIZE_HEIGHT
{ 0xC870, 0x0014, WORD_LEN, 0 }, 	// CAM_CORE_A_RX_FIFO_TRIGGER_MARK
{ 0xC858, 0x0003, WORD_LEN, 0 }, 	// CAM_CORE_A_COARSE_ITMIN
{ 0xC8B8, 0x0004, WORD_LEN, 0 }, 	// CAM_OUTPUT_0_JPEG_CONTROL
{ 0xC8AE, 0x0001, WORD_LEN, 0 }, 	// CAM_OUTPUT_0_OUTPUT_FORMAT
{ 0xC8AA, 0x0280, WORD_LEN, 0 }, 	// CAM_OUTPUT_0_IMAGE_WIDTH
{ 0xC8AC, 0x01E0, WORD_LEN, 0 }, 	// CAM_OUTPUT_0_IMAGE_HEIGHT
{ 0xC872, 0x0010, WORD_LEN, 0 }, 	// CAM_CORE_B_Y_ADDR_START
{ 0xC874, 0x001C, WORD_LEN, 0 }, 	// CAM_CORE_B_X_ADDR_START
{ 0xC876, 0x07AF, WORD_LEN, 0 }, 	// CAM_CORE_B_Y_ADDR_END
{ 0xC878, 0x0A43, WORD_LEN, 0 }, 	// CAM_CORE_B_X_ADDR_END
{ 0xC87A, 0x0001, WORD_LEN, 0 }, 	// CAM_CORE_B_ROW_SPEED
{ 0xC87C, 0x0101, WORD_LEN, 0 }, 	// CAM_CORE_B_SKIP_X_CORE
{ 0xC87E, 0x0101, WORD_LEN, 0 }, 	// CAM_CORE_B_SKIP_Y_CORE
{ 0xC880, 0x0101, WORD_LEN, 0 }, 	// CAM_CORE_B_SKIP_X_PIPE
{ 0xC882, 0x0101, WORD_LEN, 0 }, 	// CAM_CORE_B_SKIP_Y_PIPE
{ 0xC884, 0x00F2, WORD_LEN, 0 }, 	// CAM_CORE_B_POWER_MODE
{ 0xC886, 0x0000, WORD_LEN, 0 }, 	// CAM_CORE_B_BIN_MODE
{ 0xC888, 0x00, BYTE_LEN, 0}, 	// CAM_CORE_B_ORIENTATION
{ 0xC889, 0x00, BYTE_LEN, 0}, 	// CAM_CORE_B_PIXEL_ORDER
{ 0xC88A, 0x009C, WORD_LEN, 0 }, 	// CAM_CORE_B_FINE_CORRECTION
{ 0xC88C, 0x034A, WORD_LEN, 0 }, 	// CAM_CORE_B_FINE_ITMIN
{ 0xC890, 0x0000, WORD_LEN, 0 }, 	// CAM_CORE_B_COARSE_ITMIN
{ 0xC892, 0x0001, WORD_LEN, 0 }, 	// CAM_CORE_B_COARSE_ITMAX_MARGIN
{ 0xC894, 0x07EF, WORD_LEN, 0 }, 	// CAM_CORE_B_MIN_FRAME_LENGTH_LINES
{ 0xC896, 0xFFFF, WORD_LEN, 0 }, 	// CAM_CORE_B_MAX_FRAME_LENGTH_LINES
{ 0xC898, 0x082F, WORD_LEN, 0 }, 	// CAM_CORE_B_BASE_FRAME_LENGTH_LINES
{ 0xC89A, 0x1964, WORD_LEN, 0 }, 	// CAM_CORE_B_MIN_LINE_LENGTH_PCLK
{ 0xC89C, 0xFFFE, WORD_LEN, 0 }, 	// CAM_CORE_B_MAX_LINE_LENGTH_PCLK
{ 0xC89E, 0x7F7F, WORD_LEN, 0 }, 	// CAM_CORE_B_P4_5_6_DIVIDER
{ 0xC8A0, 0x07EF, WORD_LEN, 0 }, 	// CAM_CORE_B_FRAME_LENGTH_LINES
{ 0xC8A2, 0x1964, WORD_LEN, 0 }, 	// CAM_CORE_B_LINE_LENGTH_PCK
{ 0xC8A4, 0x0A28, WORD_LEN, 0 }, 	// CAM_CORE_B_OUTPUT_SIZE_WIDTH
{ 0xC8A6, 0x07A0, WORD_LEN, 0 }, 	// CAM_CORE_B_OUTPUT_SIZE_HEIGHT
{ 0xC8A8, 0x0124, WORD_LEN, 0 }, 	// CAM_CORE_B_RX_FIFO_TRIGGER_MARK
{ 0xC890, 0x0003, WORD_LEN, 0 }, 	// CAM_CORE_B_COARSE_ITMIN
{ 0xC8C0, 0x0A20, WORD_LEN, 0 }, 	// CAM_OUTPUT_1_IMAGE_WIDTH
{ 0xC8C2, 0x0798, WORD_LEN, 0 }, 	// CAM_OUTPUT_1_IMAGE_HEIGHT
{ 0xC89A, 0x1964, WORD_LEN, 0 }, 	// CAM_CORE_B_MIN_LINE_LENGTH_PCLK
{ 0xC8A2, 0x1964, WORD_LEN, 0 }, 	// CAM_CORE_B_LINE_LENGTH_PCK
{ 0xC8C4, 0x0001, WORD_LEN, 0 }, 	// CAM_OUTPUT_1_OUTPUT_FORMAT
{ 0xC8C6, 0x0000, WORD_LEN, 0 }, 	// CAM_OUTPUT_1_OUTPUT_FORMAT_ORDER
{ 0xC8CE, 0x0014, WORD_LEN, 0 }, 	// CAM_OUTPUT_1_JPEG_CONTROL
{ 0xD822, 0x4610, WORD_LEN, 0 }, 	// JPEG_JPSS_CTRL_VAR
{ 0x3330, 0x0000, WORD_LEN, 0 }, 	// OUTPUT_FORMAT_TEST
{ 0x098E, 0xA00E, WORD_LEN, 0 }, 	// LOGICAL_ADDRESS_ACCESS
{ 0xA00E, 0x32, BYTE_LEN, 0}, 	// FD_MAX_NUM_AUTOCOR_FUNC_VALUES_TO_CHECK
{ 0xA010, 0x00CC, WORD_LEN, 0 }, 	// FD_MIN_EXPECTED50HZ_FLICKER_PERIOD
{ 0xA012, 0x00E0, WORD_LEN, 0 }, 	// FD_MAX_EXPECTED50HZ_FLICKER_PERIOD
{ 0xA014, 0x00A8, WORD_LEN, 0 }, 	// FD_MIN_EXPECTED60HZ_FLICKER_PERIOD
{ 0xA016, 0x00BC, WORD_LEN, 0 }, 	// FD_MAX_EXPECTED60HZ_FLICKER_PERIOD
{ 0xA018, 0x00D6, WORD_LEN, 0 }, 	// FD_EXPECTED50HZ_FLICKER_PERIOD_IN_CONTEXT_A
{ 0xA01A, 0x0075, WORD_LEN, 0 }, 	// FD_EXPECTED50HZ_FLICKER_PERIOD_IN_CONTEXT_B
{ 0xA01C, 0x00B2, WORD_LEN, 0 }, 	// FD_EXPECTED60HZ_FLICKER_PERIOD_IN_CONTEXT_A
{ 0xA01E, 0x0062, WORD_LEN, 0 }, 	// FD_EXPECTED60HZ_FLICKER_PERIOD_IN_CONTEXT_B
{ 0xA000, 0x10, BYTE_LEN, 0}, 	// FD_STATUS
{ 0x8417, 0x02, BYTE_LEN, 0}, 	// SEQ_STATE_CFG_1_FD
//delay = 100
{ SEQUENCE_WAIT_MS,100, BYTE_LEN, 0},


//[Step2-Fixups]                                  
// Default variable access mode is always logical.


{ 0x098E, 0x0000, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS
{ 0x301A, 0x0030, WORD_LEN, 0}, 	// RESET_REGISTER
{ 0x316C, 0xB430, WORD_LEN, 0}, 	// DAC_TXLO
{ 0x31E0, 0x0003, WORD_LEN, 0}, 	// PIX_DEF_ID
{ 0x3E2E, 0xF319, WORD_LEN, 0}, 	// SAMP_SPARE
{ 0x3EE6, 0xA7C1, WORD_LEN, 0}, 	// DAC_LD_26_27
{ 0x301E, 0x00A8, WORD_LEN, 0}, 	// DATA_PEDESTAL
{ 0xDC33, 0x2A, BYTE_LEN, 0}, 	// SYS_FIRST_BLACK_LEVEL
{ 0x3812, 0x212C, WORD_LEN, 0}, 	// OTPM_CFG
{ 0x0982, 0x0000, WORD_LEN, 0}, 	// ACCESS_CTL_STAT
{ 0x098A, 0x0000, WORD_LEN, 0}, 	// PHYSICAL_ADDRESS_ACCESS
{ 0x886C, 0xC0F1, WORD_LEN, 0},
{ 0x886E, 0xC5E1, WORD_LEN, 0},
{ 0x8870, 0x246A, WORD_LEN, 0},
{ 0x8872, 0x1280, WORD_LEN, 0},
{ 0x8874, 0xC4E1, WORD_LEN, 0},
{ 0x8876, 0xD20F, WORD_LEN, 0},
{ 0x8878, 0x2069, WORD_LEN, 0},
{ 0x887A, 0x0000, WORD_LEN, 0},
{ 0x887C, 0x6A62, WORD_LEN, 0},
{ 0x887E, 0x1303, WORD_LEN, 0},
{ 0x8880, 0x0084, WORD_LEN, 0},
{ 0x8882, 0x1734, WORD_LEN, 0},
{ 0x8884, 0x7005, WORD_LEN, 0},
{ 0x8886, 0xD801, WORD_LEN, 0},
{ 0x8888, 0x8A41, WORD_LEN, 0},
{ 0x888A, 0xD900, WORD_LEN, 0},
{ 0x888C, 0x0D5A, WORD_LEN, 0},
{ 0x888E, 0x0664, WORD_LEN, 0},
{ 0x8890, 0x8B61, WORD_LEN, 0},
{ 0x8892, 0xE80B, WORD_LEN, 0},
{ 0x8894, 0x000D, WORD_LEN, 0},
{ 0x8896, 0x0020, WORD_LEN, 0},
{ 0x8898, 0xD508, WORD_LEN, 0},
{ 0x889A, 0x1504, WORD_LEN, 0},
{ 0x889C, 0x1400, WORD_LEN, 0},
{ 0x889E, 0x7840, WORD_LEN, 0},
{ 0x88A0, 0xD007, WORD_LEN, 0},
{ 0x88A2, 0x0DFB, WORD_LEN, 0},
{ 0x88A4, 0x9004, WORD_LEN, 0},
{ 0x88A6, 0xC4C1, WORD_LEN, 0},
{ 0x88A8, 0x2029, WORD_LEN, 0},
{ 0x88AA, 0x0300, WORD_LEN, 0},
{ 0x88AC, 0x0219, WORD_LEN, 0},
{ 0x88AE, 0x06C4, WORD_LEN, 0},
{ 0x88B0, 0xFF80, WORD_LEN, 0},
{ 0x88B2, 0x08D4, WORD_LEN, 0},
{ 0x88B4, 0xFF80, WORD_LEN, 0},
{ 0x88B6, 0x086C, WORD_LEN, 0},
{ 0x88B8, 0xFF80, WORD_LEN, 0},
{ 0x88BA, 0x08C0, WORD_LEN, 0},
{ 0x88BC, 0xFF80, WORD_LEN, 0},
{ 0x88BE, 0x08D4, WORD_LEN, 0},
{ 0x88C0, 0xFF80, WORD_LEN, 0},
{ 0x88C2, 0x08DC, WORD_LEN, 0},
{ 0x88C4, 0xFF80, WORD_LEN, 0},
{ 0x88C6, 0x0F58, WORD_LEN, 0},
{ 0x88C8, 0xFF80, WORD_LEN, 0},
{ 0x88CA, 0x0920, WORD_LEN, 0},
{ 0x88CC, 0xFF80, WORD_LEN, 0},
{ 0x88CE, 0x1010, WORD_LEN, 0},
{ 0x88D0, 0xFF80, WORD_LEN, 0},
{ 0x88D2, 0x1030, WORD_LEN, 0},
{ 0x88D4, 0x0010, WORD_LEN, 0},
{ 0x88D6, 0x0008, WORD_LEN, 0},
{ 0x88D8, 0x0000, WORD_LEN, 0},
{ 0x88DA, 0x0000, WORD_LEN, 0},
{ 0x88DC, 0xD102, WORD_LEN, 0},
{ 0x88DE, 0xD003, WORD_LEN, 0},
{ 0x88E0, 0x7FE0, WORD_LEN, 0},
{ 0x88E2, 0xB035, WORD_LEN, 0},
{ 0x88E4, 0xFF80, WORD_LEN, 0},
{ 0x88E6, 0x10C8, WORD_LEN, 0},
{ 0x88E8, 0xFF80, WORD_LEN, 0},
{ 0x88EA, 0x0118, WORD_LEN, 0},
{ 0x88EC, 0xC0F1, WORD_LEN, 0},
{ 0x88EE, 0xC5E1, WORD_LEN, 0},
{ 0x88F0, 0xD5EC, WORD_LEN, 0},
{ 0x88F2, 0x8D04, WORD_LEN, 0},
{ 0x88F4, 0x8D25, WORD_LEN, 0},
{ 0x88F6, 0xB808, WORD_LEN, 0},
{ 0x88F8, 0x7825, WORD_LEN, 0},
{ 0x88FA, 0x0821, WORD_LEN, 0},
{ 0x88FC, 0x01DE, WORD_LEN, 0},
{ 0x88FE, 0xD0EA, WORD_LEN, 0},
{ 0x8900, 0x8000, WORD_LEN, 0},
{ 0x8902, 0x8008, WORD_LEN, 0},
{ 0x8904, 0x7840, WORD_LEN, 0},
{ 0x8906, 0x8D04, WORD_LEN, 0},
{ 0x8908, 0x8D25, WORD_LEN, 0},
{ 0x890A, 0xB808, WORD_LEN, 0},
{ 0x890C, 0x7825, WORD_LEN, 0},
{ 0x890E, 0xB8A7, WORD_LEN, 0},
{ 0x8910, 0x2841, WORD_LEN, 0},
{ 0x8912, 0x0201, WORD_LEN, 0},
{ 0x8914, 0xAD24, WORD_LEN, 0},
{ 0x8916, 0xAD05, WORD_LEN, 0},
{ 0x8918, 0x09A6, WORD_LEN, 0},
{ 0x891A, 0x0104, WORD_LEN, 0},
{ 0x891C, 0x01A9, WORD_LEN, 0},
{ 0x891E, 0x06C4, WORD_LEN, 0},
{ 0x8920, 0xC0F1, WORD_LEN, 0},
{ 0x8922, 0x0932, WORD_LEN, 0},
{ 0x8924, 0x06E4, WORD_LEN, 0},
{ 0x8926, 0xDA38, WORD_LEN, 0},
{ 0x8928, 0xD1E0, WORD_LEN, 0},
{ 0x892A, 0xD5E1, WORD_LEN, 0},
{ 0x892C, 0x76A9, WORD_LEN, 0},
{ 0x892E, 0x0EC6, WORD_LEN, 0},
{ 0x8930, 0x06A4, WORD_LEN, 0},
{ 0x8932, 0x70C9, WORD_LEN, 0},
{ 0x8934, 0xD0DF, WORD_LEN, 0},
{ 0x8936, 0xA501, WORD_LEN, 0},
{ 0x8938, 0xD0DF, WORD_LEN, 0},
{ 0x893A, 0xA503, WORD_LEN, 0},
{ 0x893C, 0xD0DF, WORD_LEN, 0},
{ 0x893E, 0xA506, WORD_LEN, 0},
{ 0x8940, 0xD0DF, WORD_LEN, 0},
{ 0x8942, 0xA509, WORD_LEN, 0},
{ 0x8944, 0xD0D8, WORD_LEN, 0},
{ 0x8946, 0xA0C0, WORD_LEN, 0},
{ 0x8948, 0xD0DE, WORD_LEN, 0},
{ 0x894A, 0x802E, WORD_LEN, 0},
{ 0x894C, 0x9117, WORD_LEN, 0},
{ 0x894E, 0x0171, WORD_LEN, 0},
{ 0x8950, 0x06E4, WORD_LEN, 0},
{ 0x8952, 0xB10E, WORD_LEN, 0},
{ 0x8954, 0xC0F1, WORD_LEN, 0},
{ 0x8956, 0xD0D3, WORD_LEN, 0},
{ 0x8958, 0x8806, WORD_LEN, 0},
{ 0x895A, 0x080F, WORD_LEN, 0},
{ 0x895C, 0x0051, WORD_LEN, 0},
{ 0x895E, 0xD0D2, WORD_LEN, 0},
{ 0x8960, 0x8000, WORD_LEN, 0},
{ 0x8962, 0x8008, WORD_LEN, 0},
{ 0x8964, 0x7840, WORD_LEN, 0},
{ 0x8966, 0x0A1E, WORD_LEN, 0},
{ 0x8968, 0x0104, WORD_LEN, 0},
{ 0x896A, 0xC0D1, WORD_LEN, 0},
{ 0x896C, 0x7EE0, WORD_LEN, 0},
{ 0x896E, 0x78E0, WORD_LEN, 0},
{ 0x8970, 0xC0F1, WORD_LEN, 0},
{ 0x8972, 0x08D6, WORD_LEN, 0},
{ 0x8974, 0x06C4, WORD_LEN, 0},
{ 0x8976, 0xD7CC, WORD_LEN, 0},
{ 0x8978, 0x8700, WORD_LEN, 0},
{ 0x897A, 0x8009, WORD_LEN, 0},
{ 0x897C, 0x7840, WORD_LEN, 0},
{ 0x897E, 0xE080, WORD_LEN, 0},
{ 0x8980, 0x0276, WORD_LEN, 0},
{ 0x8982, 0x0002, WORD_LEN, 0},
{ 0x8984, 0xD5C7, WORD_LEN, 0},
{ 0x8986, 0xD6D0, WORD_LEN, 0},
{ 0x8988, 0x1530, WORD_LEN, 0},
{ 0x898A, 0x1081, WORD_LEN, 0},
{ 0x898C, 0x1531, WORD_LEN, 0},
{ 0x898E, 0x1080, WORD_LEN, 0},
{ 0x8990, 0xB908, WORD_LEN, 0},
{ 0x8992, 0x7905, WORD_LEN, 0},
{ 0x8994, 0x2941, WORD_LEN, 0},
{ 0x8996, 0x0200, WORD_LEN, 0},
{ 0x8998, 0x1D32, WORD_LEN, 0},
{ 0x899A, 0x1002, WORD_LEN, 0},
{ 0x899C, 0x1D33, WORD_LEN, 0},
{ 0x899E, 0x1042, WORD_LEN, 0},
{ 0x89A0, 0x962D, WORD_LEN, 0},
{ 0x89A2, 0x2540, WORD_LEN, 0},
{ 0x89A4, 0x15D1, WORD_LEN, 0},
{ 0x89A6, 0x2941, WORD_LEN, 0},
{ 0x89A8, 0x0200, WORD_LEN, 0},
{ 0x89AA, 0x1D30, WORD_LEN, 0},
{ 0x89AC, 0x1002, WORD_LEN, 0},
{ 0x89AE, 0x8D06, WORD_LEN, 0},
{ 0x89B0, 0x2540, WORD_LEN, 0},
{ 0x89B2, 0x1610, WORD_LEN, 0},
{ 0x89B4, 0x1D31, WORD_LEN, 0},
{ 0x89B6, 0x1042, WORD_LEN, 0},
{ 0x89B8, 0x081B, WORD_LEN, 0},
{ 0x89BA, 0x0051, WORD_LEN, 0},
{ 0x89BC, 0x8700, WORD_LEN, 0},
{ 0x89BE, 0x8008, WORD_LEN, 0},
{ 0x89C0, 0x7840, WORD_LEN, 0},
{ 0x89C2, 0xD900, WORD_LEN, 0},
{ 0x89C4, 0x2941, WORD_LEN, 0},
{ 0x89C6, 0x0200, WORD_LEN, 0},
{ 0x89C8, 0xAD00, WORD_LEN, 0},
{ 0x89CA, 0xAD21, WORD_LEN, 0},
{ 0x89CC, 0xD801, WORD_LEN, 0},
{ 0x89CE, 0x1D4D, WORD_LEN, 0},
{ 0x89D0, 0x1002, WORD_LEN, 0},
{ 0x89D2, 0x154D, WORD_LEN, 0},
{ 0x89D4, 0x1080, WORD_LEN, 0},
{ 0x89D6, 0xB861, WORD_LEN, 0},
{ 0x89D8, 0xE085, WORD_LEN, 0},
{ 0x89DA, 0x0218, WORD_LEN, 0},
{ 0x89DC, 0x000D, WORD_LEN, 0},
{ 0x89DE, 0x2740, WORD_LEN, 0},
{ 0x89E0, 0x7381, WORD_LEN, 0},
{ 0x89E2, 0x2132, WORD_LEN, 0},
{ 0x89E4, 0x0000, WORD_LEN, 0},
{ 0x89E6, 0x7914, WORD_LEN, 0},
{ 0x89E8, 0x7900, WORD_LEN, 0},
{ 0x89EA, 0x0323, WORD_LEN, 0},
{ 0x89EC, 0x67BB, WORD_LEN, 0},
{ 0x89EE, 0xD62E, WORD_LEN, 0},
{ 0x89F0, 0x8D11, WORD_LEN, 0},
{ 0x89F2, 0xD1B6, WORD_LEN, 0},
{ 0x89F4, 0x8924, WORD_LEN, 0},
{ 0x89F6, 0x2032, WORD_LEN, 0},
{ 0x89F8, 0x2000, WORD_LEN, 0},
{ 0x89FA, 0xDE02, WORD_LEN, 0},
{ 0x89FC, 0x082B, WORD_LEN, 0},
{ 0x89FE, 0x0040, WORD_LEN, 0},
{ 0x8A00, 0x8D20, WORD_LEN, 0},
{ 0x8A02, 0x8D41, WORD_LEN, 0},
{ 0x8A04, 0xB908, WORD_LEN, 0},
{ 0x8A06, 0x7945, WORD_LEN, 0},
{ 0x8A08, 0xB983, WORD_LEN, 0},
{ 0x8A0A, 0x2941, WORD_LEN, 0},
{ 0x8A0C, 0x0202, WORD_LEN, 0},
{ 0x8A0E, 0xAD40, WORD_LEN, 0},
{ 0x8A10, 0xAD21, WORD_LEN, 0},
{ 0x8A12, 0xD1AF, WORD_LEN, 0},
{ 0x8A14, 0x8120, WORD_LEN, 0},
{ 0x8A16, 0x8121, WORD_LEN, 0},
{ 0x8A18, 0x7940, WORD_LEN, 0},
{ 0x8A1A, 0x8D06, WORD_LEN, 0},
{ 0x8A1C, 0xE001, WORD_LEN, 0},
{ 0x8A1E, 0xAD06, WORD_LEN, 0},
{ 0x8A20, 0x1D4D, WORD_LEN, 0},
{ 0x8A22, 0x1382, WORD_LEN, 0},
{ 0x8A24, 0xF0E9, WORD_LEN, 0},
{ 0x8A26, 0x8D06, WORD_LEN, 0},
{ 0x8A28, 0x1D4D, WORD_LEN, 0},
{ 0x8A2A, 0x1382, WORD_LEN, 0},
{ 0x8A2C, 0xE001, WORD_LEN, 0},
{ 0x8A2E, 0xAD06, WORD_LEN, 0},
{ 0x8A30, 0x8D00, WORD_LEN, 0},
{ 0x8A32, 0x8D21, WORD_LEN, 0},
{ 0x8A34, 0xB808, WORD_LEN, 0},
{ 0x8A36, 0x7825, WORD_LEN, 0},
{ 0x8A38, 0xB885, WORD_LEN, 0},
{ 0x8A3A, 0x2841, WORD_LEN, 0},
{ 0x8A3C, 0x0201, WORD_LEN, 0},
{ 0x8A3E, 0xAD20, WORD_LEN, 0},
{ 0x8A40, 0xAD01, WORD_LEN, 0},
{ 0x8A42, 0x8D31, WORD_LEN, 0},
{ 0x8A44, 0xF01A, WORD_LEN, 0},
{ 0x8A46, 0x8D31, WORD_LEN, 0},
{ 0x8A48, 0x8D12, WORD_LEN, 0},
{ 0x8A4A, 0x8D46, WORD_LEN, 0},
{ 0x8A4C, 0x7822, WORD_LEN, 0},
{ 0x8A4E, 0x0863, WORD_LEN, 0},
{ 0x8A50, 0x0082, WORD_LEN, 0},
{ 0x8A52, 0x1532, WORD_LEN, 0},
{ 0x8A54, 0x1080, WORD_LEN, 0},
{ 0x8A56, 0x1533, WORD_LEN, 0},
{ 0x8A58, 0x1081, WORD_LEN, 0},
{ 0x8A5A, 0x1531, WORD_LEN, 0},
{ 0x8A5C, 0x1082, WORD_LEN, 0},
{ 0x8A5E, 0xB808, WORD_LEN, 0},
{ 0x8A60, 0x7825, WORD_LEN, 0},
{ 0x8A62, 0x1530, WORD_LEN, 0},
{ 0x8A64, 0x1081, WORD_LEN, 0},
{ 0x8A66, 0xB908, WORD_LEN, 0},
{ 0x8A68, 0x7945, WORD_LEN, 0},
{ 0x8A6A, 0xD29A, WORD_LEN, 0},
{ 0x8A6C, 0x0992, WORD_LEN, 0},
{ 0x8A6E, 0x0020, WORD_LEN, 0},
{ 0x8A70, 0x8A40, WORD_LEN, 0},
{ 0x8A72, 0x8D31, WORD_LEN, 0},
{ 0x8A74, 0x081F, WORD_LEN, 0},
{ 0x8A76, 0x0051, WORD_LEN, 0},
{ 0x8A78, 0x8D06, WORD_LEN, 0},
{ 0x8A7A, 0x6038, WORD_LEN, 0},
{ 0x8A7C, 0xD194, WORD_LEN, 0},
{ 0x8A7E, 0x8120, WORD_LEN, 0},
{ 0x8A80, 0x8121, WORD_LEN, 0},
{ 0x8A82, 0x7960, WORD_LEN, 0},
{ 0x8A84, 0x2132, WORD_LEN, 0},
{ 0x8A86, 0x2000, WORD_LEN, 0},
{ 0x8A88, 0x8D06, WORD_LEN, 0},
{ 0x8A8A, 0xE001, WORD_LEN, 0},
{ 0x8A8C, 0xAD06, WORD_LEN, 0},
{ 0x8A8E, 0xD806, WORD_LEN, 0},
{ 0x8A90, 0xF0B1, WORD_LEN, 0},
{ 0x8A92, 0xE88F, WORD_LEN, 0},
{ 0x8A94, 0x8D66, WORD_LEN, 0},
{ 0x8A96, 0x633B, WORD_LEN, 0},
{ 0x8A98, 0x63BB, WORD_LEN, 0},
{ 0x8A9A, 0xD08D, WORD_LEN, 0},
{ 0x8A9C, 0x8000, WORD_LEN, 0},
{ 0x8A9E, 0x8021, WORD_LEN, 0},
{ 0x8AA0, 0x7960, WORD_LEN, 0},
{ 0x8AA2, 0x8B17, WORD_LEN, 0},
{ 0x8AA4, 0x8D06, WORD_LEN, 0},
{ 0x8AA6, 0xE001, WORD_LEN, 0},
{ 0x8AA8, 0xAD06, WORD_LEN, 0},
{ 0x8AAA, 0xD803, WORD_LEN, 0},
{ 0x8AAC, 0xF0A3, WORD_LEN, 0},
{ 0x8AAE, 0x2032, WORD_LEN, 0},
{ 0x8AB0, 0x2040, WORD_LEN, 0},
{ 0x8AB2, 0xAD07, WORD_LEN, 0},
{ 0x8AB4, 0xD804, WORD_LEN, 0},
{ 0x8AB6, 0xF09F, WORD_LEN, 0},
{ 0x8AB8, 0x1532, WORD_LEN, 0},
{ 0x8ABA, 0x1080, WORD_LEN, 0},
{ 0x8ABC, 0x1533, WORD_LEN, 0},
{ 0x8ABE, 0x1081, WORD_LEN, 0},
{ 0x8AC0, 0x1531, WORD_LEN, 0},
{ 0x8AC2, 0x1082, WORD_LEN, 0},
{ 0x8AC4, 0xB808, WORD_LEN, 0},
{ 0x8AC6, 0x7825, WORD_LEN, 0},
{ 0x8AC8, 0x1530, WORD_LEN, 0},
{ 0x8ACA, 0x1081, WORD_LEN, 0},
{ 0x8ACC, 0xB908, WORD_LEN, 0},
{ 0x8ACE, 0x7945, WORD_LEN, 0},
{ 0x8AD0, 0xD280, WORD_LEN, 0},
{ 0x8AD2, 0x092E, WORD_LEN, 0},
{ 0x8AD4, 0x0020, WORD_LEN, 0},
{ 0x8AD6, 0x8A41, WORD_LEN, 0},
{ 0x8AD8, 0x8D51, WORD_LEN, 0},
{ 0x8ADA, 0x8D32, WORD_LEN, 0},
{ 0x8ADC, 0x8DC6, WORD_LEN, 0},
{ 0x8ADE, 0x7942, WORD_LEN, 0},
{ 0x8AE0, 0x62DB, WORD_LEN, 0},
{ 0x8AE2, 0x091F, WORD_LEN, 0},
{ 0x8AE4, 0x03A2, WORD_LEN, 0},
{ 0x8AE6, 0x63BB, WORD_LEN, 0},
{ 0x8AE8, 0xE88B, WORD_LEN, 0},
{ 0x8AEA, 0x8D00, WORD_LEN, 0},
{ 0x8AEC, 0x8D21, WORD_LEN, 0},
{ 0x8AEE, 0xB808, WORD_LEN, 0},
{ 0x8AF0, 0x7825, WORD_LEN, 0},
{ 0x8AF2, 0xB885, WORD_LEN, 0},
{ 0x8AF4, 0x2841, WORD_LEN, 0},
{ 0x8AF6, 0x0201, WORD_LEN, 0},
{ 0x8AF8, 0xAD20, WORD_LEN, 0},
{ 0x8AFA, 0xAD01, WORD_LEN, 0},
{ 0x8AFC, 0xF1CF, WORD_LEN, 0},
{ 0x8AFE, 0xDF04, WORD_LEN, 0},
{ 0x8B00, 0x092B, WORD_LEN, 0},
{ 0x8B02, 0x03A3, WORD_LEN, 0},
{ 0x8B04, 0x1D4D, WORD_LEN, 0},
{ 0x8B06, 0x13C2, WORD_LEN, 0},
{ 0x8B08, 0x1530, WORD_LEN, 0},
{ 0x8B0A, 0x108E, WORD_LEN, 0},
{ 0x8B0C, 0x1531, WORD_LEN, 0},
{ 0x8B0E, 0x1081, WORD_LEN, 0},
{ 0x8B10, 0x1533, WORD_LEN, 0},
{ 0x8B12, 0x108F, WORD_LEN, 0},
{ 0x8B14, 0xBE08, WORD_LEN, 0},
{ 0x8B16, 0x7E25, WORD_LEN, 0},
{ 0x8B18, 0x1532, WORD_LEN, 0},
{ 0x8B1A, 0x1081, WORD_LEN, 0},
{ 0x8B1C, 0xB908, WORD_LEN, 0},
{ 0x8B1E, 0x79E5, WORD_LEN, 0},
{ 0x8B20, 0x0907, WORD_LEN, 0},
{ 0x8B22, 0x0382, WORD_LEN, 0},
{ 0x8B24, 0xE883, WORD_LEN, 0},
{ 0x8B26, 0x8B16, WORD_LEN, 0},
{ 0x8B28, 0xF002, WORD_LEN, 0},
{ 0x8B2A, 0x8B15, WORD_LEN, 0},
{ 0x8B2C, 0x8D22, WORD_LEN, 0},
{ 0x8B2E, 0xAD07, WORD_LEN, 0},
{ 0x8B30, 0x8D03, WORD_LEN, 0},
{ 0x8B32, 0xD367, WORD_LEN, 0},
{ 0x8B34, 0xB908, WORD_LEN, 0},
{ 0x8B36, 0x8DC1, WORD_LEN, 0},
{ 0x8B38, 0x7905, WORD_LEN, 0},
{ 0x8B3A, 0x8D00, WORD_LEN, 0},
{ 0x8B3C, 0xB808, WORD_LEN, 0},
{ 0x8B3E, 0x78C5, WORD_LEN, 0},
{ 0x8B40, 0x0921, WORD_LEN, 0},
{ 0x8B42, 0x011E, WORD_LEN, 0},
{ 0x8B44, 0xB883, WORD_LEN, 0},
{ 0x8B46, 0x2841, WORD_LEN, 0},
{ 0x8B48, 0x0201, WORD_LEN, 0},
{ 0x8B4A, 0xAD20, WORD_LEN, 0},
{ 0x8B4C, 0x8320, WORD_LEN, 0},
{ 0x8B4E, 0xAD01, WORD_LEN, 0},
{ 0x8B50, 0x8121, WORD_LEN, 0},
{ 0x8B52, 0x7960, WORD_LEN, 0},
{ 0x8B54, 0x2032, WORD_LEN, 0},
{ 0x8B56, 0x2080, WORD_LEN, 0},
{ 0x8B58, 0x8D06, WORD_LEN, 0},
{ 0x8B5A, 0xE001, WORD_LEN, 0},
{ 0x8B5C, 0xAD06, WORD_LEN, 0},
{ 0x8B5E, 0xF04D, WORD_LEN, 0},
{ 0x8B60, 0x8D00, WORD_LEN, 0},
{ 0x8B62, 0x8D21, WORD_LEN, 0},
{ 0x8B64, 0xB808, WORD_LEN, 0},
{ 0x8B66, 0x7825, WORD_LEN, 0},
{ 0x8B68, 0xB886, WORD_LEN, 0},
{ 0x8B6A, 0x2841, WORD_LEN, 0},
{ 0x8B6C, 0x0201, WORD_LEN, 0},
{ 0x8B6E, 0xAD20, WORD_LEN, 0},
{ 0x8B70, 0xAD01, WORD_LEN, 0},
{ 0x8B72, 0xD057, WORD_LEN, 0},
{ 0x8B74, 0x8000, WORD_LEN, 0},
{ 0x8B76, 0x8021, WORD_LEN, 0},
{ 0x8B78, 0x7960, WORD_LEN, 0},
{ 0x8B7A, 0x8D07, WORD_LEN, 0},
{ 0x8B7C, 0x1545, WORD_LEN, 0},
{ 0x8B7E, 0x1080, WORD_LEN, 0},
{ 0x8B80, 0x1546, WORD_LEN, 0},
{ 0x8B82, 0x1081, WORD_LEN, 0},
{ 0x8B84, 0xB808, WORD_LEN, 0},
{ 0x8B86, 0x7825, WORD_LEN, 0},
{ 0x8B88, 0x085D, WORD_LEN, 0},
{ 0x8B8A, 0x005E, WORD_LEN, 0},
{ 0x8B8C, 0x8D06, WORD_LEN, 0},
{ 0x8B8E, 0xE001, WORD_LEN, 0},
{ 0x8B90, 0xAD06, WORD_LEN, 0},
{ 0x8B92, 0xD805, WORD_LEN, 0},
{ 0x8B94, 0xF02F, WORD_LEN, 0},
{ 0x8B96, 0x1530, WORD_LEN, 0},
{ 0x8B98, 0x1082, WORD_LEN, 0},
{ 0x8B9A, 0x1531, WORD_LEN, 0},
{ 0x8B9C, 0x1080, WORD_LEN, 0},
{ 0x8B9E, 0xD14D, WORD_LEN, 0},
{ 0x8BA0, 0xBA08, WORD_LEN, 0},
{ 0x8BA2, 0x7A05, WORD_LEN, 0},
{ 0x8BA4, 0x8903, WORD_LEN, 0},
{ 0x8BA6, 0x080F, WORD_LEN, 0},
{ 0x8BA8, 0x0083, WORD_LEN, 0},
{ 0x8BAA, 0x8902, WORD_LEN, 0},
{ 0x8BAC, 0x8E44, WORD_LEN, 0},
{ 0x8BAE, 0x0839, WORD_LEN, 0},
{ 0x8BB0, 0x0082, WORD_LEN, 0},
{ 0x8BB2, 0x1545, WORD_LEN, 0},
{ 0x8BB4, 0x1082, WORD_LEN, 0},
{ 0x8BB6, 0x1546, WORD_LEN, 0},
{ 0x8BB8, 0x1080, WORD_LEN, 0},
{ 0x8BBA, 0xBA08, WORD_LEN, 0},
{ 0x8BBC, 0x7A05, WORD_LEN, 0},
{ 0x8BBE, 0x0A29, WORD_LEN, 0},
{ 0x8BC0, 0x005E, WORD_LEN, 0},
{ 0x8BC2, 0x8D00, WORD_LEN, 0},
{ 0x8BC4, 0x8D21, WORD_LEN, 0},
{ 0x8BC6, 0xB808, WORD_LEN, 0},
{ 0x8BC8, 0x7825, WORD_LEN, 0},
{ 0x8BCA, 0xB88D, WORD_LEN, 0},
{ 0x8BCC, 0x2841, WORD_LEN, 0},
{ 0x8BCE, 0x0201, WORD_LEN, 0},
{ 0x8BD0, 0xAD20, WORD_LEN, 0},
{ 0x8BD2, 0xAD01, WORD_LEN, 0},
{ 0x8BD4, 0x0A11, WORD_LEN, 0},
{ 0x8BD6, 0x009E, WORD_LEN, 0},
{ 0x8BD8, 0xD03D, WORD_LEN, 0},
{ 0x8BDA, 0x8000, WORD_LEN, 0},
{ 0x8BDC, 0x8021, WORD_LEN, 0},
{ 0x8BDE, 0x7960, WORD_LEN, 0},
{ 0x8BE0, 0x1550, WORD_LEN, 0},
{ 0x8BE2, 0x1080, WORD_LEN, 0},
{ 0x8BE4, 0xD800, WORD_LEN, 0},
{ 0x8BE6, 0x09AA, WORD_LEN, 0},
{ 0x8BE8, 0x0164, WORD_LEN, 0},
{ 0x8BEA, 0x1D4D, WORD_LEN, 0},
{ 0x8BEC, 0x1002, WORD_LEN, 0},
{ 0x8BEE, 0xF005, WORD_LEN, 0},
{ 0x8BF0, 0xD800, WORD_LEN, 0},
{ 0x8BF2, 0x1D4D, WORD_LEN, 0},
{ 0x8BF4, 0x1002, WORD_LEN, 0},
{ 0x8BF6, 0x06B1, WORD_LEN, 0},
{ 0x8BF8, 0x0684, WORD_LEN, 0},
{ 0x8BFA, 0x78E0, WORD_LEN, 0},
{ 0x8BFC, 0xC0F1, WORD_LEN, 0},
{ 0x8BFE, 0x0E4E, WORD_LEN, 0},
{ 0x8C00, 0x06A4, WORD_LEN, 0},
{ 0x8C02, 0x7308, WORD_LEN, 0},
{ 0x8C04, 0x0919, WORD_LEN, 0},
{ 0x8C06, 0x0023, WORD_LEN, 0},
{ 0x8C08, 0x721A, WORD_LEN, 0},
{ 0x8C0A, 0xD026, WORD_LEN, 0},
{ 0x8C0C, 0x1030, WORD_LEN, 0},
{ 0x8C0E, 0x0082, WORD_LEN, 0},
{ 0x8C10, 0x1031, WORD_LEN, 0},
{ 0x8C12, 0x0081, WORD_LEN, 0},
{ 0x8C14, 0xBA08, WORD_LEN, 0},
{ 0x8C16, 0x7A25, WORD_LEN, 0},
{ 0x8C18, 0xDD00, WORD_LEN, 0},
{ 0x8C1A, 0xF005, WORD_LEN, 0},
{ 0x8C1C, 0xDD01, WORD_LEN, 0},
{ 0x8C1E, 0x7268, WORD_LEN, 0},
{ 0x8C20, 0x7328, WORD_LEN, 0},
{ 0x8C22, 0x2302, WORD_LEN, 0},
{ 0x8C24, 0x0080, WORD_LEN, 0},
{ 0x8C26, 0x2885, WORD_LEN, 0},
{ 0x8C28, 0x0901, WORD_LEN, 0},
{ 0x8C2A, 0x702F, WORD_LEN, 0},
{ 0x8C2C, 0x0EFA, WORD_LEN, 0},
{ 0x8C2E, 0x06A4, WORD_LEN, 0},
{ 0x8C30, 0x7168, WORD_LEN, 0},
{ 0x8C32, 0xD31C, WORD_LEN, 0},
{ 0x8C34, 0x8BC6, WORD_LEN, 0},
{ 0x8C36, 0x8B31, WORD_LEN, 0},
{ 0x8C38, 0x780F, WORD_LEN, 0},
{ 0x8C3A, 0xD226, WORD_LEN, 0},
{ 0x8C3C, 0x663E, WORD_LEN, 0},
{ 0x8C3E, 0xD123, WORD_LEN, 0},
{ 0x8C40, 0xBE62, WORD_LEN, 0},
{ 0x8C42, 0x7ECF, WORD_LEN, 0},
{ 0x8C44, 0x89E4, WORD_LEN, 0},
{ 0x8C46, 0x2214, WORD_LEN, 0},
{ 0x8C48, 0x0381, WORD_LEN, 0},
{ 0x8C4A, 0xED07, WORD_LEN, 0},
{ 0x8C4C, 0x2840, WORD_LEN, 0},
{ 0x8C4E, 0x020E, WORD_LEN, 0},
{ 0x8C50, 0x7EE5, WORD_LEN, 0},
{ 0x8C52, 0xB1CC, WORD_LEN, 0},
{ 0x8C54, 0xF007, WORD_LEN, 0},
{ 0x8C56, 0x7E12, WORD_LEN, 0},
{ 0x8C58, 0xE601, WORD_LEN, 0},
{ 0x8C5A, 0x7ECF, WORD_LEN, 0},
{ 0x8C5C, 0xBE08, WORD_LEN, 0},
{ 0x8C5E, 0x7FC5, WORD_LEN, 0},
{ 0x8C60, 0xB1EC, WORD_LEN, 0},
{ 0x8C62, 0x080D, WORD_LEN, 0},
{ 0x8C64, 0x2003, WORD_LEN, 0},
{ 0x8C66, 0xED0D, WORD_LEN, 0},
{ 0x8C68, 0xD800, WORD_LEN, 0},
{ 0x8C6A, 0xF01A, WORD_LEN, 0},
{ 0x8C6C, 0x134D, WORD_LEN, 0},
{ 0x8C6E, 0x0080, WORD_LEN, 0},
{ 0x8C70, 0x080B, WORD_LEN, 0},
{ 0x8C72, 0x0190, WORD_LEN, 0},
{ 0x8C74, 0x8A0E, WORD_LEN, 0},
{ 0x8C76, 0x080B, WORD_LEN, 0},
{ 0x8C78, 0x0291, WORD_LEN, 0},
{ 0x8C7A, 0xD801, WORD_LEN, 0},
{ 0x8C7C, 0xF010, WORD_LEN, 0},
{ 0x8C7E, 0x1330, WORD_LEN, 0},
{ 0x8C80, 0x0081, WORD_LEN, 0},
{ 0x8C82, 0x1331, WORD_LEN, 0},
{ 0x8C84, 0x008D, WORD_LEN, 0},
{ 0x8C86, 0xD802, WORD_LEN, 0},
{ 0x8C88, 0xB908, WORD_LEN, 0},
{ 0x8C8A, 0x79A5, WORD_LEN, 0},
{ 0x8C8C, 0xB22A, WORD_LEN, 0},
{ 0x8C8E, 0x1332, WORD_LEN, 0},
{ 0x8C90, 0x0081, WORD_LEN, 0},
{ 0x8C92, 0x1333, WORD_LEN, 0},
{ 0x8C94, 0x008D, WORD_LEN, 0},
{ 0x8C96, 0xB908, WORD_LEN, 0},
{ 0x8C98, 0x79A5, WORD_LEN, 0},
{ 0x8C9A, 0xB22B, WORD_LEN, 0},
{ 0x8C9C, 0x0611, WORD_LEN, 0},
{ 0x8C9E, 0x0684, WORD_LEN, 0},
{ 0x8CA0, 0xFF80, WORD_LEN, 0},
{ 0x8CA2, 0x0290, WORD_LEN, 0},
{ 0x8CA4, 0x8000, WORD_LEN, 0},
{ 0x8CA6, 0x008C, WORD_LEN, 0},
{ 0x8CA8, 0x0000, WORD_LEN, 0},
{ 0x8CAA, 0xF3BC, WORD_LEN, 0},
{ 0x8CAC, 0xFF80, WORD_LEN, 0},
{ 0x8CAE, 0x1120, WORD_LEN, 0},
{ 0x8CB0, 0xFF80, WORD_LEN, 0},
{ 0x8CB2, 0x08EC, WORD_LEN, 0},
{ 0x8CB4, 0xFF80, WORD_LEN, 0},
{ 0x8CB6, 0x0954, WORD_LEN, 0},
{ 0x8CB8, 0xFF80, WORD_LEN, 0},
{ 0x8CBA, 0x0970, WORD_LEN, 0},
{ 0x8CBC, 0xFF80, WORD_LEN, 0},
{ 0x8CBE, 0x0CD4, WORD_LEN, 0},
{ 0x8CC0, 0xFF80, WORD_LEN, 0},
{ 0x8CC2, 0x06C8, WORD_LEN, 0},
{ 0x8CC4, 0xFF80, WORD_LEN, 0},
{ 0x8CC6, 0x050C, WORD_LEN, 0},
{ 0x8CC8, 0xFF80, WORD_LEN, 0},
{ 0x8CCA, 0x0158, WORD_LEN, 0},
{ 0x8CCC, 0x8000, WORD_LEN, 0},
{ 0x8CCE, 0x0008, WORD_LEN, 0},
{ 0x8CD0, 0xFF80, WORD_LEN, 0},
{ 0x8CD2, 0x10C8, WORD_LEN, 0},
{ 0x8CD4, 0xC0F1, WORD_LEN, 0},
{ 0x8CD6, 0x0D7E, WORD_LEN, 0},
{ 0x8CD8, 0x0684, WORD_LEN, 0},
{ 0x8CDA, 0x17C8, WORD_LEN, 0},
{ 0x8CDC, 0xF00D, WORD_LEN, 0},
{ 0x8CDE, 0x1545, WORD_LEN, 0},
{ 0x8CE0, 0x1080, WORD_LEN, 0},
{ 0x8CE2, 0x1546, WORD_LEN, 0},
{ 0x8CE4, 0x1081, WORD_LEN, 0},
{ 0x8CE6, 0xB808, WORD_LEN, 0},
{ 0x8CE8, 0x7825, WORD_LEN, 0},
{ 0x8CEA, 0xB8E0, WORD_LEN, 0},
{ 0x8CEC, 0xDE00, WORD_LEN, 0},
{ 0x8CEE, 0xF208, WORD_LEN, 0},
{ 0x8CF0, 0x8D00, WORD_LEN, 0},
{ 0x8CF2, 0x8D21, WORD_LEN, 0},
{ 0x8CF4, 0xB808, WORD_LEN, 0},
{ 0x8CF6, 0x7825, WORD_LEN, 0},
{ 0x8CF8, 0x2044, WORD_LEN, 0},
{ 0x8CFA, 0x020E, WORD_LEN, 0},
{ 0x8CFC, 0x8D00, WORD_LEN, 0},
{ 0x8CFE, 0x8D21, WORD_LEN, 0},
{ 0x8D00, 0xB808, WORD_LEN, 0},
{ 0x8D02, 0x7825, WORD_LEN, 0},
{ 0x8D04, 0x082F, WORD_LEN, 0},
{ 0x8D06, 0x00DE, WORD_LEN, 0},
{ 0x8D08, 0x7108, WORD_LEN, 0},
{ 0x8D0A, 0x2186, WORD_LEN, 0},
{ 0x8D0C, 0x0FFE, WORD_LEN, 0},
{ 0x8D0E, 0x262F, WORD_LEN, 0},
{ 0x8D10, 0xF04A, WORD_LEN, 0},
{ 0x8D12, 0xF211, WORD_LEN, 0},
{ 0x8D14, 0x17BC, WORD_LEN, 0},
{ 0x8D16, 0xF002, WORD_LEN, 0},
{ 0x8D18, 0x8A25, WORD_LEN, 0},
{ 0x8D1A, 0xE906, WORD_LEN, 0},
{ 0x8D1C, 0xB961, WORD_LEN, 0},
{ 0x8D1E, 0xAA25, WORD_LEN, 0},
{ 0x8D20, 0xD806, WORD_LEN, 0},
{ 0x8D22, 0xF01E, WORD_LEN, 0},
{ 0x8D24, 0x8A24, WORD_LEN, 0},
{ 0x8D26, 0xB8A3, WORD_LEN, 0},
{ 0x8D28, 0xAA25, WORD_LEN, 0},
{ 0x8D2A, 0x2841, WORD_LEN, 0},
{ 0x8D2C, 0x0201, WORD_LEN, 0},
{ 0x8D2E, 0xAD20, WORD_LEN, 0},
{ 0x8D30, 0xAD01, WORD_LEN, 0},
{ 0x8D32, 0x0D56, WORD_LEN, 0},
{ 0x8D34, 0x0144, WORD_LEN, 0},
{ 0x8D36, 0x1545, WORD_LEN, 0},
{ 0x8D38, 0x1081, WORD_LEN, 0},
{ 0x8D3A, 0x1546, WORD_LEN, 0},
{ 0x8D3C, 0x1082, WORD_LEN, 0},
{ 0x8D3E, 0xB908, WORD_LEN, 0},
{ 0x8D40, 0x7945, WORD_LEN, 0},
{ 0x8D42, 0xB9E0, WORD_LEN, 0},
{ 0x8D44, 0x26CC, WORD_LEN, 0},
{ 0x8D46, 0x9022, WORD_LEN, 0},
{ 0x8D48, 0xF20A, WORD_LEN, 0},
{ 0x8D4A, 0x8D20, WORD_LEN, 0},
{ 0x8D4C, 0x8D41, WORD_LEN, 0},
{ 0x8D4E, 0xB908, WORD_LEN, 0},
{ 0x8D50, 0x7945, WORD_LEN, 0},
{ 0x8D52, 0xB983, WORD_LEN, 0},
{ 0x8D54, 0x2941, WORD_LEN, 0},
{ 0x8D56, 0x0202, WORD_LEN, 0},
{ 0x8D58, 0xAD40, WORD_LEN, 0},
{ 0x8D5A, 0xAD21, WORD_LEN, 0},
{ 0x8D5C, 0x0561, WORD_LEN, 0},
{ 0x8D5E, 0x0684, WORD_LEN, 0},
{ 0x8D60, 0xC0F1, WORD_LEN, 0},
{ 0x8D62, 0x0CEE, WORD_LEN, 0},
{ 0x8D64, 0x06A4, WORD_LEN, 0},
{ 0x8D66, 0x7098, WORD_LEN, 0},
{ 0x8D68, 0xD284, WORD_LEN, 0},
{ 0x8D6A, 0x1206, WORD_LEN, 0},
{ 0x8D6C, 0x0086, WORD_LEN, 0},
{ 0x8D6E, 0x2240, WORD_LEN, 0},
{ 0x8D70, 0x0205, WORD_LEN, 0},
{ 0x8D72, 0x264C, WORD_LEN, 0},
{ 0x8D74, 0x8000, WORD_LEN, 0},
{ 0x8D76, 0x20CA, WORD_LEN, 0},
{ 0x8D78, 0x0101, WORD_LEN, 0},
{ 0x8D7A, 0xF237, WORD_LEN, 0},
{ 0x8D7C, 0x8AA7, WORD_LEN, 0},
{ 0x8D7E, 0x6D69, WORD_LEN, 0},
{ 0x8D80, 0x7B6D, WORD_LEN, 0},
{ 0x8D82, 0x0B3F, WORD_LEN, 0},
{ 0x8D84, 0x0012, WORD_LEN, 0},
{ 0x8D86, 0x7068, WORD_LEN, 0},
{ 0x8D88, 0x780D, WORD_LEN, 0},
{ 0x8D8A, 0x2040, WORD_LEN, 0},
{ 0x8D8C, 0x007C, WORD_LEN, 0},
{ 0x8D8E, 0x20A8, WORD_LEN, 0},
{ 0x8D90, 0x0640, WORD_LEN, 0},
{ 0x8D92, 0x71CF, WORD_LEN, 0},
{ 0x8D94, 0xFF80, WORD_LEN, 0},
{ 0x8D96, 0x0158, WORD_LEN, 0},
{ 0x8D98, 0x8924, WORD_LEN, 0},
{ 0x8D9A, 0x2532, WORD_LEN, 0},
{ 0x8D9C, 0x00C0, WORD_LEN, 0},
{ 0x8D9E, 0xBD61, WORD_LEN, 0},
{ 0x8DA0, 0x0819, WORD_LEN, 0},
{ 0x8DA2, 0x0063, WORD_LEN, 0},
{ 0x8DA4, 0x7DAF, WORD_LEN, 0},
{ 0x8DA6, 0x76CF, WORD_LEN, 0},
{ 0x8DA8, 0xFF80, WORD_LEN, 0},
{ 0x8DAA, 0x0290, WORD_LEN, 0},
{ 0x8DAC, 0x8EF1, WORD_LEN, 0},
{ 0x8DAE, 0x2640, WORD_LEN, 0},
{ 0x8DB0, 0x1601, WORD_LEN, 0},
{ 0x8DB2, 0x61E9, WORD_LEN, 0},
{ 0x8DB4, 0x090F, WORD_LEN, 0},
{ 0x8DB6, 0x0002, WORD_LEN, 0},
{ 0x8DB8, 0xAAA7, WORD_LEN, 0},
{ 0x8DBA, 0xBB61, WORD_LEN, 0},
{ 0x8DBC, 0x7B6D, WORD_LEN, 0},
{ 0x8DBE, 0x7088, WORD_LEN, 0},
{ 0x8DC0, 0xF005, WORD_LEN, 0},
{ 0x8DC2, 0x8E26, WORD_LEN, 0},
{ 0x8DC4, 0xAAA7, WORD_LEN, 0},
{ 0x8DC6, 0xB961, WORD_LEN, 0},
{ 0x8DC8, 0xAE26, WORD_LEN, 0},
{ 0x8DCA, 0x0B1F, WORD_LEN, 0},
{ 0x8DCC, 0x0013, WORD_LEN, 0},
{ 0x8DCE, 0x1A07, WORD_LEN, 0},
{ 0x8DD0, 0x0182, WORD_LEN, 0},
{ 0x8DD2, 0xD26B, WORD_LEN, 0},
{ 0x8DD4, 0x8A20, WORD_LEN, 0},
{ 0x8DD6, 0x8A61, WORD_LEN, 0},
{ 0x8DD8, 0xB908, WORD_LEN, 0},
{ 0x8DDA, 0x7965, WORD_LEN, 0},
{ 0x8DDC, 0xB9A3, WORD_LEN, 0},
{ 0x8DDE, 0x2941, WORD_LEN, 0},
{ 0x8DE0, 0x020C, WORD_LEN, 0},
{ 0x8DE2, 0xAA80, WORD_LEN, 0},
{ 0x8DE4, 0xAA21, WORD_LEN, 0},
{ 0x8DE6, 0x04D1, WORD_LEN, 0},
{ 0x8DE8, 0x0684, WORD_LEN, 0},
{ 0x8DEA, 0x78E0, WORD_LEN, 0},
{ 0x8DEC, 0xC0F1, WORD_LEN, 0},
{ 0x8DEE, 0xC5E1, WORD_LEN, 0},
{ 0x8DF0, 0xD363, WORD_LEN, 0},
{ 0x8DF2, 0x8B24, WORD_LEN, 0},
{ 0x8DF4, 0x8B45, WORD_LEN, 0},
{ 0x8DF6, 0xB908, WORD_LEN, 0},
{ 0x8DF8, 0x7945, WORD_LEN, 0},
{ 0x8DFA, 0xE188, WORD_LEN, 0},
{ 0x8DFC, 0x21CC, WORD_LEN, 0},
{ 0x8DFE, 0x8422, WORD_LEN, 0},
{ 0x8E00, 0xF41F, WORD_LEN, 0},
{ 0x8E02, 0x8B26, WORD_LEN, 0},
{ 0x8E04, 0x093B, WORD_LEN, 0},
{ 0x8E06, 0x0051, WORD_LEN, 0},
{ 0x8E08, 0xD15C, WORD_LEN, 0},
{ 0x8E0A, 0xD80A, WORD_LEN, 0},
{ 0x8E0C, 0xA90E, WORD_LEN, 0},
{ 0x8E0E, 0xD05D, WORD_LEN, 0},
{ 0x8E10, 0x8804, WORD_LEN, 0},
{ 0x8E12, 0x1330, WORD_LEN, 0},
{ 0x8E14, 0x0082, WORD_LEN, 0},
{ 0x8E16, 0x1331, WORD_LEN, 0},
{ 0x8E18, 0x008D, WORD_LEN, 0},
{ 0x8E1A, 0xBA08, WORD_LEN, 0},
{ 0x8E1C, 0x7AA5, WORD_LEN, 0},
{ 0x8E1E, 0xB148, WORD_LEN, 0},
{ 0x8E20, 0x8952, WORD_LEN, 0},
{ 0x8E22, 0xA90F, WORD_LEN, 0},
{ 0x8E24, 0x0813, WORD_LEN, 0},
{ 0x8E26, 0x00A2, WORD_LEN, 0},
{ 0x8E28, 0x132C, WORD_LEN, 0},
{ 0x8E2A, 0x0083, WORD_LEN, 0},
{ 0x8E2C, 0xDA00, WORD_LEN, 0},
{ 0x8E2E, 0xA953, WORD_LEN, 0},
{ 0x8E30, 0x7862, WORD_LEN, 0},
{ 0x8E32, 0x780F, WORD_LEN, 0},
{ 0x8E34, 0xF005, WORD_LEN, 0},
{ 0x8E36, 0xDA01, WORD_LEN, 0},
{ 0x8E38, 0xA953, WORD_LEN, 0},
{ 0x8E3A, 0x6078, WORD_LEN, 0},
{ 0x8E3C, 0x780F, WORD_LEN, 0},
{ 0x8E3E, 0x080E, WORD_LEN, 0},
{ 0x8E40, 0x0000, WORD_LEN, 0},
{ 0x8E42, 0x0485, WORD_LEN, 0},
{ 0x8E44, 0x0684, WORD_LEN, 0},
{ 0x8E46, 0x78E0, WORD_LEN, 0},
{ 0x8E48, 0xC0F1, WORD_LEN, 0},
{ 0x8E4A, 0x0BFE, WORD_LEN, 0},
{ 0x8E4C, 0x0684, WORD_LEN, 0},
{ 0x8E4E, 0xD64D, WORD_LEN, 0},
{ 0x8E50, 0x7508, WORD_LEN, 0},
{ 0x8E52, 0x8E01, WORD_LEN, 0},
{ 0x8E54, 0xD14A, WORD_LEN, 0},
{ 0x8E56, 0x2046, WORD_LEN, 0},
{ 0x8E58, 0x00C0, WORD_LEN, 0},
{ 0x8E5A, 0xAE01, WORD_LEN, 0},
{ 0x8E5C, 0x1145, WORD_LEN, 0},
{ 0x8E5E, 0x0080, WORD_LEN, 0},
{ 0x8E60, 0x1146, WORD_LEN, 0},
{ 0x8E62, 0x0082, WORD_LEN, 0},
{ 0x8E64, 0xB808, WORD_LEN, 0},
{ 0x8E66, 0x7845, WORD_LEN, 0},
{ 0x8E68, 0x0817, WORD_LEN, 0},
{ 0x8E6A, 0x001E, WORD_LEN, 0},
{ 0x8E6C, 0x8900, WORD_LEN, 0},
{ 0x8E6E, 0x8941, WORD_LEN, 0},
{ 0x8E70, 0xB808, WORD_LEN, 0},
{ 0x8E72, 0x7845, WORD_LEN, 0},
{ 0x8E74, 0x080B, WORD_LEN, 0},
{ 0x8E76, 0x00DE, WORD_LEN, 0},
{ 0x8E78, 0x70A9, WORD_LEN, 0},
{ 0x8E7A, 0xFFBA, WORD_LEN, 0},
{ 0x8E7C, 0x7508, WORD_LEN, 0},
{ 0x8E7E, 0x1604, WORD_LEN, 0},
{ 0x8E80, 0x1090, WORD_LEN, 0},
{ 0x8E82, 0x0D93, WORD_LEN, 0},
{ 0x8E84, 0x1400, WORD_LEN, 0},
{ 0x8E86, 0x8EEA, WORD_LEN, 0},
{ 0x8E88, 0x8E0B, WORD_LEN, 0},
{ 0x8E8A, 0x214A, WORD_LEN, 0},
{ 0x8E8C, 0x2040, WORD_LEN, 0},
{ 0x8E8E, 0x8E2D, WORD_LEN, 0},
{ 0x8E90, 0xBF08, WORD_LEN, 0},
{ 0x8E92, 0x7F05, WORD_LEN, 0},
{ 0x8E94, 0x8E0C, WORD_LEN, 0},
{ 0x8E96, 0xB808, WORD_LEN, 0},
{ 0x8E98, 0x7825, WORD_LEN, 0},
{ 0x8E9A, 0x7710, WORD_LEN, 0},
{ 0x8E9C, 0x21C2, WORD_LEN, 0},
{ 0x8E9E, 0x244C, WORD_LEN, 0},
{ 0x8EA0, 0x081D, WORD_LEN, 0},
{ 0x8EA2, 0x03E3, WORD_LEN, 0},
{ 0x8EA4, 0xD9FF, WORD_LEN, 0},
{ 0x8EA6, 0x2702, WORD_LEN, 0},
{ 0x8EA8, 0x1002, WORD_LEN, 0},
{ 0x8EAA, 0x2A05, WORD_LEN, 0},
{ 0x8EAC, 0x037E, WORD_LEN, 0},
{ 0x8EAE, 0x0C7A, WORD_LEN, 0},
{ 0x8EB0, 0x06A4, WORD_LEN, 0},
{ 0x8EB2, 0x702F, WORD_LEN, 0},
{ 0x8EB4, 0x7810, WORD_LEN, 0},
{ 0x8EB6, 0x7F02, WORD_LEN, 0},
{ 0x8EB8, 0x7FF0, WORD_LEN, 0},
{ 0x8EBA, 0xF00B, WORD_LEN, 0},
{ 0x8EBC, 0x78E2, WORD_LEN, 0},
{ 0x8EBE, 0x2805, WORD_LEN, 0},
{ 0x8EC0, 0x037E, WORD_LEN, 0},
{ 0x8EC2, 0x0C66, WORD_LEN, 0},
{ 0x8EC4, 0x06A4, WORD_LEN, 0},
{ 0x8EC6, 0x702F, WORD_LEN, 0},
{ 0x8EC8, 0x7810, WORD_LEN, 0},
{ 0x8ECA, 0x671F, WORD_LEN, 0},
{ 0x8ECC, 0x7FF0, WORD_LEN, 0},
{ 0x8ECE, 0x7FEF, WORD_LEN, 0},
{ 0x8ED0, 0x8E08, WORD_LEN, 0},
{ 0x8ED2, 0xBF06, WORD_LEN, 0},
{ 0x8ED4, 0xD12C, WORD_LEN, 0},
{ 0x8ED6, 0xB8C3, WORD_LEN, 0},
{ 0x8ED8, 0x78E5, WORD_LEN, 0},
{ 0x8EDA, 0xB88F, WORD_LEN, 0},
{ 0x8EDC, 0x1908, WORD_LEN, 0},
{ 0x8EDE, 0x0024, WORD_LEN, 0},
{ 0x8EE0, 0x2841, WORD_LEN, 0},
{ 0x8EE2, 0x0201, WORD_LEN, 0},
{ 0x8EE4, 0x1E26, WORD_LEN, 0},
{ 0x8EE6, 0x1042, WORD_LEN, 0},
{ 0x8EE8, 0x0D15, WORD_LEN, 0},
{ 0x8EEA, 0x1423, WORD_LEN, 0},
{ 0x8EEC, 0x1E27, WORD_LEN, 0},
{ 0x8EEE, 0x1002, WORD_LEN, 0},
{ 0x8EF0, 0x214C, WORD_LEN, 0},
{ 0x8EF2, 0xA000, WORD_LEN, 0},
{ 0x8EF4, 0x214A, WORD_LEN, 0},
{ 0x8EF6, 0x2040, WORD_LEN, 0},
{ 0x8EF8, 0x21C2, WORD_LEN, 0},
{ 0x8EFA, 0x2442, WORD_LEN, 0},
{ 0x8EFC, 0x8E21, WORD_LEN, 0},
{ 0x8EFE, 0x214F, WORD_LEN, 0},
{ 0x8F00, 0x0040, WORD_LEN, 0},
{ 0x8F02, 0x090F, WORD_LEN, 0},
{ 0x8F04, 0x2010, WORD_LEN, 0},
{ 0x8F06, 0x2145, WORD_LEN, 0},
{ 0x8F08, 0x0181, WORD_LEN, 0},
{ 0x8F0A, 0xAE21, WORD_LEN, 0},
{ 0x8F0C, 0xF003, WORD_LEN, 0},
{ 0x8F0E, 0xB8A2, WORD_LEN, 0},
{ 0x8F10, 0xAE01, WORD_LEN, 0},
{ 0x8F12, 0x0FFE, WORD_LEN, 0},
{ 0x8F14, 0xFFA3, WORD_LEN, 0},
{ 0x8F16, 0x70A9, WORD_LEN, 0},
{ 0x8F18, 0x038D, WORD_LEN, 0},
{ 0x8F1A, 0x0684, WORD_LEN, 0},
{ 0x8F1C, 0xC0F1, WORD_LEN, 0},
{ 0x8F1E, 0xC5E1, WORD_LEN, 0},
{ 0x8F20, 0xD518, WORD_LEN, 0},
{ 0x8F22, 0x8D00, WORD_LEN, 0},
{ 0x8F24, 0xB8E7, WORD_LEN, 0},
{ 0x8F26, 0x20D1, WORD_LEN, 0},
{ 0x8F28, 0x80E2, WORD_LEN, 0},
{ 0x8F2A, 0xF20D, WORD_LEN, 0},
{ 0x8F2C, 0xD117, WORD_LEN, 0},
{ 0x8F2E, 0xB8A7, WORD_LEN, 0},
{ 0x8F30, 0xAD00, WORD_LEN, 0},
{ 0x8F32, 0xD017, WORD_LEN, 0},
{ 0x8F34, 0x7228, WORD_LEN, 0},
{ 0x8F36, 0x8123, WORD_LEN, 0},
{ 0x8F38, 0xA040, WORD_LEN, 0},
{ 0x8F3A, 0x7960, WORD_LEN, 0},
{ 0x8F3C, 0xD801, WORD_LEN, 0},
{ 0x8F3E, 0xD800, WORD_LEN, 0},
{ 0x8F40, 0xAD05, WORD_LEN, 0},
{ 0x8F42, 0x0F56, WORD_LEN, 0},
{ 0x8F44, 0xFF83, WORD_LEN, 0},
{ 0x8F46, 0x0381, WORD_LEN, 0},
{ 0x8F48, 0x0684, WORD_LEN, 0},
{ 0x8F4A, 0x78E0, WORD_LEN, 0},
{ 0x8F4C, 0xD20D, WORD_LEN, 0},
{ 0x8F4E, 0x8A21, WORD_LEN, 0},
{ 0x8F50, 0xB9A1, WORD_LEN, 0},
{ 0x8F52, 0x782F, WORD_LEN, 0},
{ 0x8F54, 0x7FE0, WORD_LEN, 0},
{ 0x8F56, 0xAA21, WORD_LEN, 0},
{ 0x8F58, 0xD00E, WORD_LEN, 0},
{ 0x8F5A, 0xD10C, WORD_LEN, 0},
{ 0x8F5C, 0xA100, WORD_LEN, 0},
{ 0x8F5E, 0xD00E, WORD_LEN, 0},
{ 0x8F60, 0xA101, WORD_LEN, 0},
{ 0x8F62, 0xD00E, WORD_LEN, 0},
{ 0x8F64, 0xA102, WORD_LEN, 0},
{ 0x8F66, 0xD00E, WORD_LEN, 0},
{ 0x8F68, 0xA103, WORD_LEN, 0},
{ 0x8F6A, 0xD009, WORD_LEN, 0},
{ 0x8F6C, 0xA020, WORD_LEN, 0},
{ 0x8F6E, 0xD005, WORD_LEN, 0},
{ 0x8F70, 0xD988, WORD_LEN, 0},
{ 0x8F72, 0xA820, WORD_LEN, 0},
{ 0x8F74, 0xF1D4, WORD_LEN, 0},
{ 0x8F76, 0x78E0, WORD_LEN, 0},
{ 0x8F78, 0xFF80, WORD_LEN, 0},
{ 0x8F7A, 0x10C8, WORD_LEN, 0},
{ 0x8F7C, 0xFF80, WORD_LEN, 0},
{ 0x8F7E, 0x0290, WORD_LEN, 0},
{ 0x8F80, 0xFF80, WORD_LEN, 0},
{ 0x8F82, 0x0158, WORD_LEN, 0},
{ 0x8F84, 0xFF00, WORD_LEN, 0},
{ 0x8F86, 0x0618, WORD_LEN, 0},
{ 0x8F88, 0xFF80, WORD_LEN, 0},
{ 0x8F8A, 0x1158, WORD_LEN, 0},
{ 0x8F8C, 0x8000, WORD_LEN, 0},
{ 0x8F8E, 0x0008, WORD_LEN, 0},
{ 0x8F90, 0xFF80, WORD_LEN, 0},
{ 0x8F92, 0x0F1C, WORD_LEN, 0},
{ 0x8F94, 0xFF80, WORD_LEN, 0},
{ 0x8F96, 0x0DEC, WORD_LEN, 0},
{ 0x8F98, 0xFF80, WORD_LEN, 0},
{ 0x8F9A, 0x0F4C, WORD_LEN, 0},
{ 0x8F9C, 0x0000, WORD_LEN, 0},
{ 0x8F9E, 0x0998, WORD_LEN, 0},
{ 0x8FA0, 0xC0F1, WORD_LEN, 0},
{ 0x8FA2, 0xC5E1, WORD_LEN, 0},
{ 0x8FA4, 0xD02C, WORD_LEN, 0},
{ 0x8FA6, 0x0982, WORD_LEN, 0},
{ 0x8FA8, 0x0664, WORD_LEN, 0},
{ 0x8FAA, 0x88AE, WORD_LEN, 0},
{ 0x8FAC, 0x0D23, WORD_LEN, 0},
{ 0x8FAE, 0x1051, WORD_LEN, 0},
{ 0x8FB0, 0xD12A, WORD_LEN, 0},
{ 0x8FB2, 0x1145, WORD_LEN, 0},
{ 0x8FB4, 0x0080, WORD_LEN, 0},
{ 0x8FB6, 0x1146, WORD_LEN, 0},
{ 0x8FB8, 0x0082, WORD_LEN, 0},
{ 0x8FBA, 0xB808, WORD_LEN, 0},
{ 0x8FBC, 0x7845, WORD_LEN, 0},
{ 0x8FBE, 0x0813, WORD_LEN, 0},
{ 0x8FC0, 0x00DE, WORD_LEN, 0},
{ 0x8FC2, 0xD027, WORD_LEN, 0},
{ 0x8FC4, 0x8000, WORD_LEN, 0},
{ 0x8FC6, 0x8041, WORD_LEN, 0},
{ 0x8FC8, 0x7A60, WORD_LEN, 0},
{ 0x8FCA, 0x1150, WORD_LEN, 0},
{ 0x8FCC, 0x0080, WORD_LEN, 0},
{ 0x8FCE, 0x02F9, WORD_LEN, 0},
{ 0x8FD0, 0x0684, WORD_LEN, 0},
{ 0x8FD2, 0x78E0, WORD_LEN, 0},
{ 0x8FD4, 0xC0F1, WORD_LEN, 0},
{ 0x8FD6, 0x0A7E, WORD_LEN, 0},
{ 0x8FD8, 0x0684, WORD_LEN, 0},
{ 0x8FDA, 0xD622, WORD_LEN, 0},
{ 0x8FDC, 0x8EA9, WORD_LEN, 0},
{ 0x8FDE, 0x8E2A, WORD_LEN, 0},
{ 0x8FE0, 0xBD08, WORD_LEN, 0},
{ 0x8FE2, 0x7D25, WORD_LEN, 0},
{ 0x8FE4, 0x2550, WORD_LEN, 0},
{ 0x8FE6, 0x10C2, WORD_LEN, 0},
{ 0x8FE8, 0x2A41, WORD_LEN, 0},
{ 0x8FEA, 0x0201, WORD_LEN, 0},
{ 0x8FEC, 0xAE29, WORD_LEN, 0},
{ 0x8FEE, 0x0F9A, WORD_LEN, 0},
{ 0x8FF0, 0x05A4, WORD_LEN, 0},
{ 0x8FF2, 0xAE4A, WORD_LEN, 0},
{ 0x8FF4, 0x0D17, WORD_LEN, 0},
{ 0x8FF6, 0x10DE, WORD_LEN, 0},
{ 0x8FF8, 0x8E09, WORD_LEN, 0},
{ 0x8FFA, 0x8E2A, WORD_LEN, 0},
{ 0x8FFC, 0xB808, WORD_LEN, 0},
{ 0x8FFE, 0x7825, WORD_LEN, 0},
{ 0x9000, 0xB883, WORD_LEN, 0},
{ 0x9002, 0x2841, WORD_LEN, 0},
{ 0x9004, 0x0201, WORD_LEN, 0},
{ 0x9006, 0xAE29, WORD_LEN, 0},
{ 0x9008, 0xAE0A, WORD_LEN, 0},
{ 0x900A, 0x02B5, WORD_LEN, 0},
{ 0x900C, 0x0684, WORD_LEN, 0},
{ 0x900E, 0x78E0, WORD_LEN, 0},
{ 0x9010, 0xC0F1, WORD_LEN, 0},
{ 0x9012, 0x0A42, WORD_LEN, 0},
{ 0x9014, 0x06A4, WORD_LEN, 0},
{ 0x9016, 0xDA34, WORD_LEN, 0},
{ 0x9018, 0xD113, WORD_LEN, 0},
{ 0x901A, 0xD514, WORD_LEN, 0},
{ 0x901C, 0x76A9, WORD_LEN, 0},
{ 0x901E, 0x0FD6, WORD_LEN, 0},
{ 0x9020, 0x0664, WORD_LEN, 0},
{ 0x9022, 0x70C9, WORD_LEN, 0},
{ 0x9024, 0xD012, WORD_LEN, 0},
{ 0x9026, 0xA504, WORD_LEN, 0},
{ 0x9028, 0xD012, WORD_LEN, 0},
{ 0x902A, 0x0295, WORD_LEN, 0},
{ 0x902C, 0x06A4, WORD_LEN, 0},
{ 0x902E, 0xA0C0, WORD_LEN, 0},
{ 0x9030, 0xC0F1, WORD_LEN, 0},
{ 0x9032, 0xC5E1, WORD_LEN, 0},
{ 0x9034, 0xD50D, WORD_LEN, 0},
{ 0x9036, 0xD110, WORD_LEN, 0},
{ 0x9038, 0x2540, WORD_LEN, 0},
{ 0x903A, 0x1D00, WORD_LEN, 0},
{ 0x903C, 0x0FB6, WORD_LEN, 0},
{ 0x903E, 0x0664, WORD_LEN, 0},
{ 0x9040, 0xDA50, WORD_LEN, 0},
{ 0x9042, 0xD00E, WORD_LEN, 0},
{ 0x9044, 0x2540, WORD_LEN, 0},
{ 0x9046, 0x1D01, WORD_LEN, 0},
{ 0x9048, 0xA517, WORD_LEN, 0},
{ 0x904A, 0xD00D, WORD_LEN, 0},
{ 0x904C, 0x0279, WORD_LEN, 0},
{ 0x904E, 0x06A4, WORD_LEN, 0},
{ 0x9050, 0xA020, WORD_LEN, 0},
{ 0x9052, 0x78E0, WORD_LEN, 0},
{ 0x9054, 0xFF80, WORD_LEN, 0},
{ 0x9056, 0x07A8, WORD_LEN, 0},
{ 0x9058, 0xFF80, WORD_LEN, 0},
{ 0x905A, 0x0290, WORD_LEN, 0},
{ 0x905C, 0x8000, WORD_LEN, 0},
{ 0x905E, 0x0008, WORD_LEN, 0},
{ 0x9060, 0xFF80, WORD_LEN, 0},
{ 0x9062, 0x02CC, WORD_LEN, 0},
{ 0x9064, 0x0000, WORD_LEN, 0},
{ 0x9066, 0xFA88, WORD_LEN, 0},
{ 0x9068, 0xFF80, WORD_LEN, 0},
{ 0x906A, 0x1168, WORD_LEN, 0},
{ 0x906C, 0xFF80, WORD_LEN, 0},
{ 0x906E, 0x0FD4, WORD_LEN, 0},
{ 0x9070, 0x8000, WORD_LEN, 0},
{ 0x9072, 0x0194, WORD_LEN, 0},
{ 0x9074, 0x0000, WORD_LEN, 0},
{ 0x9076, 0xFB08, WORD_LEN, 0},
{ 0x9078, 0xFF80, WORD_LEN, 0},
{ 0x907A, 0x0FA0, WORD_LEN, 0},
{ 0x907C, 0x8000, WORD_LEN, 0},
{ 0x907E, 0x01A0, WORD_LEN, 0},
{ 0x9080, 0xE280, WORD_LEN, 0},
{ 0x9082, 0x24CA, WORD_LEN, 0},
{ 0x9084, 0x7082, WORD_LEN, 0},
{ 0x9086, 0x78E0, WORD_LEN, 0},
{ 0x9088, 0x20E8, WORD_LEN, 0},
{ 0x908A, 0x01A2, WORD_LEN, 0},
{ 0x908C, 0x1002, WORD_LEN, 0},
{ 0x908E, 0x0D02, WORD_LEN, 0},
{ 0x9090, 0x1902, WORD_LEN, 0},
{ 0x9092, 0x0094, WORD_LEN, 0},
{ 0x9094, 0x7FE0, WORD_LEN, 0},
{ 0x9096, 0x7028, WORD_LEN, 0},
{ 0x9098, 0x7308, WORD_LEN, 0},
{ 0x909A, 0x1000, WORD_LEN, 0},
{ 0x909C, 0x0900, WORD_LEN, 0},
{ 0x909E, 0x7904, WORD_LEN, 0},
{ 0x90A0, 0x7947, WORD_LEN, 0},
{ 0x90A2, 0x1B00, WORD_LEN, 0},
{ 0x90A4, 0x0064, WORD_LEN, 0},
{ 0x90A6, 0x7EE0, WORD_LEN, 0},
{ 0x90A8, 0xE280, WORD_LEN, 0},
{ 0x90AA, 0x24CA, WORD_LEN, 0},
{ 0x90AC, 0x7082, WORD_LEN, 0},
{ 0x90AE, 0x78E0, WORD_LEN, 0},
{ 0x90B0, 0x20E8, WORD_LEN, 0},
{ 0x90B2, 0x01A2, WORD_LEN, 0},
{ 0x90B4, 0x1102, WORD_LEN, 0},
{ 0x90B6, 0x0502, WORD_LEN, 0},
{ 0x90B8, 0x1802, WORD_LEN, 0},
{ 0x90BA, 0x00B4, WORD_LEN, 0},
{ 0x90BC, 0x7FE0, WORD_LEN, 0},
{ 0x90BE, 0x7028, WORD_LEN, 0},
{ 0x90C0, 0x0000, WORD_LEN, 0},
{ 0x90C2, 0x0000, WORD_LEN, 0},
{ 0x90C4, 0x0000, WORD_LEN, 0},
{ 0x90C6, 0x0000, WORD_LEN, 0},
{ 0x098E, 0x0000, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS
{ 0x8016, 0x086C, WORD_LEN, 0}, 	// MON_ADDRESS_LO
{ 0x8018, 0xFF80, WORD_LEN, 0}, 	// MON_ADDRESS_HI
{ 0x8002, 0x0001, WORD_LEN, 0}, 	// MON_CMD
//delay = 100
{ SEQUENCE_WAIT_MS,100, BYTE_LEN, 0},

//[Lens Correction 90% 02/04/13 18:03:18]                           
//BITFIELD= 0x3210, 0x0008, 0 //PGA_ENABLE                          
{ 0x3210, 0x0008, WORD_LEN, 0},                                   
{ 0x3210, 0x49B0, WORD_LEN, 0},  	// COLOR_PIPELINE_CONTROL         
{ 0x3640, 0x0170, WORD_LEN, 0},  	// P_G1_P0Q0                      
{ 0x3642, 0x0BCC, WORD_LEN, 0},  	// P_G1_P0Q1                      
{ 0x3644, 0x7210, WORD_LEN, 0},  	// P_G1_P0Q2                      
{ 0x3646, 0x4C8D, WORD_LEN, 0},  	// P_G1_P0Q3                      
{ 0x3648, 0xF58D, WORD_LEN, 0},  	// P_G1_P0Q4                      
{ 0x364A, 0x0610, WORD_LEN, 0},  	// P_R_P0Q0                       
{ 0x364C, 0x8D6E, WORD_LEN, 0},  	// P_R_P0Q1                       
{ 0x364E, 0x6E90, WORD_LEN, 0},  	// P_R_P0Q2                       
{ 0x3650, 0x088F, WORD_LEN, 0},  	// P_R_P0Q3                       
{ 0x3652, 0xA890, WORD_LEN, 0},  	// P_R_P0Q4                       
{ 0x3654, 0x0550, WORD_LEN, 0},  	// P_B_P0Q0                       
{ 0x3656, 0x764C, WORD_LEN, 0},  	// P_B_P0Q1                       
{ 0x3658, 0x0FB0, WORD_LEN, 0},  	// P_B_P0Q2                       
{ 0x365A, 0x9A0D, WORD_LEN, 0},  	// P_B_P0Q3                       
{ 0x365C, 0xF4AD, WORD_LEN, 0},  	// P_B_P0Q4                       
{ 0x365E, 0x02F0, WORD_LEN, 0},  	// P_G2_P0Q0                      
{ 0x3660, 0x9A0E, WORD_LEN, 0},  	// P_G2_P0Q1                      
{ 0x3662, 0x77B0, WORD_LEN, 0},  	// P_G2_P0Q2                      
{ 0x3664, 0x416D, WORD_LEN, 0},  	// P_G2_P0Q3                      
{ 0x3666, 0xF24D, WORD_LEN, 0},  	// P_G2_P0Q4                      
{ 0x3680, 0x018A, WORD_LEN, 0},  	// P_G1_P1Q0                      
{ 0x3682, 0xD0AD, WORD_LEN, 0},  	// P_G1_P1Q1                      
{ 0x3684, 0xC62E, WORD_LEN, 0},  	// P_G1_P1Q2                      
{ 0x3686, 0x736D, WORD_LEN, 0},  	// P_G1_P1Q3                      
{ 0x3688, 0x0130, WORD_LEN, 0},  	// P_G1_P1Q4                      
{ 0x368A, 0x52ED, WORD_LEN, 0},  	// P_R_P1Q0                       
{ 0x368C, 0x682D, WORD_LEN, 0},  	// P_R_P1Q1                       
{ 0x368E, 0xF02B, WORD_LEN, 0},  	// P_R_P1Q2                       
{ 0x3690, 0xB68E, WORD_LEN, 0},  	// P_R_P1Q3                       
{ 0x3692, 0xF4AD, WORD_LEN, 0},  	// P_R_P1Q4                       
{ 0x3694, 0xC68D, WORD_LEN, 0},  	// P_B_P1Q0                       
{ 0x3696, 0x440D, WORD_LEN, 0},  	// P_B_P1Q1                       
{ 0x3698, 0x416E, WORD_LEN, 0},  	// P_B_P1Q2                       
{ 0x369A, 0xC0CE, WORD_LEN, 0},  	// P_B_P1Q3                       
{ 0x369C, 0xB46D, WORD_LEN, 0},  	// P_B_P1Q4                       
{ 0x369E, 0xD90A, WORD_LEN, 0},  	// P_G2_P1Q0                      
{ 0x36A0, 0xD76D, WORD_LEN, 0},  	// P_G2_P1Q1                      
{ 0x36A2, 0xFE0D, WORD_LEN, 0},  	// P_G2_P1Q2                      
{ 0x36A4, 0x0E0D, WORD_LEN, 0},  	// P_G2_P1Q3                      
{ 0x36A6, 0x0890, WORD_LEN, 0},  	// P_G2_P1Q4                      
{ 0x36C0, 0x70D0, WORD_LEN, 0},  	// P_G1_P2Q0                      
{ 0x36C2, 0x10CF, WORD_LEN, 0},  	// P_G1_P2Q1                      
{ 0x36C4, 0x4592, WORD_LEN, 0},  	// P_G1_P2Q2                      
{ 0x36C6, 0xB74D, WORD_LEN, 0},  	// P_G1_P2Q3                      
{ 0x36C8, 0xEEB3, WORD_LEN, 0},  	// P_G1_P2Q4                      
{ 0x36CA, 0x1991, WORD_LEN, 0},  	// P_R_P2Q0                       
{ 0x36CC, 0x9B8E, WORD_LEN, 0},  	// P_R_P2Q1                       
{ 0x36CE, 0x5DCD, WORD_LEN, 0},  	// P_R_P2Q2                       
{ 0x36D0, 0x1C8D, WORD_LEN, 0},  	// P_R_P2Q3                       
{ 0x36D2, 0x8C71, WORD_LEN, 0},  	// P_R_P2Q4                       
{ 0x36D4, 0x00F1, WORD_LEN, 0},  	// P_B_P2Q0                       
{ 0x36D6, 0x480F, WORD_LEN, 0},  	// P_B_P2Q1                       
{ 0x36D8, 0x26AF, WORD_LEN, 0},  	// P_B_P2Q2                       
{ 0x36DA, 0xC2EF, WORD_LEN, 0},  	// P_B_P2Q3                       
{ 0x36DC, 0xFC8F, WORD_LEN, 0},  	// P_B_P2Q4                       
{ 0x36DE, 0x0071, WORD_LEN, 0},  	// P_G2_P2Q0                      
{ 0x36E0, 0x8230, WORD_LEN, 0},  	// P_G2_P2Q1                      
{ 0x36E2, 0x60B2, WORD_LEN, 0},  	// P_G2_P2Q2                      
{ 0x36E4, 0x3E51, WORD_LEN, 0},  	// P_G2_P2Q3                      
{ 0x36E6, 0x8C74, WORD_LEN, 0},  	// P_G2_P2Q4                      
{ 0x3700, 0x492E, WORD_LEN, 0},  	// P_G1_P3Q0                      
{ 0x3702, 0x7FAD, WORD_LEN, 0},  	// P_G1_P3Q1                      
{ 0x3704, 0x93CE, WORD_LEN, 0},  	// P_G1_P3Q2                      
{ 0x3706, 0xC86F, WORD_LEN, 0},  	// P_G1_P3Q3                      
{ 0x3708, 0xC830, WORD_LEN, 0},  	// P_G1_P3Q4                      
{ 0x370A, 0x610E, WORD_LEN, 0},  	// P_R_P3Q0                       
{ 0x370C, 0x8EC8, WORD_LEN, 0},  	// P_R_P3Q1                       
{ 0x370E, 0xA930, WORD_LEN, 0},  	// P_R_P3Q2                       
{ 0x3710, 0xE88D, WORD_LEN, 0},  	// P_R_P3Q3                       
{ 0x3712, 0x2B51, WORD_LEN, 0},  	// P_R_P3Q4                       
{ 0x3714, 0xDECD, WORD_LEN, 0},  	// P_B_P3Q0                       
{ 0x3716, 0xBD8E, WORD_LEN, 0},  	// P_B_P3Q1                       
{ 0x3718, 0x2E50, WORD_LEN, 0},  	// P_B_P3Q2                       
{ 0x371A, 0x60AF, WORD_LEN, 0},  	// P_B_P3Q3                       
{ 0x371C, 0xBB11, WORD_LEN, 0},  	// P_B_P3Q4                       
{ 0x371E, 0x22CB, WORD_LEN, 0},  	// P_G2_P3Q0                      
{ 0x3720, 0xEEEC, WORD_LEN, 0},  	// P_G2_P3Q1                      
{ 0x3722, 0x0251, WORD_LEN, 0},  	// P_G2_P3Q2                      
{ 0x3724, 0x142D, WORD_LEN, 0},  	// P_G2_P3Q3                      
{ 0x3726, 0xE271, WORD_LEN, 0},  	// P_G2_P3Q4                      
{ 0x3740, 0x1D10, WORD_LEN, 0},  	// P_G1_P4Q0                      
{ 0x3742, 0xE94F, WORD_LEN, 0},  	// P_G1_P4Q1                      
{ 0x3744, 0x8735, WORD_LEN, 0},  	// P_G1_P4Q2                      
{ 0x3746, 0xC2CC, WORD_LEN, 0},  	// P_G1_P4Q3                      
{ 0x3748, 0x23F6, WORD_LEN, 0},  	// P_G1_P4Q4                      
{ 0x374A, 0xE90F, WORD_LEN, 0},  	// P_R_P4Q0                       
{ 0x374C, 0x1A30, WORD_LEN, 0},  	// P_R_P4Q1                       
{ 0x374E, 0xAEF3, WORD_LEN, 0},  	// P_R_P4Q2                       
{ 0x3750, 0xB2F2, WORD_LEN, 0},  	// P_R_P4Q3                       
{ 0x3752, 0x2195, WORD_LEN, 0},  	// P_R_P4Q4                       
{ 0x3754, 0xFFEE, WORD_LEN, 0},  	// P_B_P4Q0                       
{ 0x3756, 0xD8D0, WORD_LEN, 0},  	// P_B_P4Q1                       
{ 0x3758, 0xCC92, WORD_LEN, 0},  	// P_B_P4Q2                       
{ 0x375A, 0x0451, WORD_LEN, 0},  	// P_B_P4Q3                       
{ 0x375C, 0x5814, WORD_LEN, 0},  	// P_B_P4Q4                       
{ 0x375E, 0x2470, WORD_LEN, 0},  	// P_G2_P4Q0                      
{ 0x3760, 0x6151, WORD_LEN, 0},  	// P_G2_P4Q1                      
{ 0x3762, 0x9555, WORD_LEN, 0},  	// P_G2_P4Q2                      
{ 0x3764, 0xD5D3, WORD_LEN, 0},  	// P_G2_P4Q3                      
{ 0x3766, 0x3B56, WORD_LEN, 0},  	// P_G2_P4Q4                      
{ 0x3782, 0x03DC, WORD_LEN, 0},  	// CENTER_ROW                     
{ 0x3784, 0x04E0, WORD_LEN, 0},  	// CENTER_COLUMN                  
{ 0x3210, 0x49B8, WORD_LEN, 0},  	// COLOR_PIPELINE_CONTROL         
//BITFIELD= 0x3210, 0x0008, 1 //PGA_ENABLE                          
//{ 0x3210, 0x0008, WORD_LEN, 0},                 



//[*********Step6************] 
//[Step6-AWB_CCM]              
//[AWB_setup]                  

{ 0xAC01, 0xBB, BYTE_LEN, 0}, 	// AWB_MODE   
//[CCM]
{ 0xAC46, 0x0221, WORD_LEN, 0}, 	// AWB_LEFT_CCM_0
{ 0xAC48, 0xFEAE, WORD_LEN, 0}, 	// AWB_LEFT_CCM_1
{ 0xAC4A, 0x0032, WORD_LEN, 0}, 	// AWB_LEFT_CCM_2
{ 0xAC4C, 0xFFC5, WORD_LEN, 0}, 	// AWB_LEFT_CCM_3
{ 0xAC4E, 0x0154, WORD_LEN, 0}, 	// AWB_LEFT_CCM_4
{ 0xAC50, 0xFFE7, WORD_LEN, 0}, 	// AWB_LEFT_CCM_5
{ 0xAC52, 0xFFB1, WORD_LEN, 0}, 	// AWB_LEFT_CCM_6
{ 0xAC54, 0xFEC5, WORD_LEN, 0}, 	// AWB_LEFT_CCM_7
{ 0xAC56, 0x028A, WORD_LEN, 0}, 	// AWB_LEFT_CCM_8
{ 0xAC58, 0x00C6, WORD_LEN, 0}, 	// AWB_LEFT_CCM_R2BRATIO
{ 0xAC5C, 0x01CD, WORD_LEN, 0}, 	// AWB_RIGHT_CCM_0
{ 0xAC5E, 0xFF63, WORD_LEN, 0}, 	// AWB_RIGHT_CCM_1
{ 0xAC60, 0xFFD0, WORD_LEN, 0}, 	// AWB_RIGHT_CCM_2
{ 0xAC62, 0xFFCD, WORD_LEN, 0}, 	// AWB_RIGHT_CCM_3
{ 0xAC64, 0x013B, WORD_LEN, 0}, 	// AWB_RIGHT_CCM_4
{ 0xAC66, 0xFFF8, WORD_LEN, 0}, 	// AWB_RIGHT_CCM_5
{ 0xAC68, 0xFFFB, WORD_LEN, 0}, 	// AWB_RIGHT_CCM_6
{ 0xAC6A, 0xFF78, WORD_LEN, 0}, 	// AWB_RIGHT_CCM_7
{ 0xAC6C, 0x018D, WORD_LEN, 0}, 	// AWB_RIGHT_CCM_8
{ 0xAC6E, 0x0055, WORD_LEN, 0}, 	// AWB_RIGHT_CCM_R2BRATIO

//[AWB]
{ 0xB842, 0x0037, WORD_LEN, 0}, 	// STAT_AWB_GRAY_CHECKER_OFFSET_X
{ 0xB844, 0x0044, WORD_LEN, 0}, 	// STAT_AWB_GRAY_CHECKER_OFFSET_Y
{ 0x3240, 0x0024, WORD_LEN, 0}, 	// AWB_XY_SCALE
{ 0x3240, 0x0024, WORD_LEN, 0}, 	// AWB_XY_SCALE
{ 0x3242, 0x0000, WORD_LEN, 0}, 	// AWB_WEIGHT_R0
{ 0x3244, 0x0000, WORD_LEN, 0}, 	// AWB_WEIGHT_R1
{ 0x3246, 0x0000, WORD_LEN, 0}, 	// AWB_WEIGHT_R2
{ 0x3248, 0x7F00, WORD_LEN, 0}, 	// AWB_WEIGHT_R3
{ 0x324A, 0xA500, WORD_LEN, 0}, 	// AWB_WEIGHT_R4
{ 0x324C, 0x1540, WORD_LEN, 0}, 	// AWB_WEIGHT_R5
{ 0x324E, 0x01AC, WORD_LEN, 0}, 	// AWB_WEIGHT_R6
{ 0x3250, 0x003E, WORD_LEN, 0}, 	// AWB_WEIGHT_R7

//[Preawb_params]
{ 0xACB0, 0x32, BYTE_LEN, 0}, 	// AWB_RG_MIN
{ 0xACB1, 0x5A, BYTE_LEN, 0}, 	// AWB_RG_MAX
{ 0xACB2, 0x32, BYTE_LEN, 0}, 	// AWB_RG_MIN_BRIGHT
{ 0xACB3, 0x5A, BYTE_LEN, 0}, 	// AWB_RG_MAX_BRIGHT
{ 0xACB4, 0x23, BYTE_LEN, 0}, 	// AWB_BG_MIN
{ 0xACB5, 0x55, BYTE_LEN, 0}, 	// AWB_BG_MAX
{ 0xACB6, 0x49, BYTE_LEN, 0}, 	// AWB_BG_MIN_BRIGHT
{ 0xACB7, 0x55, BYTE_LEN, 0}, 	// AWB_BG_MAX_BRIGHT 

//[**********Step7*************] 
//[Step7-CPIPE_Calibration]      
                                 
//[jpeg_setup]                   

{ 0xD80F, 0x04, BYTE_LEN, 0}, 	// JPEG_QSCALE_0
{ 0xD810, 0x08, BYTE_LEN, 0}, 	// JPEG_QSCALE_1
{ 0xC8D2, 0x04, BYTE_LEN, 0}, 	// CAM_OUTPUT_1_JPEG_QSCALE_0
{ 0xC8D3, 0x08, BYTE_LEN, 0}, 	// CAM_OUTPUT_1_JPEG_QSCALE_1
{ 0xC8BC, 0x04, BYTE_LEN, 0}, 	// CAM_OUTPUT_0_JPEG_QSCALE_0
{ 0xC8BD, 0x08, BYTE_LEN, 0}, 	// CAM_OUTPUT_0_JPEG_QSCALE_1

//[Sys_Settings]
{ 0xDC35, 0x04, BYTE_LEN, 0}, 	// SYS_UV_COLOR_BOOST
{ 0x326E, 0x0006, WORD_LEN, 0}, 	// RESERVED_SOC1_326E
{ 0xDC37, 0x62, BYTE_LEN, 0}, 	// SYS_BRIGHT_COLORKILL
{ 0x35A4, 0x0596, WORD_LEN, 0}, 	// BRIGHT_COLOR_KILL_CONTROLS
{ 0x35A2, 0x0094, WORD_LEN, 0}, 	// DARK_COLOR_KILL_CONTROLS
{ 0xDC36, 0x23, BYTE_LEN, 0}, 	// SYS_DARK_COLOR_KILL

//[Gamma_Curves_REV3]
{ 0xBC18, 0x00, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_0
{ 0xBC19, 0x11, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_1
{ 0xBC1A, 0x23, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_2
{ 0xBC1B, 0x3F, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_3
{ 0xBC1C, 0x67, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_4
{ 0xBC1D, 0x85, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_5
{ 0xBC1E, 0x9B, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_6
{ 0xBC1F, 0xAD, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_7
{ 0xBC20, 0xBB, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_8
{ 0xBC21, 0xC7, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_9
{ 0xBC22, 0xD1, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_10
{ 0xBC23, 0xDA, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_11
{ 0xBC24, 0xE1, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_12
{ 0xBC25, 0xE8, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_13
{ 0xBC26, 0xEE, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_14
{ 0xBC27, 0xF3, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_15
{ 0xBC28, 0xF7, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_16
{ 0xBC29, 0xFB, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_17
{ 0xBC2A, 0xFF, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_18
{ 0xBC2B, 0x00, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_0
{ 0xBC2C, 0x11, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_1
{ 0xBC2D, 0x23, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_2
{ 0xBC2E, 0x3F, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_3
{ 0xBC2F, 0x67, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_4
{ 0xBC30, 0x85, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_5
{ 0xBC31, 0x9B, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_6
{ 0xBC32, 0xAD, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_7
{ 0xBC33, 0xBB, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_8
{ 0xBC34, 0xC7, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_9
{ 0xBC35, 0xD1, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_10
{ 0xBC36, 0xDA, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_11
{ 0xBC37, 0xE1, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_12
{ 0xBC38, 0xE8, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_13
{ 0xBC39, 0xEE, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_14
{ 0xBC3A, 0xF3, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_15
{ 0xBC3B, 0xF7, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_16
{ 0xBC3C, 0xFB, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_17
{ 0xBC3D, 0xFF, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_18
{ 0xBC3E, 0x00, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_0
{ 0xBC3F, 0x05, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_1
{ 0xBC40, 0x0F, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_2
{ 0xBC41, 0x21, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_3
{ 0xBC42, 0x3C, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_4
{ 0xBC43, 0x52, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_5
{ 0xBC44, 0x67, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_6
{ 0xBC45, 0x7B, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_7
{ 0xBC46, 0x8D, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_8
{ 0xBC47, 0x9E, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_9
{ 0xBC48, 0xAD, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_10
{ 0xBC49, 0xBA, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_11
{ 0xBC4A, 0xC6, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_12
{ 0xBC4B, 0xD1, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_13
{ 0xBC4C, 0xDC, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_14
{ 0xBC4D, 0xE5, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_15
{ 0xBC4E, 0xEE, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_16
{ 0xBC4F, 0xF7, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_17
{ 0xBC50, 0xFF, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_18

//[BM_Dampening]
{ 0xB801, 0xE0, BYTE_LEN, 0}, 	// STAT_MODE
{ 0xB862, 0x04, BYTE_LEN, 0}, 	// STAT_BMTRACKING_SPEED

//[AE]
{ 0xB829, 0x02, BYTE_LEN, 0}, 	// STAT_LL_BRIGHTNESS_METRIC_DIVISOR
{ 0xB863, 0x02, BYTE_LEN, 0}, 	// STAT_BM_MUL
{ 0xB827, 0x0F, BYTE_LEN, 0}, 	// STAT_AE_EV_SHIFT
{ 0xA409, 0x42, BYTE_LEN, 0}, 	// AE_RULE_BASE_TARGET

//[BM_GM_Start_Stop] 
{ 0xBC52, 0x00C8, WORD_LEN, 0}, 	// LL_START_BRIGHTNESS_METRIC
{ 0xBC54, 0x0A28, WORD_LEN, 0}, 	// LL_END_BRIGHTNESS_METRIC
{ 0xBC58, 0x00C8, WORD_LEN, 0}, 	// LL_START_GAIN_METRIC
{ 0xBC5A, 0x12C0, WORD_LEN, 0}, 	// LL_END_GAIN_METRIC
{ 0xBC5E, 0x00FA, WORD_LEN, 0}, 	// LL_START_APERTURE_GAIN_BM
{ 0xBC60, 0x0258, WORD_LEN, 0}, 	// LL_END_APERTURE_GAIN_BM
{ 0xBC66, 0x00FA, WORD_LEN, 0}, 	// LL_START_APERTURE_GM
{ 0xBC68, 0x0258, WORD_LEN, 0}, 	// LL_END_APERTURE_GM
{ 0xBC86, 0x00C8, WORD_LEN, 0}, 	// LL_START_FFNR_GM
{ 0xBC88, 0x0640, WORD_LEN, 0}, 	// LL_END_FFNR_GM
{ 0xBCBC, 0x0040, WORD_LEN, 0}, 	// LL_SFFB_START_GAIN
{ 0xBCBE, 0x01FC, WORD_LEN, 0}, 	// LL_SFFB_END_GAIN
{ 0xBCCC, 0x00C8, WORD_LEN, 0}, 	// LL_SFFB_START_MAX_GM
{ 0xBCCE, 0x0640, WORD_LEN, 0}, 	// LL_SFFB_END_MAX_GM
{ 0xBC90, 0x00C8, WORD_LEN, 0}, 	// LL_START_GRB_GM
{ 0xBC92, 0x0640, WORD_LEN, 0}, 	// LL_END_GRB_GM
{ 0xBC0E, 0x0001, WORD_LEN, 0}, 	// LL_GAMMA_CURVE_ADJ_START_POS
{ 0xBC10, 0x0002, WORD_LEN, 0}, 	// LL_GAMMA_CURVE_ADJ_MID_POS
{ 0xBC12, 0x02BC, WORD_LEN, 0}, 	// LL_GAMMA_CURVE_ADJ_END_POS
{ 0xBCAA, 0x044C, WORD_LEN, 0}, 	// LL_CDC_THR_ADJ_START_POS
{ 0xBCAC, 0x00AF, WORD_LEN, 0}, 	// LL_CDC_THR_ADJ_MID_POS
{ 0xBCAE, 0x0009, WORD_LEN, 0}, 	// LL_CDC_THR_ADJ_END_POS
{ 0xBCD8, 0x00C8, WORD_LEN, 0}, 	// LL_PCR_START_BM
{ 0xBCDA, 0x0A28, WORD_LEN, 0}, 	// LL_PCR_END_BM

//[Kernel]
{ 0x3380, 0x0504, WORD_LEN, 0}, 	// KERNEL_CONFIG

//[GRB]
{ 0xBC94, 0x0C, BYTE_LEN, 0}, 	// LL_GB_START_THRESHOLD_0
{ 0xBC95, 0x08, BYTE_LEN, 0}, 	// LL_GB_START_THRESHOLD_1
{ 0xBC9C, 0x3C, BYTE_LEN, 0}, 	// RESERVED_LL_9C
{ 0xBC9D, 0x28, BYTE_LEN, 0}, 	// RESERVED_LL_9D

//[Demosaic_REV3]
{ 0x33B0, 0x2A16, WORD_LEN, 0}, 	// FFNR_ALPHA_BETA
{ 0xBC8A, 0x02, BYTE_LEN, 0}, 	// LL_START_FF_MIX_THRESH_Y
{ 0xBC8B, 0x0F, BYTE_LEN, 0}, 	// LL_END_FF_MIX_THRESH_Y
{ 0xBC8C, 0xFF, BYTE_LEN, 0}, 	// LL_START_FF_MIX_THRESH_YGAIN
{ 0xBC8D, 0xFF, BYTE_LEN, 0}, 	// LL_END_FF_MIX_THRESH_YGAIN
{ 0xBC8E, 0xFF, BYTE_LEN, 0}, 	// LL_START_FF_MIX_THRESH_GAIN
{ 0xBC8F, 0x00, BYTE_LEN, 0}, 	// LL_END_FF_MIX_THRESH_GAIN

//[CDC]
{ 0xBCB2, 0x20, BYTE_LEN, 0}, 	// LL_CDC_DARK_CLUS_SLOPE
{ 0xBCB3, 0x3A, BYTE_LEN, 0}, 	// LL_CDC_DARK_CLUS_SATUR
{ 0xBCB4, 0x39, BYTE_LEN, 0}, 	// RESERVED_LL_B4
{ 0xBCB7, 0x39, BYTE_LEN, 0}, 	// RESERVED_LL_B7
{ 0xBCB5, 0x20, BYTE_LEN, 0}, 	// RESERVED_LL_B5
{ 0xBCB8, 0x3A, BYTE_LEN, 0}, 	// RESERVED_LL_B8
{ 0xBCB6, 0x80, BYTE_LEN, 0}, 	// RESERVED_LL_B6
{ 0xBCB9, 0x24, BYTE_LEN, 0}, 	// RESERVED_LL_B9
{ 0xBCAA, 0x03E8, WORD_LEN, 0}, 	// LL_CDC_THR_ADJ_START_POS
{ 0xBCAC, 0x012C, WORD_LEN, 0}, 	// LL_CDC_THR_ADJ_MID_POS
{ 0xBCAE, 0x0009, WORD_LEN, 0}, 	// LL_CDC_THR_ADJ_END_POS

//[Aperture_calib]
{ 0x33BA, 0x0084, WORD_LEN, 0}, 	// APEDGE_CONTROL
{ 0x33BE, 0x0000, WORD_LEN, 0}, 	// UA_KNEE_L
{ 0x33C2, 0x8800, WORD_LEN, 0}, 	// UA_WEIGHTS
{ 0xBC5E, 0x0154, WORD_LEN, 0}, 	// LL_START_APERTURE_GAIN_BM
{ 0xBC60, 0x0640, WORD_LEN, 0}, 	// LL_END_APERTURE_GAIN_BM
{ 0xBC62, 0x0E, BYTE_LEN, 0}, 	// LL_START_APERTURE_KPGAIN
{ 0xBC63, 0x14, BYTE_LEN, 0}, 	// LL_END_APERTURE_KPGAIN
{ 0xBC64, 0x0E, BYTE_LEN, 0}, 	// LL_START_APERTURE_KNGAIN
{ 0xBC65, 0x14, BYTE_LEN, 0}, 	// LL_END_APERTURE_KNGAIN
{ 0xBCE2, 0x0A, BYTE_LEN, 0}, 	// LL_START_POS_KNEE
{ 0xBCE3, 0x2B, BYTE_LEN, 0}, 	// LL_END_POS_KNEE
{ 0xBCE4, 0x0A, BYTE_LEN, 0}, 	// LL_START_NEG_KNEE
{ 0xBCE5, 0x2B, BYTE_LEN, 0}, 	// LL_END_NEG_KNEE
{ 0x3210, 0x49B8, WORD_LEN, 0}, 	// COLOR_PIPELINE_CONTROL

//[SFFB_REV3_noisemodel]
{ 0xBCC0, 0x1F, BYTE_LEN, 0}, 	// LL_SFFB_RAMP_START
{ 0xBCC1, 0x03, BYTE_LEN, 0}, 	// LL_SFFB_RAMP_STOP
{ 0xBCC2, 0x2C, BYTE_LEN, 0}, 	// LL_SFFB_SLOPE_START
{ 0xBCC3, 0x10, BYTE_LEN, 0}, 	// LL_SFFB_SLOPE_STOP
{ 0xBCC4, 0x07, BYTE_LEN, 0}, 	// LL_SFFB_THSTART
{ 0xBCC5, 0x0B, BYTE_LEN, 0}, 	// LL_SFFB_THSTOP
{ 0xBCBA, 0x0009, WORD_LEN, 0}, 	// LL_SFFB_CONFIG

//[**********Step8*************]  
//[FTB_Off]                       
{ 0xBC14, 0xFFFE, WORD_LEN, 0}, 	// LL_GAMMA_FADE_TO_BLACK_START_POS
{ 0xBC16, 0xFFFE, WORD_LEN, 0}, 	// LL_GAMMA_FADE_TO_BLACK_END_POS

//[Aperture_preference]
{ 0xBC66, 0x0154, WORD_LEN, 0}, 	// LL_START_APERTURE_GM
{ 0xBC68, 0x07D0, WORD_LEN, 0}, 	// LL_END_APERTURE_GM
{ 0xBC6A, 0x04, BYTE_LEN, 0}, 	// LL_START_APERTURE_INTEGER_GAIN
{ 0xBC6B, 0x00, BYTE_LEN, 0}, 	// LL_END_APERTURE_INTEGER_GAIN
{ 0xBC6C, 0x00, BYTE_LEN, 0}, 	// LL_START_APERTURE_EXP_GAIN
{ 0xBC6D, 0x00, BYTE_LEN, 0}, 	// LL_END_APERTURE_EXP_GAIN

//[Gain_max]
{ 0xA81C, 0x0040, WORD_LEN, 0}, 	// AE_TRACK_MIN_AGAIN
{ 0xA820, 0x012C, WORD_LEN, 0}, 	// AE_TRACK_MAX_AGAIN
{ 0xA822, 0x0060, WORD_LEN, 0}, 	// AE_TRACK_MIN_DGAIN
{ 0xA824, 0x00E5, WORD_LEN, 0}, 	// AE_TRACK_MAX_DGAIN

//[Saturation_REV3]
{ 0xBC56, 0x64, BYTE_LEN, 0}, 	// LL_START_CCM_SATURATION
{ 0xBC57, 0x1E, BYTE_LEN, 0}, 	// LL_END_CCM_SATURATION

//[DCCM_REV3]
{ 0xBCDE, 0x03, BYTE_LEN, 0}, 	// LL_START_SYS_THRESHOLD
{ 0xBCDF, 0x50, BYTE_LEN, 0}, 	// LL_STOP_SYS_THRESHOLD
{ 0xBCE0, 0x08, BYTE_LEN, 0}, 	// LL_START_SYS_GAIN
{ 0xBCE1, 0x03, BYTE_LEN, 0}, 	// LL_STOP_SYS_GAIN

//[Sobel_REV3]
{ 0xBCD0, 0x000A, WORD_LEN, 0}, 	// LL_SFFB_SOBEL_FLAT_START
{ 0xBCD2, 0x00FE, WORD_LEN, 0}, 	// LL_SFFB_SOBEL_FLAT_STOP
{ 0xBCD4, 0x001E, WORD_LEN, 0}, 	// LL_SFFB_SOBEL_SHARP_START
{ 0xBCD6, 0x00FF, WORD_LEN, 0}, 	// LL_SFFB_SOBEL_SHARP_STOP
{ 0xBCC6, 0x00, BYTE_LEN, 0}, 	// LL_SFFB_SHARPENING_START
{ 0xBCC7, 0x00, BYTE_LEN, 0}, 	// LL_SFFB_SHARPENING_STOP
{ 0xBCC8, 0x20, BYTE_LEN, 0}, 	// LL_SFFB_FLATNESS_START
{ 0xBCC9, 0x40, BYTE_LEN, 0}, 	// LL_SFFB_FLATNESS_STOP
{ 0xBCCA, 0x04, BYTE_LEN, 0}, 	// LL_SFFB_TRANSITION_START
{ 0xBCCB, 0x00, BYTE_LEN, 0}, 	// LL_SFFB_TRANSITION_STOP

//[SFFB_slope_zero_enable]
{ 0xBCE6, 0x03, BYTE_LEN, 0}, 	// LL_SFFB_ZERO_ENABLE
{ 0xBCE6, 0x03, BYTE_LEN, 0}, 	// LL_SFFB_ZERO_ENABLE


//[AE_preference]
{ 0xA410, 0x04, BYTE_LEN, 0}, 	// AE_RULE_TARGET_AE_6
{ 0xA411, 0x06, BYTE_LEN, 0}, 	// AE_RULE_TARGET_AE_7


//[**********Step9*************]         
//[JPEG Quantization]                    
//[Sepia effect]                                        
{ 0xDC3A, 0x23, BYTE_LEN, 0}, 	// SYS_SEPIA_CR
{ 0xDC3B, 0xB2, BYTE_LEN, 0}, 	// SYS_SEPIA_CB


//[Touch Focus + Fast Focus AF_AFM_INIT]
{ 0x8411, 0x00, BYTE_LEN, 0}, 	// SEQ_STATE_CFG_0_AF
{ 0x8419, 0x04, BYTE_LEN, 0}, 	// SEQ_STATE_CFG_1_AF

{ 0xB002, 0x0002, WORD_LEN, 0}, 	// AF_MODE
{ 0xC40A, 0x0030, WORD_LEN, 0}, 	// AFM_POS_MIN
{ 0xC40C, 0x00A0, WORD_LEN, 0}, 	// AFM_POS_MAX
{ 0xB045, 0x000C, WORD_LEN, 0}, 	// AF_MODE_EX


//AF Window size
{ 0xB854, 0x60, BYTE_LEN, 0}, 	// STAT_SM_WINDOW_POS_X
{ 0xB855, 0x60, BYTE_LEN, 0}, 	// STAT_SM_WINDOW_POS_Y
{ 0xB856, 0x40, BYTE_LEN, 0}, 	// STAT_SM_WINDOW_SIZE_X
{ 0xB857, 0x40, BYTE_LEN, 0}, 	// STAT_SM_WINDOW_SIZE_Y
{ 0xB012, 0x0A, BYTE_LEN, 0}, 	// AF_FS_NUM_STEPS
{ 0xB018, 0x00, BYTE_LEN, 0}, 	// AF_FS_POS_0
{ 0xB019, 0x30, BYTE_LEN, 0}, 	// AF_FS_POS_1
{ 0xB01A, 0x48, BYTE_LEN, 0}, 	// AF_FS_POS_2
{ 0xB01B, 0x60, BYTE_LEN, 0}, 	// AF_FS_POS_3
{ 0xB01C, 0x78, BYTE_LEN, 0}, 	// AF_FS_POS_4
{ 0xB01D, 0x90, BYTE_LEN, 0}, 	// AF_FS_POS_5
{ 0xB01E, 0xA8, BYTE_LEN, 0}, 	// AF_FS_POS_6
{ 0xB01F, 0xC0, BYTE_LEN, 0}, 	// AF_FS_POS_7
{ 0xB020, 0xE0, BYTE_LEN, 0}, 	// AF_FS_POS_8
{ 0xB021, 0xFF, BYTE_LEN, 0}, 	// AF_FS_POS_9
{ 0xB022, 0x00, BYTE_LEN, 0}, 	// AF_FS_POS_10
{ 0xB011, 0x00, BYTE_LEN, 0}, 	// AF_FS_INIT_POS  

//INIT PATCH PAGE used in FF 
{ 0x098E, 0xD40E, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS
{ 0xD40E, 0x0000, WORD_LEN, 0},
{ 0xD40F, 0x0000, WORD_LEN, 0},
{ 0xD410, 0x0000, WORD_LEN, 0},
{ 0xD411, 0x0000, WORD_LEN, 0},
{ 0xD412, 0x0000, WORD_LEN, 0},
{ 0xD413, 0x0000, WORD_LEN, 0},
{ 0xD414, 0x0000, WORD_LEN, 0},
{ 0xD415, 0x0000, WORD_LEN, 0},
{ 0xD416, 0x0000, WORD_LEN, 0},
{ 0xD417, 0x0000, WORD_LEN, 0},
{ 0xD418, 0x0000, WORD_LEN, 0},
{ 0xD418, 0x0000, WORD_LEN, 0},
{ 0xD419, 0x0000, WORD_LEN, 0},
{ 0xD41A, 0x0000, WORD_LEN, 0},
{ 0xD41B, 0x0000, WORD_LEN, 0},
{ 0xD41C, 0x0000, WORD_LEN, 0},
{ 0xD41D, 0x0000, WORD_LEN, 0},
{ 0xD41E, 0x0000, WORD_LEN, 0},
{ 0xD420, 0x0000, WORD_LEN, 0},
{ 0xD406, 0x0000, WORD_LEN, 0},
{ 0xD407, 0x0000, WORD_LEN, 0},
{ 0xD422, 0x0000, WORD_LEN, 0},
{ 0xD423, 0x0000, WORD_LEN, 0},
{ 0xD424, 0x0000, WORD_LEN, 0},
{ 0xD425, 0x0000, WORD_LEN, 0},
{ 0xD426, 0x0000, WORD_LEN, 0},
{ 0xD427, 0x0000, WORD_LEN, 0},
{ 0xD428, 0x0000, WORD_LEN, 0},
{ 0xD429, 0x0000, WORD_LEN, 0},
{ 0xD42A, 0x0000, WORD_LEN, 0},
{ 0xD42B, 0x0000, WORD_LEN, 0},
{ 0xD400, 0x0001, WORD_LEN, 0},
{ 0xD401, 0x0000, WORD_LEN, 0},
{ 0xD402, 0x0028, WORD_LEN, 0},
{ 0xD403, 0x0080, WORD_LEN, 0},
{ 0xD404, 0x0000, WORD_LEN, 0},
{ 0xD405, 0x0000, WORD_LEN, 0},
{ 0xD406, 0x0000, WORD_LEN, 0},
{ 0xD407, 0x0000, WORD_LEN, 0},
{ 0xD408, 0x0030, WORD_LEN, 0},
{ 0xD409, 0x0040, WORD_LEN, 0},
{ 0xD40A, 0x0050, WORD_LEN, 0},
{ 0xD40B, 0x0070, WORD_LEN, 0},
{ 0xD40C, 0x0080, WORD_LEN, 0},
{ 0xD40D, 0x0090, WORD_LEN, 0},

{ 0x0018, 0x2008, WORD_LEN, 0}, 	// STANDBY_CONTROL_AND_STATUS

{SEQUENCE_WAIT_MS,100, WORD_LEN, 0},

   { SEQUENCE_END, 0x00, 0, 0}

                                                                                                                                                                             

};

/* 720p 15fps @ 1280x720 */
static struct reginfo sensor_720p[]=
{
	//{SEQUENCE_END, 0x00},
	{0x098E, 0x843C, WORD_LEN, 0}, // LOGICAL_ADDRESS_ACCESS [CAM_CORE_A_Y_ADDR_START]
	{0x843C, 0x01, BYTE_LEN, 0 }, // SEQ_STATE_CFG_5_MAX_FRAME_CNT
	{0x8404, 0x01, BYTE_LEN, 0 }, // SEQ_CMD
	{0x0016, 0x0447, WORD_LEN, 0},  // CLOCKS_CONTROL
	{0xC83A, 0x0106, WORD_LEN, 0},  // CAM_CORE_A_Y_ADDR_START
	{0xC83C, 0x0018, WORD_LEN, 0},  // CAM_CORE_A_X_ADDR_START
	{0xC83E, 0x06B7, WORD_LEN, 0},  // CAM_CORE_A_Y_ADDR_END
	{0xC840, 0x0A45, WORD_LEN, 0},  // CAM_CORE_A_X_ADDR_END
	{0xC86C, 0x0518, WORD_LEN, 0},  // CAM_CORE_A_OUTPUT_SIZE_WIDTH
	{0xC86E, 0x02D8, WORD_LEN, 0},  // CAM_CORE_A_OUTPUT_SIZE_HEIGHT
	{0xC870, 0x0014, WORD_LEN, 0},  // CAM_CORE_A_RX_FIFO_TRIGGER_MARK
	{0xC858, 0x0003, WORD_LEN, 0}, // CAM_CORE_A_COARSE_ITMIN
	{0xC8B8, 0x0004, WORD_LEN, 0},  // CAM_OUTPUT_0_JPEG_CONTROL
/****bug:part pixsels data not to be aquired *****/
#if ADJUST_FOR_720P_FALG            
	{0xC8AA, 0x0500, WORD_LEN, 0},  // CAM_OUTPUT_0_IMAGE_WIDTH
	{0xC8AC, 0x02D1, WORD_LEN, 0},  // CAM_OUTPUT_0_IMAGE_HEIGHT
#else
	{0xC8AA, 0x0500, WORD_LEN, 0},  // CAM_OUTPUT_0_IMAGE_WIDTH
	{0xC8AC, 0x02D0, WORD_LEN, 0},  // CAM_OUTPUT_0_IMAGE_HEIGHT
#endif	
	{0xC8AE, 0x0001, WORD_LEN, 0},  // CAM_OUTPUT_0_OUTPUT_FORMAT
	{0x8404, 0x06, BYTE_LEN, 0 },  // SEQ_CMD

	{SEQUENCE_WAIT_MS,100, WORD_LEN, 0},

   { SEQUENCE_END, 0x00, 0, 0}
};

/* 	1080p, 0x15fps, 0xyuv @1920x1080 */
static struct reginfo sensor_1080p[]=
{
{ SEQUENCE_END, 0x00, 0, 0}
};

/* 2592X1944 QSXGA */
#if  ADJUST_FOR_CAPTURE_FALG
static struct reginfo sensor_qsxga[] =
{

    {0x098E, 0x48C0,WORD_LEN,0},    // LOGICAL_ADDRESS_ACCESS [CAM_OUTPUT_1_IMAGE_WIDTH]
    {0xC8C0, 0x0A20,WORD_LEN,0},    // CAM_OUTPUT_1_IMAGE_WIDTH
    {0xC8C2, 0x0798,WORD_LEN,0},    // CAM_OUTPUT_1_IMAGE_HEIGHT
    {0x8404, 0x06 ,BYTE_LEN,0},      // SEQ_CMD
    {SEQUENCE_WAIT_MS,100,WORD_LEN,0},
    
    {SEQUENCE_END, 0x00, 0, 0}
};
#else
static struct reginfo sensor_qsxga[] =
{
	{SEQUENCE_PROPERTY,SEQUENCE_CAPTURE},
    { SEQUENCE_END, 0x00, 0, 0}
};
#endif

/* 2048*1536 QXGA */
#if ADJUST_FOR_CAPTURE_FALG
// send extra two lines to forbid to be captured error
static struct reginfo sensor_qxga[] =
{
    {0x098E, 0x48C0,WORD_LEN,0},    // LOGICAL_ADDRESS_ACCESS [CAM_OUTPUT_1_IMAGE_WIDTH]
    {0xC8C0, 0x0800,WORD_LEN,0},    // CAM_OUTPUT_1_IMAGE_WIDTH
    {0xC8C2, 0x0602,WORD_LEN,0},    // CAM_OUTPUT_1_IMAGE_HEIGHT
    {0x8404, 0x06 ,BYTE_LEN,0},      // SEQ_CMD
    {SEQUENCE_WAIT_MS,100,WORD_LEN,0},
   
    {SEQUENCE_END, 0x00, 0, 0}
};
#else
static struct reginfo sensor_qxga[] =
{
{ SEQUENCE_END, 0x00, 0, 0}
};
#endif

/* 1600X1200 UXGA */
#if ADJUST_FOR_CAPTURE_FALG
static struct reginfo sensor_uxga[] =
{
    {0x098E, 0x48C0,WORD_LEN,0},    // LOGICAL_ADDRESS_ACCESS [CAM_OUTPUT_1_IMAGE_WIDTH]
    {0xC8C0, 0x0640,WORD_LEN,0},    // CAM_OUTPUT_1_IMAGE_WIDTH
    {0xC8C2, 0x04b2,WORD_LEN,0},    // CAM_OUTPUT_1_IMAGE_HEIGHT
    {0x8404, 0x06 ,BYTE_LEN,0},      // SEQ_CMD
    {SEQUENCE_WAIT_MS,100,WORD_LEN,0},
   
    {SEQUENCE_END, 0x00, 0, 0}
};
#else
static struct reginfo sensor_uxga[] =
{
    { SEQUENCE_END, 0x00, 0, 0}
};
#endif

/* 1280X1024 SXGA */
static struct reginfo sensor_sxga[] =
{
	{SEQUENCE_END, 0x00}
};

/*  1024X768 XGA */
#if ADJUST_FOR_CAPTURE_FALG
static struct reginfo sensor_xga[] =
{
    {0x098E, 0x48C0,WORD_LEN,0},    // LOGICAL_ADDRESS_ACCESS [CAM_OUTPUT_1_IMAGE_WIDTH]
    {0xC8C0, 0x0403,WORD_LEN,0},    // CAM_OUTPUT_1_IMAGE_WIDTH
    {0xC8C2, 0x0302,WORD_LEN,0},    // CAM_OUTPUT_1_IMAGE_HEIGHT
    {0x8404, 0x06 ,BYTE_LEN,0},      // SEQ_CMD
    {SEQUENCE_WAIT_MS,100,WORD_LEN,0},
   
    {SEQUENCE_END, 0x00, 0, 0}
};
#else
static struct reginfo sensor_xga[] =
{
    {SEQUENCE_END, 0x00, 0, 0}
};
#endif


/* 800X600 SVGA*/
static struct reginfo sensor_svga[] =
{
    { SEQUENCE_END, 0x00, 0, 0}
};

/* 640X480 VGA */
static struct reginfo sensor_vga[] =
{
	//720p2vga
    {0xC83A, 0x000C, WORD_LEN, 0},    // CAM_CORE_A_Y_ADDR_START
    {0xC83C, 0x0018, WORD_LEN, 0},    // CAM_CORE_A_X_ADDR_START
    {0xC83E, 0x07B1, WORD_LEN, 0 },    // CAM_CORE_A_Y_ADDR_END
    {0xC840, 0x0A45, WORD_LEN, 0},    // CAM_CORE_A_X_ADDR_END
    {0xC868, 0x0423, WORD_LEN, 0},    // CAM_CORE_A_FRAME_LENGTH_LINES
    {0xC86A, 0x1194, WORD_LEN, 0},    // CAM_CORE_A_LINE_LENGTH_PCK
    {0xC86C, 0x0518, WORD_LEN, 0},    // CAM_CORE_A_OUTPUT_SIZE_WIDTH
    {0xC86E, 0x03D4, WORD_LEN, 0},    // CAM_CORE_A_OUTPUT_SIZE_HEIGHT
    {0xC870, 0x0014, WORD_LEN, 0},    // CAM_CORE_A_RX_FIFO_TRIGGER_MARK
    {0xC858, 0x0003, WORD_LEN, 0},  // CAM_CORE_A_COARSE_ITMIN
    {0xC8A4, 0x0A28, WORD_LEN, 0},    // CAM_CORE_B_OUTPUT_SIZE_WIDTH
    {0xC8A6, 0x07A0, WORD_LEN, 0 },    // CAM_CORE_B_OUTPUT_SIZE_HEIGHT
    {0xC8AA, 0x0280, WORD_LEN, 0 },    // CAM_OUTPUT_0_IMAGE_WIDTH
    {0xC8AC, 0x01E0, WORD_LEN, 0 },    // CAM_OUTPUT_0_IMAGE_HEIGHT
    {0xC8AE, 0x0001, WORD_LEN, 0 },    // CAM_OUTPUT_0_OUTPUT_FORMAT
    {0x8404, 0x06, BYTE_LEN, 0 }, // SEQ_CMD
    {SEQUENCE_WAIT_MS,100, WORD_LEN, 0},
    {SEQUENCE_END, 0x00, 0, 0}

};

/* 352X288 CIF */
static struct reginfo sensor_cif[] =
{
	{SEQUENCE_END, 0x00}
};

/* 320*240 QVGA */
static  struct reginfo sensor_qvga[] =
{
	{SEQUENCE_END, 0x00}
};

/* 176X144 QCIF*/
static struct reginfo sensor_qcif[] =
{
	{SEQUENCE_END, 0x00}
};
#endif
static  struct reginfo sensor_Preview2Capture[]=
{
	//capture2preview
	{0x098E, 0x843C, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS [SEQ_STATE_CFG_5_MAX_FRAME_CNT]
	{0x843C, 0xFF, BYTE_LEN, 0 }, 	// SEQ_STATE_CFG_5_MAX_FRAME_CNT
	{0x8404, 0x02, BYTE_LEN, 0 },	// SEQ_CMD
	{SEQUENCE_END, 0x00, 0, 0}

};

static  struct reginfo sensor_Capture2Preview[]=
{
	//snap2preview
	{0x098E, 0x843C, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS [SEQ_STATE_CFG_5_MAX_FRAME_CNT]
	{0x843C, 0x01, BYTE_LEN, 0 }, 	// SEQ_STATE_CFG_5_MAX_FRAME_CNT
	{0x8404, 0x01, BYTE_LEN, 0 },	// SEQ_CMD
	{0x0016, 0x0447, WORD_LEN, 0},	// CLOCKS_CONTRO
	{SEQUENCE_END, 0x00, 0, 0}

};
static  struct reginfo sensor_ClrFmt_YUYV[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_ClrFmt_UYVY[]=
{
	{SEQUENCE_END, 0x00}
};


#if CONFIG_SENSOR_WhiteBalance
static  struct reginfo sensor_WhiteB_Auto[]=
{
	//Auto
	{0x098E, 0xACB0, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS [AWB_MIN_ACCEPTED_PRE_AWB_R2G_RATIO]
	{0xACB0, 0x31, BYTE_LEN, 0 }, 	// AWB_RG_MIN
	{0xACB1, 0x5B, BYTE_LEN, 0 }, 	// AWB_RG_MAX
	{0xACB4, 0x2A, BYTE_LEN, 0 }, 	// AWB_BG_MIN
	{0xACB5, 0x5B, BYTE_LEN, 0 }, 	// AWB_BG_MAX
	{0xACB2, 0x40, BYTE_LEN, 0 }, 	// AWB_RG_MIN_BRIGHT
	{0xACB3, 0x48, BYTE_LEN, 0 }, 	// AWB_RG_MAX_BRIGHT
	{0xACB6, 0x3f, BYTE_LEN, 0 }, 	// AWB_BG_MIN_BRIGHT
	{0xACB7, 0x48, BYTE_LEN, 0 }, 	// AWB_BG_MAX_BRIGHT
	{0xAC44, 0x00, BYTE_LEN, 0 }, 	// AWB_LEFT_CCM_POS_RANGE_LIMIT
	{0xAC45, 0x7F, BYTE_LEN, 0 }, 	// AWB_RIGHT_CCM_POS_RANGE_LIMIT
	{SEQUENCE_END, 0x00, 0, 0}

};
/* Cloudy Colour Temperature : 6500K - 8000K  */
static  struct reginfo sensor_WhiteB_Cloudy[]=
{
	//[V.       DL 7500]
	{ 0x098E, 0xACB0, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS [AWB_MIN_ACCEPTED_PRE_AWB_R2G_RATIO]
	{0xACB0, 0x38, BYTE_LEN, 0 }, 	// AWB_RG_MIN
	{0xACB1, 0x42, BYTE_LEN, 0 }, 	// AWB_RG_MAX
	{0xACB4, 0x44, BYTE_LEN, 0 }, 	// AWB_BG_MIN
	{0xACB5, 0x4C, BYTE_LEN, 0 }, 	// AWB_BG_MAX
	{0xACB2, 0x38, BYTE_LEN, 0 }, 	// AWB_RG_MIN_BRIGHT
	{0xACB3, 0x42, BYTE_LEN, 0 }, 	// AWB_RG_MAX_BRIGHT
	{0xACB6, 0x44, BYTE_LEN, 0 }, 	// AWB_BG_MIN_BRIGHT
	{0xACB7, 0x4C, BYTE_LEN, 0 }, 	// AWB_BG_MAX_BRIGHT
	{0xAC44, 0x7C, BYTE_LEN, 0 }, 	// AWB_LEFT_CCM_POS_RANGE_LIMIT
	{0xAC45, 0x7F, BYTE_LEN, 0 }, 	// AWB_RIGHT_CCM_POS_RANGE_LIMIT
	{0xAC04, 0x3E, BYTE_LEN, 0 }, 	// AWB_PRE_AWB_R2G_RATIO
	{0xAC05, 0x48, BYTE_LEN, 0 }, 	// AWB_PRE_AWB_B2G_RATIO
	{0xAC08, 0x7F, BYTE_LEN, 0 }, 	// AWB_CUR_CCM_POS
	{SEQUENCE_END, 0x00, 0, 0}

};
/* ClearDay Colour Temperature : 5000K - 6500K  */
static  struct reginfo sensor_WhiteB_ClearDay[]=
{
	//[IV       Day Light]
	{ 0x098E, 0xACB0, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS [AWB_MIN_ACCEPTED_PRE_AWB_R2G_RATIO]
	{0xACB0, 0x3A, BYTE_LEN, 0 }, 	// AWB_RG_MIN
	{0xACB1, 0x44, BYTE_LEN, 0 }, 	// AWB_RG_MAX
	{0xACB4, 0x40, BYTE_LEN, 0 }, 	// AWB_BG_MIN
	{0xACB5, 0x4A, BYTE_LEN, 0 }, 	// AWB_BG_MAX
	{0xACB2, 0x3A, BYTE_LEN, 0 }, 	// AWB_RG_MIN_BRIGHT
	{0xACB3, 0x44, BYTE_LEN, 0 }, 	// AWB_RG_MAX_BRIGHT
	{0xACB6, 0x40, BYTE_LEN, 0 }, 	// AWB_BG_MIN_BRIGHT
	{0xACB7, 0x4A, BYTE_LEN, 0 }, 	// AWB_BG_MAX_BRIGHT
	{0xAC44, 0x7C, BYTE_LEN, 0 }, 	// AWB_LEFT_CCM_POS_RANGE_LIMIT
	{0xAC45, 0x7F, BYTE_LEN, 0 }, 	// AWB_RIGHT_CCM_POS_RANGE_LIMIT
	{0xAC04, 0x40, BYTE_LEN, 0 }, 	// AWB_PRE_AWB_R2G_RATIO
	{0xAC05, 0x48, BYTE_LEN, 0 }, 	// AWB_PRE_AWB_B2G_RATIO
	{0xAC08, 0x7F, BYTE_LEN, 0 }, 	// AWB_CUR_CCM_POS
	{SEQUENCE_END, 0x00, 0, 0}

};
/* Office Colour Temperature : 3500K - 5000K  */
static  struct reginfo sensor_WhiteB_TungstenLamp1[]=
{
	//[III        Fluorescent]
	{ 0x098E, 0xACB0, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS [AWB_MIN_ACCEPTED_PRE_AWB_R2G_RATIO]
	{0xACB0, 0x44, BYTE_LEN, 0 }, 	// AWB_RG_MIN
	{0xACB1, 0x4B, BYTE_LEN, 0 }, 	// AWB_RG_MAX
	{0xACB4, 0x2C, BYTE_LEN, 0 }, 	// AWB_BG_MIN
	{0xACB5, 0x34, BYTE_LEN, 0 }, 	// AWB_BG_MAX
	{0xACB2, 0x44, BYTE_LEN, 0 }, 	// AWB_RG_MIN_BRIGHT
	{0xACB3, 0x4B, BYTE_LEN, 0 }, 	// AWB_RG_MAX_BRIGHT
	{0xACB6, 0x2C, BYTE_LEN, 0 }, 	// AWB_BG_MIN_BRIGHT
	{0xACB7, 0x34, BYTE_LEN, 0 }, 	// AWB_BG_MAX_BRIGHT
	{0xAC44, 0x40, BYTE_LEN, 0 }, 	// AWB_LEFT_CCM_POS_RANGE_LIMIT
	{0xAC45, 0x4A, BYTE_LEN, 0 }, 	// AWB_RIGHT_CCM_POS_RANGE_LIMIT
	{0xAC04, 0x47, BYTE_LEN, 0 }, 	// AWB_PRE_AWB_R2G_RATIO
	{0xAC05, 0x30, BYTE_LEN, 0 }, 	// AWB_PRE_AWB_B2G_RATIO
	{0xAC08, 0x45, BYTE_LEN, 0 }, 	// AWB_CUR_CCM_POS
	{SEQUENCE_END, 0x00, 0, 0}
};
/* Home Colour Temperature : 2500K - 3500K  */
static  struct reginfo sensor_WhiteB_TungstenLamp2[]=
{
	//[II.        Incandescent]
	{ 0x098E, 0xACB0, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS [AWB_MIN_ACCEPTED_PRE_AWB_R2G_RATIO]
	{0xACB0, 0x57, BYTE_LEN, 0 }, 	// AWB_RG_MIN
	{0xACB1, 0x5F, BYTE_LEN, 0 }, 	// AWB_RG_MAX
	{0xACB4, 0x26, BYTE_LEN, 0 }, 	// AWB_BG_MIN
	{0xACB5, 0x2E, BYTE_LEN, 0 }, 	// AWB_BG_MAX
	{0xACB2, 0x57, BYTE_LEN, 0 }, 	// AWB_RG_MIN_BRIGHT
	{0xACB3, 0x5F, BYTE_LEN, 0 }, 	// AWB_RG_MAX_BRIGHT
	{0xACB6, 0x26, BYTE_LEN, 0 }, 	// AWB_BG_MIN_BRIGHT
	{0xACB7, 0x2E, BYTE_LEN, 0 }, 	// AWB_BG_MAX_BRIGHT
	{0xAC44, 0x00, BYTE_LEN, 0 }, 	// AWB_LEFT_CCM_POS_RANGE_LIMIT
	{0xAC45, 0x08, BYTE_LEN, 0 }, 	// AWB_RIGHT_CCM_POS_RANGE_LIMIT
	{0xAC04, 0x5B, BYTE_LEN, 0 }, 	// AWB_PRE_AWB_R2G_RATIO
	{0xAC05, 0x2A, BYTE_LEN, 0 }, 	// AWB_PRE_AWB_B2G_RATIO
	{0xAC08, 0x00, BYTE_LEN, 0 }, 	// AWB_CUR_CCM_POS
	{SEQUENCE_END, 0x00, 0, 0}
};
static struct reginfo *sensor_WhiteBalanceSeqe[] = {sensor_WhiteB_Auto, sensor_WhiteB_TungstenLamp1,sensor_WhiteB_TungstenLamp2,
    sensor_WhiteB_ClearDay, sensor_WhiteB_Cloudy,NULL,
};
#endif

#if CONFIG_SENSOR_Brightness
static  struct reginfo sensor_Brightness0[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Brightness1[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Brightness2[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Brightness3[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Brightness4[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Brightness5[]=
{
	{SEQUENCE_END, 0x00}
};
static struct reginfo *sensor_BrightnessSeqe[] = {sensor_Brightness0, sensor_Brightness1, sensor_Brightness2, sensor_Brightness3,
    sensor_Brightness4, sensor_Brightness5,NULL,
};

#endif

#if CONFIG_SENSOR_Effect
static  struct reginfo sensor_Effect_Normal[] =
{
	{0x098e,0xdc38, WORD_LEN, 0},
	{0xdc38,0x00, BYTE_LEN, 0 },
	{0x8404,0x06, BYTE_LEN, 0 },
	{SEQUENCE_END, 0x00, 0, 0}
};
#if 0
static  struct reginfo sensor_Effect_WandB[] =
{
    {SEQUENCE_END, 0x00, 0, 0}
};
#endif
static  struct reginfo sensor_Effect_Sepia[] =
{
	{0x098e,0xdc38, WORD_LEN, 0},
	{0xdc38,0x02, BYTE_LEN, 0 },
	{0xdc3a,0x10, BYTE_LEN, 0 },
	{0xdc3b,0xe0, BYTE_LEN, 0 },
	{0x8404,0x06, BYTE_LEN, 0 },
	{SEQUENCE_END, 0x00, 0, 0}
};

static  struct reginfo sensor_Effect_Negative[] =
{
	{0x098e,0xdc38, WORD_LEN, 0},
	{0xdc38,0x03, BYTE_LEN, 0 },
	{0x8404,0x06, BYTE_LEN, 0 },
	{SEQUENCE_END, 0x00, 0, 0}
};
#if 0
static  struct reginfo sensor_Effect_Bluish[] =
{
    {SEQUENCE_END, 0x00, 0, 0}
};

static  struct reginfo sensor_Effect_Green[] =
{
    {SEQUENCE_END, 0x00, 0, 0}
};
#endif
static struct reginfo sensor_Effect_Solarize[] =
{
	{0x098e,0xdc38, WORD_LEN, 0},
	{0xdc38,0x05, BYTE_LEN, 0 },
	{0xdc39,0x20, BYTE_LEN, 0 },
	{0x8404,0x06, BYTE_LEN, 0 },
	{SEQUENCE_END, 0x00, 0, 0}
};
static struct reginfo *sensor_EffectSeqe[] = {sensor_Effect_Normal, sensor_Effect_Negative,sensor_Effect_Sepia,
    sensor_Effect_Solarize,NULL,
};
#endif
#if CONFIG_SENSOR_Exposure
static  struct reginfo sensor_Exposure0[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Exposure1[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Exposure2[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Exposure3[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Exposure4[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Exposure5[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Exposure6[]=
{
	{SEQUENCE_END, 0x00}
};

static struct reginfo *sensor_ExposureSeqe[] = {sensor_Exposure0, sensor_Exposure1, sensor_Exposure2, sensor_Exposure3,
    sensor_Exposure4, sensor_Exposure5,sensor_Exposure6,NULL,
};
#endif
#if CONFIG_SENSOR_Saturation
static  struct reginfo sensor_Saturation0[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Saturation1[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Saturation2[]=
{
	{SEQUENCE_END, 0x00}
};
static struct reginfo *sensor_SaturationSeqe[] = {sensor_Saturation0, sensor_Saturation1, sensor_Saturation2, NULL,};

#endif
#if CONFIG_SENSOR_Contrast
static  struct reginfo sensor_Contrast0[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Contrast1[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Contrast2[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Contrast3[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Contrast4[]=
{
	{SEQUENCE_END, 0x00}
};


static  struct reginfo sensor_Contrast5[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Contrast6[]=
{
	{SEQUENCE_END, 0x00}
};
static struct reginfo *sensor_ContrastSeqe[] = {sensor_Contrast0, sensor_Contrast1, sensor_Contrast2, sensor_Contrast3,
    sensor_Contrast4, sensor_Contrast5, sensor_Contrast6, NULL,
};

#endif
#if CONFIG_SENSOR_Mirror
static  struct reginfo sensor_MirrorOn[]=
{
    {SEQUENCE_END, 0x00, 0, 0}
};

static  struct reginfo sensor_MirrorOff[]=
{
    {SEQUENCE_END, 0x00, 0, 0}
};
static struct reginfo *sensor_MirrorSeqe[] = {sensor_MirrorOff, sensor_MirrorOn,NULL,};
#endif
#if CONFIG_SENSOR_Flip
static  struct reginfo sensor_FlipOn[]=
{
    {SEQUENCE_END, 0x00, 0, 0}
};

static  struct reginfo sensor_FlipOff[]=
{
    {SEQUENCE_END, 0x00, 0, 0}
};
static struct reginfo *sensor_FlipSeqe[] = {sensor_FlipOff, sensor_FlipOn,NULL,};

#endif

#if CONFIG_SENSOR_Scene
static  struct reginfo sensor_SceneAuto[] =
{
    {SEQUENCE_END, 0x00, 0, 0}
};

static  struct reginfo sensor_SceneNight[] =
{
    {SEQUENCE_END, 0x00, 0, 0}
};
static struct reginfo *sensor_SceneSeqe[] = {sensor_SceneAuto, sensor_SceneNight,NULL,};

#endif

#if CONFIG_SENSOR_DigitalZoom
static struct reginfo sensor_Zoom0[] =
{
    {SEQUENCE_END, 0x00, 0, 0}
};

static struct reginfo sensor_Zoom1[] =
{
    {SEQUENCE_END, 0x00, 0, 0}
};

static struct reginfo sensor_Zoom2[] =
{
    {SEQUENCE_END, 0x00, 0, 0}
};


static struct reginfo sensor_Zoom3[] =
{
    {SEQUENCE_END, 0x00, 0, 0}
};
static struct reginfo *sensor_ZoomSeqe[] = {sensor_Zoom0, sensor_Zoom1, sensor_Zoom2, sensor_Zoom3, NULL};
#endif
static const struct v4l2_querymenu sensor_menus[] =
{
	#if CONFIG_SENSOR_WhiteBalance
    { .id = V4L2_CID_DO_WHITE_BALANCE,  .index = 0,  .name = "auto",  .reserved = 0, }, {  .id = V4L2_CID_DO_WHITE_BALANCE,  .index = 1, .name = "incandescent",  .reserved = 0,},
    { .id = V4L2_CID_DO_WHITE_BALANCE,  .index = 2,  .name = "fluorescent", .reserved = 0,}, {  .id = V4L2_CID_DO_WHITE_BALANCE, .index = 3,  .name = "daylight", .reserved = 0,},
    { .id = V4L2_CID_DO_WHITE_BALANCE,  .index = 4,  .name = "cloudy-daylight", .reserved = 0,},
    #endif

	#if CONFIG_SENSOR_Effect
    { .id = V4L2_CID_EFFECT,  .index = 0,  .name = "none",  .reserved = 0, }, {  .id = V4L2_CID_EFFECT,  .index = 1, .name = "negative",  .reserved = 0,},
    { .id = V4L2_CID_EFFECT,  .index = 2,  .name = "sepia", .reserved = 0,}, {  .id = V4L2_CID_EFFECT, .index = 3,  .name = "solarize", .reserved = 0,},
    #endif

	#if CONFIG_SENSOR_Scene
    { .id = V4L2_CID_SCENE,  .index = 0, .name = "auto", .reserved = 0,} ,{ .id = V4L2_CID_SCENE,  .index = 1,  .name = "night", .reserved = 0,},
    #endif

	#if CONFIG_SENSOR_Flash
    { .id = V4L2_CID_FLASH,  .index = 0,  .name = "off",  .reserved = 0, }, {  .id = V4L2_CID_FLASH,  .index = 1, .name = "auto",  .reserved = 0,},
    { .id = V4L2_CID_FLASH,  .index = 2,  .name = "on", .reserved = 0,}, {  .id = V4L2_CID_FLASH, .index = 3,  .name = "torch", .reserved = 0,},
    #endif
};

static  struct v4l2_queryctrl sensor_controls[] =
{
	#if CONFIG_SENSOR_WhiteBalance
    {
        .id		= V4L2_CID_DO_WHITE_BALANCE,
        .type		= V4L2_CTRL_TYPE_MENU,
        .name		= "White Balance Control",
        .minimum	= 0,
        .maximum	= 4,
        .step		= 1,
        .default_value = 0,
    },
    #endif

	#if CONFIG_SENSOR_Brightness
	{
        .id		= V4L2_CID_BRIGHTNESS,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "Brightness Control",
        .minimum	= -3,
        .maximum	= 2,
        .step		= 1,
        .default_value = 0,
    },
    #endif

	#if CONFIG_SENSOR_Effect
	{
        .id		= V4L2_CID_EFFECT,
        .type		= V4L2_CTRL_TYPE_MENU,
        .name		= "Effect Control",
        .minimum	= 0,
        .maximum	= 3,
        .step		= 1,
        .default_value = 0,
    },
	#endif

	#if CONFIG_SENSOR_Exposure
	{
        .id		= V4L2_CID_EXPOSURE,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "Exposure Control",
        .minimum	= 0,
        .maximum	= 6,
        .step		= 1,
        .default_value = 0,
    },
	#endif

	#if CONFIG_SENSOR_Saturation
	{
        .id		= V4L2_CID_SATURATION,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "Saturation Control",
        .minimum	= 0,
        .maximum	= 2,
        .step		= 1,
        .default_value = 0,
    },
    #endif

	#if CONFIG_SENSOR_Contrast
	{
        .id		= V4L2_CID_CONTRAST,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "Contrast Control",
        .minimum	= -3,
        .maximum	= 3,
        .step		= 1,
        .default_value = 0,
    },
	#endif

	#if CONFIG_SENSOR_Mirror
	{
        .id		= V4L2_CID_HFLIP,
        .type		= V4L2_CTRL_TYPE_BOOLEAN,
        .name		= "Mirror Control",
        .minimum	= 0,
        .maximum	= 1,
        .step		= 1,
        .default_value = 1,
    },
    #endif

	#if CONFIG_SENSOR_Flip
	{
        .id		= V4L2_CID_VFLIP,
        .type		= V4L2_CTRL_TYPE_BOOLEAN,
        .name		= "Flip Control",
        .minimum	= 0,
        .maximum	= 1,
        .step		= 1,
        .default_value = 1,
    },
    #endif

	#if CONFIG_SENSOR_Scene
    {
        .id		= V4L2_CID_SCENE,
        .type		= V4L2_CTRL_TYPE_MENU,
        .name		= "Scene Control",
        .minimum	= 0,
        .maximum	= 1,
        .step		= 1,
        .default_value = 0,
    },
    #endif

	#if CONFIG_SENSOR_DigitalZoom
    {
        .id		= V4L2_CID_ZOOM_RELATIVE,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "DigitalZoom Control",
        .minimum	= -1,
        .maximum	= 1,
        .step		= 1,
        .default_value = 0,
    }, {
        .id		= V4L2_CID_ZOOM_ABSOLUTE,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "DigitalZoom Control",
        .minimum	= 0,
        .maximum	= 3,
        .step		= 1,
        .default_value = 0,
    },
    #endif

	#if CONFIG_SENSOR_Focus
	{
        .id		= V4L2_CID_FOCUS_RELATIVE,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "Focus Control",
        .minimum	= -1,
        .maximum	= 1,
        .step		= 1,
        .default_value = 0,
    }, {
        .id		= V4L2_CID_FOCUS_ABSOLUTE,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "Focus Control",
        .minimum	= 0,
        .maximum	= 255,
        .step		= 1,
        .default_value = 125,
    },
	{
        .id		= V4L2_CID_FOCUSZONE,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "FocusZone Control",
        .minimum	= -1,
        .maximum	= 1,
        .step		= 1,
        .default_value = 0,
    },{
        .id		= V4L2_CID_FOCUS_AUTO,
        .type		= V4L2_CTRL_TYPE_BOOLEAN,
        .name		= "Focus Control",
        .minimum	= 0,
        .maximum	= 1,
        .step		= 1,
        .default_value = 0,
    },/*{
        .id		= V4L2_CID_FOCUS_CONTINUOUS,
        .type		= V4L2_CTRL_TYPE_BOOLEAN,
        .name		= "Focus Control",
        .minimum	= 0,
        .maximum	= 1,
        .step		= 1,
        .default_value = 0,
    },*/
    #endif

	#if CONFIG_SENSOR_Flash
	{
        .id		= V4L2_CID_FLASH,
        .type		= V4L2_CTRL_TYPE_MENU,
        .name		= "Flash Control",
        .minimum	= 0,
        .maximum	= 2,
        //.maximum	= 3
        .step		= 1,
        .default_value = 0,
    },
	#endif
};

static int sensor_probe(struct i2c_client *client, const struct i2c_device_id *did);
static int sensor_video_probe(struct soc_camera_device *icd, struct i2c_client *client);
static int sensor_g_control(struct v4l2_subdev *sd, struct v4l2_control *ctrl);
static int sensor_s_control(struct v4l2_subdev *sd, struct v4l2_control *ctrl);
static int sensor_g_ext_controls(struct v4l2_subdev *sd,  struct v4l2_ext_controls *ext_ctrl);
static int sensor_s_ext_controls(struct v4l2_subdev *sd,  struct v4l2_ext_controls *ext_ctrl);
static int sensor_suspend(struct soc_camera_device *icd, pm_message_t pm_msg);
static int sensor_resume(struct soc_camera_device *icd);
static int sensor_set_bus_param(struct soc_camera_device *icd,unsigned long flags);
static unsigned long sensor_query_bus_param(struct soc_camera_device *icd);
static int sensor_set_effect(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value);
static int sensor_set_whiteBalance(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value);
static int sensor_deactivate(struct i2c_client *client);

static struct soc_camera_ops sensor_ops =
{
    .suspend                     = sensor_suspend,
    .resume                       = sensor_resume,
    .set_bus_param		= sensor_set_bus_param,
    .query_bus_param	= sensor_query_bus_param,
    .controls		= sensor_controls,
    .menus                         = sensor_menus,
    .num_controls		= ARRAY_SIZE(sensor_controls),
    .num_menus		= ARRAY_SIZE(sensor_menus),
};

/* only one fixed colorspace per pixelcode */
struct sensor_datafmt {
	enum v4l2_mbus_pixelcode code;
	enum v4l2_colorspace colorspace;
};

/* Find a data format by a pixel code in an array */
static const struct sensor_datafmt *sensor_find_datafmt(
	enum v4l2_mbus_pixelcode code, const struct sensor_datafmt *fmt,
	int n)
{
	int i;
	for (i = 0; i < n; i++)
		if (fmt[i].code == code)
			return fmt + i;

	return NULL;
}

static const struct sensor_datafmt sensor_colour_fmts[] = {
    {V4L2_MBUS_FMT_UYVY8_2X8, V4L2_COLORSPACE_JPEG},
    {V4L2_MBUS_FMT_YUYV8_2X8, V4L2_COLORSPACE_JPEG}	
};
enum sensor_wq_cmd
{
    WqCmd_af_init,
    WqCmd_af_single,
    WqCmd_af_special_pos,
    WqCmd_af_far_pos,
    WqCmd_af_near_pos,
    WqCmd_af_continues,
    WqCmd_af_return_idle,
};
enum sensor_wq_result
{
    WqRet_success = 0,
    WqRet_fail = -1,
    WqRet_inval = -2
};
struct sensor_work
{
	struct i2c_client *client;
	struct delayed_work dwork;
	enum sensor_wq_cmd cmd;
    wait_queue_head_t done;
    enum sensor_wq_result result;
    bool wait;
    int var;    
    int zone_center_pos[2];
};
typedef struct sensor_info_priv_s
{
    int whiteBalance;
    int brightness;
    int contrast;
    int saturation;
    int effect;
    int scene;
    int digitalzoom;
    int focus;
	int auto_focus;
	int affm_reinit;
    int flash;
    int exposure;
    unsigned char mirror;                                        /* HFLIP */
    unsigned char flip;                                          /* VFLIP */
	bool snap2preview;
	bool video2preview;
	int capture_w;
	int capture_h;
	int preview_w;
	int preview_h;
    struct reginfo *winseqe_cur_addr;
	struct sensor_datafmt fmt;
	unsigned int enable;
	unsigned int funmodule_state;
} sensor_info_priv_t;



struct sensor_parameter
{
	unsigned short int preview_maxlines;
	unsigned short int preview_exposure;
	unsigned short int preview_line_width;
	unsigned short int preview_gain;

	unsigned short int capture_framerate;
	unsigned short int preview_framerate;
};

struct sensor
{
    struct v4l2_subdev subdev;
    struct i2c_client *client;
    sensor_info_priv_t info_priv;
	struct sensor_parameter parameter;
	struct workqueue_struct *sensor_wq;
	struct sensor_work sensor_wk;
	struct mutex wq_lock;
    int model;	/* V4L2_IDENT_OV* codes from v4l2-chip-ident.h */
#if CONFIG_SENSOR_I2C_NOSCHED
	atomic_t tasklock_cnt;
#endif
	struct rk29camera_platform_data *sensor_io_request;
    struct rk29camera_gpio_res *sensor_gpio_res;
};


static bool sensor_fmt_videochk(struct v4l2_subdev *sd, struct v4l2_mbus_framefmt *mf);

static struct sensor* to_sensor(const struct i2c_client *client)
{
    return container_of(i2c_get_clientdata(client), struct sensor, subdev);
}

static int sensor_task_lock(struct i2c_client *client, int lock)
{
#if CONFIG_SENSOR_I2C_NOSCHED
	int cnt = 3;
    struct sensor *sensor = to_sensor(client);

	if (lock) {
		if (atomic_read(&sensor->tasklock_cnt) == 0) {
			while ((atomic_read(&client->adapter->bus_lock.count) < 1) && (cnt>0)) {
				SENSOR_TR("\n %s will obtain i2c in atomic, but i2c bus is locked! Wait...\n",SENSOR_NAME_STRING());
				msleep(35);
				cnt--;
			}
			if ((atomic_read(&client->adapter->bus_lock.count) < 1) && (cnt<=0)) {
				SENSOR_TR("\n %s obtain i2c fail in atomic!!\n",SENSOR_NAME_STRING());
				goto sensor_task_lock_err;
			}
			preempt_disable();
		}

		atomic_add(1, &sensor->tasklock_cnt);
	} else {
		if (atomic_read(&sensor->tasklock_cnt) > 0) {
			atomic_sub(1, &sensor->tasklock_cnt);

			if (atomic_read(&sensor->tasklock_cnt) == 0)
				preempt_enable();
		}
	}    
	return 0;
sensor_task_lock_err:
	return -1;    
#else
    return 0;
#endif
}
/*sensor register write */
static int sensor_write(struct i2c_client *client, struct reginfo *reg_info)
{
    int err=0,cnt;
    u8 buf[4];
    struct i2c_msg msg[1];

	switch (reg_info->reg)
	{
		case SEQUENCE_WAIT_MS:
		{
			if (in_atomic())
				mdelay(reg_info->val);
			else
				msleep(reg_info->val);
			break;
		}

		case SEQUENCE_WAIT_US:
		{
			udelay(reg_info->val);
			break;
		}
		case SEQUENCE_PROPERTY:
		{
			break;
		}
		default:
		{
		    buf[0] = reg_info->reg >> 8;
		    buf[1] = reg_info->reg & 0xFF;
			if (reg_info->reg_len == WORD_LEN) {
				buf[2] = reg_info->val >> 8;
				buf[3] = reg_info->val & 0xFF;
				msg->len = 4;
			} else if (reg_info->reg_len == BYTE_LEN) {
				buf[2] = reg_info->val;
				msg->len = 3;
			}
		    msg->addr = client->addr;
		    msg->flags = client->flags;
		    msg->buf = buf;
		    msg->scl_rate = CONFIG_SENSOR_I2C_SPEED;         /* ddl@rock-chips.com : 100kHz */
		    msg->read_type = 0;               /* fpga i2c:0==I2C_NORMAL : direct use number not enum for don't want include spi_fpga.h */
		    cnt = 3;
		    err = -EAGAIN;
		    while ((cnt-- > 0) && (err < 0)) {                       /* ddl@rock-chips.com :  Transfer again if transent is failed   */
		        err = i2c_transfer(client->adapter, msg, 1);

		        if (err >= 0) {
		            return 0;
		        } else {
		            SENSOR_TR("\n %s write reg(0x%x, val:0x%x) failed, try to write again!\n",SENSOR_NAME_STRING(),reg_info->reg, reg_info->val);
		            udelay(10);
		        }
		    }
		}
	}
    return err;
}

/**
 *sensor_write_Multiple_data - sensor register write with Multiple data
 * @i2c_client: 
 * @reg_info: the first register address
 * @count: data number
 *
 * Returns negative errno, else the number of messages executed.
 *
 * Note that it 
 */
static int sensor_write_Multiple_data(struct i2c_client *client, struct reginfo *reg_info, int count)
{
    int err=0,cnt;  
    int i=0;
    int sum =0;
    struct reginfo *tmpval = NULL;
    u8 *buf;
    struct i2c_msg msg[1];
    tmpval = reg_info;
    
    if(count < 1 || tmpval==NULL||tmpval->reg==0x0000)                         
     return -EINVAL;

    memset((char*)&msg[0],0,sizeof(struct i2c_msg));   
    buf = kmalloc((count*2+10)*sizeof(u8),GFP_KERNEL);
    if (buf == NULL) {
        SENSOR_TR("%s %s fail,because kmalloc failed",SENSOR_NAME_STRING(),__FUNCTION__);
        err = -1;
        goto sensor_write_Multiple_data_end;
    }
    memset(buf,0,sizeof(buf));
    
	switch (reg_info->reg)
  	{
  		case SEQUENCE_WAIT_MS:
		{
			if (in_atomic())
				mdelay(reg_info->val);
			else
				msleep(reg_info->val);
			break;
		}

		case SEQUENCE_WAIT_US:
		{
			udelay(reg_info->val);
			break;
		}

		case SEQUENCE_PROPERTY:
		{
			break;
		}
		default:
		{
            
		    buf[0] = tmpval->reg >> 8;
		    buf[1] = tmpval->reg & 0xFF;
            i= 2;    
			if (tmpval->reg_len == WORD_LEN)
            {
               sum = (count+1)*2;
               while(i<sum) 
               {
				 buf[i] = tmpval->val >> 8;
				 buf[i+1] = tmpval->val & 0xFF;
                 i=i+2;
                 tmpval++;
               }             
			   msg->len = sum;               
			} else if (tmpval->reg_len == BYTE_LEN) {
			  sum = count+2;
               while(i<sum) 
               {
				 buf[i] = tmpval->val;
                 i++;
                 tmpval++;
               }             
			   msg->len = sum;               
			}
		    msg->addr = client->addr;
		    msg->flags = client->flags;
		    msg->buf = buf;
		    msg->scl_rate = CONFIG_SENSOR_I2C_SPEED;         /* ddl@rock-chips.com : 100kHz */
		    msg->read_type = 0;               /* fpga i2c:0==I2C_NORMAL : direct use number not enum for don't want include spi_fpga.h */
		    cnt = 3;
		    err = -EAGAIN;
		    while ((cnt-- > 0) && (err < 0)) {                       /* ddl@rock-chips.com :  Transfer again if transent is failed   */
		        err = i2c_transfer(client->adapter, msg, 1);
		        if (err >= 0) {
		            return 0;
		        } else {
		            SENSOR_TR("\n %s write reg(0x%x, val:0x%x) failed, try to write again!\n",SENSOR_NAME_STRING(),reg_info->reg, reg_info->val);
		            udelay(10);
		        }
		    }            
		}                
	}
sensor_write_Multiple_data_end:  
    if (buf) {
        kfree(buf);
        buf = NULL;
    }
    return err;
}

/* sensor register read */
static int sensor_read(struct i2c_client *client, u16 reg, u16 *val)
{
    int err,cnt;
    u8 buf[2];
    struct i2c_msg msg[2];

    buf[0] = reg >> 8;
    buf[1] = reg & 0xFF; 

    msg[0].addr = client->addr;
    msg[0].flags = client->flags;
    msg[0].buf = buf;
    msg[0].len = sizeof(buf);
    msg[0].scl_rate = CONFIG_SENSOR_I2C_SPEED;       /* ddl@rock-chips.com : 100kHz */
    msg[0].read_type = 2;   /* fpga i2c:0==I2C_NO_STOP : direct use number not enum for don't want include spi_fpga.h */

    msg[1].addr = client->addr;
    msg[1].flags = client->flags|I2C_M_RD;
    msg[1].buf = buf;
    msg[1].len = 2;
    msg[1].scl_rate = CONFIG_SENSOR_I2C_SPEED;                       /* ddl@rock-chips.com : 100kHz */
    msg[1].read_type = 2;                             /* fpga i2c:0==I2C_NO_STOP : direct use number not enum for don't want include spi_fpga.h */

    cnt = 3;
    err = -EAGAIN;
    while ((cnt-- > 0) && (err < 0)) {                       /* ddl@rock-chips.com :  Transfer again if transent is failed   */
        err = i2c_transfer(client->adapter, msg, 2);

        if (err >= 0) {
            *val = buf[0];
            return 0;
        } else {
        	SENSOR_TR("\n %s read reg(0x%x val:0x%x) failed, try to read again! \n",SENSOR_NAME_STRING(),reg, *val);
            udelay(10);
        }
    }

    return err;
}

static int sensor_read1(struct i2c_client *client, struct reginfo *reg_info)
{
    int err,cnt;
    u8 buf[2];
    struct i2c_msg msg[2];

    buf[0] = reg_info->reg >> 8;
    buf[1] = reg_info->reg & 0xFF;
			

    msg[0].addr = client->addr;
    msg[0].flags = client->flags;
    msg[0].buf = buf;
    msg[0].len = sizeof(buf);
    msg[0].scl_rate = CONFIG_SENSOR_I2C_SPEED;       /* ddl@rock-chips.com : 100kHz */
    msg[0].read_type = 2;   /* fpga i2c:0==I2C_NO_STOP : direct use number not enum for don't want include spi_fpga.h */

    msg[1].addr = client->addr;
    msg[1].flags = client->flags|I2C_M_RD;
    msg[1].buf = buf;
    if (reg_info->reg_len == WORD_LEN) {		
		msg[1].len = 2;
	} else if (reg_info->reg_len == BYTE_LEN) {
		msg[1].len = 1;
	} 
    msg[1].scl_rate = CONFIG_SENSOR_I2C_SPEED;                       /* ddl@rock-chips.com : 100kHz */
    msg[1].read_type = 2;                             /* fpga i2c:0==I2C_NO_STOP : direct use number not enum for don't want include spi_fpga.h */

    cnt = 3;
    err = -EAGAIN;
    while ((cnt-- > 0) && (err < 0)) {                       /* ddl@rock-chips.com :  Transfer again if transent is failed   */
        err = i2c_transfer(client->adapter, msg, 2);

        if (err >= 0) {
            if (reg_info->reg_len == WORD_LEN) {		
        		reg_info->val = buf[0];
                reg_info->val <<= 8;
                reg_info->val |= buf[1];
        	} else if (reg_info->reg_len == BYTE_LEN) {
        		reg_info->val = buf[0];
        	}
            return 0;
        } else {
        	SENSOR_TR("\n %s read reg(0x%x val:0x%x) failed, try to read again! \n",SENSOR_NAME_STRING(),reg_info->reg, reg_info->val);
            udelay(10);
        }
    }

    return err;
}

/* write a array of registers  */
static int sensor_write_array(struct i2c_client *client, struct reginfo *regarray)
{
    int err = 0, cnt;
    int i = 0,j=0;
    int num = 0;  
    u16 temp = 0;
    
#if CONFIG_SENSOR_I2C_RDWRCHK
	char valchk;
#endif
	cnt = 0;

	if (sensor_task_lock(client, 1) < 0)
		goto sensor_write_array_end;
    
   // SENSOR_TR("%s ..%s..\n",SENSOR_NAME_STRING(),__FUNCTION__);         
   
    while (regarray[i].reg != SEQUENCE_END) {           
       num =1;
       j= i+1;   
       #if 0
       while((regarray[j].reg_len ==regarray[i].reg_len)&&regarray[j].reg != SEQUENCE_END)
       {
          temp = regarray[j].reg - regarray[j-1].reg;            
          if((regarray[j].reg_len==WORD_LEN && temp!=0x0002)||(regarray[j].reg_len==BYTE_LEN && temp!=0x0001))
           break;
           num++;
           j++;
       }    
       #endif
       err = sensor_write_Multiple_data(client, &regarray[i], num) ;            
       if (err < 0)
        {
            if (cnt-- > 0) {
			    SENSOR_TR("%s..write failed current reg:0x%x, Write array again !\n", SENSOR_NAME_STRING(),regarray[i].reg);
				i = 0;
				continue;
            } else {
                SENSOR_TR("%s..write array failed!!!\n", SENSOR_NAME_STRING());
                err = -EPERM;
				goto sensor_write_array_end;
            }
        } else {
        #if CONFIG_SENSOR_I2C_RDWRCHK
			sensor_read(client, regarray[i].reg, &valchk);
			if (valchk != regarray[i].val)
				SENSOR_TR("%s Reg:0x%x write(0x%x, 0x%x) fail\n",SENSOR_NAME_STRING(), regarray[i].reg, regarray[i].val, valchk);
		#endif
        }

        i=i+num;
    }
sensor_write_array_end:
	sensor_task_lock(client,0);
    return err;
}

/* write sensor initial data */
static int sensor_write_init_data(struct i2c_client *client, struct reginfo *regarray)
{
    int err = 0, cnt;
    int i = 0;
    int num = 0;
#if CONFIG_SENSOR_I2C_RDWRCHK
	char valchk;
#endif
    int ti=0;	   
    int table[167] = {                   /*written data numbers every time*/
        3,1,1,3,1,1,1,1,11,2,2,13,1,1,1,2,11,2,2,13,
        1,2,1,1,2,1,1,1,1,1,8,1,1,1,1,1,1,714,1,1,
        1,1,1,1,1,42,1,3,9,1,1,2,2,1,1,1,1,3,1,1,
        1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,8,2,2,2,
        2,2,1,1,1,1,10,10,9,6,4,2,9,2,2,2,1,1,1,1,
        1,1,1,1,1,1,1,1,58,1,1,1,1,1,1,1,1,1,1,1,
        2,2,2,2,2,2,2,2,2,3,3,2,1,1,1,1,1, 2,2,1,
        6,3,1,1,1,1,1,6,1,2,4,4,1,1,1,4,5,2,2,4,
        4,6,1,1,1,1,1
    };
    
    cnt = 0; 
	if (sensor_task_lock(client, 1) < 0)
		goto sensor_write_array_end;
   
    while (regarray[i].reg != SEQUENCE_END) { 
       #if 0
       if(ti < 167){
         num = table[ti];
         ti++;
       }    
       #else
       num = 1;
       #endif
       err = sensor_write_Multiple_data(client, &regarray[i], num) ;            
       if (err < 0)
        {
            if (cnt-- > 0) {
			    SENSOR_TR("%s..write failed current reg:0x%x, Write array again !\n", SENSOR_NAME_STRING(),regarray[i].reg);
				i = 0;
				continue;
            } else {
                SENSOR_TR("%s..write array failed!!!\n", SENSOR_NAME_STRING());
                err = -EPERM;
				goto sensor_write_array_end;
            }
        } else {
        #if CONFIG_SENSOR_I2C_RDWRCHK
			sensor_read(client, regarray[i].reg, &valchk);
			if (valchk != regarray[i].val)
				SENSOR_TR("%s Reg:0x%x write(0x%x, 0x%x) fail\n",SENSOR_NAME_STRING(), regarray[i].reg, regarray[i].val, valchk);
		#endif
        }
       i=i+num;
    }
sensor_write_array_end:
	sensor_task_lock(client,0);
    return err;
}

#if 0
/* write a array of registers  */
static int sensor_write_array(struct i2c_client *client, struct reginfo *regarray)
{
    int err = 0, cnt;
    int i = 0;
#if CONFIG_SENSOR_I2C_RDWRCHK
	char valchk;
#endif
	cnt = 0;
	if (sensor_task_lock(client, 1) < 0)
		goto sensor_write_array_end;
    
    while (regarray[i].reg != SEQUENCE_END) {
       
        err = sensor_write(client, &regarray[i]);
        
        if (err < 0)
        {
            if (cnt-- > 0) {
			    SENSOR_TR("%s..write failed current reg:0x%x, Write array again !\n", SENSOR_NAME_STRING(),regarray[i].reg);
				i = 0;
				continue;
            } else {
                SENSOR_TR("%s..write array failed!!!\n", SENSOR_NAME_STRING());
                err = -EPERM;
				goto sensor_write_array_end;
            }
        } else {
        #if CONFIG_SENSOR_I2C_RDWRCHK
			sensor_read(client, regarray[i].reg, &valchk);
			if (valchk != regarray[i].val)
				SENSOR_TR("%s Reg:0x%x write(0x%x, 0x%x) fail\n",SENSOR_NAME_STRING(), regarray[i].reg, regarray[i].val, valchk);
		#endif
        }
        i++;
    }
sensor_write_array_end:
	sensor_task_lock(client,0);
    return err;
}
#endif
#if CONFIG_SENSOR_I2C_RDWRCHK
static int sensor_readchk_array(struct i2c_client *client, struct reginfo *regarray)
{
    int cnt;
    int i = 0;
	char valchk;

	cnt = 0;
	valchk = 0;
    while (regarray[i].reg != SEQUENCE_END)
    {
		sensor_read(client, regarray[i].reg, &valchk);
		if (valchk != regarray[i].val)
			SENSOR_TR("%s Reg:0x%x read(0x%x, 0x%x) error\n",SENSOR_NAME_STRING(), regarray[i].reg, regarray[i].val, valchk);

        i++;
    }
    return 0;
}
#endif

#if CONFIG_SENSOR_Focus

static struct reginfo sensor_af_trigger[] =
{
    { 0xB854, 0x4040, WORD_LEN, 0},	// STAT_SM_WINDOW_POS_X; POS_Y                                                                                                                                                                              
    { 0xB856, 0x4040, WORD_LEN, 0}, 	// STAT_SM_WINDOW_SIZE_X; SIZE_Y                                                                                                                                                                          
    { 0xB006, 0x01, BYTE_LEN, 0},       //run AF - af.progress   
    {SEQUENCE_END, 0x00, 0, 0}
};
static int sensor_af_touch_zone(struct i2c_client *client, int *zone_center_pos)
{
	int ret = 0;
    
    zone_center_pos[0] = zone_center_pos[0]*0x100/2000;
    zone_center_pos[1] = zone_center_pos[1]*0x100/2000;

    zone_center_pos[0] = zone_center_pos[0]/0x40*0x40;
    zone_center_pos[1] = zone_center_pos[1]/0x40*0x40;

    sensor_af_trigger[0].val = (zone_center_pos[0]<<8)|zone_center_pos[1];
  
sensor_af_zone_end:
    return ret;
}
static int sensor_af_single(struct i2c_client *client)
{
	int ret = 0;
    char cnt=0;
    struct reginfo reg;
    
	ret = sensor_write_array(client, sensor_af_trigger);
	if (ret<0) {
		SENSOR_TR("%s sensor auto focus trigger fail!!\n",SENSOR_NAME_STRING());
	} else {

        reg.reg_len = BYTE_LEN;
        reg.reg = 0xb006;
        reg.val = 0x01;

        do {
            msleep(30);
            sensor_read1(client,&reg);

        } while ((reg.val != 0) && (cnt++ < 50));
        
		SENSOR_DG("%s sensor auto focus trigger(0x%x) success! state: %d, cnt: %d\n",SENSOR_NAME_STRING(),
          sensor_af_trigger[0].val,reg.val,cnt);
	}

    
sensor_af_single_end:
	return ret;
}

static int sensor_af_const(struct i2c_client *client)
{
	int ret = 0;

sensor_af_const_end:
	return ret;
}

static int sensor_af_init(struct i2c_client *client)
{
	int ret = 0;
    return 0;
}
static int sensor_af_downfirmware(struct i2c_client *client)
{
	struct sensor *sensor = to_sensor(client);
	int ret=0;
    struct soc_camera_device *icd = client->dev.platform_data;
    struct v4l2_mbus_framefmt mf;
		
	SENSOR_DG("%s %s Enter\n",SENSOR_NAME_STRING(), __FUNCTION__);
    
	if (sensor_af_init(client)) {
		sensor->info_priv.funmodule_state &= (~SENSOR_AF_IS_OK);
		ret = -1;
	} else {
		sensor->info_priv.funmodule_state |= SENSOR_AF_IS_OK;
        
        mf.width = icd->user_width;
		mf.height = icd->user_height;
        mf.code = sensor->info_priv.fmt.code;
        mf.colorspace = sensor->info_priv.fmt.colorspace;
        mf.field	= V4L2_FIELD_NONE;
        if (sensor_fmt_videochk(NULL, &mf) == true) {    /* ddl@rock-chips.com: focus mode fix const auto focus in video */
            ret = sensor_af_const(client);
        } else {
    		switch (sensor->info_priv.auto_focus)
    		{
    			case SENSOR_AF_MODE_AUTO:
    			{
    				ret = sensor_af_single(client);
    				break;
    			}
    			case SENSOR_AF_MODE_CLOSE:
    			{
    				ret = 0;
    				break;
    			}
                case SENSOR_AF_MODE_CONTINUOUS:
                {
                    ret = sensor_af_const(client);
                    break;
                }
    			default:
                {
    				SENSOR_DG("%s focus mode(0x%x) is unkonwn\n",SENSOR_NAME_STRING(),sensor->info_priv.auto_focus);
                    goto sensor_af_downfirmware_end;
    			}
    		}
        }
		SENSOR_DG("%s sensor_af_downfirmware set focus mode(0x%x) ret:0x%x\n",SENSOR_NAME_STRING(), sensor->info_priv.auto_focus,ret);
	}

sensor_af_downfirmware_end:
	
	return ret;
}
static void sensor_af_workqueue(struct work_struct *work)
{
	struct sensor_work *sensor_work = container_of(work, struct sensor_work, dwork.work);
	struct i2c_client *client = sensor_work->client;
    struct sensor *sensor = to_sensor(client);
    //struct af_cmdinfo cmdinfo;
    
    SENSOR_DG("%s %s Enter, cmd:0x%x \n",SENSOR_NAME_STRING(), __FUNCTION__,sensor_work->cmd);
    
    mutex_lock(&sensor->wq_lock);
    
    switch (sensor_work->cmd) 
    {
        case WqCmd_af_init:
        {
        	if (sensor_af_downfirmware(client) < 0) {
        		SENSOR_TR("%s Sensor_af_init is failed in sensor_af_workqueue!\n",SENSOR_NAME_STRING());
        	}            
            break;
        }
        case WqCmd_af_single:
        {      
            if ((sensor_work->zone_center_pos[0] >=0) && (sensor_work->zone_center_pos[1]>=0))
                sensor_af_touch_zone(client,sensor_work->zone_center_pos);
            
            if (sensor_af_single(client) < 0) {
        		SENSOR_TR("%s Sensor_af_single is failed in sensor_af_workqueue!\n",SENSOR_NAME_STRING());
                sensor_work->result = WqRet_fail;
        	} else {
                sensor_work->result = WqRet_success;
        	}
            break;
        }
        #if 0
        case WqCmd_af_special_pos:
        {
            sensor_af_idlechk(client);

			cmdinfo.cmd_tag = StepFocus_Spec_Tag;
			cmdinfo.cmd_para[0] = sensor_work->var;
			cmdinfo.validate_bit = 0x81;
			if (sensor_af_cmdset(client, StepMode_Cmd, &cmdinfo) < 0)
               sensor_work->result = WqRet_fail;
            else 
               sensor_work->result = WqRet_success;
            break;
        }
        case WqCmd_af_near_pos:
        {            
            sensor_af_idlechk(client);
            cmdinfo.cmd_tag = StepFocus_Near_Tag;
            cmdinfo.validate_bit = 0x80;
			if (sensor_af_cmdset(client, StepMode_Cmd, &cmdinfo) < 0)
               sensor_work->result = WqRet_fail;
            else 
               sensor_work->result = WqRet_success;
            break;
        }
        case WqCmd_af_far_pos:
        {
            sensor_af_idlechk(client);
			cmdinfo.cmd_tag = StepFocus_Far_Tag;
			cmdinfo.validate_bit = 0x80;
			if (sensor_af_cmdset(client, StepMode_Cmd, &cmdinfo) < 0)
               sensor_work->result = WqRet_fail;
            else 
               sensor_work->result = WqRet_success;
            break;
        }
        #endif
        case WqCmd_af_continues:
        {
            if (sensor_af_const(client) < 0)
               sensor_work->result = WqRet_fail;
            else 
               sensor_work->result = WqRet_success;
            break;
        }
        #if 0
        case WqCmd_af_return_idle:
        {
            if (sensor_af_idlechk(client) < 0)
               sensor_work->result = WqRet_fail;
            else 
               sensor_work->result = WqRet_success;
            break;
        }  
        #endif
        default:
            SENSOR_TR("Unknow command(%d) in %s af workqueue!",sensor_work->cmd,SENSOR_NAME_STRING());
            break;
    } 
set_end:
    if (sensor_work->wait == false) {
        kfree((void*)sensor_work);
    } else {
        wake_up(&sensor_work->done); 
    }
    mutex_unlock(&sensor->wq_lock); 
    return;
}

static int sensor_af_workqueue_set(struct soc_camera_device *icd, enum sensor_wq_cmd cmd, int var, bool wait, int *zone_pos)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
	struct sensor *sensor = to_sensor(client); 
    struct sensor_work *wk;
    int ret=0;

    if (sensor->sensor_wq == NULL) { 
        ret = -EINVAL;
        goto sensor_af_workqueue_set_end;
    }

    if ((sensor->info_priv.funmodule_state & SENSOR_AF_IS_OK) != SENSOR_AF_IS_OK) {
        if (cmd != WqCmd_af_init) {
            SENSOR_TR("%s %s cmd(%d) ingore,because af module isn't ready!",SENSOR_NAME_STRING(),__FUNCTION__,cmd);
            ret = -1;
            goto sensor_af_workqueue_set_end;
        }
    }
    
    wk = kzalloc(sizeof(struct sensor_work), GFP_KERNEL);
    if (wk) {
	    wk->client = client;
	    INIT_DELAYED_WORK(&wk->dwork, sensor_af_workqueue);
        wk->cmd = cmd;
        wk->result = WqRet_inval;
        wk->wait = wait;
        wk->var = var;

        if (zone_pos) {
            *zone_pos += 1000;
            *(zone_pos+1) += 1000;
            *(zone_pos+2) += 1000;
            *(zone_pos+3) += 1000;
            wk->zone_center_pos[0] = ((*zone_pos + *(zone_pos+2))>>1);
            wk->zone_center_pos[1] = ((*(zone_pos+1) + *(zone_pos+3))>>1);
        }
        
        init_waitqueue_head(&wk->done);
            
        /* ddl@rock-chips.com: 
        * video_lock is been locked in v4l2_ioctl function, but auto focus may slow,
        * As a result any other ioctl calls will proceed very, very slowly since each call
        * will have to wait for the AF to finish. Camera preview is pause,because VIDIOC_QBUF 
        * and VIDIOC_DQBUF is sched. so unlock video_lock here.
        */
        if (wait == true) {
            queue_delayed_work(sensor->sensor_wq,&(wk->dwork),0);
            mutex_unlock(&icd->video_lock);
            if (wait_event_timeout(wk->done, (wk->result != WqRet_inval), msecs_to_jiffies(5000)) == 0) {  //hhb
                SENSOR_TR("%s %s cmd(%d) is timeout!\n",SENSOR_NAME_STRING(),__FUNCTION__,cmd);
            }
            ret = wk->result;
            kfree((void*)wk);
            mutex_lock(&icd->video_lock);  
        } else {
            queue_delayed_work(sensor->sensor_wq,&(wk->dwork),msecs_to_jiffies(10));
        }
        
    } else {
        SENSOR_TR("%s %s cmd(%d) ingore,because struct sensor_work malloc failed!",SENSOR_NAME_STRING(),__FUNCTION__,cmd);
        ret = -1;
    }
sensor_af_workqueue_set_end:
    return ret;
}
#endif

static int sensor_ioctrl(struct soc_camera_device *icd,enum rk29sensor_power_cmd cmd, int on)
{
	struct soc_camera_link *icl = to_soc_camera_link(icd);
	int ret = 0;

    SENSOR_DG("%s %s  cmd(%d) on(%d)\n",SENSOR_NAME_STRING(),__FUNCTION__,cmd,on);
	switch (cmd)
	{
		case Sensor_PowerDown:
		{
			if (icl->powerdown) {
				ret = icl->powerdown(icd->pdev, on);
				if (ret == RK29_CAM_IO_SUCCESS) {
					if (on == 0) {
						mdelay(2);
						if (icl->reset)
							icl->reset(icd->pdev);
					}
				} else if (ret == RK29_CAM_EIO_REQUESTFAIL) {
					ret = -ENODEV;
					goto sensor_power_end;
				}
			}
			break;
		}
		case Sensor_Flash:
		{
			struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
    		struct sensor *sensor = to_sensor(client);

			if (sensor->sensor_io_request && sensor->sensor_io_request->sensor_ioctrl) {
				sensor->sensor_io_request->sensor_ioctrl(icd->pdev,Cam_Flash, on);
				printk( "Sensor_Flash on = %d\n", on );
#if 0
                if(on){
                    //flash off after 2 secs
                    if ( flash_off_timer.status ){
				hrtimer_cancel(&(flash_off_timer.timer));
                    }
            		hrtimer_start(&(flash_off_timer.timer),ktime_set(0, 800*1000*1000),HRTIMER_MODE_REL);
			flash_off_timer.status = 1;
               }else{
	               flash_off_timer.status = 0;
               }
#endif
		}
			break;
		}
		default:
		{
			SENSOR_TR("%s %s cmd(0x%x) is unknown!",SENSOR_NAME_STRING(),__FUNCTION__,cmd);
			break;
		}
	}

sensor_power_end:
	return ret;
}

static enum hrtimer_restart flash_off_func(struct hrtimer *hrtimer){
	struct flash_timer *fps_timer = container_of(hrtimer, struct flash_timer, timer);
	 sensor_ioctrl(fps_timer->icd,Sensor_Flash,0);
	 printk("%s %s = 0x%x !!!!!!",SENSOR_NAME_STRING(),__FUNCTION__, fps_timer );
	 return 0;
}

static int sensor_init(struct v4l2_subdev *sd, u32 val)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct soc_camera_device *icd = client->dev.platform_data;
    struct sensor *sensor = to_sensor(client);
#if (ADJUST_OPTIMIZE_TIME_FALG == 0)
	const struct v4l2_queryctrl *qctrl;
#endif
    const struct sensor_datafmt *fmt;
    int ret,pid = 0;
    int index  =0 ;
#if (SENSOR_RESET_REG != SEQUENCE_END)
    struct reginfo reg_info;
#endif

    SENSOR_DG("\n%s..%s.. \n",SENSOR_NAME_STRING(),__FUNCTION__);

	if (sensor_ioctrl(icd, Sensor_PowerDown, 0) < 0) {
		ret = -ENODEV;
		goto sensor_INIT_ERR;
	}
    
    SENSOR_DG("\n soft reset..%s.\n",SENSOR_NAME_STRING());

    /* soft reset */
	if (sensor_task_lock(client,1)<0)
		goto sensor_INIT_ERR;

#if (SENSOR_RESET_REG != SEQUENCE_END)
	reg_info.reg = SENSOR_RESET_REG;
	reg_info.val = SENSOR_RESET_VAL;
	reg_info.reg_len = SENSOR_RESET_REG_LEN;
    ret = sensor_write(client, &reg_info);
    if (ret != 0) {
        SENSOR_TR("%s soft reset sensor failed\n",SENSOR_NAME_STRING());
        ret = -ENODEV;
		goto sensor_INIT_ERR;
    }
    mdelay(5);     //delay 5 microseconds
#endif

	/* check if it is an sensor sensor */
#if (SENSOR_ID_REG != SEQUENCE_END)
    ret = sensor_read(client, SENSOR_ID_REG, &pid);
    if (ret != 0) {
        SENSOR_TR("read chip id failed\n");
        ret = -ENODEV;
        goto sensor_INIT_ERR;
    }
    SENSOR_DG("\n %s  pid = 0x%x \n", SENSOR_NAME_STRING(), pid);
#else
	pid = SENSOR_ID;
#endif

    if (pid == SENSOR_ID) {
        sensor->model = SENSOR_V4L2_IDENT;
    } else {
        SENSOR_TR("error: %s mismatched   pid = 0x%x\n", SENSOR_NAME_STRING(), pid);
        ret = -ENODEV;
        goto sensor_INIT_ERR;
    }
    
    SENSOR_DG("\n sensor_init_data..%s.\n",SENSOR_NAME_STRING());
 
    ret =sensor_write_init_data(client, sensor_init_data);
    if (ret != 0) {
        SENSOR_TR("error: %s initial failed\n",SENSOR_NAME_STRING());
        goto sensor_INIT_ERR;
    }
	sensor_task_lock(client,0);
    sensor->info_priv.preview_w = SENSOR_INIT_WIDTH;
    sensor->info_priv.preview_h = SENSOR_INIT_HEIGHT;
    sensor->info_priv.capture_w = SENSOR_MAX_WIDTH;
    sensor->info_priv.capture_h = SENSOR_MAX_HEIGHT;
    sensor->info_priv.winseqe_cur_addr  = SENSOR_INIT_WINSEQADR;
	fmt = sensor_find_datafmt(SENSOR_INIT_PIXFMT,sensor_colour_fmts, ARRAY_SIZE(sensor_colour_fmts));
    if (!fmt) {
        SENSOR_TR("error: %s initial array colour fmts is not support!!",SENSOR_NAME_STRING());
        ret = -EINVAL;
        goto sensor_INIT_ERR;
    }
	sensor->info_priv.fmt = *fmt;

    /* sensor sensor information for initialization  */
#if ADJUST_OPTIMIZE_TIME_FALG   
    SENSOR_DG("\n optimize code..%s.\n",SENSOR_NAME_STRING());
	#if CONFIG_SENSOR_WhiteBalance
      sensor->info_priv.whiteBalance = 0;
    #endif    
	#if CONFIG_SENSOR_Brightness
      sensor->info_priv.brightness = 0;
    #endif
	#if CONFIG_SENSOR_Effect
    	sensor->info_priv.effect = 0;
    #endif
	#if CONFIG_SENSOR_Exposure
        sensor->info_priv.exposure = 0;
    #endif
	#if CONFIG_SENSOR_Saturation
        sensor->info_priv.saturation = 0;
    #endif
	#if CONFIG_SENSOR_Contrast
        sensor->info_priv.contrast = 0;
    #endif        
	#if CONFIG_SENSOR_Mirror
        sensor->info_priv.mirror = 1;
    #endif
	#if CONFIG_SENSOR_Flip
        sensor->info_priv.flip = 1;
        index++;        
    #endif        
	#if CONFIG_SENSOR_Scene
        sensor->info_priv.scene = 0;
        index++;        
    #endif
	#if CONFIG_SENSOR_DigitalZoom
        sensor->info_priv.digitalzoom = 0;
    #endif        
	#if CONFIG_SENSOR_Focus
        sensor->info_priv.focus = 125  ;
        if (sensor_af_init(client) < 0) {
		sensor->info_priv.funmodule_state &= ~SENSOR_AF_IS_OK;
		SENSOR_TR("%s auto focus module init is fail!\n",SENSOR_NAME_STRING());
	    } else {
		sensor->info_priv.funmodule_state |= SENSOR_AF_IS_OK;
		SENSOR_DG("%s auto focus module init is success!\n",SENSOR_NAME_STRING());
	    }
    #endif    
	#if CONFIG_SENSOR_Flash
        sensor->info_priv.flash = 0 ;    
    #endif
    
#else
    SENSOR_DG("\n origin code..%s.\n",SENSOR_NAME_STRING());

	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_DO_WHITE_BALANCE);
	if (qctrl)
    	sensor->info_priv.whiteBalance = qctrl->default_value;
    
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_BRIGHTNESS);
	if (qctrl)
    	sensor->info_priv.brightness = qctrl->default_value;
    
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_EFFECT);
	if (qctrl)
    	sensor->info_priv.effect = qctrl->default_value;
    
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_EXPOSURE);
	if (qctrl)
        sensor->info_priv.exposure = qctrl->default_value;

	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_SATURATION);
	if (qctrl)
        sensor->info_priv.saturation = qctrl->default_value;
    
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_CONTRAST);
	if (qctrl)
        sensor->info_priv.contrast = qctrl->default_value;
    
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_HFLIP);
	if (qctrl)
        sensor->info_priv.mirror = qctrl->default_value;
    
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_VFLIP);
	if (qctrl)
        sensor->info_priv.flip = qctrl->default_value;
    
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_SCENE);
	if (qctrl)
        sensor->info_priv.scene = qctrl->default_value;
    
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_ZOOM_ABSOLUTE);
	if (qctrl)
        sensor->info_priv.digitalzoom = qctrl->default_value;

    /* ddl@rock-chips.com : if sensor support auto focus and flash, programer must run focus and flash code  */
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_FOCUS_ABSOLUTE);
	if (qctrl)
        sensor->info_priv.focus = qctrl->default_value;
   
	#if CONFIG_SENSOR_Focus
	if (sensor_af_init(client) < 0) {
		sensor->info_priv.funmodule_state &= ~SENSOR_AF_IS_OK;
		SENSOR_TR("%s auto focus module init is fail!\n",SENSOR_NAME_STRING());
	} else {
		sensor->info_priv.funmodule_state |= SENSOR_AF_IS_OK;
		SENSOR_DG("%s auto focus module init is success!\n",SENSOR_NAME_STRING());
	}
	#endif
	#ifdef CONFIG_SENSOR_Flash
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_FLASH);
	if (qctrl)
        sensor->info_priv.flash = qctrl->default_value;

    flash_off_timer.icd = icd;
	flash_off_timer.timer.function = flash_off_func;
	printk( "flash_off_timer.timer.function\n" );

    #endif
#endif      
    SENSOR_DG("\n%s..%s.. icd->width = %d.. icd->height %d\n",SENSOR_NAME_STRING(),((val == 0)?__FUNCTION__:"sensor_reinit"),icd->user_width,icd->user_height);
    sensor->info_priv.funmodule_state |= SENSOR_INIT_IS_OK;
    return 0;
sensor_INIT_ERR:
    sensor->info_priv.funmodule_state &= ~SENSOR_INIT_IS_OK;
	sensor_task_lock(client,0);
	sensor_deactivate(client);
    return ret;
}
static int sensor_deactivate(struct i2c_client *client)
{
	struct soc_camera_device *icd = client->dev.platform_data;
    struct sensor *sensor = to_sensor(client);

	SENSOR_DG("\n%s..%s.. Enter\n",SENSOR_NAME_STRING(),__FUNCTION__);

	/* ddl@rock-chips.com : all sensor output pin must change to input for other sensor */


	sensor_ioctrl(icd, Sensor_PowerDown, 1);
    msleep(100);

	/* ddl@rock-chips.com : sensor config init width , because next open sensor quickly(soc_camera_open -> Try to configure with default parameters) */
	icd->user_width = SENSOR_INIT_WIDTH;
    icd->user_height = SENSOR_INIT_HEIGHT;
    sensor->info_priv.funmodule_state &= ~SENSOR_INIT_IS_OK;

	return 0;
}
static  struct reginfo sensor_power_down_sequence[]=
{
    {0x00,0x00}
};
static int sensor_suspend(struct soc_camera_device *icd, pm_message_t pm_msg)
{
    int ret;
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if (pm_msg.event == PM_EVENT_SUSPEND) {
        SENSOR_DG("\n %s Enter Suspend..pm_msg.event=%d \n", SENSOR_NAME_STRING(),pm_msg.event);
        ret = sensor_write_array(client, sensor_power_down_sequence) ;
        if (ret != 0) {
            SENSOR_TR("\n %s..%s WriteReg Fail.. \n", SENSOR_NAME_STRING(),__FUNCTION__);
            return ret;
        } else {
            ret = sensor_ioctrl(icd, Sensor_PowerDown, 1);
            if (ret < 0) {
			    SENSOR_TR("\n %s suspend fail for turn on power!\n", SENSOR_NAME_STRING());
                return -EINVAL;
            }
        }
    } else {
        SENSOR_TR("\n %s cann't suppout Suspend..\n",SENSOR_NAME_STRING());
        return -EINVAL;
    }

    return 0;
}

static int sensor_resume(struct soc_camera_device *icd)
{
	int ret;

    ret = sensor_ioctrl(icd, Sensor_PowerDown, 0);
    if (ret < 0) {
		SENSOR_TR("\n %s resume fail for turn on power!\n", SENSOR_NAME_STRING());
        return -EINVAL;
    }

	SENSOR_DG("\n %s Enter Resume.. \n", SENSOR_NAME_STRING());
	return 0;
}

static int sensor_set_bus_param(struct soc_camera_device *icd,
                                unsigned long flags)
{

    return 0;
}

static unsigned long sensor_query_bus_param(struct soc_camera_device *icd)
{
    struct soc_camera_link *icl = to_soc_camera_link(icd);
    unsigned long flags = SENSOR_BUS_PARAM;

    return soc_camera_apply_sensor_flags(icl, flags);
}

static int sensor_g_fmt(struct v4l2_subdev *sd, struct v4l2_mbus_framefmt *mf)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct soc_camera_device *icd = client->dev.platform_data;
    struct sensor *sensor = to_sensor(client);

    mf->width	= icd->user_width;
	mf->height	= icd->user_height;
	mf->code	= sensor->info_priv.fmt.code;
	mf->colorspace	= sensor->info_priv.fmt.colorspace;
	mf->field	= V4L2_FIELD_NONE;

    return 0;
}
static bool sensor_fmt_capturechk(struct v4l2_subdev *sd, struct v4l2_mbus_framefmt *mf)
{
    bool ret = false;

	if ((mf->width == 1024) && (mf->height == 768)) {
		ret = true;
	} else if ((mf->width == 1280) && (mf->height == 1024)) {
		ret = true;
	} else if ((mf->width == 1600) && (mf->height == 1200)) {
		ret = true;
	} else if ((mf->width == 2048) && (mf->height == 1536)) {
		ret = true;
	} else if ((mf->width == 2592) && (mf->height == 1944)) {
		ret = true;
	}

	if (ret == true)
		SENSOR_DG("%s %dx%d is capture format\n", __FUNCTION__, mf->width, mf->height);
	return ret;
}

static bool sensor_fmt_videochk(struct v4l2_subdev *sd, struct v4l2_mbus_framefmt *mf)
{
    bool ret = false;

	if ((mf->width == 1280) && (mf->height == 720)) {
		ret = true;
	} else if ((mf->width == 1920) && (mf->height == 1080)) {
		ret = true;
	}

	if (ret == true)
		SENSOR_DG("%s %dx%d is video format\n", __FUNCTION__, mf->width, mf->height);
	return ret;
}
static struct reginfo* sensor_fmt_catch(int set_w, int set_h, int *ret_w, int *ret_h)
{
	struct reginfo *winseqe_set_addr = NULL;
    
    if (set_w*240 == set_h*320) {        
        if (((set_w >= 320) && (set_h >= 240)) && (sensor_qvga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_qvga;
            *ret_w = 320;
            *ret_h = 240;
    	} 

#if  ADJUST_FOR_VGA_FALG    
        // to forbid preview err         
        if (((set_w >= 576) && (set_h >= 432)) && (sensor_vga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_vga;
            *ret_w = 576;
            *ret_h = 432;
        } 
#else
        if (((set_w >= 640) && (set_h >= 480)) && (sensor_vga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_vga;
            *ret_w = 640;
            *ret_h = 480;
        } 

#endif
              
        if (((set_w >= 800) && (set_h >= 600)) && (sensor_svga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_svga;
            *ret_w = 800;
            *ret_h = 600;
        } 

        if (((set_w >= 1024) && (set_h >= 768)) && (sensor_xga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_xga;
            *ret_w = 1024;
            *ret_h = 768;
    	} 
      
        if (((set_w >= 1280) && (set_h >= 1024)) && (sensor_sxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_sxga;
            *ret_w = 1280;
            *ret_h = 1024;
        }         

        if (((set_w >= 1600) && (set_h >= 1200)) && (sensor_uxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_uxga;
            *ret_w = 1600;
            *ret_h = 1200;
    	} 

        if (((set_w >= 2048) && (set_h >= 1536)) && (sensor_qxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_qxga;
            *ret_w = 2048;
            *ret_h = 1536;
        } 

        if (((set_w >= 2592) && (set_h >= 1944)) && (sensor_qsxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_qsxga;
            *ret_w = 2592;
            *ret_h = 1944;
        }

        if (winseqe_set_addr == NULL) {
            if (((set_w <= 176) && (set_h <= 144)) && (sensor_qcif[0].reg!=SEQUENCE_END)) {
        		winseqe_set_addr = sensor_qcif;
                *ret_w = 176;
                *ret_h = 144;
        	} else if (((set_w <= 352) && (set_h<= 288)) && (sensor_cif[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_cif;
                *ret_w = 352;
                *ret_h = 288;
            }

            if (((set_w <= 1280) && (set_h <= 720)) && (sensor_720p[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_720p;
                *ret_w = 1280;
                *ret_h = 720;
            } else if (((set_w <= 1920) && (set_h <= 1080)) && (sensor_1080p[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_1080p;
                *ret_w = 1920;
                *ret_h = 1080;
            } 
        }

    } else if (set_w*288 == set_h*352) {
        if (((set_w >= 176) && (set_h >= 144)) && (sensor_qcif[0].reg!=SEQUENCE_END)) {
    		winseqe_set_addr = sensor_qcif;
            *ret_w = 176;
            *ret_h = 144;
    	} else if (((set_w >= 352) && (set_h >= 288)) && (sensor_cif[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_cif;
            *ret_w = 352;
            *ret_h = 288;
        }

        if (winseqe_set_addr == NULL) {
            if (((set_w <= 320) && (set_h <= 240)) && (sensor_qvga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_qvga;
                *ret_w = 320;
                *ret_h = 240;
        	} else if (((set_w <= 640) && (set_h <= 480)) && (sensor_vga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_vga;
                *ret_w = 640;
                *ret_h = 480;
            } else if (((set_w <= 800) && (set_h <= 600)) && (sensor_svga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_svga;
                *ret_w = 800;
                *ret_h = 600;
            } else if (((set_w <= 1024) && (set_h <= 768)) && (sensor_xga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_xga;
                *ret_w = 1024;
                *ret_h = 768;
        	} else if (((set_w <= 1280) && (set_h <= 1024)) && (sensor_sxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_sxga;
                *ret_w = 1280;
                *ret_h = 1024;
            } else if (((set_w <= 1600) && (set_h <= 1200)) && (sensor_uxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_uxga;
                *ret_w = 1600;
                *ret_h = 1200;
        	} else if (((set_w <= 2048) && (set_h <= 1536)) && (sensor_qxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_qxga;
                *ret_w = 2048;
                *ret_h = 1536;
            } else if (((set_w <= 2592) && (set_h <= 1944)) && (sensor_qsxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_qsxga;
                *ret_w = 2592;
                *ret_h = 1944;
            }        


            if (((set_w <= 1280) && (set_h <= 720)) && (sensor_720p[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_720p;
                *ret_w = 1280;
                *ret_h = 720;
            } else if (((set_w <= 1920) && (set_h <= 1080)) && (sensor_1080p[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_1080p;
                *ret_w = 1920;
                *ret_h = 1080;
            }  
        }
    } else if (set_w*720 == set_h*1280) {
        if (((set_w >= 1280) && (set_h >= 720)) && (sensor_720p[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_720p;
            *ret_w = 1280;
            *ret_h = 720;
        } else if (((set_w >= 1920) && (set_h >= 1080)) && (sensor_1080p[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_1080p;
            *ret_w = 1920;
            *ret_h = 1080;
        }

        if (winseqe_set_addr == NULL) {
    
            if (((set_w <= 176) && (set_h <= 144)) && (sensor_qcif[0].reg!=SEQUENCE_END)) {
        		winseqe_set_addr = sensor_qcif;
                *ret_w = 176;
                *ret_h = 144;
        	} else if (((set_w <= 352) && (set_h<= 288)) && (sensor_cif[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_cif;
                *ret_w = 352;
                *ret_h = 288;
            }
        
            if (((set_w <= 320) && (set_h <= 240)) && (sensor_qvga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_qvga;
                *ret_w = 320;
                *ret_h = 240;
        	} else if (((set_w <= 640) && (set_h <= 480)) && (sensor_vga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_vga;
                *ret_w = 640;
                *ret_h = 480;
            } else if (((set_w <= 800) && (set_h <= 600)) && (sensor_svga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_svga;
                *ret_w = 800;
                *ret_h = 600;
            } else if (((set_w <= 1024) && (set_h <= 768)) && (sensor_xga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_xga;
                *ret_w = 1024;
                *ret_h = 768;
        	} else if (((set_w <= 1280) && (set_h <= 1024)) && (sensor_sxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_sxga;
                *ret_w = 1280;
                *ret_h = 1024;
            } else if (((set_w <= 1600) && (set_h <= 1200)) && (sensor_uxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_uxga;
                *ret_w = 1600;
                *ret_h = 1200;
        	} else if (((set_w <= 2048) && (set_h <= 1536)) && (sensor_qxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_qxga;
                *ret_w = 2048;
                *ret_h = 1536;
            } else if (((set_w <= 2592) && (set_h <= 1944)) && (sensor_qsxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_qsxga;
                *ret_w = 2592;
                *ret_h = 1944;
            } 
        }
    } else {
        if (((set_w <= 176) && (set_h <= 144)) && (sensor_qcif[0].reg!=SEQUENCE_END)) {
    		winseqe_set_addr = sensor_qcif;
            *ret_w = 176;
            *ret_h = 144;
    	} else if (((set_w <= 320) && (set_h <= 240)) && (sensor_qvga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_qvga;
            *ret_w = 320;
            *ret_h = 240;
    	} else if (((set_w <= 352) && (set_h<= 288)) && (sensor_cif[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_cif;
            *ret_w = 352;
            *ret_h = 288;
        } else if (((set_w <= 640) && (set_h <= 480)) && (sensor_vga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_vga;
            *ret_w = 640;
            *ret_h = 480;
        } else if (((set_w <= 800) && (set_h <= 600)) && (sensor_svga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_svga;
            *ret_w = 800;
            *ret_h = 600;
        } else if (((set_w <= 1024) && (set_h <= 768)) && (sensor_xga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_xga;
            *ret_w = 1024;
            *ret_h = 768;
    	} else if (((set_w <= 1280) && (set_h <= 720)) && (sensor_720p[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_720p;
            *ret_w = 1280;
            *ret_h = 720;
        } else if (((set_w <= 1280) && (set_h <= 1024)) && (sensor_sxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_sxga;
            *ret_w = 1280;
            *ret_h = 1024;
        } else if (((set_w <= 1600) && (set_h <= 1200)) && (sensor_uxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_uxga;
            *ret_w = 1600;
            *ret_h = 1200;
    	} else if (((set_w <= 1920) && (set_h <= 1080)) && (sensor_1080p[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_1080p;
            *ret_w = 1920;
            *ret_h = 1080;
        } else if (((set_w <= 2048) && (set_h <= 1536)) && (sensor_qxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_qxga;
            *ret_w = 2048;
            *ret_h = 1536;
        } else if (((set_w <= 2592) && (set_h <= 1944)) && (sensor_qsxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_qsxga;
            *ret_w = 2592;
            *ret_h = 1944;
        }        
    }
    
	return winseqe_set_addr;
}

/*modify image with resolution 2592*1944;solve bug that the first 32 pixel data*/
/*in the first line have misplace with the last 32 pixel data in the last line*/
static int sensor_cb(void *arg)
{
   void __iomem *vbpmem;
   struct videobuf_buffer *buffer;
   char *imagey_addr =NULL;
   char *imageuv_addr = NULL;
   char *tempaddr = NULL;
   int  tempsize = 0;
   
   buffer = (struct videobuf_buffer*)arg; 
   if(buffer->width!=SENSOR_MAX_WIDTH||buffer->height!=SENSOR_MAX_HEIGHT||buffer==NULL)
    return -EINVAL;
 
   if (buffer->bsize< YUV420_BUFFER_MAX_SIZE)        //yuv420 format size
    return -EINVAL;

   
   vbpmem = ioremap(buffer->boff,buffer->bsize);
   if(vbpmem == NULL) {
      SENSOR_DG("\n%s..%s..ioremap fail\n",__FUNCTION__,SENSOR_NAME_STRING());
      return -ENXIO;
   }
     
   imagey_addr = (char*)vbpmem;         // y data  to be dealed with
   imageuv_addr = imagey_addr+buffer->width*buffer->height;
   
   tempaddr =  imageuv_addr - 32;  
   memcpy(tempaddr,imagey_addr,32);

   tempaddr = imagey_addr+32;
   memcpy(imagey_addr,tempaddr,32);

                                      //uv data to be dealed with
   tempsize  = YUV420_BUFFER_MAX_SIZE-32;                              
   tempaddr = imagey_addr+tempsize;
   memcpy(tempaddr,imageuv_addr,32);

   tempaddr = imageuv_addr+32;
   memcpy(imageuv_addr,tempaddr,32);
   return 0;
}
static int sensor_s_fmt(struct v4l2_subdev *sd, struct v4l2_mbus_framefmt *mf)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct soc_camera_device *icd = client->dev.platform_data;
    struct sensor *sensor = to_sensor(client);
    const struct sensor_datafmt *fmt;
    struct reginfo *winseqe_set_addr=NULL;
    int ret = 0, set_w,set_h,cnt;
    u16 seq_state=0;
    int time = 0;
    u16 targetbrightness,realbrightness;
    
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());

	fmt = sensor_find_datafmt(mf->code, sensor_colour_fmts,
				   ARRAY_SIZE(sensor_colour_fmts));
	if (!fmt) {
        ret = -EINVAL;
        goto sensor_s_fmt_end;
    }

	if (sensor->info_priv.fmt.code != mf->code) {
		switch (mf->code)
		{
			case V4L2_MBUS_FMT_YUYV8_2X8:
			{
				winseqe_set_addr = sensor_ClrFmt_YUYV;
				break;
			}
			case V4L2_MBUS_FMT_UYVY8_2X8:
			{
				winseqe_set_addr = sensor_ClrFmt_UYVY;
				break;
			}
			default:
				break;
		}
		if (winseqe_set_addr != NULL) {
            sensor_write_array(client, winseqe_set_addr);
			sensor->info_priv.fmt.code = mf->code;
            sensor->info_priv.fmt.colorspace= mf->colorspace;            
			SENSOR_DG("%s v4l2_mbus_code:%d set success!\n", SENSOR_NAME_STRING(),mf->code);
		} else {
			SENSOR_TR("%s v4l2_mbus_code:%d is invalidate!\n", SENSOR_NAME_STRING(),mf->code);
		}
	}

    set_w = mf->width;
    set_h = mf->height;

	winseqe_set_addr = sensor_fmt_catch(set_w, set_h, &set_w, &set_h);

    if ((winseqe_set_addr  != sensor->info_priv.winseqe_cur_addr) && winseqe_set_addr)
    { 
       /*solve bug that video set is ineffective */
       /*set five times to make sure sensor_720p set go into effect*/
        if(winseqe_set_addr==sensor_720p)
        {
          time = 5;
        }else{
          time = 1;
        }
        
        while(time > 0)
        {
           time--;
           ret |= sensor_write_array(client, winseqe_set_addr);
           if (ret != 0) {
                SENSOR_TR("%s set format capability failed\n", SENSOR_NAME_STRING());
                goto sensor_s_fmt_end;
           }
           udelay(10);
        }
        sensor->info_priv.winseqe_cur_addr  = winseqe_set_addr;
		if (winseqe_set_addr==sensor_qxga ||winseqe_set_addr==sensor_qsxga||winseqe_set_addr==sensor_uxga ||winseqe_set_addr==sensor_xga)
        {
        	SENSOR_DG("\n%s..%s..Capture icd->width = %d.. icd->height %d\n",SENSOR_NAME_STRING(),__FUNCTION__,set_w,set_h);
		} else {
			SENSOR_DG("\n%s..%s..Video icd->width = %d.. icd->height %d\n",SENSOR_NAME_STRING(),__FUNCTION__,set_w,set_h);
			sensor->info_priv.preview_w = mf->width;
			sensor->info_priv.preview_h = mf->height;
		}
    }

	if (winseqe_set_addr && (winseqe_set_addr==sensor_qxga ||winseqe_set_addr==sensor_qsxga||winseqe_set_addr==sensor_uxga ||winseqe_set_addr==sensor_xga)) 
     {
		ret |= sensor_write_array(client, sensor_Preview2Capture);      
		if (ret != 0) {
        	SENSOR_TR("%s Preview 2 Capture failed\n", SENSOR_NAME_STRING());
        	goto sensor_s_fmt_end;
    	}

      /*check state of register 0x8405 to make sure set is successful*/
      /*set sensor_Preview2Capture more times to make sure set go into effect */
        cnt = 0;
        time  =0;
        do{                      
            ret =  0;
            msleep(50);   
            ret =sensor_read(client,0x8405, &seq_state);
            if (ret < 0)
              goto sensor_s_fmt_end;
            cnt++;
            if(cnt > 9)
            {
                time++;
                cnt = 0;
        		ret |= sensor_write_array(client, sensor_Preview2Capture);      
        		if (ret != 0||time >2) {
                	SENSOR_TR("%s Preview 2 Capture failed\n", SENSOR_NAME_STRING());
                	goto sensor_s_fmt_end;
            	}
                SENSOR_DG("mt9p111 Preview 2 Capture again\n");
            }
            SENSOR_DG("mt9p111 Preview 2 Capture count = %d;seq_state = 0x%x\n",cnt,seq_state);
         } while((seq_state != 0x07) && (time < 4));

       SENSOR_TR("%s Preview 2 Capture successs\n", SENSOR_NAME_STRING());

      #if CONFIG_SENSOR_Flash
       /*The 0xA409 is AE target register address.*/
       /*The 0xB804 is currently total brightness Y value of sensor.*/
       targetbrightness = 0;
       realbrightness =0;
       if((sensor->info_priv.flash == 1) || (sensor->info_priv.flash == 2))
       {
          if(sensor->info_priv.flash == 1)
          {
            ret =sensor_read(client,0xA409, &targetbrightness);
            if (ret < 0)
              SENSOR_DG("%s ..%s..get targetbrightness fail\n", SENSOR_NAME_STRING(),__FUNCTION__);
            
            ret =sensor_read(client, 0xB804, &realbrightness);
            if (ret < 0)
              SENSOR_DG("%s ..%s..get realbrightness fail\n", SENSOR_NAME_STRING(),__FUNCTION__);
          }
         
          if((realbrightness < targetbrightness)|| (sensor->info_priv.flash == 2))
          {
            sensor_ioctrl(icd, Sensor_Flash, Flash_On);
            SENSOR_DG("%s flash on,realbrightness=%d,targetbrightness=%d\n", SENSOR_NAME_STRING(),realbrightness,targetbrightness);
          }else{
            SENSOR_DG("%s not need to flash in capture!\n", SENSOR_NAME_STRING());
          }
        }
      #endif        
		sensor->info_priv.capture_w = set_w;
		sensor->info_priv.capture_h = set_h;
		sensor->info_priv.snap2preview = true;
	} else if (sensor->info_priv.snap2preview == true) {
		if (winseqe_set_addr || ((sensor->info_priv.preview_w == mf->width) && (sensor->info_priv.preview_h == mf->height))) {
			ret |= sensor_write_array(client, sensor_Capture2Preview);
			if (ret != 0) {
	        	SENSOR_TR("%s Capture 2 Preview success\n", SENSOR_NAME_STRING());
	        	goto sensor_s_fmt_end;
	    	}
            
            cnt = 0;
            do{                                    //check state of register 0x8405 to make sure set is successful
                ret =  0;
                msleep(50);   
                ret =sensor_read(client,0x8405, &seq_state);
                if (ret < 0)
                  goto sensor_s_fmt_end;
                SENSOR_DG("mt9p111 Capture 2 Preview seq_state = 0x%x\n",seq_state);
              } while((seq_state != 0x03) && (cnt < 20));
            
            SENSOR_TR("%s Capture 2 Preview success\n", SENSOR_NAME_STRING());

            #if CONFIG_SENSOR_Flash
            if ((sensor->info_priv.flash == 1) || (sensor->info_priv.flash == 2)) {
                sensor_ioctrl(icd, Sensor_Flash, Flash_Off);
                SENSOR_DG("%s flash off in preivew!\n", SENSOR_NAME_STRING());
            }
            #endif        
    		sensor->info_priv.preview_w = mf->width;
    		sensor->info_priv.preview_h = mf->height;
    		sensor->info_priv.snap2preview = false;
		} else {
			SENSOR_TR("\n %s..%s Format is Invalidate. pix->width = %d.. pix->height = %d\n",SENSOR_NAME_STRING(),__FUNCTION__,mf->width,mf->height);
		}
	}

	mf->width = set_w;
	mf->height = set_h;
sensor_s_fmt_end:
    return ret;
}

static int sensor_try_fmt(struct v4l2_subdev *sd, struct v4l2_mbus_framefmt *mf)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct sensor *sensor = to_sensor(client);
    const struct sensor_datafmt *fmt;
    int ret = 0;
   
	fmt = sensor_find_datafmt(mf->code, sensor_colour_fmts,
				   ARRAY_SIZE(sensor_colour_fmts));
	if (fmt == NULL) {
		fmt = &sensor->info_priv.fmt;
        mf->code = fmt->code;
	} 

    if (mf->height > SENSOR_MAX_HEIGHT)
        mf->height = SENSOR_MAX_HEIGHT;
    else if (mf->height < SENSOR_MIN_HEIGHT)
        mf->height = SENSOR_MIN_HEIGHT;

    if (mf->width > SENSOR_MAX_WIDTH)
        mf->width = SENSOR_MAX_WIDTH;
    else if (mf->width < SENSOR_MIN_WIDTH)
        mf->width = SENSOR_MIN_WIDTH;
    if (sensor_fmt_catch(mf->width, mf->height, &mf->width, &mf->height) == NULL) {
		mf->width = 0;
		mf->height = 0;
	}
    mf->colorspace = fmt->colorspace;
    
    return ret;
}
 static int sensor_g_chip_ident(struct v4l2_subdev *sd, struct v4l2_dbg_chip_ident *id)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);

    if (id->match.type != V4L2_CHIP_MATCH_I2C_ADDR)
        return -EINVAL;

    if (id->match.addr != client->addr)
        return -ENODEV;

    id->ident = SENSOR_V4L2_IDENT;      /* ddl@rock-chips.com :  Return OV2655  identifier */
    id->revision = 0;

    return 0;
}
#if CONFIG_SENSOR_Brightness
static int sensor_set_brightness(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_BrightnessSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_BrightnessSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
	SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Effect
static int sensor_set_effect(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    int time =5;
    int ret =0 ;
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_EffectSeqe[value - qctrl->minimum] != NULL)
        {
           /*set five times to make sure the set go into effect*/
           /*solve bug for setting invalidate during changing from preview to video*/
            while(time >0)
            {
                time--;
                ret |=sensor_write_array(client, sensor_EffectSeqe[value - qctrl->minimum]);
                if(ret != 0)
                {  
                    SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                    return -EINVAL;
                }
                msleep(50);   
            }       
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
	SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Exposure
static int sensor_set_exposure(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_ExposureSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_ExposureSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
	SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Saturation
static int sensor_set_saturation(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_SaturationSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_SaturationSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
    SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Contrast
static int sensor_set_contrast(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_ContrastSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_ContrastSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
    SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Mirror
static int sensor_set_mirror(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_MirrorSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_MirrorSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
    SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Flip
static int sensor_set_flip(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_FlipSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_FlipSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
    SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Scene
static int sensor_set_scene(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_SceneSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_SceneSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
    SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_WhiteBalance
static int sensor_set_whiteBalance(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_WhiteBalanceSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_WhiteBalanceSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
	SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_DigitalZoom
static int sensor_set_digitalzoom(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
    struct sensor *sensor = to_sensor(client);
	const struct v4l2_queryctrl *qctrl_info;
    int digitalzoom_cur, digitalzoom_total;

	qctrl_info = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_ZOOM_ABSOLUTE);
	if (qctrl_info)
		return -EINVAL;

    digitalzoom_cur = sensor->info_priv.digitalzoom;
    digitalzoom_total = qctrl_info->maximum;

    if ((value > 0) && (digitalzoom_cur >= digitalzoom_total))
    {
        SENSOR_TR("%s digitalzoom is maximum - %x\n", SENSOR_NAME_STRING(), digitalzoom_cur);
        return -EINVAL;
    }

    if  ((value < 0) && (digitalzoom_cur <= qctrl_info->minimum))
    {
        SENSOR_TR("%s digitalzoom is minimum - %x\n", SENSOR_NAME_STRING(), digitalzoom_cur);
        return -EINVAL;
    }

    if ((value > 0) && ((digitalzoom_cur + value) > digitalzoom_total))
    {
        value = digitalzoom_total - digitalzoom_cur;
    }

    if ((value < 0) && ((digitalzoom_cur + value) < 0))
    {
        value = 0 - digitalzoom_cur;
    }

    digitalzoom_cur += value;

    if (sensor_ZoomSeqe[digitalzoom_cur] != NULL)
    {
        if (sensor_write_array(client, sensor_ZoomSeqe[digitalzoom_cur]) != 0)
        {
            SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
            return -EINVAL;
        }
        SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
        return 0;
    }

    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Flash
static int sensor_set_flash(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{    
    if ((value >= qctrl->minimum) && (value <= qctrl->maximum)) {
        if (value == 3) {       /* ddl@rock-chips.com: torch */
	printk("=====sensor_set_flash======  Flash On\n");
            sensor_ioctrl(icd, Sensor_Flash, Flash_Torch);   /* Flash On */
        } else {
        printk("=====sensor_set_flash======  Flash off\n");
            sensor_ioctrl(icd, Sensor_Flash, Flash_Off);
        }
        SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
        return 0;
    }
    
	SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Focus
static int sensor_set_focus_absolute(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
	struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
    struct sensor *sensor = to_sensor(client);
	const struct v4l2_queryctrl *qctrl_info;
	int ret = 0;

	qctrl_info = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_FOCUS_ABSOLUTE);
	if (!qctrl_info)
		return -EINVAL;

	if ((sensor->info_priv.funmodule_state & SENSOR_AF_IS_OK) && (sensor->info_priv.affm_reinit == 0)) {
		if ((value >= qctrl_info->minimum) && (value <= qctrl_info->maximum)) {

			SENSOR_DG("%s..%s : %d  ret:0x%x\n",SENSOR_NAME_STRING(),__FUNCTION__, value,ret);
		} else {
			ret = -EINVAL;
			SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
		}
	} else {
		ret = -EACCES;
		SENSOR_TR("\n %s..%s AF module state(0x%x, 0x%x) is error!\n",SENSOR_NAME_STRING(),__FUNCTION__,
			sensor->info_priv.funmodule_state,sensor->info_priv.affm_reinit);
	}

sensor_set_focus_absolute_end:
	return ret;
}
static int sensor_set_focus_relative(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
	struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
	struct sensor *sensor = to_sensor(client);
	const struct v4l2_queryctrl *qctrl_info;
	int ret = 0;

	qctrl_info = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_FOCUS_RELATIVE);
	if (!qctrl_info)
		return -EINVAL;

	if ((sensor->info_priv.funmodule_state & SENSOR_AF_IS_OK) && (sensor->info_priv.affm_reinit == 0)) {
		if ((value >= qctrl_info->minimum) && (value <= qctrl_info->maximum)) {

			SENSOR_DG("%s..%s : %d  ret:0x%x\n",SENSOR_NAME_STRING(),__FUNCTION__, value,ret);
		} else {
			ret = -EINVAL;
			SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
		}
	} else {
		ret = -EACCES;
		SENSOR_TR("\n %s..%s AF module state(0x%x, 0x%x) is error!\n",SENSOR_NAME_STRING(),__FUNCTION__,
			sensor->info_priv.funmodule_state,sensor->info_priv.affm_reinit);
	}
sensor_set_focus_relative_end:
	return ret;
}

static int sensor_set_focus_mode(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value, int *zone_pos)
{
	struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
	struct sensor *sensor = to_sensor(client);
	int ret = 0;
    
	if ((sensor->info_priv.funmodule_state & SENSOR_AF_IS_OK)  && (sensor->info_priv.affm_reinit == 0)) {
		switch (value)
		{
			case SENSOR_AF_MODE_AUTO:
			{
				ret = sensor_af_workqueue_set(icd, WqCmd_af_single, 0, true, zone_pos);
				break;
			}

			/*case SENSOR_AF_MODE_MACRO:
			{
				ret = sensor_set_focus_absolute(icd, qctrl, 0xff);
				break;
			}

			case SENSOR_AF_MODE_INFINITY:
			{
				ret = sensor_set_focus_absolute(icd, qctrl, 0x00);
				break;
			}
			*/
			case SENSOR_AF_MODE_CONTINUOUS:
			{
				ret = sensor_af_workqueue_set(icd, WqCmd_af_continues, 0, true,NULL);
				break;
			}
			default:
				SENSOR_TR("\n %s..%s AF value(0x%x) is error!\n",SENSOR_NAME_STRING(),__FUNCTION__,value);
				break;

		}

		SENSOR_DG("%s..%s : %d  ret:0x%x\n",SENSOR_NAME_STRING(),__FUNCTION__, value,ret);
	} else {
		ret = -EACCES;
		SENSOR_TR("\n %s..%s AF module state(0x%x, 0x%x) is error!\n",SENSOR_NAME_STRING(),__FUNCTION__,
			sensor->info_priv.funmodule_state,sensor->info_priv.affm_reinit);
	}

	return ret;

}
#endif
static int sensor_g_control(struct v4l2_subdev *sd, struct v4l2_control *ctrl)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct sensor *sensor = to_sensor(client);
    const struct v4l2_queryctrl *qctrl;
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());

    qctrl = soc_camera_find_qctrl(&sensor_ops, ctrl->id);

    if (!qctrl)
    {
        SENSOR_TR("\n %s ioctrl id = 0x%x  is invalidate \n", SENSOR_NAME_STRING(), ctrl->id);
        return -EINVAL;
    }

    switch (ctrl->id)
    {
        case V4L2_CID_BRIGHTNESS:
            {
                ctrl->value = sensor->info_priv.brightness;
                break;
            }
        case V4L2_CID_SATURATION:
            {
                ctrl->value = sensor->info_priv.saturation;
                break;
            }
        case V4L2_CID_CONTRAST:
            {
                ctrl->value = sensor->info_priv.contrast;
                break;
            }
        case V4L2_CID_DO_WHITE_BALANCE:
            {
                ctrl->value = sensor->info_priv.whiteBalance;
                break;
            }
        case V4L2_CID_EXPOSURE:
            {
                ctrl->value = sensor->info_priv.exposure;
                break;
            }
        case V4L2_CID_HFLIP:
            {
                ctrl->value = sensor->info_priv.mirror;
                break;
            }
        case V4L2_CID_VFLIP:
            {
                ctrl->value = sensor->info_priv.flip;
                break;
            }
        default :
                break;
    }
    return 0;
}



static int sensor_s_control(struct v4l2_subdev *sd, struct v4l2_control *ctrl)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct sensor *sensor = to_sensor(client);
    struct soc_camera_device *icd = client->dev.platform_data;
    const struct v4l2_queryctrl *qctrl;
    
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());


    qctrl = soc_camera_find_qctrl(&sensor_ops, ctrl->id);

    if (!qctrl)
    {
        SENSOR_TR("\n %s ioctrl id = 0x%x  is invalidate \n", SENSOR_NAME_STRING(), ctrl->id);
        return -EINVAL;
    }

    switch (ctrl->id)
    {
#if CONFIG_SENSOR_Brightness
        case V4L2_CID_BRIGHTNESS:
            {
                if (ctrl->value != sensor->info_priv.brightness)
                {
                    if (sensor_set_brightness(icd, qctrl,ctrl->value) != 0)
                    {
                        return -EINVAL;
                    }
                    sensor->info_priv.brightness = ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_Exposure
        case V4L2_CID_EXPOSURE:
            {
                if (ctrl->value != sensor->info_priv.exposure)
                {
                    if (sensor_set_exposure(icd, qctrl,ctrl->value) != 0)
                    {
                        return -EINVAL;
                    }
                    sensor->info_priv.exposure = ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_Saturation
        case V4L2_CID_SATURATION:
            {
                if (ctrl->value != sensor->info_priv.saturation)
                {
                    if (sensor_set_saturation(icd, qctrl,ctrl->value) != 0)
                    {
                        return -EINVAL;
                    }
                    sensor->info_priv.saturation = ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_Contrast
        case V4L2_CID_CONTRAST:
            {
                if (ctrl->value != sensor->info_priv.contrast)
                {
                    if (sensor_set_contrast(icd, qctrl,ctrl->value) != 0)
                    {
                        return -EINVAL;
                    }
                    sensor->info_priv.contrast = ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_WhiteBalance
        case V4L2_CID_DO_WHITE_BALANCE:
            {
                if (ctrl->value != sensor->info_priv.whiteBalance)
                {
                    if (sensor_set_whiteBalance(icd, qctrl,ctrl->value) != 0)
                    {
                        return -EINVAL;
                    }
                    sensor->info_priv.whiteBalance = ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_Mirror
        case V4L2_CID_HFLIP:
            {
                if (ctrl->value != sensor->info_priv.mirror)
                {
                    if (sensor_set_mirror(icd, qctrl,ctrl->value) != 0)
                        return -EINVAL;
                    sensor->info_priv.mirror = ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_Flip
        case V4L2_CID_VFLIP:
            {
                if (ctrl->value != sensor->info_priv.flip)
                {
                    if (sensor_set_flip(icd, qctrl,ctrl->value) != 0)
                        return -EINVAL;
                    sensor->info_priv.flip = ctrl->value;
                }
                break;
            }
#endif
        default:
            break;
    }

    return 0;
}
static int sensor_g_ext_control(struct soc_camera_device *icd , struct v4l2_ext_control *ext_ctrl)
{
    const struct v4l2_queryctrl *qctrl;
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
    struct sensor *sensor = to_sensor(client);
    
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());

    qctrl = soc_camera_find_qctrl(&sensor_ops, ext_ctrl->id);

    if (!qctrl)
    {
        SENSOR_TR("\n %s ioctrl id = 0x%x  is invalidate \n", SENSOR_NAME_STRING(), ext_ctrl->id);
        return -EINVAL;
    }

    switch (ext_ctrl->id)
    {
        case V4L2_CID_SCENE:
            {
                ext_ctrl->value = sensor->info_priv.scene;
                break;
            }
        case V4L2_CID_EFFECT:
            {
                ext_ctrl->value = sensor->info_priv.effect;
                break;
            }
        case V4L2_CID_ZOOM_ABSOLUTE:
            {
                ext_ctrl->value = sensor->info_priv.digitalzoom;
                break;
            }
        case V4L2_CID_ZOOM_RELATIVE:
            {
                return -EINVAL;
            }
        case V4L2_CID_FOCUS_ABSOLUTE:
            {
                return -EINVAL;
            }
        case V4L2_CID_FOCUS_RELATIVE:
            {
                return -EINVAL;
            }
        case V4L2_CID_FLASH:
            {
                ext_ctrl->value = sensor->info_priv.flash;
                break;
            }
        default :
            break;
    }
    return 0;
}
static int sensor_s_ext_control(struct soc_camera_device *icd, struct v4l2_ext_control *ext_ctrl)
{
    const struct v4l2_queryctrl *qctrl;
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
    struct sensor *sensor = to_sensor(client);
    int val_offset;

    qctrl = soc_camera_find_qctrl(&sensor_ops, ext_ctrl->id);

    if (!qctrl)
    {
        SENSOR_TR("\n %s ioctrl id = 0x%x  is invalidate \n", SENSOR_NAME_STRING(), ext_ctrl->id);
        return -EINVAL;
    }

	val_offset = 0;
    switch (ext_ctrl->id)
    {
#if CONFIG_SENSOR_Scene
        case V4L2_CID_SCENE:
            {
                if (ext_ctrl->value != sensor->info_priv.scene)
                {
                    if (sensor_set_scene(icd, qctrl,ext_ctrl->value) != 0)
                        return -EINVAL;
                    sensor->info_priv.scene = ext_ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_Effect
        case V4L2_CID_EFFECT:
            {
                if (ext_ctrl->value != sensor->info_priv.effect)
                {
                    if (sensor_set_effect(icd, qctrl,ext_ctrl->value) != 0)
                        return -EINVAL;
                    sensor->info_priv.effect= ext_ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_DigitalZoom
        case V4L2_CID_ZOOM_ABSOLUTE:
            {
                if ((ext_ctrl->value < qctrl->minimum) || (ext_ctrl->value > qctrl->maximum))
                    return -EINVAL;

                if (ext_ctrl->value != sensor->info_priv.digitalzoom)
                {
                    val_offset = ext_ctrl->value -sensor->info_priv.digitalzoom;

                    if (sensor_set_digitalzoom(icd, qctrl,&val_offset) != 0)
                        return -EINVAL;
                    sensor->info_priv.digitalzoom += val_offset;

                    SENSOR_DG("%s digitalzoom is %x\n",SENSOR_NAME_STRING(),  sensor->info_priv.digitalzoom);
                }

                break;
            }
        case V4L2_CID_ZOOM_RELATIVE:
            {
                if (ext_ctrl->value)
                {
                    if (sensor_set_digitalzoom(icd, qctrl,&ext_ctrl->value) != 0)
                        return -EINVAL;
                    sensor->info_priv.digitalzoom += ext_ctrl->value;

                    SENSOR_DG("%s digitalzoom is %x\n", SENSOR_NAME_STRING(), sensor->info_priv.digitalzoom);
                }
                break;
            }
#endif
#if CONFIG_SENSOR_Focus
        #if 0
        case V4L2_CID_FOCUS_ABSOLUTE:
            {
                if ((ext_ctrl->value < qctrl->minimum) || (ext_ctrl->value > qctrl->maximum))
                    return -EINVAL;

				if (sensor_set_focus_absolute(icd, qctrl,ext_ctrl->value) == 0) {
					if (ext_ctrl->value == qctrl->minimum) {
						sensor->info_priv.auto_focus = SENSOR_AF_MODE_INFINITY;
					} else if (ext_ctrl->value == qctrl->maximum) {
						sensor->info_priv.auto_focus = SENSOR_AF_MODE_MACRO;
					} else {
						sensor->info_priv.auto_focus = SENSOR_AF_MODE_FIXED;
					}
				}

                break;
            }
        case V4L2_CID_FOCUS_RELATIVE:
            {
                if ((ext_ctrl->value < qctrl->minimum) || (ext_ctrl->value > qctrl->maximum))
                    return -EINVAL;

                sensor_set_focus_relative(icd, qctrl,ext_ctrl->value);
                break;
            }
        #endif
		case V4L2_CID_FOCUS_AUTO:
			{
				if (ext_ctrl->value) {
                    if ((ext_ctrl->value==1) || (SENSOR_AF_MODE_AUTO == sensor->info_priv.auto_focus)) {
    					if (sensor_set_focus_mode(icd, qctrl,SENSOR_AF_MODE_AUTO,ext_ctrl->rect) != 0) {
    						if(0 == (sensor->info_priv.funmodule_state & SENSOR_AF_IS_OK)) {
    							sensor->info_priv.auto_focus = SENSOR_AF_MODE_AUTO;
    						}
    						return -EINVAL;
    					}
                    }
                    if (ext_ctrl->value == 1)
					    sensor->info_priv.auto_focus = SENSOR_AF_MODE_AUTO;
				} else if (SENSOR_AF_MODE_AUTO == sensor->info_priv.auto_focus){
					if (ext_ctrl->value == 0)
						sensor->info_priv.auto_focus = SENSOR_AF_MODE_CLOSE;
				} 
				break;
			}
		case V4L2_CID_FOCUS_CONTINUOUS:
			{
				if (SENSOR_AF_MODE_CONTINUOUS != sensor->info_priv.auto_focus) {
					if (ext_ctrl->value == 1) {
						if (sensor_set_focus_mode(icd, qctrl,SENSOR_AF_MODE_CONTINUOUS,NULL) != 0) {
    						if(0 == (sensor->info_priv.funmodule_state & SENSOR_AF_IS_OK)) {
    							sensor->info_priv.auto_focus = SENSOR_AF_MODE_CONTINUOUS;
    						}
    						return -EINVAL;
						}
						sensor->info_priv.auto_focus = SENSOR_AF_MODE_CONTINUOUS;
					}
				} else {
					if (ext_ctrl->value == 0)
						sensor->info_priv.auto_focus = SENSOR_AF_MODE_CLOSE;
				}
				break;
			}
#endif
#if CONFIG_SENSOR_Flash
        case V4L2_CID_FLASH:
            {
                if (sensor_set_flash(icd, qctrl,ext_ctrl->value) != 0)
                    return -EINVAL;
                sensor->info_priv.flash = ext_ctrl->value;

                SENSOR_DG("%s flash is %x\n",SENSOR_NAME_STRING(), sensor->info_priv.flash);
                break;
            }
#endif
        default:
            break;
    }

    return 0;
}

static int sensor_g_ext_controls(struct v4l2_subdev *sd, struct v4l2_ext_controls *ext_ctrl)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct soc_camera_device *icd = client->dev.platform_data;
    int i, error_cnt=0, error_idx=-1;
    
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());


    for (i=0; i<ext_ctrl->count; i++) {
        if (sensor_g_ext_control(icd, &ext_ctrl->controls[i]) != 0) {
            error_cnt++;
            error_idx = i;
        }
    }

    if (error_cnt > 1)
        error_idx = ext_ctrl->count;

    if (error_idx != -1) {
        ext_ctrl->error_idx = error_idx;
        return -EINVAL;
    } else {
        return 0;
    }
}

static int sensor_s_ext_controls(struct v4l2_subdev *sd, struct v4l2_ext_controls *ext_ctrl)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct soc_camera_device *icd = client->dev.platform_data;
    int i, error_cnt=0, error_idx=-1;
    
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());

    for (i=0; i<ext_ctrl->count; i++) {
        if (sensor_s_ext_control(icd, &ext_ctrl->controls[i]) != 0) {
            error_cnt++;
            error_idx = i;
        }
    }

    if (error_cnt > 1)
        error_idx = ext_ctrl->count;

    if (error_idx != -1) {
        ext_ctrl->error_idx = error_idx;
        return -EINVAL;
    } else {
        return 0;
    }
}

static int sensor_s_stream(struct v4l2_subdev *sd, int enable)
{
	struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct sensor *sensor = to_sensor(client);
	#if CONFIG_SENSOR_Focus
	struct soc_camera_device *icd = client->dev.platform_data;
	struct v4l2_mbus_framefmt mf;
	#endif
    
	if (enable == 1) {
		sensor->info_priv.enable = 1;
		#if CONFIG_SENSOR_Focus
		mf.width	= icd->user_width;
    	mf.height	= icd->user_height;
    	mf.code	= sensor->info_priv.fmt.code;
    	mf.colorspace	= sensor->info_priv.fmt.colorspace;
    	mf.field	= V4L2_FIELD_NONE;
		/* If auto focus firmware haven't download success, must download firmware again when in video or preview stream on */
		if (sensor_fmt_capturechk(sd, &mf) == false) {
			if ((sensor->info_priv.affm_reinit == 1) || ((sensor->info_priv.funmodule_state & SENSOR_AF_IS_OK)==0)) {
                sensor_af_workqueue_set(icd, WqCmd_af_init, 0, false,NULL);
				sensor->info_priv.affm_reinit = 0;
			}
		}
		#endif
	} else if (enable == 0) {
	    sensor->info_priv.enable = 0;
		#if CONFIG_SENSOR_Focus	
        flush_workqueue(sensor->sensor_wq);
		#endif
	}
	return 0;
}

/* Interface active, can use i2c. If it fails, it can indeed mean, that
 * this wasn't our capture interface, so, we wait for the right one */
static int sensor_video_probe(struct soc_camera_device *icd,
			       struct i2c_client *client)
{
    int ret,pid = 0;
    struct sensor *sensor = to_sensor(client);
#if (SENSOR_RESET_REG != SEQUENCE_END)
    struct reginfo reg_info;
#endif
    /* We must have a parent by now. And it cannot be a wrong one.
     * So this entire test is completely redundant. */
    if (!icd->dev.parent ||
	    to_soc_camera_host(icd->dev.parent)->nr != icd->iface)
		return -ENODEV;

	if (sensor_ioctrl(icd, Sensor_PowerDown, 0) < 0) {
		ret = -ENODEV;
		goto sensor_video_probe_err;
	}

    /* soft reset */
#if (SENSOR_RESET_REG != SEQUENCE_END)   
	reg_info.reg = SENSOR_RESET_REG;
	reg_info.val = SENSOR_RESET_VAL;
	reg_info.reg_len = SENSOR_RESET_REG_LEN;
    ret = sensor_write(client, &reg_info);
    if (ret != 0) {
        SENSOR_TR("%s soft reset sensor failed\n",SENSOR_NAME_STRING());
        ret = -ENODEV;
		goto sensor_video_probe_err;
    }

    mdelay(5);  //delay 5 microseconds
#endif

	/* check if it is an sensor sensor */
#if (SENSOR_ID_REG != SEQUENCE_END)
    ret = sensor_read(client, SENSOR_ID_REG, &pid);
    if (ret != 0) {
        SENSOR_TR("read chip id failed\n");
        ret = -ENODEV;
        goto sensor_video_probe_err;
    }

    SENSOR_DG("\n %s  pid = 0x%x \n", SENSOR_NAME_STRING(), pid);
#else
	pid = SENSOR_ID;
#endif

    if (pid == SENSOR_ID) {
        sensor->model = SENSOR_V4L2_IDENT;
    } else {
        SENSOR_TR("error: %s mismatched   pid = 0x%x\n", SENSOR_NAME_STRING(), pid);
        ret = -ENODEV;
        goto sensor_video_probe_err;
    }

    return 0;

sensor_video_probe_err:

    return ret;
}
static long sensor_ioctl(struct v4l2_subdev *sd, unsigned int cmd, void *arg)
{
	struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct soc_camera_device *icd = client->dev.platform_data;
    struct sensor *sensor = to_sensor(client);
//#if CONFIG_SENSOR_Flash	
    int i;
//#endif
    int ret = 0;
    
    rk29_camera_sensor_cb_s *icd_cb =NULL;
    
	SENSOR_DG("\n%s..%s..cmd:%x \n",SENSOR_NAME_STRING(),__FUNCTION__,cmd);
	switch (cmd)
	{
		case RK29_CAM_SUBDEV_DEACTIVATE:
		{
			sensor_deactivate(client);
			break;
		}
		case RK29_CAM_SUBDEV_IOREQUEST:
		{
			sensor->sensor_io_request = (struct rk29camera_platform_data*)arg;           
            if (sensor->sensor_io_request != NULL) { 
                sensor->sensor_gpio_res = NULL;
                for (i=0; i<RK29_CAM_SUPPORT_NUMS;i++) {
                    if (sensor->sensor_io_request->gpio_res[i].dev_name && 
                        (strcmp(sensor->sensor_io_request->gpio_res[i].dev_name, dev_name(icd->pdev)) == 0)) {
                        sensor->sensor_gpio_res = (struct rk29camera_gpio_res*)&sensor->sensor_io_request->gpio_res[i];
                    }
                }
                if (sensor->sensor_gpio_res == NULL) {
                    SENSOR_TR("%s %s obtain gpio resource failed when RK29_CAM_SUBDEV_IOREQUEST \n",SENSOR_NAME_STRING(),__FUNCTION__);
                    ret = -EINVAL;
                    goto sensor_ioctl_end;
                }
            } else {
                SENSOR_TR("%s %s RK29_CAM_SUBDEV_IOREQUEST fail\n",SENSOR_NAME_STRING(),__FUNCTION__);
                ret = -EINVAL;
                goto sensor_ioctl_end;
            }
            /* ddl@rock-chips.com : if gpio_flash havn't been set in board-xxx.c, sensor driver must notify is not support flash control 
               for this project */
            #if CONFIG_SENSOR_Flash	
        	if (sensor->sensor_gpio_res) {
                if (sensor->sensor_gpio_res->gpio_flash == INVALID_GPIO) {
                    for (i = 0; i < icd->ops->num_controls; i++) {
                		if (V4L2_CID_FLASH == icd->ops->controls[i].id) {
                			//memset((char*)&icd->ops->controls[i],0x00,sizeof(struct v4l2_queryctrl));  
                              sensor_controls[i].id=0xffff;         			
                		}
                    }
                    sensor->info_priv.flash = 0xff;
                    SENSOR_DG("%s flash gpio is invalidate!\n",SENSOR_NAME_STRING());
                }else{ //two cameras are the same,need to deal diffrently ,zyc
                    for (i = 0; i < icd->ops->num_controls; i++) {
                           if(0xffff == icd->ops->controls[i].id){
                              sensor_controls[i].id=V4L2_CID_FLASH;
                           }               
                    }
                }
        	}
            #endif
			break;
		}
        case RK29_CAM_SUBDEV_CB_REGISTER:
        {
           icd_cb = (rk29_camera_sensor_cb_s*)(arg);
           icd_cb->sensor_cb = sensor_cb;
           break;    
        }
		default:
		{
			SENSOR_TR("%s %s cmd(0x%x) is unknown !\n",SENSOR_NAME_STRING(),__FUNCTION__,cmd);
			break;
		}
	}
sensor_ioctl_end:
	return ret;

}
static int sensor_enum_fmt(struct v4l2_subdev *sd, unsigned int index,
			    enum v4l2_mbus_pixelcode *code)
{
	if (index >= ARRAY_SIZE(sensor_colour_fmts))
		return -EINVAL;

	*code = sensor_colour_fmts[index].code;
	return 0;
}
static struct v4l2_subdev_core_ops sensor_subdev_core_ops = {
	.init		= sensor_init,
	.g_ctrl		= sensor_g_control,
	.s_ctrl		= sensor_s_control,
	.g_ext_ctrls          = sensor_g_ext_controls,
	.s_ext_ctrls          = sensor_s_ext_controls,
	.g_chip_ident	= sensor_g_chip_ident,
	.ioctl = sensor_ioctl,
};
static struct v4l2_subdev_video_ops sensor_subdev_video_ops = {
	.s_mbus_fmt	= sensor_s_fmt,
	.g_mbus_fmt	= sensor_g_fmt,
	.try_mbus_fmt	= sensor_try_fmt,
	.enum_mbus_fmt	= sensor_enum_fmt,
	.s_stream   = sensor_s_stream,
};
static struct v4l2_subdev_ops sensor_subdev_ops = {
	.core	= &sensor_subdev_core_ops,
	.video = &sensor_subdev_video_ops,
};

static int sensor_probe(struct i2c_client *client,
			 const struct i2c_device_id *did)
{
    struct sensor *sensor;
    struct soc_camera_device *icd = client->dev.platform_data;
    struct i2c_adapter *adapter = to_i2c_adapter(client->dev.parent);
    struct soc_camera_link *icl;
    int ret;

    SENSOR_DG("\n%s..%s..%d..\n",__FUNCTION__,__FILE__,__LINE__);
    if (!icd) {
        dev_err(&client->dev, "%s: missing soc-camera data!\n",SENSOR_NAME_STRING());
        return -EINVAL;
    }

    icl = to_soc_camera_link(icd);
    if (!icl) {
        dev_err(&client->dev, "%s driver needs platform data\n", SENSOR_NAME_STRING());
        return -EINVAL;
    }

    if (!i2c_check_functionality(adapter, I2C_FUNC_I2C)) {
        dev_warn(&adapter->dev,
        	 "I2C-Adapter doesn't support I2C_FUNC_I2C\n");
        return -EIO;
    }

    sensor = kzalloc(sizeof(struct sensor), GFP_KERNEL);
    if (!sensor)
        return -ENOMEM;

    v4l2_i2c_subdev_init(&sensor->subdev, client, &sensor_subdev_ops);

    /* Second stage probe - when a capture adapter is there */
    icd->ops		= &sensor_ops;
    sensor->info_priv.fmt = sensor_colour_fmts[0];
	#if CONFIG_SENSOR_I2C_NOSCHED
	atomic_set(&sensor->tasklock_cnt,0);
	#endif

    ret = sensor_video_probe(icd, client);
    if (ret < 0) {
        icd->ops = NULL;
        i2c_set_clientdata(client, NULL);
        kfree(sensor);
		sensor = NULL;
    } else {
        #if CONFIG_SENSOR_Focus
		sensor->sensor_wq = create_singlethread_workqueue(SENSOR_NAME_STRING(_af_workqueue));
		if (sensor->sensor_wq == NULL)
			SENSOR_TR("%s create fail!", SENSOR_NAME_STRING(_af_workqueue));
		mutex_init(&sensor->wq_lock);
		#endif
    }
	flash_off_timer.status = 0;
	hrtimer_init(&(flash_off_timer.timer), CLOCK_MONOTONIC, HRTIMER_MODE_REL);
    SENSOR_DG("\n%s..%s..%d  ret = %x \n",__FUNCTION__,__FILE__,__LINE__,ret);
    return ret;
}

static int sensor_remove(struct i2c_client *client)
{
    struct sensor *sensor = to_sensor(client);
    struct soc_camera_device *icd = client->dev.platform_data;

	#if CONFIG_SENSOR_Focus
	if (sensor->sensor_wq) {
		destroy_workqueue(sensor->sensor_wq);
		sensor->sensor_wq = NULL;
	}
	#endif

    icd->ops = NULL;
    i2c_set_clientdata(client, NULL);
    client->driver = NULL;
    kfree(sensor);
	sensor = NULL;
    return 0;
}

static const struct i2c_device_id sensor_id[] = {
	{SENSOR_NAME_STRING(), 0 },
	{ }
};
MODULE_DEVICE_TABLE(i2c, sensor_id);

static struct i2c_driver sensor_i2c_driver = {
	.driver = {
		.name = SENSOR_NAME_STRING(),
	},
	.probe		= sensor_probe,
	.remove		= sensor_remove,
	.id_table	= sensor_id,
};

static int __init sensor_mod_init(void)
{
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());
    return i2c_add_driver(&sensor_i2c_driver);
}

static void __exit sensor_mod_exit(void)
{
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());
    i2c_del_driver(&sensor_i2c_driver);
}

device_initcall_sync(sensor_mod_init);
module_exit(sensor_mod_exit);

MODULE_DESCRIPTION(SENSOR_NAME_STRING(Camera sensor driver));
MODULE_AUTHOR("ddl <kernel@rock-chips>");
MODULE_LICENSE("GPL");


