#!/bin/bash -e

PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin
function run_glmark2() {
if [ "$1" == "rk3288" ]; then
	glmark2-es2-wayland --fullscreen

elif [[  "$1" == "rk3328"  ]]; then
	glmark2-es2-wayland --fullscreen

elif [[  "$1" == "rk3399"  ]]; then
	taskset -c 4-5 glmark2-es2-wayland --fullscreen

elif [[  "$1" == "rk3399pro"  ]]; then
	taskset -c 4-5 glmark2-es2-wayland --fullscreen

elif [[  "$1" == "px30" || "$1" == "rk3326"  ]]; then
	glmark2-es2-wayland --fullscreen

elif [[  "$1" == "rk1808" || "$1" == "rk3308"  ]]; then
	echo "the chips didn't support gpu"

elif [[  "$1" == "px3se"  ]]; then
	glmark2-es2-wayland --fullscreen
else
	echo "please check if the linux support it!!!!!!!"
fi
}

COMPATIBLE=$(cat /proc/device-tree/compatible)
if [[ $(expr $COMPATIBLE : ".*rk3288") -ne 0 ]]; then
    CHIPNAME="rk3288"
elif [[ $(expr $COMPATIBLE : ".*rk3308") -ne 0 ]]; then
    CHIPNAME="rk3308"
elif [[ $(expr $COMPATIBLE : ".*rk3328") -ne 0 ]]; then
    CHIPNAME="rk3328"
elif [[ $(expr $COMPATIBLE : ".*rk3399") -ne 0 ]]; then
    CHIPNAME="rk3399"
elif [[ $(expr $COMPATIBLE : ".*rk3326") -ne 0 ]]; then
    CHIPNAME="rk3326"
elif [[ $(expr $COMPATIBLE : ".*rk3399") -ne 0 ]]; then
    CHIPNAME="rk3399"
elif [[ $(expr $COMPATIBLE : ".*rk3399pro") -ne 0 ]]; then
    CHIPNAME="rk3399pro"
elif [[ $(expr $COMPATIBLE : ".*rk1808") -ne 0 ]]; then
    CHIPNAME="rk1808"
elif [[ $(expr $COMPATIBLE : ".*px3se") -ne 0 ]]; then
    CHIPNAME="px3se"
elif [[ $(expr $COMPATIBLE : ".*px30") -ne 0 ]]; then
    CHIPNAME="px30"
else
    CHIPNAME="rk3399"
fi
COMPATIBLE=${COMPATIBLE#rockchip,}

echo performance | tee $(find /sys/ -name *governor)

echo "run glmark2 wayland with fullscreen......"
export XDG_RUNTIME_DIR=/tmp/.xdg
run_glmark2 ${CHIPNAME}

echo "the governor is performance for now, please restart it........"
