APP_DEMO_SITE = $(TOPDIR)/../app/demo
APP_DEMO_SITE_METHOD = local
APP_DEMO_INSTALL_STAGING = NO

ifeq ($(BR2_PACKAGE_APP_DEMO_IMAGE_PROCESS),y)
APP_DEMO_DEPENDENCIES += gflags libdrm linux-rga ffmpeg sdl2 sdl2_gfx sdl2_ttf
endif

APP_DEMO_CONF_OPTS += "-DCMAKE_BUILD_TYPE=Debug" \
	"-DDOT_GIT_PARENT_DIR=$($(PKG)_SITE)" \
	"-DMODULE_RK_IMAGE_PROCESS_DEMO=$(if $(BR2_PACKAGE_APP_DEMO_IMAGE_PROCESS),ON,OFF)" \
	$(if $(BR2_PACKAGE_APP_DEMO_IMAGE_PROCESS),"-DSDL_GLES2FUNCS_H_DIR=$(SDL2_BUILDDIR)src/render/opengles2")

ifeq ($(BR2_PACKAGE_LIBMALI),y)
APP_DEMO_CONF_OPTS += "-DDRAW_BY_OPENGLES=1"
else
APP_DEMO_CONF_OPTS += "-DDRAW_BY_SDL=1"
APP_DEMO_CONF_OPTS += "-DDRAW_BY_DRM=1"
endif

ifeq ($(BR2_PACKAGE_ROCKX),y)
APP_DEMO_DEPENDENCIES += rockx
APP_DEMO_CONF_OPTS += "-DROCKX=ON" "-DROCKX_HERDER_DIR=$(STAGING_DIR)/usr/include/rockx"
endif

ifeq ($(BR2_PACKAGE_APP_DEMO_NPU_UVC_CONNECTION),y)

APP_DEMO_DEPENDENCIES += rkmedia sdl2 sdl2_gfx sdl2_ttf
APP_DEMO_CONF_OPTS += "-DMODULE_RK_NPU_UVC_DEMO=ON" \
	"-DRKNPU_HEADER_DIR=$(RKNPU_BUILDDIR)/rknn/include"

ifeq ($(BR2_PACKAGE_RK1808),y)
APP_DEMO_DEPENDENCIES += uvc_app camera_engine_rkisp
APP_DEMO_CONF_OPTS += "-DNPU_DEVICE=ON"
else
APP_DEMO_CONF_OPTS += "-DNPU_HOST=ON"
endif

endif

ifeq ($(BR2_PACKAGE_APP_DEMO_RMSL),y)
APP_DEMO_DEPENDENCIES += camera_engine_rkisp linux-rga mpp
APP_DEMO_CONF_OPTS += "-DMODULE_RK_RMSL_DEMO=ON"
endif

$(eval $(cmake-package))
