# Rockchip's DuerOS c++ sdk
# Author : Nyx Zheng <zyh@rock-chips.com>
#          Hertz <wangh@rock-chips.com>

ifeq ($(BR2_PACKAGE_DUERCLIENTSDK),y)

DUERCLIENTSDK_SITE = $(TOPDIR)/../external/DuerClientSDK
DUERCLIENTSDK_SITE_METHOD = local
# DUERCLIENTSDK_INSTALL_STAGING = YES
DUERCLIENTSDK_DEPENDENCIES = wpa_supplicant

DUERCLIENTSDK_BUILD_CONF = $(DUERCLIENTSDK_BUILDDIR)build/build.conf
DUERCLIENTSDK_THIRD_HEADER_PATH = $(DUERCLIENTSDK_BUILDDIR)third/include
DUERCLIENTSDK_THIRD_LIB_PATH = $(DUERCLIENTSDK_BUILDDIR)third/lib
DUERCLIENTSDK_OEM_DIR = $(TOPDIR)/../device/rockchip/rk3308/dueros
DUERCLIENTSDK_OEM_RESOURCE_DIR = $(DUERCLIENTSDK_OEM_DIR)/duer/resources

# /usr
DUERCLIENTSDK_INSTALL_DIR = $(DUERCLIENTSDK_OEM_DIR)/duer
DUERCLIENTSDK_LIBDIR = lib

# Duer DevKit has its special setting,
# keep same with $(DUERCLIENTSDK_BUILDDIR)build.sh.
DUERCLIENTSDK_INSTALL_TARGET_OPTS := DESTDIR= install/fast
define DUERCLIENTSDK_CONFIGURE_CMDS
	(mkdir -p $($(PKG)_BUILDDIR) && \
	cd $($(PKG)_BUILDDIR) && \
	rm -f CMakeCache.txt && \
	PATH=$(BR_PATH); \
	sed -i '/^COMPILER_PATH/d' $(DUERCLIENTSDK_BUILD_CONF); \
	COMPILER_PATH=$(HOST_DIR);\
	source $(DUERCLIENTSDK_BUILD_CONF); \
	$($(PKG)_CONF_ENV) $(BR2_CMAKE) $($(PKG)_SRCDIR) \
		-DBLUEZ5_UTILS=$(if $(BR2_PACKAGE_BLUEZ5_UTILS),ON,OFF) \
		-DCMAKE_INSTALL_PREFIX="$(DUERCLIENTSDK_INSTALL_DIR)" \
		-DCMAKE_COLOR_MAKEFILE=ON \
		-DCMAKE_RULE_MESSAGES=ON \
		-DCMAKE_INSTALL_MESSAGE=LAZY \
		-DCMAKE_INSTALL_RPATH=$(join "'\$$,ORIGIN/lib'") \
		-DCPU_ARCH=$${CPU_ARCH} \
		-DCMAKE_BUILD_TYPE=$${CMAKE_BUILD_TYPE} \
		-DCMAKE_C_COMPILER=$${CMAKE_C_COMPILER} \
		-DCMAKE_CXX_COMPILER=$${CMAKE_CXX_COMPILER} \
		-DCMAKE_C_FLAGS="$${CMAKE_C_FLAGS}" \
		-DCMAKE_CXX_FLAGS="$${CMAKE_CXX_FLAGS}" \
		-DCMAKE_EXE_LINKER_FLAGS="-L$(TARGET_DIR)/usr/lib" \
		-DPlatform=$${Platform} \
		-DPORTAUDIO_LIB_PATH=$(DUERCLIENTSDK_THIRD_LIB_PATH)/libportaudio.so \
		-DPORTAUDIO_INCLUDE_DIR=$(DUERCLIENTSDK_THIRD_HEADER_PATH) \
		-DFFMPEG_LIB_PATH=$(DUERCLIENTSDK_THIRD_LIB_PATH) \
		-DFFMPEG_INCLUDE_DIR=$(DUERCLIENTSDK_THIRD_HEADER_PATH) \
		-DCURL_LIBRARY=$(DUERCLIENTSDK_THIRD_LIB_PATH)/libcurl.so \
		-DCURL_INCLUDE_DIR=$(DUERCLIENTSDK_THIRD_HEADER_PATH) \
		-DSQLITE_LDFLAGS=$(DUERCLIENTSDK_THIRD_LIB_PATH)/libsqlite3.so \
		-DSQLITE_INCLUDE_DIRS=$(DUERCLIENTSDK_THIRD_HEADER_PATH) \
		-DKITTAI_KEY_WORD_DETECTOR=$${KITTAI_KEY_WORD_DETECTOR} \
		-DBUILD_TTS_SDK=$${BUILD_TTS_SDK} \
		-DBUILD_CRAB_SDK=$${BUILD_CRAB_SDK} \
		-DPORTAUDIO=ON \
		-DGSTREAMER_MEDIA_PLAYER=ON \
		-DBUILD_DOC=OFF \
		-DBUILD_TEST=OFF \
		-DBUILD_ONE_LIB=ON \
		-DOUTPUT_FOR_THIRD=ON \
		-DDEBUG_FLAG=$${DEBUG_FLAG} \
		-DDUERLINK_V2=$${DUERLINK_V2} \
		-DBUILD_JEMALLOC=ON \
		-DBDSAI_KEY_WORD_DETECTOR=ON \
		-DBUILD_WITHOUT_SQLITE3=ON \
	)
endef

$(eval $(shell sed -n '/MIC_NUM=/p' $(TOPDIR)/../device/rockchip/.BoardConfig.mk))
ifeq ($(MIC_NUM),)
$(error missing set MIC_NUM in BoardConfig.mk?)
endif

ifeq ($(call qstrip,$(BR2_ARCH)),arm)
DUERCLIENTSDK_OEM_BINARIES_DIR = $(DUERCLIENTSDK_OEM_DIR)/spil/arm32
DUERCLIENTSDK_BUILD_CONF = $(DUERCLIENTSDK_BUILDDIR)build/build32.conf
DUERCLIENTSDK_EXTRA_RESOURCES_DIR = $(DUERCLIENTSDK_BUILDDIR)resources32
DUERCLIENTSDK_THIRD_HEADER_PATH = $(DUERCLIENTSDK_BUILDDIR)third/include32
DUERCLIENTSDK_THIRD_LIB_PATH = $(DUERCLIENTSDK_BUILDDIR)third/lib32
DUERCLIENTSDK_SDK_LIB_PATH = $(DUERCLIENTSDK_BUILDDIR)sdk/lib32
DUERCLIENTSDK_LIBDIR = lib32
endif
ifeq ($(call qstrip,$(BR2_ARCH)),aarch64)
DUERCLIENTSDK_OEM_BINARIES_DIR = $(DUERCLIENTSDK_OEM_DIR)/spil/arm64
DUERCLIENTSDK_BUILD_CONF = $(DUERCLIENTSDK_BUILDDIR)build/build64.conf
DUERCLIENTSDK_EXTRA_RESOURCES_DIR = $(DUERCLIENTSDK_BUILDDIR)resources64
DUERCLIENTSDK_THIRD_HEADER_PATH = $(DUERCLIENTSDK_BUILDDIR)third/include64
DUERCLIENTSDK_THIRD_LIB_PATH = $(DUERCLIENTSDK_BUILDDIR)third/lib64
DUERCLIENTSDK_SDK_LIB_PATH = $(DUERCLIENTSDK_BUILDDIR)sdk/lib64
DUERCLIENTSDK_LIBDIR = lib64
endif

define DUERCLIENTSDK_PRE_BUILD_HOOK1
	install -C $(DUERCLIENTSDK_OEM_BINARIES_DIR)/baidu_spil_rk3308_$(call qstrip,$(MIC_NUM))mic/libbd_alsa_audio_client.so \
	$(DUERCLIENTSDK_SDK_LIB_PATH)
	cd $(DUERCLIENTSDK_INSTALL_DIR); rm -rf lib; mkdir $(DUERCLIENTSDK_LIBDIR); \
	ln -snf $(DUERCLIENTSDK_LIBDIR) lib
endef

DUERCLIENTSDK_PRE_BUILD_HOOKS += DUERCLIENTSDK_PRE_BUILD_HOOK1

strip_files_under = find $(1) -type f -name "*" | xargs -r $(STRIPCMD) $(STRIP_STRIP_ALL) $(if $(Q),2>/dev/null) || true
define DUERCLIENTSDK_POST_INSTALL_TARGET_HOOK1
	mkdir -p $(DUERCLIENTSDK_OEM_RESOURCE_DIR)
	install -C $($(PKG)_BUILDDIR)resources/* $(DUERCLIENTSDK_OEM_RESOURCE_DIR)
	install -C $(DUERCLIENTSDK_EXTRA_RESOURCES_DIR)/* $(DUERCLIENTSDK_OEM_RESOURCE_DIR)
	install -C $(DUERCLIENTSDK_BUILDDIR)sdk/log.config $(DUERCLIENTSDK_INSTALL_DIR)/log.config
	install -C $(DUERCLIENTSDK_BUILDDIR)sdk/duerlinklog.config $(DUERCLIENTSDK_INSTALL_DIR)/duerlinklog.config
	cd $(DUERCLIENTSDK_INSTALL_DIR)/lib; rm -f libbd_alsa_audio_client.so; ln -sf ../../baidu_spil_rk3308/libbd_alsa_audio_client.so .
	$(call strip_files_under,$(DUERCLIENTSDK_INSTALL_DIR))
endef

DUERCLIENTSDK_POST_INSTALL_TARGET_HOOKS += DUERCLIENTSDK_POST_INSTALL_TARGET_HOOK1

$(eval $(cmake-package))
endif


